/*Copyright 2021 Karlsruher Institut für Technologie
    
Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
        
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
        
THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.*/
        
class edMLPlayer_Util{

    // static ultility functions
    static isMultiLineString = false;  //for highlighting

    static getScriptUrl ( name ) {
        let scripts = document.getElementsByTagName('script');
        let src;
        let path;
        let filename;
        for( let i = 0; i < scripts.length; i++){
            src = scripts[i].getAttribute('src');
            if(src != null) {
                path = src.split('/');
                filename = path[path.length-1].split('?')[0];
                
                if(filename == name ) {                    
                   let pos = src.lastIndexOf('/');
                   if(pos == -1) return ""; else return src.substring(0,pos+1);
                }
            } 
        }
        return null;
    }


    static getTimestampNow(){
        var date = new Date();
        return date.getFullYear()+"-"+("0" + (date.getMonth() + 1)).slice(-2)+"-"+("0" + (date.getDate())).slice(-2)+" "+("0" + (date.getHours())).slice(-2)+":"+("0" + (date.getMinutes())).slice(-2)+":"+("0" + (date.getSeconds())).slice(-2);
    }
    
    static sleep(milliseconds) {
        return new Promise((resolve) => setTimeout(resolve, milliseconds));
    }   


    static typesetMathjax(nodes){ 
        let mathjaxstate = edMLPlayer_Config.get("player.mathjax.loaded");
        if(nodes.length > 0){
            if(mathjaxstate == true){
                edMLPlayer_Config.set("player.mathjax.promise",Promise.resolve());  // Used to hold chain of typesetting calls
                edMLPlayer_Config.set("player.mathjax.promise",edMLPlayer_Config.get("player.mathjax.promise").then(() => MathJax.typesetPromise(nodes)).catch((err) => {console.error('Typeset failed: ' + err.message); console.error(nodes);}));
                for(let i = 0; i < nodes.length; i++){
                    nodes[i].classList.add('rendered');
                }
                return edMLPlayer_Config.get("player.mathjax.promise");
            } else if(mathjaxstate == false) {
                edMLPlayer_Util.sleep(100);
                edMLPlayer_Util.typesetMathjax(nodes);
            } else {
                console.error('typeset Mathjax failed: Mathjax not loaded');
            }
        }
    }

    static typesetMath(node){
        if(edMLPlayer_Config.get("player.mathjax.active")){
            if (window.MathJax) {
                if((node instanceof edML_M) && !node.classList.contains('rendered')){                    
                    return edMLPlayer_Util.typesetMathjax([node]);
                } else {
                    if(node != null) return edMLPlayer_Util.typesetMathjax(node.querySelectorAll('edml-m:not(.rendered)'));                    
                }
            }
        }

        if(edMLPlayer_Config.get("player.katex.active") && !edMLPlayer_Config.get("player.mathjax.ative")){
            if(node instanceof edML_M){
                katex.render(node.innerText, node, {
                    throwOnError: false
                });
            } else {

                node.querySelectorAll('edml-m').forEach(function(el){
                    katex.render(el.innerText, el, {
                        throwOnError: false
                    });

                });
                
            }

        }
    }


    static getCaretPosition(element) {
        let position = 0;
        const isSupported = typeof window.getSelection !== "undefined";
        if (isSupported) {
            const selection = window.getSelection();
            if (selection.rangeCount !== 0) {
            const range = window.getSelection().getRangeAt(0);
            const preCaretRange = range.cloneRange();
            preCaretRange.selectNodeContents(element);
            preCaretRange.setEnd(range.endContainer, range.endOffset);
            position = preCaretRange.toString().length;
            }
        }
        return position;
    }

    static setCaretPosition(el,pos) {        
        for(var node of el.childNodes){
            if(node.nodeType == Node.TEXT_NODE){ 
                if(node.length >= pos){
                    var range = document.createRange();
                    let sel = window.getSelection();
                    range.setStart(node,pos);
                    range.collapse(true);
                    sel.removeAllRanges();
                    sel.addRange(range);
                    return -1; 
                }else{
                    pos -= node.length;
                }
            }else{
                pos = this.setCaretPosition(node,pos);
                if(pos == -1){
                    return -1; 
                }
            }
        }
        return pos; 
    }
 
    static isLetter(text) {
        return text.length === 1 && text.match(/[a-zA-Z]/i);
    }

    static formatBoxEnumerator(navitem,box){
        let counter = edMLPlayer_Config.get('box.'+box.nodeName.toLowerCase().replace('edml-','')+'.counter');
        let format = edMLPlayer_Config.get('box.'+box.nodeName.toLowerCase().replace('edml-','')+'.format.enumeration');  
        var output = "";

        if(format == "auto"){
            if(!Array.isArray(counter.value)){
                let value = ++counter.value;
                output = value;
            }
        } else if(format.split("-").length > 2 && format.indexOf("-toc-") > -1){
            var maxtocdepth = parseInt(format.split("-")[2]);
            var type = format.split("-")[0];
            var blabel = navitem.getAttribute('blabel');
            var separr = edMLPlayer_Config.get('box.format.separator');
            if(format.split("-").length > 3) {
                separr = format.replace(type+"-toc-"+maxtocdepth+"-","");
            }
            if(separr.length == 0) separr = ".";
            
            if(!isNaN(maxtocdepth) && maxtocdepth > 0){
                if(!Array.isArray(counter.value)){
                    counter.value = new Array();
                    for(var i = 0; i <= maxtocdepth; i++){
                        counter.value.push(-1);
                    }
                }
                
                blabel = blabel.substring(0,blabel.length-1);
                var split = blabel.split(".");
               
                var n = 0;
                var ct;
                
               
                while(n < split.length && n < maxtocdepth){
                    n++;
                }
                var nmax = n;
                n = 0;

                while(n < split.length && n < maxtocdepth){
                    ct = edMLPlayer_Util.formatFromTocType(type,n,nmax,split[n]);
                    output += ct+separr.substring(0,1);
                   
                    if(counter.value[n] != split[n]) {
                        counter.value[n] = split[n];
                        for(var i = n+1; i <= maxtocdepth;i++) {
                            counter.value[i] = 0;
                        }
                    } 
                    n++;
                }
                    
                counter.value[n]++;
                ct = edMLPlayer_Util.formatFromTocType(type,n,nmax,counter.value[n]);
                output += ct;
                if(separr.length == 2) output += separr.substring(1,2);

                 
                    
                
            } else output = ++counter.value;
        }

       /* var pattern = /(.*?)(\[[alrL]\])/g;
        var match = [...format.matchAll(pattern)];
        var rebuildValue = "";*
        var separator = edMLPlayer_Config.get('navigation.separator');
        var blabel = navitem.getAttribute('blabel');
        var labelarr = blabel.split(separator);
        if(labelarr[labelarr.length-1] == "") labelarr.pop();

        var i = 0;
        while(i < match.length-1 && i < labelarr.length){
            rebuildValue += match[i][0];
            output += match[i][1];

            if(match[i][2] == "[a]"){
                output += labelarr[i];
            } else if(match[i][2] == "[l]"){
                output += edMLPlayer_Util.numberToArr(labelarr[i],edML_Navlist.arrletter);
            }
            i++;
        }
   

        if(match.length > 0){
            output += match[i][1] + value;
        } else output += value;
         */


        
        return output;
    }


    static formatFromTocType(type,depth,maxdepth,value){
        let diff = maxdepth - depth;    

        if(type == "r"){
            value = edMLPlayer_Util.numberToRoman(value,false,true);
        } else if(type == "l"){
            value = edMLPlayer_Util.numberToArr(value,edML_Navlist.arrletter);
        } else if(type == "L"){
            value = edMLPlayer_Util.numberToArr(value,edML_Navlist.arrLetter);
        } else if(type == "g"){
            value = edMLPlayer_Util.numberToArr(value,edML_Navlist.arrgreek);
        } else if(type == "G"){
            value = edMLPlayer_Util.numberToArr(value,edML_Navlist.arrGreek);
        } else if(type == "al"){
            if(diff == 0 && depth > 0){
                value = edMLPlayer_Util.numberToArr(value,edML_Navlist.arrletter);
            }
        } else if(type == "aL"){
            if(diff == 0 && depth > 0){
                value = edMLPlayer_Util.numberToArr(value,edML_Navlist.arrLetter);
            }
        } else if(type == "ag"){
            if(diff == 0 && depth > 0){
                value = edMLPlayer_Util.numberToArr(value,edML_Navlist.arrgreek);
            }
        } else if(type == "aG"){
            if(diff == 0 && depth > 0){
                value = edMLPlayer_Util.numberToArr(value,edML_Navlist.arrGreek);
            }
        } else if(type == "RLa"){
            if(depth == 0){
                value = edMLPlayer_Util.numberToRoman(value,true,true);
            } else if(depth == 1){
                value = edMLPlayer_Util.numberToArr(value,edML_Navlist.arrLetter);
            }
        } else if(type == "alr"){
            if(depth == 2){
                value = edMLPlayer_Util.numberToRoman(value,false,true);
            } else if(depth == 1){
                value = edMLPlayer_Util.numberToArr(value,edML_Navlist.arrLetter);
            }
        }

        return value;
    }

    static numberToArr(nb,arr){

        let div;
        let mod;
        let text = "";
        let i;

        i = 1;
        div = nb - 1;
        do{
            mod = div % Math.pow(arr.length,i);
            div = div - Math.pow(arr.length,i) * mod;
            text = arr[mod] + text;
            i++;                     
        } while(div > 0);

        return text;
    }


    static numberToRoman(number,uppercase,substract){
        let symbols = ["I","V","X","L","C","D","M"];
        let values = [1,5,10,50,100,500,1000];
        let nb;
        let roman = "";

        for(let i = symbols.length-1; i >=0; i--){
            nb = Math.floor(number / values[i]);
            for(let j = 0; j < nb; j++){
                roman = roman + symbols[i];
            }
            number = number % values[i]
        }
        
        if(substract){
            roman = roman.replace('DDDD','DM');
            roman = roman.replace('CCCC','CD');
            roman = roman.replace('LLLL','LC');
            roman = roman.replace('XXXX','XL');
            roman = roman.replace('IIII','IV');
        }

        if(uppercase == false){
            roman = roman.toLowerCase();
        }
        
        return roman;
    }

    static structuredClone(obj){
        if(obj == null){
            return null;
        } else if(structuredClone != null) {            
            return structuredClone(obj);
        }  else  {
            return JSON.parse(JSON.stringify(obj));
        }
    }

    static uniqueArray(arr) {
        var output = arr;
        for(var i = 0; i < output.length; i++) {
            for(var j = i + 1; j < output.length; j++) {
                if(output[i] === output[j]) output.splice(j--, 1);
            }
        }    
        return output;
    };   


    static removeDoubletsFromArray(arr){
        return [...new Set(arr)];
    }


    static getBaselineHeight(el){
        let bottomY = el.getBoundingClientRect().bottom;//viewport pos of bottom of el
        
        let baselineLocator = document.createElement("img"); // needs to be an inline element without a baseline (so its bottom (not baseline) is used for alignment)
        el.appendChild(baselineLocator);
    
        baselineLocator.style.verticalAlign = 'baseline' ; // aligns bottom of baselineLocator with baseline of el
        let baseLineY = baselineLocator.getBoundingClientRect().bottom;//viewport pos of baseline
        el.removeChild(baselineLocator);
            
        return (bottomY - baseLineY) ;        
    }

    static getLineHeight(node, defaultheight){
        if(node.childNodes[0] != null){
            //get range of first line
            var range = document.createRange();
            let i = 0;
            let lineHeight = 0;
            let firstnode = null;
            let found = false;
            do{                               
                          
                
                // search for first occurence of textnode -> get bottom
                if(node.childNodes[i].nodeType == Node.TEXT_NODE && node.childNodes[i].textContent.trim() != "" && lineHeight == 0){
                    if(firstnode == null) firstnode = node.childNodes[i];
                    range.setStart(node.childNodes[i],0);
                    range.setEnd(node.childNodes[i],node.childNodes[i].textContent.length);
                    let topparent = parseFloat(node.getBoundingClientRect().top);
                    let top = parseFloat(range.getBoundingClientRect().top);
                   // console.log(bottom);
                    //console.log(node.closest('edml-p').getBoundingClientRect().top);
                   /* lineHeight = Math.round(range.getBoundingClientRect().bottom - range.getBoundingClientRect().top);
                    if(lineHeight < Math.round(parseFloat(getComputedStyle(node).getPropertyValue('line-height').replace('px','')))){
                        lineHeight = Math.round(parseFloat(getComputedStyle(node).getPropertyValue('line-height').replace('px','')));
                    }
                    lineHeight +=  (range.getBoundingClientRect().top - topparent);*/                    
                    lineHeight =  Math.round(top - topparent);
                    found = true;
                    
                  //  if(lineHeight < defaultheight) lineHeight = defaultheight;
                    
                } else if(node.childNodes[i].nodeType != Node.TEXT_NODE) {
                    if(firstnode == null) firstnode = node.childNodes[i];
                    range.selectNode(node.childNodes[i]);
                }

                

                if((node.childNodes[i].nodeType != Node.TEXT_NODE && (getComputedStyle(node.childNodes[i]).getPropertyValue('display') == "block" || getComputedStyle(node.childNodes[i]).getPropertyValue('display') == "flex")) || (node.childNodes[i].nodeType == Node.TEXT_NODE && node.childNodes[i].textContent.indexOf("\n") > 2 && node.childNodes[i].textContent.trim() != "")) {  //block elemen  or textnode with \n? --> stop propagation                   
                    i = node.childNodes.length+2;
                    
                   
                } 
                if(node.childNodes[i] instanceof edML_Br){
                    i = node.childNodes.length+2;
                }
                i++;
                                    
                
            } while(range.getClientRects().length < 2 && i < node.childNodes.length);

            //no textnode found?
            if(found == false){                
                if(firstnode != null && firstnode.nodeType != Node.TEXT_NODE && parseFloat(getComputedStyle(firstnode).getPropertyValue('line-height').replace('px','')) > lineHeight) {
                    let topparent = parseFloat(node.getBoundingClientRect().top);
                    let top = parseFloat(firstnode.getBoundingClientRect().top);
                    lineHeight = top - topparent +1 * Math.round(firstnode.getBoundingClientRect().height/4);
                }
            }

            /*if(lineHeight < node.clientHeight && i < node.childNodes.length +2) lineHeight =   node.clientHeight - 4;// node is single line

            if(lineHeight == 0 && firstnode != null && firstnode.nodeType != Node.TEXT_NODE && lineHeight < Math.round(parseFloat(firstnode.getBoundingClientRect().height) + firstnode.getBoundingClientRect().top - node.getBoundingClientRect().top)) {
                //lineHeight = parseFloat(getComputedStyle(firstnode).getPropertyValue('height').replace('px',''));
                lineHeight = Math.round(parseFloat(firstnode.getBoundingClientRect().height) + firstnode.getBoundingClientRect().top - node.getBoundingClientRect().top);
            }

            if(firstnode != null && firstnode.nodeType != Node.TEXT_NODE && parseFloat(getComputedStyle(firstnode).getPropertyValue('line-height').replace('px','')) > lineHeight) lineHeight = Math.round(parseFloat(getComputedStyle(firstnode).getPropertyValue('line-height').replace('px','')));

            if(lineHeight == 0) lineHeight = Math.round(parseFloat(getComputedStyle(node).getPropertyValue('line-height').replace('px','')));*/
            //console.log("Ergebnis für:");
            //console.log(node);
            //console.log(lineHeight);
            return lineHeight;
        }
        
    }


    static formatJava(text){
        var keyword = "new super assert open to with void".split(" ");
        var definitionKeyword = "class interface extends implements enum var".split(" "); 
        var moduleKeyword = "module package import".split(" ");
        var controlKeyword = "switch while for if else case default do break continue return try catch finally throw".split(" ");
        var modifierKeyword = "requires exports opens uses provides public private protected static transitive abstract final strictfp synchronized native transient volatile throws".split(" ");

        var datatypeKeyword = "byte short int long float double boolean char String".split(" ");
  

        //Strings must be first
          //lookbehind -> error on Safari browsers
        //text = text.replaceAll(/(?<!\\)"(.*?)(?<!\\)"/gm ,'<span keywordtype="stringkeyword">"$1"</span>');

        //Multiline Strings
        
        if(text.indexOf('<span keywordtype="stringkeyword">""<\/span>"') > -1){
            text = text.replaceAll(/<span keywordtype="stringkeyword">""<\/span>"/gm,'<span keywordtype="stringkeyword">"""</span>');
            edMLPlayer_Util.isMultiLineString = !edMLPlayer_Util.isMultiLineString;
        } else if(edMLPlayer_Util.isMultiLineString){
            text = '<span keywordtype="stringkeyword">'+text+'</span>';
        }
        
        
        //definition keywords 
        for(var i = 0; i < definitionKeyword.length; i++){
            var regex = new RegExp(String.raw`([^a-zA-Z0-9]|^)(${definitionKeyword[i]})([^a-zA-Z0-9]|$)`, "g");
            text = text.replaceAll(regex ,'$1<span keywordtype="definitionkeyword">$2</span>$3');
        }
        
        //definition keywords followed by  name 
        text = text.replaceAll(/(\<span keywordtype="definitionkeyword"\>.*?<\/span>) ([a-zA-Z][a-zA-Z0-9]*)/gm ,'$1 <span keywordtype="definitionname">$2</span>');
    
        
        //keywords
        for(var i = 0; i < keyword.length; i++){
            var regex = new RegExp(String.raw`([^a-zA-Z0-9]|^)(${keyword[i]})([^a-zA-Z0-9]|$)`, "g");
            text = text.replaceAll(regex ,'$1<span keywordtype="keyword">$2</span>$3');
        }

        
        //module keywords
        for(var i = 0; i < moduleKeyword.length; i++){
            var regex = new RegExp(String.raw`([^a-zA-Z0-9]|^)(${moduleKeyword[i]})([^a-zA-Z0-9]|$)`, "g");
            text = text.replaceAll(regex ,'<span keywordtype="modulekeyword">$1$2</span>$3');
        }

        //control keywords
        for(var i = 0; i < controlKeyword.length; i++){
            var regex = new RegExp(String.raw`([^a-zA-Z0-9]|^)(${controlKeyword[i]})([^a-zA-Z0-9]|$)`, "g");
            text = text.replaceAll(regex ,'$1<span keywordtype="controlkeyword">$2</span>$3');
        }

        
        //modifier keywords
        for(var i = 0; i < modifierKeyword.length; i++){
            var regex = new RegExp(String.raw`([^a-zA-Z0-9]|^)(${modifierKeyword[i]})([^a-zA-Z0-9]|$)`, "g");
            text = text.replaceAll(regex ,'$1<span keywordtype="modifierkeyword">$2</span>$3');
        }

        //datatype keywords
        for(var i = 0; i < datatypeKeyword.length; i++){
            var regex = new RegExp(String.raw`([^a-zA-Z0-9]|^)(${datatypeKeyword[i]})([^a-zA-Z0-9$]|$)`, "g");
            text = text.replaceAll(regex ,'$1<span keywordtype="datatypekeyword">$2</span>$3');
        }

        return text;
    }

    static addLeadingZeros(val,len){
        var output = ""+val;
        for(var i = len-1; i > 0; i-- ){
            if(val / Math.pow(10,i) < 1){
                output = "0"+output;
            }
        }
        return output;
    }

  
  /*  static getLineHeight(node){
        //calculate height
        console.log("Calculate");
        if(node.childNodes[0] != null){
            //get range of first line
            var range = document.createRange();
            let i = 0;
            let lineHeight = parseFloat(getComputedStyle(node).getPropertyValue('line-height').replace('px',''));
            
            do{                               

                range.selectNode(node.childNodes[i]);
                if(node.childNodes[i].nodeType == Node.TEXT_NODE){
                    range.setStart(node.childNodes[i],0);
                    range.setEnd(node.childNodes[i],node.childNodes[i].textContent.length);
                }
                if((node.childNodes[i].nodeType != Node.TEXT_NODE && (getComputedStyle(node.childNodes[i]).getPropertyValue('display') == "block" || getComputedStyle(node.childNodes[i]).getPropertyValue('display') == "flex")) || (node.childNodes[i].nodeType == Node.TEXT_NODE && node.childNodes[i].textContent.indexOf("\n") > 2)) {  //block elemen  or textnode with \n? --> stop propagation                   
                    i = node.childNodes.length;
                    if(lineHeight == 0 && lineHeight < range.getBoundingClientRect().height) lineHeight = range.getBoundingClientRect().height;
                   
                } else {
                    if(range.getClientRects().length < 2) {
                        if(lineHeight < range.getBoundingClientRect().height) lineHeight = range.getBoundingClientRect().height; 
                        //if(node.childNodes[i].nodeType != Node.TEXT_NODE && lineHeight < parseFloat(getComputedStyle(node.childNodes[i]).getPropertyValue('height').replace("px",""))) lineHeight = parseFloat(getComputedStyle(node.childNodes[i]).getPropertyValue('height').replace("px",""))
                    }
                    if(range.getClientRects().length > 1 && range.getClientRects()[0].height > lineHeight) lineHeight = range.getClientRects()[0].height;                     
                    if(range.getClientRects().length == 1) i++;       
                }
                                    
                
            } while(range.getClientRects().length == 1 && i < node.childNodes.length);
            return lineHeight;
        }
        return null;
        
    }*/

    static replaceVariables(match){
        var result = match;
        match = match.substring(2,match.length-1);
        var s = match.indexOf(".")
        var name = match.substring(0,s);
        var proppart = match.substring(s+1);
        s = proppart.indexOf('.');
        if(s == -1) s = proppart.length;
        var prop = proppart.substring(0,s);

        var el = null;        
        if(document.querySelector('edml-variant.active') != null) el = document.querySelector('edml-variant.active').querySelector('edml-input[name="'+name+'"],edml-inputblock[name="'+name+'"],edml-booleangroup[name="'+name+'"]');   
        if(el != null){
            var obj = el.getStateObject();
            if(obj != null){
                result = obj[prop];
            }
        }
        
        

        if(prop == "type" || prop == "closure" || prop == "unit" || (prop == "value" && obj.valuemode == "string") ) this.mode = "string";
        
        return result;
    }    


    static getPrimeSet(number){
        var arr = null;
        if(Number.isInteger(number)){
            arr = new Array();
            var help = number;
            var found;
            var i;
            var p;
            while(help > 1) {
                i = 2;
                found = false;
                while(i*i <= help && !found) {
                    if(help % i == 0) {
                        found = true;
                        p = i;
                    } else {
                        i++;
                    }
                }
                if(!found) p = help;
                if(arr.indexOf(p) == -1) arr.push(p);            
                help = help / p
            }
        } 

        return arr;


    }

    static getDecimalSeparator(val){
        
        if(val == "auto") {
            var lang = edMLPlayer_Config.get("course.lang"); 

            if(lang == "de") {
                return ",";
            } else {
                return ".";
            }
        } else return val;
    }


}
class edMLPlayer_Config{
    //provides confiugaration values


    static config = null;


    static create(){
        if(edMLPlayer_Config.config == null){
            edMLPlayer_Config.config = new Object();

                                     
            

            //player
            edMLPlayer_Config.config.player = new Object();
            edMLPlayer_Config.config.player.version = "(early access)";                            
            edMLPlayer_Config.config.player.edmlversion = "0.5.0";                            
            edMLPlayer_Config.config.player.path = edMLPlayer_Util.getScriptUrl('edmlplayer.min.js');                         
            if(edMLPlayer_Config.config.player.path == null) edMLPlayer_Config.config.player.path = edMLPlayer_Util.getScriptUrl('edmlplayer.compress.js'); 
            if(edMLPlayer_Config.config.player.path == null) edMLPlayer_Config.config.player.path = edMLPlayer_Config.config.player.path = edMLPlayer_Util.getScriptUrl('edmlplayer.js');
            //console.log(edMLPlayer_Config.config.player.path);

            edMLPlayer_Config.config.player.file = null;   
            edMLPlayer_Config.config.player.isZip = false; 
            edMLPlayer_Config.config.player.ressourcepath = "";
            edMLPlayer_Config.config.player.lang = "de";             
            edMLPlayer_Config.config.player.depractedconversion = true;
            edMLPlayer_Config.config.player.forceshuffleOff = false;
            edMLPlayer_Config.config.player.defaultfontsize = 16;
            edMLPlayer_Config.config.player.fontsize = edMLPlayer_Config.config.player.defaultfontsize;
            edMLPlayer_Config.config.player.accessenabled = false;
            edMLPlayer_Config.config.player.printable = "none"; //none, page, entire
            edMLPlayer_Config.config.player.poolviewenabled = true; // false = everything in the poolview will be displayed; no random order
           // edMLPlayer_Config.config.player.scormenabled = false;
           // edMLPlayer_Config.config.player.scormjournaling = true;
           // edMLPlayer_Config.config.player.scormversion = 4; //0 = default --> 4; 1 = 1.1, 2 = 1.2, 3 = 2004 2nd, 4 = 2004 3rd
           // edMLPlayer_Config.config.player.scormonlytest = false; 
            edMLPlayer_Config.config.player.inputcounter = 0; //will be increased by inputs, inputblocks, intputgroups
            edMLPlayer_Config.config.player.breadcrumb = true; // true, false, "always"
            edMLPlayer_Config.config.player.preventcopy = true; 
            edMLPlayer_Config.config.player.showhelp = true; 
            edMLPlayer_Config.config.player.reveal = 1; 
            edMLPlayer_Config.config.player.arrowbar = null; 
            edMLPlayer_Config.config.player.displaystyle = true;
            edMLPlayer_Config.config.player.displayerror = "all";  //all, none, console

                //IndexedDB
            edMLPlayer_Config.config.player.indexeddb = new Object();  
            edMLPlayer_Config.config.player.indexeddb.enabled = false;  
            edMLPlayer_Config.config.player.indexeddb.version = 1;
            edMLPlayer_Config.config.player.indexeddb.name = "edmlplayerdb";
            edMLPlayer_Config.config.player.indexeddb.testonly = false;   
            edMLPlayer_Config.config.player.indexeddb.showhint = false;   
            edMLPlayer_Config.config.player.indexeddb.showdialogentry = false;  
            edMLPlayer_Config.config.player.indexeddb.showdeletebtn = false;               



            

                //SCORM
            edMLPlayer_Config.config.player.scorm = new Object();    
            edMLPlayer_Config.config.player.scorm.enabled = false;    
            edMLPlayer_Config.config.player.scorm.journaling = true;    
            edMLPlayer_Config.config.player.scorm.version = 4; //1 = 1.1, 2 = 1.2, 3 = 2004 2nd, 4 = 2004 3rd
            edMLPlayer_Config.config.player.scorm.testonly = false;


                //render
            edMLPlayer_Config.config.player.render = new Object();    
            edMLPlayer_Config.config.player.render.picture = true; 
            edMLPlayer_Config.config.player.render.video = true;   
            edMLPlayer_Config.config.player.render.maxwidth = 800;
            edMLPlayer_Config.config.player.render.maxheight = 0.3 * document.documentElement.clientHeight;
            edMLPlayer_Config.config.player.render.maxheightvh = 30;
            edMLPlayer_Config.config.player.render.fallbackwidth = 300;  
            edMLPlayer_Config.config.player.render.fallbackheight = 300;

               
               

       
                //aes
            edMLPlayer_Config.config.player.aes = new Object();
            edMLPlayer_Config.config.player.aes.loaded = false;
            edMLPlayer_Config.config.player.aes.file = "aesjs.js";    
            edMLPlayer_Config.config.player.aes.path = edMLPlayer_Config.config.player.path + "extern/aesjs/";
            if(edMLPlayer_Util.getScriptUrl(edMLPlayer_Config.config.player.aes.file) != null) edMLPlayer_Config.config.player.aes.loaded = true;

                //zip
            edMLPlayer_Config.config.player.zip = new Object();
            edMLPlayer_Config.config.player.zip.loaded = false;
            edMLPlayer_Config.config.player.zip.file = "jszip.min.js";    
            edMLPlayer_Config.config.player.zip.path = edMLPlayer_Config.config.player.path + "extern/jszip/dist/";
            if(edMLPlayer_Util.getScriptUrl(edMLPlayer_Config.config.player.zip.file) != null) edMLPlayer_Config.config.player.zip.loaded = true;

                //codemirror
            edMLPlayer_Config.config.player.codemirror = new Object();
            edMLPlayer_Config.config.player.codemirror.active = false;
            edMLPlayer_Config.config.player.codemirror.promise = null;
            edMLPlayer_Config.config.player.codemirror.loaded = false;
            edMLPlayer_Config.config.player.codemirror.file = "codemirror.js";       
            edMLPlayer_Config.config.player.codemirror.path = edMLPlayer_Config.config.player.path + "extern/codemirror/";  
            if(edMLPlayer_Util.getScriptUrl(edMLPlayer_Config.config.player.codemirror.file) != null) edMLPlayer_Config.config.player.codemirror.loaded = true;
            
                //nerdamer
            edMLPlayer_Config.config.player.nerdamer = new Object();
            edMLPlayer_Config.config.player.nerdamer.active = true;
            edMLPlayer_Config.config.player.nerdamer.promise = null;
            edMLPlayer_Config.config.player.nerdamer.loaded = false;
            edMLPlayer_Config.config.player.nerdamer.evalmode = "normal";  //normal: working as nerdamer; strict: *-, /+, +* etc. not allowed
            edMLPlayer_Config.config.player.nerdamer.file = "all.min.js";    
            edMLPlayer_Config.config.player.nerdamer.path = edMLPlayer_Config.config.player.path + "extern/nerdamer/";    
            if(edMLPlayer_Util.getScriptUrl(edMLPlayer_Config.config.player.nerdamer.file) != null) edMLPlayer_Config.config.player.nerdamer.loaded = true;

                //mathjax
            edMLPlayer_Config.config.player.mathjax = new Object();
            edMLPlayer_Config.config.player.mathjax.active = true;
            edMLPlayer_Config.config.player.mathjax.promise = null;            
            edMLPlayer_Config.config.player.mathjax.loaded = false;  //false, true, failed
            edMLPlayer_Config.config.player.mathjax.diffoperatormacro = true;
            edMLPlayer_Config.config.player.mathjax.svg = false;            
            //edMLPlayer_Config.config.player.mathjax.file = "tex-chtml.js";            
            edMLPlayer_Config.config.player.mathjax.file = "mathjax.min.js";            
           // edMLPlayer_Config.config.player.mathjax.path = edMLPlayer_Config.config.player.path + "extern/mathjax2/es5/";     
            edMLPlayer_Config.config.player.mathjax.path = edMLPlayer_Config.config.player.path + "extern/mathjax/";     
            if(edMLPlayer_Util.getScriptUrl(edMLPlayer_Config.config.player.mathjax.file) != null) edMLPlayer_Config.config.player.mathjax.loaded = true;


            //PLUGINS
            edMLPlayer_Config.config.plugins = new Object();
                //Geogebra
            edMLPlayer_Config.config.plugins.geogebra = new Object();
            edMLPlayer_Config.config.plugins.geogebra.path = edMLPlayer_Config.config.player.path + "plugins/geogebra";
            edMLPlayer_Config.config.plugins.geogebra.file = "geogebra_edmlplugin.js?V0.02";
            edMLPlayer_Config.config.plugins.geogebra.loaded = false;
            edMLPlayer_Config.config.plugins.geogebra.promise = false;
            edMLPlayer_Config.config.plugins.geogebra.active = false;
            edMLPlayer_Config.config.plugins.geogebra.local = true;

                //PSE
            edMLPlayer_Config.config.plugins.pse = new Object();
            edMLPlayer_Config.config.plugins.pse.path = edMLPlayer_Config.config.player.path + "plugins/pse";
            edMLPlayer_Config.config.plugins.pse.file = "pse_edmlplugin.js";
            edMLPlayer_Config.config.plugins.pse.loaded = false;
            edMLPlayer_Config.config.plugins.pse.promise = false;
            edMLPlayer_Config.config.plugins.pse.active = false;

                //3Dmol
            edMLPlayer_Config.config.plugins.threedmol = new Object();
            edMLPlayer_Config.config.plugins.threedmol.path = edMLPlayer_Config.config.player.path + "plugins/3Dmol";
            edMLPlayer_Config.config.plugins.threedmol.file = "3Dmol_edmlplugin.js";
            edMLPlayer_Config.config.plugins.threedmol.loaded = false;
            edMLPlayer_Config.config.plugins.threedmol.promise = false;
            edMLPlayer_Config.config.plugins.threedmol.active = false;
            edMLPlayer_Config.config.plugins.threedmol.local = true;


                //TikZ
            edMLPlayer_Config.config.plugins.tikz = new Object();
            edMLPlayer_Config.config.plugins.tikz.path = edMLPlayer_Config.config.player.path + "plugins/tikz";
            edMLPlayer_Config.config.plugins.tikz.file = "tikz_edmlplugin.js";
            edMLPlayer_Config.config.plugins.tikz.jsfile = "tikzjax.js";
            edMLPlayer_Config.config.plugins.tikz.cssfile = "fonts.css";
            edMLPlayer_Config.config.plugins.tikz.loaded = false;
            edMLPlayer_Config.config.plugins.tikz.promise = false;
            edMLPlayer_Config.config.plugins.tikz.active = false;
            edMLPlayer_Config.config.plugins.tikz.local = true;

               //JSXGraph
            edMLPlayer_Config.config.plugins.jsxgraph = new Object();
            edMLPlayer_Config.config.plugins.jsxgraph.path = edMLPlayer_Config.config.player.path + "plugins/JSXGraph";
            edMLPlayer_Config.config.plugins.jsxgraph.file = "jsxgraph_edmlplugin.js";
            edMLPlayer_Config.config.plugins.jsxgraph.jsfile = "jsxgraphcore.js";
            edMLPlayer_Config.config.plugins.jsxgraph.cssfile = "jsxgraph.css";
            edMLPlayer_Config.config.plugins.jsxgraph.loaded = false;
            edMLPlayer_Config.config.plugins.jsxgraph.promise = false;
            edMLPlayer_Config.config.plugins.jsxgraph.active = false;
            edMLPlayer_Config.config.plugins.jsxgraph.local = true;


                //Subnavigation
            edMLPlayer_Config.config.plugins.subnavigation = new Object();          
            edMLPlayer_Config.config.plugins.subnavigation.path = edMLPlayer_Config.config.player.path + "plugins/subnavigation";  
            edMLPlayer_Config.config.plugins.subnavigation.file = "subnavigation_edmlplugin.js?V0.02";
            edMLPlayer_Config.config.plugins.subnavigation.active = false;


                     
                //katex
         /*   edMLPlayer_Config.config.player.katex = new Object();
            edMLPlayer_Config.config.player.katex.active = false;
            edMLPlayer_Config.config.player.katex.promise = null;
            edMLPlayer_Config.config.player.katex.loaded = false;
            edMLPlayer_Config.config.player.katex.file = "katex.min.js";    
            edMLPlayer_Config.config.player.katex.path = edMLPlayer_Config.config.player.path + "extern/katex/";
            if(edMLPlayer_Util.getScriptUrl(edMLPlayer_Config.config.player.katex.file) != null) edMLPlayer_Config.config.player.katex.loaded = true;*/

            //edML-Tags

            //externmedia
            edMLPlayer_Config.config.externmedia = new Object();
            edMLPlayer_Config.config.externmedia.autoload = true;
            edMLPlayer_Config.config.externmedia.appearance = "normal";  // normal, link

            //figureblock
            edMLPlayer_Config.config.figureblock = new Object();
            edMLPlayer_Config.config.figureblock.numbered = true;    

            //course 
            edMLPlayer_Config.config.course = new Object();
            edMLPlayer_Config.config.course.defaultlang = "de";  
            edMLPlayer_Config.config.course.lang = "de";           
            edMLPlayer_Config.config.course.decimalseparator = ",";  
            edMLPlayer_Config.config.course.decimalseparator = "auto";             
            edMLPlayer_Config.config.course.name = "MyEdmlCourse";    
            
            //solutionhint
            edMLPlayer_Config.config.solutionhint = new Object();
            edMLPlayer_Config.config.solutionhint.mode = "sequence";             
            edMLPlayer_Config.config.solutionhint.appendback = true; 
            
            

            //access
            edMLPlayer_Config.config.access = new Object();
            edMLPlayer_Config.config.access.level = 1;   // 1: normal user, 2: blind user, 3: visual impaired
            if(window.location.search.indexOf("access=") > -1){
                let access = window.location.search.split("access=");
                access = parseInt(access[1].split("&")[0]);
                if(!isNaN(access)) edMLPlayer_Config.config.access.level = access;
            }


            //list
            edMLPlayer_Config.config.list = new Object();
            edMLPlayer_Config.config.list.format = "decimal";            
            edMLPlayer_Config.config.list.separator = ".";
            edMLPlayer_Config.config.list.lastsep = true;
            edMLPlayer_Config.config.list.fullnumbering = false;
            

            //test
            edMLPlayer_Config.config.test = new Object();
            edMLPlayer_Config.config.test.feedback = 'detailed';
            edMLPlayer_Config.config.test.maxattempts = Infinity;
            edMLPlayer_Config.config.test.navigation = "full";
            edMLPlayer_Config.config.test.showformerresults = false;  // if results saved to scorm, show on test start page the old results -> be careful for rolled parameters
            edMLPlayer_Config.config.test.solutionhintopened = false; // on feedback page: should all solutionhints be opened?

            //navigation
            edMLPlayer_Config.config.navigation = new Object();
            edMLPlayer_Config.config.navigation.static = false;
            edMLPlayer_Config.config.navigation.editmode = false;
            edMLPlayer_Config.config.navigation.depth = 1;            //limit of navigation depth that will be shown open by default
            edMLPlayer_Config.config.navigation.format = "decimal";  //decimal, roman, letter ...
            edMLPlayer_Config.config.navigation.separator = ".";
            edMLPlayer_Config.config.navigation.lastsep = true;
            edMLPlayer_Config.config.navigation.additionalitems = new Array();
            edMLPlayer_Config.config.navigation.shortenlearnpath = true;
            edMLPlayer_Config.config.navigation.staticarrowstest = false;
            edMLPlayer_Config.config.navigation.staticarrows = false;

            //titlebar
            edMLPlayer_Config.config.titlebar = new Object();
            edMLPlayer_Config.config.titlebar.visible = true;

            //footer
            edMLPlayer_Config.config.footer = new Object();
            edMLPlayer_Config.config.footer.visible = true;
            

            //score
            edMLPlayer_Config.config.score = new Object();
            edMLPlayer_Config.config.score.visible = true;

            //poolview
            edMLPlayer_Config.config.poolview = new Object();
            edMLPlayer_Config.config.poolview.refreshbutton = false;
            edMLPlayer_Config.config.poolview.shuffle = true;
            edMLPlayer_Config.config.poolview.amount = 1;

            //clonecontainer
            edMLPlayer_Config.config.clonecontainer = new Object();
            edMLPlayer_Config.config.clonecontainer.mode = "shallow"; //shallow | deep | forcenone: that's for edmleditor

            //BOXES 
            edMLPlayer_Config.config.box = new Object();
            edMLPlayer_Config.config.box.sharedcounter = true;
                //format and counter value changes are copied in set-function
            edMLPlayer_Config.config.box.format = new Object();
            edMLPlayer_Config.config.box.format.separator = ".";  // default, could be overriden per format.enumeration
            edMLPlayer_Config.config.box.format.enumeration = "a-toc-0"; // a-toc-0            
            edMLPlayer_Config.config.box.format.title = "des"; // des
            edMLPlayer_Config.config.box.format.subtitleleft = "(";
            edMLPlayer_Config.config.box.format.subtitleright = ")";
            edMLPlayer_Config.config.box.format.difficulty = "prepend"; //prepend, append
            edMLPlayer_Config.config.box.counter = new Object();
            edMLPlayer_Config.config.box.counter.value = 0;
            

             //applicationbox
             edMLPlayer_Config.config.box.applicationbox = new Object();
             edMLPlayer_Config.config.box.applicationbox.counter = edMLPlayer_Config.config.box.counter;
             edMLPlayer_Config.config.box.applicationbox.numbered = true;
             edMLPlayer_Config.config.box.applicationbox.format = new Object();
             edMLPlayer_Config.config.box.applicationbox.format.enumeration = edMLPlayer_Config.config.box.format.enumeration;
             edMLPlayer_Config.config.box.applicationbox.format.title = edMLPlayer_Config.config.box.format.title;
             edMLPlayer_Config.config.box.applicationbox.format.subtitleleft = edMLPlayer_Config.config.box.format.subtitleleft;
             edMLPlayer_Config.config.box.applicationbox.format.subtitleright = edMLPlayer_Config.config.box.format.subtitleright;

            //conventionbox
            edMLPlayer_Config.config.box.conventionbox = new Object();
            edMLPlayer_Config.config.box.conventionbox.counter = edMLPlayer_Config.config.box.counter;
            edMLPlayer_Config.config.box.conventionbox.numbered = true;
            edMLPlayer_Config.config.box.conventionbox.format = new Object();
            edMLPlayer_Config.config.box.conventionbox.format.enumeration = edMLPlayer_Config.config.box.format.enumeration;
            edMLPlayer_Config.config.box.conventionbox.format.title = edMLPlayer_Config.config.box.format.title;
            edMLPlayer_Config.config.box.conventionbox.format.subtitleleft = edMLPlayer_Config.config.box.format.subtitleleft;
            edMLPlayer_Config.config.box.conventionbox.format.subtitleright = edMLPlayer_Config.config.box.format.subtitleright;


            //definitionbox
            edMLPlayer_Config.config.box.definitionbox = new Object();
            edMLPlayer_Config.config.box.definitionbox.counter = edMLPlayer_Config.config.box.counter;
            edMLPlayer_Config.config.box.definitionbox.numbered = true;
            edMLPlayer_Config.config.box.definitionbox.format = new Object();
            edMLPlayer_Config.config.box.definitionbox.format.enumeration = edMLPlayer_Config.config.box.format.enumeration;
            edMLPlayer_Config.config.box.definitionbox.format.title = edMLPlayer_Config.config.box.format.title;
            edMLPlayer_Config.config.box.definitionbox.format.subtitleleft = edMLPlayer_Config.config.box.format.subtitleleft;
            edMLPlayer_Config.config.box.definitionbox.format.subtitleright = edMLPlayer_Config.config.box.format.subtitleright;

            //examplebox
            edMLPlayer_Config.config.box.examplebox = new Object();
            edMLPlayer_Config.config.box.examplebox.counter = edMLPlayer_Config.config.box.counter;
            edMLPlayer_Config.config.box.examplebox.numbered = true;
            edMLPlayer_Config.config.box.examplebox.format = new Object();
            edMLPlayer_Config.config.box.examplebox.format.enumeration = edMLPlayer_Config.config.box.format.enumeration;
            edMLPlayer_Config.config.box.examplebox.format.title = edMLPlayer_Config.config.box.format.title;
            edMLPlayer_Config.config.box.examplebox.format.subtitleleft = edMLPlayer_Config.config.box.format.subtitleleft;
            edMLPlayer_Config.config.box.examplebox.format.subtitleright = edMLPlayer_Config.config.box.format.subtitleright;
            edMLPlayer_Config.config.box.examplebox.format.difficulty = edMLPlayer_Config.config.box.format.difficulty;

            

            //exercisebox
            edMLPlayer_Config.config.box.exercisebox = new Object();
            edMLPlayer_Config.config.box.exercisebox.counter = edMLPlayer_Config.config.box.counter;
            edMLPlayer_Config.config.box.exercisebox.numbered = true;
            edMLPlayer_Config.config.box.exercisebox.format = new Object();
            edMLPlayer_Config.config.box.exercisebox.format.enumeration = edMLPlayer_Config.config.box.format.enumeration;
            edMLPlayer_Config.config.box.exercisebox.format.title = edMLPlayer_Config.config.box.format.title;
            edMLPlayer_Config.config.box.exercisebox.format.subtitleleft = edMLPlayer_Config.config.box.format.subtitleleft;
            edMLPlayer_Config.config.box.exercisebox.format.subtitleright = edMLPlayer_Config.config.box.format.subtitleright;
            edMLPlayer_Config.config.box.exercisebox.format.difficulty = edMLPlayer_Config.config.box.format.difficulty;


            //formulabox
            edMLPlayer_Config.config.box.formulabox = new Object();
            edMLPlayer_Config.config.box.formulabox.counter = edMLPlayer_Config.config.box.counter;
            edMLPlayer_Config.config.box.formulabox.numbered = true;
            edMLPlayer_Config.config.box.formulabox.format = new Object();
            edMLPlayer_Config.config.box.formulabox.format.enumeration = edMLPlayer_Config.config.box.format.enumeration;
            edMLPlayer_Config.config.box.formulabox.format.title = edMLPlayer_Config.config.box.format.title;
            edMLPlayer_Config.config.box.formulabox.format.subtitleleft = edMLPlayer_Config.config.box.format.subtitleleft;
            edMLPlayer_Config.config.box.formulabox.format.subtitleright = edMLPlayer_Config.config.box.format.subtitleright;


            //helpbox
            edMLPlayer_Config.config.box.helpbox = new Object();
            edMLPlayer_Config.config.box.helpbox.counter = edMLPlayer_Config.config.box.counter;
            edMLPlayer_Config.config.box.helpbox.numbered = true;
            edMLPlayer_Config.config.box.helpbox.format = new Object();
            edMLPlayer_Config.config.box.helpbox.format.enumeration = edMLPlayer_Config.config.box.format.enumeration;
            edMLPlayer_Config.config.box.helpbox.format.title = edMLPlayer_Config.config.box.format.title;
            edMLPlayer_Config.config.box.helpbox.format.subtitleleft = edMLPlayer_Config.config.box.format.subtitleleft;
            edMLPlayer_Config.config.box.helpbox.format.subtitleright = edMLPlayer_Config.config.box.format.subtitleright;


            //hintbox
            edMLPlayer_Config.config.box.hintbox = new Object();
            edMLPlayer_Config.config.box.hintbox.counter = edMLPlayer_Config.config.box.counter;
            edMLPlayer_Config.config.box.hintbox.numbered = true;
            edMLPlayer_Config.config.box.hintbox.format = new Object();
            edMLPlayer_Config.config.box.hintbox.format.enumeration = edMLPlayer_Config.config.box.format.enumeration;
            edMLPlayer_Config.config.box.hintbox.format.title = edMLPlayer_Config.config.box.format.title;
            edMLPlayer_Config.config.box.hintbox.format.subtitleleft = edMLPlayer_Config.config.box.format.subtitleleft;
            edMLPlayer_Config.config.box.hintbox.format.subtitleright = edMLPlayer_Config.config.box.format.subtitleright;

            //infobox
            edMLPlayer_Config.config.box.infobox = new Object();
            edMLPlayer_Config.config.box.infobox.counter = edMLPlayer_Config.config.box.counter;
            edMLPlayer_Config.config.box.infobox.numbered = true;
            edMLPlayer_Config.config.box.infobox.format = new Object();
            edMLPlayer_Config.config.box.infobox.format.enumeration = edMLPlayer_Config.config.box.format.enumeration;
            edMLPlayer_Config.config.box.infobox.format.title = edMLPlayer_Config.config.box.format.title;
            edMLPlayer_Config.config.box.infobox.format.subtitleleft = edMLPlayer_Config.config.box.format.subtitleleft;
            edMLPlayer_Config.config.box.infobox.format.subtitleright = edMLPlayer_Config.config.box.format.subtitleright;


            //proofbox
            edMLPlayer_Config.config.box.proofbox = new Object();
            edMLPlayer_Config.config.box.proofbox.counter = edMLPlayer_Config.config.box.counter;
            edMLPlayer_Config.config.box.proofbox.numbered = true;
            edMLPlayer_Config.config.box.proofbox.format = new Object();
            edMLPlayer_Config.config.box.proofbox.format.enumeration = edMLPlayer_Config.config.box.format.enumeration;
            edMLPlayer_Config.config.box.proofbox.format.title = edMLPlayer_Config.config.box.format.title;
            edMLPlayer_Config.config.box.proofbox.format.subtitleleft = edMLPlayer_Config.config.box.format.subtitleleft;
            edMLPlayer_Config.config.box.proofbox.format.subtitleright = edMLPlayer_Config.config.box.format.subtitleright;

            //remarkbox
            edMLPlayer_Config.config.box.remarkbox = new Object();
            edMLPlayer_Config.config.box.remarkbox.counter = edMLPlayer_Config.config.box.counter;
            edMLPlayer_Config.config.box.remarkbox.numbered = true;
            edMLPlayer_Config.config.box.remarkbox.format = new Object();
            edMLPlayer_Config.config.box.remarkbox.format.enumeration = edMLPlayer_Config.config.box.format.enumeration;
            edMLPlayer_Config.config.box.remarkbox.format.title = edMLPlayer_Config.config.box.format.title;
            edMLPlayer_Config.config.box.remarkbox.format.subtitleleft = edMLPlayer_Config.config.box.format.subtitleleft;
            edMLPlayer_Config.config.box.remarkbox.format.subtitleright = edMLPlayer_Config.config.box.format.subtitleright;

            //textbox
            edMLPlayer_Config.config.box.textbox = new Object();
            edMLPlayer_Config.config.box.textbox.counter = edMLPlayer_Config.config.box.counter;
            edMLPlayer_Config.config.box.textbox.numbered = false;
            edMLPlayer_Config.config.box.textbox.format = new Object();
            edMLPlayer_Config.config.box.textbox.format.enumeration = edMLPlayer_Config.config.box.format.enumeration;
            edMLPlayer_Config.config.box.textbox.format.title = edMLPlayer_Config.config.box.format.title;
            edMLPlayer_Config.config.box.textbox.format.subtitleleft = edMLPlayer_Config.config.box.format.subtitleleft;
            edMLPlayer_Config.config.box.textbox.format.subtitleright = edMLPlayer_Config.config.box.format.subtitleright;


            //theorembox
            edMLPlayer_Config.config.box.theorembox = new Object();
            edMLPlayer_Config.config.box.theorembox.counter = edMLPlayer_Config.config.box.counter;
            edMLPlayer_Config.config.box.theorembox.numbered = true;
            edMLPlayer_Config.config.box.theorembox.format = new Object();
            edMLPlayer_Config.config.box.theorembox.format.enumeration = edMLPlayer_Config.config.box.format.enumeration;
            edMLPlayer_Config.config.box.theorembox.format.title = edMLPlayer_Config.config.box.format.title;
            edMLPlayer_Config.config.box.theorembox.format.subtitleleft = edMLPlayer_Config.config.box.format.subtitleleft;
            edMLPlayer_Config.config.box.theorembox.format.subtitleright = edMLPlayer_Config.config.box.format.subtitleright;

            //codelisting
            edMLPlayer_Config.config.codelisting = new Object();
            edMLPlayer_Config.config.codelisting.preventcopy = false;
            

            //default model
            edMLPlayer_Config.config.defaultmodel = new Object();  

            edMLPlayer_Config.config.defaultmodel.boolean = new Object();
            edMLPlayer_Config.config.defaultmodel.boolean.checkduration = 2000;
            edMLPlayer_Config.config.defaultmodel.boolean.credits = 1;
            edMLPlayer_Config.config.defaultmodel.boolean.penalty = 0;
            edMLPlayer_Config.config.defaultmodel.boolean.reveal = edMLPlayer_Config.config.player.reveal; 

            edMLPlayer_Config.config.defaultmodel.number = new Object();            
            edMLPlayer_Config.config.defaultmodel.number.checkduration = 2000;
            edMLPlayer_Config.config.defaultmodel.number.decimalseparator = edMLPlayer_Config.config.course.decimalseparator;
            edMLPlayer_Config.config.defaultmodel.number.credits = 1;
            edMLPlayer_Config.config.defaultmodel.number.penalty = 0;
            edMLPlayer_Config.config.defaultmodel.number.base = 10;
            edMLPlayer_Config.config.defaultmodel.number.digits = new Array('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
            edMLPlayer_Config.config.defaultmodel.number.minfracdigits = 0;
            edMLPlayer_Config.config.defaultmodel.number.maxfracdigits = Infinity;
            edMLPlayer_Config.config.defaultmodel.number.minintdigits = 0;
            edMLPlayer_Config.config.defaultmodel.number.maxintdigits = Infinity;
            edMLPlayer_Config.config.defaultmodel.number.lowertolerance = 0;             
            edMLPlayer_Config.config.defaultmodel.number.uppertolerance = 0;             
            edMLPlayer_Config.config.defaultmodel.number.lowerreltolerance = 0;             
            edMLPlayer_Config.config.defaultmodel.number.upperreltolerance = 0;
            edMLPlayer_Config.config.defaultmodel.number.minfracdigitshints = false;
            edMLPlayer_Config.config.defaultmodel.number.maxfracdigitshints = false;
            edMLPlayer_Config.config.defaultmodel.number.minintdigitshints = false;
            edMLPlayer_Config.config.defaultmodel.number.maxintdigitshints = false;
            edMLPlayer_Config.config.defaultmodel.number.significant = "none";
            edMLPlayer_Config.config.defaultmodel.number.significancecheck = "lax"; 
            edMLPlayer_Config.config.defaultmodel.number.checkvalue = true;  // false -> check attributes only; important for exponential
            edMLPlayer_Config.config.defaultmodel.number.reveal = edMLPlayer_Config.config.player.reveal;  
            edMLPlayer_Config.config.defaultmodel.number.precision = 1E-13; 


            edMLPlayer_Config.config.defaultmodel.exponential = new Object();
            edMLPlayer_Config.config.defaultmodel.exponential.checkduration = 2000;  
            edMLPlayer_Config.config.defaultmodel.exponential.credits = 1;  
            edMLPlayer_Config.config.defaultmodel.exponential.penalty = 0;  
            edMLPlayer_Config.config.defaultmodel.exponential.base = 10; 
            edMLPlayer_Config.config.defaultmodel.exponential.lowertolerance = 0; 
            edMLPlayer_Config.config.defaultmodel.exponential.uppertolerance = 0; 
            edMLPlayer_Config.config.defaultmodel.exponential.lowerreltolerance = 0; 
            edMLPlayer_Config.config.defaultmodel.exponential.upperreltolerance = 0; 
            edMLPlayer_Config.config.defaultmodel.exponential.precision = 1E-12;  
            edMLPlayer_Config.config.defaultmodel.exponential.scientific = false;  
            edMLPlayer_Config.config.defaultmodel.exponential.engineering = false;  
            edMLPlayer_Config.config.defaultmodel.exponential.reveal = edMLPlayer_Config.config.player.reveal;           
            edMLPlayer_Config.config.defaultmodel.exponential.mantissa = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.number);
            edMLPlayer_Config.config.defaultmodel.exponential.mantissa.checkvalue = false;

            edMLPlayer_Config.config.defaultmodel.exponential.exponent = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.number);
            edMLPlayer_Config.config.defaultmodel.exponential.exponent.checkvalue = false;            
            

        


            
            edMLPlayer_Config.config.defaultmodel.choice = new Object();
            edMLPlayer_Config.config.defaultmodel.choice.checkduration = 2000;
            edMLPlayer_Config.config.defaultmodel.choice.credits = 1;
            edMLPlayer_Config.config.defaultmodel.choice.penalty = 0;
            edMLPlayer_Config.config.defaultmodel.choice.shuffle = "false";
            edMLPlayer_Config.config.defaultmodel.choice.reveal = edMLPlayer_Config.config.player.reveal;

            edMLPlayer_Config.config.defaultmodel.expression = new Object();
            edMLPlayer_Config.config.defaultmodel.expression.inputmode = "calculator";  //preview or calculator
            edMLPlayer_Config.config.defaultmodel.expression.checkduration = 3000;
            edMLPlayer_Config.config.defaultmodel.expression.credits = 1;
            edMLPlayer_Config.config.defaultmodel.expression.penalty = 0;
            edMLPlayer_Config.config.defaultmodel.expression.useonly = "";
            edMLPlayer_Config.config.defaultmodel.expression.usenot = "";
            edMLPlayer_Config.config.defaultmodel.expression.useonce = "";
            edMLPlayer_Config.config.defaultmodel.expression.expect = "";
            edMLPlayer_Config.config.defaultmodel.expression.simplify = "false";           
            edMLPlayer_Config.config.defaultmodel.expression.expanded = "false";        
            edMLPlayer_Config.config.defaultmodel.expression.testmode = "equality";
            edMLPlayer_Config.config.defaultmodel.expression.precision = 1E-15;
            edMLPlayer_Config.config.defaultmodel.expression.infinityaddword = [];           
            edMLPlayer_Config.config.defaultmodel.expression.functions = [];   
            edMLPlayer_Config.config.defaultmodel.expression.reveal = edMLPlayer_Config.config.player.reveal;   
            




            edMLPlayer_Config.config.defaultmodel.vector = new Object();
            edMLPlayer_Config.config.defaultmodel.vector.checkduration = 2000;
            edMLPlayer_Config.config.defaultmodel.vector.credits = 1;  
            edMLPlayer_Config.config.defaultmodel.vector.penalty = 1;  
            edMLPlayer_Config.config.defaultmodel.vector.direction = 'column';  
            edMLPlayer_Config.config.defaultmodel.vector.number = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.number);
            edMLPlayer_Config.config.defaultmodel.vector.expression = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.expression);
            edMLPlayer_Config.config.defaultmodel.vector.string = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.string);
            edMLPlayer_Config.config.defaultmodel.vector.minsize = 1;  
            edMLPlayer_Config.config.defaultmodel.vector.maxsize = Infinity; 
            edMLPlayer_Config.config.defaultmodel.vector.reveal = edMLPlayer_Config.config.player.reveal; 


            
            edMLPlayer_Config.config.defaultmodel.matrix = new Object();
            edMLPlayer_Config.config.defaultmodel.matrix.checkduration = 2000;
            edMLPlayer_Config.config.defaultmodel.matrix.credits = 1;
            edMLPlayer_Config.config.defaultmodel.matrix.penalty = 1;
            edMLPlayer_Config.config.defaultmodel.matrix.defaultcolumns = 1;
            edMLPlayer_Config.config.defaultmodel.matrix.mincolumns = 1;
            edMLPlayer_Config.config.defaultmodel.matrix.maxcolumns = Infinity;
            edMLPlayer_Config.config.defaultmodel.matrix.defaultrows = 1;
            edMLPlayer_Config.config.defaultmodel.matrix.minrows = 1;
            edMLPlayer_Config.config.defaultmodel.matrix.maxrows = Infinity;
            edMLPlayer_Config.config.defaultmodel.matrix.number = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.number);
            edMLPlayer_Config.config.defaultmodel.matrix.expression = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.expression);
            edMLPlayer_Config.config.defaultmodel.matrix.string = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.string);
            edMLPlayer_Config.config.defaultmodel.matrix.reveal = edMLPlayer_Config.config.player.reveal; 


            edMLPlayer_Config.config.defaultmodel.interval = new Object();
            edMLPlayer_Config.config.defaultmodel.interval.checkduration = 2000;
            edMLPlayer_Config.config.defaultmodel.interval.credits = 1;
            edMLPlayer_Config.config.defaultmodel.interval.penalty = 0;
            edMLPlayer_Config.config.defaultmodel.interval.fixclosure = false;  
            edMLPlayer_Config.config.defaultmodel.interval.closure = "closed";  // open,closedopen, openclosed, closed         
            edMLPlayer_Config.config.defaultmodel.interval.leftclosed = "[";
            edMLPlayer_Config.config.defaultmodel.interval.leftopen = "(";
            edMLPlayer_Config.config.defaultmodel.interval.separator = ";";
            edMLPlayer_Config.config.defaultmodel.interval.rightclosed = "]";
            edMLPlayer_Config.config.defaultmodel.interval.rightopen = ")";
            edMLPlayer_Config.config.defaultmodel.interval.number = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.number);
            edMLPlayer_Config.config.defaultmodel.interval.exponential = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.exponential);
            edMLPlayer_Config.config.defaultmodel.interval.reveal = edMLPlayer_Config.config.player.reveal; 



            edMLPlayer_Config.config.defaultmodel.molecular = new Object();
            edMLPlayer_Config.config.defaultmodel.molecular.checkduration = 2000;
            edMLPlayer_Config.config.defaultmodel.molecular.credits = 1;
            edMLPlayer_Config.config.defaultmodel.molecular.penalty = 0;
            edMLPlayer_Config.config.defaultmodel.molecular.reveal = edMLPlayer_Config.config.player.reveal; 
            
            edMLPlayer_Config.config.defaultmodel.unit = new Object();
            edMLPlayer_Config.config.defaultmodel.unit.inputmode = "calculator"; //calculator, calculatoronly
            edMLPlayer_Config.config.defaultmodel.unit.checkduration = 2000;
            edMLPlayer_Config.config.defaultmodel.unit.useonly = "all";
            edMLPlayer_Config.config.defaultmodel.unit.usenot = "";
            edMLPlayer_Config.config.defaultmodel.unit.prefixes = "all";
            edMLPlayer_Config.config.defaultmodel.unit.credits = 1;
            edMLPlayer_Config.config.defaultmodel.unit.penalty = 0;
            edMLPlayer_Config.config.defaultmodel.unit.number = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.number);
            edMLPlayer_Config.config.defaultmodel.unit.exponential = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.exponential);
            edMLPlayer_Config.config.defaultmodel.unit.useonlyhints = false;
            edMLPlayer_Config.config.defaultmodel.unit.usenothints = false;
            edMLPlayer_Config.config.defaultmodel.unit.prefixeshints = false;
            edMLPlayer_Config.config.defaultmodel.unit.preferredforms = null;
            edMLPlayer_Config.config.defaultmodel.unit.reveal = edMLPlayer_Config.config.player.reveal; 

            edMLPlayer_Config.config.defaultmodel.string = new Object();
            edMLPlayer_Config.config.defaultmodel.string.checkduration = 2000;
            edMLPlayer_Config.config.defaultmodel.string.cloze = "false";
            edMLPlayer_Config.config.defaultmodel.string.minlength = "0";
            edMLPlayer_Config.config.defaultmodel.string.maxlength = null;
            edMLPlayer_Config.config.defaultmodel.string.characters = null;
            edMLPlayer_Config.config.defaultmodel.string.casesensitive = true;
            edMLPlayer_Config.config.defaultmodel.string.charactershints = false;
            edMLPlayer_Config.config.defaultmodel.string.minlengthhints = false;
            edMLPlayer_Config.config.defaultmodel.string.maxlengthhints = false;
            edMLPlayer_Config.config.defaultmodel.string.trim = true;
            edMLPlayer_Config.config.defaultmodel.string.credits = 1;
            edMLPlayer_Config.config.defaultmodel.string.penalty = 0;
            edMLPlayer_Config.config.defaultmodel.string.reveal = edMLPlayer_Config.config.player.reveal; 
            

            edMLPlayer_Config.config.defaultmodel.quantity = new Object();
            edMLPlayer_Config.config.defaultmodel.quantity.checkduration = 2000;
            edMLPlayer_Config.config.defaultmodel.quantity.credits = 1;
            edMLPlayer_Config.config.defaultmodel.quantity.penalty = 0;
            edMLPlayer_Config.config.defaultmodel.quantity.number = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.number);
            edMLPlayer_Config.config.defaultmodel.quantity.unit = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.unit);
            edMLPlayer_Config.config.defaultmodel.quantity.exponential = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.exponential);
            edMLPlayer_Config.config.defaultmodel.quantity.reveal = edMLPlayer_Config.config.player.reveal;


            edMLPlayer_Config.config.defaultmodel.set = new Object();
            edMLPlayer_Config.config.defaultmodel.set.checkduration = 2000;
            edMLPlayer_Config.config.defaultmodel.set.enumerationsign = ",";
            edMLPlayer_Config.config.defaultmodel.set.leftbracket = "{";
            edMLPlayer_Config.config.defaultmodel.set.rightbracket = "}";
            edMLPlayer_Config.config.defaultmodel.set.credits = 1;
            edMLPlayer_Config.config.defaultmodel.set.penalty = 0;  
            edMLPlayer_Config.config.defaultmodel.set.subset = null;            
            edMLPlayer_Config.config.defaultmodel.set.vector = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.vector);
            edMLPlayer_Config.config.defaultmodel.set.number = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.number);
            edMLPlayer_Config.config.defaultmodel.set.string = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.string);
            edMLPlayer_Config.config.defaultmodel.set.of = "auto";                 
            edMLPlayer_Config.config.defaultmodel.set.feedback = "detailed";                 
            edMLPlayer_Config.config.defaultmodel.set.maxsize = Infinity;                 
            edMLPlayer_Config.config.defaultmodel.set.minsize = 0; 
            edMLPlayer_Config.config.defaultmodel.set.minsizehints = false; 
            edMLPlayer_Config.config.defaultmodel.set.maxsizehints = false; 
            edMLPlayer_Config.config.defaultmodel.set.checklive = "minsize maxsize";
            edMLPlayer_Config.config.defaultmodel.set.reveal = edMLPlayer_Config.config.player.reveal;    


            edMLPlayer_Config.config.defaultmodel.matching = new Object();
            edMLPlayer_Config.config.defaultmodel.matching.checkduration = 2000;
            edMLPlayer_Config.config.defaultmodel.matching.credits = 1;
            edMLPlayer_Config.config.defaultmodel.matching.penalty = 1;
            edMLPlayer_Config.config.defaultmodel.matching.maxtotalpenalty = 0;
            edMLPlayer_Config.config.defaultmodel.matching.shuffle = false;
            edMLPlayer_Config.config.defaultmodel.matching.dragusage = 1;
            edMLPlayer_Config.config.defaultmodel.matching.dropusage = 1;
            edMLPlayer_Config.config.defaultmodel.matching.reveal = edMLPlayer_Config.config.player.reveal;


            edMLPlayer_Config.config.defaultmodel.order = new Object();
            edMLPlayer_Config.config.defaultmodel.order.checkduration = 2000;
            edMLPlayer_Config.config.defaultmodel.order.credits = 1;
            edMLPlayer_Config.config.defaultmodel.order.penalty = 1;
            edMLPlayer_Config.config.defaultmodel.order.shuffle = true;   
            edMLPlayer_Config.config.defaultmodel.order.reveal = edMLPlayer_Config.config.player.reveal;        

            edMLPlayer_Config.config.defaultmodel.reaction = new Object();
            edMLPlayer_Config.config.defaultmodel.reaction.educts = new Object();
            edMLPlayer_Config.config.defaultmodel.reaction.educts.molecular = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.molecular);
            edMLPlayer_Config.config.defaultmodel.reaction.educts.fixed = false;
            edMLPlayer_Config.config.defaultmodel.reaction.educts.coefficient = 'blank';
            edMLPlayer_Config.config.defaultmodel.reaction.products = new Object();
            edMLPlayer_Config.config.defaultmodel.reaction.products.molecular = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.molecular);
            edMLPlayer_Config.config.defaultmodel.reaction.products.fixed = false;
            edMLPlayer_Config.config.defaultmodel.reaction.products.coefficient = 'blank';
            edMLPlayer_Config.config.defaultmodel.reaction.credits = 1;
            edMLPlayer_Config.config.defaultmodel.reaction.penalty = 1;
            edMLPlayer_Config.config.defaultmodel.reaction.reduced = false;
            edMLPlayer_Config.config.defaultmodel.reaction.fixededucts = false;
            edMLPlayer_Config.config.defaultmodel.reaction.fixedproducts = false;
            edMLPlayer_Config.config.defaultmodel.reaction.type = 'equilibrium';
            edMLPlayer_Config.config.defaultmodel.reaction.reveal = edMLPlayer_Config.config.player.reveal;  

            edMLPlayer_Config.config.defaultmodel.sourcecode = new Object();
            edMLPlayer_Config.config.defaultmodel.sourcecode.credits = 1;
            edMLPlayer_Config.config.defaultmodel.sourcecode.penalty = 1;
            edMLPlayer_Config.config.defaultmodel.sourcecode.checkduration = 2000;
            edMLPlayer_Config.config.defaultmodel.sourcecode.reveal = edMLPlayer_Config.config.player.reveal;



            //booleangroup
            edMLPlayer_Config.config.defaultmodel.booleangroup = new Object();
            edMLPlayer_Config.config.defaultmodel.booleangroup.maxselection = "unbounded";
            edMLPlayer_Config.config.defaultmodel.booleangroup.minselection = 1;
            edMLPlayer_Config.config.defaultmodel.booleangroup.expectedselection = "none";
            edMLPlayer_Config.config.defaultmodel.booleangroup.maxtotalcredits = 1;
            edMLPlayer_Config.config.defaultmodel.booleangroup.maxtotalpenalty = 0;
            edMLPlayer_Config.config.defaultmodel.booleangroup.feedback = "group";
            edMLPlayer_Config.config.defaultmodel.booleangroup.defaultpenalty = 1;
            edMLPlayer_Config.config.defaultmodel.booleangroup.boolean = edMLPlayer_Config.structuredClone(edMLPlayer_Config.config.defaultmodel.boolean);
            edMLPlayer_Config.config.defaultmodel.booleangroup.reveal = edMLPlayer_Config.config.player.reveal;
            edMLPlayer_Config.config.defaultmodel.booleangroup.onlycheckedcredits = true; //only checked boolean give credits, unchecked not


            //linearspan
            edMLPlayer_Config.config.defaultmodel.linearspan = new Object();
            edMLPlayer_Config.config.defaultmodel.linearspan.checkduration = 2000;
            edMLPlayer_Config.config.defaultmodel.linearspan.credits = 1;
            edMLPlayer_Config.config.defaultmodel.linearspan.penalty = 0;
            edMLPlayer_Config.config.defaultmodel.linearspan.maxvectorcount = "unbounded";
            edMLPlayer_Config.config.defaultmodel.linearspan.minvectorcount = 0;
            edMLPlayer_Config.config.defaultmodel.linearspan.leftsymbol = "<";
            edMLPlayer_Config.config.defaultmodel.linearspan.rightsymbol = ">";
            edMLPlayer_Config.config.defaultmodel.linearspan.lefttext = "";
            edMLPlayer_Config.config.defaultmodel.linearspan.enumerationsign = ",";
            edMLPlayer_Config.config.defaultmodel.linearspan.basis = false;
            edMLPlayer_Config.config.defaultmodel.linearspan.normed = false;
            edMLPlayer_Config.config.defaultmodel.linearspan.orthogonal = false;
            edMLPlayer_Config.config.defaultmodel.linearspan.fixed = true;

            //affinespace
            edMLPlayer_Config.config.defaultmodel.affinespace = new Object();
            edMLPlayer_Config.config.defaultmodel.affinespace.checkduration = 2000;
            edMLPlayer_Config.config.defaultmodel.affinespace.credits = 1;
            edMLPlayer_Config.config.defaultmodel.affinespace.penalty = 0;
        }  
    }

    static get(word){
        let obj = null;
        if(word != null){
            edMLPlayer_Config.create();
            let split = word.split(".");
            obj = edMLPlayer_Config.config;
            for(let i = 0; i< split.length;i++){
            if(obj != null) obj = obj[split[i]];
            }
            if(obj == null) console.error(word);
        }
        return obj;
    }

    static set(word, value){
        edMLPlayer_Config.create();
        let split = word.split(".");
        let obj = edMLPlayer_Config.config;
        for(let i = 0; i< split.length-1;i++){
           if(obj != null) obj = obj[split[i]];
        }      
        
        if(word.indexOf("box.format.") > -1) {
            let boxes = ["applicationbox", "conventionbox", "definitionbox", "examplebox", "exercisebox", "formulabox", "helpbox", "hintbox","infobox","proofbox","remarkbox","textbox","theorembox"];
            let tag = word.replace("box.format.","");
            obj = edMLPlayer_Config.config;

            for(var i = 0; i < boxes.length; i++){
                obj["box"][boxes[i]]["format"][tag] = value;
            }
        }

        if(word.indexOf("box.counter.value") > -1) {
            let boxes = ["applicationbox", "conventionbox", "definitionbox", "examplebox", "exercisebox", "formulabox", "helpbox", "hintbox","infobox","proofbox","remarkbox","textbox","theorembox"];           
            obj = edMLPlayer_Config.config;
            for(var i = 0; i < boxes.length; i++){
                obj["box"][boxes[i]]["counter"]["value"] = value;
            }
        }

        if(obj != null) obj[split[split.length-1]] = value; else console.error(word);
    }

    static structuredClone(obj){
        if(obj == null){
            return null;
        } else if(structuredClone != null) {            
            return structuredClone(obj);
        }  else  {
            return JSON.parse(JSON.stringify(obj));
        }
    }
    
    

    

    
    
}
class edML_SuperclassModel{

    constructor(name){
        this.model = edMLPlayer_Util.structuredClone(edMLPlayer_Config.get('defaultmodel'));        
        this.name = name;
        if(name == null) console.log("edml-defautlmodel created");
        
    }

    getName(){
        return this.name;
    }


    get(identifier){        
        let split = identifier.split(".");
        let obj = this.model;
        for(let i = 0; i< split.length;i++){
           if(obj != null) obj = obj[split[i]];
        }
        if(obj == null) console.error(identifier);
        return obj;
    }

    set(identifier, value){
        let split = identifier.split(".");
        let obj = this.model;
        for(let i = 0; i< split.length-1;i++){
           if(obj != null) obj = obj[split[i]];
        }
        if(obj != null) obj[split[split.length-1]] = value; else console.error(identifier);
    }


    getSubmodel(identifier){
        let split = identifier.split(".");
        let obj = this.model;
        for(let i = 0; i< split.length;i++){
           if(obj != null) obj = obj[split[i]];
        }
        if(obj == null) console.error(identifier);
        return obj;
    }

/*
    onCheck(evt,obj){
        let change = true;
        let timeout = 2000;
        let input = obj;

        if(obj instanceof edML_Boolean){
            timeout = this.boolean.checkduration;
            //part of inputgroup?
            let igroup = obj.closest('edml-booleangroup');
           
            if(igroup != null && igroup instanceof edML_Booleangroup){        
                change = igroup.checkSelection(obj);    
                input = igroup;                        
            } 

        } else if(obj instanceof edML_Expression){
            timeout = this.expression.checkduration;
        } else if(obj instanceof edML_Unit){
            timeout = this.unit.checkduration;
        } else if(obj instanceof edML_Choice){
            timeout = this.choice.checkduration;
        } else if(obj instanceof edML_Set){
            timeout = this.set.checkduration;
        } else if(obj instanceof edML_Vector){
            timeout = this.vector.checkduration;
        } else if(obj instanceof edML_Matrix){
            timeout = this.matrix.checkduration;
        } else if(obj instanceof edML_Interval){
            timeout = this.interval.checkduration;
        } else if(obj instanceof edML_Molecular){
            timeout = this.molecular.checkduration;
        } else if(obj instanceof edML_Unit){
            timeout = this.unit.checkduration;
        } else if(obj instanceof edML_String){
            timeout = this.string.checkduration;
        }  else if(obj instanceof edML_Matching){
            timeout = this.matching.checkduration;
        } else {
            input = obj.closest('edml-input');
        }


        if(change){
            obj.classList.toggle("selected");           
            if(obj.classList.contains("selected")) obj.classList.add('processed'); else obj.classList.remove('processed');
            obj.removeAttribute('solved');
            obj.classList.remove('unsolved');
        }

        edMLPlayer_Functions.hideCheckButton();     
        if(edMLPlayer_Functions.getTimer() != null) {
            clearTimeout(edMLPlayer_Functions.getTimer());
            edMLPlayer_Functions.setTimer(null);                        
        }
      
        if(edMLPlayer_Functions.getTimer() == null && input != null) edMLPlayer_Functions.setTimer(timeout,input); 
        
        
        
    }
    */

}
class edML_Tag extends HTMLElement {

    constructor(){
        super();        
        this.tagWhitelist = null;
        this.attributeWhitelist = null;
        this.requiredTag = null;
        this.requiredAttribute = null;
        this.mixedContent = false;
        this.onlyOnceTag = null;
        this.removeContentByClass = new Array();
        this.ignoreClasses = new Array();  // subnodes with this classname will be ignored by check
        this.ignoreAttributes = new Array();  // attributes that will be ignored by check

        /* quantifier helper:

        minimmum:
        - only attributewhitelist entry -> *
        - attributewhitelist & onlyonce entry -> ?
        - attributewhitelist & required entry -> +
        - attributewhitelist & required & onlyonce entry -> "nothing" (= exactly one)

        */
    }

    cloneEdmlNode(){
        let node = document.createElement('span');
        let edml = this.getEdML();

        //remove name attribute
        edml = edml.replaceAll(/<([a-zA-Z]+ .*? )(name=".*?")( (?:[^>]|\n)*?|)\>/g,'<$1$3>');

        // add edml- to every tag
        edml = edml.replaceAll(/<([a-zA-Z]+)( (?:[^>]|\n)*?|)\>/g,'<edml-$1$2>');           // typ: <tag>        
        edml = edml.replaceAll(/<\/([a-zA-Z]+)[ ]*>/g,'</edml-$1>');   //typ: </tag>

        

        //create and extract node
        node.innerHTML = edml;

        return node.firstChild;
    }
    
    getInnerEdML(node = this){
        let edml = this.getEdML(node);
        edml = edml.substring(edml.indexOf('>')+1);
        edml = edml.substring(0,edml.lastIndexOf('<')); 
        return edml;     
    }

    getEdML(node = this){
        let nodename = node.nodeName.toLowerCase().replace('edml-','');
        let inner = "";
        let innerlist = this.getTagWhitelist();
        if(innerlist == null){
            // all tags are allowed
            innerlist = new Array();
            for(let i = 0; i < node.childNodes; i++){
                innerlist.push(node.nodeName.toLowerCase().replace('edml-',''));
            }
        }
        let innernode;

        for(let i = 0; i < node.childNodes.length; i++){
            innernode = node.childNodes[i];            
            if(innernode.nodeType == Node.TEXT_NODE){
                if(this.isMixedContent()) inner += innernode.textContent.replaceAll('&nbsp;','&#xa0;').replaceAll('&','&amp;').replaceAll(String.fromCharCode(160),'&#xa0;').replaceAll('<','&lt;').replaceAll('>','&gt;').replaceAll('\u00AD',"&#xAD;");                              

            } else if(innerlist.indexOf(innernode.nodeName.toLowerCase().replace('edml-','').toLowerCase()) > -1 && (innernode instanceof edML_Tag)){ 
                let toDelete = false;
                for(let i = 0; i < this.removeContentByClass.length; i++){
                    if(innernode.classList.contains(this.removeContentByClass[i])) toDelete = true;    
                } 
                if(toDelete == false) inner += innernode.getEdML();
            } else {
                // ignore childnode
            }

        } 


        let attr = "";
        let attrlist = this.getAttributeWhitelist();
        if(attrlist == null) { 
            // all attributes are allowed
            attrlist = new Array();
            for(let i = 0; i < node.attributes; i++){
                attrlist.push(node.attributes[i].nodeName);
            }
        } else {                            
            for(let i = 0; i < attrlist.length; i++){
                if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i]).replaceAll('&','&amp;')+'"'; 
            } 
        }


        return '<'+nodename+attr+'>' + inner + '</'+nodename+'>';
    }
    
   /* getEdML(node = this){
        let edml = "";      
        if(node.nodeType == Node.TEXT_NODE){
               // edml += node.textContent.replaceAll(/(?:\r\n|\r|\n)/gm, '').replaceAll(/ +/gm, ' ').replaceAll(/\xa0/gm, ' ').replaceAll('&','&amp;').replaceAll('<','&lt;').replaceAll('>','&gt;').replaceAll('"',' &quot;').replaceAll('"','&apos;');                          
               edml += node.textContent.replaceAll('&nbsp;','&#xa0;').replaceAll('&','&amp;').replaceAll(String.fromCharCode(160),'&#xa0;').replaceAll('<','&lt;').replaceAll('>','&gt;')                                 
        } else{
        
            //node has to remove?
            let toDelete = false;
            for(let i = 0; i < this.removeContentByClass.length; i++){
                if(node.classList.contains(this.removeContentByClass[i])) toDelete = true;    
            } 
             
            if(toDelete == false){
                //check/copy attributes
                if(this.attributeWhitelist == null){
                    //copy all attributes
                    edml += node.outerHTML.substring(0,node.outerHTML.indexOf('>')+1);
                    
                } else {
                    edml += '<' + node.tagName.toLowerCase();
                    //copy allowed attributes
                    for(let i = 0; i < this.attributeWhitelist.length; i++){
                        if(node.getAttribute(this.attributeWhitelist[i]) != null){                    
                            edml += ' ' + this.attributeWhitelist[i] + '="' + node.getAttribute(this.attributeWhitelist[i]) + '"';
                        } 
                    }
                    if(node.outerHTML.indexOf('>') == node.outerHTML.indexOf('/>') +1) edml += '/'; // tag like <br/>
                    edml += '>';
                }
                
                
                
                //child nodes / taglist                  
                for(let i = 0 ; i < node.childNodes.length; i++){ 

                    if(node.childNodes[i].nodeType == Node.TEXT_NODE){
                        //minify textnodes
                        //if(this.isMixedContent()) edml += node.childNodes[i].textContent.replaceAll(/(?:\r\n|\r|\n)/gm, '').replaceAll(/ +/gm, ' ').replaceAll(/\xa0/gm, ' ').replaceAll('&','&amp;').replaceAll('<','&lt;').replaceAll('>','&gt;').replaceAll('"','&quot;').replaceAll('"','&apos;');
                        if(this.isMixedContent()) { 
                            if(node.childNodes[i].parentNode.closest('edml-cdata') == null){                                                            
                                edml += node.childNodes[i].textContent.replaceAll('&','&amp;').replaceAll('<','&lt;').replaceAll('>','&gt;').replaceAll(String.fromCharCode(160),'&#xa0;');
                                
                            } else {                        
                                edml += node.childNodes[i].textContent.replaceAll(String.fromCharCode(160),'&#xa0;');
                            }
                        }
                        
                    } else if(node.childNodes[i].nodeType == Node.CDATASection){ 
                        edml += '<cdata>'+node.childNodes[i].textContent+'</cdata>';
                        
                    } else if(this.tagWhitelist != null && (this.tagWhitelist.indexOf(node.childNodes[i].tagName.toLowerCase().replace('edml-','')) > -1 || node.childNodes[i].tagName.toLowerCase().replace('edml-','') == "cdata") && node.childNodes[i] instanceof edML_Tag){                        
                        edml += node.childNodes[i].getEdML();                                            
                    } else if(this.tagWhitelist != null && this.tagWhitelist.indexOf(node.childNodes[i].tagName.toLowerCase().replace('edml-','')) > -1){
                        edml += this.getEdML(node.childNodes[i]);    
                    } else if(this.tagWhitelist == null){                
                         // all tags are accepted when tagWhitelist = null
                        if(node.childNodes[i] instanceof edML_Tag){
                            edml += node.childNodes[i].getEdML();   
                        } else {
                            edml += this.getEdML(node.childNodes[i]); 
                        }
                    } else {
                        
                    }              
                }
                
                if(node.outerHTML.indexOf('>') != node.outerHTML.indexOf('/>') + 1) edml += '</' + node.tagName.toLowerCase() + '>';   
            }          
        }
        
    
        edml = edml.replaceAll(/<edml-([a-zA-Z]+[^>]*)>/g,'<$1>'); 
        edml = edml.replaceAll(/<\/edml-([a-zA-Z]+[^>]*)>/g,'</$1>');            
        return edml;
    }*/
    
    setOuterEdML(edml){
        var div = document.createElement('div');
        this.closest('edml-variant').appendChild(div);
        div.innerHTML = edml.trim();
        let node = div.firstChild; 
        if(this.previousElementSibling != null) this.parentNode.insertBefore(div.firstChild,this.previousElementSibling); else this.parentNode.prepend(div.firstChild);
               
        div.remove();
        this.remove();
        return node;

    }
    
    setTagWhitelist(list){
        this.tagWhitelist = list;    
    }
    
    setAttributeWhitelist(list){
        this.attributeWhitelist = list;
    }

    setIgnoreAttributes(list){
        this.ignoreAttributes = list;
    }
    
    setRequiredAttribute(list){
        this.requiredAttribute = list;
    }

    setIgnoreClasses(list){
        this.ignoreClasses = list;
    }
    
    setRequiredTag(list){
        this.requiredTag = list;
    }
    
    setOnlyOnceTag(list){
        this.onlyOnceTag = list;
    }
    
    setMixedContent(val){
        if(val == true) this.mixedContent = true; else this.mixedContent = false;
    }
    
    
    setRemoveContentByClass(arr){
        //defines Content that has to be removed when getEdML is called
        this.removeContentByClass = arr;
    }
     
    
    getTagWhitelist(){
        return this.tagWhitelist;
    }

    getAttributeWhitelist(){
        return this.attributeWhitelist;
    }
    
    getRequiredAttribute(){
        return this.requiredAttribute;
    }

    getIgnoreClasses(){
        return this.ignoreClasses;
    }

    getIgnoreAttributes(){
        return this.ignoreAttributes;
    }
                        
    getRequiredTag(){
        return this.requiredTag;
    }
    
    getOnlyOnceTag(){
        return this.onlyOnceTag;
    } 
    
    check(){
        //check for not allowed tags & textcontent
        if(this.getTagWhitelist() != null){
            for(let i = this.childNodes.length-1; i >= 0; i--){                
                if(this.getTagWhitelist().indexOf(this.childNodes[i].nodeName.toLowerCase().replace('edml-','')) == -1 && this.childNodes[i].nodeName.toLowerCase().replace('edml-','') != "cdata"){
                    //have to ignore?
                    let ignore = false; 
                    if(this.childNodes[i].nodeType == Node.COMMENT_NODE){
                        ignore = true;
                    } else if(this.childNodes[i].nodeType != Node.TEXT_NODE && this.childNodes[i].getAttribute("class") != null){
                        let classes = this.childNodes[i].getAttribute("class").split(' ');
                        for(let j = 0; j < classes.length; j++){
                            if(this.ignoreClasses.indexOf(classes[j]) > -1){
                                ignore = true;
                            }
                        }
                    }

                    
                
                    if(!ignore){
                        if(this.childNodes[i].nodeType == Node.TEXT_NODE){
                            if(this.isMixedContent()){
                                this.checkText();
                            } else {
                                //"(nearly) empty node"
                                if(this.childNodes[i].textContent.replace("\t"," ").trim() != ""){
                                    edML_Error.push("0002",this.outerHTML,this.childNodes[i].textContent);
                                    edML_Error.printLast(); 
                                    this.childNodes[i].remove();
                                } 
                                if(this.childNodes[i].nodeType == Node.TEXT_NODE){
                                    this.childNodes[i].remove();
                                }  
                            }
                        } else {                
                            edML_Error.push("0001",this.outerHTML,this.childNodes[i].outerHTML);
                            edML_Error.printLast();
                            this.childNodes[i].remove();   
                        }
                    }
                }    
            }
        }
        
        //check for required tags
        if(this.getRequiredTag() != null){
            for(let i = 0; i < this.getRequiredTag().length; i++){
                if(Array.isArray(this.getRequiredTag()[i])){
                    
                    let j = 0;
                    let found = false;
                    while(j < this.getRequiredTag()[i].length && found == false){
                        if(this.querySelector(':scope > edml-'+this.getRequiredTag()[i][j]) == null){
                            j++;
                        } else {
                            found = true;
                        }   
                    }
                    if(found == false){
                        edML_Error.push("0004",this.outerHTML,this.getRequiredTag()[i]);
                        edML_Error.printLast();       
                    }
                } else {
                    if(this.querySelector(':scope > edml-'+this.getRequiredTag()[i]) == null){
                        edML_Error.push("0004",this.outerHTML,this.getRequiredTag()[i]);
                        edML_Error.printLast();                        
                    }
                }
                
            }
        }
        
        //check for only once tags
        if(this.getOnlyOnceTag() != null){
            for(let i = 0; i < this.getOnlyOnceTag().length; i++){
                if(this.querySelectorAll(':scope > edml-'+this.getOnlyOnceTag()[i]).length > 1){
                    edML_Error.push("0005",this.outerHTML,this.getOnlyOnceTag()[i]);
                        edML_Error.printLast();
                }
            }
        }
        
        
        //check for not allowed attributes
        if(this.getAttributeWhitelist() != null){
            for(let i = this.getAttributeNames().length-1; i >= 0;  i--){
                if(this.getAttributeWhitelist().indexOf(this.getAttributeNames()[i]) == -1){
                    
                    if(this.getAttributeNames()[i].toLowerCase().trim() == "class"){
                        let classes = this.getAttribute("class").split(' ');
                        for(let j = 0; j < classes.length; j++){
                            if(this.ignoreClasses.indexOf(classes[j]) == -1 && classes[j].trim() != ""){                                
                                edML_Error.push("0011",this.outerHTML,classes[j]);
                                edML_Error.printLast();
                                this.classList.remove(classes[j]);
                            }
                        }
                    } else if(this.ignoreAttributes.indexOf(this.getAttributeNames()[i]) > -1){
                        //ignore
                    } else {
                        edML_Error.push("0003",this.outerHTML,this.getAttributeNames()[i]);
                        edML_Error.printLast();
                        this.removeAttribute(this.getAttributeNames()[i]);
                    }
                    
                }
            }
        }
        

        //check for required attributes
        if(this.getRequiredAttribute() != null){
            for(let i = this.getRequiredAttribute().length-1; i >= 0;  i--){
                if(this.getAttributeNames().indexOf(this.getRequiredAttribute()[i]) == -1){
                    edML_Error.push("0010",this.outerHTML,this.getRequiredAttribute()[i]);
                    edML_Error.printLast();
                    this.removeAttribute(this.getAttributeNames()[i]);
                }
            }
        }
    
    }
    
    checkText(){

    }
    
    isMixedContent(){
        return this.mixedContent;
    }

    refresh(){
    
    }
    
    
    

}
class edML_Box extends edML_Tag{

    constructor(){
        super();
        this.setIgnoreClasses(['hide']);

        //move parameters to top
        this.querySelectorAll(':scope > edml-parameter').forEach(function(item){
            this.prepend(item);
        }.bind(this));
    }

    refresh(){
        if(this.querySelector('edml-title') != null){
            this.querySelector('edml-title').refresh(); 
        }
    }

    orderTitle(){
        var orderformat = edMLPlayer_Config.get('box.'+this.nodeName.toLowerCase().replace('edml-','')+'.format.title');
        for(var i = orderformat.length-1; i >= 0; i--){
            if(orderformat[i] == "s"){
                if(this.querySelector(':scope > edml-subtitle') != null) this.prepend(this.querySelector(':scope > edml-subtitle'));
            } else if(orderformat[i] == "e"){
                if(this.querySelector(':scope > edml-enumerator') != null) this.prepend(this.querySelector(':scope > edml-enumerator'));
            } else if(orderformat[i] == "d"){
                if(this.querySelector(':scope > edml-descriptor') != null) this.prepend(this.querySelector(':scope > edml-descriptor'));
            }
        }        
    }



  

    

}
class edML_View extends edML_Tag{

    constructor(){
        super();
        this.setIgnoreClasses(['hide']);
    }



}
class edML_Cdata extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist(["xmlns"]);
        this.setMixedContent(true);
        this.check(); 
    }
    
    //@override
    getEdML(){        
        return '<![CDATA[' + this.innerText + ']]>';
    }
    


}
class edML_Inputvalue extends edML_Tag{

    constructor(){
        super();
        this.lastCredits = 0;         
    }

    


    /** "abstract", must be overrided */
    getValue(){}
    

    /** "abstract", maybe be overrided */
    getCredits(){   // credit points, the user may get
        let val = this.getSubmodel().credits;
        if(this.getAttribute('credits') != null) {
            val = parseInt(this.getAttribute('credits'));
        }
        return val;
    }



   


    /** "abstract", must be overrided */
    verify(value,model){}   // return solvedobj with attributes solved, solution  



    /** maybe be overrided, normaly not */
    getSubmodel(){
        return this.getModel().getSubmodel(edMLPlayer_Functions.getSubmodelByInputvalue(this));
    }
   
    
    
   
    checkFunction(refreshtimer=true){
        let timeout = this.getSubmodel().checkduration;
        let input = this.closest('edml-inputblock');
        if(input == null) input = this.closest('edml-input');
        let igrouptype = edMLPlayer_Functions.getInputgroupTagByInputvalue(this);
        let igroup = null;
        let checked = true;
        if(igrouptype != null) igroup = this.closest(igrouptype);
        if(igroup != null){ 
            if(igroup.checkSelection(this)){
                input.removeAttribute('solved');
                igroup.querySelectorAll('edml-input > ' + this.tagName).forEach(function(item){
                    item.classList.remove('unsolved');             
                });
                checked = true;
                igroup.removeAttribute('solved');
                
            } else {
                checked = false;
            }
            if(refreshtimer) edMLPlayer_Functions.refreshTimer(timeout,igroup);

        } else {
            input.removeAttribute('solved');
            input.classList.remove('missed');
            this.classList.remove('unsolved');  
            checked = true;    
            if(refreshtimer) edMLPlayer_Functions.refreshTimer(timeout,input);    
        }
        return checked;
    }


     /** maybe be overrided, normaly not */
     onCheck(){
        if(this.closest('edml-variant').querySelector('edml-test.active') == null){
            return this.checkFunction();
        } else return false;        
    }


     /** maybe be overrided, e.g. by active preprocessing checks */
     checkShowCheckButton(){
        return true;
    }       

    /** maybe be overrided, normaly not */
    getInputField(){
        return this.querySelector(':scope > input');
    }

    /** maybe be overrided, normaly not */
    getEdmlInput(){
        return this.closest('edml-input');
    }

    /** should be overrided */
    showSolutionhint(){
        
    }

     /** should be overrided */
     clear(){
        
     }


    /** maybe be overrided, normaly not */
    getModel(){
        let node = this.parentNode;
        while(node != null && !(node instanceof edML_Inputvalue || node instanceof edML_Input || node instanceof edML_Inputblock)) {
            node = node.parentNode;            
        }
        
        if(node != null) return node.getModel(); else {
            return null;
        }
    }
    
}
class edML_Inputgroup extends edML_Inputvalue{

    constructor(){
        super();
        this.classList.add('edmlplayer-inputgroup');    
        this.setIgnoreClasses(['edmlplayer-inputgroup']);    
        this.lastCredits = 0;
    }

    /** maybe be overrided, normaly not */
    getUserCredits(){
        return this.lastCredits;
    }

    /** maybe be overrided, normaly not */
    getEdmlInput(){
        return null;
    }

    /** maybe be overrided, normaly not */
    getInputField(){
        return null;
    }

    /** should be overrided */
    clear(){
       
    }



    /** maybe be overrided, normaly not */
    onCheck(evt){
        //check if input group is present is done in model class            
        //this.onCheck(evt);

    }

    /** should be overrided */
    checkSolutionhint(solvedobj){
        //to override
    }

    addAttempt(){
        if(this.attempt == null) this.attempt = 0;
        this.attempt++;
    }

    getAttempts(){
        return this.attempt;
    }


    initFromSCORM(){
        let firstChild = this.childNodes[0];
        let i = 0;
        while(i < this.childNodes.length && firstChild == null ){
            if(this.childNodes[i] instanceof edML_Inputvalue) firstChild = this.childNodes[i];
            i++;
        }    


        if(firstChild != null) {
            this.classList.add('edmlinput-' + firstChild.nodeName.toLowerCase().replace('edml-',''));
        } else {
            console.log(this);
        }

        if(edMLPlayer_Config.get("player.scorm.enabled") == true && firstChild.initFromSCORM != null){  
            firstChild.initFromSCORM();   
        }
    }

    getModel(){
        return edMLPlayer_Functions.getModel("");        
    }
}
class edML_Blockgroup extends edML_Tag{

    constructor(){
        super();          
    }
}
class edML_Inlinegroup extends edML_Tag{

    constructor(){
        super(); 
    }
    
}
class edMLPlayer_Locale{

    constructor(locale){
        this.locale = new Object();
        this.locale.langcode = "en";
        this.locale.yes = "Yes";
        this.locale.okay = "OK";
        this.locale.close = "close";
        this.locale.no = "No";
        this.locale.about = "About";        
        this.locale.dialogAboutTitle = "About";
        this.locale.checkbuttontext = "check results";
        this.locale.errortext = "error";
        this.locale.latexerror = "error";
        this.locale.print = 'Print';        
        this.locale.printpage = 'actual page';
        this.locale.printcourse = 'course (with restrictions)';
        this.locale.printlearnpath = 'learnpath';
        this.locale.menuhelp = 'Help (player)';
        this.locale.notsupported = "This function is not (yet) supported!";

        this.locale.learnpathtitle = "Please choose:";
        this.locale.learnpathstartbtn = "open";
        this.locale.learnpathtitlemiddle = "Description";
        this.locale.learnpathviewbtn = "overview";
        
        this.locale.config = "Configuration";
        
        this.locale.dialog = new Object();
        this.locale.dialog.reveal = new Object();
        this.locale.dialog.reveal.title = "Solution";
        this.locale.dialog.reveal.asktext = "Show solutions?";
        this.locale.dialog.reveal.yes = "Yes";
        this.locale.dialog.reveal.no = "No";
        this.locale.dialog.reveal.solution = "solution:";


        this.locale.dialog.config = new Object();
        this.locale.dialog.config.title = "Configuration";
        this.locale.dialog.config.langplayer = "Webplayer language: ";
        this.locale.dialog.config.langcourse = "Course language: ";
        this.locale.dialog.config.indexeddb = "Save data to browser: ";
        this.locale.dialog.config.deleteindexeddb = "delete data";
        this.locale.dialog.config.confirmdelete = "Would you like to permanently delete all course data?";

        this.locale.indexeddb = new Object();
        this.locale.indexeddb.hint = "Save data to browser. See Configuration";
        
        
        this.locale.solution = "Solution";
        this.locale.dialogSolutionTextTitle = "Solution";

        this.locale.dialog.solutionhintTitle = "Solution hint";
        
        this.locale.dialogErrorTitle = "Error Message";

        //sourcecode
        this.locale.sourcecode = new Object();
        this.locale.sourcecode.runbutton = "run program";
        this.locale.sourcecode.resetbutton = "reset to initial state";
        this.locale.sourcecode.reset = "reset";
        this.locale.sourcecode.solutionbutton = "show solution";
        this.locale.sourcecode.okay = "OK";

        //SCORM
        this.locale.scorm = new Object();
        this.locale.scorm.notsaved = "The data could not be saved. Restart the course.";
        this.locale.scorm.noScorm = "SCORM interface could not be found";
        this.locale.scorm.saveResults = "save results";
        this.locale.scorm.loadResults = "load results";
        this.locale.scorm.prepare = "in preparation";

        //Titlebar
        this.locale.titlebar = new Object();

        //Footer
        this.locale.footer = new Object();
        this.locale.footer.impressum = "legals";
        this.locale.footer.privacy = "privacy policy";
        
        
        //errors
        this.locale.error = new Object();      
        this.locale.error.err0001 = "A not allowed tag was detected.";
        this.locale.error.err0002 = "A not allowed text node was detected.";
        this.locale.error.err0003 = "A not allowed attribute was detected.";
        this.locale.error.err0004 = "A required tag is missing.";
        this.locale.error.err0005 = "Multiple occurence of a tag. Allowed is only one.";
        this.locale.error.err0006 = "Referenced tag not found.";
        this.locale.error.err0007 = "File not found.";
        this.locale.error.err0008 = "No valid edML/XML file.";
        this.locale.error.err0009 = "Duplicated name attribute";
        this.locale.error.err0010 = "Required attribute is missing";
        this.locale.error.err0011 = "A not allowed class was detected.";
        this.locale.error.err0012 = "Different type of tags in input element used. Only one type is allowed.";
        this.locale.error.err0013 = "Parameters should be pairwise distinct or coprime but they aren't.";
        this.locale.error.err0014 = "Language variant not found. Change course language in configuration menu.";
        this.locale.error.err0015 = "Navigation not found. Change course language in configuration menu.";
        this.locale.error.err0016 = "No course element found. Please check your edML.";
        this.locale.error.err0017 = "Fullscreen disabled in testmode. The test is automatically finished.";
        this.locale.error.err0018 = "Unexpected visbility change detected in testmode. The test is automatically finished.";  
        
        this.locale.dialogAboutFooter = '<small>powered by <span class="edml-font-logo"></span>-Webplayer V'+edMLPlayer_Config.get("player.version")+' based on <span class="edml-font-logo"></span> V'+edMLPlayer_Config.get("player.edmlversion")+'</small><br/><small><span class="edml-font-logo"></span>-Webplayer is developed and maintained by <a target="_blank" href="https://www.mint-kolleg.de">MINT-Kolleg Baden-Württemberg</a></small><br/>';
        
        this.locale.dialogNoPageTitle = "Error Message";
        this.locale.dialogNoPageBody= "Sorry, the requested page could not be found.";


        this.locale.dialogExitTitle = "Please confirm";
        this.locale.dialogExitBody = "Would you like to go further back in the browser history? <br/>All entries are irrevocably discarded.";
        this.locale.dialogExitCancel = "cancel";
        this.locale.dialogExitOk = "go back";

        this.locale.helpbtntitle = "Help";
      
        

        
        /* externmedia */
        this.locale.externmedia = new Object();
        this.locale.externmedia.linkname = "extern ressource";
        this.locale.externmediamsg = "extern media content";
        this.locale.externmediabutton = "▶"; //"confirm external content loading";
        this.locale.externmediawarning = "Loading external content may involve sending data to third parties!";


        /*figureblock*/
        this.locale.figureblock = new Object();
        this.locale.figureblock.pic = "Fig.";
        this.locale.figureblock.video = "Video";
        this.locale.figureblock.table = "Table";
        this.locale.figureblock.code = "Codelisting";
        this.locale.figureblock.misc = "";
        this.locale.figureblock.symbol = ":";
        
        //language abbreviation 
        this.locale.languageDE = "German";
        this.locale.languageEN = "English";
        
        
        //boxes and views
        this.locale.applicationbox = new Object();
        this.locale.applicationbox.descriptor = "Application";
        this.locale.applicationbox.subtypes = new Object();
        this.locale.applicationbox.subtypes.experiment = "Experiment";

        this.locale.conventionbox = new Object();
        this.locale.conventionbox.descriptor = "Convention"; 
        this.locale.conventionbox.subtypes = new Object(); 

        this.locale.definitionbox = new Object();
        this.locale.definitionbox.descriptor = "Definition";
        this.locale.definitionbox.subtypes = new Object();

        this.locale.examplebox = new Object();
        this.locale.examplebox.descriptor = "Example";
        this.locale.examplebox.subtypes = new Object();

        this.locale.exercisebox = new Object();
        this.locale.exercisebox.descriptor = "Exercise";
        this.locale.exercisebox.subtypes = new Object();

        this.locale.formulabox = new Object();
        this.locale.formulabox.descriptor = "Formula";
        this.locale.formulabox.subtypes = new Object();

        this.locale.helpbox = new Object();
        this.locale.helpbox.descriptor = "Help";
        this.locale.helpbox.subtypes = new Object();

        
        this.locale.hintbox = new Object();
        this.locale.hintbox.descriptor = "Hint";  
        this.locale.hintbox.subtypes = new Object();

        this.locale.infobox = new Object();
        this.locale.infobox.descriptor = "Info";
        this.locale.infobox.subtypes = new Object();
        this.locale.infobox.subtypes.learningobjective = "Learning objective";

        this.locale.proofbox = new Object();
        this.locale.proofbox.descriptor = "Proof";
        this.locale.proofbox.subtypes = new Object();

        this.locale.remarkbox = new Object();
        this.locale.remarkbox.descriptor = "Remark";
        this.locale.remarkbox.subtypes = new Object();

        this.locale.textbox = new Object();
        this.locale.textbox.descriptor = "";
        this.locale.textbox.subtypes = new Object();

        this.locale.theorembox = new Object();
        this.locale.theorembox.descriptor = "Theorem";
        this.locale.theorembox.subtypes = new Object();
        this.locale.theorembox.subtypes.lemma = "Lemma";
        this.locale.theorembox.subtypes.proposition = "Proposition";
        this.locale.theorembox.subtypes.corollary = "Corollary";
        this.locale.theorembox.subtypes.conjecture = "Conjecture";


        //input types
        this.locale.inputtype = new Object;        
        this.locale.inputtype.number = "Number";
        this.locale.inputtype.expression = "Formula expression";
        this.locale.inputtype.exponential = "Number (exponential notation)";
        this.locale.inputtype.vector = "Vector";
        this.locale.inputtype.vectorofnumbers = "Vector with numbers";
        this.locale.inputtype.vectorofexpressions = "Vector with formula epxressions";
        this.locale.inputtype.vectorofstrings = "Vector with strings";
        this.locale.inputtype.interval = "Interval";
        this.locale.inputtype.intervalofnumbers = "Interval with numbers";
        this.locale.inputtype.intervalofexpressions = "Interval with formula epxressions";
        this.locale.inputtype.set = "Set";
        this.locale.inputtype.matrix = "Matrix";
        this.locale.inputtype.matrixofnumbers = "Matrix with numbers";
        this.locale.inputtype.matrixofexpressions = "Matrix with formula expressions";
        this.locale.inputtype.matrixofstrings = "Matrix with strings";
        this.locale.inputtype.string = "Text";

        //inputs
        this.locale.choice_choose = "please choose";
        
        //Solution hint
        this.locale.dialog_solutionhint_title = "Solution hint";
        
        
        //picture info
        this.locale.dialog_pictureinfo_title = "Attribution";
        this.locale.dialog_pictureinfo_author = "Author(s)";
        this.locale.dialog_pictureinfo_license = "License";
        this.locale.dialog_pictureinfo_source = "Source";
        this.locale.dialog_pictureinfo_description = "Description";
                
        
   
        //general dialogs
        this.locale.dialog_title_hint = "Please note ...";
        this.locale.dialog_body_tomanyselected = "You have to many items selected";
        this.locale.dialog_body_tolittleselected = "You have to select more items";
        this.locale.dialog_startspeak = "Please click to start voice output";
        this.locale.dialog_xmlerror_title = "Attention";
        this.locale.dialog_xmlerror_domparser = "No valid edML/XML file.";
        this.locale.dialog_xmlerror_edmlerror = 'There are some errors in the edML syntax. Something may not be displayed correctly or may be missing.' + '<br/><br/><button class="edml-dialog-button edml-logbtn">show log</button><br/><br/>';
        
        //search dialog
        this.locale.dialogsearch_title = "Search";
        this.locale.dialogsearch_placeholder = "text to search for";
        this.locale.dialogsearch_notfound = "nothing found";

               
        //shortmessage dialog
        this.locale.shortmessage = new Object();
        this.locale.shortmessage.representation = "Please check the number representation.";
        this.locale.shortmessage_minvalue = "minimum value: ";
        this.locale.shortmessage_maxvalue = "maximum value: ";
        this.locale.shortmessage_minfracdigits = "minimum number of decimal places: ";
        this.locale.shortmessage_maxfracdigits = "maximum number of decimal places: ";
        this.locale.shortmessage_minintdigits = "minimum number of digits before the decimal point: ";
        this.locale.shortmessage_maxintdigits = "maximum number of digits before the decimal point: ";
        this.locale.shortmessage_minlength = "minimum number of letters: ";
        this.locale.shortmessage_maxlength = "maximum number of letters: ";
        this.locale.shortmessage_digitserror = "Please check the accuracy with which you state the result.";
        this.locale.shortmessage_minsize = "minimum size of elements: ";
        this.locale.shortmessage_maximumsize = "maximum size of elements: ";
        this.locale.shortmessage.significanterror = "Your input have #1# significant digits. #2# significant digits are required";
        this.locale.shortmessage.prefferedunit = "A better representation is ";

        
        //optionalview
        this.locale.optionalview_button = "Further information";
        
        //buttons
        this.locale.btn_search = "search";
        this.locale.btn_access01 = "optimized display for blind users";
        this.locale.btn_access02 = "optimized display for the visually impaired";
        this.locale.btn_access03 = "increase font size";
        this.locale.btn_access04 = "decrease font size";
        this.locale.btn_addpage = "add page";
        this.locale.btn_levelup = "move navigation item up";
        this.locale.btn_leveldown = "move navigation item down";
        this.locale.btn_levelleft = "move navigation item left";
        this.locale.btn_levelright = "move navigation item right";
        this.locale.toolbar = new Object();
        this.locale.toolbar.lang = "select language";

        //page
        this.locale.page = new Object();
        this.locale.page.timeout = "time's up";

        //expressioncalculator
        this.locale.expressioncalculator = new Object();
        this.locale.expressioncalculator.del = "delete";
        this.locale.expressioncalculator.clr = "clear";
        this.locale.expressioncalculator.right = "move cursor right";
        this.locale.expressioncalculator.left = "move cursor left";

        //unitcalculator
        this.locale.unitcalculator = new Object();

        this.locale.unitcalculator.numerator = "numerator";
        this.locale.unitcalculator.numeratordescription = "Activate to place a unit in the numerator";
        this.locale.unitcalculator.denominator = "denominator";
        this.locale.unitcalculator.denominatordescription = "Activate to place a unit in the denominator";
        this.locale.unitcalculator.clr = "clear whole input";
        this.locale.unitcalculator.enter = "send data to input element";
        this.locale.unitcalculator.cancel = "cancel unit and prefix selection";
        this.locale.unitcalculator.redo = "redo";
        this.locale.unitcalculator.undo = "undo";

        this.locale.unitcalculator.unit = new Object();
        this.locale.unitcalculator.unit.s = "second";
        this.locale.unitcalculator.unit.m = "metre";
        this.locale.unitcalculator.unit.kg = "kilogram";
        this.locale.unitcalculator.unit.A = "ampere";
        this.locale.unitcalculator.unit.K = "kelvin";
        this.locale.unitcalculator.unit.mol = "mole";
        this.locale.unitcalculator.unit.cd = "candela";

        this.locale.unitcalculator.unit.degC = "degree celcius";
        this.locale.unitcalculator.unit.atm = "standard atmosphere";
        this.locale.unitcalculator.unit.B = "Bel";
        this.locale.unitcalculator.unit.bar = "bar";
        this.locale.unitcalculator.unit.Bq = "becquerel";
        this.locale.unitcalculator.unit.C = "coulomb";
        this.locale.unitcalculator.unit.cal = "(mean) calorie";
        this.locale.unitcalculator.unit.cd = "Candela";
        this.locale.unitcalculator.unit.d = "day";
        this.locale.unitcalculator.unit.Da = "dalton";
        this.locale.unitcalculator.unit.eV = "electron volt";        
        this.locale.unitcalculator.unit.F = "farad";
        this.locale.unitcalculator.unit.Gs = "gauss";
        this.locale.unitcalculator.unit.g = "gram";
        this.locale.unitcalculator.unit.Gy = "gray";
        this.locale.unitcalculator.unit.H = "henry";
        this.locale.unitcalculator.unit.h = "hour";
        this.locale.unitcalculator.unit.Hz = "hertz";
        this.locale.unitcalculator.unit.J = "joule";
        this.locale.unitcalculator.unit.kat = "katal";
        this.locale.unitcalculator.unit.L = "litre";
        this.locale.unitcalculator.unit.lm = "lumen";
        this.locale.unitcalculator.unit.lx = "lux";
        this.locale.unitcalculator.unit.min = "minute";
        this.locale.unitcalculator.unit.N = "newton";
        this.locale.unitcalculator.unit.Ω  = "ohm";
        this.locale.unitcalculator.unit.Pa = "pascal";
        this.locale.unitcalculator.unit.rad = "Radian";
        this.locale.unitcalculator.unit.S = "siemens";
        this.locale.unitcalculator.unit.sr = "Steradian";
        this.locale.unitcalculator.unit.Sv = "sievert";
        this.locale.unitcalculator.unit.T = "tesla";
        this.locale.unitcalculator.unit.t = "ton";
        this.locale.unitcalculator.unit.u = "atomic mass unit";
        this.locale.unitcalculator.unit.V = "volt";
        this.locale.unitcalculator.unit.var = "var";
        this.locale.unitcalculator.unit.W = "watt";
        this.locale.unitcalculator.unit.Wb = "weber";
        this.locale.unitcalculator.unit.Wh = "watthour";
        this.locale.unitcalculator.prefixtext = "right click or press & hold unit button for prefix selection";

        this.locale.unitcalculator.prefix = new Object();
        this.locale.unitcalculator.prefix.Y = "yotta";
        this.locale.unitcalculator.prefix.Z = "zetta";
        this.locale.unitcalculator.prefix.E = "exa";
        this.locale.unitcalculator.prefix.P = "peta";
        this.locale.unitcalculator.prefix.T = "tera";
        this.locale.unitcalculator.prefix.G = "giga";
        this.locale.unitcalculator.prefix.M = "mega";
        this.locale.unitcalculator.prefix.k = "kilo";
        this.locale.unitcalculator.prefix.h = "hecto";
        this.locale.unitcalculator.prefix.da = "deca";
        this.locale.unitcalculator.prefix.d = "deci";
        this.locale.unitcalculator.prefix.c = "centi";
        this.locale.unitcalculator.prefix.m = "milli";
        this.locale.unitcalculator.prefix.µ = "micro";
        this.locale.unitcalculator.prefix.n = "nano";
        this.locale.unitcalculator.prefix.p = "pico";
        this.locale.unitcalculator.prefix.f = "femto";
        this.locale.unitcalculator.prefix.a = "atto";
        this.locale.unitcalculator.prefix.z = "zepto";
        this.locale.unitcalculator.prefix.y = "yocto";



        //access
        this.locale.access_navigation_heading = "Navigation";
        this.locale.access_navigation_label = "Course Navigation";
        this.locale.access_pages_heading = "Page";
        this.locale.access_titlebar_heading = "Titlebar";
        this.locale.access_closebutton = "cancel";
        this.locale.access_prevchapter = "previous chapter";
        this.locale.access_next = "next page";
        this.locale.access_previous = "previous page";
        this.locale.access_nextchapter = "next chapter";
        this.locale.access_link = ": external link end";
        this.locale.access_hint = "hint";


        //autoref
        this.locale.autoref = new Object();
        this.locale.autoref.onpage = "on page";
        this.locale.autoref.page = "page";
        this.locale.autoref.navitem = "topic";
        this.locale.autoref.content = "content on page";
        this.locale.autoref.applicationbox = "application";
        this.locale.autoref.conventionbox = "convention";
        this.locale.autoref.definitionbox = "definition";
        this.locale.autoref.examplebox = "example";
        this.locale.autoref.exercisebox = "exercise";
        this.locale.autoref.experimentbox = "experiment";
        this.locale.autoref.formulabox = "formula";
        this.locale.autoref.helpbox = "help";
        this.locale.autoref.hintbox = "hint";
        this.locale.autoref.infobox = "info";
        this.locale.autoref.proofbox = "proof";
        this.locale.autoref.remarkbox = "remark";
        this.locale.autoref.textbox = "text";
        this.locale.autoref.theorembox = "theorem";
        this.locale.autoref.lemma = "lemma";
        this.locale.autoref.figureblock = "figure";
        this.locale.autoref.m = "equation";
        this.locale.autoref.picture = "picture";
        this.locale.autoref.list = "list";

        //test
        this.locale.test = new Object();
        this.locale.test.startbutton = "start test";
        this.locale.test.exitbutton = "exit";
        this.locale.test.fullscreenwarning = "Exiting fullscreen mode or switching to another application will automatically terminate the test!";
        this.locale.test.maxattemptslabel = "Maximum number of test runs";
        this.locale.test.maxattemptsinf = "no limit";
        this.locale.test.minute = "minute";
        this.locale.test.minutes = "minutes";
        this.locale.test.hour = "hour";
        this.locale.test.hours = "hours";
        this.locale.test.second = "second";
        this.locale.test.seconds = "seconds";
        this.locale.test.durationlabel = "Processing time";
        this.locale.test.durationinf = "unlimited";
        this.locale.test.durationpagelimited  = "Pages have time limit";
        this.locale.test.and = "and";
        this.locale.test.navigationlabel = "Navigation";
        this.locale.test.navigationfull = "unlimited";
        this.locale.test.navigationforward = "forward only";
        this.locale.test.navigationnone = "none";
        this.locale.test.creditresult = "Total credits";
        this.locale.test.result = "Total result";
        this.locale.test.starting = "The test starts in a few seconds ...";
        this.locale.test.dontstopfullscreen = "Please do not exit fullscreen mode!";
        this.locale.test.detailedresult = "Your detailed results";
        this.locale.test.detailedcredits = "Credits: ";
    }
    
    get(word,lang = null){
        let split = word.split(".");
        let obj = this.locale;
        if(lang != null && document.edmllocaleObj[lang] != null) {
            obj = document.edmllocaleObj[lang].locale;            
        }
        for(let i = 0; i< split.length;i++){
           if(obj != null && obj != undefined) obj = obj[split[i]];
        }
        
        if(obj == null || obj == undefined) console.error("Locale not found: " + word);
        return obj;
    }
    
    set(word,value,lang=null){
        let split = word.split(".");
        let obj = this.locale;
        if(lang != null && document.edmllocaleObj[lang] != null) {
            obj = document.edmllocaleObj[lang];            
        }
        for(let i = 0; i< split.length-1;i++){
           if(obj != null) obj = obj[split[i]];
        }
        if(obj != null) obj[split[split.length-1]] = value; else console.error("Locale not found: " + word);
    }
    
    
    
    
}
class edMLPlayer_LocaleDE extends edMLPlayer_Locale{

    constructor(){
        super();
        this.locale.langcode = "de";
        this.locale.okay = "übernehmen";
        this.locale.close = "schließen";
        this.locale.errortext = "Fehler";
        this.locale.latexerror = "Fehler";
        this.locale.print = 'Drucken';        
        this.locale.printpage = 'Aktuelle Seite';
        this.locale.printcourse = 'Kurs (mit Einschränkungen)';
        this.locale.printlearnpath = 'Lernpfad';
        this.locale.menuhelp = 'Hilfe (Player)';
        this.locale.yes = "Ja";
        this.locale.no = "Nein";
        this.locale.notsupported = "Diese Funktion wird (noch) nicht unterstützt!";

        this.locale.learnpathtitle = "Bitte wählen Sie:";
        this.locale.learnpathstartbtn = "starten";
        this.locale.learnpathtitlemiddle = "Beschreibung";
        this.locale.learnpathviewbtn = "Übersicht";


        this.locale.about = "Über"; 
        this.locale.dialogAboutTitle = "Über";
        this.locale.checkbuttontext = "Ergebnis prüfen"; 

        
        this.locale.config = "Einstellungen";
        
        this.locale.dialog.config.title = "Einstellungen";
        this.locale.dialog.config.langplayer = "Player-Sprache: ";
        this.locale.dialog.config.langcourse = "Kurs-Sprache: ";
        this.locale.dialog.config.indexeddb = "Daten im Browser speichern: ";
        this.locale.dialog.config.deleteindexeddb = "Daten löschen";
        this.locale.dialog.config.confirmdelete = "Möchten Sie alle Kursdaten unwiderruflich löschen?";

        this.locale.indexeddb.hint = "Daten werden im Browser gespeichert. Siehe Einstellungen";
        
        this.locale.solution = "Lösung";
        this.locale.dialogSolutionTextTitle = "Lösungshinweis";
        
        
        this.locale.dialogAboutFooter = '<p><small>powered by <span class="edml-font-logo"></span>-Player '+edMLPlayer_Config.get("player.version")+' based on <span class="edml-font-logo"></span> V'+edMLPlayer_Config.get("player.edmlversion")+'</small><br/><small><span class="edml-font-logo"></span>-Player wird entwickelt und gepflegt durch das <a target="_blank" href="https://www.mint-kolleg.kit.edu">MINT-Kolleg Baden-Württemberg</a></small></p><p>Alle Infos zu <span class="edml-font-logo"></span> unter <a href="https://www.edml.de">edml.de</a></p>';
        
        this.locale.dialogNoPageTitle = "Fehlermeldung";
        this.locale.dialogNoPageBody= "Die Seite konnte leider nicht gefunden werden.";

        this.locale.helpbtntitle = "Hilfestellung";


        this.locale.dialogExitTitle = "Bitte bestätigen";
        this.locale.dialogExitBody = "Möchten Sie weiter in der Browser-History zurückgehen?<br/> Alle Eingaben werden unwiederruflich verworfen.";
        this.locale.dialogExitCancel = "abbrechen";
        this.locale.dialogExitOk = "bestätigen";


        //sourcecode
        this.locale.sourcecode.runbutton = "Programm starten";
        this.locale.sourcecode.resetbutton = "auf den Ursprungswert zurücksetzen";
        this.locale.sourcecode.reset = "zurücksetzen";
        this.locale.sourcecode.solutionbutton = "Lösung anzeigen";
        this.locale.sourcecode.okay = "OK";

        //SCORM
        this.locale.scorm.notsaved = "Die Daten konnten nicht gespeichert werden. Bitte starten Sie den Kurs neu.";
        this.locale.scorm.noScorm = "Keine SCORM-Schnittstelle gefunden.";
        this.locale.scorm.saveResults = "speichere Daten";
        this.locale.scorm.loadResults = "lade Daten";
        this.locale.scorm.prepare = "wird vorbereitet";

        //Footer
        this.locale.footer.impressum = "Impressum";
        this.locale.footer.privacy = "Datenschutz";
        

         /* externmedia */
         this.locale.externmedia.linkname = "externe Ressource";
        this.locale.externmediamsg = "Externer Inhalt";
        this.locale.externmediabutton = "▶"; //"confirm external content loading";
        this.locale.externmediawarning = "Beim Laden fremder Inhalte können Daten an Dritte übertragen werden!";

        /*figureblock*/
        this.locale.figureblock.pic = "Abb.";
        this.locale.figureblock.video = "Video";
        this.locale.figureblock.table = "Tabelle";
        this.locale.figureblock.code = "Code listing";
        this.locale.figureblock.misc = "";
        this.locale.figureblock.symbol = ":";
        
        //language abbreviation
        this.locale.languageDE = "Deutsch";
        this.locale.languageEN = "Englisch";
        
                
        
        //boxes and views
        this.locale.applicationbox.descriptor = "Anwendung";
        this.locale.applicationbox.subtypes.experiment = "Experiment";

        this.locale.conventionbox.descriptor = "Konvention";

        this.locale.definitionbox.descriptor = "Definition";

        this.locale.exercisebox.descriptor = "Aufgabe";
;
        this.locale.examplebox.descriptor = "Beispiel";

        this.locale.formulabox.descriptor = "Formel";
 
        this.locale.helpbox.descriptor = "Hilfe";

        this.locale.hintbox.descriptor = "Hinweis";

        this.locale.infobox.descriptor = "Info";
        this.locale.infobox.subtypes.learningobjective = "Lernziele";

        this.locale.proofbox.descriptor = "Beweis";

        this.locale.remarkbox.descriptor = "Anmerkung";

        this.locale.textbox.descriptor = "";

        this.locale.theorembox.descriptor = "Theorem";
        this.locale.theorembox.subtypes.lemma = "Lemma";
        this.locale.theorembox.subtypes.proposition = "Proposition";
        this.locale.theorembox.subtypes.corollary = "Korollar";
        this.locale.theorembox.subtypes.conjecture = "Vermutung";

        //inputs
        this.locale.choice_choose = "bitte wählen";

        
        
        //picture info
        this.locale.dialog_pictureinfo_title = "Quellenangabe";
        this.locale.dialog_pictureinfo_author = "Autor(en)";
        this.locale.dialog_pictureinfo_license = "Lizenz";
        this.locale.dialog_pictureinfo_source = "Quelle";
        this.locale.dialog_pictureinfo_description = "Beschreibung";
        
        
        //general dialogs
        this.locale.dialog.solutionhintTitle = "Lösungshinweis";        
        this.locale.dialog_title_hint = "Bitte beachten ...";
        this.locale.dialog_body_tomanyselected = "Sie haben zu viele Felder ausgewählt.";
        this.locale.dialog_body_tolittleselected = "Sie müssen mehr Felder auswählen.";
        this.locale.dialog_startspeak = "Bitte Klicken, um die Sprachwiedergabe zu starten.";


         //search dialog
         this.locale.dialogsearch_title = "Suchen";
         this.locale.dialogsearch_placeholder = "Suchtext";
         this.locale.dialogsearch_notfound = "nichts gefunden";

        
 
                
         //shortmessage dialog
         this.locale.shortmessage.representation = "Bitte prüfen Sie die Zahldarstellung.";
         this.locale.shortmessage_minvalue = "Minimaler Wert: ";
         this.locale.shortmessage_maxvalue = "Maximaler wert: ";
         this.locale.shortmessage_minfracdigits = "Mindestanzahl an Nachkommastellen: ";
         this.locale.shortmessage_maxfracdigits = "Maximale Anzahl an Nachkommastellen: ";
         this.locale.shortmessage_minintdigits = "Mindestanzahl an Vorkommastellen: ";
         this.locale.shortmessage_maxintdigits = "Maximale Anzahl an Vorkommastellen: ";
         this.locale.shortmessage_digitserror = "Bitte prüfen Sie die Genauigkeit, mit welcher Sie das Ergebnis angeben.";
         this.locale.shortmessage.significanterror = "Ihre Eingabe hat #1# signifikante Stellen. Es werden jedoch #2# signifkante Stellen gefordert.";
         this.locale.shortmessage.prefferedunit = "Eine bessere Darstellung ist ";

         //optionalview
        this.locale.optionalview_button = "Weiterführende Informationen";

        //page
        this.locale.page.timeout = "Zeit abgelaufen";

        //expressioncalculator
        this.locale.expressioncalculator.del = "löschen";
        this.locale.expressioncalculator.clr = "alles löschen";
        this.locale.expressioncalculator.right = "Cursor nach rechts";
        this.locale.expressioncalculator.left = "Cursor nach links";


        //unitcalculator
        this.locale.unitcalculator.numerator = "Zähler";
        this.locale.unitcalculator.numeratordescription = "Aktivieren, um Einheiten in den Zähler zu platzieren";
        this.locale.unitcalculator.denominator = "Nenner";
        this.locale.unitcalculator.denominatordescription = "Aktivieren, um Einheiten in den Nenner zu platzieren";
        this.locale.unitcalculator.clr = "Bisherige Eingaben löschen";
        this.locale.unitcalculator.enter = "Daten zum Eingabefeld senden";
        this.locale.unitcalculator.cancel = "Einheit- und Prefix-Auswahl abbrechen";


        this.locale.unitcalculator.unit.s = "Sekunde";
        this.locale.unitcalculator.unit.m = "Meter";
        this.locale.unitcalculator.unit.kg = "Kilogramm";
        this.locale.unitcalculator.unit.A = "Ampere";
        this.locale.unitcalculator.unit.K = "Kelvin";
        this.locale.unitcalculator.unit.mol = "mol";
        this.locale.unitcalculator.unit.cd = "Candela";

        this.locale.unitcalculator.unit.atm = "Physikalische Atmosphäre";
        this.locale.unitcalculator.unit.B = "Bel";
        this.locale.unitcalculator.unit.bar = "Bar";
        this.locale.unitcalculator.unit.Bq = "Becquerel";
        this.locale.unitcalculator.unit.C = "Coulomb";
        this.locale.unitcalculator.unit.cal = "(Mittlere) Kalorie";
        this.locale.unitcalculator.unit.cd = "Candela";
        this.locale.unitcalculator.unit.d = "Tag";
        this.locale.unitcalculator.unit.Da = "Dalton";
        this.locale.unitcalculator.unit.eV= "Elektronenvolt";
        this.locale.unitcalculator.unit.F = "Farad";
        this.locale.unitcalculator.unit.Gs = "Gauß";
        this.locale.unitcalculator.unit.g = "Gramm";
        this.locale.unitcalculator.unit.Gy = "Gray";
        this.locale.unitcalculator.unit.H = "Henry";
        this.locale.unitcalculator.unit.h = "Stunde";
        this.locale.unitcalculator.unit.Hz = "Hertz";
        this.locale.unitcalculator.unit.J = "Joule";
        this.locale.unitcalculator.unit.kat = "Katal";
        this.locale.unitcalculator.unit.L = "Liter";
        this.locale.unitcalculator.unit.lx = "Lux";
        this.locale.unitcalculator.unit.min = "Minute";
        this.locale.unitcalculator.unit.N = "Newton";
        this.locale.unitcalculator.unit.Ω = "Ohm";
        this.locale.unitcalculator.unit.Pa = "Pascal";
        this.locale.unitcalculator.unit.rad = "Radiant";        
        this.locale.unitcalculator.unit.S = "Siemens";
        this.locale.unitcalculator.unit.sr = "Steradiant";
        this.locale.unitcalculator.unit.Sv = "Sievert";
        this.locale.unitcalculator.unit.T = "Tesla";
        this.locale.unitcalculator.unit.t = "Tonne";
        this.locale.unitcalculator.unit.u = "Atomare Masseneinheit";
        this.locale.unitcalculator.unit.V = "Volt";
        this.locale.unitcalculator.unit.var = "Var";
        this.locale.unitcalculator.unit.W = "Watt";
        this.locale.unitcalculator.unit.Wb = "Weber";
        this.locale.unitcalculator.unit.Wh = "Wattstunde";
        this.locale.unitcalculator.unit.degC = "Grad Celcius";

        this.locale.unitcalculator.prefixtext = "Rechtsklick/Halten Sie die Taste gedrückt, um das Präfix auszuwählen";
        this.locale.unitcalculator.prefix.Y = "Yotta";
        this.locale.unitcalculator.prefix.Z = "Zetta";
        this.locale.unitcalculator.prefix.E = "Exa";
        this.locale.unitcalculator.prefix.P = "Peta";
        this.locale.unitcalculator.prefix.T = "Tera";
        this.locale.unitcalculator.prefix.G = "Giga";
        this.locale.unitcalculator.prefix.M = "Mega";
        this.locale.unitcalculator.prefix.k = "Kilo";
        this.locale.unitcalculator.prefix.h = "Hekto";
        this.locale.unitcalculator.prefix.da = "Deka";
        this.locale.unitcalculator.prefix.d = "Dezie";
        this.locale.unitcalculator.prefix.c = "Zenti";
        this.locale.unitcalculator.prefix.m = "Milli";
        this.locale.unitcalculator.prefix.µ = "Mikro";
        this.locale.unitcalculator.prefix.n = "Nano";
        this.locale.unitcalculator.prefix.p = "Piko";
        this.locale.unitcalculator.prefix.f = "Femto";
        this.locale.unitcalculator.prefix.a = "Atto";
        this.locale.unitcalculator.prefix.z = "Zepto";
        this.locale.unitcalculator.prefix.y = "Yokto";


        //access
        this.locale.access_navigation_heading = "Navigation";
        this.locale.access_navigation_label = "Kurs-Navigation";
        this.locale.access_pages_heading = "Seite";
        this.locale.access_titlebar_heading = "Titelleiste";
        this.locale.access_closebutton = "Abbruch";
        this.locale.access_prevchapter = "vorheriges Kapitel";
        this.locale.access_next = "nächste Seite";
        this.locale.access_previous = "vorherige Seite";
        this.locale.access_nextchapter = "nächstes Kapitel";
        this.locale.access_link = ": externer Link Ende";
        this.locale.access_hint = "Hinweis";

        //autoref
        this.locale.autoref.onpage = "auf Seite";
        this.locale.autoref.page = "Seite";
        this.locale.autoref.navitem = "Thema";
        this.locale.autoref.content = "Inhalt auf Seite";
        this.locale.autoref.applicationbox = "Anwendung";
        this.locale.autoref.conventionbox = "Konvention";
        this.locale.autoref.definitionbox = "Definition";
        this.locale.autoref.examplebox = "Beispiel";
        this.locale.autoref.exercisebox = "Aufgabe";
        this.locale.autoref.experimentbox = "Experiment";
        this.locale.autoref.formulabox = "Formel";
        this.locale.autoref.helpbox = "Hilfe";
        this.locale.autoref.hintbox = "Hinweis";
        this.locale.autoref.infobox = "Info";
        this.locale.autoref.proofbox = "Beweis";
        this.locale.autoref.remarkbox = "Anmerkung";
        this.locale.autoref.textbox = "Text";
        this.locale.autoref.theorembox = "Theorem";  
        this.locale.autoref.lemma = "Lemma";  
        this.locale.autoref.m = "Gleichung";  
        this.locale.autoref.figureblock = "Abbildung";  
        this.locale.autoref.picture = "Abbildung";  
        this.locale.autoref.list = "Auflistung";  
        
        
        //error
        this.locale.error.err0001 = "Ein unerlaubes Tag-Element wurde gefunden.";
        this.locale.error.err0002 = "Ein unerlaubter Textknoten wurde gefunden.";
        this.locale.error.err0003 = "Ein unerlaubtes Attribut wurde gefunden.";
        this.locale.error.err0004 = "Ein notwendiges Tag-Element fehlt.";
        this.locale.error.err0005 = "Ein Tag-Element wird mehrfach verwendet, welcher nur einmal verwendet werden darf.";
        this.locale.error.err0006 = "Referenz nicht gefunden.";
        this.locale.error.err0007 = "Datei nicht gefunden.";
        this.locale.error.err0008 = "Keine valide edML/XML-Datei.";
        this.locale.error.err0009 = "Ein Namens-Attributwert wird mehrfach verwendet. Namen müssen eindeutig sein.";
        this.locale.error.err0010 = "Ein erforderliches Attribut fehlt.";
        this.locale.error.err0011 = "Eine unerlaubte Klasse wurde gefunden.";
        this.locale.error.err0012 = "Unterschiedliche Typen von tags wurden im input-Element verwendet. Nur ein Typ pro input-Element ist zulässig.";
        this.locale.error.err0013 = "Parameters should be pairwise distinct but they aren't.";
        this.locale.error.err0014 = "Kursvariante nicht gefunden. Wählen Sie bitte eine andere Variante im Menu aus.";
        this.locale.error.err0015 = "Navigation nicht gefunden. Wählen Sie bitte eine andere Variante im Menu aus.";
        this.locale.error.err0016 = "Kein Kurs-Element gefunden. Bitte prüfen Sie ihre Quelldatei.";
        this.locale.error.err0017 = "Erforderlicher Vollbildmodus wurde während eines Test deaktiviert. Der Test wird daher beendet.";
        this.locale.error.err0018 = "Eine Veränderung der Fenstersichtbarkeit wurde im Testmodus detektiert. Der Test wird daher beendet.";  
        
        //test
        this.locale.test.startbutton = "Test starten";
        this.locale.test.exitbutton = "beenden";
        this.locale.test.fullscreenwarning = "Das Verlassen des Fullscreen-Modus oder das Wechseln zu einer anderen Anwendung führt zu einer automatischen Beendigung des Tests!";
        this.locale.test.maxattemptslabel = "Maximale Anzahl an Testaufrufen";
        this.locale.test.maxattemptsinf = "keine Begrenzung";
        this.locale.test.minute = "Minute";
        this.locale.test.minutes = "Minuten";
        this.locale.test.hour = "Stunde";
        this.locale.test.hours = "Stunden";
        this.locale.test.second = "Sekunde";
        this.locale.test.seconds = "Sekunden";
        this.locale.test.durationlabel = "Bearbeitungszeit";
        this.locale.test.durationinf = "unbegrenzt";
        this.locale.test.durationpagelimited = "Seiten besitzen ein Zeitlimit";
        this.locale.test.and = "und";
        this.locale.test.navigationfull = "Sie können zwischen den Seiten beliebig wechseln. Die Navigation ist nicht eingeschränkt.";
        this.locale.test.navigationforward = "Sie können nur zur nächsten Seite navigieren, aber nicht zurück.";
        this.locale.test.navigationnone = "Es ist keine Navigation möglich. Die Seiten werden automatisch geladen.";
        this.locale.test.creditresult = "Gesamt-Punktzahl";
        this.locale.test.result = "Gesamt-Ergebnis";
        this.locale.test.starting = "Der Test startet in wenigen Sekunden ...";
        this.locale.test.dontstopfullscreen = "Den Fullscreen-Modus bitte nicht beenden!";
        this.locale.test.detailedresult = "Ihre detailierten Ergebnisse";
        this.locale.test.detailedcredits = "Punkte: ";
    }
 
    


    

}


class edMLPlayer_LocaleSelect{
    
    
    constructor(lang){
        switch(lang){
            case "de": 
                this.langobj = new edMLPlayer_LocaleDE();    
            break;                
            default: this.langobj = new edMLPlayer_Locale();
        }
        
        
    }
    
    getLocale(){
        return this.langobj;    
    }
    
    
    
    
    
}
class edML_IndexedDB{

    static db = null;

    static exist(){
        var name = "edmlplayerdb";
        let dbExists = true;
        if(edMLPlayer_Config.get("player.indexeddb.name") != null) name = edMLPlayer_Config.get("player.indexeddb.name");
        const request = window.indexedDB.open(name);
        request.onupgradeneeded = function (e){
            e.target.transaction.abort();
            dbExists = false;
        }
        return dbExists;
    }

    static start(){
        console.info("IndexedDB: try to start");
        return new Promise((resolve, reject) => {
            var name = "edmlplayerdb";
            if(edMLPlayer_Config.get("player.indexeddb.name") != null) name = edMLPlayer_Config.get("player.indexeddb.name");
            const request = window.indexedDB.open(name, edMLPlayer_Config.get("player.indexeddb.version"));
            request.onerror = (event) => {
                edMLPlayer_Config.set("player.indexeddb.enabled",false);
                console.error("IndexedDB could NOT be started!");
                resolve(false);
            };
            request.onsuccess = (event) => {
                edML_IndexedDB.db = event.target.result;
                console.info("IndexedDB: database opened");                                
                resolve(true);
            };

            request.onupgradeneeded = async(event) =>{
                let dbRequest = event.target;
                var db = dbRequest.result;
                if(edMLPlayer_Config.get("player.indexeddb.enabled") == true || db.version != 0) {

                    if(!db.objectStoreNames.contains("input")){
                        var objectStore = db.createObjectStore("input", { keyPath: "name" });
                    // objectStore.createIndex("name", "name", { unique: true });    
                    }
                    if(!db.objectStoreNames.contains("course")){
                        var objectStore = db.createObjectStore("course", { keyPath: "name" });
                    // objectStore.createIndex("name", "name", { unique: true });    
                    }

                    console.info("IndexedDB: database structure created");   
                }

                if(edMLPlayer_Config.get("player.indexeddb.enabled") == false && db.version == 0){
                    window.setTimeout(function(){edML_IndexedDB.cleanup},100);
                }

                
            };
        });

    }


    static async write(index,object){
        if(edML_IndexedDB.db == null) await edML_IndexedDB.start();

        if(edML_IndexedDB.db != null){
            let transaction = edML_IndexedDB.db.transaction(index, "readwrite");
            let store = transaction.objectStore(index);
            let request = store.put(object); 

            request.onsuccess = function() { // (4)
            console.log("Object saved in IndexedDb", request.result);
            };
            
            request.onerror = function() {
                console.log("Error", request.error);
            };
        }
    }

    static read(index,name){        
        return new Promise((resolve, reject) => {
            if(edML_IndexedDB.db != null){
                let transaction = edML_IndexedDB.db.transaction(index);
                let store = transaction.objectStore(index);
                const request = store.get(name);
                request.onerror = (event) => {
                    resolve(null);
                }

                request.onsuccess = (event) => {
                    resolve(request.result);
                }
            } else resolve(null);
        });
    }

    static cleanup(){
        var name = "edmlplayerdb";
        if(edMLPlayer_Config.get("player.indexeddb.name") != null) name = edMLPlayer_Config.get("player.indexeddb.name");
        window.indexedDB.deleteDatabase(name);
    }

}
class edML_ComponentScore{


    constructor(output){
        this.object = document.createElement('span');
        this.object.classList.add('edml-component-score');
        this.leftscore = document.createElement('span');
        this.leftscore.classList.add('edml-component-score-left');
        this.leftscore.innerText = edMLPlayer_Functions.getCredits();
        this.object.append(this.leftscore);
        this.middlescore = document.createElement('span');
        this.middlescore.classList.add('edml-component-score-right');
        this.middlescore.innerText = "/";
        this.object.append(this.middlescore);
        this.rightscore = document.createElement('span');
        this.rightscore.classList.add('edml-component-score-right');
        this.rightscore.innerText = edMLPlayer_Functions.getMaxCredits();
        this.object.append(this.rightscore);
        output.querySelector('edml-pages').append(this.object);  
        
        let maxCredits = 0;
        output.querySelectorAll('edml-input').forEach(function(item){
            
            if((item.closest('edml-booleangroup') == null && item.querySelector(':scope > edml-boolean') != null) || item.querySelector(':scope > edml-boolean') == null ){ // don't count inputs of booleangroup
                maxCredits += item.getMaxCredits();             
            }
            
        });

        output.querySelectorAll('edml-inputblock,edml-booleangroup').forEach(function(item){           
                maxCredits += item.getMaxCredits();                                 
        });

        edMLPlayer_Functions.setMaxCredits(maxCredits);
        this.rightscore.innerText = maxCredits;

        if(edMLPlayer_Config.get("player.scorm.enabled") == true){                      
            edML_SCORM.setValue("cmi.score.max",maxCredits);                               
            edML_SCORM.setValue("cmi.score.min",0);                               
            //edML_SCORM.setValue("cmi.core.score.min",0);  // Ilias nicht implementiert                             
            //edML_SCORM.setValue("cmi.core.score.max",maxCredits);  // Ilias nicht implementiert                                
            edML_SCORM.commit();                               
        } 

        this.handleIndexedDB(0,maxCredits);
        

    }
    

    async handleIndexedDB(minCredits,maxCredits){
        if(edMLPlayer_Config.get("player.indexeddb.enabled") == true){
            var courseobj = await edML_IndexedDB.read('course',edMLPlayer_Config.get("course.name"));  
            if(courseobj != null){
                if(courseobj.min != null) courseobj.min = minCredits;
                if(courseobj.max != null) courseobj.max = maxCredits;
                if(courseobj.score != null) {
                    this.leftscore.innerText = courseobj.score;
                    edMLPlayer_Functions.credits = courseobj.score;
                }
                edML_IndexedDB.write('course',courseobj); 
            }     
        }
    }

    async setLeftScore(amount,effect){                 
        //if(effect) console.log(amount);         

        this.leftscore.innerText = amount;    
        if(effect && parseInt(amount) > 0){
            this.object.classList.remove('nchange');
            this.object.classList.add('pchange');
            setTimeout(function(){this.object.classList.remove('pchange');}.bind(this),1000);
        } else if(effect && parseInt(amount) <= 0){
            this.object.classList.remove('pchange');
            this.object.classList.add('nchange');
            setTimeout(function(){this.object.classList.remove('nchange');}.bind(this),1000);   
        }


        if(edMLPlayer_Config.get("player.scorm.enabled") == true){                         
            edML_SCORM.setValue("cmi.score.raw",amount);     
           // edML_SCORM.setValue("cmi.core.score.raw",amount); // Ilias nicht implementiert   
            edML_SCORM.setValue("cmi.score.raw",amount);     
           // edML_SCORM.setValue("cmi.core.score.raw",amount);    // Ilias nicht implementiert   
            edML_SCORM.commit();                               
        }

        this.saveScoreIndexedDB(amount);
        
    }


    async saveScoreIndexedDB(score){
        if(edMLPlayer_Config.get("player.indexeddb.enabled") == true){
            var courseobj = await edML_IndexedDB.read('course',edMLPlayer_Config.get("course.name"));  
            if(courseobj != null){
                courseobj.score = score;

                await edML_IndexedDB.write('course',courseobj);  
            }     
        }
    }
}
class edML_Error{

    static errorvallist = new Array();
    static errorlist = new Array();
    static errornodelist = new Array();
    
    
    static push(errorcode,parentnode,value){              
        edML_Error.errorlist.push(errorcode);
        edML_Error.errorvallist.push(value);
        edML_Error.errornodelist.push(parentnode);
        
    }
    
    static hasError(){
        if(edML_Error.errorlist.length > 0) return true; else return false;
    }
    
    static clear(){
        edML_Error.errorlist.length = 0;
        edML_Error.errornodelist.length = 0;
        edML_Error.errorvallist.length = 0;
    }
    
    static print(){
        if(edMLPlayer_Config.get("player.displayerror") != "none"){
            for(let i = 0; i < edML_Error.errorlist.length; i++){
                console.error("CODE: " + edML_Error.errorlist[i] + "\nNODE: " + edML_Error.errornodelist[i] + "\nVALUE: " + edML_Error.errorvallist[i] + "\nDESCRIPTION: " + edML_Error.getDescription(edML_Error.errorlist[i]));
            }
        }
    }
    
    static printLast(){
        let i = edML_Error.errorlist.length-1;
        if(edMLPlayer_Config.get("player.displayerror") != "none"){
            console.error("CODE: " + edML_Error.errorlist[i] + "\nNODE: " + edML_Error.errornodelist[i] + "\nVALUE: " + edML_Error.errorvallist[i] + "\nDESCRIPTION: " + edML_Error.getDescription(edML_Error.errorlist[i]));
        }
    }
    
    static list2Dom(){
        let log = document.createElement('div');
        log.classList.add('edml-log');
        for(let i = 0; i < edML_Error.errorlist.length; i++){
            let code = document.createElement('div');
            let codetext = document.createTextNode(edML_Error.errorlist[i]);
            code.innerHTML = "<p><b>CODE</b></p>";
            code.append(codetext);
            let node = document.createElement('div');
            let nodetext = document.createTextNode(edML_Error.errornodelist[i]);
            node.innerHTML = "<p><b>NODE</b><p>";
            node.append(nodetext);
            let value = document.createElement('div');
            let valuetext = document.createTextNode(edML_Error.errorvallist[i]);
            value.innerHTML = "<p><b>VALUE</b><p>";
            value.append(valuetext);
            let descr = document.createElement('div');
            let descrtext = document.createTextNode(edML_Error.getDescription(edML_Error.errorlist[i]));
            descr.innerHTML = "<p><b>DESCRIPTION</b><p>";
            descr.append(descrtext);
            descr.append(document.createElement("br"));  
            descr.append(document.createTextNode("------------------"));         
            descr.append(document.createElement("br"));
            log.append(code);
            log.append(node);
            log.append(value);
            log.append(descr);
             
            
           
        }
        return log;    
    }
    
    static getErrorList(){
        return edML_Error.errorlist;            
    }
    
    static getErrorDescriptionList(){
        let arr = new Array();
        for(let i = 0; i < edML_Error.errorlist.length; i++){
            arr.push(edML_Error.getDescription(edML_Error.errorlist[i]));
        }
        return arr;
    }
    
    static getErrorValueList(){        
        return edML_Error.errorvallist;
    }
    
    
    static getDescription(val){
        return document.edmllocale.get('error.err' + val); 
    }


}
class edML_Groups{

    constructor(){
    
    }
    
    
    static getInlineGroup(){
        return ["audio","autoref","button","cdata","strong","emph","underline","strikeout","input","underline","sup","sub","code","hint","info","warning","m","ref","mark","link","picture","quote","calc","br","note","label"];
    }
    
    static getInputGroup(){
        return ["string","decimal","expression","interval","boolean","choice","set","vector","matrix","unit","quantity","molecular"]; 
    }
    
    static getBlockGroup(){
        return ["objectblock","p","video","flex","list","table","blockquote","codelisting","figureblock","help","solutionhint","sourcecode","inputblock","accordion","tabset","externmedia","booleangroup","decision"];
    }
    
    
    static getInlineBlockGroup(){
        return this.getInlineGroup().concat(edML_Groups.getBlockGroup());
    }
    
    static getInlineBlockInputGroup(){
        return this.getInlineGroup().concat(edML_Groups.getBlockGroup()).concat(edML_Groups.getInputGroup());
    }
    
    static getInlineInputGroup(){
        return this.getInlineGroup().concat(edML_Groups.getInputGroup());
    }

    static getInteractionGroup(){
        return ["interaction"];
    }
    
    static getBoxGroup(){
        return ["applicationbox","conventionbox","definitionbox", "examplebox", "exercisebox", "experimentbox", "formulabox", "helpbox", "hintbox", "infobox", "proofbox", "remarkbox", "textbox", "theorembox"]; 
    }

    static getBoxGroupQuerySelector(){
        var boxes = edML_Groups.getBoxGroup();
        for(var i = 0; i < boxes.length; i++){
            boxes[i] = 'edml-'+boxes[i];
        }
        boxes = JSON.stringify(boxes);
        boxes = boxes.replaceAll('"','').replaceAll('[','').replaceAll(']','');
        return boxes;
    }
    
    static getViewGroup(){
        return ["accordionview", "carouselview", "flipcardview", "groupview", "optionalview","poolview", "tabview"];
    }
    
    static getContainerGroup(){
        return  edML_Groups.getBoxGroup().concat(edML_Groups.getViewGroup().concat(["clonecontainer"]));
    }

}

class edML_SCORM{

    static scormapi = null;
    static scormtableInteractions = null; //Tables to increase performance
    static scormtableObjectives = null; //Tables to increase performance
    static scormInteractionsChildren = null;
    static scormObjectivesChildren = null;
    static scormScoreChildren = null;

    static connect(){
        let apitext;
        if(edMLPlayer_Config.get('player.scorm.version') == 4 || edMLPlayer_Config.get('player.scorm.version') == 0 || edMLPlayer_Config.get('player.scorm.version') == 3){
            apitext = "API_1484_11";
        } else {
            apitext = "API";
        }
        if(edML_SCORM.scormapi == null){
            var win = window;
            var i = 0;

            while (i < 100 && (win[apitext] == null) && (win.parent != null) && (win.parent != win)) {
                i++;            
                win = win.parent;
            }

            if(win[apitext] == null){
                win = window.opener;
                while (win != null && i < 100 && (win[apitext] == null) && (win.parent != null) && (win.parent != win)) {
                    i++;            
                    win = win.parent;
                }
            } 

            if(win != null && win[apitext] != null){
                edML_SCORM.scormapi = win[apitext];                
                edML_SCORM.buildTables();
                console.info('SCORM-LMS connection established');
            } else {
                edML_SCORM.scormapi = null;        
                //alert("LMS connection failed.\nYour results may not be recorded.");
            }
        } else {            
            return true;
        }
        if(edML_SCORM.scormapi == null) {
            new edML_DialogShortmessage(document.edmllocale.get('scorm.noScorm'),"error","5000");
            return false; 
        } else {
            
            if(edMLPlayer_Config.get('player.scorm.version') == 4 || edMLPlayer_Config.get('player.scorm.version') == 0 || edMLPlayer_Config.get('player.scorm.version') == 3){
                      
                if(edML_SCORM.scormapi.Initialize("")){        
                    edML_SCORM.scormapi.SetValue('cmi.exit','suspend');                                              
                    edML_SCORM.buildTables();
                    return true;
                } else {
                    edML_SCORM.scormapi == null;
                }
            } else if(edMLPlayer_Config.get('player.scorm.version') == 2 || edMLPlayer_Config.get('player.scorm.version') == 1){
                
                if(edML_SCORM.scormapi.LMSInitialize("")){ 
                    edML_SCORM.scormapi.LMSSetValue('cmi.exit','suspend');                              
                    edML_SCORM.buildTables();
                    return true;
                } else {
                    edML_SCORM.scormapi == null;
                }
            }
        }
        
    }

    static buildTables(){
        //console.debug("Try to build SCORM-Tables");
        if(edML_SCORM.scormapi != null){
            edML_SCORM.scormtableInteractions = new Array();
            edML_SCORM.scormtableObjectives = new Array();

            edML_SCORM.scormInteractionsChildren = edML_SCORM.getValue('cmi.interactions._children').split(',');
            edML_SCORM.scormObjectivesChildren = edML_SCORM.getValue('cmi.objectives._children').split(',');

            if(edML_SCORM.scormObjectivesChildren.indexOf("score") > -1) {
                var children = edML_SCORM.getValue('cmi.objectives.0.score._children');
                if(children == "") {
                    edML_SCORM.scormScoreChildren = ['raw','min','max'];   
                } else {
                    edML_SCORM.scormScoreChildren = children.split(',');
                }                
            } else {
                edML_SCORM.scormScoreChildren = ['raw','min','max'];                
            }

            //build interactions array
            let n = edML_SCORM.getValue('cmi.interactions._count');
            for(var i = 0; i < n; i++){
                edML_SCORM.scormtableInteractions.push(edML_SCORM.getValue('cmi.interactions.'+(i)+'.id'));
            }

            //build scormtableObjectives array
            n = edML_SCORM.getValue('cmi.objectives._count');
            for(var i = 0; i < n; i++){
                edML_SCORM.scormtableObjectives.push(edML_SCORM.getValue('cmi.objectives.'+(i)+'.id'));
            }
                
            //console.log(edML_SCORM.scormInteractionsChildren);
            //console.log(edML_SCORM.scormObjectivesChildren);
            //console.debug("SCORM-Tables build");

        }

    }


    static saveInteraction(name,type,response,suspend_data, description,latency){
        if(edML_SCORM.scormapi == null){
            edML_SCORM.connect();
        }
        if(edML_SCORM.scormapi != null){
            if(edML_SCORM.getValue('cmi.interactions._count') != edML_SCORM.scormtableInteractions.length){
                /*console.debug("---");
                console.debug(edML_SCORM.getValue('cmi.interactions._count'));
                console.debug(edML_SCORM.scormtableInteractions.length); */
                edML_SCORM.buildTables();
                /*console.debug(edML_SCORM.getValue('cmi.interactions._count'));
                console.debug(edML_SCORM.scormtableInteractions.length); 
                console.debug("---");*/
                
            }
            let addBuildtables = false;
            let n;
            let count = 1;
            if(edMLPlayer_Config.get("player.scorm.journaling") == false){
                n = edML_SCORM.scormtableInteractions.indexOf(name);
                if(n > -1) {
                    count = parseInt(edML_SCORM.getValue('cmi.interactions.'+(n)+'.result'));                
                    count++;
                } else {
                    n = edML_SCORM.scormtableInteractions.length;
                    addBuildtables = true;
                }
            } else {
                n = edML_SCORM.scormtableInteractions.length;
                addBuildtables = true;
            }

            let date = new Date();
            let noerror = true;
            if(edML_SCORM.scormInteractionsChildren.indexOf("id") > -1) {
                noerror = noerror && edML_SCORM.setValue('cmi.interactions.'+(n)+'.id',name); 
            } else {
                console.error('interactions.id not found' + JSON.stringify(edML_SCORM.scormInteractionsChildren));
            }
     
            if(noerror){                            
                if(edML_SCORM.scormInteractionsChildren.indexOf("timestamp") > -1) noerror = noerror && edML_SCORM.setValue('cmi.interactions.'+(n)+'.timestamp',date.toISOString().slice(0, 19));      
                
                
                if(edML_SCORM.scormInteractionsChildren.indexOf("result") > -1) noerror = noerror && edML_SCORM.setValue('cmi.interactions.'+(n)+'.result',count);

                if(type != null && edML_SCORM.scormInteractionsChildren.indexOf("type") > -1) noerror = noerror && edML_SCORM.setValue('cmi.interactions.'+(n)+'.type',type);        
                if(response != null && edML_SCORM.scormInteractionsChildren.indexOf("learner_response") > -1) noerror = noerror && edML_SCORM.setValue('cmi.interactions.'+(n)+'.learner_response',response);       
                if(description != null && edML_SCORM.scormInteractionsChildren.indexOf("description") > -1) noerror = noerror && edML_SCORM.setValue('cmi.interactions.'+(n)+'.description',description);
                if(latency != null && edML_SCORM.scormInteractionsChildren.indexOf("latency") > -1) noerror = noerror && edML_SCORM.setValue('cmi.interactions.'+(n)+'.latency',latency);     // format: e.g. P1Y3M2DT3H   ISO 8601

                
                if(suspend_data != null) edML_SCORM.setValue('cmi.suspend_data',suspend_data);

                noerror = noerror && edML_SCORM.commit();               
                if(noerror){
                    //console.log("SCORM interaction: " + name + " saved");
                    if(addBuildtables) edML_SCORM.scormtableInteractions.push(name);
                } else {
                    new edML_DialogShortmessage(document.edmllocale.get('scorm.notsaved'),"error","5000");
                }
            } else console.error('SCORM interaction id can not be set: ' + name);
            return n;
        } return -1;
        
     
    }

    

    static saveInputObjective(result, input,value){
        if(edML_SCORM.scormapi == null){
            edML_SCORM.connect();
        }
        if(edML_SCORM.scormapi != null){
            if(edML_SCORM.getValue('cmi.objectives._count') != edML_SCORM.scormtableObjectives.length){
               /* console.debug("***");
                console.debug(edML_SCORM.getValue('cmi.objectives._count'));
                console.debug(edML_SCORM.scormtableObjectives.length); */
                edML_SCORM.buildTables();
                /*console.debug(edML_SCORM.getValue('cmi.objectives._count'));
                console.debug(edML_SCORM.scormtableObjectives.length); 
                console.debug("***");*/
                
            }

            let journaling = edMLPlayer_Config.get("player.scorm.journaling");                     
            let n = edML_SCORM.scormtableObjectives.length;
            let name = null;
            let count = 0.01; // 0.01 = first try, 0.02 = second try etc.
            let noerror = true;
            let addBuildtables = false;

            //create id
            if(input != null && input.getAttribute('name') != null) name = input.getAttribute('name');
            if(name != null && name.replace(/[a-zA-Z0-9]*/,"") != "") name = null;  //only numbers and letters for scorm ids

            if(name == null) {
                name = input.closest('edml-page').getAttribute('name').substring(0,500) + "_input";
                let found = input.getAttribute('inputcounter');
                if(found != "" && found != null){
                    while (found.length < 4) found = "0" + found;                
                    name = name + found;
                } else {
                    name = name + "notfound";
                }

            } 
                
            
            if(journaling == false){ //--> state
                n = edML_SCORM.scormtableObjectives.indexOf(name);
                if(n > -1) {
                    count = parseFloat(edML_SCORM.getValue('cmi.objectives.'+n+'.progress_measure')); 
                                    
                    count = count + 0.01;
                    
                } else {
                    n = edML_SCORM.scormtableObjectives.length;
                    addBuildtables = true;
                }
                if(edML_SCORM.scormObjectivesChildren.indexOf("id") > -1) {
                    noerror = noerror & edML_SCORM.setValue('cmi.objectives.'+n+'.id',name);
                } else {
                    console.error("object id not found"+JSON.stringify(edML_SCORM.scormObjectivesChildren));
                }
            } else {

                var found = 0;
                var i = -1;
                while ((i = edML_SCORM.scormtableObjectives.indexOf(name, i+1)) != -1){
                    found++;
                }
                addBuildtables = true;
                
                found = found.toString();
                while(found.length < 4) found = "0"+found;                 
                name = name + "#" + found;
                if(edML_SCORM.scormObjectivesChildren.indexOf("id") > -1) noerror = noerror & edML_SCORM.setValue('cmi.objectives.'+n+'.id',name);
                
            }
            

            if(noerror){               
                
                if(result.solved) {
                    if(edML_SCORM.scormObjectivesChildren.indexOf("success_status") > -1) noerror = noerror & edML_SCORM.setValue('cmi.objectives.'+n+'.success_status',"passed"); 
                    if(edML_SCORM.scormObjectivesChildren.indexOf("score") > -1 && edML_SCORM.scormScoreChildren.indexOf("raw") > -1) {
                        noerror = noerror & edML_SCORM.setValue('cmi.objectives.'+n+'.score.raw',result.credits);
                    }
                    if(edML_SCORM.scormObjectivesChildren.indexOf("completion_status") > -1) noerror = noerror & edML_SCORM.setValue('cmi.objectives.'+n+'.completion_status',"completed"); 
                } else {
                    if(edML_SCORM.scormObjectivesChildren.indexOf("success_status") > -1) noerror = noerror & edML_SCORM.setValue('cmi.objectives.'+n+'.success_status',"failed"); 
                    if(edML_SCORM.scormObjectivesChildren.indexOf("completion_status") > -1) noerror = noerror & edML_SCORM.setValue('cmi.objectives.'+n+'.completion_status',"incomplete"); 
                    if(result.penalty != 0 && result.penalty != null){
                        if(edML_SCORM.scormObjectivesChildren.indexOf("score") > -1 && edML_SCORM.scormScoreChildren.indexOf("raw") > -1) {
                            noerror = noerror & edML_SCORM.setValue('cmi.objectives.'+n+'.score.raw',(-1 * result.penalty));
                        }
                    } else {
                        if(edML_SCORM.scormObjectivesChildren.indexOf("score") > -1 && edML_SCORM.scormScoreChildren.indexOf("raw") > -1) noerror = noerror & edML_SCORM.setValue('cmi.objectives.'+n+'.score.raw',0);
                    }
                }

                
                if(input.getMaxPenalty != 0) noerror = noerror & edML_SCORM.setValue('cmi.objectives.'+n+'.score.min',-1*input.getMaxPenalty());  else  noerror = noerror & edML_SCORM.setValue('cmi.objectives.'+n+'.score.min',0);
                noerror = noerror & edML_SCORM.setValue('cmi.objectives.'+n+'.score.max',input.getMaxCredits());    
                noerror = noerror & edML_SCORM.setValue('cmi.objectives.'+n+'.progress_measure',count);           
                noerror = noerror & edML_SCORM.setValue('cmi.objectives.'+n+'.description',value.substring(0,250));                      
                //  console.log(edML_SCORM.scormapi.GetDiagnostic(edML_SCORM.scormapi.GetLastError()));
                var commiterror = edML_SCORM.commit();
                if(commiterror == "false") commiterror = false;
                if(commiterror == "true") commiterror = true;
                noerror = noerror & commiterror;

                if(noerror){
                    //console.log("SCORM input objective: " + name + " saved");
                    if(addBuildtables) edML_SCORM.scormtableObjectives.push(name);
                } else {
                    new edML_DialogShortmessage(document.edmllocale.get('scorm.notsaved'),"error","5000");
                }
            }

            return name;   
        } else return "";       

    }

    static getInteractionValueByID(element,name){
        //element e.g. cmi.interactions.1.description, name = id
        if(edML_SCORM.scormapi == null){
            edML_SCORM.connect();
        }
        if(edML_SCORM.scormapi != null){
            let journaling = edMLPlayer_Config.get("player.scorm.journaling");    
            if(edML_SCORM.getValue('cmi.interactions._count') != edML_SCORM.scormtableInteractions.length){
                edML_SCORM.buildTables();
            } 
            var n = edML_SCORM.scormtableInteractions.indexOf(name);                
            if(n != null && n > -1){
                element = element.replace('.n.','.'+n+'.');
                return edML_SCORM.getValue(element);
            } else return null;
        } else return "";
    }

    static getValue(element){
        if(edML_SCORM.scormapi == null){
            edML_SCORM.connect();
        }
        if(edML_SCORM.scormapi != null){
            var val = null;
            if(edMLPlayer_Config.get('player.scorm.version') == 4 || edMLPlayer_Config.get('player.scorm.version') == 0 || edMLPlayer_Config.get('player.scorm.version') == 3){
                if(edML_SCORM.connect()){
                    //if(edML_SCORM.scormapi.GetValue('cmi.mode') == "normal"){
                        val = edML_SCORM.scormapi.GetValue(element);
                        
                    //} else {
                      //  console.error('could not read value (1): ' + element);
                    //}
                //  edML_SCORM.disconnect();
                } else {
                    console.error('could not read value (2): ' + element);
                }
                return val;
            } else if(edMLPlayer_Config.get('player.scorm.version') == 2 || edMLPlayer_Config.get('player.scorm.version') == 1){
                if(edML_SCORM.connect()){
                    val = edML_SCORM.scormapi.LMSGetValue(element);    
                } else {
                    console.error('could not read value: ' + element);
                }
                return val;
            }
        } else return "";
    }

    static setValue(element,value){
        //console.debug("SCORM set Value " + element + ": " + value);
        
        if(edML_SCORM.scormapi != null && value !== null){
            var val = null;
            //1.2, 2004 2nd compatibility
            if(edMLPlayer_Config.get('player.scorm.version') < 4) {
                
                element = element.replace(/\.([0-9])\./,'.0$1.');

                if(element.endsWith('.type') == true && value == "other") {
                    value = "performance";
                } else if(element.endsWith('.progress_measure') == true) {
                    element = "";
                } else if(element.endsWith('.result') == true && (value == "NaN" || isNaN(value))) {
                    value = "neutral";
                }  
            }
            

             if(edMLPlayer_Config.get('player.scorm.version') < 3) {
                if(element.endsWith('.description') == true) {
                    element = "";
                } 
             }


            if(element != null && element != "") {
                if(edMLPlayer_Config.get('player.scorm.version') == 4 || edMLPlayer_Config.get('player.scorm.version') == 0 || edMLPlayer_Config.get('player.scorm.version') == 3){
                    if(edML_SCORM.connect()){
                        if(edML_SCORM.scormapi.GetValue('cmi.mode') == "normal"){
                            val = edML_SCORM.scormapi.SetValue(element,value);
                            if(val == false || val == "false") console.error("could not save value " + value + " to element " + element);
                        } else {
                            console.error("couldn't set value: " + value + " to element " + element);
                        }
                    // edML_SCORM.disconnect();
                    } else {
                        console.error('could not set value: ' + value + " to element " + element);
                    }
                    if(val == "true") val = true;
                    if(val == "false") val = false;
                    return val;
                } else if(edMLPlayer_Config.get('player.scorm.version') == 2 || edMLPlayer_Config.get('player.scorm.version') == 1){
                    if(edML_SCORM.connect()){
                    
                        val = edML_SCORM.scormapi.LMSSetValue(element,value);              
                        if(val == false || val == "false") console.error("could not save value " + value + " to element " + element);
                    } else {
                        console.error('could not set value: ' + value + " to element " + element);
                    }
                    if(val == "true") val = true;
                    if(val == "false") val = false;
                    return val;
                }
            } else return true;
        } else if(edML_SCORM.scormapi === null) {
            
            return false;
        } else return false;
    }

    static commit(){
        //console.debug("SCORM data comitted");
        if(edML_SCORM.scormapi != null){
            var result;
            if(edMLPlayer_Config.get('player.scorm.version') == 4 || edMLPlayer_Config.get('player.scorm.version') == 0 || edMLPlayer_Config.get('player.scorm.version') == 3){
                if(edML_SCORM.connect()){
                    result = edML_SCORM.scormapi.Commit("");
                }
            } else if(edMLPlayer_Config.get('player.scorm.version') == 2 || edMLPlayer_Config.get('player.scorm.version') == 1){
                if(edML_SCORM.connect()){
                    result = edML_SCORM.scormapi.LMSCommit("");
                }
            }
            if(result == "true") result = true;
            if(result == "false") result = false;
            return result;
        }
    }

    static disconnect(){        
        if(edML_SCORM.scormapi != null){
            if(edMLPlayer_Config.get('player.scorm.version') == 4 || edMLPlayer_Config.get('player.scorm.version') == 0 || edMLPlayer_Config.get('player.scorm.version') == 3){

                edML_SCORM.scormapi.Terminate("");
                edML_SCORM.scormapi = null;
                console.info('SCORM-LMS connection closed');
            } else if(edMLPlayer_Config.get('player.scorm.version') == 2 || edMLPlayer_Config.get('player.scorm.version') == 1){

                edML_SCORM.scormapi.LMSFinish("");
                edML_SCORM.scormapi = null;
                console.info('SCORM-LMS connection closed');
            }
        }
    }



}
class UnitCalculator{

    static calculator = null;
    static input = null;
    static value = new Object();
    static prefix = "";
    static ticking = false;
    static lastKnownScrollPosition = 0;
    static siunits = ["s","m","kg","A","K","mol","cd"];
    static additionalunits = ["atm","bar","B","Bq","C","cal","d","Da","eV","F","Gs","g","Gy","H","h","Hz","J","kat","L","lm","lx","min","N","Ω","Pa","rad","S","sr","Sv","T","t","u","V","var","W","Wb","Wh","°C"];
    static unitallowed = UnitCalculator.siunits.concat(UnitCalculator.additionalunits);           
    static unitprefix = ["Y","Z","E","P","T","G","M","k","h","da","d","c","m","µ","n","p","f","a","z","y"];
    static undoArr = new Array();
    static undoIndex = 0;

    static create(){
        if(UnitCalculator.calculator == null){
            UnitCalculator.calculator = document.createElement('div');
            UnitCalculator.calculator.classList.add('edml-unitcalculator');
            document.querySelector('edml-course').append(UnitCalculator.calculator);

            let display = document.createElement('div');
            display.classList.add('edml-unitcalculator-display');
            UnitCalculator.calculator.append(display);

            let buttonCLR = document.createElement('button');
            buttonCLR.innerText = "CLR";       
            buttonCLR.classList.add('edml-unitcalculator-button'); 
            buttonCLR.classList.add('edml-unitcalculator-clr'); 
            buttonCLR.setAttribute('title',document.edmllocale.get("unitcalculator.clr")); 
            UnitCalculator.calculator.append(buttonCLR);

            buttonCLR.addEventListener('click',function(){
                UnitCalculator.calculator.querySelectorAll('.edml-unitcalculator-prefix.active').forEach(function(item02){  
                    item02.classList.remove('active');
                });
                UnitCalculator.prefix = "";
                UnitCalculator.value = new Object();  
                UnitCalculator.draw();
                UnitCalculator.undoArr.length = 0;
                UnitCalculator.undoIndex = 0;
                UnitCalculator.calculator.querySelector('.edml-unitcalculator-undo').classList.add('disabled');
                UnitCalculator.calculator.querySelector('.edml-unitcalculator-redo').classList.add('disabled');
            });


            let displayfrac = document.createElement('div');
            displayfrac.classList.add('edml-unitcalculator-displayfrac');

            let buttonnum = document.createElement('button');
            buttonnum.innerText = document.edmllocale.get("unitcalculator.numerator");       
            buttonnum.classList.add('edml-unitcalculator-button'); 
            buttonnum.classList.add('edml-unitcalculator-numerator'); 
            buttonnum.setAttribute('title',document.edmllocale.get("unitcalculator.numeratordescription")); 
            buttonnum.classList.add('active'); 
            displayfrac.append(buttonnum);

            buttonnum.addEventListener('click',function(){
                UnitCalculator.calculator.querySelector('.edml-unitcalculator-denumerator').classList.remove('active');
                this.classList.add('active');                
            });

            let numspan = document.createElement('span');
            numspan.innerText = "/";
            numspan.classList.add('edml-unitcalculator-numspan')
            displayfrac.append(numspan);

            let buttondenum = document.createElement('button');
            buttondenum.innerText = document.edmllocale.get("unitcalculator.denominator");           
            buttondenum.classList.add('edml-unitcalculator-button'); 
            buttondenum.classList.add('edml-unitcalculator-denumerator'); 
            buttondenum.setAttribute('title',document.edmllocale.get("unitcalculator.denominatordescription")); 
            displayfrac.append(buttondenum);

            buttondenum.addEventListener('click',function(){
                UnitCalculator.calculator.querySelector('.edml-unitcalculator-numerator').classList.remove('active');
                this.classList.add('active');
            });

            UnitCalculator.calculator.append(displayfrac);

            
            let buttonRedo = document.createElement('button');
            buttonRedo.innerText = ")";       
            buttonRedo.classList.add('edml-unitcalculator-button'); 
            buttonRedo.classList.add('edml-unitcalculator-redo'); 
            buttonRedo.classList.add('disabled'); 
            buttonRedo.setAttribute('title',document.edmllocale.get("unitcalculator.redo")); 
            displayfrac.append(buttonRedo);
            buttonRedo.addEventListener('click',UnitCalculator.redo.bind(this));


            let buttonUndo = document.createElement('button');
            buttonUndo.innerText = "(";       
            buttonUndo.classList.add('edml-unitcalculator-button'); 
            buttonUndo.classList.add('edml-unitcalculator-undo'); 
            buttonUndo.classList.add('disabled'); 
            buttonUndo.setAttribute('title',document.edmllocale.get("unitcalculator.undo")); 
            displayfrac.append(buttonUndo);
            buttonUndo.addEventListener('click',UnitCalculator.undo.bind(this));


            


            let displaysi = document.createElement('div');
            displaysi.classList.add('edml-unitcalculator-displaysi');
            
            
            for(let i = 0; i < UnitCalculator.siunits.length; i++){
                let button = document.createElement('button');
                button.innerText = UnitCalculator.siunits[i];       
                button.classList.add('edml-unitcalculator-button');
                button.classList.add('edml-unitcalculator-unit');   
                button.setAttribute('title',document.edmllocale.get("unitcalculator.unit." + UnitCalculator.siunits[i])); 
                button.setAttribute('unit',UnitCalculator.siunits[i]);
                displaysi.append(button);
            }
            UnitCalculator.calculator.append(displaysi);


            let displayadd = document.createElement('div');
            displayadd.classList.add('edml-unitcalculator-displayadd');

            UnitCalculator.calculator.append(document.createElement('br'));
            
            
            for(let i = 0; i < UnitCalculator.additionalunits.length; i++){
                let button = document.createElement('button');
                button.innerText = UnitCalculator.additionalunits[i].replace('ohm','Ω'); ;      
                button.classList.add('edml-unitcalculator-button');         
                button.classList.add('edml-unitcalculator-unit'); 
                button.setAttribute('title',document.edmllocale.get("unitcalculator.unit." + UnitCalculator.additionalunits[i].replace('°','deg')));  
                button.setAttribute('unit',UnitCalculator.additionalunits[i]);       
                displayadd.append(button);
            }
            UnitCalculator.calculator.append(displayadd);

            let displayprefix = document.createElement('div');
            displayprefix.classList.add('edml-unitcalculator-displayprefix');

            let displayprefixtriangle = document.createElement('div');
            displayprefixtriangle.classList.add('edml-unitcalculator-displayprefixtriangle');

            UnitCalculator.calculator.append(document.createElement('br'));
            
            for(let i = 0; i < UnitCalculator.unitprefix.length; i++){
                let button = document.createElement('button');
                button.innerText = UnitCalculator.unitprefix[i];       
                button.classList.add('edml-unitcalculator-button');         
                button.classList.add('edml-unitcalculator-prefix');         
                button.setAttribute('prefix',UnitCalculator.unitprefix[i]);
                displayprefix.append(button);
            }

            let buttonCancel = document.createElement('span');
            buttonCancel.innerText = "O";       
            buttonCancel.classList.add('edml-unitcalculator-button');                 
            buttonCancel.classList.add('edml-unitcalculator-buttoncancel');   
            buttonCancel.setAttribute('title',document.edmllocale.get("unitcalculator.cancel"));               
            displayprefix.append(buttonCancel);

            buttonCancel.addEventListener('click',function(){
                UnitCalculator.calculator.querySelector('.edml-unitcalculator-displayprefix').style.display = "none";  
                UnitCalculator.prefix = ""; 
                UnitCalculator.calculator.querySelectorAll('.edml-unitcalculator-unit.active').forEach(function(item02){  
                    item02.classList.remove('active');
                });              
            });

            displayprefix.append(displayprefixtriangle);
            UnitCalculator.calculator.append(displayprefix);


            let buttonEnter = document.createElement('button');
            buttonEnter.innerText = "ok";       
            buttonEnter.classList.add('edml-unitcalculator-button');         
            buttonEnter.classList.add('edml-unitcalculator-enter');      
            buttonEnter.setAttribute('title',document.edmllocale.get("unitcalculator.enter"));           
            UnitCalculator.calculator.append(buttonEnter);

            buttonEnter.addEventListener('click',function(){
                
                const props = Object.getOwnPropertyNames(UnitCalculator.value);
                let text = "";
                for(let i = 0; i < props.length; i++){
                    if(UnitCalculator.value[props[i]] != 0) text += props[i] + "^" + UnitCalculator.value[props[i]] + "*";   
                }  
                if(text.length > 0) text = text.substring(0,text.length - 1);                
                if(UnitCalculator.input != null) {
                    let evt = new Event('valuechange');
                    evt.expression = text;
                    UnitCalculator.input.dispatchEvent(evt);
                }
                UnitCalculator.hide();   
            });


            let buttonClose = document.createElement('button');
            buttonClose.innerText = "X";                   
            buttonClose.classList.add('edml-unitcalculator-close');         
            UnitCalculator.calculator.append(buttonClose);

            buttonClose.addEventListener('click',function(){
                UnitCalculator.hide();     
            });

            let bottomText = document.createElement('span');            
            bottomText.classList.add('edml-unitcalculator-bottomtext');
            UnitCalculator.calculator.append(bottomText);


            UnitCalculator.calculator.querySelectorAll('.edml-unitcalculator-unit').forEach(function(it){
                let item = it;
                item.addEventListener('click',function(){
                    if(!this.classList.contains('disabled')){                    
                        if(UnitCalculator.value[this.innerText] == null) UnitCalculator.value[this.innerText] = 0;
                        if(UnitCalculator.calculator.querySelector('.edml-unitcalculator-numerator.active') != null) {
                            UnitCalculator.value[this.innerText]++; 
                            UnitCalculator.undoArr.length = UnitCalculator.undoIndex;
                            UnitCalculator.undoArr.push("+"+this.innerText); // for undo 
                            UnitCalculator.undoIndex++;
                            UnitCalculator.calculator.querySelector('.edml-unitcalculator-undo').classList.remove('disabled');
                            UnitCalculator.calculator.querySelector('.edml-unitcalculator-redo').classList.add('disabled');
                        } else {
                            UnitCalculator.value[this.innerText]--;   
                            UnitCalculator.undoArr.length = UnitCalculator.undoIndex;                         
                            UnitCalculator.undoArr.push("-"+this.innerText); //for undo
                            UnitCalculator.undoIndex++;
                            UnitCalculator.calculator.querySelector('.edml-unitcalculator-undo').classList.remove('disabled');
                            UnitCalculator.calculator.querySelector('.edml-unitcalculator-redo').classList.add('disabled');
                        }
                        
                        UnitCalculator.draw();
                        UnitCalculator.prefix = "";   
                        UnitCalculator.calculator.querySelector('.edml-unitcalculator-displayprefix').style.display = "none";   
                        UnitCalculator.calculator.querySelectorAll('.edml-unitcalculator-unit.active').forEach(function(item02){  
                            item02.classList.remove('active');
                        });   
                    }           
                });

                item.addEventListener('contextmenu',function(evt){
                    evt.preventDefault();
                    if(!this.classList.contains('disabled')){   
                        if(item.innerText != "kg" && item.innerText != "d"){
                            UnitCalculator.prefix = item.innerText;
                            UnitCalculator.calculator.querySelectorAll('.edml-unitcalculator-unit.active').forEach(function(item02){  
                                item02.classList.remove('active');
                            });
                            item.classList.add('active');
                            let dspprefix = UnitCalculator.calculator.querySelector('.edml-unitcalculator-displayprefix');
                            dspprefix.style.display = "inline-block";

                            dspprefix.style.top = (item.getBoundingClientRect().top - dspprefix.offsetHeight - dspprefix.querySelector('.edml-unitcalculator-displayprefixtriangle').offsetHeight - UnitCalculator.calculator.getBoundingClientRect().top)+"px";
                            dspprefix.querySelector('.edml-unitcalculator-displayprefixtriangle').style.left = (item.getBoundingClientRect().left - UnitCalculator.calculator.getBoundingClientRect().left - parseInt(dspprefix.querySelector('.edml-unitcalculator-displayprefixtriangle').offsetWidth/4))  + "px";
                        }
                    }
                });
                
            });

            UnitCalculator.calculator.querySelectorAll('.edml-unitcalculator-prefix').forEach(function(item){
                item.addEventListener('click',function(){   
                    if(!this.classList.contains('disabled')){                    
                        UnitCalculator.calculator.querySelectorAll('.edml-unitcalculator-unit.active').forEach(function(item02){  
                            item02.classList.remove('active');
                        });                                  
                        let prefix = this.innerText;
                        if(UnitCalculator.prefix == "kg") prefix = "";
                        if(UnitCalculator.value[prefix + UnitCalculator.prefix] == null) UnitCalculator.value[prefix + UnitCalculator.prefix] = 0;
                        if(UnitCalculator.calculator.querySelector('.edml-unitcalculator-numerator.active') != null) UnitCalculator.value[prefix + UnitCalculator.prefix]++; else UnitCalculator.value[prefix + UnitCalculator.prefix]--;
                        
                        UnitCalculator.draw();
                        UnitCalculator.prefix = "";
                        UnitCalculator.calculator.querySelector('.edml-unitcalculator-displayprefix').style.display = "none";
                    }
                });
            });



            UnitCalculator.prefix = "";
            UnitCalculator.value = new Object();


            //drag-Event
            UnitCalculator.onDrag = this.dialogDrag.bind(this);
            this.onDragEnd = this.dialogDragEnd.bind(this);

            //touch
            UnitCalculator.calculator.addEventListener('touchstart', function (event) {
                UnitCalculator.dialogX = event.touches[0].clientX;
                UnitCalculator.dialogY = event.touches[0].clientY;                          
                event.stopPropagation();
                UnitCalculator.calculator.addEventListener('touchmove', UnitCalculator.onDrag);
                UnitCalculator.calculator.addEventListener('touchend', UnitCalculator.onDragEnd);
            }.bind(this));

            //mouse
            UnitCalculator.calculator.addEventListener('mousedown', function (event) {
                UnitCalculator.dialogX = event.clientX;
                UnitCalculator.dialogY = event.clientY;   
                //UnitCalculator.dialogWidth = UnitCalculator.calculator.offsetWidth;                         
                event.stopPropagation();
                window.addEventListener('mousemove', UnitCalculator.onDrag);
                window.addEventListener('mouseup', UnitCalculator.onDragEnd);
            }.bind(this));


            //Scroll
            document.querySelectorAll('edml-variant').forEach(function(it){
                let item = it;
                item.addEventListener('scroll',function(evt){                    
                    if(UnitCalculator.calculator.classList.contains('active')){                        
                        let lastKnownScrollPosition = item.scrollY;
                        
                        if(!UnitCalculator.ticking) {
                            window.requestAnimationFrame(function() {
                                UnitCalculator.onScroll(lastKnownScrollPosition);
                                UnitCalculator.ticking = false;
                            });
                            UnitCalculator.ticking = true;
                        }    
                    }
                });
            });

            UnitCalculator.calculator.addEventListener('contextmenu',function(evt){
                evt.preventDefault();
            });

            
        }
        

    }

    static draw(){
        const props = Object.getOwnPropertyNames(UnitCalculator.value);
        let textNom = "";
        let textDenom = "";
        let text = "";
        for(let i = 0; i < props.length; i++){
            if(UnitCalculator.value[props[i]] < 0){
                textDenom += "\\pu{" + props[i] + "}";
                if(UnitCalculator.value[props[i]] < -1) textDenom += "^{" + Math.abs(UnitCalculator.value[props[i]]) +"}";
                textDenom += "\\cdot";
            } else if(UnitCalculator.value[props[i]] > 0){
                textNom += "\\pu{" + props[i] + "}";
                if(UnitCalculator.value[props[i]] > 1) textNom += "^{" + UnitCalculator.value[props[i]] +"}";
                textNom += "\\cdot";
            }         
            if(UnitCalculator.value[props[i]] != 0) text += props[i] + "^" + UnitCalculator.value[props[i]] + "*";          
        }
        if(textNom.length > 0) textNom = textNom.substring(0,textNom.length - 5);
        if(textDenom.length > 0) textDenom = textDenom.substring(0,textDenom.length - 5);
        if(text.length > 0) text = text.substring(0,text.length - 1);

        if(textDenom != ""){      
            if(textNom.trim() == "") textNom = "1";      
            UnitCalculator.calculator.querySelector('.edml-unitcalculator-display').innerHTML = "<edml-m>\\frac{" + textNom + "}{" + textDenom + "}</edml-m>";
        } else {
            UnitCalculator.calculator.querySelector('.edml-unitcalculator-display').innerHTML = "<edml-m>" + textNom + "</edml-m>";
        }

        if (window.MathJax) {
            edMLPlayer_Util.typesetMath(UnitCalculator.calculator.querySelector('.edml-unitcalculator-display'));
        }   
        
        //if(UnitCalculator.input != null && UnitCalculator.input.value != null) UnitCalculator.input.value = text; 
        
    }

    static positioning(){    
        if(UnitCalculator.input != null){
            let diff = 0;
            let obj = UnitCalculator.input.parentNode; 
            let top;
            let left;
            let active = UnitCalculator.calculator.classList.contains('active');
            UnitCalculator.calculator.classList.add('active');
            let width = UnitCalculator.calculator.getBoundingClientRect().width;
            let height = UnitCalculator.calculator.getBoundingClientRect().height;
            if(!active) UnitCalculator.calculator.classList.remove('active');
            

        // console.log(document.querySelector('edml-variant.active').scrollTop);
            if(document.querySelector('edml-page.active').offsetHeight-obj.getBoundingClientRect().bottom-document.querySelector('edml-variant.active').scrollTop < 350) diff = 350 - (document.querySelector('edml-page.active').offsetHeight-obj.getBoundingClientRect().bottom-document.querySelector('edml-variant.active').scrollTop);
            left = obj.getBoundingClientRect().left;
            if(left + width > window.innerWidth) left = window.innerWidth - width;
            if(left < 0) left = 0;
            UnitCalculator.calculator.style.left = left+"px";
            top = obj.getBoundingClientRect().bottom+8-diff;
            if(top + height > window.innerHeight) top = window.innerHeight - height;
            if(top < 0 ) top = 0;            
            UnitCalculator.calculator.style.top = (top)+"px";            
          //  console.log(diff);
            UnitCalculator.lastKnownScrollPosition = obj.getBoundingClientRect().bottom+8;
        }

    }

    static setInput(input){
        UnitCalculator.create();
        UnitCalculator.input = input;
        UnitCalculator.input.disabled = true;
        
        UnitCalculator.value = new Object();        
        if(input.value != null && input.value.trim() != ""){
            let splitted = input.value.split(/[\/*]/gm);
            let props;
            let length = 0;
            for(let i = 0; i < splitted.length; i++){
                props = splitted[i].split('^');                
                if(props.length == 1) props.push(1);
                if(input.value[length-1] == "/"){
                    props[1] = -props[1];
                }

                UnitCalculator.value[props[0]] = props[1];
                length += splitted[i].length+1;
            }
        }
        UnitCalculator.draw();
    }

    
    static show(useonly,usenot,prefix){              
        UnitCalculator.create();
        UnitCalculator.calculator.querySelector('.edml-unitcalculator-numerator').click();  
        if(UnitCalculator.input != null) {
            UnitCalculator.positioning();
            UnitCalculator.calculator.classList.add('active');
        }

        let arrUseOnly = new Array();
        if(useonly != null){            
            arrUseOnly = useonly.split(' ');    
            if(arrUseOnly.length == 1 && arrUseOnly[0].trim() == "") arrUseOnly.length = 0;   
        }

        let arrUseNot = new Array();
        if(usenot != null){            
            arrUseNot = usenot.split(' '); 
            if(arrUseNot.length == 1 && arrUseNot[0].trim() == "") arrUseNot.length = 0;   
        }

        let arrPrefix = new Array();
        if(prefix != null){            
            arrPrefix = prefix.split(' ');    
            if(arrPrefix.length == 1 && arrPrefix[0].trim() == "") arrPrefix.length = 0;   
        }

        //texte
        UnitCalculator.calculator.querySelector('.edml-unitcalculator-bottomtext').innerText = document.edmllocale.get("unitcalculator.prefixtext");

        UnitCalculator.calculator.querySelectorAll('.edml-unitcalculator-unit').forEach(function(item){
            item.setAttribute('title',document.edmllocale.get("unitcalculator.unit." + item.innerText.replace('°','deg'))); 
            item.classList.add('disabled');    
        });


        UnitCalculator.calculator.querySelectorAll('.edml-unitcalculator-prefix').forEach(function(item){
            item.setAttribute('title',document.edmllocale.get("unitcalculator.prefix." + item.innerText));
            item.classList.add('disabled');            
        });

        //useonly
        for(let i = 0; i < arrUseOnly.length; i++){
            switch(arrUseOnly[i]){
                case "SIbase":
                    for(let i = 0; i < UnitCalculator.siunits.length; i++){
                        UnitCalculator.calculator.querySelector('.edml-unitcalculator-unit[unit="'+UnitCalculator.siunits[i]+'"]').classList.remove('disabled');      
                    }
                break;
                case "all":
                    UnitCalculator.calculator.querySelectorAll('.edml-unitcalculator-unit').forEach(function(item){                    
                        item.classList.remove('disabled');    
                    })   
                break;
                default:
                    UnitCalculator.calculator.querySelector('.edml-unitcalculator-unit[unit="'+arrUseOnly[i]+'"]').classList.remove('disabled');
            }
        }

        //usenot
        for(let i = 0; i < arrUseNot.length; i++){                        
            if(UnitCalculator.calculator.querySelector('.edml-unitcalculator-unit[unit="'+arrUseNot[i]+'"]') != null) {
                UnitCalculator.calculator.querySelector('.edml-unitcalculator-unit[unit="'+arrUseNot[i]+'"]').classList.add('disabled');
            } else {
                console.error('usenot ' + arrUseNot[i] + "not found");
            }
        }

        //prefix
        for(let i = 0; i < arrPrefix.length; i++){
            switch(arrPrefix[i]){
                case "all":
                    UnitCalculator.calculator.querySelectorAll('.edml-unitcalculator-prefix').forEach(function(item){                    
                        item.classList.remove('disabled');            
                    });  
                break;
                default:
                    UnitCalculator.calculator.querySelector('.edml-unitcalculator-prefix[prefix="'+arrPrefix[i]+'"]').classList.remove('disabled');
            }
        }
            
        UnitCalculator.undoArr = new Array();
        UnitCalculator.undoIndex = 0; 
    }



    static hide(){
        UnitCalculator.input.disabled = false;
        UnitCalculator.input = null;
        UnitCalculator.calculator.classList.remove('active');
    }


    static dialogDrag(evt){
        var clientX = evt.clientX;
        var clientY = evt.clientY;
        if(evt.touches != null && evt.touches[0] != null){
            clientX = evt.touches[0].clientX;
            clientY = evt.touches[0].clientY;
            evt.stopPropagation();
        }

        let diffx = clientX - UnitCalculator.dialogX;
        let diffy = clientY - UnitCalculator.dialogY;
        UnitCalculator.calculator.style.top = (UnitCalculator.calculator.offsetTop + diffy) + "px";
        UnitCalculator.calculator.style.left = (UnitCalculator.calculator.offsetLeft + diffx) + "px";
        UnitCalculator.dialogX = clientX;
        UnitCalculator.dialogY = clientY;
       // UnitCalculator.calculator.style.width = UnitCalculator.dialogWidth + "px";
    }

    static dialogDragEnd(evt){
        window.removeEventListener('mouseup',UnitCalculator.onDragEnd);
        window.removeEventListener('mousemove',UnitCalculator.onDrag);
        //UnitCalculator.dialogWidth = null;
    }

    static onScroll(pos){
        UnitCalculator.calculator.style.top = (parseInt(UnitCalculator.calculator.style.top) + (UnitCalculator.input.getBoundingClientRect().bottom+8-UnitCalculator.lastKnownScrollPosition)) + "px";
        UnitCalculator.lastKnownScrollPosition = UnitCalculator.input.getBoundingClientRect().bottom+8;
    }

    static getNormalForm(unitexpression){
        unitexpression = unitexpression.replaceAll(' ','');
        unitexpression = unitexpression.replaceAll('Ω','ohm');
        unitexpression = unitexpression.replaceAll(/([\/\*])?([a-zA-Z]+)([\/\*]|$)/g,'$1$2^+1$3'); // x -> x^+1     
        unitexpression = unitexpression.replaceAll(/(\^)([0-9]+)/g,'$1+$2'); // x^a -> x^+a        
        unitexpression = unitexpression.replaceAll(/[\/]([a-zA-Z]+)(\^\+)+([0-9])*/g,'*$1^-$3'); // /x^+a --> *x^-a
        unitexpression = unitexpression.replaceAll(/[\/]([a-zA-Z]+)(\^\-)+([0-9])*/g,'*$1^+$3'); // /x^-a --> *x^+a 
        unitexpression = unitexpression.replaceAll('+','');
        return unitexpression;
    }

    static getUsedUnitsPrefixes(unitexpression){
        let result = null;
        if(UnitCalculator.unitcheck(unitexpression).trim() == ""){ 
            unitexpression = unitexpression.replaceAll(' ','');
            unitexpression = unitexpression.replaceAll(/([\/\*])?([a-zA-Z]+)([\/\*]|$)/g,'$1$2^+1$3'); // x -> x^+1     
            unitexpression = unitexpression.replaceAll(/(\^)([0-9]+)/g,'$1+$2'); // x^a -> x^+a        
            unitexpression = unitexpression.replaceAll(/[\/]([a-zA-Z]+)(\^\+)+([0-9])*/g,'*$1^-$3'); // /x^+a --> *x^-a
            unitexpression = unitexpression.replaceAll(/[\/]([a-zA-Z]+)(\^\-)+([0-9])*/g,'*$1^+$3'); // /x^-a --> *x^+a 
            unitexpression = unitexpression.replaceAll('+','');
            let unitarr = unitexpression.split('*');
            result = new Object();
            result.units = new Array();
            result.prefixes = new Array();

            let data;
            let d;

            for(let i = 0; i < unitarr.length; i++){                
                data = unitarr[i].split('^');            
                data[0] = data[0].trim();          //Einheit
                
                if(data.length == 2){
                    data[1] = parseInt(data[1].trim());    //Exponent
                } else {
                    data.push(1);  //Exponent
                }

                if(UnitCalculator.unitallowed.indexOf(data[0]) == -1 && data[0].trim() != ""){
                    if(UnitCalculator.unitprefix.indexOf(data[0].substring(0,2)) > -1){
                        d = data[0].substring(0,2);
                        data[0] = data[0].substring(2); 
                        if(result.prefixes.indexOf(d) == -1) result.prefixes.push(d); 
                    } else if(UnitCalculator.unitprefix.indexOf(data[0].substring(0,1)) > -1){
                        d = data[0].substring(0,1);
                        data[0] = data[0].substring(1);
                        if(result.prefixes.indexOf(d) == -1) result.prefixes.push(d);
                    }
                }
                if(result.units.indexOf(data[0]) == -1) result.units.push(data[0]);
            }
        }
        return result;
    }

    static getUnitArray(unitexpression) {
        let result = null;
        if(UnitCalculator.unitcheck(unitexpression).trim() == ""){ 
            unitexpression = unitexpression.replaceAll(' ','');
            unitexpression = unitexpression.replaceAll('Ω','ohm');
            unitexpression = unitexpression.replaceAll(/([\/\*])?([a-zA-Z]+)([\/\*]|$)/g,'$1$2^+1$3'); // x -> x^+1     
            unitexpression = unitexpression.replaceAll(/(\^)([0-9]+)/g,'$1+$2'); // x^a -> x^+a        
            unitexpression = unitexpression.replaceAll(/[\/]([a-zA-Z]+)(\^\+)+([0-9])*/g,'*$1^-$3'); // /x^+a --> *x^-a
            unitexpression = unitexpression.replaceAll(/[\/]([a-zA-Z]+)(\^\-)+([0-9])*/g,'*$1^+$3'); // /x^-a --> *x^+a 
            unitexpression = unitexpression.replaceAll('+','');
            
            let unitarr = unitexpression.split('*');
            result = new Object();
            result.s = 0;
            result.m = 0;
            result.kg = 0;
            result.A = 0;
            result.K = 0;
            result.mol = 0;
            result.cd = 0;
            result.factor = 1;   
            result.summand = 0;         
            let faktor = 1; //factor of the whole expression
            let innerfaktor; 
            let data; // array; splitted unit and exponent
            let d; // multiplikator like k = 1000
            let add;
            for(let i = 0; i < unitarr.length; i++){
                innerfaktor = 1;
                data = unitarr[i].split('^');            
                data[0] = data[0].trim();          //Einheit
                
                if(data.length == 2){
                    data[1] = parseInt(data[1].trim());    //Exponent
                } else {
                    data.push(1);  //Exponent
                }
              
                if(UnitCalculator.unitallowed.indexOf(data[0]) == -1 && data[0].trim() != ""){
                    if(UnitCalculator.unitprefix.indexOf(data[0].substring(0,2)) > -1){
                        d = data[0].substring(0,2);
                        data[0] = data[0].substring(2); 
                        switch(d){                          
                            case "da": innerfaktor = 10; break;                                        
                            default: innerfaktor = 1;
                        }   
                    } else if(UnitCalculator.unitprefix.indexOf(data[0].substring(0,1)) > -1){
                        d = data[0].substring(0,1);
                        data[0] = data[0].substring(1);

                        switch(d){
                            case "Y": innerfaktor = 1E24; break;
                            case "Z": innerfaktor = 1E21; break;
                            case "E": innerfaktor = 1E18; break;
                            case "P": innerfaktor = 1E15; break;
                            case "T": innerfaktor = 1E12; break;
                            case "G": innerfaktor = 1E9; break;
                            case "M": innerfaktor = 1E6; break;
                            case "k": innerfaktor = 1E3; break;
                            case "h": innerfaktor = 100; break; 
                            case "da": innerfaktor = 10; break;                           
                            case "d": innerfaktor = 0.1; break;
                            case "c": innerfaktor = 0.01; break;
                            case "m": innerfaktor = 1E-3; break;
                            case "µ": innerfaktor = 1E-6; break;
                            case "n": innerfaktor = 1E-9; break;
                            case "p": innerfaktor = 1E-12; break;
                            case "f": innerfaktor = 1E-15; break;
                            case "a": innerfaktor = 1E-18; break;
                            case "z": innerfaktor = 1E-21; break;
                            case "y": innerfaktor = 1E-24; break;                       
                            default: innerfaktor = 1;
                        }
                    
                        
                    } else {
                        faktor = NaN;
                    }
                }
                if(data[1] < 0) {
                    add = -1;
                } else {
                    add = 1;
                }
                
                switch(data[0]){
                    case "Hz":    //Hertz
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.s -= add;
                        }
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                    break;

                    case "g":    //Gramm
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.kg += add;
                        }
                        faktor = faktor * Math.pow(0.001 * innerfaktor,data[1]);
                    break;
                    
                    case "N":   //Newton
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.kg += add;
                            result.m += add;
                            result.s -= add;
                            result.s -= add;                                   
                        }
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                    break;
                    
                    case "J":   //Joule
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.kg += add;
                            result.m += add;
                            result.m += add;
                            result.s -= add;
                            result.s -= add;                                          
                        } 
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);   
                    break;
                    
                 case "W":  //Watt
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.kg += add;
                            result.m += add;
                            result.m += add;
                            result.s -= add;
                            result.s -= add;
                            result.s -= add;                        
                        }
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                    break;
                    
                    case "F": // Farad
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.A += add;
                            result.A += add;
                            result.s += add;
                            result.s += add;
                            result.s += add;
                            result.s += add;
                            result.kg -= add;
                            result.m -= add;
                            result.m -= add;
                        }
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                    break;
                    
                    
                    case "C": // Coulomb
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.A += add;
                            result.s += add;                                                    
                        }
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                    break;
                    
                    case "V": // Volt
                        for(let j = 0; j < Math.abs(data[1]); j++) {                        
                            result.kg += add;
                            result.m += add;
                            result.m += add; 
                            result.A -= add;                                     
                            result.s -= add;                                     
                            result.s -= add;                                     
                            result.s -= add;                                                                                       
                        } 
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);                    
                    break;
                    
                    case "Ohm": // Ohm
                    case "Ω":
                    case "ohm":
                        for(let j = 0; j < Math.abs(data[1]); j++) {                                                      
                            result.kg += add;
                            result.m += add;
                            result.m += add;
                            result.A -= add;
                            result.A -= add;
                            result.s -= add;
                            result.s -= add;
                            result.s -= add;                                                 
                        }
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                    break;
                    
                    case "S": // Siemens
                        for(let j = 0; j < Math.abs(data[1]); j++) {                            
                            result.A += add;
                            result.A += add;
                            result.s += add;
                            result.s += add;
                            result.s += add;
                            result.kg -= add;
                            result.m -= add;
                            result.m -= add;                                                        
                        }   
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);                 
                    break;
                    
                    case "Wb": // Weber
                        for(let j = 0; j < Math.abs(data[1]); j++) {                           
                            result.kg += add;
                            result.m += add;
                            result.m += add;
                            result.A -= add;
                            result.s -= add;
                            result.s -= add;

                        }
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);                    
                    break;
                    
                    case "T": // Tesla
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                             result.kg += add;
                             result.A -= add;
                             result.s -= add;
                             result.s -= add;
                        }       
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);             
                    break;
                    
                case "Gs": // Gauss
                        for(let j = 0; j < Math.abs(data[1]); j++) {                            
                            result.kg += add;
                            result.A -= add;
                            result.s -= add;
                            result.s -= add;             
                        }   
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);                                     
                    break;
                    
                    case "H": // Henry
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.kg += add;
                            result.m += add;
                            result.m += add;
                            result.A -= add;
                            result.A -= add;
                            result.s -= add;
                            result.s -= add;
                        }
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                    break;
                    
                    case "lx": // Lux
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.cd += add;
                            result.m -= add;
                            result.m -= add;                        
                        }
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                    break;

                    
                    case "atm": // Atmosphäre
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.kg += add;
                            result.m -= add;
                            result.s -= add;
                            result.s -= add;

                        }
                        faktor = faktor * Math.pow(101325 * innerfaktor,data[1]);
                    break;
                    
                    
                    
                    case "bar":  //bar
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.kg += add;
                            result.m -= add;
                            result.s -= add;
                            result.s -= add;
                        }
                        faktor = faktor * Math.pow(100000 * innerfaktor,data[1]);
                    break;


                    case "Pa":  //Pascal
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.kg += add;
                            result.m -= add;
                            result.s -= add;
                            result.s -= add;
                        }
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                    break;
                    
                    case "l": //Liter
                    case "L":
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.m += add;
                            result.m += add;
                            result.m += add;
                        }
                        faktor = faktor * Math.pow(0.001 * innerfaktor,data[1]);
                    break;
                                        
                    
                    case "Bq": //Becquerel
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.s -= add;
                        }
                        faktor = faktor * Math.pow(0.001 * innerfaktor,data[1]);
                    break;
                    
                    case "Gy": //Gray
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.m += add;
                            result.m += add;
                            result.s -= add;
                            result.s -= add;
                        }
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                    break;
                    
                    case "Sv": //Sievert
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.m += add;
                            result.m += add;
                            result.s -= add;
                            result.s -= add;
                        }
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                    break;
                    
                    case "kat": //katalytische Einheit
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.mol += add;
                            result.s -= add;
                        }
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                    break;

                    case "cal": //Kalorie
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.kg += add;
                            result.m += add;
                            result.m += add;
                            result.s -= add;
                            result.s -= add;
                        }
                        faktor = faktor * Math.pow(4.1897 * innerfaktor,data[1]);
                    break;

                    case "d": //Tag
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.s += add;                           
                        }
                        faktor = faktor * Math.pow(86400 * innerfaktor,data[1]);
                    break;

                    case "h": //Stunde
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.s += add;                           
                        }
                        faktor = faktor * Math.pow(3600 * innerfaktor,data[1]);
                    break;

                    case "min": //Minute
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.s += add;                           
                        }
                        faktor = faktor * Math.pow(60 * innerfaktor,data[1]);
                    break;

                    case "var": //Var (Voltampere)
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.A += add;  
                            result.kg += add;
                            result.m += add;
                            result.m += add; 
                            result.A -= add;                                     
                            result.s -= add;                                     
                            result.s -= add;                                     
                            result.s -= add;                               
                        }
                        faktor = faktor * Math.pow(60 * innerfaktor,data[1]);
                    break;

                    case "Wh": //Wattstunde
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.s += add; 
                            result.kg += add;
                            result.m += add;
                            result.m += add;
                            result.s -= add;
                            result.s -= add;
                            result.s -= add;                           
                        }
                        faktor = faktor * Math.pow(3600 * innerfaktor,data[1]);
                    break;

                    case "t": //Tonne
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.kg += add;                           
                        }
                        faktor = faktor * Math.pow(1000 * innerfaktor,data[1]);
                    break;

                    case "eV": //Elektronenvolt
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.kg += add;
                            result.m += add;
                            result.m += add;
                            result.s -= add;
                            result.s -= add;                          
                        }
                        faktor = faktor * Math.pow(1.602176634E-19 * innerfaktor,data[1]);
                    break;

                    case "u": //Atomare Masseneinheit & Dalton                    
                    case "Da": //Dalton
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.kg += add;                           
                        }
                        faktor = faktor * Math.pow(1.66053906660E-27* innerfaktor,data[1]);
                    break;

                    case "°C":
                        for(let j = 0; j < Math.abs(data[1]); j++) {                            
                            result.Celsius += add;                                                  
                        }
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                    break;

                    case "cd": //Candela
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result.lm += add;       
                            //result.sr -= add; -> 1
                        }
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                    break;

                    case "rad": //Radiant
                        // -> 1
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                    break;

                    case "sr": //Steradiant
                        // -> 1
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                    break;

                    
                    
                    case "":{

                    }
                    break;    

                    default:
                        for(let j = 0; j < Math.abs(data[1]); j++) {
                            result[data[0]] += add;                            
                        }
                        faktor = faktor * Math.pow(1 * innerfaktor,data[1]);
                }
                
            }

            //Umrechungsfaktor anhaengen
            result.factor = faktor; 
            
        }
        
        return result;
    }

    static unitcheck(value){
        let units = value;
        units = units.trim();
      /*  units = units.replace("*"," ");
        units = units.replace(/\s+/g," ");
        units = units.replace("^ ","^");*/

        //for division sign / 
        units = units.replaceAll(' ','');
        units = units.replaceAll(/([\/\*])?([a-zA-Z]+)([\/\*]|$)/g,'$1$2^+1$3'); // x -> x^+1        
        units = units.replaceAll(/(\^)([0-9]+)/g,'$1+$2'); // x^a -> x^+a        
        units = units.replaceAll(/[\/]([a-zA-Z]+)(\^\+)+([0-9])*/g,'*$1^-$3'); // /x^+a --> *x^-a
        units = units.replaceAll(/[\/]([a-zA-Z]+)(\^\-)+([0-9])*/g,'*$1^+$3'); // /x^-a --> *x^+a
        units = units.replaceAll('+','');

        var notallowed = ["(",")","[","]","\\"];
        var msg = "";
        for(var i = 0; i < notallowed.length; i++){
            if(units.indexOf(notallowed[i]) > -1) msg = msg + "<br/>"+notallowed[i];
        }
        if(msg != "") msg = "Eingabefehler Einheit: unzulaessige Zeichen" + msg;

        
        if(msg == ""){
            var unitArr = units.split("*");
            
            //not allowed unit?
            for(let i = 0; i < unitArr.length; i++){
                let data = unitArr[i].split("^");
             
                if(UnitCalculator.unitallowed.indexOf(data[0].trim()) == -1 && data[0].trim() != "") {
                    //has prefix?
                    if(!(UnitCalculator.unitprefix.indexOf(data[0].trim()[0]) > -1 && UnitCalculator.unitallowed.indexOf(data[0].trim().substring(1)) > -1) && !(UnitCalculator.unitprefix.indexOf(data[0].trim().substring(0,2)) > -1 && UnitCalculator.unitallowed.indexOf(data[0].trim().substring(2)) > -1)){
                        msg = msg + "<br/>" +data[0];    
                        //console.log(data[0]);
                    }  
                }   
            }
            if(msg != "") msg = "Einheit nicht erkannt; Einheiten werden mit Leerzeichen voneinander getrennt:" + msg + '<br/><br/> <a href="./units.php" target="_blank">Liste unterstuetzter Einheiten</a>';
            
            if(msg == ""){
                // invalid exponent
                for(var i = 0; i < unitArr.length; i++){
                    let data = unitArr[i].split("^");            
                    if(data.length == 2) {                        
                        var expo = parseInt(data[1]);
                        if(isNaN(expo) || expo.toString().length != data[1].trim().length){
                            msg = msg + "<br/>" + data[1];
                        }

                    }
                }
                if(msg != "") msg = msg + "Ungueltiger Exponent:<br/>" + msg;
            }
            
            
            
        }      
        
        return msg;
    }

    static undo(){
        if(UnitCalculator.undoIndex > 0){
            if(UnitCalculator.undoArr[UnitCalculator.undoIndex-1].indexOf('+') == 0){
                UnitCalculator.value[UnitCalculator.undoArr[UnitCalculator.undoIndex-1].substring(1)]--; 
            } else {
                UnitCalculator.value[UnitCalculator.undoArr[UnitCalculator.undoIndex-1].substring(1)]++; 
            }
            UnitCalculator.undoIndex--;
            UnitCalculator.draw();  
            UnitCalculator.calculator.querySelector('.edml-unitcalculator-redo').classList.remove('disabled');          
        } 
        if(UnitCalculator.undoIndex == 0)  UnitCalculator.calculator.querySelector('.edml-unitcalculator-undo').classList.add('disabled');
    
    }


    static redo(){
        if(UnitCalculator.undoIndex < UnitCalculator.undoArr.length){
            if(UnitCalculator.undoArr[UnitCalculator.undoIndex].indexOf('+') == 0){
                UnitCalculator.value[UnitCalculator.undoArr[UnitCalculator.undoIndex].substring(1)]++; 
            } else {
                UnitCalculator.value[UnitCalculator.undoArr[UnitCalculator.undoIndex].substring(1)]--; 
            }
            UnitCalculator.undoIndex++;
            UnitCalculator.draw();   
            UnitCalculator.calculator.querySelector('.edml-unitcalculator-undo').classList.remove('disabled');                 
        } 
        if(UnitCalculator.undoIndex == UnitCalculator.undoArr.length) UnitCalculator.calculator.querySelector('.edml-unitcalculator-redo').classList.add('disabled');
    }

    


}
class ExpressionCalculator{

    static calculator = null;
    static input = null;
    static lastKnownScrollPosition = 0;
    static value = "";
    static cursorpos = 0;
    static renderTimer = null;
    static fnblock = 1;


    static create(){
        if(ExpressionCalculator.calculator == null){
            ExpressionCalculator.calculator = document.createElement('div');
            ExpressionCalculator.calculator.classList.add('edml-expressioncalculator');
            document.querySelector('edml-course').append(ExpressionCalculator.calculator);    


            let buttonClose = document.createElement('button');
            buttonClose.innerText = "X";                   
            buttonClose.classList.add('edml-expressioncalculator-close');         
            ExpressionCalculator.calculator.append(buttonClose);

            buttonClose.addEventListener('click',function(){
                ExpressionCalculator.hide();     
            });

            let display = document.createElement('div');
            display.classList.add('edml-expressioncalculator-display');
            ExpressionCalculator.calculator.append(display);

            //m (part of display)
            var mtag = new edML_M();
            mtag.classList.add('edml-expressioncalculator-m');
            mtag.classList.add('hide');
            display.append(mtag);

            //contentditable div (part of display)
            var div = document.createElement('div');
            div.innerText = ExpressionCalculator.value;
            div.classList.add('edml-expressioncalculator-value');
            div.classList.add('hide');
            var caret = document.createElement('span');
            caret.classList.add('edml-expressioncalculator-caret');
            div.prepend(caret);
            //div.contentEditable = "true";
            //div.readOnly  = "true";
            //div.setAttribute("readonly","true");
            //div.addEventListener('blur',function(evt){evt.preventDefault()});
            //div.addEventListener('click',function(evt){evt.preventDefault()});
            display.append(div);

            
            //clear button
            let buttonCLR = document.createElement('div');
            buttonCLR.innerText = "CLR";       
            buttonCLR.classList.add('edml-expressioncalculator-button'); 
            buttonCLR.classList.add('edml-expressioncalculator-clr'); 
            buttonCLR.setAttribute('title',document.edmllocale.get("expressioncalculator.clr")); 
            ExpressionCalculator.calculator.append(buttonCLR);

            
            buttonCLR.addEventListener('click',function(){                
                ExpressionCalculator.value = "";
                ExpressionCalculator.renderValue();
                ExpressionCalculator.cursorpos = 0;
            });



            //left, right, del button
            let buttonLeft = document.createElement('div');
            buttonLeft.innerText = "x";       
            buttonLeft.classList.add('edml-expressioncalculator-button'); 
            buttonLeft.classList.add('edml-expressioncalculator-left'); 
            buttonLeft.classList.add('edml-expressioncalculator-edmlfont');             
            buttonLeft.classList.add('disabled'); 
            buttonLeft.classList.add('small'); 
            buttonLeft.setAttribute('title',document.edmllocale.get("expressioncalculator.left")); 
            //ExpressionCalculator.calculator.append(buttonLeft);
            buttonLeft.addEventListener('click',ExpressionCalculator.left.bind(this));


            let buttonRight = document.createElement('div');
            buttonRight.innerText = "y";       
            buttonRight.classList.add('edml-expressioncalculator-button'); 
            buttonRight.classList.add('edml-expressioncalculator-edmlfont'); 
            buttonRight.classList.add('edml-expressioncalculator-right'); 
            buttonRight.classList.add('disabled'); 
            buttonRight.classList.add('small'); 
            buttonRight.setAttribute('title',document.edmllocale.get("expressioncalculator.right")); 
            //ExpressionCalculator.calculator.append(buttonRight);
            buttonRight.addEventListener('click',ExpressionCalculator.right.bind(this));


            let buttonDel = document.createElement('div');
            buttonDel.innerText = "del";       
            buttonDel.classList.add('edml-expressioncalculator-button'); 
            buttonDel.classList.add('edml-expressioncalculator-del'); 
            buttonDel.classList.add('disabled');
            buttonDel.classList.add('small');  
            buttonDel.setAttribute('title',document.edmllocale.get("expressioncalculator.del")); 
            buttonDel.setAttribute('value',"del"); 


            //first page
            var page01 = document.createElement('div');
            page01.classList.add('edml-expressioncalculator-page01');
            ExpressionCalculator.calculator.append(page01);

            //second page (a b c etc.)
            var page02 = document.createElement('div');
            page02.classList.add('edml-expressioncalculator-page02');
            ExpressionCalculator.calculator.append(page02);

            //numbers
            var decsep = ".";
            if(edMLPlayer_Config.get("course.decimalseparator") == ",") decsep = ",";

            let numberblock = document.createElement('div');
            numberblock.classList.add('edml-expressioncalculator-numberblock');
            page01.append(numberblock);
            var numbers = ["7","8","9","&#247;","4","5","6","&times;","1","2","3","&minus;","0",decsep,"^","+"];            
            for(var i = 0; i < numbers.length; i++ ){
                var number = document.createElement('div');
                number.classList.add('edml-expressioncalculator-button');
                number.setAttribute('value',numbers[i]);
                number.innerHTML = numbers[i];
                numberblock.append(number);
            }

            // ( ), abc and ok
            let rightblock = document.createElement('div');
            rightblock.classList.add('edml-expressioncalculator-rightblock');
            page01.append(rightblock);
            var rightsymbols = ["(",")","abc","ok"];            
            for(var i = 0; i < rightsymbols.length; i++ ){
                var symbol = document.createElement('div');
                symbol.classList.add('edml-expressioncalculator-button');
                symbol.setAttribute('value',rightsymbols[i]);
                symbol.innerHTML = rightsymbols[i];
                rightblock.append(symbol);
            }




            //functions block1
            let fnblock1 = document.createElement('div');
            fnblock1.classList.add('edml-expressioncalculator-fnblock');
            fnblock1.classList.add('edml-expressioncalculator-fnblock1');
            fnblock1.classList.add('show');
            page01.append(fnblock1);
            var fnsymbols1 = ["sin","cos","ln","log","exp","&Sqrt;","..."];            
            for(var i = 0; i < fnsymbols1.length; i++ ){
                var symbol = document.createElement('div');
                symbol.classList.add('edml-expressioncalculator-button');
                symbol.classList.add('small');
                symbol.classList.add('fnblock1');
                symbol.setAttribute('value',fnsymbols1[i]);
                symbol.innerHTML = fnsymbols1[i];
                fnblock1.append(symbol);
            }

            //functions block2
            let fnblock2 = document.createElement('div');
            fnblock2.classList.add('edml-expressioncalculator-fnblock');
            fnblock2.classList.add('edml-expressioncalculator-fnblock2');
            page01.append(fnblock2);
            var fnsymbols2 = ["tan","asin","acos","atan","sinh","cosh","..."];            
            for(var i = 0; i < fnsymbols2.length; i++ ){
                var symbol = document.createElement('div');
                symbol.classList.add('edml-expressioncalculator-button');
                symbol.classList.add('small');
               symbol.classList.add('fontsmall');

                symbol.classList.add('fnblock1');
                symbol.setAttribute('value',fnsymbols2[i]);
                symbol.innerHTML = fnsymbols2[i];
                fnblock2.append(symbol);
            }


            // calculator buttons + constants
            let constblock = document.createElement('div');
            constblock.classList.add('edml-expressioncalculator-constantblock');            
            constblock.append(buttonLeft);
            constblock.append(buttonRight);
            constblock.append(buttonDel);

            ExpressionCalculator.calculator.append(constblock);
            var constsymbols = ["&pi;","&#8455;","i","!"];            
            for(var i = 0; i < constsymbols.length; i++ ){
                var symbol = document.createElement('div');
                symbol.classList.add('edml-expressioncalculator-button');
                symbol.classList.add('small');
                symbol.setAttribute('value',constsymbols[i]);
                symbol.innerHTML = constsymbols[i];
                constblock.append(symbol);
            }

            let letterblock = document.createElement('div');
            letterblock.classList.add('edml-expressioncalculator-letterblock');
            var lettersymbols = ["[","]","(",")","&comma;","&#1477;",";","^","&#247;","*","-","+","","123","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","&#8679;","ok"];            
            for(var i = 0; i < lettersymbols.length; i++ ){
                if(lettersymbols[i] != ""){
                    var symbol = document.createElement('div');
                    symbol.classList.add('edml-expressioncalculator-button');
                    symbol.classList.add('small');
                    symbol.setAttribute('value',lettersymbols[i]);
                    symbol.innerHTML = lettersymbols[i];
                    letterblock.append(symbol);
                } else letterblock.append(document.createElement('span'));
            }

            page02.append(letterblock);


            ExpressionCalculator.calculator.querySelectorAll('.edml-expressioncalculator-button').forEach(function(item){
                item.addEventListener('click',function(){
                    if(this.getAttribute("value") != null){
                        ExpressionCalculator.processKey(this.getAttribute("value"));
                    }
                });
            });


            //drag-Event   
                //touch
            ExpressionCalculator.calculator.addEventListener('touchstart', function (event) {
                ExpressionCalculator.dialogX = event.touches[0].clientX;
                ExpressionCalculator.dialogY = event.touches[0].clientY;                          
                event.stopPropagation();
                ExpressionCalculator.calculator.addEventListener('touchmove', ExpressionCalculator.dialogDrag);
                ExpressionCalculator.calculator.addEventListener('touchend', ExpressionCalculator.dialogDragEnd);
            }.bind(this));
                //mouse
            ExpressionCalculator.calculator.addEventListener('mousedown', function (event) {
                ExpressionCalculator.dialogX = event.clientX;
                ExpressionCalculator.dialogY = event.clientY;                          
                event.stopPropagation();                                
                window.addEventListener('mousemove', ExpressionCalculator.dialogDrag);
               
                window.addEventListener('mouseup', ExpressionCalculator.dialogDragEnd);
            }.bind(this));
        }
    }

    static dialogDrag(evt){
        var clientX = evt.clientX;
        var clientY = evt.clientY;
        if(evt.touches != null && evt.touches[0] != null){
            clientX = evt.touches[0].clientX;
            clientY = evt.touches[0].clientY;
            evt.stopPropagation();
        }
        let diffx = clientX - ExpressionCalculator.dialogX;
        let diffy = clientY - ExpressionCalculator.dialogY;
        ExpressionCalculator.calculator.style.top = (ExpressionCalculator.calculator.offsetTop + diffy) + "px";
        ExpressionCalculator.calculator.style.left = (ExpressionCalculator.calculator.offsetLeft + diffx) + "px";
        ExpressionCalculator.dialogX = clientX;
        ExpressionCalculator.dialogY = clientY;
       // UnitCalculator.calculator.style.width = UnitCalculator.dialogWidth + "px";
    }

    static dialogDragEnd(evt){
        window.removeEventListener('mouseup',ExpressionCalculator.dialogDragEnd);
        window.removeEventListener('mousemove',ExpressionCalculator.dialogDrag);
        //UnitCalculator.dialogWidth = null;
    }


    static show(input){
        ExpressionCalculator.create();
        ExpressionCalculator.hide();
        ExpressionCalculator.input = input;

        ExpressionCalculator.value = ""; 
        if(input != null && input.querySelector('.edml-expression-input') != null) {
            ExpressionCalculator.value = input.querySelector('.edml-expression-input').value;
            ExpressionCalculator.renderValue();
            ExpressionCalculator.cursorpos = ExpressionCalculator.value.length;
        }

        ExpressionCalculator.positioning();
        ExpressionCalculator.calculator.classList.add('active');

        ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-page01').classList.add('active');
        ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-page02').classList.remove('active');

        window.addEventListener('keydown',ExpressionCalculator.onKeyDown);
    }

    static onKeyDown(evt){ 
        var key = evt.key;
        if(key != "F5" && key != "F1" && key != "F2" && key != "F3" && key != "F4" && key != "F6" && key != "F7" && key != "F8" && key != "F9" && key != "F10" && key != "F11" &&key != "F12") evt.preventDefault();               
        if(key.toLowerCase() == "backspace") {
            key = "del";  
        }
        console.log(key);

        if(key.toLowerCase() == "arrowleft" ) {
            ExpressionCalculator.left();
            ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-left').classList.add('active');
                window.setTimeout(function(){
                    ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-left').classList.remove('active');
                },200);
        } else if(key.toLowerCase() == "arrowright") {
            ExpressionCalculator.right();  
            ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-right').classList.add('active');
                window.setTimeout(function(){
                    ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-right').classList.remove('active');
                },200);      
        } else {
            let skey = key;
            if(skey == "*"){
                skey == "&times;";
            } else if(skey == "e"){
                skey = "&#8455;";
            } else if(skey == "-"){
                skey = "&minus;";
            } else if(skey == "/"){
                skey = "&#247;";
            }
            if(ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-button[value="'+skey+'"]') != null){
                ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-button[value="'+skey+'"]').classList.add('active');
                window.setTimeout(function(){
                    ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-button[value="'+skey+'"]').classList.remove('active');
                },200);
            }
            ExpressionCalculator.processKey(key);
        }
    }

    static processKey(key){
        switch(key){
            case "ok": 
                ExpressionCalculator.input.querySelector('.edml-expression-input').value = ExpressionCalculator.value;    
                let evt = new KeyboardEvent('keyup',{'key':' '});            
                evt.calculator = true;    
                ExpressionCalculator.input.querySelector('.edml-expression-input').dispatchEvent(evt);          
                ExpressionCalculator.hide(); 
                key = "";              
            break;
            case "...": 
                ExpressionCalculator.fnblock++;
                if(ExpressionCalculator.fnblock > 2) ExpressionCalculator.fnblock = 1;
                if(ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-fnblock.show') != null) ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-fnblock.show').classList.remove('show');
                ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-fnblock'+ExpressionCalculator.fnblock).classList.add('show');
                key = "";
            break;

            case "abc": ExpressionCalculator.turnpage(); key = ""; break;
            case "123": ExpressionCalculator.turnpage(); key = ""; break;
            case "&#8679;": ExpressionCalculator.caseSwitch(); key = ""; break;
            case "sin": key = "sin("; break;
            case "cos": key = "cos("; break;
            case "tan": key = "tan("; break;
            case "ln": key = "ln("; break;
            case "log": key = "log10("; break;
            case "exp": key = "exp("; break;
            case "&Sqrt;":  key = "sqrt("; break;
            case "asin":  key = "asin("; break;
            case "acos":  key = "acos("; break;
            case "atan":  key = "atan("; break;
            case "sinh":  key = "sinh("; break;
            case "cosh":  key = "cosh("; break;
            case "!": key = "factorial("; break;                        
            case "&times;": key = "*"; break;
            case "&pi;": key = "pi"; break;
            case "&#247;": key = "/"; break;
            case "&minus;": key = "-"; break;        
            case "&#8455;": key = "e"; break;             
            case "&#1477;": key = "."; break;
            case "&comma;": key = ","; break;
            case "ok": key = ""; break;            
            case ".": break; // key = key
            case "del": break;
            case ",": break;
            case ";": break;
            case "0": break;
            case "1": break;
            case "2": break;
            case "3": break;
            case "4": break;
            case "5": break;
            case "6": break;
            case "7": break;
            case "8": break;
            case "9": break;
            case "a": break;
            case "b": break;
            case "c": break;
            case "d": break;
            case "e": break;              
            case "f": break;              
            case "g": break;              
            case "h": break;              
            case "i": break;              
            case "j": break;              
            case "k": break;              
            case "l": break;              
            case "m": break;              
            case "n": break;              
            case "o": break;              
            case "p": break;              
            case "q": break;              
            case "r": break;              
            case "s": break;              
            case "t": break;              
            case "u": break;              
            case "v": break;              
            case "w": break;              
            case "x": break;              
            case "y": break;              
            case "z": break; 
            case "A": break;                
            case "B": break;  
            case "C": break;  
            case "D": break;  
            case "E": break;  
            case "F": break;  
            case "G": break;  
            case "H": break;  
            case "I": break;  
            case "J": break;  
            case "K": break;  
            case "L": break;  
            case "M": break;  
            case "N": break;  
            case "O": break;  
            case "P": break;  
            case "Q": break;  
            case "R": break;  
            case "S": break;  
            case "T": break;  
            case "U": break;  
            case "V": break;  
            case "W": break;  
            case "X": break;  
            case "Y": break;  
            case "Z": break;  
            case "(": break;              
            case ")": break;              
            case "+": break;              
            case "-": break;              
            case "/": break; 
            case "^": break;             
            case "[": break;             
            case "]": break;             
            case "*": break;  // key = key             
            default: key = "";  
            
        }
        if(key == "del"){
            if(ExpressionCalculator.cursorpos > 0){
                ExpressionCalculator.value = ExpressionCalculator.value.substring(0,ExpressionCalculator.cursorpos-1) + ExpressionCalculator.value.substring(ExpressionCalculator.cursorpos);
                ExpressionCalculator.cursorpos--;
            }            
        } else {
            ExpressionCalculator.value = ExpressionCalculator.value.substring(0,ExpressionCalculator.cursorpos) + key + ExpressionCalculator.value.substring(ExpressionCalculator.cursorpos);
            ExpressionCalculator.cursorpos += key.length;
        }
        if(ExpressionCalculator.renderTimer != null) clearTimeout(ExpressionCalculator.renderTimer);
        ExpressionCalculator.renderTimer = window.setTimeout(ExpressionCalculator.renderValue(),500);

    }

    static renderValue(){
        //display in plain text
        var display = ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-display');
        var m = display.querySelector('.edml-expressioncalculator-m');   
        var div = display.querySelector('.edml-expressioncalculator-value'); 
        
        m.classList.add('hide');
        div.classList.remove('hide');
        div.innerText = ExpressionCalculator.value;
        
        div.focus();
        ExpressionCalculator.setCaretPosition(div);

        if(ExpressionCalculator.renderMTimer != null) clearTimeout(ExpressionCalculator.renderMTimer);
        ExpressionCalculator.renderMTimer = window.setTimeout(function(){ExpressionCalculator.renderValueM()},1500); //display MathJax after 1500 s
        
    }

    static renderValueM(){
        //tries to display with MathJax
        var display = ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-display');
        var m = display.querySelector('.edml-expressioncalculator-m');  
        var div = display.querySelector('.edml-expressioncalculator-value'); 
        ExpressionCalculator.renderMTime = null;

        try{
            var latex = nerdamer.convertToLaTeX(ExpressionCalculator.value);                        
            latex = latex.replaceAll('ln(','\ln(');     
            latex = latex.replaceAll('\\frac{',"\\dfrac{");
            
            m.querySelector(':scope > .edml-m-inner').innerHTML = "#$# " + latex + " #$#";
            m.classList.remove('rendered');
            m.classList.remove('hide');
            div.classList.add('hide');   
            
            if(window.MathJax) {
                edMLPlayer_Util.typesetMath(display);
            }  
        } catch(err){

        }
    }

    static hide(){
        ExpressionCalculator.value = "";
        if(ExpressionCalculator.calculator != null) ExpressionCalculator.calculator.classList.remove('active');
        window.removeEventListener('keydown',ExpressionCalculator.onKeyDown);
    }

    static setCaretPosition(div){
        div.innerHTML = "";
        var txtNodeLeft = document.createTextNode(ExpressionCalculator.value.substring(0,ExpressionCalculator.cursorpos));        
        div.append(txtNodeLeft);
        
        var caret = document.createElement('span');
        caret.classList.add('edml-expressioncalculator-caret');
        div.append(caret);

        var txtNodeRight = document.createTextNode(ExpressionCalculator.value.substring(ExpressionCalculator.cursorpos));        
        div.append(txtNodeRight);

    }

    static positioning(){    
        if(ExpressionCalculator.input != null){
            let diff = 0;
            let obj = ExpressionCalculator.input.parentNode; 
            let top;
            let left;
            let active = ExpressionCalculator.calculator.classList.contains('active');
            ExpressionCalculator.calculator.classList.add('active');
            let width = ExpressionCalculator.calculator.getBoundingClientRect().width;
            let height = ExpressionCalculator.calculator.getBoundingClientRect().height;
            if(!active) ExpressionCalculator.calculator.classList.remove('active');
                   
            if(document.querySelector('edml-page.active').offsetHeight-obj.getBoundingClientRect().bottom-document.querySelector('edml-variant.active').scrollTop < 350) diff = 350 - (document.querySelector('edml-page.active').offsetHeight-obj.getBoundingClientRect().bottom-document.querySelector('edml-variant.active').scrollTop);
            left = obj.getBoundingClientRect().left;
            if(left + width > window.innerWidth) left = window.innerWidth - width;
            if(left < 0) left = 0;
            ExpressionCalculator.calculator.style.left = left+"px";
            top = obj.getBoundingClientRect().bottom+8-diff;
            if(top + height > window.innerHeight) top = window.innerHeight - height;
            if(top < 0 ) top = 0;            
            ExpressionCalculator.calculator.style.top = (top)+"px";            
            ExpressionCalculator.lastKnownScrollPosition = obj.getBoundingClientRect().bottom+8;
        }

    }


    static turnpage(){
        if(ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-page01.active') == null){
            ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-page01').classList.add('active');
            ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-page02').classList.remove('active');
        } else {
            ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-page01').classList.remove('active');
            ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-page02').classList.add('active');
        }
    }

    static caseSwitch(){
        //toggles between lower and uppercase
        var btns = [...ExpressionCalculator.calculator.querySelectorAll('.edml-expressioncalculator-letterblock > .edml-expressioncalculator-button')];
        var toupperCase = true;
        var start = btns.indexOf(ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-letterblock > .edml-expressioncalculator-button[value="a"],.edml-expressioncalculator-letterblock > .edml-expressioncalculator-button[value="A"] '));
        var end = start + 26;
        if(btns[start].getAttribute('value') == btns[start].getAttribute('value').toUpperCase()) toupperCase = false;
        if(toupperCase){
            ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-letterblock > .edml-expressioncalculator-button[value="&#8679;"]').classList.add('pressed');   
        } else {
            ExpressionCalculator.calculator.querySelector('.edml-expressioncalculator-letterblock > .edml-expressioncalculator-button[value="&#8679;"]').classList.remove('pressed');   
        }
        for(var i = start; i < end; i++){
            if(toupperCase){
                btns[i].setAttribute('value',btns[i].getAttribute('value').toUpperCase()); 
                btns[i].innerText = btns[i].innerText.toUpperCase();               
            } else {
                btns[i].setAttribute('value',btns[i].getAttribute('value').toLowerCase());                
                btns[i].innerText = btns[i].innerText.toLowerCase();               
            }
        }
    }

    static left(){
        if(ExpressionCalculator.cursorpos > 0) ExpressionCalculator.cursorpos--;
        ExpressionCalculator.renderValue();
    }

    static right(){
        if(ExpressionCalculator.cursorpos < ExpressionCalculator.value.length) ExpressionCalculator.cursorpos++;
        ExpressionCalculator.renderValue();
    }

 
}
class edML_Loader{

    constructor(){
        this.loader = document.createElement('div');
        this.loader.classList.add("edmlplayer-loader");
        let block = document.createElement('div');
        block.classList.add("edmlplayer-loader-block");
        let text = document.createElement('div');
        text.classList.add('edmlplayer-loader-text');
        this.loader.append(block);
        this.loader.append(text);
        document.body.append(this.loader);
    }
    
    show(){       
        this.loader.classList.add('active');
    }
    
    hide(){
        this.loader.classList.remove('active');
    }
    
    setText(text){
        this.loader.querySelector('.edmlplayer-loader-text').innerText = text;    
        
    }
    
    getDiv(){
        return this.loader;
    }
}
class edML_Arrowbar{
    
    constructor(container){
        //if(document.querySelector('#edmlplayer-arrowbar') == null){
            //let arrowbar = document.createElement('div');
            //arrowbar.id = 'edmlplayer-arrowbar';
            //container.append(arrowbar);
            this.setTestmode(false);

            let prevchapter = document.createElement('div');
            prevchapter.id = 'edmlplayer-btn_prevchapter';
            prevchapter.setAttribute('role','button');
            prevchapter.setAttribute('aria-label',document.edmllocale.get('access_prevchapter'));
            prevchapter.setAttribute('tabindex',20);
            prevchapter.classList.add('edmlplayer-arrows');
            prevchapter.classList.add('edmlplayer-arrows-left');
            prevchapter.classList.add('hidden');

            let arrowpc = document.createElement('span');
            arrowpc.classList.add('edmlplayer-arrow-chapter-left');
            prevchapter.append(arrowpc);
        
            container.append(prevchapter);
            
            
            let prev = document.createElement('div');
            prev.id = 'edmlplayer-btn_prev';  
            prev.setAttribute('role','button');
            prev.setAttribute('aria-label',document.edmllocale.get('access_previous'));
            prev.setAttribute('tabindex',20);          
            prev.classList.add('edmlplayer-arrows');
            prev.classList.add('edmlplayer-arrows-left');
            prev.classList.add('hidden');
            let arrowp = document.createElement('span');
            arrowp.classList.add('edmlplayer-arrow-left');
            prev.append(arrowp);                       
            container.append(prev);
            
            let next = document.createElement('div');
            next.id = 'edmlplayer-btn_next';
            next.setAttribute('role','button');
            next.setAttribute('aria-label',document.edmllocale.get('access_next'));
            next.setAttribute('tabindex',21);
            next.classList.add('edmlplayer-arrows');
            next.classList.add('edmlplayer-arrows-right');
            next.classList.add('hidden');
            let arrownxt = document.createElement('span');
            arrownxt.classList.add('edmlplayer-arrow-right');
            next.append(arrownxt);
            container.append(next);
            
            let nextchapter = document.createElement('div');
            nextchapter.id = 'edmlplayer-btn_nextchapter';
            nextchapter.setAttribute('role','button');
            nextchapter.setAttribute('aria-label',document.edmllocale.get('access_nextchapter'));
            nextchapter.setAttribute('tabindex',21);
            nextchapter.classList.add('edmlplayer-arrows');
            nextchapter.classList.add('edmlplayer-arrows-right');
            nextchapter.classList.add('hidden');

            let arrownxtc = document.createElement('span');
            arrownxtc.classList.add('edmlplayer-arrow-chapter-right');
            nextchapter.append(arrownxtc);
            container.append(nextchapter);
            
            
            //arrow bar events
            //next button, next chapter button etc. events
            document.getElementById('edmlplayer-btn_next').addEventListener('click',function(evt){
                evt.stopPropagation();
                let navitem = document.querySelector('edml-variant.active '+this.edmlnavigation+'.active '+this.edmlnavitem+'.selected');              
                if(navitem.querySelector(this.edmlnavitem+':not([visible="false"])') != null){
                    //click first visible sub navitem
                    navitem.querySelector(this.edmlnavitem+':not([visible="false"])').resetClick();
                    navitem.querySelector(this.edmlnavitem+':not([visible="false"])').click();
                } else {
                    //no subitem -> go next
                    while(navitem.nextElementSibling != null && navitem.nextElementSibling.getAttribute("visible") == "false"){
                        navitem = navitem.nextElementSibling;
                    }
                    if(navitem.nextElementSibling != null){
                        navitem.nextElementSibling.resetClick();
                        navitem.nextElementSibling.click();
                    }
                }
               
            }.bind(this));
    
    
            document.getElementById('edmlplayer-btn_prev').addEventListener('click',function(evt){
                evt.stopPropagation();
                let navitem = document.querySelector('edml-variant.active '+this.edmlnavigation+'.active '+this.edmlnavitem+'.selected');
                //go back if impressum or privacy
                if(navitem.getAttribute('roles') == "impressum" || navitem.getAttribute('roles') == "privacy"){
                    history.back();
                } else {

                    
                    while(navitem.previousElementSibling != null && (navitem.previousElementSibling.nodeName.toLowerCase() != this.edmlnavitem || navitem.previousElementSibling.getAttribute('visible') == "false")){               
                        navitem = navitem.previousElementSibling;
                    }      
                
                    if(navitem.previousElementSibling != null) {
                        let items = navitem.previousElementSibling.querySelectorAll(this.edmlnavitem+':not([visible="false"])');                               
                        if(items.length > 0) {
                            items[items.length-1].resetClick();
                            items[items.length-1].click();
                        } else {
                            navitem.previousElementSibling.resetClick();
                            navitem.previousElementSibling.click();
                        }
                        
                    } 
                }
                
            }.bind(this));
    
            document.getElementById('edmlplayer-btn_prevchapter').addEventListener('click',function(evt){
                evt.stopPropagation();    
                let startnavitem = document.querySelector('edml-variant.active '+this.edmlnavigation+'.active '+this.edmlnavitem+'.selected');            
                let navitem = document.querySelector('edml-variant.active '+this.edmlnavigation+'.active '+this.edmlnavitem+'.selected').previousElementSibling;
                while(navitem != null && (navitem.nodeName.toLowerCase() != this.edmlnavitem || navitem.getAttribute('visible') == "false")){
                    navitem = navitem.previousElementSibling;
                }
                if(navitem == null) navitem = document.querySelector('edml-variant.active '+this.edmlnavigation+'.active '+this.edmlnavitem+'.selected').parentNode;
                

                while(navitem != null && (!(navitem instanceof this.edmlnavitemclass) || navitem.querySelector(':scope > edml-title') != null || this.isSameRef2PageAsActive(navitem))){                    
                    if(navitem.previousElementSibling == null) {
                        navitem = navitem.parentNode;
                    } else {
                        navitem = navitem.previousElementSibling;
                    }
                }     
                           

                if(navitem != null) {
                    var lastsubnavitem = this.goToLastSubelement(navitem); 
                    var navs = [...document.querySelectorAll('edml-navitem')];
                    var idxstart = navs.indexOf(startnavitem);
                    var idxsub = navs.indexOf(lastsubnavitem);
                    if(lastsubnavitem.parentNode != startnavitem.parentNode && idxsub < idxstart) navitem = lastsubnavitem;                              
                    navitem.resetClick();
                    navitem.click();
                } else {
                    document.querySelector('edml-variant.active '+this.edmlnavigation+'.active '+this.edmlnavitem).resetClick();
                    document.querySelector('edml-variant.active '+this.edmlnavigation+'.active '+this.edmlnavitem).click();
                }
    
            }.bind(this));


            document.getElementById('edmlplayer-btn_nextchapter').addEventListener('click',function(evt){
                evt.stopPropagation();
                let navitem = document.querySelector('edml-variant.active '+this.edmlnavigation+'.active '+this.edmlnavitem+'.selected');
                
                while(navitem != null && this.getNextSibling(navitem) == null || (navitem != null && navitem.nextElementSibling != null && navitem.nextElementSibling.querySelector(this.edmlnavitem) == null && !(navitem instanceof this.edmlnavitemclass)) ){
                    navitem = navitem.parentNode;
                }
    
                if(navitem != null && navitem.nextElementSibling != null) {
                    let item = navitem.nextElementSibling;
                    if(!item instanceof this.edmlnavitemclass) item = navitem.querySelector(this.edmlnavitem);  
                                      
                    item.resetClick();
                    item.click();
                
                } else {
                   // console.log(this.edmlnavitem);
                    if(document.querySelector('edml-variant.active '+this.edmlnavigation+'.active .edml-navigation-backbutton') != null){
                        document.querySelector('edml-variant.active '+this.edmlnavigation+'.active .edml-navigation-backbutton').click();
                    } else {
                        document.querySelector('edml-variant.active '+this.edmlnavigation+'.active '+this.edmlnavitem).resetClick();
                        document.querySelector('edml-variant.active '+this.edmlnavigation+'.active '+this.edmlnavitem).click();
                    }
                }
    
            }.bind(this));
            
                    
//        }
        

        window.addEventListener('resize',this.resize);
        
    }

    isSameRef2PageAsActive(navitem){
        var result = false;

        if(navitem instanceof this.edmlnavitemclass){
            var finished = false;
            var to;
            var variant = navitem.closest('edml-variant');
            var obj;
            var page = variant.querySelector('edml-page.active');
            if(page == null) finished = true;
            
            while(finished == false){
                to = "";
                if(navitem.querySelector(':scope > edml-ref') != null) to = navitem.querySelector(':scope > edml-ref').getAttribute('to');                
                obj = variant.querySelector('*[name="'+to+'"');
                if(obj instanceof this.edmlnavitemclass){
                    navitem = obj;
                } else {
                    if(obj != null && obj.closest('edml-page') == page){
                        result = true;
                    }
                    finished = true;
                }
            }
        } 
        return result;
    }

    getNextSibling(navitem){
        let next = navitem.nextElementSibling;
        while(next != null && (next.nodeName.toLowerCase() != this.edmlnavitem || next.getAttribute('visible') == "false")){
            next = next.nextElementSibling;
        }
        return next;
    }

    goToLastSubelement(navitem){
        let oldnav = null;
        while(navitem.querySelector('edml-navitem, edml-testitem') != null && oldnav != navitem){
            oldnav = navitem;
            navitem = navitem.querySelector(':scope > * > edml-navitem:last-of-type, :scope > * > edml-testitem:last-of-type');
            if(this.isSameRef2PageAsActive(navitem)) navitem = oldnav;
            
        }
        return navitem;
    }

    resize(container){
        let page = container;
        if(page == null || container.type == "resize") page = document.querySelector('edm-variant.active edml-page.active');
        if(page != null) {
            document.querySelectorAll('.edmlplayer-arrows').forEach(function(item) {page.append(item)}); 
            if(!edMLPlayer_Config.get('navigation.staticarrowstest')) {
                document.querySelectorAll('.edmlplayer-arrows-right').forEach(function(item){
                     item.style.left = (page.getBoundingClientRect().left + page.offsetWidth - 3.5*parseInt(window.getComputedStyle(page, null).getPropertyValue('padding-left').replace('px',''))) + "px";
                });
            }

        } else {
            document.querySelectorAll('.edmlplayer-arrows').forEach(function(item) {
                if(document.querySelector('edml-variant.active edml-pages') != null) {
                    document.querySelector('edml-variant.active edml-pages').append(item);
                } else {
                    document.body.append(item);
                }
            });

        }
        
    }

    setTestmode(val){
        if(val) {
            this.edmlnavitem = 'edml-testitem';
            this.edmlnavigation = 'edml-test';
            this.edmlnavlist = 'edml-testlist';
            this.edmlnavitemclass = edML_Testitem;
            if(edMLPlayer_Config.get('navigation.staticarrowstest')) {
                document.querySelectorAll('.edmlplayer-arrows').forEach(function(item){
                    item.classList.add('static');
                });
            }

            if(edMLPlayer_Config.get('navigation.staticarrows')) {
                document.querySelectorAll('.edmlplayer-arrows').forEach(function(item){
                    item.classList.add('static');
                });
            }
                

        } else {
            this.edmlnavitem = 'edml-navitem';
            this.edmlnavigation = 'edml-navigation'; 
            this.edmlnavlist = 'edml-navlist';
            this.edmlnavitemclass = edML_Navitem;      
            if(edMLPlayer_Config.get('navigation.staticarrowstest')) {
                document.querySelectorAll('.edmlplayer-arrows').forEach(function(item){
                    item.classList.remove('static');
                });
            }

            if(edMLPlayer_Config.get('navigation.staticarrows')) {
                document.querySelectorAll('.edmlplayer-arrows').forEach(function(item){
                    item.classList.add('static');
                });
            }
        }
    }


    //show or hide next button, prev button etc.
    prevnextButton(){
        if(document.getElementById('edmlplayer-btn_prev') != null && document.getElementById('edmlplayer-btn_prevchapter') != null && document.getElementById('edmlplayer-btn_nextchapter') != null && document.getElementById('edmlplayer-btn_next') != null){ 
        
            document.getElementById('edmlplayer-btn_prev').classList.add('hidden');
            document.getElementById('edmlplayer-btn_prevchapter').classList.add('hidden');
            document.getElementById('edmlplayer-btn_nextchapter').classList.add('hidden');
            document.getElementById('edmlplayer-btn_next').classList.add('hidden');
            
                
            if(document.querySelector('edml-variant.active '+this.edmlnavigation+'.active') != null && document.querySelector('edml-variant.active '+this.edmlnavigation+'.active '+this.edmlnavitem+'.selected') != null){
                let navitem = document.querySelector('edml-variant.active '+this.edmlnavigation+'.active '+this.edmlnavitem+'.selected');        
                let previous = navitem.previousElementSibling;

                //impressum or privacy?
                if(navitem.getAttribute('roles') == "impressum" || navitem.getAttribute('roles') == "privacy"){
                    document.getElementById('edmlplayer-btn_prev').classList.remove('hidden');
                } else {
                
                    while(previous != null && (previous.tagName.toLowerCase() != this.edmlnavitem || previous.getAttribute('visible') == "false")) {
                        previous = previous.previousElementSibling;
                    }
                    let next = navitem.nextElementSibling;
                    while(next != null && (next.tagName.toLowerCase() != this.edmlnavitem || next.getAttribute('visible') == "false")) {
                        next = next.nextElementSibling;
                    }
                    

                    if(previous  == null){
                        document.getElementById('edmlplayer-btn_prevchapter').classList.remove('hidden');
                        document.getElementById('edmlplayer-btn_prev').classList.add('hidden');
                    } else {
                        document.getElementById('edmlplayer-btn_prevchapter').classList.add('hidden');
                        document.getElementById('edmlplayer-btn_prev').classList.remove('hidden');
                    }
            
                    if(next  == null && navitem.querySelector('edml-navitem:not([visible="false"])') == null){
                        document.getElementById('edmlplayer-btn_nextchapter').classList.remove('hidden');
                        document.getElementById('edmlplayer-btn_next').classList.add('hidden');
                    } else {
                        document.getElementById('edmlplayer-btn_nextchapter').classList.add('hidden');
                        document.getElementById('edmlplayer-btn_next').classList.remove('hidden');                
                    }
            
            
                    //at first navitem
                    if(navitem == document.querySelector('edml-variant.active '+this.edmlnavigation+'.active '+this.edmlnavitem)){
                        document.getElementById('edmlplayer-btn_prevchapter').classList.add('hidden');
                    }
            
                    //at last navitem
                    if(navitem == document.querySelector('edml-variant.active '+this.edmlnavigation+'.active').querySelectorAll(this.edmlnavitem)[document.querySelector('edml-variant.active '+this.edmlnavigation+'.active').querySelectorAll(this.edmlnavitem).length-1] || document.querySelector('edml-variant.active '+this.edmlnavigation+'.active').querySelectorAll(this.edmlnavitem).length == 0){
                        document.getElementById('edmlplayer-btn_nextchapter').classList.add('hidden');
                        document.getElementById('edmlplayer-btn_next').classList.add('hidden');
                    }

                    //learnpath?            
                    if(navitem.querySelector(':scope > '+this.edmlnavlist+' > '+this.edmlnavitem+'.learnpath') != null || navitem.classList.contains('learnpath')){
                        document.getElementById('edmlplayer-btn_nextchapter').classList.add('hidden');
                        document.getElementById('edmlplayer-btn_next').classList.add('hidden');           
                    }

                    if(navitem.classList.contains('learnpath')){
                        document.getElementById('edmlplayer-btn_prev').classList.add('hidden');
                        document.getElementById('edmlplayer-btn_prevchapter').classList.add('hidden');
                    }


                    // test?    
        
                    if(document.querySelector('edml-variant.active edml-test.active') != null && document.querySelector('edml-variant.active edml-test.active').getAttribute('navigation') == "forward"){                
                        document.getElementById('edmlplayer-btn_prev').classList.add('hidden');
                        document.getElementById('edmlplayer-btn_prevchapter').classList.add('hidden');
                    }

                    if(document.querySelector('edml-variant.active edml-test.active') != null && document.querySelector('edml-variant.active edml-test.active').getAttribute('navigation') == "none"){                    
                        document.getElementById('edmlplayer-btn_prev').classList.add('hidden');
                        document.getElementById('edmlplayer-btn_prevchapter').classList.add('hidden');
                        document.getElementById('edmlplayer-btn_nextchapter').classList.add('hidden');
                        document.getElementById('edmlplayer-btn_next').classList.add('hidden');           
                    }
                }
            }
        }
        

        
        
        

    }
    
    
}

var digitspattern = /^(?:[0-9]+(?:,[0-9]{3})*(?:\.[0-9]*)*|\.[0-9]+)/;


if(edMLPlayer_Config.get("course.decimalseparator") == ","){
  digitspattern = /^(?:[0-9]+(?:\{,\}[0-9]{3})*(?:\,[0-9]*)*|\,[0-9]+)/;  
}

if (/Mobi|Android/i.test(navigator.userAgent)) {
    // mobile!
    var mymacros = new Object();
    var loadArr = ["input/tex",'output/chtml', '[tex]/cancel','[tex]/color', '[tex]/mhchem','[tex]/textmacros', '[tex]/textcomp'];
    if(edMLPlayer_Config.get("player.mathjax.svg") == true) loadArr = ["input/tex",'output/svg', '[tex]/color', '[tex]/mhchem','[tex]/textmacros', '[tex]/textcomp'];
    if(edMLPlayer_Config.get('player.mathjax.diffoperatormacro') == true) mymacros.md = "\\mathrm{d}"; 
    MathJax = {
      loader: {load: loadArr},  //'ui/lazy',     ,'[tex]/tagFormat'
      startup: {
        elements: ['bxy'],
        document: null,
        typeset: false,
        processEscapes: false,
        pageReady: () => {let event = new Event('mathjaxloaded'); window.dispatchEvent(event);},

      },

      tex: {
        inlineMath:  [['#$#', '#$#']],
        packages: {'[+]': ['cancel','color','mhchem','textmacros']},   // ,'tagFormat'
        macros: mymacros,
        digits: digitspattern              
      },
      options:{
        ignoreHtmlClass: 'edml-course',
        renderActions: {
          last: [100000, function () {let event = new Event('mathjaxrendered'); window.dispatchEvent(event);return true;},'',false]  
        }
      },
    textmacros: {packages: {'[+]': ['textcomp']}},

    asciimath:{
      decimalsign: edMLPlayer_Config.get("course.decimalseparator")
    }

    };

    
} else {
    var mymacros = new Object();
    if(edMLPlayer_Config.get('player.mathjax.diffoperatormacro') == true) mymacros.md = "\\mathrm{d}"; 
    var loadArr = ["input/tex", 'output/chtml','[tex]/cancel','[tex]/color', '[tex]/mhchem','[tex]/textmacros', '[tex]/textcomp'];
    if(edMLPlayer_Config.get("player.mathjax.svg") == true) loadArr = ["input/tex",'output/svg', '[tex]/color','[tex]/mhchem','[tex]/textmacros', '[tex]/textcomp'];
    MathJax = {    
      loader: {load: loadArr}, //'ui/lazy',  ,'[tex]/tagFormat'
      startup: {
        elements: ['bxy'],
        document: null,
        typeset: false,
        processEscapes: false,
        pageReady: () => {let event = new Event('mathjaxloaded'); window.dispatchEvent(event);},

      },

      tex: {
        inlineMath: [['#$#', '#$#']],
        packages: {'[+]': ['cancel','color', 'mhchem','textmacros']},   // ,'tagFormat'
        macros: mymacros,
        digits: digitspattern
      },
      options:{
        ignoreHtmlClass: 'edml-course',
        renderActions: {
          last: [100000, function () {let event = new Event('mathjaxrendered'); window.dispatchEvent(event);return true;},'',false]  
        }
      },
      textmacros: {packages: {'[+]': ['textcomp']}},

      asciimath:{
        decimalsign: edMLPlayer_Config.get("course.decimalseparator")
      }
     

    };

}

  


//Titlebar

class edML_Titlebar{

    static additionalMenuEntries = new Array();
    
    constructor(frame,lang,title){
        this.titlebar = document.createElement('div');
        this.titlebar.classList.add('edmlplayer-titlebar');
        this.path = this.getScriptUrl('edmlplayer.js');
        frame.prepend(this.titlebar);
       /* this.titlebar.style.maxWidth = frame.offsetWidth+"px";
        window.onresize = function(){
            this.titlebar.style.maxWidth = frame.offsetWidth+"px";                
        }.bind(this);*/
        frame.querySelector('edml-course').prepend(this.titlebar);


        //Titlebar Brand
        let titlebarBrand = document.createElement('span');
        //titlebarBrand.innerText = document.querySelector('course').querySelector('title').innerText;
        titlebarBrand.classList.add('edmlplayer-titlebar-brand');
        this.titlebar.append(titlebarBrand);

        //Titlebar Title
        let titlebarTitle = document.createElement('edml-title');
        titlebarTitle.innerHTML = title;
        titlebarTitle.classList.add('edmlplayer-titlebar-title');
        this.titlebar.append(titlebarTitle);
        titlebarTitle.setAttribute('tabindex',1);
        titlebarTitle.setAttribute('role','banner');   
        titlebarTitle.setAttribute('label',title);    
        titlebarTitle.addEventListener('click',function(){
            if(document.querySelector('edml-course > edml-variant.active edml-navitem[roles="home"]') != null) {
                document.querySelector('edml-course > edml-variant.active edml-navitem[roles="home"]').click();
            }
        });
  


        //Titlebar Hamburger
        let titlebarHamburger = document.createElement('span');
        
        //titlebarBrand.innerText = document.querySelector('course').querySelector('title').innerText;
        titlebarHamburger.classList.add('edmlplayer-titlebar-hamburger');
        titlebarHamburger.setAttribute('tabindex',2);
        titlebarHamburger.setAttribute('role','menu');
        titlebarHamburger.addEventListener('keyup',this.onKeyUpHamburger.bind(this));
        this.titlebar.append(titlebarHamburger);
        
        this.hamburger = titlebarHamburger;

        let titlebarHamburgerLine01 = document.createElement('div');
        titlebarHamburgerLine01.classList.add('edmlplayer-titlebar-hamburger-line');
        titlebarHamburger.append(titlebarHamburgerLine01);
        let titlebarHamburgerLine02 = document.createElement('div');
        titlebarHamburgerLine02.classList.add('edmlplayer-titlebar-hamburger-line');
        titlebarHamburger.append(titlebarHamburgerLine02);
        let titlebarHamburgerLine03 = document.createElement('div');
        titlebarHamburgerLine03.classList.add('edmlplayer-titlebar-hamburger-line');
        titlebarHamburger.append(titlebarHamburgerLine03);

        let titlebarHamburgerMenu= document.createElement('div');
        titlebarHamburgerMenu.classList.add('edmlplayer-titlebar-hamburger-menu');
        titlebarHamburger.append(titlebarHamburgerMenu);

        //Menu item config
        this.titlebarHamburgerMenuItem01= document.createElement('div');
        this.titlebarHamburgerMenuItem01.classList.add('edmlplayer-titlebar-hamburger-item');
        this.titlebarHamburgerMenuItem01.setAttribute('role','menuitem');
        this.titlebarHamburgerMenuItem01.setAttribute('tabindex',0);
        this.titlebarHamburgerMenuItem01.innerText = document.edmllocale.get('config');
        titlebarHamburgerMenu.append(this.titlebarHamburgerMenuItem01);
        this.titlebarHamburgerMenuItem01.addEventListener('click',function(){
           this.dialogConfig.show();
        }.bind(this));
        this.titlebarHamburgerMenuItem01.addEventListener('keyup',this.onKeyUpMenuItem.bind(this));


        //Menu item help
        
        this.titlebarHamburgerMenuItem04= document.createElement('div');
        this.titlebarHamburgerMenuItem04.classList.add('edmlplayer-titlebar-hamburger-item');
        if(edMLPlayer_Config.get('player.showhelp') == false) this.titlebarHamburgerMenuItem04.classList.add('hide');
        this.titlebarHamburgerMenuItem04.setAttribute('role','menuitem');
        this.titlebarHamburgerMenuItem04.setAttribute('tabindex',0);
        this.titlebarHamburgerMenuItem04.innerText = document.edmllocale.get('menuhelp');
        titlebarHamburgerMenu.append(this.titlebarHamburgerMenuItem04);
        this.titlebarHamburgerMenuItem04.addEventListener('click',function(){
            window.open('https://edml.mint-kolleg.kit.edu/player/help/', '_blank').focus();
        }.bind(this));
        this.titlebarHamburgerMenuItem04.addEventListener('keyup',this.onKeyUpMenuItem.bind(this));
        

        //Menu item print

        this.titlebarHamburgerMenuItem03= document.createElement('div');
        this.titlebarHamburgerMenuItem03.classList.add('edmlplayer-titlebar-hamburger-item');
        this.titlebarHamburgerMenuItem03.setAttribute('role','menuitem');
        this.titlebarHamburgerMenuItem03.setAttribute('tabindex',0);
        this.titlebarHamburgerMenuItem03.innerText = document.edmllocale.get('print');
        titlebarHamburgerMenu.append(this.titlebarHamburgerMenuItem03);
        this.titlebarHamburgerMenuItem03.addEventListener('click',function(){
            edML_DialogPrint.show();
        }.bind(this));
        this.titlebarHamburgerMenuItem03.addEventListener('keyup',this.onKeyUpMenuItem.bind(this));
        if(edMLPlayer_Config.get('player.printable') == "none" || edMLPlayer_Config.get('player.printable') == false) this.titlebarHamburgerMenuItem03.classList.add('hide');
    
        
        //Menu item about
        this.titlebarHamburgerMenuItem02= document.createElement('div');
        this.titlebarHamburgerMenuItem02.classList.add('edmlplayer-titlebar-hamburger-item');
        this.titlebarHamburgerMenuItem02.innerText = document.edmllocale.get('about');
        this.titlebarHamburgerMenuItem02.setAttribute('role','menuitem');
        this.titlebarHamburgerMenuItem02.setAttribute('tabindex',0);
        titlebarHamburgerMenu.append(this.titlebarHamburgerMenuItem02);
        this.titlebarHamburgerMenuItem02.addEventListener('click',function(){
           this.dialogAbout.show();        
        }.bind(this));
        this.titlebarHamburgerMenuItem02.addEventListener('keyup',this.onKeyUpMenuItem.bind(this));



        //additional items
        let addmenuitems = edMLPlayer_Config.get('navigation.additionalitems');
        for(let i = 0; i < addmenuitems.length; i++){
            let mitem = document.createElement('div');
            mitem.classList.add('edmlplayer-titlebar-hamburger-item');
            mitem.setAttribute('role','menuitem');
            mitem.setAttribute('tabindex',0);
            mitem.setAttribute('command',addmenuitems[i][1]);
            mitem.innerHTML = addmenuitems[i][0];
            if(addmenuitems[i][2] != null){
                mitem.addEventListener('click',function(evt){
                    addmenuitems[i][2](evt);               
                });
            }
            titlebarHamburgerMenu.append(mitem);            
        }
        
        //Dialogs
        this.dialogAbout = new edML_DialogAbout();
        this.dialogConfig = new edML_DialogConfig();
               
        
        //events
        titlebarHamburger.addEventListener('click',this.onHamburgerClick.bind(this));


        //Headings for blind users
        if(edMLPlayer_Config.get("access.level") == 2){
          /*  let heading = document.createElement('h1');
            heading.innerText = document.edmllocale.get('access_titlebar_heading');;
            this.titlebar.prepend(heading);  */
                

            //this.titlebar.querySelector('.edmlplayer-titlebar-hamburger').setAttribute('tabindex',1);  
            
        }

    }
    
    getContainer(){
        return this.titlebar;
    }
    
    //event handling
    onHamburgerClick(){
        this.titlebarHamburgerMenuItem01.innerText = document.edmllocale.get('config');
        this.titlebarHamburgerMenuItem02.innerText = document.edmllocale.get('about');
        this.titlebarHamburgerMenuItem03.innerText = document.edmllocale.get('print');
        this.titlebarHamburgerMenuItem04.innerText = document.edmllocale.get('menuhelp');        

        
        if(this.hamburger.querySelector('.edmlplayer-titlebar-hamburger-menu').getAttribute('open') != "true") {
            this.hamburger.querySelector('.edmlplayer-titlebar-hamburger-menu').setAttribute('open','true'); 
        } else {
            this.hamburger.querySelector('.edmlplayer-titlebar-hamburger-menu').setAttribute('open','false');                
        }
        this.tabMenuIndex = 0;
    }

    onKeyUpHamburger(evt){
        if(evt.key.toLowerCase() == "enter"){
            this.onHamburgerClick();
            this.titlebar.querySelector('.edmlplayer-titlebar-hamburger-item').focus();
        }
    
        
    }

    onKeyUpMenuItem(evt){
        if(evt.key.toLowerCase() == "arrowdown"){
            if(this.tabMenuIndex < [...this.titlebar.querySelectorAll('.edmlplayer-titlebar-hamburger-item')].length-1) this.tabMenuIndex++;
            this.titlebar.querySelectorAll('.edmlplayer-titlebar-hamburger-item')[this.tabMenuIndex].focus();
        } else if(evt.key.toLowerCase() == "arrowup"){
            if(this.tabMenuIndex > 0) this.tabMenuIndex--;
            this.titlebar.querySelectorAll('.edmlplayer-titlebar-hamburger-item')[this.tabMenuIndex].focus();
        } else if(evt.key.toLowerCase() == "escape"){
            this.onHamburgerClick();
            this.titlebar.querySelector('.edmlplayer-titlebar-hamburger').focus();
        } else if(evt.key.toLowerCase() == "enter"){
            this.titlebar.querySelectorAll('.edmlplayer-titlebar-hamburger-item')[this.tabMenuIndex].click(); 
            this.onHamburgerClick();
        }

    }
    
    
    // functional things
    getScriptUrl ( name ) {
        let scripts = document.getElementsByTagName('script');
        let src;
        for( let i = 0; i < scripts.length; i++){
            src = scripts[i].getAttribute('src');
            if(src &&  src.indexOf(name) > -1 ) {
                let pos = src.lastIndexOf('/');
                return src.substring(0,pos+1);
            }
        }
        return null;
    }

    static addAditionalMenuEntry(text,command,fn){
        edML_Titlebar.additionalMenuEntries.push([text,command,fn]);
    }
    
    
            
}
class edML_Dialog{
    
    constructor(){
        this.dialogX = null;
        this.dialogY = null;        
        this.dialogWidth = null;
    
        this.container = document.createElement('div');
        this.container.classList.add('edml-dialog');
        this.container.setAttribute('role','dialog');
        this.container.setAttribute('aria-labelledby','edml-dialog-title');
        this.container.setAttribute('aria-describedby','edml-dialog-body');
        this.container.setAttribute('aria-modal','true');

        document.body.append(this.container);
        this.head = document.createElement('div');
        this.head.classList.add('edml-dialog-title');
        this.title = document.createElement('div');
        this.title.classList.add('edml-dialog-title-text');
        this.close = document.createElement('div');
        this.close.classList.add('edml-dialog-title-close');
        this.close.classList.add('edml-dialog-close');
        this.close.innerHTML = '<span class="edml-font">X</span>';
        this.close.addEventListener('click',this.hide.bind(this));
        this.close.setAttribute('tabindex',0);
        this.close.setAttribute('role','button');
        //this.close.setAttribute('aria-label',document.edmllocale.get('access_closebutton'));

        this.head.append(this.title);
        this.head.append(this.close);
        
        this.body = document.createElement('div');
        this.body.classList.add('edml-dialog-body');
        this.body.setAttribute('tabindex',0);
        this.body.setAttribute('role','none');        
        
        this.footer = document.createElement('div');
        this.footer.classList.add('edml-dialog-footer');
        
        let resize = document.createElement('span');
        resize.classList.add('edml-footer-resize');
        resize.setAttribute('aria-hidden',"true");
        resize.innerText = "D";
               
        
        this.container.append(this.head); 
        this.container.append(this.body); 
        this.container.append(this.footer); 
        this.container.append(resize);
        
        
        
        
        
        //drag-Event
        this.onDrag = this.dialogDrag.bind(this);
        this.onDragEnd = this.dialogDragEnd.bind(this);
        
        this.head.addEventListener('mousedown', function (event) {
            this.dialogX = event.clientX;
            this.dialogY = event.clientY;            
            this.dialogWidth = this.container.offsetWidth;
            event.stopPropagation();
            window.addEventListener('mousemove', this.onDrag);
            window.addEventListener('mouseup', this.onDragEnd);
        }.bind(this));
        
        //resize Event
        this.onResize = this.dialogResizeDrag.bind(this);
        this.onResizeEnd = this.dialogResizeDragEnd.bind(this);
        
        resize.addEventListener('mousedown', function (event) {
            this.dialogX = event.clientX;
            this.dialogY = event.clientY;            
            event.stopPropagation();
            window.addEventListener('mousemove', this.onResize);
            window.addEventListener('mouseup', this.onResizeEnd);
        }.bind(this));
        
    }
    
    setTitle(title){
        this.title.innerText = title;
    }
    
    setDangerTitle(bool){
        if(bool == true){
            this.title.parentNode.classList.add('danger');
        } else {
            this.title.parentNode.classList.remove('danger');
        }        
    }

    getContainer(){
        return this.container;
    }
    
    setBody(body){
        this.body.innerHTML = body;
    }

    setBodyCentered(bool){
        if(bool == true){
            this.getBody().classList.add('centered');
        } else {
            this.getBody().classList.remove('centered');
        }
    }

    setSelectable(bool){
        if(bool == true){
            this.container.classList.add('edml-dialog-selectable');
        } else {
            this.container.classList.remove('edml-dialog-selectable');
        }
    }    
    
    setFooter(footer){
        this.footer.innerHTML = footer;
        if(edMLPlayer_Config.get("access.level") == 2){
            this.footer.append(this.close);
        }
    }

    hideBody(){
        this.body.style.display = "none";
    }

    showBody(){
        this.body.style.display = "block";
    }
    
    getBody(){
        return this.body;
    }
    
    getFooter(){
        return this.footer;
    }
    
    getTitle(){
        return this.title;
    }
    
    show(){
        this.container.setAttribute('open','true');
        this.body.querySelectorAll('edml-list').forEach(function(item){
            item.setIndent();
        })
        window.setTimeout(function(){this.body.focus()}.bind(this),10);
        this.body.setAttribute('aria-label',this.title.innerText);
    }
    
    hide(){
        this.container.setAttribute('open','false'); 
        this.onClose();       
    }
    
    
    showFooter(){
        this.footer.style.display = 'flex';
    }
    
    hideFooter(){
        this.footer.style.display = 'none';
    }
    
    
    dialogDrag(evt){
        let diffx = event.clientX - this.dialogX;
        let diffy = event.clientY - this.dialogY;
        this.container.style.top = (this.container.offsetTop + diffy) + "px";
        this.container.style.left = (this.container.offsetLeft + diffx) + "px";
        this.dialogX = event.clientX;
        this.dialogY = event.clientY;
        this.container.style.width = this.dialogWidth + "px";
    }

    dialogDragEnd(evt){
        window.removeEventListener('mouseup',this.onDragEnd);
        window.removeEventListener('mousemove',this.onDrag);
        this.dialogWidth = null;
    }

    onClose(){

    }







    dialogResizeDrag(evt){
        let diffx = evt.clientX - this.dialogX;
        let diffy = evt.clientY - this.dialogY;
        this.container.style.height = (this.container.offsetHeight + diffy) + "px";
        this.container.style.width = (this.container.offsetWidth + diffx) + "px";
        this.dialogX = evt.clientX;
        this.dialogY = evt.clientY;
    }
    
    dialogResizeDragEnd(evt){
        window.removeEventListener('mouseup',this.onResizeEnd);
        window.removeEventListener('mousemove',this.onResize);
        this.dialogWidth = null;
        this.dialogX = null;
        this.dialogY = null;
    }
}
class edML_Arabic2Roman{


    static toRoman(number){
        let roman = "";
        let romanArr = ['M','D','C','L','X','V','I'];
        let arabicArr = [1000,500,100,50,10,5,1];
        let rest = number;
        let mult = 0;
        
        for(let i = 0; i < romanArr.length; i++){
            mult = Math.floor(rest/(arabicArr[i]));
            rest = rest%arabicArr[i];
           
            for(let j = 0; j < mult; j++){
                roman += romanArr[i];
            }
        }
        roman = roman.replace('DCCCC','CM');
        roman = roman.replace('CCCC','CD');
        roman = roman.replace('LXXXX','XC');
        roman = roman.replace('XXXX','XL');
        roman = roman.replace('VIIII','IX');
        roman = roman.replace('IIII','IV');
        return roman;
    }

}
class edML_Slidertab{
    
    constructor(container){
        this.container = container;
        if(!this.container.classList.contains('edml-slidertab')) this.container = container.querySelector('.edml-slidertab');
        if(this.container != null){
            this.container.querySelectorAll('.edml-slidertab .edml-slidertab-buttons .edml-slidertab-btn').forEach(function(item){
            item.addEventListener('click',function(evt){
                let ref = evt.target.getAttribute('ref');
                this.container.querySelectorAll('.edml-slidertab-tab.active').forEach(function(el){
                    el.classList.remove('active');
                });
                if(this.container.querySelector('.edml-slidertab-tab[ref="'+ref+'"]') != null) this.container.querySelector('.edml-slidertab-tab[ref="'+ref+'"]').classList.add('active');
                
                this.container.querySelectorAll('.edml-slidertab-btn.selected').forEach(function(el){                    
                    el.classList.remove('selected');
                });
                
                evt.target.classList.add('selected');
                            
                
            }.bind(this));
            
           }.bind(this));
        }
    }

}
//Titlebar

class edML_Footer{

    constructor(container){
        this.footer = document.createElement('div');
        this.footer.classList.add('edmlplayer-footer');
        container.prepend(this.footer);
    }


}
var edmlcheckbutton = document.createElement('span');
edmlcheckbutton.classList.add('edml-checkbutton');
edmlcheckbutton.container = new Array();

edmlcheckbutton.addEventListener('click',function(){
    let result;
    let container;

    for(let i = 0; i < edmlcheckbutton.container.length; i++){           
        container = edmlcheckbutton.container[i];  
        edMLPlayer_Functions.checkContainer(container);
    }
    edmlcheckbutton.container.length = 0;
    edmlcheckbutton.classList.remove('show');
});


class edMLPlayer_LoaderPlugin{

    static load(){
        if(edMLPlayer_Config.get('plugins.threedmol.active') == "true" || edMLPlayer_Config.get('plugins.threedmol.active') == true){
            var script = document.createElement('script');
            script.setAttribute('src',edMLPlayer_Config.get('plugins.threedmol.path') + "/" + edMLPlayer_Config.get('plugins.threedmol.file'));            
            script.setAttribute('type','text/javascript');
            script.async = true;
            document.head.append(script);

        }

        if(edMLPlayer_Config.get('plugins.geogebra.active') == "true" || edMLPlayer_Config.get('plugins.geogebra.active') == true){
            var script = document.createElement('script');
            script.setAttribute('src',edMLPlayer_Config.get('plugins.geogebra.path') + "/" + edMLPlayer_Config.get('plugins.geogebra.file'));            
            script.setAttribute('type','text/javascript');
            script.async = true;
            document.head.append(script);

        }

        if(edMLPlayer_Config.get('plugins.pse.active') == "true" || edMLPlayer_Config.get('plugins.pse.active') == true){
            var script = document.createElement('script');
            script.setAttribute('src',edMLPlayer_Config.get('plugins.pse.path') + "/" + edMLPlayer_Config.get('plugins.pse.file'));            
            script.setAttribute('type','text/javascript');
            script.async = true;
            document.head.append(script);

        }


        if(edMLPlayer_Config.get('plugins.subnavigation.active') == "true" || edMLPlayer_Config.get('plugins.subnavigation.active') == true){
            var script = document.createElement('script');
            script.setAttribute('src',edMLPlayer_Config.get('plugins.subnavigation.path') + "/" + edMLPlayer_Config.get('plugins.subnavigation.file'));            
            script.setAttribute('type','text/javascript');
            script.async = true;
            document.head.append(script);

        }


        if(edMLPlayer_Config.get('plugins.tikz.active') == "true" || edMLPlayer_Config.get('plugins.tikz.active') == true){
            var script = document.createElement('script');
            script.setAttribute('src',edMLPlayer_Config.get('plugins.tikz.path') + "/" + edMLPlayer_Config.get('plugins.tikz.file'));            
            script.setAttribute('type','text/javascript');
            script.async = true;
            document.head.append(script);

        }


        if(edMLPlayer_Config.get('plugins.jsxgraph.active') == "true" || edMLPlayer_Config.get('plugins.jsxgraph.active') == true){
            var script = document.createElement('script');
            script.setAttribute('src',edMLPlayer_Config.get('plugins.jsxgraph.path') + "/" + edMLPlayer_Config.get('plugins.jsxgraph.file'));            
            script.setAttribute('type','text/javascript');
            script.async = true;
            document.head.append(script);

        }
    }

}
class edMLPlayer_LoaderZip{

    static loaded = false;

    static async load(){   
                    
        let path = edMLPlayer_Config.get("player.zip.path");
        let file = edMLPlayer_Config.get("player.zip.file");
        let integrity = "";
        let enabledcsp = false;
        let count = 0;
        console.error(path+file);
        
        if(edMLPlayer_Config.get("player.zip.loaded") == false){  
            
            if(edMLPlayer_LoaderZip.loaded == false){
                let script = document.createElement('script');
                script.setAttribute('src',path+file);
                script.setAttribute('type','text/javascript');
                script.async = true;
                
                if(enabledcsp){
                    script.setAttribute('integrity',integrity.toString());
                    script.setAttribute('crossorigin','anonymous');
                }
                document.head.appendChild(script);
                edMLPlayer_LoaderZip.loaded = true;
                script.addEventListener('load',function(){
                    edMLPlayer_Config.set("player.zip.loaded",true);
                    edMLPlayer_LoaderZip.loaded = true;                    
                    console.info("zip functions loaded"); 
                });              
            }

            while(edMLPlayer_Config.get("player.zip.loaded") == false && count < 1000){
                await edMLPlayer_Util.sleep(1);
                count++;
            }
            if(edMLPlayer_Config.get("player.zip.loaded") == false){
                console.error('failed to load zip functions');
            }                
        }

        return new Promise(function(resolve, reject) {
            resolve(1);
          });
        
    }

    
    
    

}
class edMLPlayer_LoaderAes{

    static loaded = false;

    static async load(){   
                    
        let path = edMLPlayer_Config.get("player.aes.path");
        let file = edMLPlayer_Config.get("player.aes.file");
        let integrity = "";
        let enabledcsp = false;
        let count = 0;

        
        if(edMLPlayer_Config.get("player.aes.loaded") == false){  
            
            if(edMLPlayer_LoaderAes.loaded == false){
                let script = document.createElement('script');
                script.setAttribute('src',path+file);
                script.setAttribute('type','text/javascript');
                script.async = true;
                
                if(enabledcsp){
                    script.setAttribute('integrity',integrity.toString());
                    script.setAttribute('crossorigin','anonymous');
                }
                document.head.appendChild(script);
                edMLPlayer_LoaderAes.loaded = true;
                script.addEventListener('load',function(){
                    edMLPlayer_Config.set("player.aes.loaded",true);
                    edMLPlayer_LoaderAes.loaded = true;                    
                    console.info("AES loaded"); 
                });              
            }

            while(edMLPlayer_Config.get("player.aes.loaded") == false && count < 1000){
                await edMLPlayer_Util.sleep(1);
                count++;
            }
            if(edMLPlayer_Config.get("player.aes.loaded") == false){
                console.error('failed to load AES');
            }                
        } else {
            edMLPlayer_LoaderAes.loaded = true;
            console.info("AES already loaded"); 
        }

        return new Promise(function(resolve, reject) {
            resolve(1);
          });
        
    }

    
    
    

}
class edMLPlayer_LoaderCodemirror{    

    static async load(fn = null){   
                    
        let path = edMLPlayer_Config.get("player.codemirror.path");
        let file = edMLPlayer_Config.get("player.codemirror.file");
        let integrity = "";
        let enabledcsp = false;
        let count = 0;
        
        if(edMLPlayer_Config.get("player.codemirror.loaded") == false){                      
            let script = document.createElement('script');
            script.setAttribute('type',"application/javascript");
            script.setAttribute('src',path+file);
           // script.setAttribute('type','module');  // module !!!!
            script.async = true;
            
            if(enabledcsp){
                script.setAttribute('integrity',integrity.toString());
                script.setAttribute('crossorigin','anonymous');
            }
            document.head.appendChild(script);
            edMLPlayer_LoaderCodemirror.loaded = true;
            script.addEventListener('load',function(){
                edMLPlayer_Config.set("player.codemirror.loaded",true);
                edMLPlayer_LoaderCodemirror.loaded = true;
                if(fn != null) fn();
                console.info("CodeMirror loaded");                 
            }); 
            
            

            while(edMLPlayer_Config.get("player.codemirror.loaded") == false && count < 1000){
                await edMLPlayer_Util.sleep(1);
                count++;
            }
            if(edMLPlayer_Config.get("player.codemirror.loaded") == false){
                console.error('failed to load CodeMirror');
            }                
        } else {
            if(fn != null) fn();
            edMLPlayer_LoaderCodemirror.loaded = true;
            console.info("CodeMirror already loaded"); 
        }

        return new Promise(function(resolve, reject) {
            resolve(1);
          });
        
    }

    
    
    

}

class edMLPlayer_LoaderMathjax{    

    /* 
        Mathjax configuration in mathjax/mathjax.js 
    */

    static async load(fn = null){   
          
        let path = edMLPlayer_Config.get("player.mathjax.path");
        let file = edMLPlayer_Config.get("player.mathjax.file");
        let integrity = "";
        let enabledcsp = false;
        let count = 0;
        
        if(edMLPlayer_Config.get("player.mathjax.loaded") == false){ 
           

            let script = document.createElement('script');
            script.setAttribute('src',path+file);            
            script.setAttribute('type','text/javascript');
            script.async = true;
            
            if(enabledcsp){
                script.setAttribute('integrity',integrity.toString());
                script.setAttribute('crossorigin','anonymous');
            }
            document.head.appendChild(script);
            edMLPlayer_LoaderMathjax.loaded = true;
            /*script.addEventListener('load',function(){
                edMLPlayer_Config.set("player.mathjax.loaded",true);
                edMLPlayer_LoaderMathjax.loaded = true;
                if(fn != null) fn();
                console.info("Mathjax loaded"); 
            });              */
            window.addEventListener('mathjaxloaded',function(){
                edMLPlayer_Config.set("player.mathjax.loaded",true);
                edMLPlayer_LoaderMathjax.loaded = true;
                if(fn != null) fn();
                console.info("Mathjax loaded"); 
               // await edMLPlayer_LoaderMathjaxTagFormat.load();  
                
            });
                       

            while(edMLPlayer_Config.get("player.mathjax.loaded") == false && typeof MathJax.typesetPromise == "undefined" && count < 1000){
                await edMLPlayer_Util.sleep(1);
                count++;
            }
            if(edMLPlayer_Config.get("player.mathjax.loaded") == false){
                edMLPlayer_Config.set("player.mathjax.loaded","failed");
                console.error('failed to load Mathjax');
            }                
        } else {
            if(fn != null) fn();
            edMLPlayer_LoaderMathjax.loaded = true;
            console.info("Mathjax already loaded"); 
        }

        return new Promise(function(resolve, reject) {
            resolve(1);
          });
        
    }

    
    
    

}

class edMLPlayer_LoaderAlgebrite{

    static loaded = false;

    static async load(){   
                    
        let path = edMLPlayer_Config.get("player.algebrite.path");
        let file = edMLPlayer_Config.get("player.algebrite.file");
        let integrityalgebrite = "";
        let enabledcsp = false;
        let count = 0;

        
        if(edMLPlayer_Config.get("player.algebrite.loaded") == false){  
            
            if(edMLPlayer_LoaderAlgebrite.loaded == false){
                let script = document.createElement('script');
                script.setAttribute('src',path+file);
                script.setAttribute('type','text/javascript');
                script.async = true;
                
                if(enabledcsp){
                    script.setAttribute('integrity',integrityalgebrite.toString());
                    script.setAttribute('crossorigin','anonymous');
                }
                document.head.appendChild(script);
                edMLPlayer_LoaderAlgebrite.loaded = true;
                script.addEventListener('load',function(){
                    edMLPlayer_Config.set("player.algebrite.loaded",true);
                    edMLPlayer_LoaderAlgebrite.loaded = true;
                    console.info("Algebrite loaded"); 
                });              
            }

            while(edMLPlayer_Config.get("player.algebrite.loaded") == false && count < 1000){
                await edMLPlayer_Util.sleep(1);
                count++;
            }
            if(edMLPlayer_Config.get("player.algebrite.loaded") == false){
                console.error('failed to load Algebrite');
            }                
        }

        return new Promise(function(resolve, reject) {
            resolve(1);
          });
        
    }

    
    
    

}
class edMLPlayer_LoaderNerdamer{

    static loaded = false;

    static async load(){   
                    
        let path = edMLPlayer_Config.get("player.nerdamer.path");
        let file = edMLPlayer_Config.get("player.nerdamer.file");
        let integritynerdamer = "";
        let enabledcsp = false;
        let count = 0;

        
        if(edMLPlayer_Config.get("player.nerdamer.loaded") == false){  
            
            if(edMLPlayer_LoaderNerdamer.loaded == false){
                let script = document.createElement('script');
                script.setAttribute('src',path+file);
                script.setAttribute('type','text/javascript');
                script.async = true;
                
                if(enabledcsp){
                    script.setAttribute('integrity',integrityalgebrite.toString());
                    script.setAttribute('crossorigin','anonymous');
                }
                document.head.appendChild(script);
                edMLPlayer_LoaderNerdamer.loaded = true;
                script.addEventListener('load',async function(){
                    edMLPlayer_Config.set("player.nerdamer.loaded",true);
                    
                    nerdamer.setConstant('E', 'delete');
                    

                    let functionarr = edMLPlayer_Config.get("defaultmodel.expression.functions");
     
                    for(let i = 0; i < functionarr.length; i++){
                        if(functionarr[i].length == 3){  
                            nerdamer.setFunction(functionarr[i][0],[functionarr[i][1]],functionarr[i][2]);    
                        }
                    }

                    let wordarr = edMLPlayer_Config.get("defaultmodel.expression.infinityaddword");

                    for(let i = 0; i < wordarr.length; i++){
                        nerdamer.setConstant(wordarr[i],"Infinity");    
                    }
                    nerdamer.getCore().bigDec.set({precision: 5000});

                    console.info("Nerdamer configured"); 
                    
                    edMLPlayer_LoaderNerdamer.loaded = true;
                    console.info("Nerdamer loaded"); 
                    
                });              
            }

            while(edMLPlayer_Config.get("player.nerdamer.loaded") == false && count < 1000){
                await edMLPlayer_Util.sleep(1);
                count++;
            }
            if(edMLPlayer_Config.get("player.nerdamer.loaded") == false){
                console.error('failed to load Nerdamer');
            }                
        } else {
            edMLPlayer_LoaderNerdamer.loaded = true;
            console.info("Nerdamer already loaded"); 
        }

        return new Promise(function(resolve, reject) {
            resolve(1);
          });
        
    }

    
    
    

}
class edMLPlayer_Functions{
    //helper class to provide global static methods

    static models = [['',null]];  // first element is default model object; array struture: [[name, model], [name,model], ...]
    static timer = null;  
    static credits = 0;
    static maxcredits = 0; 
    static score = null; 
    static navindex = 0;
    

    static checkContainer(container){
        let result = container.verify();                        
        container.evaluateCredits(result);  
        container.checkSolutionhint(result);  //show solutionhint?             
        if(container.save2SCORM != null) container.save2SCORM(result);   
        if(container.save2iDB != null) container.save2iDB(result);    
    }

    static getEdmlTags(){
          
       return ["tag","cdata","accordion","accordionview","affinespace","allof","applicationbox","audio","autoref","blockquote","boolean","booleangroup","br","button","calc","caption","carouselview","case","cell","chain","chains","choice","clonecontainer","code","codelisting","colspec","colspecs","condition","conventionbox","course","creator","date","decision","default","definitionbox","description","descriptor","dragitems","dropitems","educts","emph","enumerator","examplebox","exercisebox","exponent","exponential","expression","externmedia","feedback","figureblock","flex","flexitem","flipcardview","formulabox","frame","groupview","headrow","help","helpbox","hint","hintbox","info","infobox","initialcode","input","inputblock","inputmodel","inputmodels","interaction","interval","item","label","license","linearspan","link","list","listitem","m","mantissa","mark","match","matches","matching","matrix","metadata","molecular","molecule","matrixrow","navigation","navitem","navlist","note","number","objectblock","oneof","option","optionalview","order","orderitems","p","page","pages","panel","parameter","parametergroup","picture","poolview","products","proofbox","quantity","quote","range","reaction","ref","refnumber","remarkbox","row","set","settings","solutioncode","solutionhint","source","sourcecode","sourcefile","spotlight","step","strikeout","string","strong","style","styles","sub","subtitle","sup","table","tabset","tabview","test","testitem","testlist","tests","textbox","theorembox","title","underline","unit","value","variant","vector","video","warning"];
    }


    
    static getEdmlClasses(){
        return [edML_Tag,edML_Cdata,edML_Accordion,edML_Accordionview,edML_Affinespace,edML_Allof,edML_Applicationbox,edML_Audio,edML_Autoref,edML_Blockquote,edML_Boolean,edML_Booleangroup,edML_Br,edML_Button,edML_Calc,edML_Caption,edML_Carouselview,edML_Case,edML_Cell,edML_Chain,edML_Chains,edML_Choice,edML_Clonecontainer,edML_Code,edML_Codelisting,edML_Colspec,edML_Colspecs,edML_Condition,edML_Conventionbox, edML_Course,edML_Creator,edML_Date,edML_Decision,edML_Default,edML_Definitionbox,edML_Description,edML_Descriptor,edML_Dragitems,edML_Dropitems,edML_Educts,edML_Emph,edML_Enumerator,edML_Examplebox,edML_Exercisebox,edML_Exponent,edML_Exponential,edML_Expression,edML_Externmedia,edML_Feedback,edML_Figureblock,edML_Flex,edML_Flexitem,edML_Flipcardview,edML_Formulabox,edML_Frame,edML_Groupview,edML_Headrow,edML_Help,edML_Helpbox,edML_Hint,edML_Hintbox,edML_Info,edML_Infobox,edML_Initialcode,edML_Input,edML_Inputblock,edML_Inputmodel,edML_Inputmodels,edML_Interaction,edML_Interval,edML_Item,edML_Label,edML_License,edML_Linearspan,edML_Link,edML_List,edML_Listitem,edML_M,edML_Mantissa,edML_Mark,edML_Match,edML_Matches,edML_Matching,edML_Matrix,edML_Metadata,edML_Molecular,edML_Molecule,edML_Matrixrow,edML_Navigation,edML_Navitem,edML_Navlist,edML_Note,edML_Number,edML_Objectblock,edML_Oneof,edML_Option,edML_Optionalview,edML_Order,edML_Orderitems,edML_P,edML_Page,edML_Pages,edML_Panel,edML_Parameter,edML_Parametergroup,edML_Picture,edML_Poolview,edML_Products,edML_Proofbox,edML_Quantity,edML_Quote,edML_Range,edML_Reaction,edML_Ref,edML_Refnumber,edML_Remarkbox,edML_Row,edML_Set,edML_Settings, edML_Solutioncode,edML_SolutionHint,edML_Source,edML_Sourcecode,edML_Sourcefile,edML_Spotlight,edML_Step,edML_Strikeout,edML_String,edML_Strong,edML_Style,edML_Styles,edML_Sub,edML_Subtitle,edML_Sup,edML_Table,edML_Tabset,edML_Tabview,edML_Test,edML_Testitem,edML_Testlist,edML_Tests,edML_Textbox,edML_Theorembox,edML_Title,edML_Underline,edML_Unit,edML_Value,edML_Variant,edML_Vector,edML_Video,edML_Warning];
    }

    static getBoxes(){
        return ["applicationbox","conventionbox","definitionbox","examplebox","exercisebox","formulabox","helpbox","hintbox","infobox","proofbox","remarkbox","textbox","theorembox"];
    }


    static getBoxQuery(){
        var boxquery = "";
        var boxes = edMLPlayer_Functions.getBoxes();
        for(var i = 0; i< boxes.length;i++){
            boxquery += ",edml-"+boxes[i];
        }
        return boxquery.substring(1);
    }

    static getNextNavindex(){
        return ++edMLPlayer_Functions.navindex;
    }

    static getHelpTags(){
        //additional custom element tags not included in edML
        return [];
    }

    static getHelpClasses(){
        //additional custom element tags not included in edML -> corresponding class name
        return [];
    }

    static getModels(){
        return edMLPlayer_Functions.models;
    }


    static getDefaultModel(){
        if(edMLPlayer_Functions.models[0][1] == null) edMLPlayer_Functions.models[0][1] = new edML_SuperclassModel();
        return edMLPlayer_Functions.models[0][1];
    }

    static getModel(name){
        if(name == "") {
            return edMLPlayer_Functions.getDefaultModel();
        } else {
            let found = false;
            let i = 1;
            while(i < edMLPlayer_Functions.models.length && found == false){
                if(edMLPlayer_Functions.models[i][0] != name) i++; else found = true;
            }

            if(found) return edMLPlayer_Functions.models[i][1]; else return null; 
        }
    }

    static addModel(name,model){
        let entry = new Array();
        entry.push(name);
        entry.push(model);
        edMLPlayer_Functions.models.push(entry);
    }

    static getTimer(){
        return edMLPlayer_Functions.timer;
    }

    static refreshTimer(time,obj){
        edMLPlayer_Functions.hideCheckButton();     
        if(edMLPlayer_Functions.getTimer() != null) {
            clearTimeout(edMLPlayer_Functions.getTimer());
            edMLPlayer_Functions.setTimer(null);                        
        }
        if(edMLPlayer_Functions.getTimer() == null && obj != null) edMLPlayer_Functions.setTimer(time,obj);
    }

    static setTimer(time, obj){  // time == null --> delete timer
        let element = obj; // obj should be input, inputblock or inputgroup
        if(time != null){
            if(!(element instanceof edML_Input || element instanceof edML_Inputblock || element instanceof edML_Inputgroup)) {
                element = obj.closest('edml-input');
                if(element == null){
                    element = obj.closest('edml-inputblock');
                }
            }

            if(element != null && !window.edmlcheckbutton.container.includes(element) && document.querySelector('edml-variant.active edml-test.active') == null) {
                window.edmlcheckbutton.container.push(element);
            }

            edMLPlayer_Functions.timer = setTimeout(function(){
                if(obj.closest('edml-input') != null && obj.closest('edml-input').getAttribute('check') == "false"){
                    if(edMLPlayer_Config.get("player.scorm.enabled") == true && (edMLPlayer_Config.get('player.scorm.testonly') != true || document.querySelector('edml-test.active') != null)){ 
                        var result = obj.verify();                        
                        if(obj.save2SCORM != null) obj.save2SCORM(result);
                    }
                } else {
                    if(obj.checkShowCheckButton != null){
                        if(obj.checkShowCheckButton()){
                            edMLPlayer_Functions.showCheckButton();     
                        }
                    } else {
                        edMLPlayer_Functions.showCheckButton(); 
                    }
                }    
                

            }, time);

        } else {
            clearTimeout(edMLPlayer_Functions.timer);
            edMLPlayer_Functions.timer = null;
        }
 
   
        /*if(time == null || element == null) edMLPlayer_Functions.timer = null; else edMLPlayer_Functions.timer = setTimeout(function(){
           /* let firstchild = element.firstChild;
            while(!(firstchild instanceof edML_Inputvalue) && firstchild != null){
                firstchild = firstchild.nextElementSibling;
            }
           
            if(firstchild != null && element instanceof edML_Input && firstchild.checkShowCheckButton()){
                edMLPlayer_Functions.showCheckButton(element);
                if(element.querySelector('edml-expression') != null){
                    element.querySelector('edml-expression').toggleView(); 
                }
            }

            if(element instanceof edML_Inputgroup && element.checkShowCheckButton()){
                edMLPlayer_Functions.showCheckButton(element); 
            }
            edMLPlayer_Functions.showCheckButton(); 

        }, time);*/
    }


    static showCheckButton(){ 
        if(document.querySelector('.edml-expression-output') != null) document.querySelector('.edml-expression-output').classList.remove('active');
        if(document.querySelector('.edml-unit-output') != null) document.querySelector('.edml-unit-output').classList.remove('active');
        if(window.edmlcheckbutton.container.length > 0) window.edmlcheckbutton.classList.add('show');                
        window.edmlcheckbutton.innerText = document.edmllocale.get('checkbuttontext',document.querySelector('edml-variant.active').getAttribute('lang'));
    }
    
    static hideCheckButton(){
        window.edmlcheckbutton.classList.remove('show');
    }

    isCheckButtonVisible(){
        return window.edmlcheckbutton.classList.contains('show');
    }

    static changeCredits(amount, effect){
        edMLPlayer_Functions.credits = parseInt(edMLPlayer_Functions.credits) + parseInt(amount);        
        if(edMLPlayer_Functions.score != null) edMLPlayer_Functions.score.setLeftScore(edMLPlayer_Functions.credits,effect);    

    }

    static getCredits(){
        return edMLPlayer_Functions.credits;
    }

    static getMaxCredits(){
        return edMLPlayer_Functions.maxcredits;
    }

    static setMaxCredits(val){
        edMLPlayer_Functions.maxcredits = val;
    }

    static setScore(score){
        edMLPlayer_Functions.score = score;
    }

    static getScore(){
        return edMLPlayer_Functions.score;
    }

    static getInputgroupTagByInputvalue(inputvalue){
        if(inputvalue == null){
            return null;
        } else if(inputvalue.tagName.toLowerCase() == 'edml-boolean'){
            return 'edml-booleangroup';
        } else {
            return null;
        }
    }

    static getSubmodelByInputvalue(inputvalue){
        if(inputvalue == null){
            return null;
        } else {
            return inputvalue.tagName.toLowerCase().replace('edml-','');
        }
    }

    


    
   /*static getEdmlOption(){
        return [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,{extends: "h4"},null,null,null,null];
    } */  
 

}

/*console.log(edMLPlayer_Functions.getEdmlTags().length);
console.log(edMLPlayer_Functions.getEdmlClasses().length);

console.log(edMLPlayer_Functions.getEdmlTags()[65]);
console.log(edMLPlayer_Functions.getEdmlClasses()[65]);*/
class edML_edML2HTML{

    static registered = false;

    constructor(){
    }
    
    static registerACE(){
        if(edML_edML2HTML.registered == false){
            //register autonomos custom elements: edML elements
            let tags = edMLPlayer_Functions.getEdmlTags();
            let classes = edMLPlayer_Functions.getEdmlClasses();
            //let options = edMLPlayer_Functions.getEdmlOption();
            for(let i = 0; i <tags.length; i++){            
                customElements.define("edml-"+tags[i], classes[i]);                        
            }


            //register autonomos custom elements: help classes, e.g. for unit input
            let helptags = edMLPlayer_Functions.getHelpTags();
            let helpclasses = edMLPlayer_Functions.getHelpClasses();

            for(let i = 0; i <helptags.length; i++){
                customElements.define("edml-"+helptags[i], helpclasses[i]);            
            }
            edML_edML2HTML.registered = true;
        }
    }
    
    static parse2string(input){
        
        if(edMLPlayer_Config.get('player.depractedconversion') == true) input = edML_edML2HTML.replaceDepracted(input);
        let output = "";
        if(input.trim() != ""){
            let inputXML = input;
            if(input.indexOf('<course') == -1) inputXML = '<root>'+inputXML+ '</root>';
            if(input.indexOf('<?xml version') == -1) inputXML = '<?xml version="1.0" encoding="UTF-8" ?>'+inputXML;
            let doc = new DOMParser().parseFromString(inputXML, "text/xml");
            const errorNode = doc.querySelector('parsererror');
            if (errorNode) {
                let dlg = new edML_Dialog();
                dlg.setDangerTitle(true);
                dlg.setTitle(document.edmllocale.get("dialog_xmlerror_title"));
                dlg.setBody(document.edmllocale.get("dialog_xmlerror_domparser"));
                //dlg.classList.add('edml-dialog-selectable');
                dlg.hideFooter();
                dlg.show();
                edML_Error.push("0008",errorNode.outerHTML,"");
                edML_Error.printLast();
            } else {
            
                output = doc.firstElementChild; 
                              
                if(output != null && output.nodeType != Node.TEXT_NODE){
                    //remove all comments
                    output.querySelectorAll('*').forEach(function(item){
                        for(let i = 0; i < item.childNodes.length; i++){
                            if(item.childNodes[i].nodeType == Node.COMMENT_NODE) item.childNodes[i].remove();
                        }
                        
                    });
                
                    output.querySelectorAll('script').forEach(function(item){
                        item.remove();
                    }); 
                    
                    this.replaceCDATA(output);
                }     
               
                if(output != null){     
                    if(output.nodeType == Node.TEXT_NODE){
                        output = output.textContent;
                    } else {
                        if(input.indexOf('<course') != -1){
                            output = output.outerHTML;
                        } else {
                            output = output.innerHTML;
                        }
                    }
                    
                    
                    //change <tag/> types to <tag></tag>
                    output = output.replaceAll(/<([a-zA-Z]+)( (?:[^>]|\n)*?|)\/>/gm,'<$1$2></$1>');          
                    
                    // add edml- to every tag
                    output = output.replaceAll(/<([a-zA-Z]+)( (?:[^>]|\n)*?|)\>/g,'<edml-$1$2>');           // typ: <tag>        
                    output = output.replaceAll(/<\/([a-zA-Z]+)[ ]*>/g,'</edml-$1>');   //typ: </tag>
                    
                    
                } else {
                    output = "";
                    edML_Error.push("0006",input,"");
                    edML_Error.printLast();
                }
            }  
        }      
        return output;
    }
    
    static replaceCDATA(node){
        //replace CDATA-Nodes        
        if(node.nodeType == Node.CDATA_SECTION_NODE){
            let newnode = node.ownerDocument.createElement('cdata');
           // let newnode = node.ownerDocument.createTextNode(node.textContent);
            node.parentNode.insertBefore(newnode,node);
            newnode.textContent = node.textContent; 
            node.remove();            
        } else {
            for(let i = 0; i < node.childNodes.length; i++){
                this.replaceCDATA(node.childNodes[i]);
            }
        }    
    }

    static replaceDepracted(text){
        let output = text;
        //panelview -> groupview
        if(output.indexOf('<panelview') > - 1) console.warn('edML-Warning: panelview is depracted. Use groupview instead. Autoconversion to groupview is done.');
        output = output.replaceAll(/<panelview/gm,'<groupview');               
        output = output.replaceAll(/<\/panelview\>/gm,'</groupview>');  
        
        //decimal -> number
        if(output.indexOf('<decimal') > - 1) console.warn('edML-Warning: decimal is depracted. Use number instead. Autoconversion to number is done.');
        output = output.replaceAll(/<decimal/gm,'<number');               
        output = output.replaceAll(/<\/decimal\>/gm,'</number>'); 

        //b -> strong
        if(output.indexOf('<b>') > - 1) console.warn('edML-Warning: b is depracted. Use strong instead. Autoconversion to strong is done.');
        output = output.replaceAll(/<b\>/gm,'<strong>');               
        output = output.replaceAll(/<\/b\>/gm,'</strong>'); 

         //u -> underline
         if(output.indexOf('<u>') > - 1) console.warn('edML-Warning: u is HTML. Use underline instead. Autoconversion to underline is done.');
         output = output.replaceAll(/<u\>/gm,'<underline>');               
         output = output.replaceAll(/<\/u\>/gm,'</underline>'); 

        //i -> emph
        if(output.indexOf('<i>') > - 1) console.warn('edML-Warning: i is depracted. Use emph instead. Autoconversion to emph is done.');
        output = output.replaceAll(/<i\>/gm,'<emph>');               
        output = output.replaceAll(/<\/i\>/gm,'</emph>'); 

        //<equation -> <m display="block"
        if(output.indexOf('<equation>') > - 1) console.warn('edML-Warning: equation is depracted. Use m with Attribute display="block" instead. Autoconversion to m is tried. Maybe some errors will occur. ');
        //output = output.replaceAll(/<equation\>(.*)<\/equation\>[\s]*</gm,'<p><m display="block">$1</m></p>');               
        output = output.replaceAll(/<equation\>(.*)<\/equation\>/gm,'<p><m display="block">$1</m></p>');   
        output = output.replaceAll(/<equation\>(.*?)<\/equation\>/gms,'<p><m display="block">$1</m></p>');  
        
        //panelview -> groupview
        if(output.indexOf('<panelview>') > - 1) console.warn('edML-Warning: panelview is depracted. Use groupview instead. Autoconversion to groupview is done.');
        output = output.replaceAll(/<panelview/gm,'<groupview');               
        output = output.replaceAll(/<\/panelview\>/gm,'</groupview>'); 

        //attribution -> metadata
        if(output.indexOf('<attribution') > - 1) console.warn('edML-Warning: attribution is depracted. Use metadata instead. Autoconversion to metadata is done.');
        output = output.replaceAll(/<attribution/gm,'<metadata');               
        output = output.replaceAll(/<\/attribution\>/gm,'</metadata>'); 

        //i -> emph
        if(output.indexOf('<author>') > - 1) console.warn('edML-Warning: author is depracted. Use creator instead. Autoconversion to creator is done.');
        output = output.replaceAll(/<author\>/gm,'<creator>');               
        output = output.replaceAll(/<\/author\>/gm,'</creator>'); 

        //terms -> dragitems
        if(output.indexOf('<terms ') > - 1 || output.indexOf('<terms>') > - 1) console.warn('edML-Warning: terms is depracted. Use dragitems instead. Autoconversion to dragitems is done. WARNING: Indexing in match has in newer edML changed and will NOT be autoconverted.');
        output = output.replaceAll(/<terms /gm,'<dragitems '); 
        output = output.replaceAll(/<terms\>/gm,'<dragitems>');               
        output = output.replaceAll(/<\/terms\>/gm,'</dragitems>'); 

        //definitions -> dropitems
        if(output.indexOf('<definitions>') > - 1 || output.indexOf('<definitions ') > - 1) console.warn('edML-Warning: definitions is depracted. Use dropitems instead. Autoconversion to dropitems is done. WARNING: Indexing in match has in newer edML changed and will NOT be autoconverted.');
        output = output.replaceAll(/<definitions /gm,'<dropitems ');               
        output = output.replaceAll(/<definitions\>/gm,'<dropitems>');               
        output = output.replaceAll(/<\/definitions\>/gm,'</dropitems>');  

        

        //<exponential.*?\>.*?<(number).*?<\/(number)>.*?(<(number).*?<\/(number)>)+?.*?<\/exponential>

        //exponential > number, two numbers given --> exponential mantissa exponent
        if(output.match(/<\/exponent>/gms) == null && output.match(/<\/exponential>/gms) != null){
            console.warn('edML-Warning: exponential with number is depracted. Use mantissa and exponent instead. Autoconversion is done.');                                    
            output = output.replaceAll(/(<exponential.*?\>.*?<)number(.*?<\/)number(>.*?)(<number(.*?<\/)number(.*?<\/exponential>)|<\/exponential>)/gms,edML_edML2HTML.replaceExponential);
        }

        //codelisting -> sourcecode
        if(output.indexOf('<codeenvironment ') > - 1 || output.indexOf('<codeenvironment>') > - 1) console.warn('edML-Warning: codeenvironment is depracted. Use sourcecode instead. Autoconversion to sourcecode is done.');
        output = output.replaceAll(/<codeenvironment /gm,'<sourcecode ');     
        output = output.replaceAll(/<codeenvironment\>/gm,'<sourcecode>');           
        output = output.replaceAll(/<\/codeenvironment\>/gm,'</sourcecode>');  

      

        //content -> initialcontent
        if(output.indexOf('<content>') > - 1 || output.indexOf('<content ') > - 1) console.warn('edML-Warning: content is depracted. Use initialcontent instead. Autoconversion to content is done.');
        output = output.replaceAll(/<content /gm,'<initialcontent ');               
        output = output.replaceAll(/<content\>/gm,'<initialcontent>');               
        output = output.replaceAll(/<\/content\>/gm,'</initialcontent>');  

        //calculate -> calc
        if(output.indexOf('<calculate ') > - 1 || output.indexOf('<calculate>') > - 1) console.warn('edML-Warning: calculate is depracted. Use calc instead. Autoconversion to calc is done.');
        output = output.replaceAll(/<calculate /gm,'<calc ');     
        output = output.replaceAll(/<calculate\>/gm,'<calc>');           
        output = output.replaceAll(/<\/calculate\>/gm,'</calc>'); 

        //duration -> maxduration
        if(output.indexOf(' duration="') > - 1) console.warn('edML-Warning: attribute duration is depracted. Use maxduration instead. Autoconversion to maxduration is done.');
        output = output.replaceAll(/ duration="/gm,' maxduration="');     


        //<defaultvariant>xy</defaultvariant> -> nichts
        if(output.indexOf('<defaultvariant>') > - 1 || output.indexOf('<defaultvariant ') > - 1) console.warn('edML-Warning: defaultvariant is depracted. Use defaultvariant attribute on settings (course) instead. WARNING: No autoconversion is done. Tag is just dropped.');
        output = output.replaceAll(/<defaultvariant /gm,'<defaultvariant ');               
        output = output.replaceAll(/<defaultvariant\>/gm,'<defaultvariant>');               
        output = output.replaceAll(/<\/defaultvariant\>/gm,'</defaultvariant>');  

        return output;
    }
    
    
    static replaceExponential(match){
        //replace last number to exponent
        let newmatch = match;
        let idx = newmatch.lastIndexOf('</number>');
        if(idx > -1) newmatch = newmatch.substring(0,idx) + '</exponent>' + newmatch.substring(idx + '</number>'.length);
        idx = newmatch.lastIndexOf('<number');
        if(idx > -1) newmatch = newmatch.substring(0,idx) + '<exponent' + newmatch.substring(idx + '<number'.length);

        idx = newmatch.lastIndexOf('</number>');
        if(idx > -1) newmatch = newmatch.substring(0,idx) + '</mantissa>' + newmatch.substring(idx + '</number>'.length);
        idx = newmatch.lastIndexOf('<number');
        if(idx > -1) newmatch = newmatch.substring(0,idx) + '<mantissa' + newmatch.substring(idx + '<number'.length);
        return newmatch;
    }
   
    
    
    static parse2dom(input){               
        let output = edML_edML2HTML.parse2string(input);                                
        output = document.createRange().createContextualFragment(output);               
        
        
       /* const parser = new DOMParser();
        output = parser.parseFromString(output, "text/html").firstChild;*/
       

        
        return output;
    }

}
class edMLplayer_Breadcrumb {

    constructor(container){
        this.breadcrumb = document.createElement('div');
        this.breadcrumb.classList.add('edmlplayer-breadcrumb');        
        container.append(this.breadcrumb);
        window.addEventListener("edmlevent-newpage",this.changeBreadcrumb.bind(this));        
        window.addEventListener("edmlevent-shownavigation",this.shownavEvt.bind(this));     
        window.addEventListener("edmlevent-hidenavigation",this.hidenavEvt.bind(this));  

        window.addEventListener("resize",this.resizeEvt.bind(this));
        
        
    }

    resizeEvt(evt){
        if(document.querySelector('edml-variant.active edml-page.active') != null){
        
            if(document.querySelector('edml-variant.active edml-page.active').getBoundingClientRect().left < 32){
                this.breadcrumb.style.left = "2em";
            } else {
                this.breadcrumb.style.left = document.querySelector('edml-variant.active edml-page.active').getBoundingClientRect().left+"px";
            }

            //scale for ... text-overflow: ellipsis;
            let nb = [...this.breadcrumb.querySelectorAll('.edmlplayer-breadcrumbitem')].length+1;
            
            let mwidth = document.querySelector('edml-variant.active edml-page.active').getBoundingClientRect().width / nb;
            this.breadcrumb.querySelectorAll('.edmlplayer-breadcrumbitem').forEach(function(item){
                item.style.maxWidth = mwidth + "px";
            });
        }
    }

    changeBreadcrumb(evt){
        document.querySelector('edml-variant.active').prepend(this.breadcrumb);
        if(document.querySelector('edml-variant.active edml-page.active')){
            if(document.querySelector('edml-variant.active edml-page.active').getBoundingClientRect().left < 32){
                this.breadcrumb.style.left = "2em";
            } else {
                this.breadcrumb.style.left = document.querySelector('edml-variant.active edml-page.active').getBoundingClientRect().left+"px";
            }
        }

        
        

        if(document.querySelector('edml-navigation.active.show') != null){
            this.breadcrumb.classList.add('navextended');
        } else {
            this.breadcrumb.classList.remove('navextended');
        }

        let navigationarr = [...document.querySelectorAll('edml-variant.active edml-navitem')];
        let idx = navigationarr.indexOf(evt.navitem);
        let text = "";
        if(idx > -1){
            text = '<span class="edmlplayer-breadcrumbitem" navidx="'+idx+'">'+evt.navitem.querySelector('edml-ref, edml-link').innerText+'</span>';
            let item = evt.navitem.parentNode.closest('edml-navitem');
            while(item != null){
                idx = navigationarr.indexOf(item);
                text = '<span class="edmlplayer-breadcrumbitem" navidx="'+idx+'">' + item.querySelector('edml-ref').innerText + "</span> &gt; " + text
                item = item.parentNode.closest('edml-navitem');
            }
        }

        this.breadcrumb.innerHTML = text;

        this.breadcrumb.querySelectorAll('.edmlplayer-breadcrumbitem').forEach(function(item){
            item.addEventListener('click',function(evt){
                let obj = evt.target;
                let navigationarr = [...document.querySelectorAll('edml-variant.active edml-navitem')];
                let navitem = navigationarr[obj.getAttribute('navidx')];
                navitem.click();
            })
        })

        //scale for ... text-overflow: ellipsis;
        let nb = [...this.breadcrumb.querySelectorAll('.edmlplayer-breadcrumbitem')].length+1;
        let mwidth = 0;
        if(document.querySelector('edml-variant.active edml-page.active') != null) mwidth = document.querySelector('edml-variant.active edml-page.active').getBoundingClientRect().width / nb;
        this.breadcrumb.querySelectorAll('.edmlplayer-breadcrumbitem').forEach(function(item){
            item.style.maxWidth = mwidth + "px";
        });
    }

    setAlways(bool){
        if(bool) this.breadcrumb.setAttribute('always','on'); else this.breadcrumb.removeAttribute('always');
    }

    shownavEvt(evt){    
        this.breadcrumb.classList.add('navextended');
        
    }

    hidenavEvt(evt){
        this.breadcrumb.classList.remove('navextended');
    }

}


class edMLplayer_Timer extends HTMLElement {
    constructor(time) {
      super();
      this.initialtime = edMLplayer_Timer.time2seconds(time);
      this.time = this.initialtime;

      this.innerText = edMLplayer_Timer.seceonds2time(this.initialtime);
      
      //set counter
      this.counter = window.setInterval(this.checkTime.bind(this),1000);


    }

    reset(){
      this.time = this.initialtime;       
    }

    checkTime(){
        this.time--;        
        
        if(this.time > 600){
            this.innerText = edMLplayer_Timer.seceonds2time(this.time,true);            
        } else if(this.time > 0){
            this.innerText = edMLplayer_Timer.seceonds2time(this.time,false);            
        } else {
            this.innerText = "00:00:00";
            window.clearInterval(this.counter);
            let evt = new Event("edmlevent-testtimeout"); 
            evt.initialtime = this.initialtime;           
            var variant = this.closest('edml-variant');
            variant.querySelector('edml-test.active').dispatchEvent(evt);
        }

        if(this.time < 15 && this.time > 0){
            this.classList.add('red');
            console.log("red");
        } else {
            this.classList.remove('red');
        }
        
    }

    stop(){
        window.clearInterval(this.counter);
    }

    static seceonds2time(seconds,noSeconds){
        let h = Math.floor(seconds / 3600);
        if(h.toString().length == 1) {
            h = "0" + h + ":"; 
        } else {
            h = h + ":";
        }

        let m = Math.floor((seconds % 3600) / 60);
        if(m.toString().length == 1) {
            m = "0" + m; 
        } 

        let s = Math.floor((seconds % 3600) % 60);
        if(s.toString().length == 1) {
            s = ":" + "0" + s; 
        } else {
            s = ":" + s;
        }

        if(noSeconds == true){
            return h + m;
        } else {
            return m + s;
        }
    }

    static time2seconds(time){
        //calculate seconds from time
        let seconds = 0;
        var split = time.split(":");
        if(!isNaN(parseInt(split[0]))) seconds += 3600 * parseInt(split[0]);
        if(split.length > 1 && !isNaN(parseInt(split[1]))) seconds += 60 * parseInt(split[1]);
        if(split.length > 2 && !isNaN(parseInt(split[2]))) seconds += parseInt(split[2]);
        return seconds;
    }



}

customElements.define("edmlplayer-timer", edMLplayer_Timer);
class edML_Accordion extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["panel"]);
        this.setAttributeWhitelist(["name","tags","open"]);
        this.setRequiredTag(["panel"]);
        this.setMixedContent(false);
        this.check();

    }

    connectedCallback(){
        if(this.getAttribute('open') != null && !isNaN(parseInt(this.getAttribute('open')))){

            let panel = [...this.querySelectorAll(':scope > edml-panel')][parseInt(this.getAttribute('open')-1)];

            if(panel != null){
                panel.classList.add('show');
            }
        }
    }
}
class edML_Accordionview extends edML_View{

    constructor(){
        super();        
        this.setTagWhitelist(["clonecontainer","groupview","title"]);
        this.setAttributeWhitelist(["name","tags","open"]);
        this.setRequiredTag([["groupview","clonecontainer"]]);
        this.setOnlyOnceTag(["title"]);
        this.setRemoveContentByClass(["edml-autotitle"]);
        this.setMixedContent(false);
                
        //to avoid fatal errors if groupview is missing
        if(this.querySelector(':scope > edml-groupview') == null){            
           this.prepend(new edML_Groupview());
        }
        
        this.check();

        if(this.getAttribute('label') != null){
            let label = document.createElement('div');
            label.innerText = this.getAttribute('label');
            label.classList.add('edml-accordionview-label');
            this.prepend(label);
        }

    }


    connectedCallback(){
        if(this.getAttribute('open') != null && !isNaN(parseInt(this.getAttribute('open')))){

            let gview = [...this.querySelectorAll(':scope > edml-groupview')][parseInt(this.getAttribute('open')-1)];
            if(gview != null){
                gview.classList.add('show');
            }
        }

        
    }
}                                                                                   
class edML_Affinespace extends edML_Inputvalue{

    constructor(){
        super();
        this.setTagWhitelist(['vector','linearspan']);
        this.setAttributeWhitelist([]);
        this.setMixedContent(false); 
        this.setRequiredAttribute([]);
        this.setRequiredTag(['vector','linearspan']);
        this.setOnlyOnceTag(['vector','linearspan']);
        this.check();

    }

    verify(value, model){    
        let resultobj = new Object();
        resultobj.solved = false;
        resultobj.solution = null;
        resultobj.credits = 0;
        if(model == null) model = this.getSubmodel(); 

        if(this.getAttribute('credits') != null && !isNaN(parseInt(this.getAttribute('credits')))) {
            resultobj.credits = parseInt(this.getAttribute('credits'));
         } else {
            resultobj.credits = model.credits;
        }

        let span = this.querySelector('edml-linearspan');
        let vector = this.querySelector('edml-vector');        
        if(span.verify(null).solved == true) {  
            //create augmented matrix          
            var diff = vector.getDifferenceVectorString();
            span.getValue();
            var spanVecs = span.getValue();
            var amatrix = "[";
            for(var i = 0; i < spanVecs.length; i++){
                amatrix += spanVecs[i].getString() + ",";
                
            }
            amatrix += diff + "]";

            let nerdamertext = "(" + amatrix + ")";

            nerdamer.flush();
            nerdamer.clearVars();
            nerdamer.setConstant('E', 'delete');
            var result = "";
            try{
                result = nerdamer(nerdamertext).evaluate().text('decimals');
            } catch(err) {

            }
            //result -> transposed array
            var tamatrix = new Array();
            var rows = result.split("],[");
            var bigDec = nerdamer.getCore().bigDec;
            for(var i = 0; i < rows.length; i++){
                tamatrix.push(new Array());
                var cols = rows[i].replaceAll("[","").replaceAll("]","").split(",");
                console.log(rows[i].replaceAll("[",""));
                for(var j = 0; j < cols.length; j++) {
                    tamatrix[i].push(bigDec(cols[j]));
                }
            }
            tamatrix = tamatrix[0].map((x, i) => tamatrix.map(x => x[i]));
            edML_Linearspan.calculateRowEchelonForm(tamatrix);
            var check = tamatrix.every(function (row) {
                var firstNonZeroIndex = row.findIndex(number => !number.equals(0));
                return firstNonZeroIndex != row.length - 1;
            });
            
            if(check){
                resultobj.solved = true;
            }
            

            
        }

        return resultobj;
    }
}
class edML_Allof extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["condition","oneof"]);
        this.setAttributeWhitelist([]);
        this.setRequiredAttribute([]);
        this.setRequiredTag([["condition","oneof"]]);
        this.setMixedContent(false);
        this.check();
    }

    getResult(){
        let result = true;
        var length = this.childNodes.length;
        var i = 0;
        while(i < length && result == true){
            if(this.childNodes[i].getResult() == false) result = false;
            i++;
        }

        return result;

        
    }
}
class edML_Applicationbox extends edML_Box{

    constructor(container){
        super();
        
        if(this.parentNode != null && this.parentNode.nodeName.toLowerCase() == 'edml-containers') {
            this.setAttributeWhitelist(["withsubtype"]);
            this.setTagWhitelist(["descriptor"]);
        } else {
            this.setAttributeWhitelist(["name","label","tags","subtype","numbered"]);
            this.setTagWhitelist(edML_Groups.getBlockGroup().concat(["title","parameter","parametergroup","enumerator","descriptor","subtitle"]));
        }
        this.setMixedContent(false);
        this.setOnlyOnceTag(["title","descriptor","enumerator","subtitle"]);
        this.setRemoveContentByClass(["edml-autotitle","edml-autodescriptor"]);
        this.check();


        if(this.querySelector(':scope > edml-title') == null){  // for compatiblity
            if(this.querySelector(':scope > edml-descriptor') == null){
                var descr = document.edmllocale.get('applicationbox.descriptor',this.closest('edml-variant').getAttribute('lang'));
                if(this.getAttribute('subtype') != null){  
                    if(document.edmllocale.get('applicationbox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang')) != null){
                        descr = document.edmllocale.get('applicationbox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang'));
                    } 
                }

                let descriptor = new edML_Descriptor(descr);
                descriptor.classList.add('edml-autodescriptor');
                this.prepend(descriptor);
            }

            if(this.querySelector(':scope > edml-enumerator') == null && (this.getAttribute('numbered') == "true" || (this.getAttribute('numbered') == null && edMLPlayer_Config.get('box.applicationbox.numbered') == true))){ 
                let enumerator = new edML_Enumerator();
                enumerator.classList.add('edml-autoenumerator');
                enumerator.classList.add('edml-applicationbox-numbering');
                this.prepend(enumerator);
            } 


            this.orderTitle();
            
        }

        

    }
    
    
}
class edML_Audio extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["metadata"]);
        this.setAttributeWhitelist(["name","tags","filepath"]);
        this.setMixedContent(false); 
        this.setRequiredAttribute(["filepath"]);
        this.setRequiredTag(["metadata"]);
        this.setOnlyOnceTag(["metadata"]);
        this.check();

        this.setAttribute('state','off');
        let path = this.getAttribute('filepath');


        this.audio = document.createElement('audio');
        this.append(this.audio);
        this.audio.classList.add('edml-audio-res');
        this.addEventListener('edmlevent-audioloaded',this.audioloaded.bind(this));
        this.audio.addEventListener('ended',this.ended.bind(this));
        this.audio.addEventListener('canplaythrough',this.canplay.bind(this));

        if(edMLPlayer_Config.get("player.isZip")){            
            this.getURLdata();                        
        } else {        
            if(path.indexOf("./") == 0) path = path.substring(2);         
            let dir = edMLPlayer_Config.get("player.file").substr(0,edMLPlayer_Config.get("player.file").lastIndexOf('/')+1);
            if(edMLPlayer_Config.get("player.ressourcepath") != ""){
                path = edMLPlayer_Config.get("player.ressourcepath") + path;
            } else {
                path = dir + path;  
            }    
            let event = new Event('edmlevent-audioloaded');
            this.audio.src = path;
            this.dispatchEvent(event);
        }
        
        

        //create buttons
            //play
        let playbtn = document.createElement('span');
        playbtn.classList.add('edml-audio-playbtn');
        playbtn.classList.add('edml-audio-btn');
        this.append(playbtn);
        playbtn.addEventListener('click',this.play.bind(this));
            //pause
        let pausebtn = document.createElement('span');
        pausebtn.classList.add('edml-audio-pausebtn');
        pausebtn.classList.add('edml-audio-btn');
        this.append(pausebtn);
        pausebtn.addEventListener('click',this.pause.bind(this));

            //duration
        let duration = document.createElement('span');
        duration.classList.add('edml-audio-duration');
        let durationleft = document.createElement('span');
        durationleft.classList.add('edml-audio-durationleft');
        let durationmiddle = document.createElement('span');
        durationmiddle.classList.add('edml-audio-durationmiddle');
        durationmiddle.innerText = " : ";
        let durationright = document.createElement('span');
        durationright.classList.add('edml-audio-durationright');
        duration.append(durationleft);
        duration.append(durationmiddle);
        duration.append(durationright);
        this.append(duration);

        
        //volume
        let volumesign = document.createElement('span');
        volumesign.classList.add('edml-audio-vsign');
        volumesign.classList.add('edml-icon');
        volumesign.classList.add('edml-icon-soundon');
        volumesign.innerHTML = " ";        
        volumesign.addEventListener('click',this.toggleVolume.bind(this));

        this.append(volumesign);
        let volume = document.createElement('input');
        volume.classList.add('edml-audio-volume');
        volume.type = "range";
        volume.min = "0";
        volume.max = "100";
        volume.value = "100";
        this.append(volume);
        this.oldvolume = null;
        volume.addEventListener('change',this.volumechange.bind(this));

 
        //scrollbar
        this.slider = document.createElement('input');
        this.slider.type = "range";
        this.slider.min = 0;
        this.slider.max = 100;
        this.slider.classList.add('edml-audio-slider');
        this.append(this.slider);
        this.slider.addEventListener('input',this.sliderchange.bind(this));

        
    }

    connectedCallback(){                
        
    }

    sliderchange(){
        var stop = false;
        if(!this.audio.ended && !this.audio.paused && this.audio.currentTime > 0){
            stop = true;
            this.audio.pause();
        }
        this.audio.currentTime = this.slider.value / 100 * this.audio.duration;
        let seconds = parseInt(Math.round(this.audio.currentTime));
        let minutes = parseInt(seconds / 60);
        seconds = seconds % 60;        
        this.querySelector('.edml-audio-durationleft').innerText = minutes + ":" + (seconds/100).toFixed(2).replace("0.","");  
        
        if(stop){
            this.audio.play();
        }
    }

    toggleVolume(){        
        if(this.oldvolume != null){
            this.querySelector('.edml-audio-volume').classList.remove('silent');
            this.audio.volume = this.oldvolume;
            this.querySelector('.edml-audio-vsign').classList.add('edml-icon-soundon');
            this.querySelector('.edml-audio-vsign').classList.remove('edml-icon-soundoff');
            this.querySelector('.edml-audio-volume').value = this.oldvolume*100;
            this.oldvolume = null;
            
        } else {
            this.oldvolume = (this.querySelector('.edml-audio-volume').value/100).toFixed(2);
            this.querySelector('.edml-audio-volume').value = 0;
            this.audio.volume = 0;
            this.querySelector('.edml-audio-volume').classList.add('silent');
            this.querySelector('.edml-audio-vsign').classList.add('edml-icon-soundoff');
            this.querySelector('.edml-audio-vsign').classList.remove('edml-icon-soundon');
        }
    }

    volumechange(){
        this.audio.volume = (this.querySelector('.edml-audio-volume').value/100).toFixed(2);
        if(this.audio.volume == 0){
            this.querySelector('.edml-audio-volume').classList.add('silent');
            this.querySelector('.edml-audio-vsign').classList.add('edml-icon-soundoff');
            this.querySelector('.edml-audio-vsign').classList.remove('edml-icon-soundon');
        } else {
            this.querySelector('.edml-audio-volume').classList.remove('silent');
            this.querySelector('.edml-audio-vsign').classList.add('edml-icon-soundon');
            this.querySelector('.edml-audio-vsign').classList.remove('edml-icon-soundoff');
        }
        
    }

    canplay(evt){
        let seconds = parseInt(Math.round(this.audio.duration));
        let minutes = parseInt(seconds / 60);
        seconds = seconds % 60;
        this.querySelector('.edml-audio-durationright').innerText = minutes + ":" + (seconds/100).toFixed(2).replace("0.","");  
        
        seconds = parseInt(Math.round(this.audio.currentTime));
        minutes = parseInt(seconds / 60);
        seconds = seconds % 60;        
        this.querySelector('.edml-audio-durationleft').innerText = minutes + ":" + (seconds/100).toFixed(2).replace("0.",""); 
    }

    currenttime(){
        let seconds = parseInt(Math.round(this.audio.currentTime));
        let minutes = parseInt(seconds / 60);
        seconds = seconds % 60;
        this.slider.value = this.audio.currentTime/this.audio.duration*100;
        this.querySelector('.edml-audio-durationleft').innerText = minutes + ":" + (seconds/100).toFixed(2).replace("0.","");  
        
    }

    audioloaded(evt){
        if(evt.url != null){
            this.audio.src = evt.url;
        }                           
    }


    play(){
        let state = this.getAttribute('state');
        if(state == "off"){
            this.fn = window.setInterval(this.currenttime.bind(this),50);
            this.audio.play();
            this.slider.classList.add('show');
            this.setAttribute("state","playing");
            this.slider.value = this.audio.currentTime/this.audio.duration*100;
        }
    }

    

    pause(){
        this.setAttribute("state","off");
        this.audio.pause();
        clearInterval(this.fn);     
    }



    ended(){
        this.setAttribute("state","off");
        this.slider.classList.remove('show');
        this.slider.value = 0;
        clearInterval(this.fn);
        this.querySelector('.edml-audio-durationleft').innerText = "0:00";
    }

   
    async getURLdata(){        
        let event = new Event('edmlevent-audioloaded');
        let path = this.getAttribute('filepath').trim();
        
        if(path.indexOf("./") == 0) path = path.substring(2); //zip file        

     
        let url = "";            
        if(edMLPlayer_Config.get("player.file").files[path] != null){
            let blobdata =  await edMLPlayer_Config.get("player.file").files[path].async("blob") ;
            url = URL.createObjectURL(blobdata);
            event.url = url;
            event.data = null;
        } else {
            console.error('file not found: ' + path);                
        }
            
                                   
        
        this.dispatchEvent(event);
    
    }


}
class edML_Autoref extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist(["name","tags","to"]);
        this.setMixedContent(false);    
        this.setRequiredAttribute(['to']);    
        this.check();
       

    }

    connectedCallback(){
        if(this.connected != true){
            this.connected = true;
            this.rename();           
        }
    }

    calculate(variant){
         //only for autoref in m tag
         let text = "\\text{"+this.rename(variant)+"}";         
         this.innerHTML = '\\href{'+window.location.toString().split('#')[0]+'#'+this.getAttribute('to')+'}{'+text+'}';   
    }

    rename(variant = null){
        if(variant == null) variant = this.closest('edml-variant'); 
        this.innerHTML = "";   
        let to = this.getAttribute('to');
        let text = "";
        if(to != null && variant != null){
            
            let item =  variant.querySelector('*[name="'+to+'"]');
            if(item instanceof edML_Mark && item.firstElementChild != null) item = item.firstElementChild;            
            if(item != null && item != undefined && this.querySelector(':scope > edml-ref') == null){
                if(item instanceof edML_Navitem){
                    if(item.querySelector(':scope > edml-ref, :scope > edml-link') != null) text = item.querySelector(':scope > edml-ref, :scope > edml-link').innerHTML;
                    this.append(new edML_Ref(to, document.edmllocale.get('autoref.navitem') + " <edml-quote>" + text + "</edml-quote>"));                
                } else if(item instanceof edML_Page){
                    if(item.querySelector(':scope > edml-title') != null) {
                        text = edML_edML2HTML.parse2string(item.querySelector(':scope > edml-title').getInnerEdML());
                    }
                    this.append(new edML_Ref(to, document.edmllocale.get('autoref.page') + " <edml-quote>" + text + "</edml-quote>"));
                } else if(item instanceof edML_Applicationbox || item instanceof edML_Conventionbox || item instanceof edML_Definitionbox || item instanceof edML_Examplebox || item instanceof edML_Exercisebox || item instanceof edML_Experimentbox || item instanceof edML_Formulabox || item instanceof edML_Helpbox || item instanceof edML_Hintbox || item instanceof edML_Infobox || item instanceof edML_Proofbox || item instanceof edML_Remarkbox || item instanceof edML_Textbox || item instanceof edML_Theorembox ){
                    if(item.querySelector(':scope > edml-title') != null) {  //depracted
                        text = "";
                        text = edML_edML2HTML.parse2string(item.querySelector(':scope > edml-title').getInnerEdML());
                        if(item.querySelector(':scope > edml-title > .'+item.nodeName.toLowerCase()+'-numbering') != null) text += " " + item.querySelector(':scope > edml-title > .'+item.nodeName.toLowerCase()+'-numbering').innerText;
                        
                        if(text.indexOf(document.edmllocale.get('autoref.'+item.nodeName.toLowerCase().replace('edml-',''))) != 0) text = document.edmllocale.get('autoref.'+item.nodeName.toLowerCase().replace('edml-','')) + " <edml-quote>" + text.trim() + "</edml-quote>";
                        this.append(new edML_Ref(to, text));
                    }
                    if(item.querySelector(':scope > edml-descriptor') != null){
                        text = "";
                        item.querySelectorAll(':scope > edml-descriptor, :scope > edml-enumerator').forEach(function(item){
                            text += " " + item.innerText;
                        });
                        //text = "<edml-quote>"+text.trim()+'</edml-quote>';
                        text = text.trim();
                        this.append(new edML_Ref(to, text));
                    }

                    
                } else if(item instanceof edML_Figureblock){
                    if(item.querySelector(':scope > edml-caption') != null) {
                        text = "";
                        if(item.querySelector(':scope > edml-caption > .edml-caption-label') != null) {
                            text = item.querySelector(':scope > edml-caption > .edml-caption-label').innerText; 
                            text = text.substring(0,text.length-2);
                        } else { 
                            text +=  edML_edML2HTML.parse2string(item.querySelector(':scope > edml-caption').getInnerEdML());
                            text = document.edmllocale.get('autoref.'+item.nodeName.toLowerCase().replace('edml-','')) + " <edml-quote>" + text.trim() + "</edml-quote>";
                       
                        }
                        if(text.indexOf(document.edmllocale.get('autoref.'+item.nodeName.toLowerCase().replace('edml-',''))) != 0) text = document.edmllocale.get('autoref.'+item.nodeName.toLowerCase().replace('edml-','')) + " <edml-quote>" + text.trim() + "</edml-quote>";
                        this.append(new edML_Ref(to, text));
                    }
                } else if(item instanceof edML_M) {                    
                    text = "";
                    if(item.querySelector(':scope > .edml-number-numbering') != null) {
                        text = document.edmllocale.get('autoref.m') + " " +  item.querySelector(':scope > .edml-number-numbering').innerText.replace("(","").replace(")","");
                        this.append(new edML_Ref(to, text));
                    } else {
                        if(item.closest('edml-page').querySelector(':scope > edml-title') != null) {
                            text = item.closest('edml-page').querySelector(':scope > edml-title').innerHTML;
                            this.append(new edML_Ref(to, document.edmllocale.get('autoref.m') + " " + document.edmllocale.get('autoref.onpage') + " <edml-quote>" + text.trim() + "</edml-quote>"));   
                        }
                    }
                    

                    
                    
                } else if(item instanceof edML_Picture) {
                    text = "";
                    var figblock = item.closest('figureblock');
                    if(figblock != null) {
                        if(figblock.querySelector(':scope > edml-caption > .edml-caption-label') != null) text = figblock.querySelector(':scope > edml-caption > .edml-caption-label').innerText;
                        text +=  edML_edML2HTML.parse2string(figblock.querySelector(':scope > edml-caption').getInnerEdML());
                        this.append(new edML_Ref(to, text));

                    } else {
                        text = item.closest('edml-page').querySelector(':scope > edml-title').innerHTML;
                        this.append(new edML_Ref(to, document.edmllocale.get('autoref.picture') + " " + document.edmllocale.get('autoref.onpage') +  " <edml-quote>" + text.trim() + "</edml-quote>"));
                    }
                
                } else if(item instanceof edML_Listitem || item instanceof edML_List){
                    $text = "";
                    if(item.querySelector(':scope > .edml-listitem-label') != null){
                        text = item.querySelector(':scope > .edml-listitem-label').innerText;
                        this.append(new edML_Ref(to, document.edmllocale.get('autoref.list') + " " + " <edml-quote>" + text.trim() + "</edml-quote>"));
                    } else {
                        if(item.closest('edml-page').querySelector(':scope > edml-title') != null) {
                            text = item.closest('edml-page').querySelector(':scope > edml-title').innerHTML;     
                            this.append(new edML_Ref(to, document.edmllocale.get('autoref.list') + " " + document.edmllocale.get('autoref.onpage') +  " <edml-quote>" + text.trim() + "</edml-quote>"));
                        }
                    }

                    

                } else if(item.closest('edml-page') != null && item.closest('edml-page').querySelector(':scope > edml-title') != null) {
                    text = item.closest('edml-page').querySelector(':scope > edml-title').innerHTML;
                    this.append(new edML_Ref(to, document.edmllocale.get('autoref.content') + " <edml-quote>" + text.trim() + "</edml-quote>"));
                }

            }            
            return text;
        }

        edMLPlayer_Util.typesetMath(this); 
    }
   


  

}
class edML_Blockquote extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup());
        this.setAttributeWhitelist(["name","tags"]);
        this.setMixedContent(false);       
        this.check();  
    }
}
class edML_Boolean extends edML_Inputvalue{


    constructor(){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist(["credits","model"]);
        this.setMixedContent(true);
        this.setRemoveContentByClass();
        this.check();  

        this.classList.add('unsolved');   
        if(this.parentNode instanceof edML_Input){
            
            this.key = new Uint8Array(32);
            for(let i =  0; i < 32; i++){
                this.key[i] = Math.floor(Math.random()*Number.MAX_SAFE_INTEGER);
            }
            let solution =  this.innerText.trim();
            if(solution != null){     
                if(solution == "true" || solution == "1") solution = 1; else solution = 0;
                let textBytes = aesjs.utils.utf8.toBytes(solution + (Math.random()*10000).toString());
                let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
                let encryptedBytes = aesCtr.encrypt(textBytes);
                let encryptedHex = aesjs.utils.hex.fromBytes(encryptedBytes);
                this.solution = encryptedHex;
                this.innerText = "";
            }

            
            this.addEventListener('click',this.onClick.bind(this)); 


            //define attributes values
            let model = this.closest('edml-input').getModel().getSubmodel('boolean');  
            for(var i = 0; i < this.getAttributeWhitelist().length; i++){
                this['attr_'+this.getAttributeWhitelist()[i]] = model[this.getAttributeWhitelist()[i]];
                if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) this['attr_'+this.getAttributeWhitelist()[i]] = this.getAttribute(this.getAttributeWhitelist()[i]);
            } 
        } else {
            //inputmodel
        
        }
        
    }



    

    onClick(){
        var msg = true;
        if(document.querySelector('edml-test.active') != null) msg = false;
        if(!this.closest('edml-input').classList.contains('disabled') && this.checkFunction(msg)){
            this.classList.toggle('selected');  
        }
    }

   
    


    getValue(){
        return this.classList.contains('selected');
    }

    getString(){
        if(this.classList.contains('selected')) return "true"; else return "false";
    }

    setValue(bool){
        if(bool == true || bool == 1 || bool == "true") this.classList.add('selected'); else this.classList.remove('selected');
    }

    verify(value, model){
        let solvedobj = new Object();
        solvedobj.solved = false;
        solvedobj.solution = null;
        solvedobj.credits = 0;
        solvedobj.penalty = 0;
        solvedobj.checked = false;
        
        this.removeAttribute('missed');
        this.classList.remove('unsolved');
        let input = this.closest('edml-input');

        if(this.solution != ""){
            if(model == null) model = this.closest("edml-input").getModel().getSubmodel("boolean");
            solvedobj.credits = this.getCredits();
            solvedobj.penalty = model.penalty;
            
            
            let encryptedBytes = aesjs.utils.hex.toBytes(this.solution);
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let decryptedBytes = aesCtr.decrypt(encryptedBytes);
            let decryptedText = aesjs.utils.utf8.fromBytes(decryptedBytes); 
            if(value == null) value = this.classList.contains('selected');
            
            if((value && decryptedText.charAt(0) == 1) ){  // solution is checked
                input.setAttribute('solved','true');                 
                solvedobj.solved = true;
                solvedobj.solution = this;
                solvedobj.checked = true;
                 
            } else if(value){  // checked, but no solution 
                solvedobj.solved = false; 
                input.setAttribute('solved','false'); 
                solvedobj.checked = true;       

            } else if(!value && decryptedText.charAt(0) == 1){  // wrong, because correct answer was not selected 
                input.setAttribute('solved','false');      
                input.classList.add('missed');                
                solvedobj.solved = false;   
            } else if(!value && decryptedText.charAt(0) == 0){// no-solution is unchecked
                input.setAttribute('solved','true');                                 
                solvedobj.solved = true;
                solvedobj.solution = this;
            }
        } 
        return solvedobj;       
    }



    getEdML(){
        let text = "";
        if(this.solution != ""){
            let encryptedBytes = aesjs.utils.hex.toBytes(this.solution);
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let decryptedBytes = aesCtr.decrypt(encryptedBytes);
            text = aesjs.utils.utf8.fromBytes(decryptedBytes).charAt(0); 
        }    
        if(text == 1 || text == "1") text = "true"; else text = "false"; 
        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 

        return '<boolean'+attr+'>' + text + '</boolean>';
    }

    save2SCORM(result){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true && (edMLPlayer_Config.get('player.scorm.testonly') != true || document.querySelector('edml-test.active') != null)){  
            let navitem = this.closest('edml-variant').querySelector('edml-navitem.selected');
            if(navitem != null) navitem = navitem.getAttribute('name');
            let exercisename = edML_SCORM.saveInputObjective(result,this.closest('edml-input'),this.getString());
            edML_SCORM.saveInteraction(this.closest('edml-page').getAttribute("name"),"other","input: boolean",navitem,exercisename,null);
        }
    }

    initFromSCORM(entrynb){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true && edMLPlayer_Config.get('player.scorm.testonly') != true) {
            this.setValue(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.description'));           
            if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "failed"){
                this.closest('edml-input').setAttribute('solved','false');
            } else if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "passed"){
                this.closest('edml-input').setAttribute('solved','true');
            }
            edMLPlayer_Functions.changeCredits(-this.lastCredits,false);
            this.lastCredits = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.score.raw');
        }

    }

    clear(){
        this.removeAttribute('solved');       
        this.classList.add('unsolved');
        this.classList.remove('selected');
    }
}
    
class edML_Booleangroup extends edML_Inputgroup{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup());
        this.setAttributeWhitelist(["check","defaultpenalty","expectedselection","feedback","maxselection","maxtotalcredits","maxtotalpenalty","minselection","name","reveal","tags","toggle"]);
        this.setMixedContent(true);        
        this.check();
        this.timer = null;
        this.lastCredits = 0;
        this.attempt = 0;
        this.connected = false;

        let counter = edMLPlayer_Config.get('player.inputcounter');        
        counter++;
        this.setAttribute('inputcounter',counter);
        edMLPlayer_Config.set('player.inputcounter',counter);

        this.querySelectorAll('edml-input > edml-boolean').forEach(function(item){
            if(document.querySelector('edml-test.active') == null) item.addEventListener('click',this.removeSolved.bind(this));
        }.bind(this));
    }

    connectedCallback(){
        if(this.connected == false) {
            this.connected = true;
        }

    }

    removeSolved(){
        this.querySelectorAll('edml-input > edml-boolean').forEach(function(item){
            item.closest('edml-input').removeAttribute('solved'); 
            item.closest('edml-input').classList.remove('missed');    
        });
    }

    getMaxCredits(){
        //calculate maximum credit points with respect to maxselection
        let val = 0;
        let creditarr = new Array();
        var model = this.getSubmodel(); 
        var maxtotalcredits = model.maxtotalcredits;  

        if(this.getAttribute('maxcredits') != null && !isNaN(parseInt(this.getAttribute('maxcredits')))){
            maxtotalcredits = parseInt(this.getAttribute('maxcredits'));
        }
        

        if(this.getAttribute('maxtotalcredits') != null && !isNaN(parseInt(this.getAttribute('maxtotalcredits')))){
            maxtotalcredits = parseInt(this.getAttribute('maxtotalcredits'));
        }

        if(this.getAttribute('maxcredits') == "unbounded" || this.getAttribute('maxtotalcredits') == "unbounded"){
            maxtotalcredits = "unbounded";
        }
        
        this.querySelectorAll('edml-input > edml-boolean').forEach(function(item){
            creditarr.push(item.parentNode.getMaxCredits());        
        });

        creditarr.sort(function(a, b) {return a - b;}); // sort array reverse: greatest value is first
        let len = creditarr.length-1;
        if(this.getAttribute('maxselection') != null && parseInt(this.getAttribute('maxselection')) < len){
            len = parseInt(this.getAttribute('maxselection'));
        }

        for(let i = len; i >= 0; i--){
            val += creditarr[i];
        }
        

        if(this.getAttribute('maxcredits') != null && parseInt(this.getAttribute('maxcredits')) < val){
            val = parseInt(this.getAttribute('maxcredits'));
        }  // old style for compability

        if(maxtotalcredits != "unbounded" && maxtotalcredits < val){
            val = maxtotalcredits;
        } 
        

        return val;
    }

    getMaxPenalty(){
        //calculate maximum penalty points with respect to maxselection
        let val = 0;
        let penaltyarr = new Array();
        var model = this.getSubmodel();   
        
        this.querySelectorAll('edml-input > edml-boolean').forEach(function(item){
            penaltyarr.push(item.parentNode.getMaxPenalty());        
        });

        penaltyarr.sort(function(a, b) {return a - b;});
        let len = penaltyarr.length-1;
        if(this.getAttribute('maxselection') != null && parseInt(this.getAttribute('maxselection')) < len){
            len = parseInt(this.getAttribute('maxselection'));
        }

        for(let i = len; i >= 0; i--){
            val += penaltyarr[i];
        }

        if(this.getAttribute('maxpenalty') != null && parseInt(this.getAttribute('maxpenalty')) < val){
            val = parseInt(this.getAttribute('maxpenalty'));
        } // old style for compability

        if(this.getAttribute('maxtotalpenalty') != null && parseInt(this.getAttribute('maxtotalpenalty')) < val){
            val = parseInt(this.getAttribute('maxtotalpenalty'));
        } else if(model.maxtotalpenalty != "unbounded" && model.maxtotalpenalty < val){
            val = model.maxtotalpenalty;
        }

     
        return val;
    }


    
    
    verify(value,model){

        if(model == null) model = this.getSubmodel();   

        let minsel = parseInt(this.getAttribute("minselection"));
        if(minsel == null || isNaN(minsel)) minsel = model.minselection;
        let maxsel = parseInt(this.getAttribute("maxselection"));
        if(maxsel == null || maxsel == "unbounded" || isNaN(maxsel)) maxsel = model.maxselection;
        let expectedselection = model.expectedselection;
        if(this.getAttribute('expectedselection') != null && (!isNaN(this.getAttribute('expectedselection')) || this.getAttribute('expectedselection') == "none")){
             expectedselection =this.getAttribute('expectedselection');
            
        }

        var onlycheckedcredits = model.onlycheckedcredits;


        if(!isNaN(expectedselection)){
            expectedselection = parseInt(expectedselection);
        } else {
            expectedselection = "none";
        }

        let feedback = model.feedback;
        if(this.getAttribute('feedback') != null) feedback = this.getAttribute('feedback');
 

        let countProcessed = 0;

        let solvedobj = new Object();
        solvedobj.solved = false;
        solvedobj.solution = null;
        solvedobj.credits = 0;
        solvedobj.penalty = 0;

        
        this.querySelectorAll('edml-input > edml-boolean.selected').forEach(function(item){
            countProcessed++;    
        });
        if(countProcessed >= minsel){
            let result;
            if(onlycheckedcredits || maxsel == 1){
                this.querySelectorAll('edml-input > edml-boolean').forEach(function(item){                
                    result = item.parentNode.verify();                                           
                    if(result.solved && result.checked){
                        solvedobj.credits += result.credits;
                    } else if((result.solved == false && result.checked) ){ // no-solution is checked --> penalty , solution is unchecked --> no points
                        solvedobj.penalty += result.penalty;
                    }
                
                });  
            } else {
                this.querySelectorAll('edml-input > edml-boolean').forEach(function(item){                
                    result = item.parentNode.verify();                
                    if(result.solved){
                        solvedobj.credits += result.credits;
                    } else if(result.solved == false){ 
                        solvedobj.penalty += result.penalty;
                    }
                
                }); 
            }

            //verify group result            
            let solvedlen = this.querySelectorAll('edml-input[solved="true"] > edml-boolean.selected').length;
            let missedlen = this.querySelectorAll('edml-input.missed > edml-boolean').length;
            let faillen = this.querySelectorAll('edml-input[solved="false"]:not(.missed) > edml-boolean').length;            

            if(missedlen > 0 && expectedselection=="none"){ // missed input could have been selected
                this.setAttribute('solved','false'); 
            } else if(expectedselection!="none" && solvedlen < expectedselection){
                this.setAttribute('solved','false'); 
            } else if(faillen > 0){
                this.setAttribute('solved','false'); 
            } else {
                this.setAttribute('solved','true'); 
                solvedobj.solved = true;
            }


            if(feedback != "detailed") {
                this.querySelectorAll('edml-input > edml-boolean').forEach(function(item){
                    item.parentNode.removeAttribute('solved');
                });
            }
            

            //remove solved from boolean
           // this.removeSolved();

        } else {
            if(document.querySelector('edml-test.active') == null && document.querySelector('edml-test.nodialog') == null){
                let dlg = new edML_Dialog();
                dlg.setDangerTitle(false);
                dlg.setTitle(document.edmllocale.get("dialog_title_hint"));
                dlg.setBody(document.edmllocale.get("dialog_body_tolittleselected"));
                dlg.hideFooter();
                dlg.show(); 
                solvedobj = null; 
            }             
        }

        this.timer = null;  
        //console.log(solvedobj);             
        return solvedobj;
    }

    checkShowCheckButton(){
        return true;
    }

    getUserCredits(){
        return this.lastCredits;
    }

    evaluateCredits(result){
        if(result != null) {
            let val = result.credits - result.penalty;            
            if(val < this.getMaxPenalty()){
                val = this.getMaxPenalty();
            } 
            if(val > this.getMaxCredits()){
                val = this.getMaxCredits();
            } 
            edMLPlayer_Functions.changeCredits(-1 * this.lastCredits, false);
            edMLPlayer_Functions.changeCredits(val, true);                            
            this.setAttribute('achievedcredits',val);
            this.lastCredits = val;
        }
    }


    checkSelection(obj){
        let change = true;

        let maxsel = parseInt(this.getAttribute("maxselection"));
        if(maxsel == null || isNaN(maxsel)) maxsel = Infinity;
    
        if(maxsel == 1){    //Single Choice
            this.querySelectorAll('edml-boolean').forEach(function(item){
                if(item != this){                        
                    item.classList.remove('selected');
                    item.classList.remove('unsolved');
                    item.removeAttribute('solved');                                 
                }
            });
        } else {
            let maxsel = parseInt(this.getAttribute('maxselection'));
            let minsel = parseInt(this.getAttribute("minselection"));
            if(minsel == null || isNaN(minsel)) minsel = 1;

            let selected = 0;
            this.querySelectorAll('edml-boolean').forEach(function(item){
                if(item.classList.contains('selected')) selected++;                    
            });
            
            if(selected >= maxsel && !obj.classList.contains('selected')){ 
                change = false;
                let dlg = new edML_Dialog();
                dlg.setDangerTitle(false);
                dlg.setTitle(document.edmllocale.get("dialog_title_hint"));
                dlg.setBody(document.edmllocale.get("dialog_body_tomanyselected"));
                dlg.hideFooter();
                dlg.show();
            }


            
        }                      
        return change;
    }

    getValue(){
        let arr = new Array();
        this.querySelectorAll(':scope edml-input > edml-boolean').forEach(function(item){
            arr.push(item.getValue());
        });
        return arr;
    }

    getString(){
        return JSON.stringify(this.getValue());
    }


    save2SCORM(result){        
        if(edMLPlayer_Config.get("player.scorm.enabled") == true){  
            let navitem = this.closest('edml-variant').querySelector('edml-navitem.selected');
            if(navitem != null) navitem = navitem.getAttribute('name');
            let exercisename = edML_SCORM.saveInputObjective(result,this,this.getString());
            edML_SCORM.saveInteraction(this.closest('edml-page').getAttribute("name"),"other","input: boolean",navitem,exercisename,null);
        }
    }

    initFromSCORM(entrynb){
       // let input = this.querySelector(':scope > .edml-expression-input');
        let value = JSON.parse(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.description'));
        let i = 0;
        
        this.querySelectorAll(':scope edml-input > edml-boolean').forEach(function(item){
            item.setValue(value[i]);
            i++;
        });
    
   
        if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "failed"){
            this.setAttribute('solved','false');
        } else if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "passed"){
            this.setAttribute('solved','true');
        }
        this.lastCredits = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.score.raw');
        this.verify();
    }

    clear(){
        this.removeAttribute('solved');    
        this.querySelectorAll('edml-boolean').forEach(function(item){
            item.clear();
        });
    }

    checkSolutionhint(solvedobj){        
        let hint = document.querySelector('edml-variant.active edml-solutionhint[to="'+this.getAttribute('name')+'"]');
        if(this.getAttribute('name') != null && hint != null){
            this.attempt++;
        }

        let reveal = this.getModel().reveal;
        if(this.getAttribute("reveal") != null && !isNaN(parseInt(this.getAttribute("reveal")))) reveal = parseInt(this.getAttribute("reveal"));                       
        if(solvedobj.solved != true && reveal <= this.attempt && hint != null) {
  
            if(this.querySelector('.edml-solutionhint-btn') == null){
                let btn = document.createElement('span');
                btn.classList.add('edml-solutionhint-btn');
                this.prepend(btn);
                
                btn.addEventListener('click',function(){                                       
                    edML_DialogSolutionhint.show(hint); 
                });
            }   
        }
        
    }

    getStateObject(){
        var obj = new Object();
        if(this.getAttribute('solved') == 'true') {
            obj.solved = true;
        } else obj.solved = false;
        if(this.getAttempts('solved') == null){
            obj.solved = null;
        }

        if(this.getAttribute('achievedcredits') != null) {
            obj.credits = parseInt(this.getAttribute('achievedcredits'));
        } else obj.credits = 0;

        obj.type = this.querySelector(':scope > *').nodeName.toLowerCase().replace('edml-','');
        
        return obj;
    }
}
class edML_Br extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist([]);
        this.setMixedContent(false);   
        this.check();
        this.innerHTML = '<br/>';
        
    }
    
    
    //override
    getEdML(){
        return '<br/>';
    }
}
class edML_Button extends edML_Tag{

    constructor(to = null){
        super();
        var tags = edML_Groups.getInlineGroup();
        tags = tags.splice(tags.indexOf("button"),1);
        tags = tags.splice(tags.indexOf("ref"),1);
        tags = tags.splice(tags.indexOf("link"),1);

        this.setTagWhitelist(tags);
        this.setAttributeWhitelist(["to","name","tags"]);
        this.setMixedContent(true); 
        this.setRequiredAttribute([]);
        this.setRequiredTag([]);
        this.setOnlyOnceTag([]);
        this.check();

        if(to != null){
            this.setAttribute('to',to);
        }

        if(this.getAttribute('to') != null){
            this.addEventListener('click',this.onClick.bind(this));
        }
    }

    onClick(evt){
        let obj = this.closest('edml-variant').querySelector('*[name="'+this.getAttribute('to')+'"]');
        if(obj != null){

            if(obj instanceof edML_Frame){
                let interaction = obj.closest('edml-interaction');
                interaction.querySelector(':scope > edml-frame.show').classList.remove('show');
                obj.refresh();
                obj.classList.add('show');

            } else {
                let page = obj.closest('edml-page');
                if(page != null){            
                    let navitem = this.closest('edml-variant').querySelector('edml-navitem edml-ref[to="'+page.getAttribute('name')+'"]');
                    if(navitem != null) {
                        navitem = navitem.closest('edml-navitem');
                        if(this.closest('edml-variant').querySelector('edml-navitem.selected') != null) this.closest('edml-variant').querySelector('edml-navitem.selected').classList.remove('selected');                        
                    } else {
                        let testitem = document.querySelector('edml-variant.active edml-test.active[name="'+page.getAttribute('name')+'"]');
                        if(testitem != null) {
                            event.navitem = testitem;
                            if(this.closest('edml-variant').querySelector('edml-testitem.selected') != null) this.closest('edml-variant').querySelector('edml-testitem.selected').classList.remove('selected');    
                        }
                    }
                    


                    let event = new Event('edmlevent-changepage');
                    event.navitem = navitem;                        //navitem to select
                    event.page = page;                              // page to open
                    event.container = obj;                         // container to move the focus on page
                    event.reftype = "page";
                    document.dispatchEvent(event);
                
                } else if(obj != null && obj instanceof edML_Navitem){
                    obj.click();
                    
                } else if(obj != null && obj instanceof edML_Testitem){
                    obj.click();
                } else if(obj != null && obj instanceof edML_Test){
                    let navitem = this.closest('edml-variant').querySelector('edml-navitem edml-ref[to="'+this.getAttribute('to')+'"]');
                    navitem.closest('edml-navitem').dispatchEvent(new Event("click"));
                } else {
                    edML_Error.push("0006",this.outerHTML,this.getAttribute('to'));
                    edML_Error.printLast();
                    
                }
            }  
        } else {
            if(this.getAttribute('to').indexOf('http') > -1){
                var link = document.createElement('a');
                link.setAttribute('href',this.getAttribute('to'));
                link.setAttribute('target',"_blank");
                link.click();
                link.remove();

            } else {
                edML_Error.push("0006",this.outerHTML,this.getAttribute('to'));
                edML_Error.printLast();
            }
        }
    }

}
class edML_Calc extends edML_Tag{

    constructor(){
        super();
        
        this.setTagWhitelist([]);
        this.setAttributeWhitelist(['simplify','numberformat']);
        this.setMixedContent(true);
        this.check(); 
        this.identifier = this.innerText;
        

    }

    connectedCallback(){
        if(this.connected == null){      
            //let obj = this;      
            //window.setTimeout(function() {obj.calculate()},2000);
            this.calculate();
            if(this.identifier.search(/\$\(.*?\)/g) > -1){
                this.classList.add('pagerefresh');
            }
        }
    }

    
    calculate(){
        //edMLPlayer_Util.sleep(10000);
        this.connected = true;
        let parentbox = this.parentNode;
        
        while(parentbox instanceof edML_Box == false && parentbox != null){
            parentbox = parentbox.parentNode;
        }

        let simplify = "simplify";
        if(this.getAttribute('simplify') == "false"){
            simplify = "";
        }

        let numberformat = "";
        if(this.getAttribute('numberformat') != null){
            numberformat = this.getAttribute('numberformat');

        }

        let calcval = this.identifier;
        calcval = calcval.replaceAll(/\$\(.*?\)/g,edMLPlayer_Util.replaceVariables.bind(this));
        calcval = calcval.replace(/(\r\n|\n|\r)/gm, "");
        calcval = calcval.trim();
        nerdamer.flush();
        nerdamer.clearVars();
            
        if(parentbox != null && parentbox.parameters != null){
            
            for(let i = 0; i < parentbox.parameters.length; i++){
                nerdamer.setVar(parentbox.parameters[i],parentbox.values[i]);
            }              
        }
        

        try{
            let value;
            if(numberformat.indexOf("decimals") == 0){
                var decimal = "12";
                if(this.closest('edml-m') == null){
                    
                   // window.setTimeout(function(){console.log(nerdamer('simplify(sqrt(6))').evaluate().text('decimals'))},1000);
                    value = nerdamer(simplify+'('+calcval+')').evaluate().text("decimals",decimal);
                } else {
                    // converToLaTeX always produce fractions: value = nerdamer.convertToLaTeX(nerdamer(simplify+'('+this.identifier+')').text("decimals",decimal));
                    value = nerdamer(simplify+'('+calcval+')').evaluate().text("decimals",decimal);
                }
                if(numberformat.replace('decimals ','').trim() != "" && !isNaN(parseInt(numberformat.replace('decimals ','')))){
                    var decnb = parseInt(numberformat.replace('decimals ','').trim());
                    var pos = value.indexOf(".");
                    
                    if(pos > -1){
                        value = value.substr(0,pos+decnb+1);
                    }
                    var difflen = decnb - value.length + pos + 1;
                    console.log(difflen);
                    for(var diff = 0; diff < difflen; diff++){
                        value = value + "0";
                    }



                }

                if(edMLPlayer_Config.get("course.decimalseparator") != "."){
                    value = value.replaceAll(",",";");
                    value = value.replaceAll(".",edMLPlayer_Config.get("course.decimalseparator"));
                }

                
                
            } else {
                if(this.closest('edml-m') == null){
                    value = nerdamer(simplify+'('+calcval+')').text();
                    var value02 = nerdamer(simplify+'('+calcval+')').toTeX();
                    if(value02.indexOf("\\frac{") > -1){
                        value = value02.replaceAll(/\\frac{(.*?)}{(.*?)}/gm,"$1/$2");                    
                    }

                } else {
                    value = nerdamer(simplify+'('+calcval+')').toTeX();
                }
            }
            
            this.innerHTML = value;
        } catch(e){
            console.log(e);
        }

       
        
                                    
    }  
    

    getEdML(){
        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"';
        }
        return '<calc'+attr+'>' + this.identifier + '</calc>';
    }



}
class edML_Caption extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getInlineGroup());
        this.setAttributeWhitelist([]);
        this.setMixedContent(true);
        this.check();
        
    }


    connectedCallback(){
        this.autoNumbering();
    }

    autoNumbering(){
        if(this.closest('edml-figureblock').isNumbered()){
            var text = "";
            var type =  this.closest('edml-figureblock').getType();

            
            
            text = document.edmllocale.get('figureblock.'+type,this.closest('edml-variant').getAttribute('lang'));

            if(this.closest('edml-figureblock').getCount() != null) {
                text += " " + this.closest('edml-figureblock').getCount();
                if(this.innerText.trim() != "") text += document.edmllocale.get('figureblock.symbol')+" ";
            }
            
        
            
            
            if(this.querySelector(':scope > .edml-caption-label') != null) {
                this.querySelector(':scope > .edml-caption-label').innerText = text;

            } else {
                var numberLabel = document.createElement('span');
                numberLabel.classList.add('edml-caption-label');
                numberLabel.classList.add('autolabel');
                numberLabel.innerText = text;
                this.prepend(numberLabel);
            }
        }
        
    }
}
class edML_Carouselview extends edML_View{

    constructor(){
        super();        
        this.setTagWhitelist(["groupview","title","clonecontainer"]);
        this.setAttributeWhitelist(["autostep", "label","loop","name","tags","fixedheight","indicator"]);
        this.setRequiredTag([["groupview","clonecontainer"]]);
        this.setOnlyOnceTag(["title"]);
        this.setMixedContent(false);
        
        if(this.querySelector(':scope > edml-groupview, :scope > edml-clonecontainer') == null){            
            this.prepend(new edML_Groupview());
        }
        this.check();
        

        //create gui elements
        this.toolbar = document.createElement('div');
        this.toolbar.classList.add('edml-carouselview-toolbar');
        this.append(this.toolbar);

        this.leftbtn = document.createElement('div');
        this.leftbtn.classList.add('edml-carouselview-leftbtn');
        this.append(this.leftbtn);

        this.rightbtn = document.createElement('div');
        this.rightbtn.classList.add('edml-carouselview-rightbtn');
        this.append(this.rightbtn);

        this.toolbartitle = document.createElement('div');
        this.toolbartitle.classList.add('edml-carouselview-toolbar-title');
        if(this.querySelector('edml-groupview > edml-title') != null) {
            this.toolbartitle.innerHTML = this.querySelector('edml-groupview > edml-title').innerHTML;
            this.toolbartitle.classList.add('active');
        }
        
        this.toolbar.append(this.toolbartitle);

        

        if(this.getAttribute('indicator') == "slider"){
            let toolbarslider = document.createElement('div');
            toolbarslider.classList.add('edml-carouselview-toolbar-slider');
            this.slider = document.createElement('input');
            toolbarslider.classList.add('edml-carouselview-slider');
            let len = [...this.querySelectorAll(':scope > edml-groupview')].length;
            this.slider.type ="range";
            this.slider.min = 0;
            this.slider.max = len-1;
            this.slider.value = 0;
            toolbarslider.append(this.slider);
            this.toolbar.append(toolbarslider);

            //register dot click
            this.slider.addEventListener('change',this.onSliderChange.bind(this));

        } else {
            this.toolbardots = document.createElement('div');
            this.toolbardots.classList.add('edml-carouselview-toolbar-dots');
            let dots = "";
            this.querySelectorAll(':scope > edml-groupview').forEach(function(item){
                dots += '<span class="edml-carouselview-toolbar-dot"></span>';
            }.bind(this));
            this.toolbardots.innerHTML = dots;
            this.toolbar.append(this.toolbardots);
            if(this.querySelector(':scope  .edml-carouselview-toolbar-dot') != null) this.querySelector(':scope  .edml-carouselview-toolbar-dot').classList.add('active');

            //register dot click
            this.toolbardots.querySelectorAll(':scope > .edml-carouselview-toolbar-dot').forEach(function(item){
                item.addEventListener('click',this.onDotClick.bind(this));
            }.bind(this));
        }
        


        //register prev, next button click
        this.rightbtn.addEventListener('click',this.onNext.bind(this));
        this.leftbtn.addEventListener('click',this.onPrev.bind(this));


        //label
        if(this.getAttribute('label') != null){
            let label = document.createElement('div');
            label.classList.add('edml-carouselview-label');
            label.innerHTML = this.getAttribute('label');
            this.prepend(label);            
        }
        

        this.connected = false;
    
    }

    connectedCallback(){
        if(this.connected == false){
            this.connected = true;

            if(this.querySelector(':scope > edml-title') != null) {
                this.classList.add('hastitle');
            }
            //this.setAttribute('fixedheight','false');
            this.length = [...this.querySelectorAll(':scope > edml-groupview')].length;
            let idx = 0;
            this.activeindex = 0;
            this.querySelectorAll(':scope > edml-groupview').forEach(function(item){
                item.setAttribute('index',idx);
                idx++;
            });


            
            if(this.querySelector(':scope > edml-groupview') != null) {
                this.querySelector(':scope > edml-groupview').classList.add('active');   

                if(this.getAttribute('fixedheight') != "false" && this.getAttribute('fixedheight') != "0"){
                    this.querySelector(':scope > edml-groupview').append(this.querySelector('.edml-carouselview-toolbar'));
                }
            }
            this.checkPrevNextButton();
            let autostep = this.getAttribute('autostepafter'); // old variant
            if(autostep == null) autostep = this.getAttribute('autostep');
            if(autostep != null && !isNaN(parseInt(autostep))) {
                this.interval = setInterval(this.autostep.bind(this),parseInt(autostep * 1000));
            }

            
        }
        
    }

    onSliderChange(evt){
        let index = parseInt(this.slider.value)+1;

        if(this.querySelector(':scope > edml-groupview.active') != null) this.querySelector(':scope > edml-groupview.active').classList.remove('active');
        if(this.getAttribute('fixedheight') != "false" && this.getAttribute('fixedheight') != "0"){
            this.querySelector(':scope > edml-groupview[index="'+(index-1)+'"]').classList.add('active');
            this.prepend(this.querySelector(':scope > edml-groupview[index="'+(index-1)+'"]'));  
            this.querySelector(':scope > edml-groupview[index="'+(index-1)+'"]').append(this.querySelector('.edml-carouselview-toolbar'));              
            
        } else {
            if(this.querySelector(':scope > edml-groupview:nth-of-type('+index+')') != null) this.querySelector(':scope > edml-groupview:nth-of-type('+index+')').classList.add('active');
            
        }

        this.activeindex = index-1;

        if(this.querySelector(':scope > edml-groupview.active > edml-title') != null) {
            this.toolbartitle.innerHTML = this.querySelector(':scope > edml-groupview.active > edml-title').innerHTML;
            this.toolbartitle.classList.add('active');
        } else {
            this.toolbartitle.classList.remove('active');
        }

        this.checkPrevNextButton();
    }

    onDotClick(evt){
        let dot = evt.target;
        var index = Array.prototype.indexOf.call(this.toolbardots.querySelectorAll(':scope > .edml-carouselview-toolbar-dot'), dot) + 1;
        if(this.querySelector(':scope > edml-groupview.active') != null) this.querySelector(':scope > edml-groupview.active').classList.remove('active');
        if(this.getAttribute('fixedheight') != "false" && this.getAttribute('fixedheight') != "0"){
            this.querySelector(':scope > edml-groupview[index="'+(index-1)+'"]').classList.add('active');
            this.prepend(this.querySelector(':scope > edml-groupview[index="'+(index-1)+'"]'));  
            this.querySelector(':scope > edml-groupview[index="'+(index-1)+'"]').append(this.querySelector('.edml-carouselview-toolbar'));              
            
        } else {
            if(this.querySelector(':scope > edml-groupview:nth-of-type('+index+')') != null) this.querySelector(':scope > edml-groupview:nth-of-type('+index+')').classList.add('active');
            
        }
        this.toolbardots.querySelector(':scope > .edml-carouselview-toolbar-dot.active').classList.remove('active');
        this.activeindex = index-1;

        if(this.querySelector(':scope > edml-groupview.active > edml-title') != null) {
            this.toolbartitle.innerHTML = this.querySelector(':scope > edml-groupview.active > edml-title').innerHTML;
            this.toolbartitle.classList.add('active');
        } else {
            this.toolbartitle.classList.remove('active');
        }

        dot.classList.add('active');
        this.checkPrevNextButton();

    }

    onNext(){
        let active = this.querySelector(':scope > edml-groupview.active');
        if(active != null){
            this.activeindex++;
            let next = this.querySelector(':scope > edml-groupview[index="'+this.activeindex+'"');
            
            
            if(next == null){
                next = this.querySelector(':scope > edml-groupview[index="0"]'); //select first one and make it next
                this.activeindex = 0;
            } 

            if(next != null){
                active.classList.remove('active');
                next.classList.add('active');
                if(this.getAttribute('fixedheight') != "false" && this.getAttribute('fixedheight') != "0"){
                    this.prepend(next);
                    next.append(this.querySelector('.edml-carouselview-toolbar'));
                }


                if(next.querySelector(':scope > edml-title') != null) {
                    this.toolbartitle.innerHTML = next.querySelector(':scope > edml-title').innerHTML;
                    this.toolbartitle.classList.add('active');
                } else {
                    this.toolbartitle.classList.remove('active');     
                }

                if(this.getAttribute('indicator') == "slider"){
                    if(this.slider.value < this.slider.max) this.slider.value++; else this.slider.value = 0;
                } else {
                    let dot = this.toolbardots.querySelector(':scope > .edml-carouselview-toolbar-dot.active');
                    if(dot.nextElementSibling != null) {
                        dot.nextElementSibling.classList.add('active'); 
                        dot.classList.remove('active');
                    } else {
                        dot.classList.remove('active');
                        this.toolbardots.querySelector(':scope > .edml-carouselview-toolbar-dot').classList.add('active');
                    }
                }
            }
        }
        this.checkPrevNextButton();
    }


    onPrev(){
        let active = this.querySelector(':scope > edml-groupview.active');
        if(active != null){
            this.activeindex--;
            let prev = this.querySelector(':scope > edml-groupview[index="'+this.activeindex+'"');
            

            if(prev == null){                
                prev = this.querySelector(':scope > edml-groupview:last-of-type');
                this.activeindex = prev.getAttribute('index');
            }

            if(prev != null){
                active.classList.remove('active');
                prev.classList.add('active');

                if(this.getAttribute('fixedheight') != "false" && this.getAttribute('fixedheight') != "0"){
                    this.prepend(prev);
                    prev.append(this.querySelector('.edml-carouselview-toolbar'));
                }

                if(prev.querySelector(':scope > edml-title') != null) {
                    this.toolbartitle.innerHTML = prev.querySelector(':scope > edml-title').innerHTML;
                    this.toolbartitle.classList.add('active');
                } else {
                    this.toolbartitle.classList.remove('active');
                }

                if(this.getAttribute('indicator') == "slider"){
                    if(this.slider.value > 0) this.slider.value--; else this.slider.value = this.slider.max;
                } else {
                    let dot = this.toolbardots.querySelector(':scope > .edml-carouselview-toolbar-dot.active');
                    if(dot.previousElementSibling != null) {
                        dot.previousElementSibling.classList.add('active'); 
                        dot.classList.remove('active');
                    } else {
                        this.toolbardots.querySelector(':scope > .edml-carouselview-toolbar-dot:last-of-type').classList.add('active');
                        dot.classList.remove('active');
                    }
                }
            }
        }
        this.checkPrevNextButton();
    }

    checkPrevNextButton(){
        let loop = false;
        if(this.getAttribute('loop') == "true" || this.getAttribute('loop') == "1") loop = true;

       
        if(this.activeindex == 0 && loop == false){
            this.leftbtn.classList.remove('active');            
        } else {
            this.leftbtn.classList.add('active');            
        }

        if(this.activeindex == this.length - 1 && loop == false){
            this.rightbtn.classList.remove('active');            
        } else {
            this.rightbtn.classList.add('active');            
        }

    }

    autostep(){
        this.onNext();
    }
}  
class edML_Case extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup().concat(["condition","oneof","allof"]));
        this.setAttributeWhitelist([]);
        this.setRequiredAttribute([]);
        this.setRequiredTag([["condition","oneof","allof"]]);
        this.setOnlyOnceTag(["condition","oneof","allof"]);
        this.setMixedContent(false);
        this.check();
    }


}
class edML_Cell extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup());
        this.setAttributeWhitelist(["name","tags","valign","align"]);
        this.setMixedContent(false); 
        this.check();



       
    }

   



}
class edML_Chain extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist(["credits"]);
        this.setMixedContent(true); 
        this.check();
    }

    encode(key){
        let textBytes = aesjs.utils.utf8.toBytes(this.innerText.trim());            
        let aesCtr = new aesjs.ModeOfOperation.ctr(key, new aesjs.Counter(5));
        let encryptedBytes = aesCtr.encrypt(textBytes); 
        let encryptedHex = aesjs.utils.hex.fromBytes(encryptedBytes);
        this.innerText = encryptedHex; 

    }

    decode(key){
        if(key != null && key != ""){
            let encryptedBytes = aesjs.utils.hex.toBytes(this.innerText.trim());
            let aesCtr = new aesjs.ModeOfOperation.ctr(key, new aesjs.Counter(5));
            let decryptedBytes = aesCtr.decrypt(encryptedBytes);
            return aesjs.utils.utf8.fromBytes(decryptedBytes); 
        } else {
            return this.innerText;
        }
    }

    getEdML(key){
        let edml = "";
        if(key != null && key != ""){
            let encryptedBytes = aesjs.utils.hex.toBytes(this.innerText);
            let aesCtr = new aesjs.ModeOfOperation.ctr(key, new aesjs.Counter(5));
            let decryptedBytes = aesCtr.decrypt(encryptedBytes);
            edml = aesjs.utils.utf8.fromBytes(decryptedBytes); 
        } else {
            edml = this.innerText;
        }
            

        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 
        if(attr.length > 0) attr = " " + attr;
        edml = '<chain'+attr+'>'+edml+'</chain>';

        return edml;
    }



}
class edML_Chains extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["chain"]);
        this.setAttributeWhitelist([]);
        this.setMixedContent(false); 
        this.setRequiredTag(["chain"]);
        this.check();
    }

    getEdML(key){
        let text = "";
        let chainkey = key;
        this.querySelectorAll(':scope > edml-chain').forEach(function(item){
            text += item.getEdML(chainkey);
        });

        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 
        return '<chains'+attr+'>' + text + '</chains>';
    }



}
class edML_Choice extends edML_Inputvalue{

    constructor(){
        super();
        this.setTagWhitelist(["option"]);
        this.setAttributeWhitelist(["credits","model","shuffle"]);
        this.setRequiredTag(["option"]);
        this.setMixedContent(false);        
        this.check();

        this.lastCredits = 0;  
        this.rendered = false;

        this.classList.add('unsolved'); 
      

        let span = document.createElement('span');
        span.classList.add('edml-choice-selected');
        span.innerText = "-";
        this.prepend(span);

        
        let solutions = "";
        let correct;
        this.querySelectorAll(':scope > edml-option').forEach(function(item){ 
            if(item.getAttribute('correct') != null) correct = item.getAttribute('correct'); else correct = "false";  
            solutions += "#" + correct;
            item.removeAttribute('correct');
        });         

        
        //create encrypted solution
        this.key = new Uint8Array(32);
        for(let i =  0; i < 32; i++){
            this.key[i] = Math.floor(Math.random()*Number.MAX_SAFE_INTEGER);
        }

        if(solutions.length > 0) solutions = solutions.substring(1);

        let textBytes = aesjs.utils.utf8.toBytes(solutions);            
        let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
        let encryptedBytes = aesCtr.encrypt(textBytes); 
        let encryptedHex = aesjs.utils.hex.fromBytes(encryptedBytes);
        this.solution = encryptedHex;

        
        

 

        


        //Events
        this.addEventListener('click',this.onClick.bind(this));

        this.querySelectorAll(':scope > edml-option').forEach(function(item){
            item.addEventListener('click',this.onOptionClick.bind(this,item));
        }.bind(this));

    }

    connectedCallback(){
        if(this.connected == null){
            this.connected = true;
            let shuffle = this.getSubmodel().shuffle;
            if(this.getAttribute('shuffle') != null) shuffle = this.getAttribute('shuffle');
            let nb = 0;
            this.querySelectorAll(':scope > edml-option').forEach(function(item){ 
                item.setAttribute('choiceid',nb); 
                nb++;
            });

            //randomize order?            
            let selectoptions = [...this.querySelectorAll(':scope > edml-option')];      
            if(shuffle == "true" || shuffle == true){            
                let z;            
                for(let i = 0; i < 20; i++){
                    z = Math.trunc(Math.random() * (selectoptions.length-1) + 1);
                    this.append(selectoptions[z]);
                }            
            }
        }
    }

    /*resize(){
        let open = false;
        if(this.classList.contains('open')) open = true; 
        this.classList.add('open');
        if(this.rendered == false) {
           let promise = edMLPlayer_Util.typesetMath(this);
           if(promise != null) promise.then(this.resizeSub.bind(this)); else this.resizeSub();
           this.rendered = true; 
        } else {
            this.resizeSub();
        }
        if(open == false) this.classList.remove('open');
        
    }*/


    onClick(evt){                   
        evt.preventDefault();
        evt.stopPropagation();
        if(this.querySelector('.edml-solutionhint-btn') != null){
            this.querySelector('.edml-solutionhint-btn').remove();
        }

        if(!this.closest('edml-input').classList.contains('disabled')){
            this.classList.toggle('open');
            if(this.classList.contains('open')) {
                this.openOptions();
            } else {
                this.closeOptions();
            }
        }
    }

    closeOptions(){        
        if(this.optionblock != null) {
            this.optionblock.querySelectorAll(':scope > edml-option').forEach(function(item){
                this.append(item);
            }.bind(this));
            this.optionblock.remove();
            this.classList.remove('open');
        }
    }

    clear(){
        this.querySelector('.edml-choice-selected').innerText = "-";
        this.removeAttribute('choice');
    }

    openOptions(){
        this.classList.add('open');
        if(this.optionblock != null) this.closeOptions();
        this.optionblock = document.createElement('span');
        this.optionblock.classList.add('edmlplayer-optionblock');
        let obj = this.optionblock;
        this.querySelectorAll(':scope > edml-option').forEach(function(item){
            obj.append(item);
        });
        let rect = this.getBoundingClientRect();
        let rectVariant = this.closest('edml-page').getBoundingClientRect();
       
        this.optionblock.style.left = (rect.left + window.scrollX - rectVariant.left)+"px";
        this.optionblock.style.top = (rect.top + window.scrollY+rect.height - rectVariant.top)+"px";
        this.optionblock.style.minWidth = rect.width + "px";
        this.closest('edml-page').append(this.optionblock);

        document.addEventListener('click',this.closeOptions.bind(this),{once : true});             
    }

    onOptionClick(item,check){        
        if(item != null){
            this.closeOptions();
            let node = edML_edML2HTML.parse2dom(item.getInnerEdML());
            this.querySelector(':scope > .edml-choice-selected').innerHTML = "";
            this.querySelector(':scope > .edml-choice-selected').append(node);
            this.setAttribute('choice',item.getAttribute('choiceid'));
            edMLPlayer_Util.typesetMath(this.querySelector(':scope > .edml-choice-selected'));
            this.classList.remove('open');
            this.removeAttribute('solved');
            if(check.type == "click" || check == true) this.onCheck();
            document.removeEventListener('click',this.closeOptions.bind(this),{once : true});
        }

    }

    getEdML(){
        let correct = "";
        let options = [...this.querySelectorAll(':scope > edml-option')];

        if(this.solution != ""){
            let encryptedBytes = aesjs.utils.hex.toBytes(this.solution);
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let decryptedBytes = aesCtr.decrypt(encryptedBytes);
            correct = aesjs.utils.utf8.fromBytes(decryptedBytes); 
        }     

        let correctArr = correct.split("#");
        for(let i = 0; i < correctArr.length; i++){
            options[i].setAttribute('correct',correctArr[i]);
        }


        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 

        let text = "";
        
        for(let i = 0; i < options.length; i++){
            text += options[i].getEdML();
        }
        return '<choice'+attr+'>' + text + '</choice>';
    }

    getSubmodel(){            
        return this.getModel().getSubmodel("choice");

    }

    verify(value,model){  
        let solvedobj = new Object();
        solvedobj.solved = false;
        solvedobj.solution = null;
        solvedobj.credits = 0;
        solvedobj.penalty = 0;
        
        if(model == null) model = this.getSubmodel();    
        if(value == null) value = this.getAttribute('choice');

        if(this.getAttribute('credits') != null && !isNaN(parseInt(this.getAttribute('credits')))) {
            solvedobj.credits = parseInt(this.getAttribute('credits'));
         } else {
            solvedobj.credits = model.credits;
        }
        
        if(this.solution != "" && !isNaN(parseInt(value))){
            
            //let model = this.closest("edml-input").getModel().getSubmodel("choice");  
            let encryptedBytes = aesjs.utils.hex.toBytes(this.solution);
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let decryptedBytes = aesCtr.decrypt(encryptedBytes);
            let decryptedText = aesjs.utils.utf8.fromBytes(decryptedBytes); 
            let solution = decryptedText; 
            let solArr = solution.split("#");
            if(solArr[value] != null){
                if(solArr[value] == true || solArr[value] == "true"){
                   solvedobj.solved = true;
                } else {
                    solvedobj.solved = false;
                }
            } else {
                return null;
            }   
        }   
        return solvedobj;
    }

    getValue(){
        var val = this.getAttribute('choice');
        if(val == null) val = "";
        return val;
    }

    setValue(val){
        if(this.querySelector('edml-option[choiceid="'+val+'"]')!= null){
            this.onOptionClick(this.querySelector('edml-option[choiceid="'+val+'"]'),false);
        }
    }

    getString(){
        return this.getValue().toString();
    }


    save2SCORM(result){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true && (edMLPlayer_Config.get('player.scorm.testonly') != true || document.querySelector('edml-test.active') != null)){  
            let navitem = this.closest('edml-variant').querySelector('edml-navitem.selected');
            if(navitem != null) navitem = navitem.getAttribute('name');
            let exercisename = edML_SCORM.saveInputObjective(result,this.closest('edml-input'),this.getValue().toString());
            edML_SCORM.saveInteraction(this.closest('edml-page').getAttribute("name"),"other","input: choice",navitem,exercisename,null);
        }
    }

    initFromSCORM(entrynb){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true && edMLPlayer_Config.get('player.scorm.testonly') != true) {  
            let value = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.description');           
            
            this.onOptionClick(this.querySelector(':scope > edml-option[choiceid="'+value+'"]'),false);

            if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "failed"){
                this.closest('edml-input').setAttribute('solved','false');
            } else if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "passed"){
                this.closest('edml-input').setAttribute('solved','true');
            }
            edMLPlayer_Functions.changeCredits(-this.lastCredits,false);
            this.lastCredits = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.score.raw');
        }
    }

    clear(){
        this.classList.add('unsolved');
        this.removeAttribute('choice');
        this.querySelector('.edml-choice-selected').innerText = "-";
        this.removeAttribute('solved');       
    }

    showSolutionhint(){        
        let hint = document.querySelector('edml-variant.active edml-solutionhint[to="'+this.closest('edml-input').getAttribute('name')+'"]');
  
        if(this.querySelector('.edml-solutionhint-btn') == null){
            let btn = document.createElement('span');
            btn.classList.add('edml-solutionhint-btn');
            this.append(btn);
            
            btn.addEventListener('click',function(evt){
                evt.stopPropagation();
                edML_DialogSolutionhint.show(hint);                
            });
        }   
        
    }
    

}
class edML_Clonecontainer extends edML_Tag{


    constructor(){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist(["from","mode"]);
        this.setMixedContent(false);
        this.setRequiredAttribute(["from"]);
        this.check();  

    }

    //This is for edml-editor
    connectedCallback(){
        if(this.connected == null){
            this.connected = true;
            var mode = edMLPlayer_Config.get('clonecontainer.mode');
            if(mode == "forcenone"){
                var span = document.createElement('span');
                span.classList.add('edml-clonecontainer-symbol');
                this.append(span);

                span.addEventListener('click',function(){
                    let obj = document.querySelector('edml-variant.active *[name="'+this.getAttribute('from')+'"]');
                    if(obj != null){
                        let page = obj.closest('edml-page');
                        if(page != null){            
                            let navitem = document.querySelector('edml-variant.active edml-navitem edml-ref[to="'+page.getAttribute('name')+'"]');
                            if(navitem != null) {
                                navitem = navitem.closest('edml-navitem');
                                if(document.querySelector('edml-variant.active edml-navitem.selected') != null) document.querySelector('edml-variant.active edml-navitem.selected').classList.remove('selected');    
                                
                            } else {
                                let testitem = document.querySelector('edml-variant.active edml-test.active[name="'+page.getAttribute('name')+'"]');
                                if(testitem != null) {
                                    event.navitem = testitem;
                                    if(document.querySelector('edml-variant.active edml-testitem.selected') != null) document.querySelector('edml-variant.active edml-testitem.selected').classList.remove('selected');    
                                }
                            }
                            


                            let event = new Event('edmlevent-changepage');
                            event.navitem = navitem;                        //navitem to select
                            event.page = page;                              // page to open
                            event.container = obj;                         // container to move the focus on page
                            event.reftype = "page";
                            document.dispatchEvent(event);
                        
                        } else if(obj != null && obj instanceof edML_Navitem){
                            obj.click();
                            
                        } else {
                            edML_Error.push("0006",this.outerHTML,this.getAttribute('to'));
                            edML_Error.printLast();
                        }   
                    } else {
                        edML_Error.push("0006",this.outerHTML,this.getAttribute('to'));
                        edML_Error.printLast();
                    }
                }.bind(this));
            }
        }
    }

}
class edML_Code extends edML_Tag{

    

    constructor(){
        super();
        this.setTagWhitelist(['cdata']);
        this.setAttributeWhitelist(["name","tags","lang"]);
        this.setMixedContent(true);  
        this.check();  
        
    
        if(this.getAttribute("lang") == "java") this.formatJava();
        
        
    }

    formatJava(){
        this.innerHTML = edMLPlayer_Util.formatJava(this.innerHTML);
    }


    

}
class edML_Codelisting extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["spotlight"]);
        this.setAttributeWhitelist(["lang","tags","name","highlight","firstlinenumber"]);
        this.setMixedContent(true);  
        this.setRemoveContentByClass(["edml-codelistingtable"]);   
        this.check();        
        let edmlnode = document.createElement('div');
        for(let i = this.childNodes.length-1; i > -1; i--){            
            edmlnode.prepend(this.childNodes[i]);
        }
        edmlnode.classList.add('edml-codelisting-edmlnode');
        this.prepend(edmlnode);
        
        let table = document.createElement('table');
        table.classList.add('edml-codelistingtable');
        this.append(table);   
        this.connected = false;


        if(edMLPlayer_Config.get('codelisting.preventcopy') != true) {
            this.classList.add('edml-codelisting-copy');
        }
        
        

    }
    
    connectedCallback(){       
        if(this.connected == false) {
            this.connected = true;
             
            let table = this.querySelector('.edml-codelistingtable');
            table.innerHTML = "";       
            let lines = this.querySelector('.edml-codelisting-edmlnode').innerHTML.split('\n');
            
            let highlight = this.getAttribute('highlight');
            if(highlight != null) {
                highlight = highlight.split(" ");

                let fidx;
                let splitted;
                while(highlight.find(element => element.indexOf("-") > -1) != null){
                    splitted = highlight.find(element => element.indexOf("-") > -1)
                    fidx = highlight.indexOf(splitted);
                    highlight.splice(fidx,1);                
                    splitted = splitted.split("-");
                    
                    for(let j = parseInt(splitted[0]); j <= parseInt(splitted[1]); j++){
                        highlight.push(j.toString());
                    }

                }

            } else {
                highlight = new Array();
            }


            edMLPlayer_Util.isMultiLineString = false;
            var start = 0;
            if(this.getAttribute('firstlinenumber') != null) start = parseInt(this.getAttribute('firstlinenumber')) - 1;
            if(isNaN(start) || start < 0) start = 0;
        

            for(let i = 0; i < lines.length; i++){
                let row = document.createElement('tr');
                if(highlight.indexOf((i+1).toString()) > -1){
                    row.classList.add('highlight');
                }
                let td1 = document.createElement('td');
                td1.classList.add('edml-codelistingtable-tdnb');
                td1.innerText = (start+i+1);
                row.append(td1);
                let td2 = document.createElement('td');
                td2.classList.add('edml-codelistingtable-code');
                
                if(this.getAttribute("lang") == "java") {
                    td2.innerHTML = edMLPlayer_Util.formatJava(lines[i]);
                } else {
                    td2.innerHTML = lines[i];
                }
                
                row.append(td2);
                table.append(row);

            }   
            
            
        }  
    }

 
    

  /* getEdML(){
        let text = this.edml;
        //if(this.edml.indexOf('<![CDATA[') == -1) text = '<![CDATA[' + text + ']]>';
        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"';
        }
        return '<codelisting'+attr+'>' + text + '</codelisting>';

    }  */

    getEdML(){
        let edmlnode = this.querySelector('.edml-codelisting-edmlnode');
        let edml = "";
        for(let i = 0; i < edmlnode.childNodes.length; i++){
            if(edmlnode.childNodes[i] instanceof edML_Tag){
                edml += edmlnode.childNodes[i].getEdML();
            } else if(edmlnode.childNodes[i].nodeType == Node.TEXT_NODE){
                edml += edmlnode.childNodes[i].textContent.replaceAll('&','&amp;').replaceAll('<','&lt;').replaceAll('>','&gt;');               
            }
        }
        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"';
        }
        return '<codelisting'+attr+'>' + edml + '</codelisting>';
    }



}
class edML_Colspecs extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["colspec"]);
        this.setAttributeWhitelist([]);
        this.setMixedContent(false);  
        this.setRequiredAttribute([]);
        this.setRemoveContentByClass([]);   
        this.check(); 
    }
} 
class edML_Colspec extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist(["column","align","minwidth","maxwidth","fixed"]);
        this.setMixedContent(false);  
        this.setRequiredAttribute(['column']);
        this.setRemoveContentByClass([]);   
        this.check(); 
    }

    connectedCallback(){
        if(this.connected == null){
            this.connected = true;
            let col = parseInt(this.getAttribute('column'));
            let align = null;
            let val = this.getAttribute('align');
            if(val != null){
                if(val == "left") {
                    align = "alignleft";
                } else if(val == "right"){
                    align = "alignright";
                } else if(val == "center"){
                    align = "aligncenter";
                }
            }

            let minwidth = null;
            if(this.getAttribute('minwidth') != null) minwidth = this.getAttribute('minwidth');

            let maxwidth = null;
            if(this.getAttribute('maxwidth') != null) maxwidth = this.getAttribute('maxwidth');

            if(this.getAttribute('fixed') == "true" && col == 1){
                this.closest('edml-table').classList.add('fixleft');
            }


            this.closest('edml-table').querySelectorAll(':scope > edml-row > edml-cell:nth-child('+col+')').forEach(function(item){
                if(align != null) item.classList.add(align)
                if(minwidth != null) item.style.minWidth = minwidth;
                if(maxwidth != null) item.style.maxWidth = maxwidth;
            })
        }
    }
} 
class edML_Condition extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist(["left","right","operator"]);
        this.setRequiredAttribute(["left","right","operator"]);
        this.setRequiredTag([]);
        this.setMixedContent(false);
        this.check();
        
    }

    getResult(){
        this.mode = "algebraic";
        let parentbox = this.parentNode;
        
        while(parentbox instanceof edML_Box == false && parentbox != null){
            parentbox = parentbox.parentNode;
        }

        if(parentbox != null){
            nerdamer.flush();
            nerdamer.clearVars();
            
            if(parentbox.parameters != null){
                
                for(let i = 0; i < parentbox.parameters.length; i++){
                    nerdamer.setVar(parentbox.parameters[i],parentbox.values[i]);
                }              
            }
        }
        
        var left = this.getAttribute('left');
        var right = this.getAttribute('right');
        var op = this.getAttribute('operator');
        var result = false;

        //replace variables
        left = left.replaceAll(/\$\(.*?\)/g,edMLPlayer_Util.replaceVariables.bind(this)); 
        right = right.replaceAll(/\$\(.*?\)/g,edMLPlayer_Util.replaceVariables.bind(this));    

        if(this.mode == "string"){
            
            try{
                switch(op){
                    case "less": result = left < right; break;
                    case "greater": result = left > right; break;
                    case "equal": result = (left == right); break;
                    case "notequal": result = (left != right); break; //no != or !== in Nerdamer -> factorial and equal
                    case "lessorequal": result = left <= right; break;
                    case "greaterorequal": result = left >= right; break;
                }
            } catch(exception){

            }
            
        } else {
            //algebraic is standard
            try{
                switch(op){
                    case "less": result = nerdamer(left).lt(right); break;
                    case "greater": result = nerdamer(left).gt(right); break;
                    case "equal": result = nerdamer(left).eq(right); break;
                    case "notequal": result = !nerdamer(left).eq(right); break; //no != or !== in Nerdamer -> factorial and equal
                    case "lessequal": result = nerdamer(left).lte(right); break;
                    case "greaterequal": result = nerdamer(left).gte(right); break;
                }
            } catch(exception){
            // console.log(exception);
            }
        } 
        
        return result;

    
    }

    
}
class edML_Conventionbox extends edML_Box{

    constructor(container){
        super(); 
        this.setTagWhitelist(edML_Groups.getBlockGroup().concat(["title","parameter","parametergroup","enumerator","descriptor","subtitle"]));
        this.setAttributeWhitelist(["name","label","subtype","tags","numbered"]);
        this.setOnlyOnceTag(["title","descriptor","enumerator","subtitle"]);
        this.setMixedContent(false);
        this.setRemoveContentByClass(["edml-autotitle","edml-autodescriptor"]);
        this.check();  
        
        if(this.querySelector(':scope > edml-title') == null){  // for compatiblity
            if(this.querySelector(':scope > edml-descriptor') == null){
                var descr = document.edmllocale.get('conventionbox.descriptor',this.closest('edml-variant').getAttribute('lang'));
                if(this.getAttribute('subtype') != null){  
                    if(document.edmllocale.get('conventionbox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang')) != null){
                        descr = document.edmllocale.get('conventionbox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang'));
                    } 
                }

                let descriptor = new edML_Descriptor(descr);
                descriptor.classList.add('edml-autodescriptor');
                this.prepend(descriptor);
            }

            if(this.querySelector(':scope > edml-enumerator') == null && (this.getAttribute('numbered') == "true" || (this.getAttribute('numbered') == null && edMLPlayer_Config.get('box.conventionbox.numbered') == true))){ 
                let enumerator = new edML_Enumerator();
                enumerator.classList.add('edml-autoenumerator');
                enumerator.classList.add('edml-conventionbox-numbering');
                this.prepend(enumerator);
            }


            this.orderTitle();
            
        }
        
    }
}
class edML_Course extends edML_Tag{

    constructor(){
        super();         
        this.setTagWhitelist(["settings","variant"]);
        this.setAttributeWhitelist(["xmlns:xi","xmlns:xsi","xsi:schemalocation","xmlns","edmlversion","xml:base"]);   
        this.setOnlyOnceTag(["settings"]);
        this.setRequiredTag(["variant"]);
        this.check();                                           
        this.setAttribute('alevel',edMLPlayer_Config.get("access.level"));   
        
        if(this.getAttribute("xmlns") == null){
            this.setAttribute("xmlns",'http://mint-kolleg.kit.edu/edML');
        }
    }


}
class edML_Creator extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist(["url"]);
        this.setMixedContent(true);        
        this.check();
    }
}
class edML_Date extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist([]);
        this.setMixedContent(true);
        this.check();
        
        this.edml = this.outerHTML;
        const date = new Date(this.innerText);
        this.innerText = date.toLocaleDateString();         
    }
    
    
    getEdML(){
        return this.edml;
    }



}
class edML_Definitionbox extends edML_Box{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup().concat(["title","parameter","parametergroup","enumerator","descriptor","subtitle"]));
        this.setAttributeWhitelist(["name","label","subtype","tags","numbered"]);
        this.setOnlyOnceTag(["title","descriptor","enumerator","subtitle"]);
        this.setMixedContent(false);
        this.setRemoveContentByClass(["edml-autotitle","edml-autodescriptor"]);
        this.check();
        
        
        if(this.querySelector(':scope > edml-title') == null){  // for compatiblity
            if(this.querySelector(':scope > edml-descriptor') == null){
                var descr = document.edmllocale.get('definitionbox.descriptor',this.closest('edml-variant').getAttribute('lang'));
                if(this.getAttribute('subtype') != null){  
                    if(document.edmllocale.get('definitionbox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang')) != null){
                        descr = document.edmllocale.get('definitionbox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang'));
                    } 
                }

                let descriptor = new edML_Descriptor(descr);
                descriptor.classList.add('edml-autodescriptor');
                this.prepend(descriptor);
            }

            if(this.querySelector(':scope > edml-enumerator') == null && (this.getAttribute('numbered') == "true" || (this.getAttribute('numbered') == null && edMLPlayer_Config.get('box.definitionbox.numbered') == true))){ 
                let enumerator = new edML_Enumerator();
                enumerator.classList.add('edml-autoenumerator');
                enumerator.classList.add('edml-definitionbox-numbering');
                this.prepend(enumerator);
            }


            this.orderTitle();
            
        }
    }
    
    show(){
        super.show();
    }



}
class edML_Decision extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["case","default"]);
        this.setAttributeWhitelist([]);
        this.setRequiredAttribute([]);
        this.setRequiredTag(["case"]);
        this.setOnlyOnceTag(["default"]);
        this.setMixedContent(false);
        this.check();
    }

    decide(){
        let decision = false;
        this.querySelectorAll('edml-default.show, edml-condition.show, edml-allof.show, edml-oneof.show, edml-case.show').forEach(function(item){
            item.classList.remove('show');
        });
        this.querySelectorAll(':scope > edml-case').forEach(function(caseitem){
            caseitem.querySelectorAll(':scope > *').forEach(function(item){
                if(item instanceof edML_Condition || item instanceof edML_Allof || item instanceof edML_Oneof){
                    if(decision == false && item.getResult() == true){
                        decision = true;
                        caseitem.classList.add('show');
                    }
                }
            });
        });

        if(this.querySelector(':scope > edml-default') != null){
            if(decision == false) {
                this.querySelector(':scope > edml-default').classList.add('show');
            } else {
                this.querySelector(':scope > edml-default').classList.remove('show');
            }
        }
        
    }
}
class edML_Default extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup());
        this.setAttributeWhitelist([]);
        this.setRequiredAttribute([]);
        this.setRequiredTag([edML_Groups.getBlockGroup()]);
        this.setMixedContent(false);
        this.check();
    }
}
class edML_Description extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist(["url"]);
        this.setRequiredTag([]);
        this.setMixedContent(true);        
        this.check();
    }

    connectedCallback(){
        if(this.getAttribute('url') != null){
            let link = new edML_Link(this.getAttribute("url"));
            for(let i = this.childNodes.length-1; i > 0; i--){
                link.prepend(this.childNodes[i]);
            }
            this.prepend(link);

        }
    }
}
class edML_Descriptor extends edML_Tag{


    constructor(value){
        super();
        this.setTagWhitelist(edML_Groups.getInlineGroup());
        this.setAttributeWhitelist([]);
        this.setMixedContent(true);
        this.setRemoveContentByClass(['edml-autotitle']);
        if(value != null) this.innerHTML = value;
        this.check();  

    }
    
    
    connectedCallback(){
        this.parentNode.classList.add('hastitle');
    }

    rename(){
        if(this.classList.contains('edml-autodescriptor')){
            var boxname = this.parentNode.nodeName.toLowerCase().replace('edml-','');
            var descr = document.edmllocale.get(boxname+'.descriptor');
            if(this.getAttribute('subtype') != null){  
                if(document.edmllocale.get(boxname+'.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang')) != null){
                    descr = document.edmllocale.get(boxname+'.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang'));
                } 
            }

            this.innerText = descr;


        }
    }
}
class edML_Dragitems extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["item"]);
        this.setAttributeWhitelist(["shuffle","maxuse"]);
        this.setMixedContent(false);
        this.setRequiredTag(["item"]); 
        this.check();

        this.itemorder = new Array();
        
    }




    connectedCallback(){
        if(this.connected == null){
            this.connected = true;
            let nb = 0;
            let items = new Array();
            this.querySelectorAll(':scope > edml-item').forEach(function(item){
                item.setAttribute('order',nb);
                items.push(item);
                nb++;
            }.bind(this));

            let shuffle = this.parentNode.getSubmodel().shuffle;
            
            //old standard --> DELETE
            if(this.parentNode.getAttribute('shuffle') != null){
                if(this.parentNode.getAttribute('shuffle') == "true") shuffle = true; else shuffle = false;
            }
            //old standard end 

            
            if(this.getAttribute('shuffle') != null){
                if(this.getAttribute('shuffle') == "true") shuffle = true; else shuffle = false;
            }

            //shuffle = false;
            if(this.parentNode instanceof edML_Matching){
                if(shuffle && edMLPlayer_Config.get('player.forceshuffleOff') == false){
                    for(let i = 0; i < items.length * 2; i++){
                        this.prepend(items[Math.floor(Math.random() * items.length)]);
                    }
                }
            }
            
            //reorder and rember original order
            nb = 0;
            this.querySelectorAll(':scope > edml-item').forEach(function(item){
                this.itemorder[nb] = item.getAttribute('order');
                item.setAttribute('order',nb);            
                nb++;
            }.bind(this));
        }
    }

    getEdML(){
        let edml = "";
        let idx;
        for(let i = 0; i < this.itemorder.length; i++){
            idx = this.itemorder.indexOf(i.toString());
            if(this.querySelector(':scope > edml-item[order="' + idx +'"') != null) edml += this.querySelector(':scope > edml-item[order="' + idx +'"').getEdML();
        }

        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 
        if(attr.length > 0) attr = " " + attr;
        edml = '<dragitems'+attr+'>'+edml+'</dragitems>';
     
        return edml;
    }

    sort(){
        for(let i = 0; i < this.itemorder.length; i++){
            if(this.querySelector(':scope > edml-item[order="'+i+'"') != null) this.append(this.querySelector(':scope > edml-item[order="'+i+'"'));
        
        }
    }



}
class edML_Dropitems extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["item"]);
        this.setAttributeWhitelist(["shuffle","maxuse"]);
        this.setMixedContent(false); 
        this.setRequiredTag(["item"]);
        this.check();

        this.itemorder = new Array();       
    }


    

    connectedCallback(){
        if(this.connected == null){
            this.connected = true;
            let nb = 0;
            let items = new Array();
            this.querySelectorAll(':scope > edml-item').forEach(function(item){
                item.setAttribute('order',nb);
                items.push(item);
                nb++;
            }.bind(this));

            let shuffle = this.parentNode.getSubmodel().shuffle;
            
            //old standard --> DELETE
            if(this.parentNode.getAttribute('shuffle') != null){
                if(this.parentNode.getAttribute('shuffle') == "true") shuffle = true; else shuffle = false;
            }
            //old standard end 

            if(this.getAttribute('shuffle') != null){
                if(this.getAttribute('shuffle') == "true") shuffle = true; else shuffle = false;
            }

            //shuffle = false;
            if(this.parentNode instanceof edML_Matching){
                if(shuffle && edMLPlayer_Config.get('player.forceshuffleOff') == false){
                    for(let i = 0; i < items.length * 2; i++){
                        this.prepend(items[Math.floor(Math.random() * items.length)]);
                    }
                }
            }
            
            //reorder and rember original order
            nb = 0;
            this.querySelectorAll(':scope > edml-item').forEach(function(item){
                this.itemorder[nb] = item.getAttribute('order');
                item.setAttribute('order',nb);            
                nb++;
            }.bind(this));
        }
    
    }

    sort(){
        for(let i = 0; i < this.itemorder.length; i++){
            if(this.querySelector(':scope > edml-item[order="'+i+'"') != null) this.append(this.querySelector(':scope > edml-item[order="'+i+'"'));
        
        }
    }

    getEdML(){
        let edml = "";
        let idx;
        for(let i = 0; i < this.itemorder.length; i++){
            idx = this.itemorder.indexOf(i.toString());
            if(this.querySelector(':scope > edml-item[order="' + idx +'"') != null) edml += this.querySelector(':scope > edml-item[order="' + idx +'"').getEdML();
        }

        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 
        if(attr.length > 0) attr = " " + attr;
        edml = '<dropitems'+attr+'>'+edml+'</dropitems>';
        
        return edml;
    }

    




}
class edML_Educts extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["molecule"]);
        this.setAttributeWhitelist(["fixed"]);
        this.setMixedContent(false);
        this.setRequiredTag(["molecule"]); 
        this.check();
    }



}
class edML_Emph extends edML_Tag{

    constructor(value){
        super();
        if(value != null) this.innerHTML = value;
        let arr = edML_Groups.getInlineGroup();
        arr.splice(edML_Groups.getInlineGroup().indexOf('emph'),1);
        this.setTagWhitelist(arr.concat(edML_Groups.getInputGroup()));
        this.setAttributeWhitelist(["name","tags"]);
        this.setMixedContent(true);
        this.check();
    }


}
class edML_Enumerator extends edML_Tag{


    constructor(value){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist([]);
        this.setMixedContent(true);
        //this.setRemoveContentByClass(['edml-autotitle']);
        if(value != null) this.innerHTML = value;
        this.check();  

    }
    
    
    connectedCallback(){
        this.parentNode.classList.add('hastitle');
    }
}
class edML_Examplebox extends edML_Box{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup().concat(["title","parameter","parametergroup","enumerator","descriptor","subtitle"]));
        this.setAttributeWhitelist(["name","label","difficulty","subtype","tags","numbered"]);
        this.setMixedContent(false);
        this.setOnlyOnceTag(["title","descriptor","enumerator","subtitle"]);
        this.setRemoveContentByClass(["edml-autotitle","edml-autodescriptor"]);
        this.check();
        
        if(this.querySelector(':scope > edml-title') == null){  // for compatiblity
            if(this.querySelector(':scope > edml-descriptor') == null){
                var descr = document.edmllocale.get('examplebox.descriptor',this.closest('edml-variant').getAttribute('lang'));
                if(this.getAttribute('subtype') != null){  
                    if(document.edmllocale.get('examplebox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang')) != null){
                        descr = document.edmllocale.get('examplebox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang'));
                    } 
                }

                let descriptor = new edML_Descriptor(descr);
                descriptor.classList.add('edml-autodescriptor');
                this.prepend(descriptor);
            }

            if(this.querySelector(':scope > edml-enumerator') == null && (this.getAttribute('numbered') == "true" || (this.getAttribute('numbered') == null && edMLPlayer_Config.get('box.examplebox.numbered') == true))){ 
                let enumerator = new edML_Enumerator();
                enumerator.classList.add('edml-autoenumerator');
                enumerator.classList.add('edml-examplebox-numbering');
                this.prepend(enumerator);
            }


            this.orderTitle();
            
        }


        if(this.getAttribute('difficulty') != null){   
            if(this.querySelector(':scope > .edml-difficultysign') != null) {
                this.querySelector(':scope > .edml-difficultysign').innerText = "";        
            } else {
                var sign = document.createElement('span');
                sign.classList.add('edml-difficultysign');
                this.prepend(sign);

                if(edMLPlayer_Config.get('box.examplebox.format.difficulty') == "append"){ 
                    this.querySelectorAll('edml-enumerator, edml-descriptor, edml-subtitle').forEach(function(item){
                        item.after(sign);
                    });                    
                } 
            }
            
            let level = parseInt(this.getAttribute('difficulty'));
            if(level != NaN && level > 0){
                let diff = "";
                for(let i = 0; i < level; i++) {
                    diff += "q";
                }                
                this.querySelector(':scope > .edml-difficultysign').innerText = ""+diff+"";
            } 
            
        } 

        
    }
}
class edML_Exercisebox extends edML_Box{

    constructor(container){
        super(); 
        this.setTagWhitelist(edML_Groups.getBlockGroup().concat(["title","parameter","parametergroup","enumerator","descriptor","subtitle","interaction"])); //title to delete
        this.setAttributeWhitelist(["name","label","difficulty","subtype","tags","numbered"]); //label to delete
        this.setMixedContent(false);
        this.setOnlyOnceTag(["title","descriptor","enumerator","subtitle"]);
        this.setRemoveContentByClass(["edml-autotitle","edml-autodescriptor"]);
        this.check();  
        
        //old code 
        /*if(this.querySelector(':scope > edml-title') == null){
            /*let title = new edML_Title();;
            if(this.getAttribute('label') != null) {
                title.innerText = this.getAttribute('label'); 
            } else {
                title.innerHTML = document.edmllocale.get('exercisebox.title') + '<span class="edml-exercisebox-numbering"></span>';
                
            }
            title.classList.add('edml-autotitle');
            
            this.prepend(title); 
        } */

        if(this.querySelector(':scope > edml-title') == null){  // for compatiblity
            if(this.querySelector(':scope > edml-descriptor') == null){
                var descr = document.edmllocale.get('exercisebox.descriptor',this.closest('edml-variant').getAttribute('lang'));
                if(this.getAttribute('subtype') != null){  
                    if(document.edmllocale.get('exercisebox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang')) != null){
                        descr = document.edmllocale.get('exercisebox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang'));
                    } 
                }

                let descriptor = new edML_Descriptor(descr);
                descriptor.classList.add('edml-autodescriptor');
                this.prepend(descriptor);
            }

            if(this.querySelector(':scope > edml-enumerator') == null && (this.getAttribute('numbered') == "true" || (this.getAttribute('numbered') == null && edMLPlayer_Config.get('box.exercisebox.numbered') == true))){ 
                let enumerator = new edML_Enumerator();
                enumerator.classList.add('edml-autoenumerator');
                enumerator.classList.add('edml-exercisebox-numbering');
                this.prepend(enumerator);
            }


            this.orderTitle();
            
        }

        if(this.getAttribute('difficulty') != null){   
            if(this.querySelector(':scope > .edml-difficultysign') != null) {
                this.querySelector(':scope > .edml-difficultysign').innerText = "";        
            } else {
                var sign = document.createElement('span');
                sign.classList.add('edml-difficultysign');

                this.prepend(sign);
                if(edMLPlayer_Config.get('box.exercisebox.format.difficulty') == "append"){ 
                    this.querySelectorAll('edml-enumerator, edml-descriptor, edml-subtitle').forEach(function(item){
                        item.after(sign);
                    });                    
                } 
            }
            
            let level = parseInt(this.getAttribute('difficulty'));
            if(level != NaN && level > 0){
                let diff = "";
                for(let i = 0; i < level; i++) {
                    diff += "q";
                }                
                this.querySelector(':scope > .edml-difficultysign').innerText = ""+diff+"";
            } 
            
        } 

        
    }

    
}
class edML_Experimentbox extends edML_Box{

    constructor(container){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup().concat("title","parameter"));
        this.setAttributeWhitelist(["name","label","subtype","tags"]);
        this.setMixedContent(false);
        this.setOnlyOnceTag(["title"]);
        this.setRemoveContentByClass(["edml-autotitle"]);
        this.check();
        
        if(this.querySelector(':scope > edml-title') == null){
            let title = new edML_Title();
            if(this.getAttribute('label') != null) {
                title.innerText = this.getAttribute('label');
            } else {
                title.innerHTML = document.edmllocale.get('experimentbox.descriptor') + '<span class="edml-experimentbox-numbering"></span>';
                title.classList.add('edml-autotitle');
            }

            this.prepend(title);
        }
    }
}
class edML_Exponential extends edML_Inputvalue{


    constructor(){
        super();        
        //check of RequiredTag -> see connected
        
        this.setTagWhitelist(["mantissa","exponent"]);
        this.setAttributeWhitelist(["credits","model","base","lowertolerance","uppertolerance","lowerreltolerance","upperreltolerance","scientific","engineering"]);
        this.setMixedContent(false);
        this.setRemoveContentByClass([]);
        //this.setRequiredTag(['exponent']);              
        this.check();

        let parentbox = this.parentNode;
        while(parentbox != null && !(parentbox instanceof edML_Box)){
            parentbox = parentbox.parentNode;
        }

        if(this.querySelector(":scope > edml-mantissa") != null) {
            this.val01 = this.querySelector(":scope > edml-mantissa").innerText;
            if(isNaN(parseFloat(this.val01))){ //number is parameter?
                
                nerdamer.flush();
                nerdamer.clearVars();
                nerdamer.setConstant('E', 'delete');
    
                if(parentbox != null && parentbox.parameters != null){
                    nerdamer.flush();
                    nerdamer.clearVars();
    
                    for(let i = 0; i < parentbox.parameters.length; i++){
                        nerdamer.setVar(parentbox.parameters[i],parentbox.values[i]);
                    }
                    
                    this.val01 = nerdamer('simplify('+this.val01+')').toTeX('decimal');
                  
                    
                }
            }
        }

        if(this.querySelector(":scope > edml-exponent") != null) {
            this.val02 = this.querySelector(":scope > edml-exponent").innerText;
            if(isNaN(parseFloat(this.val02))){   //number is parameter?
                
                nerdamer.flush();
                nerdamer.clearVars();
                nerdamer.setConstant('E', 'delete');
    
                if(parentbox != null && parentbox.parameters != null){
                    nerdamer.flush();
                    nerdamer.clearVars();
    
                    for(let i = 0; i < parentbox.parameters.length; i++){
                        nerdamer.setVar(parentbox.parameters[i],parentbox.values[i]);
                    }
                    
                    this.val02 = nerdamer('simplify('+this.val02+')').toTeX('decimal');
                  
                    
                }
            }
        }



        
        
        
            
    }

    connectedCallback(){
        if(this.parentNode.nodeName.toLowerCase() != "edml-inputmodel" && this.querySelector(':scope edml-exponent') == null){
            edML_Error.push("0004",this.outerHTML,'edml-exponent');
            edML_Error.printLast();                        
        }


        if(!this.classList.contains('rendered')){
            this.classList.add('rendered');

            this.lastCredits = 0; 

            
            let middot = "{}\\cdot"; 
        
        
        
        
            if(this.querySelector(":scope > edml-mantissa") == null){
                let mantis = new edML_Mantissa(1);
                mantis.classList.add('hidden');
                mantis.querySelector("input").value = 1;
                this.prepend(mantis);
                middot = "";
                this.val01 = 1;               
                this.classList.add('nomantissa');
                
            } 
           

            let model = this.closest("edml-input").getModel().getSubmodel("exponential");       

            let basenb = model.base;
            if(this.getAttribute('base') != null && !isNaN(parseInt(this.getAttribute('base')))) basenb = parseInt(this.getAttribute('base'));

            this.querySelector(':scope > edml-mantissa').setAttribute('base',basenb);
            this.querySelector(':scope > edml-exponent').setAttribute('base',basenb);

            
            this.key = new Uint8Array(32);
            for(let i =  0; i < 32; i++){
                this.key[i] = Math.floor(Math.random()*Number.MAX_SAFE_INTEGER);
            }
            //console.log(this.val01 + "  " + this.val02 +  "   "  + basenb);
            var solution = this.convertToDecimal(this.val01,this.val02,this.getDecimalSeparator()); //parseFloat(this.val01)*Math.pow(basenb,parseFloat(this.val02)); 
            //console.log(solution);           
            delete this.val01;
            delete this.val02;
            let textBytes = aesjs.utils.utf8.toBytes(solution);            
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let encryptedBytes = aesCtr.encrypt(textBytes); 
            let encryptedHex = aesjs.utils.hex.fromBytes(encryptedBytes);
            this.solution = encryptedHex;
        

            let base = new edML_M(middot+basenb); //document.createElement('edml-m');
            //base.innerHTML = middot+basenb;
            base.classList.add('edml-exponential-base');
            this.base = parseFloat(basenb);

            let exponent = document.createElement('span');
            exponent.classList.add('edml-exponential-exponent');
            exponent.append(this.querySelector(':scope > edml-exponent'));

            let mantissa = document.createElement('span');
            mantissa.classList.add('edml-exponential-mantissa');
            mantissa.append(this.querySelector(':scope > edml-mantissa'));
            
            this.append(mantissa);
            this.append(base);
            this.append(exponent);

            this.querySelector(':scope > .edml-exponential-mantissa > edml-mantissa').addEventListener('keyup',this.onKeyUpNumber.bind(this)); 
        }   
    }



    onKeyUpNumber(evt){
        if(evt.key.toLowerCase() == "tab"){
            this.querySelector('.edml-exponential-exponent > edml-exponent > input').focus();
            this.querySelector('.edml-exponential-exponent > edml-exponent > input').click();
        }
        this.onCheck();
    }

    getDecimalSeparator(){
        return "."; // --> getValue intrinsic JS decimal separator
    }

    getMantissaValue(){
        return this.querySelector('.edml-exponential-mantissa > edml-mantissa').getValue();
    }

    getExponentValue(){
        return this.querySelector('.edml-exponential-mantissa > edml-exponent').getValue();
    }

    getDecimalValue(){

        return this.convertToDecimal(this.querySelector('.edml-exponential-mantissa > edml-mantissa').getValue(),this.querySelector('.edml-exponential-exponent > edml-exponent').getValue(),this.getDecimalSeparator());
       // return this.querySelector('.edml-exponential-mantissa > edml-mantissa').getDecimalValue()*Math.pow(this.base,this.querySelector('.edml-exponential-exponent > edml-exponent').getDecimalValue()); 
    }

    getValue(){
        //return this.querySelector('.edml-exponential-mantissa > edml-mantissa').getValue()*Math.pow(this.base,this.querySelector('.edml-exponential-exponent > edml-exponent').getValue());
        return this.getDecimalValue();
    }


    getString(){
        return this.querySelector('.edml-exponential-mantissa > edml-mantissa').getValue()+"*"+this.base+"^"+this.querySelector('.edml-exponential-exponent > edml-exponent').getValue();
    }


    setValue(val){
        //format  number*base^exponent
        let split = val.split('*');
        this.querySelector('.edml-exponential-mantissa > edml-mantissa').setValue(split[0]); //--> number
        if(split.length > 1){
            split = split[1].split('^');
            if(this.base == split[0].trim() && split.length > 1){  // --> equal base
                this.querySelector('.edml-exponential-exponent > edml-exponent').setValue(split[1]);
            }
        }
    }

    verify(value, model){
        if(model == null) model = this.getSubmodel();       
        
        let solvedobj = new Object();
        solvedobj.solved = false;
        solvedobj.solution = null;
        
        if(this.getAttribute('credits') != null && !isNaN(parseInt(this.getAttribute('credits')))) {
            solvedobj.credits = parseInt(this.getAttribute('credits'));
         } else {
            solvedobj.credits = model.credits;
        }

        let basenb = model.base;
        if(this.getAttribute('base') != null && !isNaN(parseInt(this.getAttribute('base')))) basenb = parseInt(this.getAttribute('base'));
        model.mantissa.base = basenb;
        model.exponent.base = basenb;

        let mantissa = this.querySelector('.edml-exponential-mantissa > edml-mantissa');
        let exponent = this.querySelector('.edml-exponential-exponent > edml-exponent');

        

        let mantissacheck = mantissa.verify(null,model.mantissa);                 
        let exponentcheck = exponent.verify(null,model.exponent); 

       // console.log(mantissacheck);
       // console.log(exponentcheck);
        if(mantissacheck.solved && mantissacheck.attributecheck && exponentcheck.attributecheck && exponentcheck.solved){
            //get attribute values
            let lowertolerance = model.lowertolerance;
            let uppertolerance = model.uppertolerance;
            let lowerreltolerance = model.lowerreltolerance;
            let upperreltolerance = model.upperreltolerance;        
            let precision = model.precision;
            let engineering = model.engineering
            let scientific = model.scientific

            if(this.getAttribute('lowertolerance') != null) lowertolerance = this.getAttribute('lowertolerance');
            if(this.getAttribute('uppertolerance') != null) uppertolerance = this.getAttribute('uppertolerance');
            if(this.getAttribute('lowerreltolerance') != null) lowerreltolerance = this.getAttribute('lowerreltolerance');
            if(this.getAttribute('upperreltolerance') != null) upperreltolerance = this.getAttribute('upperreltolerance');
            if(this.getAttribute('precision') != null) precision = this.getAttribute('precision');
            if(this.getAttribute('engineering')) engineering = this.getAttribute('engineering');
            if(this.getAttribute('scientific')) scientific = this.getAttribute('scientific');

            if(lowertolerance == "INF") lowertolerance = Infinity;
            if(uppertolerance == "INF") uppertolerance = Infinity;
            if(lowerreltolerance == "INF") lowerreltolerance = Infinity;
            if(upperreltolerance == "INF") upperreltolerance = Infinity;
            

            //get solution
            let encryptedBytes = aesjs.utils.hex.toBytes(this.solution);
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let decryptedBytes = aesCtr.decrypt(encryptedBytes);
            let decryptedText = aesjs.utils.utf8.fromBytes(decryptedBytes); 
            let solutionnumber = parseFloat(decryptedText);  
            let inputnumber = value;            
            if(value == null) inputnumber = this.getDecimalValue();
            
            //force to number !
            uppertolerance = parseFloat(uppertolerance);
            lowertolerance = parseFloat(lowertolerance);
            upperreltolerance = parseFloat(upperreltolerance);
            lowerreltolerance = parseFloat(lowerreltolerance);
            precision = parseFloat(precision);

            nerdamer.flush();
            nerdamer.clearVars();
            nerdamer.setConstant('E', 'delete');

            let check1;
            let check2;
            //absolute check
            if(nerdamer(solutionnumber+'-'+lowertolerance+"-"+precision+'<='+inputnumber) == 1 || nerdamer(solutionnumber+'-('+lowerreltolerance+ '*abs('+solutionnumber+'))'+"-"+precision+' <='+inputnumber) == 1 || lowertolerance == "Infinity" || lowerreltolerance=="Infinity") {
                check1 = true; 
            } else check1 = false;

            //relative check
            if(nerdamer(inputnumber+'<='+solutionnumber+'+'+uppertolerance+"+"+precision) == 1 || nerdamer(inputnumber+'<='+solutionnumber+"+("+upperreltolerance +'*abs('+solutionnumber+'))' +"+"+precision) == 1 || uppertolerance == "Infinity" || upperreltolerance=="Infinity") { 
                check2 = true; 
            } else check2 = false;
          /*  console.log(precision);
            console.log(solutionnumber);
            console.log(inputnumber);
            console.log(lowertolerance);
            console.log(nerdamer(solutionnumber+'-('+lowerreltolerance+ '*abs('+solutionnumber+'))').text());
            console.log(nerdamer(solutionnumber+'-('+lowerreltolerance+ '*abs('+solutionnumber+')) <='+inputnumber).text());
            console.log(nerdamer(solutionnumber+'-'+lowertolerance).text());
            console.log(nerdamer(solutionnumber+'-'+lowertolerance+'<='+inputnumber).text());
            console.log(check1);
            console.log(check2);*/

            if(check1 && check2){
            //if( (inputnumber -(uppertolerance+solutionnumber)  < precision || inputnumber - (upperreltolerance * solutionnumber + solutionnumber) < precision) && ((solutionnumber - lowertolerance) - inputnumber < precision ||(solutionnumber - solutionnumber * lowerreltolerance) - inputnumber < precision)){
                
                /*this.querySelector('.edml-exponential-mantissa > edml-number, .edml-exponential-mantissa > edml-exponential').setAttribute('solved','true');
                this.querySelector('.edml-exponential-exponent > edml-number, .edml-exponential-exponent > edml-exponential').setAttribute('solved','true');
                return true;  */
                solvedobj.solved = true;
                solvedobj.valuecheck = true;
            } else {
            /*    this.querySelector('.edml-exponential-mantissa > edml-number, .edml-exponential-mantissa > edml-exponential').setAttribute('solved','false');
                this.querySelector('.edml-exponential-exponent > edml-number, .edml-exponential-exponent > edml-exponential').setAttribute('solved','false');
                return false;*/                
                solvedobj.solved = false;
                solvedobj.valuecheck = false;
            }

            solvedobj.attributecheck = true;

            if(solvedobj.solved == true && (engineering == "true" || engineering == true)){
                
                if(parseFloat(this.querySelector('.edml-exponential-exponent > edml-exponent').getDecimalValue()) % 3 != 0 || this.querySelector('.edml-exponential-exponent > edml-exponent').getValue().split('.').length != 1){
                    new edML_DialogShortmessage(document.edmllocale.get("shortmessage.representation"),"error");                      
                    solvedobj.solved = false;  
                    solvedobj.attributecheck = false;
                }
    
                
            }

            if(solvedobj.solved == true && (scientific == "true" || scientific == true) && this.querySelector('.edml-exponential-mantissa > edml-mantissa') != null){
                //one digit before decimal point. digit is not zero.
                let mval = this.querySelector('.edml-exponential-mantissa > edml-mantissa').getValue();
                let mlen = mval.split(".")[0].length; 
                if(mval.startsWith("+0") || mval.startsWith("-0") || mval.startsWith("0")){
                    new edML_DialogShortmessage(document.edmllocale.get("shortmessage.representation"),"error");                      
                    solvedobj.solved = false;  
                    solvedobj.attributecheck = false;
                } else if((mval.startsWith("+") || mval.startsWith("-")) && mlen > 2){
                    new edML_DialogShortmessage(document.edmllocale.get("shortmessage.representation"),"error");                      
                    solvedobj.solved = false;  
                    solvedobj.attributecheck = false;
                } else if(!mval.startsWith("+") && !mval.startsWith("-") && mlen > 1){
                    new edML_DialogShortmessage(document.edmllocale.get("shortmessage.representation"),"error");                      
                    solvedobj.solved = false;  
                    solvedobj.attributecheck = false;
                }

                
            }

        } else {
            //this.querySelector('.edml-exponential-mantissa > edml-number, .edml-exponential-mantissa > edml-exponential').setAttribute('solved','false');
            //this.querySelector('.edml-exponential-exponent > edml-number, .edml-exponential-exponent > edml-exponential').setAttribute('solved','false');
            //return false;
            if(mantissacheck.valuecheck && exponentcheck.valuecheck){
                solvedobj.valuecheck = true;
            } else solvedobj.valuecheck = false;

            if(mantissacheck.attributecheck && exponentcheck.attributecheck){
                solvedobj.attributecheck = true;
            } else {
                solvedobj.attributecheck = false;
            }
            solvedobj.solved = false;
        }

        return solvedobj;
    }


    checkShowCheckButton(){
        if(this.querySelector('.edml-exponential-mantissa > edml-mantissa').checkShowCheckButton() && this.querySelector('.edml-exponential-exponent > edml-exponent').checkShowCheckButton()){
            return true;
        } else {
            return false;
        }
    }


    convertToDecimal(mantissa,exponent,decimalsep){
        mantissa = mantissa.toString().trim();
        exponent = exponent.toString().trim();
        let decimalnumberMantissa = nerdamer('0');   
        let decimalnumberExponent = nerdamer('0');   
        
        if(this.base == null) {
            this.base = this.getSubmodel().base;
            if(this.getAttribute('base') != null) this.base = parseInt(this.getAttribute('base'));
        }


        let mantissaArr = (mantissa + "").split(decimalsep);
        let exponentArr = (exponent + "").split(decimalsep);
        let digitsMantissa = String(mantissaArr[0]);
        let fractionsMantissa = String(mantissaArr[1]);
        let digitsExponent = String(exponentArr[0]);
        let fractionsExponent = String(exponentArr[1]);
        let startMantissa = 0;
        let startExponent = 0;
        let factorMantissa = 1;     
        let factorExponent = 1;     

        //check for sign
        if(digitsMantissa.indexOf('-') == 0){
            digitsMantissa = digitsMantissa.substring(1);
            factorMantissa = -1;
            startMantissa = 0;
        } else if(digitsMantissa.indexOf('+') == 0){
            startMantissa = 0;
            digitsMantissa = digitsMantissa.substring(1);
        }

        if(digitsExponent.indexOf('-') == 0){
            digitsExponent = digitsExponent.substring(1);
            factorExponent = -1;
            startExponent = 0;
        } else if(digitsExponent.indexOf('+') == 0){
            startExponent = 0;
            digitsExponent = digitsExponent.substring(1);
        }
        

        //check for wrong digits
        let okay = true;
        for(let i = startMantissa; i < digitsMantissa.length; i++){            
            if(this.getSubmodel().mantissa.digits.indexOf(digitsMantissa[i].toUpperCase()) == -1) okay = false;
        }

        for(let i = 0; i < fractionsMantissa.length; i++){            
            if(this.getSubmodel().mantissa.digits.indexOf(fractionsMantissa[i].toUpperCase()) == -1) okay = false;
        }

        for(let i = startExponent; i < digitsExponent.length; i++){            
            if(this.getSubmodel().exponent.digits.indexOf(digitsExponent[i].toUpperCase()) == -1) okay = false;
        }

        for(let i = 0; i < fractionsExponent.length; i++){            
            if(this.getSubmodel().exponent.digits.indexOf(fractionsExponent[i].toUpperCase()) == -1) okay = false;
        }

        nerdamer.flush();
        nerdamer.clearVars();
        nerdamer.setConstant('E', 'delete');

        //convert
        if(okay){
            //digits before decimalseparator
            try{
                for(let i = 0; i < digitsMantissa.length - startMantissa; i++){
                    //decimalnumber += this.getSubmodel().digits.indexOf(digits[digits.length - i - 1].toUpperCase()) * Math.pow(this.base,i);
                    decimalnumberMantissa = nerdamer(decimalnumberMantissa.toTeX('decimal') + "+" + this.getSubmodel().mantissa.digits.indexOf(digitsMantissa[digitsMantissa.length - i - 1].toUpperCase())+"*"+this.base+'^'+i);        
                }

                for(let i = 0; i < digitsExponent.length - startExponent; i++){
                    //decimalnumber += this.getSubmodel().digits.indexOf(digits[digits.length - i - 1].toUpperCase()) * Math.pow(this.base,i);
                    decimalnumberExponent = nerdamer(decimalnumberExponent.toTeX('decimal') + "+" + this.getSubmodel().exponent.digits.indexOf(digitsExponent[digitsExponent.length - i - 1].toUpperCase())+"*"+this.base+'^'+i);        
                }
    

                //fractions        
                if(mantissaArr.length > 1){
                    
                    for(let i = 0; i < String(mantissaArr[1]).length; i++){
                        decimalnumberMantissa = nerdamer(decimalnumberMantissa.toTeX('decimal') + "+" + this.getSubmodel().mantissa.digits.indexOf(fractionsMantissa[i].toUpperCase())+"*"+this.base+'^(-'+(i+1)+')');                    
                    }
                }

                if(exponentArr.length > 1){
                    
                    for(let i = 0; i < String(exponentArr[1]).length; i++){
                        decimalnumberExponent = nerdamer(decimalnumberExponent.toTeX('decimal') + "+" + this.getSubmodel().exponent.digits.indexOf(fractionsExponent[i].toUpperCase())+"*"+this.base+'^(-'+(i+1)+')');                    
                    }
                }


            }catch(error){
                //console.log(error);
                console.warn('nerdamer parse error on exponential2decimal');
            }            
            return nerdamer(factorMantissa+"*" + decimalnumberMantissa.toTeX('decimal') + "*" + this.base + "^(" + factorExponent + "*" + decimalnumberExponent+")").toTeX('decimal');
        } else {
            return null;
        }

        
    }



    getEdML(){
        let text = "";
        if(this.querySelector('edml-mantissa').classList.contains('hidden') == false){
            text = this.querySelector('edml-mantissa').getEdML();
        }
        text += this.querySelector('edml-exponent').getEdML();
        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 
        
        return '<exponential'+attr+'>' + text + '</exponential>';
    }

    

    save2SCORM(result){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true && (edMLPlayer_Config.get('player.scorm.testonly') != true || document.querySelector('edml-test.active') != null)){  
            let navitem = this.closest('edml-variant').querySelector('edml-navitem.selected');
            if(navitem != null) navitem = navitem.getAttribute('name');
            let exercisename = edML_SCORM.saveInputObjective(result,this.closest('edml-input'),this.getString());
            edML_SCORM.saveInteraction(this.closest('edml-page').getAttribute("name"),"other","input: exponential",navitem,exercisename,null);
        }
    }

    initFromSCORM(entrynb){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true){
            let value = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.description');           
            this.setValue(value);        

            if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "failed"){
                this.closest('edml-input').setAttribute('solved','false');
            } else if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "passed"){
                this.closest('edml-input').setAttribute('solved','true');
            }
            edMLPlayer_Functions.changeCredits(-this.lastCredits,false);
            this.lastCredits = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.score.raw');
        }
    }


    showSolutionhint(){        
        let hint = document.querySelector('edml-variant.active edml-solutionhint[to="'+this.closest('edml-input').getAttribute('name')+'"]');

        if(this.querySelector('.edml-solutionhint-btn') == null){
            let btn = document.createElement('span');
            btn.classList.add('edml-solutionhint-btn');
            this.append(btn);
            
            btn.addEventListener('click',function(){
                edML_DialogSolutionhint.show(hint);                
            });
        }   
        
    }

    clear(){
        this.removeAttribute('solved');    
        this.querySelector('edml-mantissa').clear();
        this.querySelector('edml-exponent').clear();
    }



} 
class edML_Expression extends edML_Inputvalue{

    static operatorlist = ['+','*','^',"-","/","abs"];
    static operatorlistedML = ['sum','product','power',"difference/negation","fraction"];

    static functionlist = ['sin','cos','tan','sec','csc','cot','acos','asin','atan','atan2','acsc','acot','asec','cosh','sinh','tanh','sech','csch','coth','acosh','asinh','atanh','asech','acsch','acoth','log','log10','min','max','abs','floor','ceil','fact','factorial','exp','mod','sign','round','sqrt'];
    static functionlistedML = edML_Expression.functionlist;

    static constantlist = ["pi","e"];
    static constantlistedML = ["pi","e"];
    

    constructor(){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist(["useonly","usenot","useonce","expect","simplified","credits","model","expanded","testmode"]);
        this.setMixedContent(true);        
        this.check();

        
        this.key = new Uint8Array(32);
        for(let i =  0; i < 32; i++){
            this.key[i] = Math.floor(Math.random()*Number.MAX_SAFE_INTEGER);
        }

        let solution =  this.innerText;        
        if(solution != null){                 
            let textBytes = aesjs.utils.utf8.toBytes(solution);            
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let encryptedBytes = aesCtr.encrypt(textBytes); 
            let encryptedHex = aesjs.utils.hex.fromBytes(encryptedBytes);
            this.solution = encryptedHex;
            this.innerText = "";
        }

        this.lastCredits = 0; 



    }

    connectedCallback(){
        //create GUI objects
        if(this.connected == null){
            this.connected = true;
            if(this.querySelector(":scope > .edml-expression-input") == null && (this.parentNode.firstChild == this && this.parentNode instanceof edML_Input || !(this.parentNode instanceof edML_Input))){            

                let input = document.createElement('input');
                input.classList.add('edml-expression-input');   
                input.classList.add('active');        
                this.append(input);

                if(edMLPlayer_Config.get("defaultmodel.expression.inputmode") == "calculator") {
                    let calculatorbtn = document.createElement('div');
                    calculatorbtn.classList.add('edml-expression-calcbtn');
                    this.prepend(calculatorbtn);
                

                    calculatorbtn.addEventListener('click',function(){
                        window.setTimeout(function(){ExpressionCalculator.show(this)}.bind(this),220);  // time delay to finish focusout event before!                  
                    }.bind(this));

                    input.addEventListener('focus',function(evt){
                        if(window.screen.width < 320) {
                            ExpressionCalculator.show(this);
                        } else {
                            this.classList.add('showcalculator');
                        }
                    }.bind(this));
    
                    input.addEventListener('focusout',function(evt){                    
                        ExpressionCalculator.hide();                        
                        window.setTimeout(function(){this.classList.remove('showcalculator')}.bind(this),200); // time delay to process click event of calculatorbtn before!
                    }.bind(this));
                }

                if(this.closest('edml-input') != null && this.closest('edml-input').getAttribute('width') != null){
                    input.style.maxWidth = this.closest('edml-input').getAttribute('width');
                    input.style.minWidth = this.closest('edml-input').getAttribute('width');
                }
                
                input.addEventListener('keyup',function(evt){
                    if(evt.key.toLowerCase() == "enter" && this.closest('edml-variant').querySelector('edml-test.active') == null && this.checkShowCheckButton()){
                        let input = this.closest('edml-input');
                        input.removeAttribute('solved');
                        input.classList.remove('missed');
                        this.classList.remove('unsolved'); 
                        edMLPlayer_Functions.checkContainer(input); 
                        if(document.querySelector('.edml-expression-output') != null) document.querySelector('.edml-expression-output').classList.remove('active');
                        
                        if(window.edmlcheckbutton.container.length == 1 && window.edmlcheckbutton.container[0] == input) {
                            
                            edmlcheckbutton.classList.remove('show');
                            window.edmlcheckbutton.container = [];
                            edMLPlayer_Functions.setTimer(null,null);
                        }
                    } else {

                        this.onCheck();  
                        //if(edMLPlayer_Config.get("defaultmodel.expression.inputmode") == "preview") {
                        this.renderInput(evt);
                         //} 
                    }
                            
                }.bind(this));

         
                
            }    
        }
        
    }


    getSubmodel(){
        return this.getModel().getSubmodel('expression');
    }


    async renderInput(evt){    
        if(evt.calculator == null || evt.calculator != true) {  
            if(this.closest('edml-course') != null && this.closest('edml-course').querySelector('.edml-expression-output') == null){
                let output = new edML_M();
                output.classList.add('edml-expression-output');
                this.closest('edml-course').append(output);
                if(edMLPlayer_Config.get("defaultmodel.expression.inputmode") == "preview"){
                    output.classList.add('nocalculator');
                }
            }
            let output = this.closest('edml-course').querySelector('.edml-expression-output');
            this.closest('edml-pages').prepend(output);
            output.classList.add('active');

            //positioning
            if(this.closest('edml-input').previousElementSibling != output || output.last != this){
                output.last = this;
                output.style.top = "inherit";
                output.style.left = "inherit";
                
                //this.closest('edml-input').parentNode.insertBefore(output,this.closest('edml-input')); //insert before input element

                let left = this.getBoundingClientRect().left; // - this.closest('edml-p').parentNode.getBoundingClientRect().left;
                let top =  this.closest('edml-input').getBoundingClientRect().top + this.closest('edml-variant').scrollTop + this.closest('edml-input').getBoundingClientRect().height/2; //this.closest('edml-input').getBoundingClientRect().bottom + 16; // + output.offsetHeight + this.offsetTop + 16;
            /* console.log( this.closest('edml-p').parentNode.getBoundingClientRect().left);
                console.log( this.offsetLeft);
                console.log( this.getBoundingClientRect().left);
                console.log( output.getBoundingClientRect().left);
                console.log(left);*/
                output.style.top = "" + top + "px";
                output.style.left = "" + left + "px";
                //console.log(document.querySelector('.edmlplayer').getBoundingClientRect().top);
            }

            try{
                let ival = this.querySelector('input').value;
                                    
                
                if(edMLPlayer_Config.get("course.decimalseparator") == ","){
                    ival = ival.replaceAll(',','.');
                    ival = ival.replaceAll(';',',');             
                }
            


                let latex = nerdamer.convertToLaTeX(ival); 
                latex = latex.replaceAll('*','\\cdot '); 

                let wordarr = edMLPlayer_Config.get("defaultmodel.expression.infinityaddword");
                
                for(let i = 0; i < wordarr.length; i++){
                    latex = latex.replaceAll("\\"+wordarr[i]+" ",'\\infty ');  
                    latex = latex.replaceAll(wordarr[i]+" ",'\\infty ');
                    
                    if(latex == wordarr[i]) latex = '\\infty';
                    if(ival == wordarr[i]) latex = '\\infty';  
                }



                                           
                
                if(edMLPlayer_Config.get("player.mathjax.active")) {
                    output.innerText = '#$#'+latex+'#$#'; 
                } else {
                    output.innerText = latex;
                    
                }
                output.classList.remove('rendered');
                
                if(this.renderTimer != null) window.clearTimeout(this.renderTimer);
                this.renderTimer = window.setTimeout(function(){
                    
                    if(this.closest('edml-course') != null && this.closest('edml-course').querySelector('.edml-expression-output') != null){
                        this.closest('edml-course').querySelector('.edml-expression-output').classList.remove('active');                    
                    }
                }.bind(this),2000);

                await edMLPlayer_Util.typesetMath(output);

                
            
            } catch(err){
            //   console.log(nerdamer.convertToLaTeX(this.querySelector('input').value));
                this.closest('edml-course').querySelector('.edml-expression-output').innerHTML = '<span class="edml-expressionerror">'+document.edmllocale.get('latexerror')+'</span>';  
            }
        }

    }

    setValue(val){
        this.querySelector('input').value = val;
    }

    getValue(){
       return this.querySelector('input').value;           
    }

    getStateValue(){
        return this.getValue();
    }

    getDecimalValue(){
        return this.querySelector('input').value;           
     }

    getString(){
        return this.querySelector('input').value.toString();           
     }

    


    getEdML(){
        let text = "";
        if(this.solution != ""){
            let encryptedBytes = aesjs.utils.hex.toBytes(this.solution);
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let decryptedBytes = aesCtr.decrypt(encryptedBytes);
            text = aesjs.utils.utf8.fromBytes(decryptedBytes); 
        }     
        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 

        return '<expression'+attr+'>' + text + '</expression>';
    }

    verify(value, model){
       // console.log(value);
        if(this.closest('edml-course').querySelector('.edml-expression-output') != null) this.closest('edml-course').querySelector('.edml-expression-output').classList.remove('active');        
        if(model == null) model = this.getSubmodel();

        let solvedobj = new Object();
        solvedobj.solved = false;
        if(this.getAttribute('credits') != null && !isNaN(parseInt(this.getAttribute('credits')))) {
            solvedobj.credits = parseInt(this.getAttribute('credits'));
         } else {
            solvedobj.credits = model.credits;
        }

        if(this.solution != ""){
            
            
            let expect = model.expect;
            let useonly = model.useonly;
            let usenot = model.usenot;
            let useonce = model.useonce;
            let simplify = model.simplify;
            let expanded = model.expanded;
            let testmode = model.testmode.trim();

            if(this.getAttribute('expect') != null) expect = this.getAttribute('expect');
            if(this.getAttribute('usenot') != null) usenot = this.getAttribute('usenot');
            if(this.getAttribute('useonly') != null) useonly = this.getAttribute('useonly');
            if(this.getAttribute('useonce') != null) useonce = this.getAttribute('useonce');
            if(this.getAttribute('simplified') != null) simplify = this.getAttribute('simplified');
            if(this.getAttribute('expanded') != null) expanded = this.getAttribute('expanded');
            if(this.getAttribute('testmode') != null) testmode = this.getAttribute('testmode').trim();


            let encryptedBytes = aesjs.utils.hex.toBytes(this.solution);
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let decryptedBytes = aesCtr.decrypt(encryptedBytes);
            let solution = aesjs.utils.utf8.fromBytes(decryptedBytes); 
            
            let expression = value;
            if(value == null) {
                expression = this.querySelector('input').value;
            } 
            
            if(edMLPlayer_Config.get("course.decimalseparator") == ","){
                expression = expression.replaceAll(',','.');
                expression = expression.replaceAll(';',',');             
            }



            //replace ln to log
            expression = expression.replaceAll(/([^a-zA-Z0-9]?)ln\(/gms,'$1log(');
            solution = solution.replaceAll(/([^a-zA-Z0-9]?)ln\(/gms,'$1log(');
            


            let solved = false;
            nerdamer.flush();
            nerdamer.clearVars();
            nerdamer.setConstant('E', 'delete');
            let parentbox = this.parentNode;
            
            while(parentbox instanceof edML_Box == false && parentbox != null){
                parentbox = parentbox.parentNode;
            }
            if(parentbox != null){
                    nerdamer.flush();
                    nerdamer.clearVars();
                    
                    if(parentbox.parameters != null){
                        
                        for(let i = 0; i < parentbox.parameters.length; i++){
                            nerdamer.setVar(parentbox.parameters[i],parentbox.values[i]);
                        }              
                    }
            } 
            

          /*  if(checkderivatives == "true" || checkderivatives == true){
                solution = "diff("+solution+",x)";
                expression = "diff("+expression+",x)";
            }*/
            
            try{            
                
                if(expression.toString().search('Infinity') > -1 || solution.toString().search('Infinity') > -1){                 
                    if(JSON.stringify(nerdamer('simplify('+solution+')')) == JSON.stringify(nerdamer('simplify('+expression+')'))){
                        solved = true;                       
                    }                                                          
                } else {
                    let test;                    
                    if(testmode.indexOf("derivative by ") == 0 ){
                        let variable = testmode.replace('derivative by ','');
                        test = nerdamer('simplify(diff('+solution+','+variable+')-(diff('+expression+','+variable+')))'); 
                    } else {                        
                        test = nerdamer('simplify('+ solution +'-('+expression+'))'); 
                    }
                   
                    //equalize possible calculation errors if result is number
                    if(test != null && !isNaN(test.text('decimals'))) {
                        test = Math.abs(test.text('decimals'));
                        if(test < model.precision){
                            solved = true;
                        }
                    } 
                }

                if(edMLPlayer_Config.get("player.nerdamer.evalmode") == "strict") {
                    if(expression.toString().indexOf("/+") > -1) solved = false;
                    if(expression.toString().indexOf("/-") > -1) solved = false;
                    if(expression.toString().indexOf("*+") > -1) solved = false;
                    if(expression.toString().indexOf("*-") > -1) solved = false;
                    if(expression.toString().indexOf("++") > -1) solved = false;
                    if(expression.toString().indexOf("+-") > -1) solved = false;
                    if(expression.toString().indexOf("--") > -1) solved = false;
                    if(expression.toString().indexOf("--") > -1) solved = false;                    
                }

                if(solved){                    
                    //create list of operator, functions and variables
                    this.opList = new Array();    
                    this.numberList = new Array();    
                    this.functionList = new Array();    
                    this.constantList = new Array();    
                    this.variableList = new Array();    
                    let tree = nerdamer.tree(expression);
             
                    //parse Tree, the arrays (= flatten tree lists of a specific type) may include multiple entries of e.g. sin 
                    this.loopTree(tree,this.opList,this.numberList,this.functionList, this.constantList, this.variableList);

                    //parameter variable used in expression? 
                    if(parentbox != null && parentbox.parameters != null){
                        for(let i = 0; i < parentbox.parameters.length; i++){                            
                            if(this.variableList.includes(parentbox.parameters[i])) solved = false;
                        }    
                    }

 
                    //expect?
                    if(expect != null && expect.trim() != ""){
                        let expectArr = expect.split(' ');                
                        let lastOperator = tree.value;

                        if(edML_Expression.operatorlist.indexOf(lastOperator) > -1){
                            lastOperator = edML_Expression.operatorlistedML[edML_Expression.operatorlist.indexOf(lastOperator)];
                            if(lastOperator == "difference/negation"){
                                if(tree.right == null){
                                    lastOperator = "negation";
                                } else {
                                    lastOperator = "difference";
                                }
                            }
                        }

                        if(edML_Expression.functionlist.indexOf(lastOperator) > -1){
                            lastOperator = edML_Expression.functionlistedML[edML_Expression.functionlist.indexOf(lastOperator)];
                        }

                        if(edML_Expression.constantlist.indexOf(lastOperator) > -1){
                            lastOperator = edML_Expression.constantlistedML[edML_Expression.constantlist.indexOf(lastOperator)];
                        }  
   
                        if(!expectArr.includes(lastOperator)) solved = false; 
                        
                        //expect mit number
                        if(expectArr.includes("number") && !isNaN(Number(lastOperator))){
                            solved = true;
                        }
                        
                        //console.log(lastOperator);
                        //console.log(tree);                    
                    }
                    
                   
                    
                    //usenot
                    if(usenot != null && usenot.trim() != ""){
                        let usenotArr = usenot.split(' ');
                        for(let i = 0; i < usenotArr.length; i++){
                            if(this.opList.indexOf(usenotArr[i]) > -1){
                               solved = false;
                            } else if(this.numberList.indexOf(usenotArr[i]) > -1){
                                solved = false;
                            } else if(this.functionList.indexOf(usenotArr[i]) > -1){
                                solved = false;
                            } else if(this.variableList.indexOf(usenotArr[i]) > -1){
                                solved = false;
                            }                                                     
                        }

                        if(usenotArr.indexOf('number') > -1 && this.numberList.length > 0){
                            solved = false;
                        }
                    }

                    
                    if(useonly != null && useonly.trim() != ""){

                        let useonlyArr = useonly.split(' ');
                        //copy array and make elements unique
                        let opCopy = [...new Set(this.opList)];
                        let functionCopy = [...new Set(this.functionList)]; 
                        let constantCopy = [...new Set(this.constantList)];
                        let variableCopy = [...new Set(this.variableList)];
                        let numberCopy = [...new Set(this.numberList)];

                        
                        for(let i = 0; i < useonlyArr.length; i++){
                            if(edML_Expression.operatorlistedML.indexOf(useonlyArr[i]) > -1){
                                opCopy = opCopy.filter((item) => item != useonlyArr[i]); // remove item form array
                            } else if(edML_Expression.functionlist.indexOf(useonlyArr[i]) > -1){
                                functionCopy = functionCopy.filter((item) => item !== useonlyArr[i]); // remove item form array
                            } else if(edML_Expression.constantlist.indexOf(useonlyArr[i]) > -1){
                                constantCopy = constantCopy.filter((item) => item !== useonlyArr[i]); // remove item form array
                            } else {
                                variableCopy = variableCopy.filter((item) => item !== useonlyArr[i]); // remove item form array
                                numberCopy = numberCopy.filter((item) => item !== useonlyArr[i]); // remove item form array
                            }

                            
                        }
                        
                        //global edML-constants
                        if(useonlyArr.indexOf('function') > -1){
                            functionCopy.length = 0;
                        }

                        if(useonlyArr.indexOf('operator') > -1){
                            opCopy.length = 0;
                        }

                        if(useonlyArr.indexOf('constant') > -1){
                            constantCopy.length = 0;
                        }

                        if(useonlyArr.indexOf('variable') > -1){
                            variableCopy.length = 0;
                        }


                        if(useonlyArr.indexOf('number') == -1 && numberCopy.length > 0){
                            solved = false;
                        }

                        
                        if(opCopy.length > 0 || functionCopy.length > 0 || constantCopy > 0 || variableCopy.length > 0) {
                            solved = false;
                        }
                           
                        

                    }

                    //useonce
                    if(useonce != null && useonce.trim() != ""){
                        let useonceArr = useonce.split(' ');
                        let idx;

                        for(let i = 0; i < useonceArr.length; i++){
                            if(edML_Expression.operatorlistedML.indexOf(useonceArr[i]) > -1){
                                idx = this.opList.indexOf((useonceArr[i]))+1;
                                if(idx > -1 && this.opList.indexOf((useonceArr[i]),idx) > -1){
                                    solved = false;
                                }
                            } else if(edML_Expression.functionlist.indexOf(useonceArr[i]) > -1){
                                idx = this.functionList.indexOf((useonceArr[i]))+1;
                                if(idx > -1 && this.functionList.indexOf((useonceArr[i]),idx) > -1){
                                    solved = false;
                                }
                            } else if(edML_Expression.constantlist.indexOf(useonceArr[i]) > -1){
                                idx = this.constantList.indexOf((useonceArr[i]))+1;
                                if(idx > -1 && this.constantList.indexOf((useonceArr[i]),idx) > -1){
                                    solved = false;
                                }
                            } else {
                                idx = this.variableList.indexOf((useonceArr[i]))+1;
                                if(idx > -1 && this.variableList.indexOf((useonceArr[i]),idx) > -1){
                                    solved = false;
                                }
                            }
                        }
                        if(useonceArr.indexOf('number') > -1 && this.numberList.length > 1){
                            solved = false;
                        }
                    }

                    //simplify
                
                    if(simplify == "true" || simplify == true){
         
                        //create flatten tree lists
                        let simplifyOpList = new Array();
                        let simplifyNumberList = new Array();
                        let simplifyFunctionList = new Array();    
                        let simplifyConstantList = new Array();    
                        let simplifyVariableList = new Array();   
                        let simplifytree = nerdamer.tree(nerdamer('simplify('+expression+')'));                    
                        this.loopTree(simplifytree,simplifyOpList,simplifyNumberList,simplifyFunctionList,simplifyConstantList,simplifyVariableList);   

                        let originalOpList = new Array();
                        let originalNumberList = new Array();
                        let originalFunctionList = new Array();    
                        let originalConstantList = new Array();    
                        let originalVariableList = new Array();   
                        let originaltree = nerdamer.tree(expression);
                        this.loopTree(originaltree,originalOpList,originalNumberList,originalFunctionList,originalConstantList,originalVariableList);                        
                        originalNumberList = this.extractNumbers(expression); 
                        

                        //check flatten tree lists against each other
                        if(simplifyOpList.length != originalOpList.length) solved = false;
                        if(simplifyNumberList.length != originalNumberList.length) solved = false;
                        if(simplifyFunctionList.length != originalFunctionList.length) solved = false;
                        if(simplifyConstantList.length != originalConstantList.length) solved = false;
                        if(simplifyVariableList.length != originalVariableList.length) solved = false;

                        if(solved == true){
                            for(let i = 0; i < originalOpList.length;i++){
                                if(simplifyOpList.indexOf(originalOpList[i]) > -1){
                                    simplifyOpList.splice(simplifyOpList.indexOf(originalOpList[i]),1);
                                } else solved = false;
                            }
                            if(simplifyOpList.length > 0) solved = false;
                        }
         
                        
                        if(solved == true){
                            for(let i = 0; i < originalNumberList.length;i++){
                                if(simplifyNumberList.indexOf(originalNumberList[i]) > -1){
                                    simplifyNumberList.splice(simplifyNumberList.indexOf(originalNumberList[i]),1);
                                } else solved = false;
                            }
                            if(simplifyNumberList.length > 0) solved = false;
                        }
                    

                        if(solved == true){
                            for(let i = 0; i < originalFunctionList.length;i++){
                                if(simplifyFunctionList.indexOf(originalFunctionList[i]) > -1){
                                    simplifyFunctionList.splice(simplifyFunctionList.indexOf(originalFunctionList[i]),1);
                                } else solved = false;
                            }
                            if(simplifyFunctionList.length > 0) solved = false;
                        }
                     

                        if(solved == true){
                            for(let i = 0; i < originalConstantList.length;i++){
                                if(simplifyConstantList.indexOf(originalConstantList[i]) > -1){
                                    simplifyConstantList.splice(simplifyConstantList.indexOf(originalConstantList[i]),1);
                                } else solved = false;
                            }
                            if(simplifyConstantList.length > 0) solved = false;
                        }
                       

                        if(solved == true){
                            for(let i = 0; i < originalVariableList.length;i++){
                                if(simplifyVariableList.indexOf(originalVariableList[i]) > -1){
                                    simplifyVariableList.splice(simplifyVariableList.indexOf(originalVariableList[i]),1);
                                } else solved = false;
                            }
                            if(simplifyVariableList.length > 0) solved = false;
                        }
                                           
                    }
                
                    //verbatim
                    if(testmode == "verbatim"){
                        
                        //create flatten tree lists
                        let verbatimOpList = new Array();
                        let verbatimNumberList = new Array();
                        let verbatimFunctionList = new Array();    
                        let verbatimConstantList = new Array();    
                        let verbatimVariableList = new Array();   
                        let verbatimtree = nerdamer.tree(expression);
                        this.loopTree(verbatimtree,verbatimOpList,verbatimNumberList,verbatimFunctionList,verbatimConstantList,verbatimVariableList);
                        verbatimNumberList = this.extractNumbers(expression);   

                        let originalOpList = new Array();
                        let originalNumberList = new Array();
                        let originalFunctionList = new Array();    
                        let originalConstantList = new Array();    
                        let originalVariableList = new Array();   
                        let originaltree = nerdamer.tree(solution);
                        this.loopTree(originaltree,originalOpList,originalNumberList,originalFunctionList,originalConstantList,originalVariableList);
                        originalNumberList = this.extractNumbers(expression);  
                        
                        //check flatten tree lists against each other
                        if(verbatimOpList.length != originalOpList.length) solved = false;
                        if(verbatimNumberList.length != originalNumberList.length) solved = false;
                        if(verbatimFunctionList.length != originalFunctionList.length) solved = false;
                        if(verbatimConstantList.length != originalConstantList.length) solved = false;
                        if(verbatimVariableList.length != originalVariableList.length) solved = false;
                        

                        if(solved == true){
                            for(let i = 0; i < originalOpList.length;i++){
                                if(verbatimOpList.indexOf(originalOpList[i]) > -1){
                                    verbatimOpList.splice(verbatimOpList.indexOf(originalOpList[i]),1);
                                } else solved = false;
                            }
                            if(verbatimOpList.length > 0) solved = false;

                            for(let i = 0; i < originalNumberList.length;i++){
                                if(verbatimNumberList.indexOf(originalNumberList[i]) > -1){
                                    verbatimNumberList.splice(verbatimNumberList.indexOf(originalNumberList[i]),1);
                                } else solved = false;
                            }
                            if(verbatimNumberList.length > 0) solved = false;

                            for(let i = 0; i < originalFunctionList.length;i++){
                                if(verbatimFunctionList.indexOf(originalFunctionList[i]) > -1){
                                    verbatimFunctionList.splice(verbatimFunctionList.indexOf(originalFunctionList[i]),1);
                                } else solved = false;
                            }
                            if(verbatimFunctionList.length > 0) solved = false;

                            for(let i = 0; i < originalConstantList.length;i++){
                                if(verbatimConstantList.indexOf(originalConstantList[i]) > -1){
                                    verbatimConstantList.splice(verbatimConstantList.indexOf(originalConstantList[i]),1);
                                } else solved = false;
                            }
                            if(verbatimConstantList.length > 0) solved = false;

                            for(let i = 0; i < originalVariableList.length;i++){
                                if(verbatimVariableList.indexOf(originalVariableList[i]) > -1){
                                    verbatimVariableList.splice(verbatimVariableList.indexOf(originalVariableList[i]),1);
                                } else solved = false;
                            }
                            if(verbatimVariableList.length > 0) solved = false;
                        }
                    }
                   

                    //expanded
                    if(expanded == "true" || expanded == true){
                        //create flatten tree lists
                        let expandedOpList = new Array();
                        let expandedNumberList = new Array();
                        let expandedFunctionList = new Array();    
                        let expandedConstantList = new Array();    
                        let expandedVariableList = new Array();   
                        let expandedtree = nerdamer.tree(nerdamer('expand('+expression+')'));
                        this.loopTree(expandedtree,expandedOpList,expandedNumberList,expandedFunctionList,expandedConstantList,expandedVariableList);   

                        let originalOpList = new Array();
                        let originalNumberList = new Array();
                        let originalFunctionList = new Array();    
                        let originalConstantList = new Array();    
                        let originalVariableList = new Array();   
                        let originaltree = nerdamer.tree(nerdamer(expression));
                        this.loopTree(originaltree,originalOpList,originalNumberList,originalFunctionList,originalConstantList,originalVariableList);
                        originalNumberList = this.extractNumbers(expression);    
       
                        //check flatten tree lists against each other
                        if(expandedOpList.length != originalOpList.length) solved = false;
                        if(expandedNumberList.length != originalNumberList.length) solved = false;
                        if(expandedFunctionList.length != originalFunctionList.length) solved = false;
                        if(expandedConstantList.length != originalConstantList.length) solved = false;
                        if(expandedVariableList.length != originalVariableList.length) solved = false;

                        
                        if(solved == true){
                            for(let i = 0; i < originalOpList.length;i++){
                                if(expandedOpList.indexOf(originalOpList[i]) > -1){
                                    expandedOpList.splice(expandedOpList.indexOf(originalOpList[i]),1);
                                } else solved = false;
                            }
                            
                            if(expandedOpList.length > 0) solved = false;
                        }

                        //numbers are not checked because 3/2 = 6/4 etc.
                       /* if(solved == true){
                            for(let i = 0; i < originalNumberList.length;i++){
                                if(expandedNumberList.indexOf(originalNumberList[i]) > -1){
                                    expandedNumberList.splice(expandedNumberList.indexOf(originalNumberList[i]),1);
                                } else solved = false;
                            }
                            if(expandedNumberList.length > 0) solved = false;
                        }*/

                        if(solved == true){
                            for(let i = 0; i < originalFunctionList.length;i++){
                                if(expandedFunctionList.indexOf(originalFunctionList[i]) > -1){
                                    expandedFunctionList.splice(expandedFunctionList.indexOf(originalFunctionList[i]),1);
                                } else solved = false;
                            }
                            if(expandedFunctionList.length > 0) solved = false;
                        }

                        if(solved == true){
                            for(let i = 0; i < originalConstantList.length;i++){
                                if(expandedConstantList.indexOf(originalConstantList[i]) > -1){
                                    expandedConstantList.splice(expandedConstantList.indexOf(originalConstantList[i]),1);
                                } else solved = false;
                            }
                            if(expandedConstantList.length > 0) solved = false;
                        }

                        if(solved == true){
                            for(let i = 0; i < originalVariableList.length;i++){
                                if(expandedVariableList.indexOf(originalVariableList[i]) > -1){
                                    expandedVariableList.splice(expandedVariableList.indexOf(originalVariableList[i]),1);
                                } else solved = false;
                            }
                            if(expandedVariableList.length > 0) solved = false;
                        }
                        
                        

                    }


                   /* //must be last one: simplify
                    if(simplify=="true" || simplify == true) {
                        let solutionOpList = new Array();
                        let solutionNumberList = new Array();
                        let solutionFunctionList = new Array();    
                        let solutionConstantList = new Array();    
                        let solutionVariableList = new Array();    
                        let tree = nerdamer.tree(nerdamer('simplify('+solution+')'));
                        this.loopTree(tree,solutionOpList,solutionNumberList,solutionFunctionList,solutionConstantList,solutionVariableList);  
                             
                        let i = 0;

                        solutionOpList.sort();
                        solutionNumberList.sort();
                        this.opList.sort();
                        this.numberList.sort();
                    
                        if(this.opList.length != solutionOpList.length) solved = false;
                        if(this.numberList.length != solutionNumberList.length) solved = false;


                        while(i < solutionOpList.length && solved == true){
                            if(this.opList[i] != solutionOpList[i]) solved = false;
                            i++;              
                        }

                        i = 0;
                        while(i < solutionNumberList.length && solved == true){
                            if(this.numberList[i] != solutionNumberList[i]) solved = false;
                            i++;                        
                        }
                    }*/
                } 
            } catch(error){
                //console.log(error);
                console.warn('nerdamer parse error');
            }
            if(solved){
                if(this.querySelector('.edml-solutionhint-btn') != null) this.querySelector('.edml-solutionhint-btn').remove();
                solvedobj.solved = true;            
            } else {
                solvedobj.solved = false;

            }
            
            return solvedobj;
        }
        
    }

    extractNumbers(expression){
        let arr = new Array();
        let matcharr = [...expression.matchAll(/\d+\.\d+|\d+/gm)];
        for(let i = 0; i < matcharr.length; i++){
            arr.push(matcharr[i][0]);
        }
        return arr;
    }


    loopTree(node,opList,numberList,functionList,constantList,variableList){
        //fractions are always reduced/shortend in tree --> if needed, use exactNumbers instead for numberList

        if(node.type == "OPERATOR") {
            let val = node.value;

            if(edML_Expression.operatorlist.indexOf(val) > -1){
                opList.push(edML_Expression.operatorlistedML[edML_Expression.operatorlist.indexOf(val)]);
            }
            
            
        } else if(node.type == "VARIABLE_OR_LITERAL" && Number.isNaN(Number.parseFloat(node.value)) == true) {
            let val = node.value;

            if(edML_Expression.constantlist.indexOf(val) > -1){
                constantList.push(edML_Expression.constantlistedML[edML_Expression.constantlist.indexOf(val)]);
            } else {
                variableList.push(val);
            }
        } else if(node.type == "VARIABLE_OR_LITERAL" && Number.isNaN(Number.parseFloat(node.value)) == false){
            numberList.push(node.value);
        } else if(node.type == "FUNCTION"){
            let val = node.value;
            if(edML_Expression.functionlist.indexOf(val) > -1){
                functionList.push(edML_Expression.functionlistedML[edML_Expression.functionlist.indexOf(val)]);
            }
        }
        if(node.left != null) this.loopTree(node.left,opList,numberList,functionList,constantList,variableList);
        if(node.right != null) this.loopTree(node.right,opList,numberList,functionList,constantList,variableList);

    }

    toggleView(){
        if(this.closest('edml-course').querySelector('.edml-expression-output') != null) this.closest('edml-course').querySelector('.edml-expression-output').classList.remove('active');
    }


    save2SCORM(result){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true && (edMLPlayer_Config.get('player.scorm.testonly') != true || document.querySelector('edml-test.active') != null)){  
            let navitem = this.closest('edml-variant').querySelector('edml-navitem.selected');
            if(navitem != null) navitem = navitem.getAttribute('name');
            let exercisename = edML_SCORM.saveInputObjective(result,this.closest('edml-input'),this.getValue().toString());
            edML_SCORM.saveInteraction(this.closest('edml-page').getAttribute("name"),"other","input: expression",navitem,exercisename,null);
        }
    }


    

    initFromSCORM(entrynb){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true){  
            let input = this.querySelector(':scope > .edml-expression-input');
            if(input != null) input.value = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.description');           
            if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "failed"){
                this.closest('edml-input').setAttribute('solved','false');
            } else if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "passed"){
                this.closest('edml-input').setAttribute('solved','true');
            }
            edMLPlayer_Functions.changeCredits(-this.lastCredits,false);
            this.lastCredits = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.score.raw');
        }
    }


    clear(){
        if(this.querySelector('.edml-expression-input') != null) this.querySelector('.edml-expression-input').value = "";
        this.removeAttribute('solved');       
    }


    showSolutionhint(){
        let hint = document.querySelector('edml-variant.active edml-solutionhint[to="'+this.closest('edml-input').getAttribute('name')+'"]');
        if(this.querySelector('.edml-solutionhint-btn') == null){
            let btn = document.createElement('span');
            btn.classList.add('edml-solutionhint-btn');
            this.append(btn);
            
            btn.addEventListener('click',function(){
                edML_DialogSolutionhint.show(hint);                
            });
        }

    }
}
class edML_Externmedia extends edML_Tag{


    constructor(){
        super();
        this.setTagWhitelist(["metadata"]);
        this.setAttributeWhitelist(["name","tags","source","minwidth","maxwidth","minheight","maxheight","autoload","preview"]);
        this.setMixedContent(false);
        this.setRemoveContentByClass([]);
        this.setRequiredAttribute(["source"]);
        this.check();
        this.loaded = false; 

        if(edMLPlayer_Config.get('externmedia.appearance') == "link"){
            this.innerHTML = '<edml-link to="'+this.getAttribute('source')+'">'+document.edmllocale.get('externmedia.linkname')+'</edml-link>';

        } else {
            let innerdiv = document.createElement('div');
            innerdiv.classList.add('edml-externmedia-placeholder');
        // innerdiv.style.width = '100%';
        // innerdiv.style.height = (window.innerHeight*0.5)+'px';
            innerdiv.style.minHeight = "5em";
            let span = document.createElement('span');
            span.classList.add('edml-externmedia-message');
            span.innerText = document.edmllocale.get('externmediamsg');            
            innerdiv.append(span);

            //preview
            if(this.getAttribute('preview') != null){
                var metadata = '<edml-metadata></edml-metadata>';
                if(this.querySelector(':scope > edml-metadata') != null) metadata = this.querySelector(':scope > edml-metadata').outerHTML;
                let pic = document.createElement('span');
                pic.classList.add('edml-externmedia-previewpic');
                pic.innerHTML = '<edml-picture filepath="' + this.getAttribute('preview') + '">'+metadata+'</edml-picture>';
                innerdiv.append(pic);
                this.classList.add('preview');
                if(this.querySelector(':scope > edml-metadata') == null) pic.querySelector('edml-metadata').remove();
            }
            
                
            if(this.getAttribute('maxheight') != null) innerdiv.style.maxHeight =  this.getAttribute('maxheight');  
            if(this.getAttribute('maxwidth') != null) innerdiv.style.maxWidth =  this.getAttribute('maxwidth'); 
            if(this.getAttribute('minheight') != null) innerdiv.style.minHeight =  this.getAttribute('minheight');  
            if(this.getAttribute('minwidth') != null) innerdiv.style.minWidth =  this.getAttribute('minwidth');  
            this.append(innerdiv); 
        }
        
     //   this.load();
        
    }

    start(){
        if(edMLPlayer_Config.get('externmedia.appearance') == "link"){
        } else {
            if(this.loaded == false){
                let autoload = edMLPlayer_Config.get('externmedia.autoload');
                if(this.getAttribute('autoload') != null){
                    if(this.getAttribute('autoload') == 'false') autoload = false; else autoload = true;
                }

                if(autoload != false){
                    this.load();
                } else if(this.querySelector('.edml-externmedia-button') == null) {
                    if(this.querySelector('.edml-externmedia-previewpic') != null && this.querySelector('.edml-externmedia-previewpic').height > 0) this.setAttribute('autoload','off');
                    let innerdiv = this.querySelector('.edml-externmedia-placeholder');
                    let button = document.createElement('div');
                    button.classList.add('edml-externmedia-button');
                    button.innerText = document.edmllocale.get('externmediabutton');
                    innerdiv.append(button);
                    button.addEventListener('click',this.load.bind(this));

                    let subtitle = document.createElement('div');
                    subtitle.classList.add('edml-externmedia-subtitle');
                    let warning = document.createElement('span');
                    warning.classList.add('edml-externmedia-warning');
                    warning.innerText = document.edmllocale.get('externmediawarning');                   
                    subtitle.append(warning);
                    innerdiv.append(subtitle);
                    

                    if(this.querySelector(":scope > edml-metadata") != null){
                        let metadatabtn = document.createElement('span');
                        metadatabtn.classList.add('edml-externmedia-metadatabtn');
                        subtitle.append(metadatabtn);
                        
                        metadatabtn.addEventListener('click',function(){
                            var text = this.querySelector(':scope > edml-metadata').getText();
                            let dlg = new edML_Dialog();
                            dlg.setTitle(document.edmllocale.get("dialog_pictureinfo_title"));        
                            dlg.setBody(text);
                            dlg.hideFooter();
                            dlg.show();
                        }.bind(this));
                    }

                    // info dialog 
        
                    this.metainfo = this.addEventListener('contextmenu', function(evt) {                           
                        evt.preventDefault();                        
                        if(this.querySelector(':scope > edml-metadata') != null){
                            let text = this.querySelector(':scope > edml-metadata').getText();
                        
                            let dlg = new edML_Dialog();
                            dlg.setTitle(document.edmllocale.get("dialog_pictureinfo_title"));        
                            dlg.setBody(text);
                            dlg.hideFooter();
                            dlg.show();
                        }
                    }.bind(this), false);
                    


                    if(this.querySelector('.edml-externmedia-message') != null) this.querySelector('.edml-externmedia-message').remove();
                }
            }
        }
    }

    load(){
        if(this.loaded == false){
            this.removeEventListener('contextmenu',this.metainfo);

            //loader
            let button = this.querySelector('.edml-externmedia-button');
            if(button != null) button.remove();

            let innerdiv = this.querySelector('.edml-externmedia-placeholder');
            let loader = innerdiv.querySelector('.externmedialoader');
            if(loader == null) {
                loader = document.createElement('div');
                loader.classList.add('externmedialoader');
                innerdiv.prepend(loader);
                loader.append(document.createElement('div'));
                loader.append(document.createElement('div'));
                loader.append(document.createElement('div'));
            }
            

            let source = this.getAttribute('source');

            let iframe = document.createElement('iframe');
            iframe.classList.add('edml-externalmedia-iframe');
            iframe.setAttribute('referrerpolicy','no-referrer');
            iframe.setAttribute('allowpaymentrequest','false');
        

            
            iframe.setAttribute('src',source);
        //  iframe.setAttribute('loading',"lazy");     
          //  iframe.style.width = '100%';
          //  iframe.style.height = (window.innerHeight*0.5)+'px';
            iframe.style.display = 'none';
            if(this.getAttribute('maxheight') != null) iframe.style.maxHeight =  this.getAttribute('maxheight');  
            if(this.getAttribute('maxwidth') != null) iframe.style.maxWidth =  this.getAttribute('maxwidth'); 
            if(this.getAttribute('minheight') != null) iframe.style.minHeight =  this.getAttribute('minheight');  
            if(this.getAttribute('minwidth') != null) iframe.style.minWidth =  this.getAttribute('minwidth'); 
            iframe.addEventListener('load',this.onLoad.bind(this));

            this.append(iframe);

            if(this.querySelector(":scope > edml-metadata") != null){
                let metadatabtn = document.createElement('span');
                metadatabtn.classList.add('edml-externmedia-metadatabtn');
                this.append(metadatabtn);
                this.classList.add('showmeta');
                
                metadatabtn.addEventListener('click',function(){
                    var text = this.querySelector(':scope > edml-metadata').getText();
                    let dlg = new edML_Dialog();
                    dlg.setTitle(document.edmllocale.get("dialog_pictureinfo_title"));        
                    dlg.setBody(text);
                    dlg.hideFooter();
                    dlg.show();
                }.bind(this));
            }
        }
    }
    

    onLoad(evt){
        this.loaded = true;   
        
        let page = this.closest('edml-page');
        let active = page.classList.contains('active');
        page.classList.add('active');
        let innerdiv = this.querySelector('.edml-externmedia-placeholder');
        if(innerdiv != null) innerdiv.remove();
        let iframe = this.querySelector('.edml-externalmedia-iframe');
        iframe.style.visibility = 'visible';
        iframe.style.display = 'inline-block';

        let ratio = (0.9 * parseInt(this.closest('edml-page').clientWidth)) / 300; // 300 is browser standard iframe width
        iframe.style.width = 0.9 * parseInt(this.closest('edml-page').clientWidth) + "px";
        iframe.style.height = (0.9 * parseInt(this.closest('edml-page').clientWidth) * 0.6666) + "px"; // 150 is browser standard iframe height

        if(active == false) page.classList.remove('active');

       /* let initHeight = iframe.scrollHeight;
        let initWidth = iframe.scrollWidth;
        console.log(initWidth + "  " + initHeight);
        iframe.style.width = '90%';
        let width = iframe.scrollWidth;
        let height = width/initWidth * initHeight;
        console.log(width + "  " + height);
        iframe.style.height = (height*1.15) + "px";*/




        //console.log(iframe.contentWindow.document.documentElement.scrollHeight);
      //  iframe.style.height = 'auto';
        
        //this.closest('edml-page').append(iframe);

       /* let iframe = this.querySelector('.edml-externalmedia-iframe');
        iframe.style.width = '100%';
        //iframe.style.height = (window.innerHeight*0.25)+'px';
        iframe.style.height = 'auto';
        
        
        iframe.style.display = 'block'; */

        

    }
} 

class edML_Feedback extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup());
        this.setAttributeWhitelist([]);
        this.setRequiredAttribute([]);
        this.setRequiredTag([]);
        this.setMixedContent(false);
        this.check();
    }


    evaluate(){
        this.querySelectorAll(':scope > edml-decision').forEach(function(item){
            item.decide();
        });
    }
}
class edML_Figureblock extends edML_Tag{

    static countPictures = new Object();
    static countTables = new Object();
    static countVideo = new Object();
    static countCodelisting = new Object();
    static countMiscellaneous = new Object();

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup().concat(["caption"]));
        this.setAttributeWhitelist(["name","tags","numbered"]);
        this.setMixedContent(false);
        this.setOnlyOnceTag(["caption"]);
        this.check();
        this.counter = null;

        var numbered = edMLPlayer_Config.get('figureblock.numbered');
        if(this.getAttribute('numbered') != null && this.getAttribute('numbered') == "false") numbered = false;
        this.numbered = numbered;

        if(edML_Figureblock.countPictures[this.closest('edml-variant').getAttribute('lang')] == null) {
            edML_Figureblock.countPictures[this.closest('edml-variant').getAttribute('lang')] = 0;
        }
        if(edML_Figureblock.countTables[this.closest('edml-variant').getAttribute('lang')] == null) {
            edML_Figureblock.countTables[this.closest('edml-variant').getAttribute('lang')] = 0;
        }
        if(edML_Figureblock.countVideo[this.closest('edml-variant').getAttribute('lang')] == null) {
            edML_Figureblock.countVideo[this.closest('edml-variant').getAttribute('lang')] = 0;
        }
        if(edML_Figureblock.countCodelisting[this.closest('edml-variant').getAttribute('lang')] == null) {
            edML_Figureblock.countCodelisting[this.closest('edml-variant').getAttribute('lang')] = 0;
        }
        if(edML_Figureblock.countMiscellaneous[this.closest('edml-variant').getAttribute('lang')] == null) {
            edML_Figureblock.countMiscellaneous[this.closest('edml-variant').getAttribute('lang')] = 0;
        }

        if(numbered){
            if(this.querySelector('edml-video') != null && this.querySelector('edml-video').closest('edml-figureblock') == this){
                edML_Figureblock.countVideo[this.closest('edml-variant').getAttribute('lang')]++;
                this.counter = edML_Figureblock.countVideo[this.closest('edml-variant').getAttribute('lang')];
                this.type = "video";
            } else if(this.querySelector('edml-picture') != null && this.querySelector('edml-picture').closest('edml-figureblock') == this){
                edML_Figureblock.countPictures[this.closest('edml-variant').getAttribute('lang')]++;
                this.counter = edML_Figureblock.countPictures[this.closest('edml-variant').getAttribute('lang')];
                this.type = "pic";
            } else if(this.querySelector('edml-tables') != null && this.querySelector('edml-table').closest('edml-figureblock') == this){
                edML_Figureblock.countTables[this.closest('edml-variant').getAttribute('lang')]++;
                this.counter = edML_Figureblock.countTables[this.closest('edml-variant').getAttribute('lang')];
                this.type = "table";
            } else if(this.querySelector('edml-codelisting') != null && this.querySelector('edml-codelisting').closest('edml-figureblock') == this){
                edML_Figureblock.countCodelisting[this.closest('edml-variant').getAttribute('lang')]++;
                this.counter = edML_Figureblock.countCodelisting[this.closest('edml-variant').getAttribute('lang')];
                this.type = "code";
            } else {
                edML_Figureblock.countMiscellaneous[this.closest('edml-variant').getAttribute('lang')]++;
                this.counter = edML_Figureblock.countMiscellaneous[this.closest('edml-variant').getAttribute('lang')];
                this.type = "misc";
            }

            
            if(numbered && this.querySelector(':scope > edml-caption') == null){
                var caption = new edML_Caption();
                caption.classList.add('edml-autonode');
                this.append(caption);
            }
        }
    }

    isNumbered(){
        return this.numbered;
    }

    getCount(){
        return this.counter;
    }

    getType(){
        return this.type;
    }
}
class edML_Flex extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["flexitem"]);
        this.setRequiredTag(["flexitem"]);                                         
        this.setAttributeWhitelist(["name","tags","flexdirection","flexwrap","justifycontent","alignitems","aligncontent","rowgap","columngap"]);
        this.setMixedContent(false);
        this.check();

        //set attribute values
        if(this.getAttribute('rowgap') != null) this.style.rowGap = this.getAttribute('rowgap');
        if(this.getAttribute('columngap') != null) this.style.columnGap = this.getAttribute('columngap');
    }
    

    attributeChangedCallback(){
        //set attribute values
        if(this.getAttribute('rowgap') != null) this.style.rowGap = this.getAttribute('rowgap');
        if(this.getAttribute('columngap') != null) this.style.columnGap = this.getAttribute('columngap');
        
    }

    static get observedAttributes() {         
        return ['rowgap', 'columngap'];
    } 
        

}
class edML_Flexitem extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup());
        this.setAttributeWhitelist(["name","tags","order","flexgrow","flexshrink","flexbasis","alignself","minwidth","maxwidth"]);
        this.setMixedContent(false);
        this.check();
    }

    attributeChangedCallback(){
        //set attribute values
        if(this.getAttribute('order') != null) this.style.order = this.getAttribute('order');
        if(this.getAttribute('flexgrow') != null) this.style.flexGrow = this.getAttribute('flexgrow');
        if(this.getAttribute('flexshrink') != null) this.style.flexShrink = this.getAttribute('flexshrink');
        if(this.getAttribute('alignself') != null) this.style.alignSelf = this.getAttribute('alignself');
        if(this.getAttribute('minwidth') != null) this.style.minWidth = this.getAttribute('minwidth');
        if(this.getAttribute('maxwidth') != null) this.style.maxWidth = this.getAttribute('maxwidth');
    }

    static get observedAttributes() {         
        return ["order","flexgrow","flexshrink","flexbasis","alignself","minwidth","maxwidth"];
    } 

}
class edML_Flipcardview extends edML_View{

    constructor(){
        super();    
        this.setTagWhitelist(edML_Groups.getContainerGroup().concat(['title']));
        this.setAttributeWhitelist(["label","name","tags"]);    
        this.setOnlyOnceTag(["title"]);
        this.setMixedContent(false);
        
   
        this.check();

        var dogear = document.createElement('div');
        dogear.classList.add('edml-flipcardview-dogear');
        this.append(dogear);

        dogear.addEventListener('click',this.flip.bind(this));

        /*var flipbtn = document.createElement('div');
        flipbtn.classList.add('edml-flipcardview-btn');
        this.append(flipbtn);*/

    }

    connectedCallback(){

    }

    flip(){
        this.classList.toggle("flipped");        
    }
}
class edML_Formulabox extends edML_Box{

    constructor(container){
        super(); 
        this.setTagWhitelist(edML_Groups.getBlockGroup().concat(["title","parameter","parametergroup","enumerator","descriptor","subtitle"]));
        this.setAttributeWhitelist(["name","label","subtype","tags","numbered"]);
        this.setOnlyOnceTag(["title","descriptor","enumerator","subtitle"]);
        this.setMixedContent(false);
        this.setRemoveContentByClass(["edml-autotitle","edml-autodescriptor"]);
        this.check();  
        
        if(this.querySelector(':scope > edml-title') == null){  // for compatiblity
            if(this.querySelector(':scope > edml-descriptor') == null){
                var descr = document.edmllocale.get('formulabox.descriptor',this.closest('edml-variant').getAttribute('lang'));
                if(this.getAttribute('subtype') != null){  
                    if(document.edmllocale.get('formulabox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang')) != null){
                        descr = document.edmllocale.get('formulabox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang'));
                    } 
                }

                let descriptor = new edML_Descriptor(descr);
                descriptor.classList.add('edml-autodescriptor');
                this.prepend(descriptor);
            }

            if(this.querySelector(':scope > edml-enumerator') == null && (this.getAttribute('numbered') == "true" || (this.getAttribute('numbered') == null && edMLPlayer_Config.get('box.formulabox.numbered') == true))){ 
                let enumerator = new edML_Enumerator();
                enumerator.classList.add('edml-autoenumerator');
                enumerator.classList.add('edml-formulabox-numbering');
                this.prepend(enumerator);
            }


            this.orderTitle();
            
        }
        
    }
}
class edML_Frame extends edML_Tag{

    constructor(container){
        super(); 
        this.setTagWhitelist(edML_Groups.getBlockGroup());
        this.setAttributeWhitelist(["name","tags"]);
        this.setMixedContent(false);
        this.setRemoveContentByClass([]);
        this.check();  
    }

    refresh(){
        document.querySelectorAll('edml-decision').forEach(function(item){
            item.decide();
        });
    }
}
class edML_Groupview extends edML_View{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getContainerGroup().concat(["title"]));
        this.setAttributeWhitelist(["label","name","tags","difficulty"]);
        this.setMixedContent(false);
        this.setOnlyOnceTag(["title"]); 

        this.titlenode = null;
        let autotitle = false;
        
        if(!this.parentNode instanceof edML_Page && !this.parentNode instanceof edML_Groupview && this.querySelector(':scope > edml-title') == null){            
            let title = new edML_Title();
            this.prepend(title);
            autotitle = "true";
        }

      
        //if difficulty exists && > 0 --> title must exists
        let difficulty = 0;
        if(this.getAttribute('difficulty') != null) difficulty = parseInt(this.getAttribute('difficulty'));
        if(difficulty != NaN && difficulty > 0){
            if(this.querySelector(':scope > edml-title') == null){
                let title = new edML_Title();
                this.prepend(title);
                autotitle = "true";
            }
        }
                           

        this.check();

        if(this.parentNode instanceof edML_Accordionview){
            let title = this.querySelector(':scope > edml-title');                
                
            title.addEventListener('click',function(){
                if(!this.classList.contains('show')){                    
                    this.parentNode.querySelectorAll('edml-groupview.show').forEach(function(gview){
                        gview.classList.remove('show');
                    });
                }
                
                
                this.classList.toggle('show');
            }.bind(this));
        }
        
        
       

    }



    
}
class edML_Headrow extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["cell"]);
        this.setRequiredTag(["cell"]);
        this.setAttributeWhitelist(["name","tags","valign","minheight","fixed"]);
        this.setMixedContent(false);  
        this.setRequiredAttribute([]);
        this.setRemoveContentByClass([]);   
        this.check(); 

        //not working with css
        if(this.getAttribute('minheight')){
            this.style.height = this.getAttribute('minheight');
            
        }

        //other --> css

     
        
    }



    
} 
class edML_Help extends edML_Tag{

    constructor(){
        super();        
        this.setTagWhitelist(["step","title"]);
        this.setAttributeWhitelist(["name","tags","open"]);  
        this.setMixedContent(false);
        this.setRequiredTag(["step"]);
        this.setRemoveContentByClass(["edml-helpheader"]);
        this.check();
        this.edml = this.innerHTML;
        
        //create button
        let button = document.createElement('span');
        button.classList.add("edml-help-button");        

        //individual title?
        if(this.querySelector(':scope > edml-title') == null){
            button.innerText = document.edmllocale.get("helpbtntitle",this.closest('edml-variant').getAttribute('lang'));
        } else {
            button.innerHTML = this.querySelector(':scope > edml-title').innerHTML;
        }

        //add listener
        button.addEventListener('click',function(){
            this.querySelector('.edml-help-text').classList.toggle('show');
        }.bind(this));
        
        
        let text = document.createElement('span');
        text.classList = "edml-help-text";            
        text.innerHTML = this.innerHTML;
        
        this.innerHTML = "";
        this.append(text);
        this.to = null;

        if(this.querySelector('edml-step') != null) this.querySelector('edml-step').classList.add('active');
        
        if(this.querySelectorAll(':scope edml-step').length > 1){
            this.header = document.createElement('div');
            this.header.classList.add('edml-helpheader');
            let headertext = document.createElement('span');
            headertext.classList.add('edml-helpheadertext');
            headertext.innerText = "1/" + this.querySelectorAll(':scope edml-step').length;
            
            let buttonprev = document.createElement('span');
            buttonprev.classList.add('edml-helpheaderprev');
            
            let buttonnext = document.createElement('span');
            buttonnext.classList.add('edml-helpheadernext');
            buttonnext.classList.add('active');
            
            
            this.header.append(buttonprev);
            this.header.append(headertext);
            this.header.append(buttonnext);                               
            
            buttonnext.addEventListener('click',function(){
                let el = this.closest('edml-help').querySelector('edml-step.active');
                el.classList.remove('active');
                let nextel = el.nextElementSibling;
                while(nextel != null && nextel.nodeName.toLowerCase() != "edml-step"){
                    nextel = nextel.nextElementSibling;    
                }
                if(nextel != null){
                    nextel.classList.add('active');
                    let nextnext = nextel.nextElementSibling;
                    while(nextnext != null && nextnext.nodeName.toLowerCase() != "edml-step"){
                        nextnext = nextnext.nextElementSibling;
                    }
                    if(nextnext == null){
                        this.header.querySelector('.edml-helpheadernext').classList.remove('active');
                    }
                }
                this.header.querySelector('.edml-helpheaderprev').classList.add('active');
                
                
                let nb = 1;
                let sel = this.querySelector('edml-step');
                while(sel != nextel){
                    if(sel.nodeName.toLowerCase() == 'edml-step') nb++;
                    sel = sel.nextElementSibling;
                }
                this.querySelector('.edml-helpheadertext').innerText = nb + "/" + this.querySelectorAll(':scope edml-step').length;
            }.bind(this));
            
            
            buttonprev.addEventListener('click',function(){
                let el = this.closest('edml-help').querySelector('edml-step.active');
                el.classList.remove('active');
                let prevel = el.previousElementSibling;
                while(prevel != null && prevel.nodeName.toLowerCase() != "edml-step"){
                    prevel = prevel.previousElementSibling;
                }
                if(prevel != null){
                    prevel.classList.add('active');
                    let prevprev = prevel.previousElementSibling;
                    while(prevprev != null && prevprev.nodeName.toLowerCase() != "edml-step"){
                        prevprev = prevprev.previousElementSibling;
                    }
                    if(prevprev == null){
                        this.header.querySelector('.edml-helpheaderprev').classList.remove('active');
                    }
                }
                this.header.querySelector('.edml-helpheadernext').classList.add('active');


                let nb = 1;
                let sel = this.querySelector('edml-step');
                while(sel != prevel){
                    if(sel.nodeName.toLowerCase() == 'edml-step') nb++;
                    sel = sel.nextElementSibling;
                }
                this.querySelector('.edml-helpheadertext').innerText = nb + "/" + this.querySelectorAll(':scope edml-step').length;
            }.bind(this));
            
            text.prepend(this.header);
        } 
        
        
        this.prepend(button);    

        if(this.getAttribute("open") == "true"){
            button.click();
        }
    
    }
    
    //override
    getEdML(){    
        
        let edml = "";
        if(this.querySelector('edml-title') != null) edml = this.querySelector('edml-title').getEdML();
        this.querySelectorAll('edml-step').forEach(function(item){
            edml += item.getEdML();
        });


        let attr = "";
        let attrs = this.getAttributeWhitelist();
        for(let i = 0; i < attrs.length; i++){
            if(this.getAttribute(attrs[i]) != null) attr += ' '+attrs[i]+'="' + this.getAttribute(attrs[i]) + '"';
        }
        edml = '<help'+attr+'>'+edml+'</help>';
        return edml;  
        
    }
    
}
class edML_Helpbox extends edML_Box{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup().concat(["paramter","title","parametergroup","enumerator","descriptor","subtitle"]));
        this.setAttributeWhitelist(["name","label","subtype","tags","numbered"]);
        this.setOnlyOnceTag(["title","descriptor","enumerator","subtitle"]);
        this.setMixedContent(false);
        this.setRemoveContentByClass(["edml-autotitle","edml-autodescriptor"]);
        this.check();
        
        if(this.querySelector(':scope > edml-title') == null){  // for compatiblity
            if(this.querySelector(':scope > edml-descriptor') == null){
                var descr = document.edmllocale.get('helpbox.descriptor',this.closest('edml-variant').getAttribute('lang'));
                if(this.getAttribute('subtype') != null){  
                    if(document.edmllocale.get('helpbox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang')) != null){
                        descr = document.edmllocale.get('helpbox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang'));
                    } 
                }

                let descriptor = new edML_Descriptor(descr);
                descriptor.classList.add('edml-autodescriptor');
                this.prepend(descriptor);
            }

            if(this.querySelector(':scope > edml-enumerator') == null && (this.getAttribute('numbered') == "true" || (this.getAttribute('numbered') == null && edMLPlayer_Config.get('box.helpbox.numbered') == true))){ 
                let enumerator = new edML_Enumerator();
                enumerator.classList.add('edml-autoenumerator');
                enumerator.classList.add('edml-helpbox-numbering');
                this.prepend(enumerator);
            }


            this.orderTitle();
            
        }
    }
}
class edML_Hint extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getInlineGroup());
        this.setAttributeWhitelist(["name","tags"]);
        this.setMixedContent(true);
        this.check();

        //this.setAttribute('role','tooltip');
        //this.setAttribute('aria-label',document.edmllocale.get('access_hint'));
        if(edMLPlayer_Config.get("access.level") == 2){
            this.innerHTML = '<b>'+document.edmllocale.get('access_hint')+ ":</b>" + this.innerHTML;
        }
    }


}
class edML_Hintbox extends edML_Box{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup().concat(["title","parameter","parametergroup","enumerator","descriptor","subtitle"]));
        this.setAttributeWhitelist(["name","label","subtype","tags","numbered"]);
        this.setOnlyOnceTag(["title","descriptor","enumerator","subtitle"]);
        this.setMixedContent(false);
        this.setRemoveContentByClass(["edml-autotitle","edml-autodescriptor"]);
        this.check();
        
        if(this.querySelector(':scope > edml-title') == null){  // for compatiblity
            if(this.querySelector(':scope > edml-descriptor') == null){
                var descr = document.edmllocale.get('hintbox.descriptor',this.closest('edml-variant').getAttribute('lang'));
                if(this.getAttribute('subtype') != null){  
                    if(document.edmllocale.get('hintbox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang')) != null){
                        descr = document.edmllocale.get('hintbox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang'));
                    } 
                }

                let descriptor = new edML_Descriptor(descr);
                descriptor.classList.add('edml-autodescriptor');
                this.prepend(descriptor);
            }

            if(this.querySelector(':scope > edml-enumerator') == null && (this.getAttribute('numbered') == "true" || (this.getAttribute('numbered') == null && edMLPlayer_Config.get('box.hintbox.numbered') == true))){ 
                let enumerator = new edML_Enumerator();
                enumerator.classList.add('edml-autoenumerator');
                enumerator.classList.add('edml-hintbox-numbering');
                this.prepend(enumerator);
            }


            this.orderTitle();
            
        }
    }
}
class edML_Info extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getInlineGroup());
        this.setAttributeWhitelist(["name","tags"]);
        this.setMixedContent(true);
        this.check();
    }


}
class edML_Infobox extends edML_Box{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup().concat(['title',"parameter","parametergroup","enumerator","descriptor","subtitle"]));
        this.setAttributeWhitelist(["name","label","subtype","tags","numbered"]);
        this.setOnlyOnceTag(["title","descriptor","enumerator","subtitle"]);
        this.setMixedContent(false);        
        this.setRemoveContentByClass(["edml-autotitle","edml-autodescriptor"]);
        this.check();


        

    
        
       /* if(this.querySelector('edml-title') == null){
            let title = document.createElement('edml-title');
            
            if(this.getAttribute('label') != null) {
                title.innerText = this.getAttribute('label');
            } else {
                      
                if(this.getAttribute('subtype') != null){                    
                    if(document.edmllocale.get('infobox.subtypes.' + this.getAttribute('subtype')) != null){
                        title.innerHTML = document.edmllocale.get('infobox.subtypes.' + this.getAttribute('subtype')) + '<span class="edml-infobox-numbering"></span>';
                    } else {
                        title.innerHTML = document.edmllocale.get('infobox.title') + '<span class="edml-infobox-numbering"></span>';
                    }
                } else {
                    title.innerHTML = document.edmllocale.get('infobox.title') + '<span class="edml-infobox-numbering"></span>';
                }
            }
            title.classList.add('edml-autotitle');
            this.prepend(title);      
          
        }*/


            if(this.querySelector(':scope > edml-title') == null){  // for compatiblity
                if(this.querySelector(':scope > edml-descriptor') == null){
                    var descr = document.edmllocale.get('infobox.descriptor',this.closest('edml-variant').getAttribute('lang'));
                    if(this.getAttribute('subtype') != null){  
                        if(document.edmllocale.get('infobox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang')) != null){
                            descr = document.edmllocale.get('infobox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang'));
                        } 
                    }
    
                    let descriptor = new edML_Descriptor(descr);
                    descriptor.classList.add('edml-autodescriptor');
                    this.prepend(descriptor);
                }
    
                if(this.querySelector(':scope > edml-enumerator') == null && (this.getAttribute('numbered') == "true" || (this.getAttribute('numbered') == null && edMLPlayer_Config.get('box.infobox.numbered') == true))){ 
                    let enumerator = new edML_Enumerator();
                    enumerator.classList.add('edml-autoenumerator');
                    enumerator.classList.add('edml-infobox-numbering');
                    this.prepend(enumerator);
                }

                this.orderTitle();
            }
    }
    

}
class edML_Initialcode extends edML_Tag{
    constructor(){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist([]);
        this.setMixedContent(true);  
        this.check(); 
    }

    connectedCallback(){
        this.style.display = "none";
    }

}
class edML_Interaction extends edML_Tag{

    constructor(container){
        super(); 
        this.setTagWhitelist(["frame"]);
        this.setAttributeWhitelist(["name","tags"]);
        this.setMixedContent(false);
        this.setRemoveContentByClass([]);
        this.check();  

       
    }

    connectedCallback(){
        if(this.querySelector('edml-frame') != null) this.querySelector('edml-frame').classList.add('show');
    }
}
class edML_Input extends edML_Tag{

    static timer = null;

    constructor(value){
        super();
        this.setTagWhitelist(["affinespace","linearspan","string","boolean","choice","number","exponential","expression","set","vector","matrix","interval","unit","quantity","molecular"]);
        this.setRequiredTag([["affinespace","linearspan","string","boolean","choice","number","exponential","expression","set","vector","matrix","interval","unit","quantity","molecular"]]); // string or boolean or ...
        this.setAttributeWhitelist(["name","tags","penalty","model","width","reveal","check"]);
        this.setMixedContent(false);
        if(value != null) this.append(value);
        this.check();
        this.model = null;
        if(this.getAttribute('model') != null){
            this.model = edMLPlayer_Functions.getModel(this.getAttribute('model').trim());
        }

        if(this.model == null) {
            this.model = edMLPlayer_Functions.getDefaultModel();
        } 

        this.lastCredits = 0;
        this.attempt = 0;

        let counter = edMLPlayer_Config.get('player.inputcounter');        
        counter++;
        this.setAttribute('inputcounter',counter);
        edMLPlayer_Config.set('player.inputcounter',counter);
       
        
    }

    connectedCallback(){ 
        this.specialcheck();


        let firstChild = null;
        let i = 0;
        while(i < this.childNodes.length && firstChild == null ){
            if(this.childNodes[i] instanceof edML_Inputvalue) firstChild = this.childNodes[i];
            i++;
        }    


        if(firstChild != null) {
            this.classList.add('edmlinput-' + firstChild.nodeName.toLowerCase().replace('edml-',''));
        } else {
            console.log(this);
        }

        
            
        

    }

    specialcheck(){
        if(this.querySelector(':scope > edml-interval') != null){
            //check if first and second nodetype of all solutions are identical
            let obj = this;
            let nodename = this.querySelector(':scope > edml-interval > *:first-child').nodeName;
            this.querySelectorAll(':scope > edml-interval > *:first-child').forEach(function(item){
                if(item.nodeName != nodename){
                    edML_Error.push("0012",obj.getEdML(),item.getEdML());
                    edML_Error.printLast(); 
                }
            });

            nodename = this.querySelector(':scope > edml-interval > *:nth-child(2)').nodeName;
            this.querySelectorAll(':scope > edml-interval > *:nth-child(2)').forEach(function(item){
                if(item.nodeName != nodename){
                    edML_Error.push("0012",obj.getEdML(),item.getEdML());
                    edML_Error.printLast(); 
                }
            });
        }
    }


    
    getMaxPenalty(){
        let firstChild = null;
        let i = 0;
        while(i < this.childNodes.length && firstChild == null){
            if(this.childNodes[i] instanceof edML_Inputvalue) firstChild = this.childNodes[i];
            i++;
        }    
        let val = firstChild.getSubmodel().penalty; // standard penalty from specific model
        
        if(this.getAttribute('penalty') != null){
            val = parseInt(this.getAttribute('penalty'));  //penalty from attribute
        } else if(this.closest('edml-booleangroup') != null){
            val = 1;
            if(this.closest('edml-booleangroup').getAttribute('penalty') != null){
                val = parseInt(this.closest('edml-booleangroup').getAttribute('penalty'));
            }
        }
        return val;
    }
    
    getMaxCredits(){
        let val = 0;
        var nodeName = null;

        for(let i = 0; i < this.childNodes.length; i++){
            if(this.childNodes[i] instanceof edML_Inputvalue && this.childNodes[i].getCredits() > val) {
                val = this.childNodes[i].getCredits();             
                if(nodeName == null) nodeName = this.childNodes[i].nodeName;
            } 
        }

        // unused input elements in poolview must not be counted if poolview has no refresh button
        if(this.closest('edml-poolview') != null && (this.closest('edml-poolview').getAttribute('allowrefresh') != "true" && this.closest('edml-poolview').getAttribute('allowrefresh') != "1")){
            	if(this.closest('.unused') != null && this.closest('edml-poolview').contains(this.closest('.unused'))){
                    val = 0;
                }
        }        
        
        return val;
    }

    getUserCredits(){
        return this.lastCredits;
    }

    clear(){
        this.removeAttribute('solved');        
        for(let i = 0; i < this.childNodes.length; i++){
            if(this.childNodes[i] instanceof edML_Inputvalue) {
                this.childNodes[i].clear();             
            } 
        }
    }

    getStateObject(){
        var obj = new Object();
        if(this.getAttribute('solved') == 'true') {
            obj.solved = true;
        } else obj.solved = false;
        if(this.getAttempts('solved') == null){
            obj.solved = null;
        }

        if(this.getAttribute('achievedcredits') != null) {
            obj.credits = parseInt(this.getAttribute('achievedcredits'));
        } else obj.credits = 0;

        obj.value = this.getStateValue();

        obj.type = this.querySelector(':scope > *').nodeName.toLowerCase().replace('edml-','');

        switch(obj.type){
            case "expression": obj.valuemode = "string"; break;
            case "string": obj.valuemode = "string"; break;
            case "molecular": obj.valuemode = "string"; break;
            case "sourcecode": obj.valuemode = "string"; break;
            case "unit": obj.valuemode = "string"; break;

            default: 
                obj.valuemode = "algebraic";
        }
        
        

        return obj;
    }


    addAttempt(){
        this.attempt++;
    }

    getAttempts(){
        return this.attempt;
    }

    /*reveal(solvedobj){
        let result = "";
        if(solvedobj.solved == false){
            this.attempt++;
            let firstChild = null;
            let i = 0;
            while(i < this.childNodes.length && firstChild == null){
                if(this.childNodes[i] instanceof edML_Inputvalue) firstChild = this.childNodes[i];
                i++;
            } 
            let revealnb = firstChild.getModel().reveal;
            if(this.getAttribute("reveal") != null) revealnb = parseInt(this.getAttribute("reveal"));

            if(this.attempt >= revealnb){
                result = '<div class="edml-dialog-head edml-dialog-link" inputcounter="' + this.getAttribute('inputcounter') + '">' + document.edmllocale.get('dialog.reveal.solution') + "</div>";
                result += firstChild.reveal();
                result += "<p><br/></p>";
                
            }
        }

        return result;   
    }*/

    checkSolutionhint(solvedobj){
        if(this.getAttribute('name') != null && this.closest('edml-variant').querySelector('edml-solutionhint[to="'+this.getAttribute('name')+'"]') != null){
            this.attempt++;
            let firstChild = null;
            let i = 0;
            while(i < this.childNodes.length && firstChild == null){
                if(this.childNodes[i] instanceof edML_Inputvalue) firstChild = this.childNodes[i];
                i++;
            } 
            let reveal = firstChild.getSubmodel().reveal;
            if(this.getAttribute("reveal") != null && !isNaN(parseInt(this.getAttribute("reveal")))) reveal = parseInt(this.getAttribute("reveal"));                       
            if(solvedobj.solved != true && reveal <= this.attempt && firstChild.showSolutionhint != null) firstChild.showSolutionhint();
        }
    }
    

    /** normally overrided */
    verify(){
        //console.log(this.model);
        /*let firstchild = this.firstChild;
        while(!(firstchild instanceof edML_Inputvalue) && firstchild != null){
            firstchild = firstchild.nextElementSibling;
        }
        if(firstchild instanceof edML_Inputvalue) {
            let result = firstchild.verify();             
            if((result.solved != null && result.solved == true || result == true)) {
                this.setAttribute('solved','true'); 
            } else {                
                this.setAttribute('solved','false');
            }
            return result;
        }  else {
            let resultobj = new Object();
            resultobj.solved = false;
            resultobj.solution = null;
            return resultobj;

        }*/
        let resultobj = new Object();
        resultobj.solved = false;
        resultobj.solution = null;
        resultobj.credits = -1;
        resultobj.penalty = -1;
    

        let check;
        let value = null;
        let originalvalue = null;
        for(let i = 0; i < this.childNodes.length; i++){
            if(this.childNodes[i] instanceof edML_Inputvalue){
                if(value == null) {
                    value = this.childNodes[i].getValue(); // get it from first one
                    if(this.childNodes[i].getDecimalValue != null) {  // number input --> decimal value is reference 
                        value = this.childNodes[i].getDecimalValue();
                        originalvalue = this.childNodes[i].getValue();
                    }
                    resultobj.penalty = this.childNodes[i].getSubmodel().penalty; // penalty is always same
                }
                if(originalvalue != null) {
                    check = this.childNodes[i].verify(value,null,originalvalue);
                } else {
                    check = this.childNodes[i].verify(value,null);
                }
                if(check.solved == true){
                    resultobj.solved = true;
                    resultobj.solution = this.childNodes[i];
                    if(check.credits > resultobj.credits){
                        resultobj.credits = check.credits;                    
                    }
                   
                }
                
                
                if(this.childNodes[i] instanceof edML_Boolean){
                    resultobj.checked = check.checked;
                }

                if(this.childNodes[i] instanceof edML_Set){
                    if(check.solved == false){
                        if(check.credits > resultobj.credits){
                            resultobj.credits = check.credits;                    
                        } 
                    }
                    resultobj.isSet = true;
                }
            }

            
        }
        
        if(resultobj.solved == false){    // calculate penalty             
            if(resultobj.isSet != true) resultobj.credits = 0; 
            this.setAttribute('solved','false');
            if(this.getAttribute('penalty') != null){
                resultobj.penalty = parseInt(this.getAttribute('penalty'));                
            } else if(this.closest('edml-booleangroup') != null){
                resultobj.penalty = 1;
                if(this.closest('edml-booleangroup').getAttribute('penalty') != null){
                    resultobj.penalty = parseInt(this.closest('edml-booleangroup').getAttribute('penalty'));
                }
            }
        } else {
            this.setAttribute('solved','true'); 
            resultobj.penalty = 0; 
        }

        return resultobj;
        
    }

    checkShowCheckButton(){
        if(this.closest('edml-variant') != null && this.closest('edml-variant').querySelector('edml-test.active') == null){
            let result = false;
            for(let i = 0; i < this.childNodes.length; i++){
                if(this.childNodes[i].checkShowCheckButton != null && this.childNodes[i].checkShowCheckButton()){
                    result = true;
                }
            }
            return result;
        } else return false;
    }
   

    /** maybe be overrided, normaly not */
    evaluateCredits(result){   // result: object of solvedobj   take care of credits in respect to result
        let node = null;
        var n = 0;
        while(node == null && n < this.childNodes.length){
            if(this.childNodes[n] instanceof edML_Inputvalue){
                node = this.childNodes[n];
            }
            n++;
        }

        if(node instanceof edML_Set){

            if(result != null) {
                let val = result.credits - result.penalty;            
                if(val < this.getMaxPenalty()){
                    val = this.getMaxPenalty();
                } 
                if(val > this.getMaxCredits()){
                    val = this.getMaxCredits();
                } 
                edMLPlayer_Functions.changeCredits(-1 * this.lastCredits, false);
                edMLPlayer_Functions.changeCredits(val, true);                            
                this.setAttribute('achievedcredits',val);
                this.lastCredits = val;
            }
        } else {
        
            if(result != null) {           
                //solutionhint ??
                if(result.solved){
                    edMLPlayer_Functions.changeCredits(-1 * this.lastCredits, false);
                    edMLPlayer_Functions.changeCredits(result.credits, true);                            
                    this.lastCredits = result.credits;
                } else {
                    edMLPlayer_Functions.changeCredits(-1 * this.lastCredits, false);
                    if(this.lastCredits != 0 || result.penalty != 0) {
                        edMLPlayer_Functions.changeCredits(-1 * result.penalty, true);
                    } 
                    this.lastCredits = -1 * result.penalty;
                }
                this.setAttribute('achievedcredits',this.lastCredits);
            } else console.error('result is undefined on credit evaluation (in inputvalue class)');       
        } 
    }  

    save2iDB(result){
        if(edMLPlayer_Config.get("player.indexeddb.enabled") == true){  
            let firstChild = null;
            let i = 0;
            while(i < this.childNodes.length && firstChild == null){
                if(this.childNodes[i] instanceof edML_Inputvalue) firstChild = this.childNodes[i];
                i++;
            }    
            //console.log(this);
            //console.log(result);
            if(firstChild.save2iDB != null) {
                firstChild.save2iDB(result);

            } else {
                //save to indexedDB
                if(edMLPlayer_Config.get("player.indexeddb.enabled") == true && (edMLPlayer_Config.get('player.indexeddb.testonly') != true || document.querySelector('edml-test.active') != null)){  
                    let navitem = this.closest('edml-variant').querySelector('edml-navitem.selected');
                    if(navitem != null) navitem = navitem.getAttribute('name');
                    var name = "";
                    if(this.getAttribute('name') != null){
                        name = this.getAttribute('name');
                    } else {
                        //create name
                        var name = this.closest('edml-page').getAttribute('name').substring(0,500) + "_input";            
                        let found = this.getAttribute('inputcounter');
                        if(found != "" && found != null){
                            while (found.length < 4) found = "0" + found;                
                            name = name + found;
                        } else {
                            name = name + "notfound";
                        }
                    }
        
                    //create DB object and write
                    var obj = new Object();
                    obj.name = name;
                    if(firstChild.getString != null) obj.value = firstChild.getString(); else obj.value = firstChild.getValue();
                    obj.type = "input";
                    obj.subtype = firstChild.nodeName.toLowerCase().replace("edml-","");
                    obj.page = this.closest('edml-page').getAttribute("name");
                    obj.solved = result.solved;
                    obj.credits = result.credits;
                    obj.penalty = result.penalty;
                    obj.timestamp = edMLPlayer_Util.getTimestampNow();
        
                    edML_IndexedDB.write("input",obj);            
                }
            }
        }
    }
    

    save2SCORM(result){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true){  
            let firstChild = null;
            let i = 0;
            while(i < this.childNodes.length && firstChild == null){
                if(this.childNodes[i] instanceof edML_Inputvalue) firstChild = this.childNodes[i];
                i++;
            }    
            //console.log(this);
            //console.log(result);
            if(firstChild.save2SCORM != null) firstChild.save2SCORM(result);
        }
    }

    async initFromiDB(){
        if(!this.classList.contains("initiDB") && edMLPlayer_Config.get("player.scorm.enabled") == false){
            this.classList.add('initiDB');
            let firstChild = null;
            let i = 0;
            while(i < this.childNodes.length && firstChild == null ){
                if(this.childNodes[i] instanceof edML_Inputvalue) firstChild = this.childNodes[i];
                i++;
            }    


            if(firstChild != null) {
                this.classList.add('edmlinput-' + firstChild.nodeName.toLowerCase().replace('edml-',''));
            } else {
                console.log(this);
            }
        

            if(edMLPlayer_Config.get("player.indexeddb.enabled") == true && firstChild.initFromiDB != null){  
            // edMLPlayer_Functions.changeCredits(-this.lastCredits,false);
                await firstChild.initFromiDB();   
                this.lastCredits = firstChild.lastCredits;
            
                this.setAttribute('achievedcredits',this.lastCredits);            
                //edMLPlayer_Functions.changeCredits(parseInt(this.lastCredits), false);               
            } else if(edMLPlayer_Config.get("player.indexeddb.enabled") == true && edMLPlayer_Config.get('player.indexeddb.testonly') != true){
                var name = "";

                if(this.getAttribute('name') == null){
                    //create name
                    name = this.closest('edml-page').getAttribute('name').substring(0,500) + "_input";            
                    let found = this.getAttribute('inputcounter');
                    if(found != "" && found != null){
                        while (found.length < 4) found = "0" + found;                
                        name = name + found;
                    } else {
                        name = name + "notfound";
                    }
                } else {
                    name = this.getAttribute('name');
                }
    
                //read value from db and write value to input element          
                let obj =  await edML_IndexedDB.read('input',name);  
                if(obj != null) {
                    if(obj.value != null) firstChild.setValue(obj.value);
                    if(obj.solved){
                        this.setAttribute('solved','true');                    
                        this.lastCredits = obj.credits;                    
                        
                    } else {
                        this.setAttribute('solved','false');                    
                        this.lastCredits = -obj.penalty;
                    }  
                            
                }                   
                         
                   
                
            }
        }

        
    }
    

    initFromSCORM(entrynb){
        let firstChild = null;
        let i = 0;
        while(i < this.childNodes.length && firstChild == null ){
            if(this.childNodes[i] instanceof edML_Inputvalue) firstChild = this.childNodes[i];
            i++;
        }    


        if(firstChild != null) {
            this.classList.add('edmlinput-' + firstChild.nodeName.toLowerCase().replace('edml-',''));
        } else {
            console.log(this);
        }
    

        if(edMLPlayer_Config.get("player.scorm.enabled") == true && firstChild.initFromSCORM != null){  
            firstChild.initFromSCORM(entrynb);   
            this.setAttribute('achievedcredits',firstChild.lastCredits);
            this.lastCredits = firstChild.lastCredits;
            edMLPlayer_Functions.changeCredits(parseInt(firstChild.lastCredits), false);               
        }

        
    }



    getModel(){
        return this.model;
    }

    setValue(val){       
        this.firstChild.setValue(val);
    }

    getValue(){
        return this.firstChild.getValue();
    }

    getStateValue(){
        if(this.firstChild.getStateValue != null) return this.firstChild.getStateValue(); else return null;
    }

    setDisabled(val){
        if(val == true){
            this.classList.add('disabled');
        } else {
            this.classList.remove('disabled');
        }

    }



    
}
class edML_Inputblock extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["sourcecode","matching","order","reaction"]);
        this.setAttributeWhitelist(["name","tags","penalty","model","align","reveal"]);
        this.setMixedContent(false);
        this.setRequiredTag([["sourcecode","matching","order","reaction"]]);
        this.check();
        this.model = edMLPlayer_Functions.getDefaultModel();


        let counter = edMLPlayer_Config.get('player.inputcounter');        
        counter++;
        this.setAttribute('inputcounter',counter);
        edMLPlayer_Config.set('player.inputcounter',counter);
        this.attempt = 0;
        this.lastCredits = 0;
    }
    
    
    connectedCallback(){ 
        if(this.connected == null){
            this.connected = true;
            let firstchild = this.querySelector(':scope > *');
            if(firstchild != null) {
                this.classList.add('edmlinputblock-' + firstchild.nodeName.toLowerCase().replace('edml-',''));
            } else {
                console.log(this);
            }
        }
    }


    
    getPenalty(){
        let val = this.getAttribute('penalty');
        if(val == null) val = 0;
        return val;
    }

    getMaxPenalty(){
        let firstChild = null;
        let i = 0;
        while(i < this.childNodes.length && firstChild == null){
            if(this.childNodes[i] instanceof edML_Inputvalue) firstChild = this.childNodes[i];
            i++;
        }    
        let val = firstChild.getSubmodel().penalty; // standard penalty from specific model
        
        if(this.getAttribute('penalty') != null){
            val = parseInt(this.getAttribute('penalty'));  //penalty from attribute
        } else if(this.closest('edml-booleangroup') != null){
            val = 1;
            if(this.closest('edml-booleangroup').getAttribute('penalty') != null){
                val = parseInt(this.closest('edml-booleangroup').getAttribute('penalty'));
            }
        }
        return val;
    }
    
    getMaxCredits(){
        let val = 0;
        
        for(let i = 0; i < this.childNodes.length; i++){
            if(this.childNodes[i] instanceof edML_Inputvalue && this.childNodes[i].getCredits() > val) {
                val = this.childNodes[i].getCredits();             
            } 
        }
        
        return val;
    }

    getUserCredits(){
        return this.lastCredits;
    }

    addAttempt(){
        this.attempt++;
    }

    getAttempts(){
        return this.attempt;
    }

    reveal(){
        
    }
    
    verify(){
        let firstchild = this.firstChild;
        while(!(firstchild instanceof edML_Inputvalue) && firstchild != null){
            firstchild = firstchild.nextElementSibling;
        }
        if(firstchild instanceof edML_Inputvalue) {
            let result = firstchild.verify();             
            if(result != null && (result.solved != null && result.solved == true || result == true)) {
                firstchild.setAttribute('solved','true'); 
                this.setAttribute('solved','true');
            } else {
                firstchild.setAttribute('solved','false');            
                this.setAttribute('solved','false');
            }
            return result;
        }  else {
            let resultobj = new Object();
            resultobj.solved = false;
            resultobj.solution = null;
            this.setAttribute('solved','false');
            return resultobj;

        }
        
    }

    evaluateCredits(result){
        let firstchild = this.firstChild;
        while(!(firstchild instanceof edML_Inputvalue) && firstchild != null){
            firstchild = firstchild.nextElementSibling;
        }
        console.log(result);
        if(firstchild instanceof edML_Inputvalue) {
            firstchild.evaluateCredits(result);
        }
        //let index = window.edmlcheckbutton.container.indexOf(this);
        //window.edmlcheckbutton.container.splice(index,1);
    }
    
    



    getModel(){
        return this.model;
    }

    checkSolutionhint(solvedobj){
        if(this.getAttribute('name') != null && this.closest('edml-variant').querySelector('edml-solutionhint[to="'+this.getAttribute('name')+'"]') != null){
            this.attempt++;
            let firstChild = null;
            let i = 0;
            while(i < this.childNodes.length && firstChild == null){
                if(this.childNodes[i] instanceof edML_Inputvalue) firstChild = this.childNodes[i];
                i++;
            } 
            let reveal = parseInt(this.getAttribute("reveal"));
            if(reveal == null) firstChild.getModel().reveal;
            if(solvedobj.solved != true && reveal <= this.attempt && firstChild.showSolutionhint != null) firstChild.showSolutionhint();
        }
    }


 
    save2SCORM(result){
        let firstChild = null;
        let i = 0;
        while(i < this.childNodes.length && firstChild == null ){
            if(this.childNodes[i] instanceof edML_Inputvalue) {
                firstChild = this.childNodes[i];
            }
            i++;
        }         
        firstChild.save2SCORM(result);
    }

    initFromSCORM(entrynb){
       
        let firstChild = null;
        let i = 0;
        while(i < this.childNodes.length && firstChild == null ){
            if(this.childNodes[i] instanceof edML_Inputvalue) firstChild = this.childNodes[i];
            i++;
        }    


        if(firstChild != null) {
            this.classList.add('edmlinput-' + firstChild.nodeName.toLowerCase().replace('edml-',''));
        } else {
            console.log(this);
        }
    

        if(edMLPlayer_Config.get("player.scorm.enabled") == true && firstChild.initFromSCORM != null){  
            firstChild.initFromSCORM(entrynb);   
        }
    }

    setValue(val){       
        this.firstChild.setValue(val);
    }

    getValue(){
        return this.firstChild.getValue();
    }

    setDisabled(val){
        if(val == true){
            this.classList.add('disabled');
        } else {
            this.classList.remove('disabled');
        }
    }

    clear(){
        this.removeAttribute('solved');        
        for(let i = 0; i < this.childNodes.length; i++){
            if(this.childNodes[i] instanceof edML_Inputvalue) {
                this.childNodes[i].clear();             
            } 
        }
    }

    getStateObject(){
        var obj = new Object();
        if(this.getAttribute('solved') == 'true') {
            obj.solved = true;
        } else obj.solved = false;
        if(this.getAttempts('solved') == null){
            obj.solved = null;
        }

        if(this.getAttribute('achievedcredits') != null) {
            obj.credits = parseInt(this.getAttribute('achievedcredits'));
        } else obj.credits = 0;

        obj.type = this.querySelector(':scope > *').nodeName.toLowerCase().replace('edml-','');
        
        return obj;
    }
    
}
class edML_Inputmodel extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["string","order", "matching", "boolean","choice","number","exponential","expression","set","vector","matrix","interval","unit","quantity","molecular","reaction"]);
        this.setAttributeWhitelist(["name"]);
        this.setMixedContent(false);        
        this.check();
        this.inner = this.innerHTML;
        let model;
        if(this.getAttribute('name') == null){
            model = edMLPlayer_Functions.getDefaultModel();
        } else {
            model = edMLPlayer_Functions.getModel(this.getAttribute('name'));
            if(model == null){
                model = new edML_SuperclassModel(this.getAttribute('name'));
                edMLPlayer_Functions.addModel(this.getAttribute('name'),model);            
            }
        }

    

        //number
        let item = this.querySelector(':scope > edml-number');
        if(item != null){
            if(item.getAttribute('base') != null)  {
                model.set('number.base',item.getAttribute('base'));
                model.set('vector.number.base',item.getAttribute('base'));
                model.set('matrix.number.base',item.getAttribute('base'));
                model.set('interval.number.base',item.getAttribute('base'));
                model.set('unit.number.base',item.getAttribute('base'));
                model.set('set.number.base',item.getAttribute('base'));
               //model.set('exponential.mantissa.base',item.getAttribute('base'));
               // model.set('exponential.exponent.base',item.getAttribute('base'));
            }
            if(item.getAttribute('minfracdigits') != null)  {
                model.set('number.minfracdigits',item.getAttribute('minfracdigits'));
                model.set('vector.number.minfracdigits',item.getAttribute('minfracdigits'));
                model.set('matrix.number.minfracdigits',item.getAttribute('minfracdigits'));
                model.set('interval.number.minfracdigits',item.getAttribute('minfracdigits'));
                model.set('unit.number.minfracdigits',item.getAttribute('minfracdigits'));
                model.set('set.number.minfracdigits',item.getAttribute('minfracdigits'));
                //model.set('exponential.mantissa.minfracdigits',item.getAttribute('minfracdigits'));
                //model.set('exponential.exponent.minfracdigits',item.getAttribute('minfracdigits'));
            }
            if(item.getAttribute('maxfracdigits') != null) {
                model.set('number.maxfracdigits',item.getAttribute('maxfracdigits'));
                model.set('vector.number.maxfracdigits',item.getAttribute('maxfracdigits'));
                model.set('matrix.number.maxfracdigits',item.getAttribute('maxfracdigits'));
                model.set('interval.number.maxfracdigits',item.getAttribute('maxfracdigits'));
                model.set('unit.number.maxfracdigits',item.getAttribute('maxfracdigits'));
                model.set('set.number.maxfracdigits',item.getAttribute('maxfracdigits'));
                //model.set('exponential.mantissa.maxfracdigits',item.getAttribute('maxfracdigits'));
                //model.set('exponential.exponent.maxfracdigits',item.getAttribute('maxfracdigits'));
            } 
            if(item.getAttribute('minintdigits') != null) {
                model.set('number.minintdigits',item.getAttribute('minintdigits'));
                model.set('vector.number.minintdigits',item.getAttribute('minintdigits'));
                model.set('matrix.number.minintdigits',item.getAttribute('minintdigits'));
                model.set('interval.number.minintdigits',item.getAttribute('minintdigits'));
                model.set('unit.number.minintdigits',item.getAttribute('minintdigits'));
                model.set('set.number.minintdigits',item.getAttribute('minintdigits'));
               // model.set('exponential.mantissa.minintdigits',item.getAttribute('minintdigits'));
               // model.set('exponential.exponent.minintdigits',item.getAttribute('minintdigits'));
            }
            if(item.getAttribute('maxintdigits') != null) {
                model.set('number.maxintdigits',item.getAttribute('maxintdigits'));
                model.set('vector.number.maxintdigits',item.getAttribute('maxintdigits'));
                model.set('matrix.number.maxintdigits',item.getAttribute('maxintdigits'));
                model.set('interval.number.maxintdigits',item.getAttribute('maxintdigits'));
                model.set('unit.number.maxintdigits',item.getAttribute('maxintdigits'));
                model.set('set.number.maxintdigits',item.getAttribute('maxintdigits'));
                //model.set('exponential.mantissa.maxintdigits',item.getAttribute('maxintdigits'));
                //model.set('exponential.exponent.maxintdigits',item.getAttribute('maxintdigits'));
            }
            if(item.getAttribute('minfracdigitshints') != null) {
                model.set('number.minfracdigitshints',item.getAttribute('minfracdigitshints'));
                model.set('vector.number.minfracdigitshints',item.getAttribute('minfracdigitshints'));
                model.set('matrix.number.minfracdigitshints',item.getAttribute('minfracdigitshints'));
                model.set('interval.number.minfracdigitshints',item.getAttribute('minfracdigitshints'));
                model.set('unit.number.minfracdigitshints',item.getAttribute('minfracdigitshints'));
                model.set('set.number.minfracdigitshints',item.getAttribute('minfracdigitshints'));
                //model.set('exponential.mantissa.minfracdigitshints',item.getAttribute('minfracdigitshints'));
                //model.set('exponential.exponent.minfracdigitshints',item.getAttribute('minfracdigitshints'));
            } 
            if(item.getAttribute('maxfracdigitshints') != null)  {
                model.set('number.maxfracdigitshints',item.getAttribute('maxfracdigitshints'));
                model.set('vector.number.maxfracdigitshints',item.getAttribute('maxfracdigitshints'));
                model.set('matrix.number.maxfracdigitshints',item.getAttribute('maxfracdigitshints'));
                model.set('interval.number.maxfracdigitshints',item.getAttribute('maxfracdigitshints'));
                model.set('unit.number.maxfracdigitshints',item.getAttribute('maxfracdigitshints'));
                model.set('set.number.maxfracdigitshints',item.getAttribute('maxfracdigitshints'));
               // model.set('exponential.mantissa.maxfracdigitshints',item.getAttribute('maxfracdigitshints'));
               // model.set('exponential.exponent.maxfracdigitshints',item.getAttribute('maxfracdigitshints'));
            }
            if(item.getAttribute('minintdigitshints') != null) {
                model.set('number.minintdigitshints',item.getAttribute('minintdigitshints'));
                model.set('vector.number.minintdigitshints',item.getAttribute('minintdigitshints'));
                model.set('matrix.number.minintdigitshints',item.getAttribute('minintdigitshints'));
                model.set('interval.number.minintdigitshints',item.getAttribute('minintdigitshints'));
                model.set('unit.number.minintdigitshints',item.getAttribute('minintdigitshints'));
                model.set('set.number.minintdigitshints',item.getAttribute('minintdigitshints'));
              //  model.set('exponential.mantissa.minintdigitshints',item.getAttribute('minintdigitshints'));
               // model.set('exponential.exponent.minintdigitshints',item.getAttribute('minintdigitshints'));
            }
            
            if(item.getAttribute('maxintdigitshints') != null) {
                model.set('number.maxintdigitshints',item.getAttribute('maxintdigitshints'));
                model.set('vector.number.maxintdigitshints',item.getAttribute('maxintdigitshints'));
                model.set('matrix.number.maxintdigitshints',item.getAttribute('maxintdigitshints'));
                model.set('interval.number.maxintdigitshints',item.getAttribute('maxintdigitshints'));
                model.set('unit.number.maxintdigitshints',item.getAttribute('maxintdigitshints'));
                model.set('set.number.maxintdigitshints',item.getAttribute('maxintdigitshints'));
              //  model.set('exponential.mantissa.maxintdigitshints',item.getAttribute('maxintdigitshints'));
              //  model.set('exponential.exponent.maxintdigitshints',item.getAttribute('maxintdigitshints'));
            } 
            if(item.getAttribute('lowertolerance') != null) {
                model.set('number.lowertolerance',item.getAttribute('lowertolerance'));
                model.set('vector.number.lowertolerance',item.getAttribute('lowertolerance'));
                model.set('matrix.number.lowertolerance',item.getAttribute('lowertolerance'));
                model.set('interval.number.lowertolerance',item.getAttribute('lowertolerance'));
                model.set('unit.number.lowertolerance',item.getAttribute('lowertolerance'));
                model.set('set.number.lowertolerance',item.getAttribute('lowertolerance'));
               // model.set('exponential.mantissa.lowertolerance',item.getAttribute('lowertolerance'));
               // model.set('exponential.exponent.lowertolerance',item.getAttribute('lowertolerance'));
            } 
            if(item.getAttribute('uppertolerance') != null)  {
                model.set('number.uppertolerance',item.getAttribute('uppertolerance'));
                model.set('vector.number.uppertolerance',item.getAttribute('uppertolerance'));
                model.set('matrix.number.uppertolerance',item.getAttribute('uppertolerance'));
                model.set('interval.number.uppertolerance',item.getAttribute('uppertolerance'));
                model.set('unit.number.uppertolerance',item.getAttribute('uppertolerance'));
                model.set('set.number.uppertolerance',item.getAttribute('uppertolerance'));
               // model.set('exponential.mantissa.uppertolerance',item.getAttribute('uppertolerance'));
               // model.set('exponential.exponent.uppertolerance',item.getAttribute('uppertolerance'));
            }
            if(item.getAttribute('lowerreltolerance') != null) {
                model.set('number.lowerreltolerance',item.getAttribute('lowerreltolerance'));
                model.set('vector.number.lowerreltolerance',item.getAttribute('lowerreltolerance'));
                model.set('matrix.number.lowerreltolerance',item.getAttribute('lowerreltolerance'));
                model.set('interval.number.lowerreltolerance',item.getAttribute('lowerreltolerance'));
                model.set('unit.number.lowerreltolerance',item.getAttribute('lowerreltolerance'));
                model.set('set.number.lowerreltolerance',item.getAttribute('lowerreltolerance'));
               // model.set('exponential.mantissa.lowerreltolerance',item.getAttribute('lowerreltolerance'));
               // model.set('exponential.exponent.lowerreltolerance',item.getAttribute('lowerreltolerance'));
            } 
            if(item.getAttribute('upperreltolerance') != null) {
                model.set('number.upperreltolerance',item.getAttribute('upperreltolerance'));
                model.set('vector.number.upperreltolerance',item.getAttribute('upperreltolerance'));
                model.set('matrix.number.upperreltolerance',item.getAttribute('upperreltolerance'));
                model.set('interval.number.upperreltolerance',item.getAttribute('upperreltolerance'));
                model.set('unit.number.upperreltolerance',item.getAttribute('upperreltolerance'));
                model.set('set.number.upperreltolerance',item.getAttribute('upperreltolerance'));
              //  model.set('exponential.mantissa.upperreltolerance',item.getAttribute('upperreltolerance'));
              //  model.set('exponential.exponent.upperreltolerance',item.getAttribute('upperreltolerance'));
            } 

        }

        //exponential
        item = this.querySelector(':scope > edml-exponential');
        if(item != null){
            if(item.getAttribute('base') != null)  {
                model.set('exponential.base',item.getAttribute('base'));                    
            }

            if(item.getAttribute('lowertolerance') != null)  {
                model.set('exponential.lowertolerance',item.getAttribute('lowertolerance'));                    
            }

            if(item.getAttribute('uppertolerance') != null)  {
                model.set('exponential.uppertolerance',item.getAttribute('uppertolerance'));                    
            }

            if(item.getAttribute('lowerreltolerance') != null)  {
                model.set('exponential.lowerreltolerance',item.getAttribute('lowerreltolerance'));                    
            }


            if(item.getAttribute('upperreltolerance') != null)  {
                model.set('exponential.upperreltolerance',item.getAttribute('upperreltolerance'));                    
            }
        }

            //exponential mantissa
        item = this.querySelector(':scope > edml-exponential > edml-mantissa');
        if(item != null){
            if(item.getAttribute('base') != null)  {
                model.set('exponential.mantissa.base',item.getAttribute('base'));                    
            }
            if(item.getAttribute('minfracdigits') != null)  {
                model.set('exponential.mantissa.minfracdigits',item.getAttribute('minfracdigits'));                 
            }
            if(item.getAttribute('maxfracdigits') != null) {
                model.set('exponential.mantissa.maxfracdigits',item.getAttribute('maxfracdigits'));
            } 
            if(item.getAttribute('minintdigits') != null) {
                model.set('exponential.mantissa.minintdigits',item.getAttribute('minintdigits'));            
            }
            if(item.getAttribute('maxintdigits') != null) {
                model.set('exponential.mantissa.maxintdigits',item.getAttribute('maxintdigits'));
            }
            if(item.getAttribute('minfracdigitshints') != null) {
                model.set('exponential.mantissa.minfracdigitshints',item.getAttribute('minfracdigitshints'));                
            } 
            if(item.getAttribute('maxfracdigitshints') != null)  {
                model.set('exponential.mantissa.maxfracdigitshints',item.getAttribute('maxfracdigitshints'));                 
            }
            if(item.getAttribute('minintdigitshints') != null) {
                model.set('exponential.mantissa.minintdigitshints',item.getAttribute('minintdigitshints'));                   
            }
            if(item.getAttribute('maxintdigitshints') != null) {
                model.set('exponential.mantissa.maxintdigitshints',item.getAttribute('maxintdigitshints'));                   
            } 
            if(item.getAttribute('lowertolerance') != null) {
                model.set('exponential.mantissa.lowertolerance',item.getAttribute('lowertolerance'));                   
            } 
            if(item.getAttribute('uppertolerance') != null)  {
                model.set('exponential.mantissa.uppertolerance',item.getAttribute('uppertolerance'));
                
            }
            if(item.getAttribute('lowerreltolerance') != null) {
                model.set('exponential.mantissa.lowerreltolerance',item.getAttribute('lowerreltolerance'));                
            } 
            if(item.getAttribute('upperreltolerance') != null) {
                model.set('exponential.mantissa.upperreltolerance',item.getAttribute('upperreltolerance'));                  
            } 

            
        }
            //exponential exponent
        item = this.querySelector(':scope > edml-exponential > edml-exponent');
        if(item != null){
            if(item.getAttribute('base') != null)  {
                model.set('exponential.exponent.base',item.getAttribute('base'));                    
            }
            if(item.getAttribute('minfracdigits') != null)  {
                model.set('exponential.exponent.minfracdigits',item.getAttribute('minfracdigits'));                 
            }
            if(item.getAttribute('maxfracdigits') != null) {
                model.set('exponential.exponent.maxfracdigits',item.getAttribute('maxfracdigits'));
            } 
            if(item.getAttribute('minintdigits') != null) {
                model.set('exponential.exponent.minintdigits',item.getAttribute('minintdigits'));            
            }
            if(item.getAttribute('maxintdigits') != null) {
                model.set('exponential.exponent.maxintdigits',item.getAttribute('maxintdigits'));
            }
            if(item.getAttribute('minfracdigitshints') != null) {
                model.set('exponential.exponent.minfracdigitshints',item.getAttribute('minfracdigitshints'));                
            } 
            if(item.getAttribute('maxfracdigitshints') != null)  {
                model.set('exponential.exponent.maxfracdigitshints',item.getAttribute('maxfracdigitshints'));                 
            }
            if(item.getAttribute('minintdigitshints') != null) {
                model.set('exponential.exponent.minintdigitshints',item.getAttribute('minintdigitshints'));                   
            }
            if(item.getAttribute('maxintdigitshints') != null) {
                model.set('exponential.exponent.maxintdigitshints',item.getAttribute('maxintdigitshints'));                   
            } 
            if(item.getAttribute('lowertolerance') != null) {
                model.set('exponential.exponent.lowertolerance',item.getAttribute('lowertolerance'));                   
            } 
            if(item.getAttribute('uppertolerance') != null)  {
                model.set('exponential.exponent.uppertolerance',item.getAttribute('uppertolerance'));
                
            }
            if(item.getAttribute('lowerreltolerance') != null) {
                model.set('exponential.exponent.lowerreltolerance',item.getAttribute('lowerreltolerance'));                
            } 
            if(item.getAttribute('upperreltolerance') != null) {
                model.set('exponential.exponent.upperreltolerance',item.getAttribute('upperreltolerance'));                  
            } 

            
        }

        //unit
        item = this.querySelector(':scope > edml-unit');
        if(item != null){
            if(item.getAttribute('useonly') != null)  {
                model.set('unit.useonly',item.getAttribute('useonly'));                   
            }

            if(item.getAttribute('usenot') != null)  {
                model.set('unit.usenot',item.getAttribute('usenot'));                   
            }

            if(item.getAttribute('prefixes') != null)  {
                model.set('unit.prefixes',item.getAttribute('prefixes'));                   
            }

            if(item.getAttribute('useonlyhints') != null)  {
                model.set('unit.useonlyhints',item.getAttribute('useonlyhints'));                   
            }

            if(item.getAttribute('usenothints') != null)  {
                model.set('unit.usenothints',item.getAttribute('usenothints'));                   
            }

            if(item.getAttribute('prefixeshints') != null)  {
                model.set('unit.prefixeshints',item.getAttribute('prefixeshints'));                   
            }

            if(item.getAttribute('preferexact') != null)  {
                model.set('unit.preferexact',item.getAttribute('preferexact'));                   
            }
            
        }

        //string
        item = this.querySelector(':scope > edml-string');
        if(item != null){
            if(item.getAttribute('cloze') != null)  {
                model.set('string.cloze',item.getAttribute('cloze'));                   
            }

            if(item.getAttribute('characters') != null)  {
                model.set('string.characters',item.getAttribute('characters'));                   
            }

            if(item.getAttribute('minlength') != null)  {
                model.set('string.minlength',item.getAttribute('minlength'));                   
            }

            if(item.getAttribute('maxlength') != null)  {
                model.set('string.maxlength',item.getAttribute('maxlength'));                   
            }

            if(item.getAttribute('casesensitive') != null)  {
                model.set('string.casesensitive',item.getAttribute('casesensitive'));                   
            }

            if(item.getAttribute('charactershints') != null)  {
                model.set('string.charactershints',item.getAttribute('charactershints'));                   
            }

            if(item.getAttribute('minlengthhints') != null)  {
                model.set('string.minlengthhints',item.getAttribute('minlengthhints'));                   
            }

            if(item.getAttribute('maxlengthhints') != null)  {
                model.set('string.maxlengthhints',item.getAttribute('maxlengthhints'));                   
            }

            if(item.getAttribute('trim') != null)  {
                model.set('string.trim',item.getAttribute('trim'));                   
            }
            
        }


        //choice
        item = this.querySelector(':scope > edml-choice');
        if(item != null){
            if(item.getAttribute('shuffle') != null)  {
                model.set('choice.shuffle',item.getAttribute('shuffle'));                   
            }
        }

            
        
        this.innerHTML = "";
    }

    getEdML(){
        let edml = this.inner.replace('edml-','');
        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 
        return '<inputmodel'+attr+'>' + edml + '</inputmodel>';

    }
}
class edML_Inputmodels extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["inputmodel"]);        
        this.setAttributeWhitelist([]);
        this.setMixedContent(false);        
        this.check();

    }
}
class edML_Interval extends edML_Inputvalue{

    constructor(type){
        super();
        this.setTagWhitelist(["number","expression"]);        
        this.setAttributeWhitelist(["credits","model","fixclosure","closure"]);
        this.setRequiredAttribute([]);
        this.setMixedContent(false);        
        if([...this.querySelectorAll('edml-number,edml-expression')].length == 0 && type!=null){
            if(type instanceof edML_Expression){
                this.append(new edML_Expression());
                this.append(new edML_Expression());
            } else if(type instanceof edML_Number){
                this.append(new edML_Number());
                this.append(new edML_Number());
            }
        }
        
        
        this.check();        

        this.lastCredits = 0;

        
        



    }

    connectedCallback(){
        
        if(!this.classList.contains('rendered')){
            this.classList.add('rendered');
        
            if(this.querySelector(':scope > edml-number, :scope > edml-expression') == null){
                let number = new edML_Number();
                this.append(number);
            }

            if(this.querySelectorAll(':scope > edml-number, :scope > edml-expression').length < 2){
                let number02 = new edML_Number();
                this.append(number02);
            }

            let model = this.closest("edml-input").getModel().getSubmodel("interval"); 
            let fixclosure = model.fixclosure;     
            if(this.getAttribute('fixclosure') != null &&  (this.getAttribute('fixclosure') == "true" || this.getAttribute('fixclosure') == "1")) fixclosure = true;

            let solution =  model.closure;
            if(['closed','closedopen','open','openclosed'].includes(this.getAttribute('closure'))) {
                solution = this.getAttribute('closure');
                this.setAttribute('closure','');
            }

            
            let leftclosure = document.createElement('span');
            leftclosure.classList.add('edml-interval-leftclosure');
            
            if(fixclosure == true) {
                leftclosure.classList.add('disabled');
                if(solution == 'closedopen' || solution == 'closed') {
                    leftclosure.classList.add('closed');
                    leftclosure.innerText = model.leftclosed;
                } else {
                    leftclosure.innerText = model.leftopen;
                }
            } else {
                leftclosure.addEventListener('click',this.toggleClosureLeft.bind(this));
                leftclosure.classList.add('closed');
                leftclosure.innerText = model.leftclosed;
            }
            
            this.prepend(leftclosure);

            


            let rightclosure = document.createElement('span');
            rightclosure.classList.add('edml-interval-rightclosure');
            
            if(fixclosure == true) {
                rightclosure.classList.add('disabled');  
                if(solution == 'openclosed' || solution == 'closed') {
                    rightclosure.classList.add('closed');      
                    rightclosure.innerText = model.rightclosed;
                } else {
                    rightclosure.innerText = model.rightopen;
                }
            } else {
                rightclosure.addEventListener('click',this.toggleClosureRight.bind(this));
                rightclosure.classList.add('closed');
                rightclosure.innerText = model.rightclosed;
            }
            
            this.append(rightclosure);

            


            let separator = document.createElement('span');
            separator.classList.add('edml-interval-separator');
            separator.classList.add('closed');
            separator.innerText = model.separator;
            this.insertBefore(separator,this.querySelector(':scope > edml-number, :scope > edml-expression').nextElementSibling);

            
            this.left = this.querySelector(':scope > edml-number, :scope > edml-expression');
            this.right = this.querySelectorAll(':scope > edml-number, :scope > edml-expression')[1];


            this.key = new Uint8Array(32);
            for(let i =  0; i < 32; i++){
                this.key[i] = Math.floor(Math.random()*Number.MAX_SAFE_INTEGER);
            }
        
            
            if(solution != null){
            // if(solution == "") solution = "none";                 
                let textBytes = aesjs.utils.utf8.toBytes(solution);            
                let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
                let encryptedBytes = aesCtr.encrypt(textBytes); 
                let encryptedHex = aesjs.utils.hex.fromBytes(encryptedBytes);
                this.solution = encryptedHex;
                this.removeAttribute('closed');
            }
        }
    }

    toggleClosureLeft(evt){        
        let model = this.closest("edml-input").getModel().getSubmodel("interval"); 
        if(this.querySelector(':scope > .edml-interval-leftclosure').classList.contains('closed')){
            this.querySelector(':scope > .edml-interval-leftclosure').classList.remove('closed');
            this.querySelector(':scope > .edml-interval-leftclosure').innerText = model.leftopen;
        } else {
            this.querySelector(':scope > .edml-interval-leftclosure').classList.add('closed');
            this.querySelector(':scope > .edml-interval-leftclosure').innerText = model.leftclosed;
        }
        this.onCheck(evt); 
    
    }


    toggleClosureRight(evt){        
        let model = this.closest("edml-input").getModel().getSubmodel("interval"); 
        if(this.querySelector(':scope > .edml-interval-rightclosure').classList.contains('closed')){
            this.querySelector(':scope > .edml-interval-rightclosure').classList.remove('closed');
            this.querySelector(':scope > .edml-interval-rightclosure').innerText = model.rightopen;
        } else {
            this.querySelector(':scope > .edml-interval-rightclosure').classList.add('closed');
            this.querySelector(':scope > .edml-interval-rightclosure').innerText = model.rightclosed;
        }
        this.onCheck(evt); 
    }

    verify(value,model){
        if(model == null) model = this.getSubmodel();
        let solvedobj = new Object();
        solvedobj.solved = false;
        solvedobj.solution = null;
       
        if(this.getAttribute('credits') != null && !isNaN(parseInt(this.getAttribute('credits')))) {
            solvedobj.credits = parseInt(this.getAttribute('credits'));
         } else {
            solvedobj.credits = model.credits;
        }

        let left;
        let right;
        let result;
       

        if(value != null && value.length == 3){
            result = value[2];
            left = value[0];
            right = value[1];
        } else {
            result = "open";
            if(this.querySelector('.edml-interval-leftclosure.closed') == null && this.querySelector('.edml-interval-rightclosure.closed') != null) result = "openclosed";
            if(this.querySelector('.edml-interval-leftclosure.closed') != null && this.querySelector('.edml-interval-rightclosure.closed') == null) result = "closedopen";
            if(this.querySelector('.edml-interval-leftclosure.closed') != null && this.querySelector('.edml-interval-rightclosure.closed') != null) result = "closed";

            left = this.querySelector(':scope > edml-number, :scope > edml-expression').getDecimalValue();
            right = this.querySelectorAll(':scope > edml-number, :scope > edml-expression')[1].getDecimalValue();
        } 

        let inputarr = [...this.querySelectorAll(':scope > edml-number,:scope > edml-expression')];
        let checkleft = inputarr[0].verify(left).solved;
        let checkright = inputarr[1].verify(right).solved;

        //console.log(result + " " + left + " " + right + " " + checkleft + " " + checkright);

        if(checkleft && checkright && this.solution != ""){    
            let encryptedBytes = aesjs.utils.hex.toBytes(this.solution);
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let decryptedBytes = aesCtr.decrypt(encryptedBytes);
            let decryptedText = aesjs.utils.utf8.fromBytes(decryptedBytes); 
            let solution = decryptedText; 
            console.log(result + "  " +solution);

            if(result == solution) {
                solvedobj.solved = true;
            } else {
                solvedobj.solved = false;
            }
        }
        
        return solvedobj;
    }

    checkShowCheckButton(){
        let okay = this.left.checkShowCheckButton() && this.right.checkShowCheckButton(); 
        
        return okay;
    }

    getValue(){
        let arr = new Array();
        let result = "open";
        if(this.querySelector('.edml-interval-leftclosure.closed') == null && this.querySelector('.edml-interval-rightclosure.closed') != null) result = "openclosed";
        if(this.querySelector('.edml-interval-leftclosure.closed') != null && this.querySelector('.edml-interval-rightclosure.closed') == null) result = "closedopen";
        if(this.querySelector('.edml-interval-leftclosure.closed') != null && this.querySelector('.edml-interval-rightclosure.closed') != null) result = "closed";

        let left = this.querySelector(':scope > edml-number, :scope > edml-expression').getValue();
        let right = this.querySelectorAll(':scope > edml-number, :scope > edml-expression')[1].getValue();

        arr.push(left);
        arr.push(right);
        arr.push(result);
        return arr;
    }

    getString(){
        return JSON.stringify(this.getValue());
    }

    getDecimalValue(){
        let arr = new Array();
        let result = "open";
        if(this.querySelector('.edml-interval-leftclosure.closed') == null && this.querySelector('.edml-interval-rightclosure.closed') != null) result = "openclosed";
        if(this.querySelector('.edml-interval-leftclosure.closed') != null && this.querySelector('.edml-interval-rightclosure.closed') == null) result = "closedopen";
        if(this.querySelector('.edml-interval-leftclosure.closed') != null && this.querySelector('.edml-interval-rightclosure.closed') != null) result = "closed";

        let left = this.querySelector(':scope > edml-number, :scope > edml-expression').getDecimalValue();
        let right = this.querySelectorAll(':scope > edml-number, :scope > edml-expression')[1].getDecimalValue();

        arr.push(left);
        arr.push(right);
        arr.push(result);
        return arr;
    }
    
   

    getEdML(){
        let text = "";
        for(let i = 0; i < this.childNodes.length; i++){
            if(this.childNodes[i] instanceof edML_Tag){
                text += this.childNodes[i].getEdML();
            }
        }

        let solution = "";        
        if(this.solution != "" && this.solution != null){
            let encryptedBytes = aesjs.utils.hex.toBytes(this.solution);
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let decryptedBytes = aesCtr.decrypt(encryptedBytes);
            solution = aesjs.utils.utf8.fromBytes(decryptedBytes); 
        }     
        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttributeWhitelist()[i] == "closure" && this.getAttribute('closure') != null) {
                attr += ' closure="' + solution+'"';
            } else if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 

        

        

        return '<interval'+attr+'>' + text + '</interval>';
    }

    save2SCORM(result){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true && (edMLPlayer_Config.get('player.scorm.testonly') != true || document.querySelector('edml-test.active') != null)){  
            let navitem = this.closest('edml-variant').querySelector('edml-navitem.selected');
            if(navitem != null) navitem = navitem.getAttribute('name');   
            console.log(JSON.stringify(this.getValue()));      
            let exercisename = edML_SCORM.saveInputObjective(result,this.closest('edml-input'),JSON.stringify(this.getValue()));
            console.log(exercisename);
            edML_SCORM.saveInteraction(this.closest('edml-page').getAttribute("name"),"other","input: interval",navitem,exercisename,null);
        }
    }

    initFromSCORM(entrynb){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true){
            //let input = this.querySelector(':scope > .edml-expression-input');
            //if(input != null) input.value = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.description');           
            let val = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.description'); 
            if(val != null) val = JSON.parse(val);
            if(val.length == 3){            
                let model = this.closest("edml-input").getModel().getSubmodel("interval"); 
                
                this.querySelector(':scope > edml-number, :scope > edml-expression').setValue(val[0]);
                [...this.querySelectorAll(':scope > edml-number, :scope > edml-expression')][1].setValue(val[1]);
                if(val[2] == "open"){
                    this.querySelector('.edml-interval-leftclosure').classList.remove('closed');
                    this.querySelector(':scope > .edml-interval-leftclosure').innerText = model.leftopen;
                    this.querySelector('.edml-interval-rightclosure').classList.remove('closed');
                    this.querySelector(':scope > .edml-interval-rightclosure').innerText = model.rightopen;
                } else if(val[2] == "openclosed"){
                    this.querySelector('.edml-interval-leftclosure').classList.remove('closed');
                    this.querySelector(':scope > .edml-interval-leftclosure').innerText = model.leftopen;
                    this.querySelector('.edml-interval-rightclosure').classList.add('closed');
                    this.querySelector(':scope > .edml-interval-rightclosure').innerText = model.rightclosed;
                } else if(val[2] == "closedopen"){
                    this.querySelector('.edml-interval-leftclosure').classList.add('closed');
                    this.querySelector(':scope > .edml-interval-leftclosure').innerText = model.leftclosed;
                    this.querySelector('.edml-interval-rightclosure').classList.remove('closed');
                    this.querySelector(':scope > .edml-interval-rightclosure').innerText = model.rightopen;
                } else if(val[2] == "closed"){
                    this.querySelector('.edml-interval-leftclosure').classList.add('closed');
                    this.querySelector(':scope > .edml-interval-leftclosure').innerText = model.leftclosed;
                    this.querySelector('.edml-interval-rightclosure').classList.add('closed');
                    this.querySelector(':scope > .edml-interval-rightclosure').innerText = model.rightclosed;
                }
    
            }
        

            if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "failed"){
                this.closest('edml-input').setAttribute('solved','false');
            } else if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "passed"){
                this.closest('edml-input').setAttribute('solved','true');
            }

            edMLPlayer_Functions.changeCredits(-this.lastCredits,false);
            this.lastCredits = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.score.raw');
        }
    }

    clear(){
        let model = this.closest("edml-input").getModel().getSubmodel("interval"); 
        this.removeAttribute('solved');
        this.querySelector('.edml-interval-rightclosure').classList.add('closed');
        this.querySelector('.edml-interval-leftclosure').classList.add('closed');
        this.querySelector('.edml-interval-leftclosure').innerText = model.leftclosed;
        this.querySelector('.edml-interval-rightclosure').innerText = model.rightclosed;
    }

    setValue(val){
        if(!Array.isArray(val)) val = JSON.parse(val);

        if(Array.isArray(val) && val.length == 3){
            let model = this.closest("edml-input").getModel().getSubmodel("interval"); 
            if(val[2] == "open"){
                this.querySelector('.edml-interval-leftclosure').classList.remove("closed");
                this.querySelector('.edml-interval-rightclosure').classList.remove("closed"); 
                this.querySelector('.edml-interval-leftclosure').innerText = model.leftopen;
                this.querySelector('.edml-interval-rightclosure').innerText = model.rightopen;                
            } else if(val[2] == "openclosed"){
                this.querySelector('.edml-interval-leftclosure').classList.remove("closed");
                this.querySelector('.edml-interval-rightclosure').classList.add("closed");  
                this.querySelector('.edml-interval-leftclosure').innerText = model.leftopen;
                this.querySelector('.edml-interval-rightclosure').innerText = model.rightclosed;               
            } else if(val[2] == "closedopen"){
                this.querySelector('.edml-interval-leftclosure').classList.add("closed");
                this.querySelector('.edml-interval-rightclosure').classList.remove("closed");  
                this.querySelector('.edml-interval-leftclosure').innerText = model.leftclosed;
                this.querySelector('.edml-interval-rightclosure').innerText = model.rightopen;                
            } else if(val[2] == "closed"){
                this.querySelector('.edml-interval-leftclosure').classList.add("closed");
                this.querySelector('.edml-interval-rightclosure').classList.add("closed");   
                this.querySelector('.edml-interval-leftclosure').innerText = model.leftclosed;
                this.querySelector('.edml-interval-rightclosure').innerText = model.rightclosed;               
            }
           
            this.querySelector(':scope > edml-number, :scope > edml-expression').setValue(val[0]);
            this.querySelectorAll(':scope > edml-number, :scope > edml-expression')[1].setValue(val[1]);
        }
    }
}
class edML_Item extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getInlineBlockGroup());
        this.setAttributeWhitelist([]);
        this.setMixedContent(true);
        this.check();


       

       
    }

    

    

    

   



}
class edML_Label extends edML_Tag{

    constructor(){
        super();
        let arr = edML_Groups.getInlineGroup();
        arr.splice(edML_Groups.getInlineGroup().indexOf('label'),1);
        this.setTagWhitelist(arr);
        this.setAttributeWhitelist(['for',"name","tags"]);
        this.setMixedContent(true);
        this.setRequiredAttribute(["for"]);
        this.check();             

        this.addEventListener('click',function(){
            if(this.closest('edml-variant').querySelector('edml-input[name="'+this.getAttribute('for')+'"] > edml-boolean') != null) {
                this.closest('edml-variant').querySelector('edml-input[name="'+this.getAttribute('for')+'"] > edml-boolean').click();
            }
        }.bind(this));
    }


}
class edML_License extends edML_Tag{

    constructor(container){
        super(); 
        this.setTagWhitelist([]);
        this.setAttributeWhitelist(["url"]);
        this.setMixedContent(true);
        this.check();  
    }
}
class edML_Linearspan extends edML_Inputvalue{

    constructor(){
        super();
        this.setTagWhitelist(['vector']);
        this.setAttributeWhitelist(['maxvectorcount','minvectorcount','basis','model','normed','orthogonal',"fixed"]);
        this.setMixedContent(false); 
        this.setRequiredAttribute([]);
        this.setRequiredTag(['vector']);
        this.setOnlyOnceTag([]);
        this.check();

        

        this.addEventListener('vectorchange',this.onVectorChange.bind(this));

        var solution = new Array();
        var matches = [...this.innerHTML.matchAll(/<edml-vector>(.*?)<\/edml-vector>/gms)];
        for(var i = 0; i < matches.length; i++){
            var vector = new Array();
            var m = [...matches[i][1].matchAll(/<(edml-number|edml-expression)>(.*?)<\/(edml-number|edml-expression)>/gms)];
            for(var j = 0; j < m.length; j++){
                vector.push(m[j][2]);
            }
            this.vlen = m.length;
            solution.push(vector);
        }
        this.key = new Uint8Array(32);
        for(let i =  0; i < 32; i++){
            this.key[i] = Math.floor(Math.random()*Number.MAX_SAFE_INTEGER);
        }       

        this.solution = "";
        if(solution != null){                             
            let textBytes = aesjs.utils.utf8.toBytes(JSON.stringify(solution));            
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let encryptedBytes = aesCtr.encrypt(textBytes); 
            let encryptedHex = aesjs.utils.hex.fromBytes(encryptedBytes);
            this.solution = encryptedHex;
        }
        

    }


    connectedCallback(){
        if(this.connected == null) {
            this.connected = true;
            this.size = [...this.querySelectorAll(':scope > edml-vector')].length;           
            this.showlen = 0;
            let model = this.getSubmodel();

            var maxlen = model.maxvectorcount;
            if(this.getAttribute('maxvectorcount') != null) {
                if(this.getAttribute('maxvectorcount') == "unbounded" ) {
                    maxlen = Infinity;
                } else if(!isNaN(parseInt(this.getAttribute('maxvectorcount')))){
                    maxlen = Math.abs(parseInt(this.getAttribute('maxvectorcount')));
                }
            } 
            
            var minlen = model.minvectorcount;
            if(this.getAttribute('minvectorcount') != null) {
                if(!isNaN(parseInt(this.getAttribute('minvectorcount')))){
                    minlen = Math.abs(parseInt(this.getAttribute('minvectorcount')));
                }
            } 

            if(minlen == maxlen){
                this.fixedvectorcount = true;
            } else this.fixedvectorcount = false;

            this.fixed = model.fixed;
            if(this.getAttribute('fixed') == false || this.getAttribute('fixed') == 0){
                this.fixed = false;
            } else if(this.getAttribute('fixed') == true || this.getAttribute('fixed') == 1){
                this.fixed = true;
            }
            

            //hide elements
            var counter = 0;
            this.querySelectorAll(':scope > edml-vector').forEach(function(item){
                if(counter >= minlen) {
                    item.classList.add('hidden');
                } else {
                    this.showlen++;
                }
                item.classList.add('edml-linearspan-element');
                counter++;
            }.bind(this));

            
            var emptybtn = document.createElement('span');
            emptybtn.classList.add('edml-linearspan-emptybtn');
            emptybtn.classList.add('hidden');
            this.prepend(emptybtn);

            if(!this.fixedvectorcount){
                var removebtn = document.createElement('span');
                removebtn.classList.add('edml-linearspan-removebtn');
                this.prepend(removebtn);
            }

            var leftsymbol = document.createElement('span');
            
            leftsymbol.setAttribute("type",model.leftsymbol);
            leftsymbol.classList.add('edml-linearspan-leftsymbol');
            this.prepend(leftsymbol);

            var lefttext = document.createElement('div');
            lefttext.innerText = model.lefttext;
            lefttext.classList.add('edml-linearspan-lefttext');
            this.prepend(lefttext);

            if(!this.fixedvectorcount){
                var addbtn = document.createElement('span');
                addbtn.classList.add('edml-linearspan-addbtn');
                this.append(addbtn);
            }

            var rightsymbol = document.createElement('span');
            rightsymbol.setAttribute('type',model.rightsymbol);
            rightsymbol.classList.add('edml-linearspan-rightsymbol');
            this.append(rightsymbol);


            //events
            emptybtn.addEventListener('click',this.onEmptyLinearspan.bind(this));

            if(!this.fixedvectorcount){
                addbtn.addEventListener('click',this.onAddVector.bind(this));
                removebtn.addEventListener('click',this.onRemoveVector.bind(this));
                if(this.showlen >=maxlen){
                    this.querySelector(':scope > .edml-linearspan-addbtn').classList.remove('active');
                } else {
                    this.querySelector(':scope > .edml-linearspan-addbtn').classList.add('active');
                }
        
                if(this.showlen > minlen){
                    this.querySelector(':scope > .edml-linearspan-removebtn').classList.add('active');
                } else {
                    this.querySelector(':scope > .edml-linearspan-removebtn').classList.remove('active');
                }
            }
                                

            if(this.showlen == 0){
                this.querySelector(':scope > .edml-linearspan-emptybtn').classList.remove('hidden');
            } else {
                this.querySelector(':scope > .edml-linearspan-emptybtn').classList.add('hidden');
            }

            if(this.fixed){                    
                this.reposition(this.vlen);
                setTimeout(function(){
                    this.querySelectorAll('edml-vector').forEach(function(item){                    
                        let el = item;
                        for(var i = 0; i < this.vlen-item.getLength(); i++){                                                                 
                            el.addElement(false);                 
                        }
                        item.classList.add('hiddenbuttons');
                    }.bind(this));
                }.bind(this),100);
            } else {
                this.reposition(1);
            }

            

           

        }
    }

    onEmptyLinearspan(){
        this.querySelector(':scope > .edml-linearspan-emptybtn').classList.toggle('active');
        if(this.querySelector(':scope > .edml-linearspan-emptybtn').classList.contains('active')){
            this.querySelector(':scope > .edml-linearspan-addbtn').classList.add('hidden');   
            this.querySelector(':scope > .edml-linearspan-removebtn').classList.add('hidden');               
            this.closest('edml-input').removeAttribute('solved');
            this.removeAttribute('solved');
            this.onCheck();
            
            
        } else {
            this.querySelector(':scope > .edml-linearspan-addbtn').classList.remove('hidden');   
            this.querySelector(':scope > .edml-linearspan-removebtn').classList.remove('hidden');            
            edMLPlayer_Functions.hideCheckButton();     
            if(edMLPlayer_Functions.getTimer() != null) {
                clearTimeout(edMLPlayer_Functions.getTimer());
                edMLPlayer_Functions.setTimer(null);                        
            }
            this.closest('edml-input').removeAttribute('solved');
            this.removeAttribute('solved');
        }
    }

    onAddVector(){ 
        this.closest('edml-input').removeAttribute('solved');
        var maxlen = this.getSubmodel().maxvectorcount;
        if(this.getAttribute('maxvectorcount') != null) {
            if(this.getAttribute('maxvectorcount') == "unbounded" ) {
                maxlen = Infinity;
            } else if(!isNaN(parseInt(this.getAttribute('maxvectorcount')))){
                maxlen = Math.abs(parseInt(this.getAttribute('maxvectorcount')));
            }
        } 

        if(maxlen == "unbounded") maxlen = Infinity;
        
        var minlen = this.getSubmodel().minvectorcount;
        if(this.getAttribute('minvectorcount') != null) {
            if(!isNaN(parseInt(this.getAttribute('minvectorcount')))){
                minlen = Math.abs(parseInt(this.getAttribute('minvectorcount')));
            }
        } 

        if(this.showlen < maxlen){
            if(this.querySelector(":scope > edml-vector.hidden") != null){
                if(this.showlen > 0){
                    let enumerationsign = document.createElement('span');
                    enumerationsign.innerText = this.getSubmodel().enumerationsign;
                    enumerationsign.classList.add('edml-linearspan-enumerationsign');
                    this.insertBefore(enumerationsign,this.querySelector(":scope > edml-vector.hidden"));
                    
                }
                this.querySelector(":scope > edml-vector.hidden").classList.remove('hidden');
                
            } else {
                var vector = new edML_Vector();
                vector.classList.add('edml-linearspan-element');
                this.insertBefore(vector,this.querySelector(':scope > .edml-linearspan-addbtn'));
                vector.setLength(this.querySelector(':scope > edml-vector').getLength());
                if(this.showlen > 0){
                    let enumerationsign = document.createElement('span');
                    enumerationsign.innerText = this.getSubmodel().enumerationsign;
                    enumerationsign.classList.add('edml-linearspan-enumerationsign');
                    this.insertBefore(enumerationsign,vector);
                }
            }
            this.showlen++;
        }
        
        
        if(this.showlen >=maxlen){
            this.querySelector(':scope > .edml-linearspan-addbtn').classList.remove('active');
        } else {
            this.querySelector(':scope > .edml-linearspan-addbtn').classList.add('active');
        }

        if(this.showlen > minlen){
            this.querySelector(':scope > .edml-linearspan-removebtn').classList.add('active');
        } else {
            this.querySelector(':scope > .edml-linearspan-removebtn').classList.remove('active');
        }

        if(this.showlen == 1){
            this.querySelector(':scope > .edml-linearspan-emptybtn').classList.add('hidden');                             
        }
        
        if(this.fixed){
            this.querySelectorAll('edml-vector').forEach(function(item){                    
                let el = item;
                let len = this.vlen;
                setTimeout(function(){
                    for(var i = 0; i < len-item.getLength(); i++){                                                                 
                        el.addElement(false)   
                    }
                },50);
                item.classList.add('hiddenbuttons')
            }.bind(this));
            this.reposition(this.vlen);
        } else {
            let len = this.querySelector(':scope > edml-vector:not(.hidden)').getLength();
            this.reposition(len);
        }

        
        
    }

    onRemoveVector(){
        this.closest('edml-input').removeAttribute('solved');
        var maxlen = this.getSubmodel().maxvectorcount;
        if(this.getAttribute('maxvectorcount') != null) {
            if(this.getAttribute('maxvectorcount') == "unbounded" ) {
                maxlen = Infinity;
            } else if(!isNaN(parseInt(this.getAttribute('maxvectorcount')))){
                maxlen = Math.abs(parseInt(this.getAttribute('maxvectorcount')));
            }
        } 
        if(maxlen == "unbounded") maxlen = Infinity;
        
        var minlen = this.getSubmodel().minvectorcount;
        if(this.getAttribute('minvectorcount') != null) {
            if(!isNaN(parseInt(this.getAttribute('minvectorcount')))){
                minlen = Math.abs(parseInt(this.getAttribute('minvectorcount')));
            }
        } 

        if(this.showlen > minlen){
            if(this.showlen > 0){
                let elements = [...this.querySelectorAll(":scope > edml-vector:not(.hidden)")];
                elements[elements.length-1].classList.add('hidden');

                if(this.showlen > 1 && [...this.querySelectorAll(':scope > .edml-linearspan-enumerationsign')][(this.showlen-2)] != null) [...this.querySelectorAll(':scope > .edml-linearspan-enumerationsign')][(this.showlen-2)].remove(); 
                this.showlen--;
            }
        }

        if(this.showlen >=maxlen){
            this.querySelector(':scope > .edml-linearspan-addbtn').classList.remove('active');
        } else {
            this.querySelector(':scope > .edml-linearspan-addbtn').classList.add('active');
        }

        if(this.showlen > minlen){
            this.querySelector(':scope > .edml-linearspan-removebtn').classList.add('active');
        } else {
            this.querySelector(':scope > .edml-linearspan-removebtn').classList.remove('active');
        }

        if(this.showlen == 0){
            this.querySelector(':scope > .edml-linearspan-emptybtn').classList.remove('hidden');
            if(this.fixed){
                this.reposition(this.vlen);
            } else {
                this.reposition(0);
            }

        } else {
            this.querySelector(':scope > .edml-linearspan-emptybtn').classList.add('hidden');
        }


    }


    onVectorChange(evt){
        this.closest('edml-input').removeAttribute('solved');
        let len = evt.vector.getLength();
        this.reposition(len);                
    }

    reposition(length){        
        let len = length;
        this.querySelector('.edml-linearspan-leftsymbol').style.transform = "scale(1,"+(1.08*len)+")";
        this.querySelector('.edml-linearspan-rightsymbol').style.transform = "scale(1,"+(1.08*len)+")";

        if(len > 1) {
            this.querySelector('.edml-linearspan-lefttext').style.top = (len-1-len*0.25)+"em"; 
            if(!this.fixedvectorcount){
                this.querySelector('.edml-linearspan-removebtn').style.top = (len-1-len*0.25)+"em"; 
                this.querySelector('.edml-linearspan-addbtn').style.top = (len-1-len*0.25)+"em"; 
            }          
            this.querySelector('.edml-linearspan-emptybtn').style.top = (len-1-len*0.25)+"em";  
            this.querySelectorAll('.edml-linearspan-enumerationsign').forEach(function(item){
                item.style.top = (len-1-len*0.25)+"em"; 
            });
            
        } else {            
            this.querySelector('.edml-linearspan-lefttext').style.top = "0em";
            if(!this.fixedvectorcount){
                this.querySelector('.edml-linearspan-removebtn').style.top = "0em";
                this.querySelector('.edml-linearspan-addbtn').style.top = "0em";
            }
            this.querySelector('.edml-linearspan-emptybtn').style.top = "0em";  
            this.querySelector('.edml-linearspan-leftsymbol').style.transform = "scale(1,1.08)";
            this.querySelector('.edml-linearspan-rightsymbol').style.transform = "scale(1,1.08)";

            this.querySelectorAll('.edml-linearspan-enumerationsign').forEach(function(item){
                item.style.top = "0em"; 
            });
        }

        this.querySelectorAll(':scope > edml-vector').forEach(function(item){
            item.setLength(len);
        });

    }

    getValue(){
        return [...this.querySelectorAll(':scope > .edml-linearspan-element:not(.hidden)')];
    }



    verify(value, model){    
        let resultobj = new Object();
        resultobj.solved = false;
        resultobj.solution = null;
        resultobj.credits = 0;
        if(model == null) model = this.getSubmodel(); 
        
        if(this.getAttribute('credits') != null && !isNaN(parseInt(this.getAttribute('credits')))) {
            resultobj.credits = parseInt(this.getAttribute('credits'));
         } else {
            resultobj.credits = model.credits;
        }

        let vectors = value;
        if(vectors == null) {
            vectors = [...this.querySelectorAll(':scope > .edml-linearspan-element:not(.hidden)')];

        }
        

        let encryptedBytes = aesjs.utils.hex.toBytes(this.solution);
        let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
        let decryptedBytes = aesCtr.decrypt(encryptedBytes);
        let solutiontext = aesjs.utils.utf8.fromBytes(decryptedBytes); 
        var solution = JSON.parse(solutiontext);
        var zeroLinesInput = 0;
        
        if(this.querySelector(':scope > .edml-linearspan-emptybtn.active') != null){
            //check if solution is zero vector
            resultobj.solved = true;
            for(var i = 0; i < solution.length; i++){
                for(var j = 0; j < solution[i].length; j++){
                    if(solution[i][j] != 0) resultobj.solved = false;
                }
            }
            
        } else {
            if(solution[0] != null && vectors[0] != null && vectors[0].getLength() == solution[0].length){      

                //reduced row echelon form solution

                //build array -> vectors are rows
                var solutionEchelon = new Array();
                var bigDec = nerdamer.getCore().bigDec;
                for(var i = 0; i < solution.length; i++){
                    var inner = new Array();
                    for(var j = 0; j < solution[i].length; j++){
                        inner.push(bigDec(solution[i][j]));
                    }
                    solutionEchelon.push(inner);
                }
                
                edML_Linearspan.calculateRowEchelonForm(solutionEchelon);
                


                //reduced row echelon form input && check vectors have values
                var inputMatrix = new Array();
        
                
                var okay = true;
                if(vectors.length > 0) {
                    var valueObjs;
                    
                    for(var i = 0; i < vectors.length; i++){
                        var row = new Array();
                        valueObjs = vectors[i].getValue(); 
                        
                        for(var j = 0; j < valueObjs.length; j++){
                            if(valueObjs[j].getValue() == null || valueObjs[j].getValue() == "") {
                                okay = false;
                                row.push(0);
                            } else {
                                row.push(bigDec(valueObjs[j].getValue()));
                            }                                                        
                        }
                        inputMatrix.push(row);
                    }
                } else okay = false;
                
                if(okay){
                    var inputEchelon = inputMatrix;
                    edML_Linearspan.calculateRowEchelonForm(inputEchelon);
                    

                    //check inputEchelon vs solutionEcholon
                    resultobj.solved = true;
                    this.removeZeroRows(solutionEchelon);
                    zeroLinesInput = this.removeZeroRows(inputEchelon);                

                    if(solutionEchelon.length != inputEchelon.length){
                        resultobj.solved = false;
                    } else {
                        for(var i = 0; i < solutionEchelon.length; i++){
                            for(var j = 0; j < solutionEchelon[i].length; j++){
                                if(!solutionEchelon[i][j].eq(inputEchelon[i][j])){
                                    resultobj.solved = false;
                                }
                            }
                        }
                    }
                }
            } else resultobj.solved = false;
            
            //additional checks
            if(resultobj.solved == true){
                //basis
                var basis = model.basis;
                if(this.getAttribute('basis') == "true" || this.getAttribute('basis') == "1"){
                    basis = true;
                } else if(this.getAttribute('basis') == "false" || this.getAttribute('basis') == "0"){
                    basis = false;
                } 
                if(basis){
                    if(zeroLinesInput != 0) resultobj.solved = false;
                }

                //normed
                var normed = model.normed;
                if(this.getAttribute('normed') == "true" || this.getAttribute('normed') == "1"){
                    normed = true;
                } else if(this.getAttribute('normed') == "false" || this.getAttribute('normed') == "0"){
                    normed = false;
                }
                if(normed){
                    var vlen;
                    for(var n = 0; n < vectors.length; n++){
                        vlen = bigDec(0);                    
                        for(var m =0; m < vectors[n].getLength(); m++){
                            vlen = vlen.add(bigDec(vectors[n].getValue(m)).mul(bigDec(vectors[n].getValue(m))));
                        }
   
                        if(!vlen.eq(1)) resultobj.solved = false;
                    }
                }

                //orthogonal
                var orthogonal = model.orthogonal;
                if(this.getAttribute('orthogonal') == "true" || this.getAttribute('orthogonal') == "1"){
                    orthogonal = true;
                } else if(this.getAttribute('orthogonal') == "false" || this.getAttribute('orthogonal') == "0"){
                    orthogonal = false;
                }

                if(orthogonal){
                    //calculate dot products
                    var ortho = true;
                    for(var i = 0; i < vectors.length-1; i++){
                        for(var j = i+1; j < vectors.length; j++){
                            if(!this.dotproduct(vectors[i].getValue(),vectors[j].getValue()).eq(0)) ortho = false;
                        }
                    }
                    if(!ortho) resultobj.solved = false;
                }
                
                
            }

        }
        
        return resultobj;
    }



    dotproduct(vec1,vec2){        
        var bigDec = nerdamer.getCore().bigDec;
        var val = bigDec(0);
        for(var i = 0; i < vec1.length; i++){
            val = val.add(bigDec(vec1[i].getValue()).mul(bigDec(vec2[i].getValue())));
        }
        return val;
    }


    removeZeroRows(arr){
        if(arr != null){
            var isZero;
            var precision = edMLPlayer_Config.get("defaultmodel.number.precision");
            var toDelete = new Array();
            for(var i = 0; i < arr.length; i++){
                isZero = true;
                for(var j = 0; j < arr[i].length; j++){
                    if(Math.abs(parseFloat(arr[i][j].toString())) > precision){
                        isZero = false;
                    }
                }
                if(isZero){
                    toDelete.push(i);
                }
            }
            
            for(var i = toDelete.length-1; i >= 0; i--){
                arr.splice(toDelete[i],1);
            }
            return toDelete.length;
        } else return 0;       
    }

   

    static logMatrix(arr){
        //help function
        var row = "";
        console.log("---------------");
        for(var i = 0; i < arr.length; i++){
            row = "";
            for(var j = 0; j < arr[i].length; j++){
                row += arr[i][j].toString() + "  ";
            }
            console.log(row);
        }
        console.log("---------------");
    }


    static calculateRowEchelonForm(arr){
        //adapted from pseudo code of rosetta code website
        var lead = 0;
        var i;
        var r = 0;
        var stop;
        while(r < arr.length && arr[r].length > lead){
            i = r;
            stop = false;
            while(!stop && (arr[i][lead]).eq(0)){
                i++;
                if(arr.length == i){
                    i = r;
                    lead++;
                }       
                if(lead == arr[i].length) stop = true;            
            }
            
            if(!stop){               
                //swap rows i and r
                var h = arr[r]; 
                arr[r] = arr[i];
                arr[i] = h; 

                var div = arr[r][lead]
                if(arr[r][lead] != 0) {
                    for(var c = 0; c < arr[r].length; c++){
                        arr[r][c] = arr[r][c].div(div);
                    }
                }

                for(var k = 0; k < arr.length; k++){
                    if(k != r){
                        var factor = arr[k][lead];
                        for(var c = 0; c < arr[r].length; c++){
                            arr[k][c] = arr[k][c].sub((arr[r][c].mul(factor)));
                        }
                    }
                }    
                
                lead++;   
                r++;
            }

        }        
    }
}
class edML_Link extends edML_Inlinegroup{

    constructor(url){
        super();           
        let arr = edML_Groups.getInlineGroup();
        arr.splice(edML_Groups.getInlineGroup().indexOf('link'),1);
        this.setTagWhitelist(arr);
        this.setAttributeWhitelist(["to","name","tags","markexternal"]);
        this.setRequiredAttribute(["to"]);
        this.setMixedContent(true);  
        if(url != null){
            this.setAttribute('to',url);
        }
        
        this.check();
        
        this.classList.add('edml-ref');
        this.setAttribute('type','link');
        this.setAttribute('role','link');
        this.setAttribute('aria-label',this.innerText+ " " + document.edmllocale.get('access_link'));
        this.setAttribute('tabindex',5);
        
        this.addEventListener('click',function(){
            let link = document.createElement('a');
            link.setAttribute('href',this.getAttribute('to'));
            link.setAttribute('target',"_blank");            
            link.click();
            link.remove();    
        });
    
    }
    

    
}
class edML_List extends edML_Tag{

    static formatValues = ["arabic","bullet","dash","dot","greek","letter","Letter","none","roman","Roman"];
    static arrletter = ["a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"];
    static arrLetter = ["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];
    static arrgreek = ["α","β","γ","δ","ε","ζ","η","θ","ι","κ","λ","μ","ν","ξ","ο","π","ρ","σ","τ","υ","φ","χ","ψ","ω"];
    static arrGreek = ["Α","Β","Γ","Δ","Ε","Ζ","Η","Θ","Ι","Κ","Λ","Μ","Ν","Ξ","Ο","Π","Ρ","Σ","Τ","Υ","Φ","Χ","Ψ","Ω"];

    constructor(){
        super();
        this.setTagWhitelist(["listitem"]);
        this.setAttributeWhitelist(["name","format","separator","lastsep","indent","fullnumbering","tags"]);
        this.setRequiredTag(["listitem"]);
        this.setMixedContent(false);      
        this.check();
        this.connected = false;

         //inheritance of attributes
        if(this.getAttribute('lastsep') == null && this.closest('edml-list[lastsep]') != null){
            this.setAttribute('lastsep',this.closest('edml-list[lastsep]').getAttribute('lastsep'));
        }

        if(this.getAttribute('separator') == null && this.closest('edml-list[separator]') != null){
            this.setAttribute('separator',this.closest('edml-list[separator]').getAttribute('separator'));
        }

        if(this.getAttribute('fullnumbering') == null && this.closest('edml-list[fullnumbering]') != null){
            this.setAttribute('fullnumbering',this.closest('edml-list[fullnumbering]').getAttribute('fullnumbering'));
        }

        if(this.getAttribute('format') == null && this.closest('edml-list[format]') != null){
            this.setAttribute('format',this.closest('edml-list[format]').getAttribute('format'));
        }

        if(this.getAttribute('indent') == null && this.closest('edml-list[indent]') != null){
            this.setAttribute('indent',this.closest('edml-list[indent]').getAttribute('indent'));
        }
        
    }

    connectedCallback(){
        //generate numbering first time only
        if(this.connected == false) {
           

            this.numberList();
            this.connected = true;         
        }
        if(this.closest('edml-page') != null && this.closest('edml-page').classList.contains('active')){
            setTimeout(function(){this.setIndent();}.bind(this),100);
        }
        

    }

   setIndent(){

        //calculate indent (x space) and height (y space)
        let indent = 0;

        this.forceVisible();
        
        

        this.querySelectorAll(':scope > edml-listitem > .edml-listitem-label').forEach(function(item){
            item.style.display = "inline";
            if(indent < item.offsetWidth) indent = item.offsetWidth;
            //console.log(item.offsetWidth);
            item.style.display = "block";
        });
        


    // indent += 0.5*edMLPlayer_Config.get('player.em2px');
        //console.log(indent);

        // with indent second, third ... line
        this.querySelectorAll(':scope > edml-listitem > *:not(.edml-listitem-label)').forEach(function(item){
            item.style.marginLeft = indent + "px";
        });

        if(this.getAttribute('indent') != null && this.getAttribute('indent') != "auto"){
            this.style.marginLeft = this.getAttribute('indent');
        }
            
    
        //this.redoForceVisible();


        // vertical alignment
        this.querySelectorAll(':scope > edml-listitem').forEach(async function(item){

            if(item.childNodes[1] instanceof edML_P){
              /*  //let normalLineHeight = parseFloat(getComputedStyle(item).getPropertyValue('line-height').replace('px',''));                
                console.log("NORMAL");
                let normalLineHeight = edMLPlayer_Util.getLineHeight(item.childNodes[1]);    
                await edMLPlayer_Util.typesetMath(item);
                console.log("WITH MATH");
                let lineHeight = edMLPlayer_Util.getLineHeight(item.childNodes[1]);                
                lineHeight = normalLineHeight + 2 * (lineHeight - normalLineHeight);
                console.log("***");
                console.log(item);
                console.log(normalLineHeight);
                console.log(lineHeight);
                console.log("***");
                item.querySelector(':scope > .edml-listitem-label').style.lineHeight = "" + (lineHeight) + "px";*/
                await edMLPlayer_Util.typesetMath(item);
                let defaultheight = parseFloat(getComputedStyle(item).getPropertyValue('line-height'));
                //console.log(getComputedStyle(item).getPropertyValue('line-height'));
                //first textnode
                //let lineHeight = edMLPlayer_Util.getBaselineHeight(item);
                let it = item;
                window.setTimeout(function(){it.querySelector(':scope > .edml-listitem-label').style.top = "" + (edMLPlayer_Util.getLineHeight(it.childNodes[1],defaultheight)) + "px";}.bind(this),300); //buffer time needed for Mathjax & Co.
                
            }

            window.setTimeout(function(){this.redoForceVisible();}.bind(this),350);
        }.bind(this));

            
        


        //let itemrect = item.getBoundingClientRect();
            
        //let lineheight = parseFloat(getComputedStyle(item).getPropertyValue('line-height').replace('px',''));
        //item.querySelector(':scope > .edml-listitem-label').style.lineHeight = "" + (lineheight+(rect.top-itemrect.top)) + "px";

        //without indent
        /*
        this.querySelectorAll(':scope > edml-listitem > *:not(.edml-listitem-label)').forEach(function(item){
            item.style.textIndent = indent + "px";
        });

        */
    }

    forceVisible(){
        //force all to show for calculation
        if(this.closest('edml-step') != null){
            this.closest('edml-step').classList.add('forceshow');
            
        }

        if(this.closest('edml-optionalview') != null){
            this.closest('edml-optionalview').classList.add('forceshow');
            
        }

        if(this.closest('.edml-solutionhint-text') != null){                       
            this.closest('.edml-solutionhint-text').classList.add('forceshow');        
        }

        if(this.closest('.edml-help-text') != null){        
            this.closest('.edml-help-text').classList.add('forceshow');        
        }

        if(this.closest('.edml-dialog') != null){                    
            this.closest('.edml-dialog').classList.add('forceshow');        
        }

        if(this.closest('edml-panel') != null){                    
            this.closest('edml-panel').classList.add('forceshow');        
        }

      /*  for(var i = 0; i < edML_Groups.getContainerGroup().length; i++){
            if(this.closest("edml-"+edML_Groups.getContainerGroup()[i]) != null){
                this.closest("edml-"+edML_Groups.getContainerGroup()[i]).classList.add('forceshow');  
            } 
        }*/

        if(this.closest('edml-page') != null) {
            this.closest('edml-page').querySelectorAll('edml-groupview').forEach(function(item){
                item.classList.add('forceshow');
            });

            this.closest('edml-page').classList.add('forceshow');
        }
    
    }

    redoForceVisible(){
        //unmkae force all to show for calculation
        if(this.closest('edml-step') != null){
            this.closest('edml-step').classList.remove('forceshow');
            
        }

        if(this.closest('edml-optionalview') != null){
            this.closest('edml-optionalview').classList.remove('forceshow');
            
        }

        if(this.closest('.edml-solutionhint-text') != null){                       
            this.closest('.edml-solutionhint-text').classList.remove('forceshow');
            
            
        }

        if(this.closest('.edml-help-text') != null){           
            this.closest('.edml-help-text').classList.remove('forceshow');
            
            
        }

        if(this.closest('.edml-dialog') != null){        
            this.closest('.edml-dialog').classList.remove('forceshow');        
        }

        if(this.closest('edml-panel') != null){                    
            this.closest('edml-panel').classList.remove('forceshow');        
        }

       /* for(var i = 0; i < edML_Groups.getContainerGroup().length; i++){
            if(this.closest("edml-"+edML_Groups.getContainerGroup()[i]) != null){                
                this.closest("edml-"+edML_Groups.getContainerGroup()[i]).classList.remove('forceshow');  
            } 
        }*/

        if(this.closest('edml-page') != null) {
            this.closest('edml-page').querySelectorAll('edml-groupview').forEach(function(item){
                item.classList.remove('forceshow');
            });
            this.closest('edml-page').classList.remove('forceshow');
        }


       
        
        
    }



    numberList(){
        let format = edMLPlayer_Config.get('list.format');
        if(this.getAttribute('format') != null && edML_List.formatValues.indexOf(this.getAttribute('format')) > -1){
            format = this.getAttribute('format');
        }

        let separator = edMLPlayer_Config.get('list.separator');
        let lastsep = edMLPlayer_Config.get('list.lastsep');
        if(this.getAttribute('separator') != null) separator = this.getAttribute('separator');
        if(this.getAttribute('lastsep') == "false" || this.getAttribute('lastsep') == false) lastsep = false;

        //for symbolic formats standard separator is ""
        if(this.getAttribute('separator') == null && (format == "bullet" || format == "dash" || format == "dot")){
            separator = "";
        }
        

        switch(format){            
            case "decimal": this.numberDecimal(separator,lastsep); break;
            case "arabic":  this.numberDecimal(separator,lastsep); break;
            case "letter" : this.numberArray(separator,lastsep, edML_List.arrletter); break;
            case "Letter" : this.numberArray(separator,lastsep, edML_List.arrLetter); break;
            case "greek" : this.numberArray(separator,lastsep, edML_List.arrgreek); break;
            case "Greek" : this.numberArray(separator,lastsep, edML_List.arrGreek); break;
            case "bullet" : this.numberSymbol(separator,lastsep,"bullet"); break;  //•
            case "dash" : this.numberSymbol(separator,lastsep,"-"); break;
            case "dot" : this.numberSymbol(separator,lastsep,"·"); break;
            case "Roman" : this.numberRoman(separator,lastsep, true); break;
            case "roman" : this.numberRoman(separator,lastsep, false); break;
            default:
                //= none -> do nothing [default behaviour is defined in edMLPlayer_Config]

        }

    }

    numberDecimal(separator,lastsep){
        let nb = 1;
        let text;
        let fullnumbering = edMLPlayer_Config.get('list.fullnumbering');
        if(this.getAttribute('fullnumbering') == 'true' || this.getAttribute('fullnumbering') == '1') fullnumbering = true;
        this.querySelectorAll(':scope > edml-listitem').forEach(function(item){
            if(item.getAttribute('label') == null){            
                text = "";
                if(fullnumbering){
                    if(item.parentNode.closest('edml-listitem') != null && item.parentNode.closest('edml-listitem').getAttribute('label') != null) {
                        text = item.parentNode.closest('edml-listitem').getAttribute('label');
                    } else if(item.parentNode.closest('edml-listitem') != null && item.parentNode.closest('edml-listitem').getAttribute('alabel') != null){
                        text = item.parentNode.closest('edml-listitem').getAttribute('alabel');
                    }
                }
    
                if(lastsep == false && item.querySelector(':scope > edml-listitem') == null){
                    item.setAttribute('alabel',text+nb);
                } else {
                    item.setAttribute('alabel',text+nb+separator);
                }
            }
            //add label/ alabel as span
            let span = document.createElement('span');
            span.classList.add('edml-listitem-label');
            if(item.getAttribute('label') != null){
                span.innerText = item.getAttribute('label');
            } else {
                span.innerText = item.getAttribute('alabel');            
            }

            

            item.prepend(span);
            if(item.getAttribute('numbered') == null || item.getAttribute('numbered') != "false") nb++;
        });
    }
    
    numberRoman(separator,lastsep,uppercase){
        let nb = 1;
        let text;
        let fullnumbering = edMLPlayer_Config.get('list.fullnumbering');
        if(this.getAttribute('fullnumbering') == 'true' || this.getAttribute('fullnumbering') == '1') fullnumbering = true;

        this.querySelectorAll(':scope > edml-listitem').forEach(function(item){
            if(item.getAttribute('label') == null){            
                text = "";
                if(fullnumbering){
                    if(item.parentNode.closest('edml-listitem') != null && item.parentNode.closest('edml-listitem').getAttribute('label') != null) {
                        text = item.parentNode.closest('edml-listitem').getAttribute('label');
                    } else if(item.parentNode.closest('edml-listitem') != null && item.parentNode.closest('edml-listitem').getAttribute('alabel') != null){
                        text = item.parentNode.closest('edml-listitem').getAttribute('alabel');
                    }
                }

                if(lastsep == false && item.querySelector(':scope > edml-listitem') == null){
                    item.setAttribute('alabel',text+edMLPlayer_Util.numberToRoman(nb,uppercase,true));
                } else {
                    item.setAttribute('alabel',text+edMLPlayer_Util.numberToRoman(nb,uppercase,true)+separator);
                }
            }
            //add label/ alabel as span
            let span = document.createElement('span');
            span.classList.add('edml-listitem-label');
            if(item.getAttribute('label') != null){
                span.innerText = item.getAttribute('label');
            } else {
                span.innerText = item.getAttribute('alabel');            
            }

            item.prepend(span);
            if(item.getAttribute('numbered') == null || item.getAttribute('numbered') != "false") nb++;
        });
    }

    numberSymbol(separator,lastsep, symbol){
        let nb = 1;
        let text;
        let fullnumbering = edMLPlayer_Config.get('list.fullnumbering');
        if(this.getAttribute('fullnumbering') == 'true' || this.getAttribute('fullnumbering') == '1') fullnumbering = true;

        this.querySelectorAll(':scope > edml-listitem').forEach(function(item){
            if(item.getAttribute('label') == null){            
                text = "";
                if(fullnumbering){
                    if(item.parentNode.closest('edml-listitem') != null && item.parentNode.closest('edml-listitem').getAttribute('label') != null) {
                        text = item.parentNode.closest('edml-listitem').getAttribute('label');
                    } else if(item.parentNode.closest('edml-listitem') != null && item.parentNode.closest('edml-listitem').getAttribute('alabel') != null){
                        text = item.parentNode.closest('edml-listitem').getAttribute('alabel');
                    }
                }

                if(lastsep == false && item.querySelector(':scope > edml-listitem') == null){
                    item.setAttribute('alabel',text+symbol);
                } else {
                    item.setAttribute('alabel',text+symbol+separator);
                }
                
            }
            //add label/ alabel as span
            let span = document.createElement('span');
            span.classList.add('edml-listitem-label');
            if(item.getAttribute('label') != null){
                span.innerText = item.getAttribute('label');
            } else {
                span.innerText = item.getAttribute('alabel');            
            }

            if(symbol == "bullet"){
                span.innerText = " ";
                span.classList.add('edml-bulletlist');
            }

            item.prepend(span);
            if(item.getAttribute('numbered') == null || item.getAttribute('numbered') != "false") nb++;
        });
    }



    numberArray(separator,lastsep,arr){
        let nb = 1;
        let div;
        let mod;
        let text;
        let i;
        let fullnumbering = edMLPlayer_Config.get('list.fullnumbering');
        if(this.getAttribute('fullnumbering') == 'true' || this.getAttribute('fullnumbering') == '1') fullnumbering = true;
        
        this.querySelectorAll(':scope > edml-listitem').forEach(function(item){
            if(item.getAttribute('label') == null){                            
                text = "";
        
                i = 1;
                div = nb - 1;
                do{
                    mod = div % Math.pow(arr.length,i);
                    div = div - Math.pow(arr.length,i) * mod;
                    text = arr[mod] + text;
                    i++;                     
                } while(div > 0);

                if(fullnumbering){
                    if(item.parentNode.closest('edml-listitem') != null && item.parentNode.closest('edml-listitem').getAttribute('label') != null) {
                        text = item.parentNode.closest('edml-listitem').getAttribute('label') + text;
                    } else if(item.parentNode.closest('edml-listitem') != null && item.parentNode.closest('edml-listitem').getAttribute('alabel') != null){
                        text = item.parentNode.closest('edml-listitem').getAttribute('alabel') + text;
                    }
                }
                      
                if(lastsep == false && item.querySelector(':scope > edml-listitem') == null){
                    item.setAttribute('alabel',text);
                } else {                    
                    item.setAttribute('alabel',text+separator);                    
                }
            }
            //add label/ alabel as span
            let span = document.createElement('span');
            span.classList.add('edml-listitem-label');
            if(item.getAttribute('label') != null){
                span.innerText = item.getAttribute('label');
            } else {
                span.innerText = item.getAttribute('alabel');            
            }

            item.prepend(span);
            if(item.getAttribute('numbered') == null || item.getAttribute('numbered') != "false") nb++;
        });
    }


}
class edML_Listitem extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup());
        this.setAttributeWhitelist(["name","label","numbered","tags"]);
        this.setIgnoreAttributes(["alabel"]);
        this.setMixedContent(false);
        this.setRemoveContentByClass(['edml-listitem-label']);
        this.setIgnoreClasses(['edml-listitem-label']);
        this.check();
    }

    
}
class edML_M extends edML_Tag{

    static number = 0;

    constructor(value){
        super();
        this.setTagWhitelist(["cdata","calc","ref","autoref"]);
        this.setAttributeWhitelist(["align","display","name","tags","numbered"]);
        this.setMixedContent(true);
        this.check();
        this.firsttime = true;
        
        this.edml = this.innerHTML.replaceAll('<edml-calc','<calc').replaceAll('</edml-calc','</calc');
        this.edml = this.edml.replaceAll('<edml-ref','<ref').replaceAll('</edml-ref','</ref');
        this.edml = this.edml.replaceAll('<edml-refnumber','<refnumber').replaceAll('</edml-refnumber','</refnumber');
        if(value != null) this.latex = value; else this.latex = null;
        if(this.getAttribute('numbered') == "true"){
            edML_M.number++;
            this.number = document.createElement('span');
            this.number.classList.add('edml-number-numbering');
            this.number.innerText = "("+edML_M.number+")";                        
        }
        
    }

    calculate(){
        var html = this.edml.replaceAll('<calc','<edml-calc').replaceAll('</calc','</edml-calc');
        html = html.replaceAll('<ref','<edml-ref').replaceAll('</ref','</edml-ref');
        html = html.replaceAll('<refnumber','<edml-refnumber').replaceAll('</refnumber','</edml-refnumber');
        html = html.replaceAll('<autoref','<edml-autoref').replaceAll('</autoref','</edml-autoref');
        this.innerHTML = html;
        this.latex = null;
        this.firsttime = true;
        this.connectedCallback();
    }


    connectedCallback(){
        /*this.querySelectorAll(':scope > edml-calculate').forEach(function(item){
            let val = item.getValue();
            item.innerHTML = val;
        });*/
        
             
        if(edMLPlayer_Config.get("player.mathjax.active") && this.firsttime) {
            this.querySelectorAll('edml-calc').forEach(function(item){
                item.calculate();
            });
            this.querySelectorAll('edml-ref').forEach(function(item){                
                item.calculate();
            });
        
            let obj = this.closest('edml-variant');
            if(this.querySelector('edml-autoref') != null) this.setAttribute('autoref',"true");
            this.querySelectorAll('edml-autoref').forEach(function(item){                
                item.calculate(obj);
            });


            if(this.querySelector('edml-refnumber') != null) this.setAttribute('refnumber',"true");
            this.querySelectorAll('edml-refnumber').forEach(function(item){               
                item.rename(obj);
            });

            if(this.latex == null) this.latex = this.innerText;

            this.innerHTML = "";
          // if(latex.indexOf('<![CDATA[') == 0) latex = latex.substring('<![CDATA['.length,latex-']]>'.length);
            let span = document.createElement('span');
            span.classList.add('edml-m-inner');
            span.innerText = "#$# " + this.getLaTeX() + " #$#"; 
            
            this.append(span);         
            if(this.innerHTML.indexOf("(") > -1) this.classList.add("roundbrackets");
            
            //this.classList.add('rendered'); 
            this.setAttribute('alt',this.getLaTeX().replaceAll('"','&quote;'));
            if(edMLPlayer_Config.get("access.level") == 2){
                this.innerText = this.latex;
            }
        }
        

        if(this.firsttime && this.getAttribute('numbered') == "true"){
            
           this.append(this.number);
        
        }
        this.firsttime = false;

    }
    
    getLaTeX(){        
        let latex = '\\require{textcomp} ';
        if(this.getAttribute('display') == "block" && (edMLPlayer_Config.get('player.displaystyle') == true || edMLPlayer_Config.get('player.displaystyle') == "true")) latex += "\\displaystyle ";
        latex += this.latex;
       // if(latex.indexOf('<![CDATA[') == 0) latex = latex.substring('<![CDATA['.length,latex-']]>'.length);
        return latex;
    }
    
    
    getEdML(){
        //if(this.latex.indexOf('![CDATA[') == -1 && (this.latex.indexOf('<') > -1 || this.latex.indexOf('>') > -1 || this.latex.indexOf('"') > -1 || this.latex.indexOf("'") > -1 || this.latex.indexOf('&') > -1)) text = '<![CDATA[' + text + ']]>';
        //if(this.latex.trim().indexOf('![CDATA[') == 0 && (this.latex.indexOf('<') == -1 && this.latex.indexOf('>') == -1 || this.latex.indexOf('"') == -1 || this.latex.indexOf("'") == -1 || this.latex.indexOf('&') == -1) && this.latex.trim().substring(this.latex.trim().length-3) == "]]>" ) this.latex = this.latex.trim().substring(8,this.latex.trim().length-3);
        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"';
        }
        return '<m'+attr+'>' + this.edml + '</m>';
    }
    
    //override
    getText(){
        let arr = new Array();
        arr.push(this.getLaTeX());
        arr.push(true);
        return arr;
    }
    
    
}
class edML_Mark extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getInlineGroup());
        this.setAttributeWhitelist(["name","tags","role"]);
        this.setMixedContent(true);
        this.check();
    }
}


class edML_Match extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist(["credits"]);
        this.setMixedContent(true); 
        this.check();
    }

    encode(key){
        let textBytes = aesjs.utils.utf8.toBytes(this.innerText);            
        let aesCtr = new aesjs.ModeOfOperation.ctr(key, new aesjs.Counter(5));
        let encryptedBytes = aesCtr.encrypt(textBytes); 
        let encryptedHex = aesjs.utils.hex.fromBytes(encryptedBytes);
        this.innerText = encryptedHex; 

    }

    decode(key){
        let encryptedBytes = aesjs.utils.hex.toBytes(this.innerText);
        let aesCtr = new aesjs.ModeOfOperation.ctr(key, new aesjs.Counter(5));
        let decryptedBytes = aesCtr.decrypt(encryptedBytes);
        return aesjs.utils.utf8.fromBytes(decryptedBytes); 
    }

    getEdML(key){
        let edml = "";
        if(key != null){
            let encryptedBytes = aesjs.utils.hex.toBytes(this.innerText);
            let aesCtr = new aesjs.ModeOfOperation.ctr(key, new aesjs.Counter(5));
            let decryptedBytes = aesCtr.decrypt(encryptedBytes);
            edml = aesjs.utils.utf8.fromBytes(decryptedBytes); 
        } else {
            edml = this.innerText;
        }
            

        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 
        if(attr.length > 0) attr = " " + attr;
        edml = '<match'+attr+'>'+edml+'</match>';

        return edml;
    }



}
class edML_Matches extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["match"]);
        this.setAttributeWhitelist([]);
        this.setMixedContent(false);
        //this.setRequiredTag(["match"]); 
        this.check();
        this.maxoccur = 3;
    }

    getMaxOccur(){
        return this.maxoccur;
    }

    getEdML(key){
        let edml = "";

        this.querySelectorAll(':scope > edml-match').forEach(function(item){
            edml += item.getEdML(key);
        });

        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 
        if(attr.length > 0) attr = " " + attr;
        edml = '<matches'+attr+'>'+edml+'</matches>';
        return edml;

    }



}
class edML_Matching extends edML_Inputvalue{

    constructor(){
        super();
        this.setTagWhitelist(["matches","dragitems","dropitems"]);
        this.setAttributeWhitelist(["credits","model"]);
        this.setMixedContent(false);
        this.setRequiredTag([["dragitems"],["dropitems"],["matches"]]); 
        this.setOnlyOnceTag(["matches","dragitems","dropitems"]);
        this.check();

        this.prepend(this.querySelector('edml-dragitems'));

        //encode matches
        this.key = new Uint8Array(32);
        for(let i =  0; i < 32; i++){
            this.key[i] = Math.floor(Math.random()*Number.MAX_SAFE_INTEGER);
        }

       
    }

    connectedCallback(){
        if(this.connected == null){
            this.connected = true;
            this.lastCredits = 0;   

            this.querySelectorAll(':scope > edml-matches > edml-match').forEach(function(item){              
                item.encode(this.key);           
            }.bind(this));

            if(!this.closest('edml-inputblock').classList.contains("disabled")){
                //make items draggable
                this.querySelectorAll(':scope > edml-dragitems > edml-item').forEach(function(item){
                    item.addEventListener('click',this.onClickDragItem.bind(this,item)); //for mobile
                    item.setAttribute('draggable','true');

                    this.dragStart(item);
                    this.dragEnd(item);
                }.bind(this));

                //make drop areas
                this.querySelectorAll(':scope > edml-dropitems > edml-item').forEach(function(item){
                    item.addEventListener('click',this.onClickDropItem.bind(this,item)); //for mobile
                }.bind(this));
            }
        }
            
    }





    dragEnd(obj){
        if(!this.closest('edml-inputblock').classList.contains("disabled")){
            let item = obj;

            item.addEventListener("dragend", function(evt) {
                evt.stopImmediatePropagation();               
                item.classList.remove("dragging");
                
                if(window.dropitem != null){
                    //item not dropped yet? --> drop back to dragitems
                    //console.log(window.dropitem)
                    if(this.querySelector(':scope > edml-dragitems edml-item[order="'+item.getAttribute('order')+'"]') == null){
                        this.querySelector(':scope > edml-dragitems').append(item);
                    } else {
                        // this.remove();
                    }
                    
                }

                //make dropitems items not dropable and check for matched class
                this.querySelectorAll(':scope > edml-dropitems > edml-item').forEach(function(it){
                    this.removeDropable(it);
                }.bind(this));

                this.querySelector(':scope > edml-dragitems').sort();
                let dragusage = this.getSubmodel().dragusage; 
                if(this.querySelector(':scope > edml-dragitems').getAttribute('maxuse') != null) dragusage = this.querySelector(':scope > edml-dragitems').getAttribute('maxuse');
                let occurDragusage = [...this.querySelectorAll(':scope > edml-dropitems > edml-item > edml-item[order="'+item.getAttribute('order')+'"]')].length;
                if(occurDragusage < dragusage){
                    item.classList.remove('hide');
                }
            }.bind(this));
        }
        

    }

    dragStart(obj){
        
        let item = obj;
        

        item.addEventListener("dragstart", function(evt) {
                if(!this.closest('edml-inputblock').classList.contains("disabled")){
                    item.setAttribute('draggable',"true");
                    evt.stopImmediatePropagation();

                    let dragusage = this.getSubmodel().dragusage; 
                    if(this.querySelector(':scope > edml-dragitems').getAttribute('maxuse') != null) dragusage = this.querySelector(':scope > edml-dragitems').getAttribute('maxuse');
                    let occurDragusage = [...this.querySelectorAll(':scope > edml-dropitems > edml-item > edml-item[order="'+item.getAttribute('order')+'"]')].length;
                    if(occurDragusage >= dragusage && !item.parentNode.parentNode instanceof edML_Dropitems){
                        evt.preventDefault(); // not dragable 
                    } else {

                        if(occurDragusage + 1 == dragusage){
                            setTimeout(function(){item.classList.add('hide')},1);
                        }

                        item.removeAttribute('solved');             
                        this.onCheck(evt);  

                        if(item.parentNode instanceof edML_Dragitems){
                            item.setAttribute('dragparent','true');    //mark, where item is coming from (dragitems or dropitems)              
                        }
                        
                                    
                    
                        //this.classList.add("dragging"); 
                    

                        evt.dataTransfer.effectAllowed = "copyMove";                    
                        
                        
                        
                        this.dragitem = item;
                        //make dropitems items dropable
                        this.querySelectorAll(':scope > edml-dropitems > edml-item').forEach(function(item){
                            this.makeDropable(item);
                        }.bind(this));
                    }
                } else{
                    evt.preventDefault();
                    evt.stopImmediatePropagation();
                    item.removeAttribute('draggable');
                }
        
            
            
        }.bind(this));
        
        
        
    }

    onClickDragItem(item,evt){
        if(!this.closest('edml-inputblock').classList.contains("disabled")){
            item.setAttribute('draggable',"true");
            this.removeAttribute('solved');
            if(item.parentNode instanceof edML_Dragitems){
                if(item.classList.contains('clicked')){
                    item.classList.remove('clicked');
                } else {
                    item.parentNode.querySelectorAll(':scope > edml-item').forEach(function(item){
                        item.classList.remove('clicked');
                    });
                    item.classList.add('clicked');
                }
            } else {
                //back to dragitems, if not exists
                
                if(this.querySelector(':scope > edml-dragitems edml-item[order="'+item.getAttribute('order')+'"]') == null){
                    this.querySelector(':scope > edml-dragitems').append(item);
                    this.querySelector(':scope > edml-dragitems').sort();
                    item.classList.remove('hide');
                } else {
                    this.querySelector(':scope > edml-dragitems edml-item[order="'+item.getAttribute('order')+'"]').classList.remove('hide');
                    item.remove();                     
                }
                
            }
            this.onCheck(evt);  
        } else {
            item.removeAttribute('draggable');
        }
         
    
    }

    onClickDropItem(item,evt){
        if(!this.closest('edml-inputblock').classList.contains("disabled")){
            this.removeAttribute('solved');
            if(this.querySelector(':scope > edml-dragitems > edml-item.clicked') != null){       
                let obj = this.querySelector(':scope > edml-dragitems > edml-item.clicked');
                obj.classList.remove('clicked');
                item.append(obj);     
                this.onCheck(evt);  
                        
            }
        }
    }

    dragover(item,evt){
        evt.preventDefault();
        item.classList.add("dragover");
        
    }

    dragenter(item,evt){        
        evt.dataTransfer.dropEffect = "copy";
        item.classList.add("dragover");
    }

    dragleave(item,evt){
        evt.dataTransfer.dropEffect = "copyMove";
        item.classList.remove("dragover");
    }

    drop(dropitem,evt){
        if(!this.closest('edml-inputblock').classList.contains("disabled")){
            evt.preventDefault();   
            if(dropitem.parentNode instanceof edML_Item) dropitem = dropitem.parentNode;
    
        
            let dragusage = this.getSubmodel().dragusage; 
            if(this.querySelector(':scope > edml-dragitems').getAttribute('maxuse') != null) dragusage = this.querySelector(':scope > edml-dragitems').getAttribute('maxuse');

            let dropusage = this.getSubmodel().dropusage; 
            if(this.querySelector(":scope > edml-dropitems").getAttribute('maxuse') != null) dropusage = this.querySelector(":scope > edml-dropitems").getAttribute('maxuse')

            let occurDragusage = [...this.querySelectorAll(':scope > edml-dropitems > edml-item > edml-item[order="'+this.dragitem.getAttribute('order')+'"]')].length;
            let occurDropusage = [...dropitem.querySelectorAll(':scope > edml-item')].length;
                    
            let appendobj = null;
            if(this.dragitem.parentNode.parentNode instanceof edML_Dropitems){
                occurDragusage--;
                appendobj = this.dragitem;
            } else if(occurDragusage < dragusage){
                appendobj = new edML_Item();
                appendobj.innerHTML = edML_edML2HTML.parse2string(this.dragitem.getEdML());
                appendobj.setAttribute('order',this.dragitem.getAttribute('order'));
            }


            if(appendobj != null && occurDropusage < dropusage){
                dropitem.append(appendobj);
                appendobj.setAttribute('draggable','true');
                appendobj.addEventListener('click',this.onClickDragItem.bind(this,appendobj)); //for mobile
                this.dragStart(appendobj);
                this.dragEnd(appendobj);
                appendobj.removeAttribute('dragparent');
                edMLPlayer_Util.typesetMath(appendobj);
            }            
            
            dropitem.classList.remove('dragover'); 
            //this.dragitem = null;
        }
                        
    }

    makeDropable(item){        

        item.addEventListener("dragover", this.dragover.bind(this,item));            
        item.addEventListener("dragenter", this.dragenter.bind(this,item));
        item.addEventListener("dragleave", this.dragleave.bind(this,item));
        item.addEventListener("drop", this.drop.bind(this,item));
    }

    removeDropable(item){

        item.removeEventListener('dragover',this.dragover);
        item.removeEventListener("dragenter", this.dragenter);
        item.removeEventListener("dragleave", this.dragleave);
        item.removeEventListener("drop", this.drop);

        //is item matched?
        if(item.querySelector(':scope > edml-item') != null){
            item.classList.add('matched');
        } else {
            item.classList.remove('matched');
        }

    }

    


    getSubmodel(){
        let model = this.getModel().getSubmodel("matching");
        return model;
    }

    verify(value, model){        
        let solvedobj = new Object();
        solvedobj.solved = false;
        solvedobj.solution = null;
        solvedobj.credits = 0;
        solvedobj.penalty = 0;
        let dragitems = this.querySelector(':scope > edml-dragitems');
        let dropitems = this.querySelector(':scope > edml-dropitems');
        if(model == null) model = this.getSubmodel();

        if(this.getAttribute('credits') != null && !isNaN(parseInt(this.getAttribute('credits')))) {
            solvedobj.maxcredits = parseInt(this.getAttribute('credits'));
         } else {
            solvedobj.maxcredits = model.credits;
        }

        


        this.querySelectorAll(':scope > edml-dropitems > edml-item').forEach(function(item){
            item.classList.remove('missed');
        });

        // compare
        if(value == null) {
            let value;
            let dragitem;
            let dropitem;
           // console.log(dragitems.itemorder);
         //   console.log(dropitems.itemorder);
            this.querySelectorAll(':scope > edml-dropitems > edml-item > edml-item').forEach(function(item){
                dragitem = parseInt(dragitems.itemorder[parseInt(item.getAttribute('order'))])+1;
                dropitem = parseInt(dropitems.itemorder[parseInt(item.parentNode.getAttribute('order'))])+1;
                value = dragitem+ " " + dropitem;
               // console.log(value);
                let found = false;
                //count solved matches first
                this.querySelectorAll(':scope > edml-matches > edml-match:not(.used)').forEach(function(match){
                    if(match.decode(this.key).trim() == value && found == false) {
                        found = true;                        
                        match.classList.add('used');
                        item.setAttribute('solved','true');
                        if(match.getAttribute('credits') != null) {
                            solvedobj.credits += parseInt(match.getAttribute('credits'));
                        } else {                            
                            solvedobj.credits += model.credits;
                        }

                        if(solvedobj.credits > solvedobj.maxcredits){
                            solvedobj.credits = solvedobj.maxcredits;
                        }
                    } 
                    
                }.bind(this));
               
                
                //count failed matches second
                if(found == false) {
                    item.setAttribute('solved','false');
                    if(this.getAttribute('penalty') != null) {
                        solvedobj.penalty += parseInt(match.getAttribute('penalty'));
                    } else {
                        solvedobj.penalty += model.penalty;
                    }                                        
                    
                }

            }.bind(this));    
            

            //check for missed matches
           
            this.querySelectorAll(':scope > edml-matches > edml-match:not(.used)').forEach(function(match){            
                let misseddropitem = parseInt(match.decode(this.key).trim().split(" ")[1]);
                //console.log(misseddropitem);
               // let idx = parseInt(dropitems.itemorder[misseddropitem-1]);
                let idx = dropitems.itemorder.indexOf((misseddropitem-1)+"");
                //console.log(idx);
                if(this.querySelector(':scope > edml-dropitems > edml-item[order="'+idx+'"]') != null) {
                    this.querySelector(':scope > edml-dropitems > edml-item[order="'+idx+'"]').classList.add('missed');
                    if(this.getAttribute('penalty') != null) {
                        solvedobj.penalty += parseInt(match.getAttribute('penalty'));
                    } else {
                        solvedobj.penalty += model.penalty;
                    }   
                }
            }.bind(this));

        

            //mark dropitems items
            this.querySelectorAll(':scope > edml-dropitems > edml-item').forEach(function(item){
                item.setAttribute('solved','true');
                if(item.querySelector(':scope > edml-item[solved="false"]') != null){
                    item.setAttribute('solved','false');
                }
                if(item.classList.contains('missed')){
                    item.setAttribute('solved','false');
                }
            });

            //everything solved?
            if(this.querySelector(':scope > edml-dropitems > edml-item.missed') == null &&  this.querySelector(':scope > edml-dropitems > edml-item > edml-item[solved="false"]') == null){
                solvedobj.solved = true;
                this.setAttribute('solved','true');
            } else {
                solvedobj.solved = false;
                this.setAttribute('solved','false');
            }
            
            //remove used
            this.querySelectorAll(':scope > edml-matches > edml-match.used').forEach(function(item){
                item.classList.remove('used');
            });

            
            

     
        }
         
        return solvedobj;
        
    }

    showSolutionhint(){        
        let hint = document.querySelector('edml-variant.active edml-solutionhint[to="'+this.closest('edml-inputblock').getAttribute('name')+'"]');
  
        if(this.closest('edml-inputblock').querySelector('.edml-solutionhint-btn') == null){
            let btn = document.createElement('span');
            btn.classList.add('edml-solutionhint-btn');
            this.closest('edml-inputblock').prepend(btn);
            
            btn.addEventListener('click',function(){
                /*let dlg = new edML_DialogSolutionhint();
                dlg.setTitle(document.edmllocale.get("dialog_solutionhint_title"));                            
                dlg.setSteps(hint);
                dlg.hideFooter();
                dlg.show();   */                                         
                edML_DialogSolutionhint.show(hint); 
            });
        }   
        
    }


    evaluateCredits(result){
        let model = this.getSubmodel();   
        console.log(result);  
        if(result != null){    
            if(result.solved == true){   
                edMLPlayer_Functions.changeCredits(-1 * this.lastCredits, false);
                edMLPlayer_Functions.changeCredits(result.credits, true);                            
                this.lastCredits = model.credits;
                
                if(this.querySelector('.edml-solutionhint-btn') != null) this.querySelector('.edml-solutionhint-btn').remove();
                                
            } else if(result.solved == false){                
                edMLPlayer_Functions.changeCredits(-1 * this.lastCredits, false);
                var penalty = result.credits - result.penalty;

                var maxtotalpenalty = model.maxtotalpenalty;
                if(this.getAttribute('maxtotalpenalty') != 0){
                    maxtotalpenalty = parseInt(this.getAttribute('maxtotalpenalty'));
                } 
                if(penalty < maxtotalpenalty){
                    penalty = maxtotalpenalty;
                }

                edMLPlayer_Functions.changeCredits(penalty, true);      
                this.lastCredits = penalty;  
            
                
                
            } else {  //result == null
                //do nothing
            }
            this.closest('edml-inputblock').setAttribute('achievedcredits',this.lastCredits);
        }  else console.error('result is undefined on credit evaluation (in inputvalue class)');
    }

    getEdML(){
        let edml = "";

        if(this.querySelector(':scope > edml-dropitems') !=null) edml += this.querySelector(':scope > edml-dropitems').getEdML(); else edml += this.querySelector(':scope > edml-dropitems').getEdML();
        if(this.querySelector(':scope > edml-dragitems') !=null) edml += this.querySelector(':scope > edml-dragitems').getEdML(); else edml += this.querySelector(':scope > edml-dragitems').getEdML();
        edml += this.querySelector(':scope > edml-matches').getEdML(this.key);


        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 
        if(attr.length > 0) attr = " " + attr;
        edml = '<matching'+attr+'>'+edml+'</matching>';

        return edml;
    }

    getValue(){
        let arr = new Array();
        let dragitems = this.querySelector(':scope > edml-dragitems');
        let dropitems = this.querySelector(':scope > edml-dropitems');
        let pair;
        this.querySelectorAll(':scope > edml-dropitems > edml-item').forEach(function(item){

            item.querySelectorAll(':scope > edml-item').forEach(function(dragitem){
                pair = dragitems.itemorder[dragitem.getAttribute('order')] + " " + dropitems.itemorder[item.getAttribute('order')];
                arr.push(pair);
            });
        });


        return arr;
    }


    getString(){        
        return JSON.stringify(this.getValue());
    }

    
    setValue(val){
        console.log(val);
        if(!Array.isArray(val) && val.trim() != ""){
            let value = JSON.parse(val);
            let dragitems = this.querySelector(':scope > edml-dragitems');
            let dropitems = this.querySelector(':scope > edml-dropitems');
            let drag;
            let drop;
            let split;

            for(let i = 0; i < value.length; i++){
                split = value[i].split(" ");
                if(split.length == 2){
                    drag = dragitems.itemorder.indexOf(split[0]);
                    this.querySelector(':scope > edml-dragitems > edml-item[order="'+drag+'"]').click();

                    drop = dropitems.itemorder.indexOf(split[1]);
                    this.querySelector(':scope > edml-dropitems > edml-item[order="'+drop+'"]').click();
                }
            } 
        }
    }


    save2SCORM(result){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true && (edMLPlayer_Config.get('player.scorm.testonly') != true || document.querySelector('edml-test.active') != null)){  
            let navitem = this.closest('edml-variant').querySelector('edml-navitem.selected');
            if(navitem != null) navitem = navitem.getAttribute('name');        
            let exercisename = edML_SCORM.saveInputObjective(result,this.closest('edml-inputblock'),this.getString());
            edML_SCORM.saveInteraction(this.closest('edml-page').getAttribute("name"),"other","input: matching",navitem,exercisename,null);
        }
    }

    initFromSCORM(entrynb){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true && edMLPlayer_Config.get('player.scorm.testonly') != true) {
       
            let value = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.description');           
            this.setValue(value);       

            if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "failed"){
                this.closest('edml-inputblock').setAttribute('solved','false');
            } else if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "passed"){
                this.closest('edml-inputblock').setAttribute('solved','true');
            }
            this.lastCredits = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.score.raw');

            this.verify();
        }
    }

    clear(){
        this.removeAttribute('solved');     
        this.querySelectorAll('edml-dropitems edml-item > edml-item').forEach(function(item){
            item.click();
        });

        this.querySelectorAll('edml-dropitems > edml-item').forEach(function(item){
            item.removeAttribute('solved');
        })

    }

    


}
class edML_Matrix extends edML_Inputvalue{

    constructor(firstelement=null){
        super();
        this.setTagWhitelist(["matrixrow"]);        
        this.setRequiredTag(["matrixrow"]);        
        this.setAttributeWhitelist(["credits","model","minrows","maxrows","defaultrows","mincolumns","maxcolumns","defaultcolumns","minrowshints","maxrowshints","mincolumnshints","maxcolumnshints"]);
        this.setMixedContent(false); 
        if(this.querySelector(':scope > edml-matrixrow') == null){
            this.append(new edML_Matrixrow(firstelement));
        }       
        this.check();        


        this.colshow = 1;
        this.rowshow = 1;
        

    }


    connectedCallback(){
        if(this.connected == null){
            this.connected = true;
            let model = this.closest("edml-input").getModel().getSubmodel("matrix");   
            let defaultcolumns = model.defaultcolumns;
            let defaultrows = model.defaultrows;
            let maxcols = model.maxcolumns;   
            let mincols = model.mincolumns;    
            let minrows = model.minrows; 
            let maxrows = model.maxrows;

            this.rowlen = this.querySelectorAll(':scope > edml-matrixrow').length;
            this.collen = this.querySelectorAll(':scope > edml-matrixrow:first-child > *').length;
        

            if(this.getAttribute('minrows') != null && !isNaN(parseInt(this.getAttribute('minrows')))) minrows = parseInt(this.getAttribute('minrows'));

            if(this.getAttribute('maxrows') != null && !isNaN(parseInt(this.getAttribute('maxrows')))) maxrows = parseInt(this.getAttribute('maxrows'));

            if(this.getAttribute('maxcolumns') != null && !isNaN(parseInt(this.getAttribute('maxcolumns')))) maxcols = parseInt(this.getAttribute('maxcolumns'));

            if(this.getAttribute('mincolumns') != null && !isNaN(parseInt(this.getAttribute('mincolumns')))) mincols = parseInt(this.getAttribute('mincolumns'));


            if(this.getAttribute('defaultcolumns') != null && !isNaN(parseInt(this.getAttribute('defaultcolumns')))) defaultcolumns = parseInt(this.getAttribute('defaultcolumns'));

            if(this.getAttribute('defaultrows') != null && !isNaN(parseInt(this.getAttribute('defaultrows')))) defaultrows = parseInt(this.getAttribute('defaultrows'));

            //for safety
            if(this.getAttribute('maxcolumns') != null && this.getAttribute('maxcolumns').toLowerCase() == "inf") maxcols = Infinity;
            if(this.getAttribute('maxrows') != null && this.getAttribute('maxrows').toLowerCase() == "inf") maxrows = Infinity;
            if(minrows < 1) minrows = 1;
            if(mincols < 1) mincols = 1;
            if(defaultrows < minrows) defaultrows = minrows;
            if(defaultrows > maxrows) defaultrows = maxrows;
            if(defaultcolumns < mincols) defaultcolumns = mincols;
            if(defaultcolumns > maxcols) defaultcolumns = maxcols;
            
        

            //hide elements
            if(this.querySelectorAll(':scope > edml-matrixrow > edml-number, :scope > edml-matrixrow > edml-expression') != null){
                this.querySelectorAll(':scope > edml-matrixrow > edml-number, :scope > edml-matrixrow > edml-expression').forEach(function(item){
                    item.classList.add('edml-matrix-element');
                    item.classList.add('hidden');
                });
            }

            this.querySelectorAll(':scope > edml-matrixrow').forEach(function(item){
                item.classList.add('hidden');
            });

            this.querySelector(':scope > edml-matrixrow').classList.remove('hidden');
            this.querySelectorAll(':scope > edml-matrixrow').forEach(function(row){
                row.querySelector(':scope > .edml-matrix-element').classList.remove('hidden');
            });



            


            let addColButton = document.createElement('span');
            addColButton.classList.add('edml-matrix-addcolbtn');

            let removeColButton = document.createElement('span');
            removeColButton.classList.add('edml-matrix-removecolbtn');

            addColButton.addEventListener('click',this.addCol.bind(this));
            removeColButton.addEventListener('click',this.removeCol.bind(this));

            let btnrow = document.createElement('div');
            btnrow.classList.add('edml-matrix-btnrow');
            this.append(btnrow);


            let addRowButton = document.createElement('span');
            addRowButton.classList.add('edml-matrix-addrowbtn');
            

            let removeRowButton = document.createElement('span');
            removeRowButton.classList.add('edml-matrix-removerowbtn');

            addRowButton.addEventListener('click',this.addRow.bind(this));
            removeRowButton.addEventListener('click',this.removeRow.bind(this));

            btnrow.append(removeRowButton);
            btnrow.append(addRowButton);


            //brackets
            this.leftbracket = document.createElement('span');
            this.leftbracket.classList.add('edml-matrix-leftbracket');
            this.leftbracket.innerText = "(";
            this.prepend(this.leftbracket);

            this.rightbracket = document.createElement('span');
            this.rightbracket.classList.add('edml-matrix-rightbracket');
            this.rightbracket.innerText = ")";       
            this.append(this.rightbracket);

            this.prepend(removeColButton);
            this.append(addColButton);

            for(let i = 1; i < defaultcolumns; i++){
                addColButton.click();
            }

            for(let i = 1; i < defaultrows; i++){
                addRowButton.click();
            }

            //active | invisible buttons?
            if(maxrows > this.rowshow) addRowButton.classList.add('active');
            if(minrows < this.rowshow) removeRowButton.classList.add('active');
            if(maxcols > this.colshow) addColButton.classList.add('active');
            if(mincols < this.colshow) removeColButton.classList.add('active');

            if(mincols == maxcols){
                this.querySelector(':scope > .edml-matrix-addcolbtn').classList.add('invisible');
                this.querySelector(':scope > .edml-matrix-removecolbtn').classList.add('invisible');
            }

            if(minrows == maxrows){
                this.querySelector(':scope > .edml-matrix-btnrow > .edml-matrix-removerowbtn').classList.add('invisible');
                this.querySelector(':scope > .edml-matrix-btnrow > .edml-matrix-addrowbtn').classList.add('invisible');
            }




            // calculate width of first element. element is not shown yet so move it to body and back to get width
        /* let obj = this.querySelector(':scope > edml-matrixrow');
            document.body.appendChild(obj);
            let width = obj.getBoundingClientRect().width;
            this.prepend(obj);
            this.rightbracket.style.left = (width)+"px";
            this.addColButton.style.left = (width)+"px";*/
        }

    }

    addCol(){ 
        let model = this.closest("edml-input").getModel().getSubmodel("matrix");   
        let mincols = model.mincolumns; 
        let maxcols = model.maxcolumns;

        if(this.getAttribute('maxcolumns') != null && !isNaN(parseInt(this.getAttribute('maxcolumns')))) maxcols = parseInt(this.getAttribute('maxcolumns'));

        if(this.getAttribute('mincolumns') != null && !isNaN(parseInt(this.getAttribute('mincolumns')))) mincols = parseInt(this.getAttribute('mincolumns'));
        
        if(this.colshow < maxcols){
            if(this.colshow < [...this.querySelector(':scope > edml-matrixrow').querySelectorAll('.edml-matrix-element')].length){
                this.querySelectorAll(':scope > edml-matrixrow').forEach(function(row){
                    [...row.querySelectorAll(':scope > .edml-matrix-element')][this.colshow].classList.remove('hidden');
                }.bind(this));
                
            } else {                                    
                this.querySelectorAll(':scope > edml-matrixrow').forEach(function(row){
                    let newelement;
                    if(this.querySelectorAll(':scope > edml-matrixrow > .edml-matrix-element')[this.collen-1] instanceof edML_Number) {
                        newelement = new edML_Number();            
                    } else if(this.querySelectorAll(':scope > edml-matrixrow > .edml-matrix-element')[this.collen-1] instanceof edML_Expression){
                        newelement = new edML_Expression();
                    }
                    newelement.classList.add('edml-matrix-element');
                    row.append(newelement);
                }.bind(this));
                
            }
            this.colshow++;
            if(this.colshow == maxcols){
                this.querySelector(':scope > .edml-matrix-addcolbtn').classList.remove('active');
            }

            if(this.colshow > mincols){
                this.querySelector(':scope > .edml-matrix-removecolbtn').classList.add('active');
            }
        }
      
       /* let width = this.querySelector(':scope > edml-matrixrow').getBoundingClientRect().width;
        this.rightbracket.style.left = (width)+"px";
        this.addColButton.style.left = (width)+"px";*/

    }

     removeCol(){
        let model = this.closest("edml-input").getModel().getSubmodel("matrix");   
        let mincols = model.mincolumns; 
        let maxcols = model.maxcolumns;

        if(this.getAttribute('maxcolumns') != null && !isNaN(parseInt(this.getAttribute('maxcolumns')))) maxcols = parseInt(this.getAttribute('maxcolumns'));

        if(this.getAttribute('mincolumns') != null && !isNaN(parseInt(this.getAttribute('mincolumns')))) mincols = parseInt(this.getAttribute('mincolumns'));


        if(this.colshow > mincols){
            this.querySelectorAll(':scope > edml-matrixrow').forEach(function(row){
                [...row.querySelectorAll(':scope > .edml-matrix-element')][this.colshow-1].classList.add('hidden');
            }.bind(this));
            this.colshow--;
        }

        if(this.colshow < maxcols){
            this.querySelector(':scope > .edml-matrix-addcolbtn').classList.add('active');
        }
        if(this.colshow == mincols){
            this.querySelector(':scope > .edml-matrix-removecolbtn').classList.remove('active');
        }        
     }


    addRow(){
        let model = this.closest("edml-input").getModel().getSubmodel("matrix");   
        let minrows = model.minrows; 
        let maxrows = model.maxrows;
        if(this.getAttribute('minrows') != null && !isNaN(parseInt(this.getAttribute('minrows')))) minrows = parseInt(this.getAttribute('minrows'));

        if(this.getAttribute('maxrows') != null && !isNaN(parseInt(this.getAttribute('maxrows')))) maxrows = parseInt(this.getAttribute('maxrows'));

        if(this.rowshow < maxrows) {
            if(this.rowshow < [...this.querySelectorAll(':scope > edml-matrixrow')].length){
                [...this.querySelectorAll(':scope > edml-matrixrow')][this.rowshow].classList.remove('hidden');                           
            } else {
                let newrow = null;
                this.querySelectorAll(':scope > edml-matrixrow:last-of-type > .edml-matrix-element').forEach(function(item){
                    let newelement;
                    if(item instanceof edML_Number) {
                        newelement = new edML_Number();            
                    } else if(item instanceof edML_Expression){
                        newelement = new edML_Expression();
                    }

                    if(newelement != null){
                        newelement.classList.add('edml-matrix-element');
                        if(newrow == null){
                            newrow = new edML_Matrixrow(newelement);   
                        } else {
                            newrow.append(newelement); 
                        }
                        if(item.classList.contains('hidden')) newelement.classList.add('hidden');
                    }
                });

                this.querySelector(':scope > edml-matrixrow:last-of-type').parentNode.insertBefore(newrow,this.querySelector(':scope > edml-matrixrow:last-of-type').nextElementSibling);

            }
            this.rowshow++;
            this.leftbracket.style.transform = "scale(1," + this.rowshow + ")";
            this.rightbracket.style.transform = "scale(1," + this.rowshow + ")";
        }

        if(this.rowshow == maxrows){
            this.querySelector(':scope > .edml-matrix-btnrow > .edml-matrix-addrowbtn').classList.remove('active');
        }
        if(this.rowshow > minrows){
            this.querySelector(':scope > .edml-matrix-btnrow > .edml-matrix-removerowbtn').classList.add('active');
        }  
    }

    removeRow(){
        let model = this.closest("edml-input").getModel().getSubmodel("matrix");   
        let minrows = model.minrows; 
        let maxrows = model.maxrows;
        if(this.getAttribute('minrows') != null && !isNaN(parseInt(this.getAttribute('minrows')))) minrows = parseInt(this.getAttribute('minrows'));

        if(this.getAttribute('maxrows') != null && !isNaN(parseInt(this.getAttribute('maxrows')))) maxrows = parseInt(this.getAttribute('maxrows'));


        if(this.rowshow > minrows){
            this.rowshow--;
            [...this.querySelectorAll(':scope > edml-matrixrow')][this.rowshow].classList.add('hidden');
            this.leftbracket.style.transform = "scale(1," + this.rowshow + ")";
            this.rightbracket.style.transform = "scale(1," + this.rowshow + ")";    
        }

        if(this.rowshow == minrows){
            this.querySelector(':scope > .edml-matrix-btnrow > .edml-matrix-removerowbtn').classList.remove('active');
        }
        if(this.rowshow < maxrows){
            this.querySelector(':scope > .edml-matrix-btnrow > .edml-matrix-addrowbtn').classList.add('active');
        }  
    }


    checkShowCheckButton(){
        let okay = true;              

        this.querySelectorAll(':scope > edml-matrixrow:not(.hidden) > .edml-matrix-element:not(.hidden)').forEach(function(item){
            if(!item.checkShowCheckButton())  {
                okay = false;
            }
        });                
        
        return okay;
    }

    verify(value, model){
        let solvedobj = new Object();
        solvedobj.solved = false;
        solvedobj.solution = null;
        solvedobj.credits = 0;
        solvedobj.penalty = 0;

        if(model == null) model = this.getSubmodel();   
        let submodel = null;
        solvedobj.solved = true;
        let elements = [...this.querySelectorAll(':scope > edml-matrixrow:not(.hidden) > .edml-matrix-element:not(.hidden)')];
        if(elements.length != this.collen * this.rowlen){
            for(let i = 0; i < elements.length; i++){     
                elements[i].setAttribute('solved','false');                      
            }   
            solvedobj.solved = false;  
        } else {
            for(let i = 0; i < elements.length; i++){
                
                if(elements[i] instanceof edML_Number){
                    submodel = model.number;
                } else if(elements[i] instanceof edML_Expression){
                    submodel = model.expression;
                } 
                if(elements[i].verify(null,submodel).solved == false) {
                    solvedobj.solved = false;
                    elements[i].setAttribute('solved','false');
                } else {
                    elements[i].setAttribute('solved','true');
                }
            }
        }


        return solvedobj;
    }

    getValue(){
        let matrix = new Array();
        this.querySelectorAll(':scope > edml-matrixrow:not(.hidden)').forEach(function(row){
            let rowarr = new Array();
            let item;
            let val;
            for(let i = 0; i < row.childNodes.length; i++){
                val = "";
                item = row.childNodes[i];
                if(!item.classList.contains('hidden')){                    
                    rowarr.push(item.getString());                
                }
            }

            matrix.push(rowarr);
        }); 
        return matrix;       

    }


    getString(){
        return JSON.stringify(this.getValue());
    }

    setValue(val){
        let rows = [...this.querySelectorAll(':scope > edml-matrixrow:not(.hidden)')];

        //empty matrix
        for(var i = 0; i < rows.length-1; i++){
            this.removeRow();            
        }

        for(var i = 0; i < [...rows[0].querySelectorAll(':scope > *:not(.hidden)')].length-1; i++){
            this.removeCol();
        }
  

        //populate matrix
        let value = new Array();
        if(typeof val == "string" && val.trim() != ""){
            value = JSON.parse(val);
        } else if(Array.isArray(val)){
            value = val;
        }
        
        let cells;


        for(let n = 0; n < value.length - rows.length; n++ ){
            this.addRow();
        }
        rows = [...this.querySelectorAll(':scope > edml-matrixrow')];


        for(let i = 0; i < value.length; i++){
            rows[i].classList.remove('hidden');
            cells = [...rows[i].querySelectorAll(':scope > *:not(.hidden)')];
            for(let n = 0; n < value[i].length - cells.length; n++ ){
                this.addCol();
            }
            cells = [...rows[i].querySelectorAll(':scope > *')];            
            //this.colshow = value[i].length;

            for(let j = 0; j < value[i].length; j++){
                cells[j].setValue(value[i][j]);
                cells[j].classList.remove('hidden');
            }
        }
        
        

    }

    save2SCORM(result){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true && (edMLPlayer_Config.get('player.scorm.testonly') != true || document.querySelector('edml-test.active') != null)){  
            let navitem = this.closest('edml-variant').querySelector('edml-navitem.selected');
            if(navitem != null) navitem = navitem.getAttribute('name');
            let exercisename = edML_SCORM.saveInputObjective(result,this.closest('edml-input'),this.getString());
            edML_SCORM.saveInteraction(this.closest('edml-page').getAttribute("name"),"other","input: matrix",navitem,exercisename,null);
        }
    }

    initFromSCORM(entrynb){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true && edMLPlayer_Config.get('player.scorm.testonly') != true){  
            let value = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.description');           
            this.setValue(value);       

            if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "failed"){
                this.closest('edml-input').setAttribute('solved','false');
            } else if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "passed"){
                this.closest('edml-input').setAttribute('solved','true');
            }

            edMLPlayer_Functions.changeCredits(-this.lastCredits,false);
            this.lastCredits = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.score.raw');
        }
    }


    clear(){
        this.removeAttribute('solved');
        this.querySelectorAll('edml-number, edml-expression').forEach(function(item){
            item.clear();
        });

        //empty matrix
        let rows = [...this.querySelectorAll(':scope > edml-matrixrow:not(.hidden)')];

        //empty matrix
        for(var i = 0; i < rows.length-1; i++){
            this.removeRow();            
        }

        
        for(var i = 0; i < [...rows[0].querySelectorAll(':scope > *:not(.hidden)')].length-1; i++){
            this.removeCol();
        }
    }
    
}
class edML_Metadata extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["creator","date","description","source","license"]);
      //  this.setAttributeWhitelist(["license"]);
    //    this.setRequiredAttribute(["license"]); 
        this.setOnlyOnceTag("date","info","source"); 

        // conversion edml version 0.1 to 0.2
        if(this.getAttribute('license') != null && this.querySelector(':scope > edml-license') == null){
            let license = new edML_License();
            license.innerText = this.getAttribute('license');
            this.prepend(license);
            this.removeAttribute('license');
            console.warn('edML-Warning: license as attribute is depracted. Use license as tag instead. Autoconversion is done.');
        }      

        //conversion end
        this.check();
        
    }


    getText(){
        let text = '<p><b>'+document.edmllocale.get("dialog_pictureinfo_author")+'</b>:<br/>';
        this.querySelectorAll(':scope > edml-creator').forEach(function(item){
            if(item.getAttribute('url') != null){
                text += '<edml-link to="'+item.getAttribute('url')+'">' + item.innerHTML+'</edml-link><br/>'
            } else {
                text += item.innerHTML+'<br/>';
            }
        });
        text += '</p>';
        
        text += '<p><b>'+document.edmllocale.get("dialog_pictureinfo_license")+'</b>:<br/>';
        if(this.querySelector(':scope > edml-license') != null){
            if(this.querySelector(':scope > edml-license').getAttribute('url')){
                text += '<edml-link to="'+this.querySelector(':scope > edml-license').getAttribute('url')+'">' + this.querySelector(':scope > edml-license').innerHTML + '</edml-link>';
            } else {
                text += this.querySelector(':scope > edml-license').innerHTML;
            }
        }
        text += '</p>';
        
        if(this.querySelector(':scope > edml-source') != null){
            text += '<p><b>'+document.edmllocale.get("dialog_pictureinfo_source")+'</b>:<br/>';
            if(this.querySelector(':scope > edml-source').getAttribute('url')){
                text += '<edml-link to="'+this.querySelector(':scope > edml-source').getAttribute('url')+'">' + this.querySelector(':scope > edml-source').innerHTML + '</edml-link>';
            } else {
                text += this.querySelector(':scope > edml-source').innerText;
            }
            
            
            text += '</p>';
        }


        if(this.querySelector(':scope > edml-description') != null){
            text += '<p><b>'+document.edmllocale.get("dialog_pictureinfo_description")+'</b>:<br/>';
            text += this.querySelector(':scope > edml-description').innerHTML + '</p>'; 
        }
        return text;
    }
}
class edML_Molecular extends edML_Inputvalue{

    static allowedLetter =["(",")","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"];

    constructor(value = null,initialvalue = null){
        super();
        this.setTagWhitelist([""]);        
        this.setAttributeWhitelist(["credits","model"]);
        this.setMixedContent(true); 
        if(value != null) this.innerText = value;        
        if(initialvalue != null) this.initialvalue = initialvalue;       
        this.innerHTML = this.innerText; 
        this.check();

        this.classList.add('unsolved'); 
        
        this.key = new Uint8Array(32);
        for(let i =  0; i < 32; i++){
            this.key[i] = Math.floor(Math.random()*Number.MAX_SAFE_INTEGER);
        }
        let solution =  this.innerText;
        if(solution != null){                 
            let textBytes = aesjs.utils.utf8.toBytes(solution);            
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let encryptedBytes = aesCtr.encrypt(textBytes); 
            let encryptedHex = aesjs.utils.hex.fromBytes(encryptedBytes);
            this.solution = encryptedHex;
            this.innerText = "";
        }


        this.setAttribute('text','');
        
        
        this.setAttribute('tabindex',-1);

    }

    connectedCallback(){
        if(this.connected == null){
            this.connected = true;
            if(this.parentNode.querySelector(':scope > edml-molecular') == this){
                //create GUI objects
                let input = document.createElement('div');
                input.setAttribute('contenteditable','true');
                input.classList.add('edml-molecular-input');   
                if(this.initialvalue != null) {
                    input.innerText = this.initialvalue;
                    this.initialvalue = null;
                }           
                //input.setAttribute('type','number'); //bad, because of digit sparator could be changed

                this.repesentation = input.innerText;
                //Events
                input.addEventListener('keyup',function(evt){
                    //window.setTimeout(this.render(this.getAttribute('text'),10));
                    this.onCheck(evt);   
                    //this.onKeyUp(evt);
                }.bind(this));

                /*input.addEventListener('keydown',function(evt){            
                    if(this.onKeyDown(evt) == false) {                    
                        evt.preventDefault();    
                    }    
                }.bind(this));*/

                input.addEventListener('onkeydown',function(evt){            
                    this.onKeyDown(evt);
                }.bind(this));

                input.addEventListener('input',function(evt){            
                    this.onInput(evt);
                }.bind(this));

                input.setAttribute('tabindex',-1);

                this.append(input);
    
            } else {
                this.classList.add('hidden');
            }
        }
    }



    
    onKeyUp(evt){
        
        

        //check for empty .sub - nodes and delete them, also br
        this.querySelectorAll(':scope > .edml-molecular-input br').forEach(function(item){
            item.remove();
        })

        this.querySelectorAll(':scope > .edml-molecular-input > .sub').forEach(function(item){
            if(item.innerText.length == 0) item.remove();
        })

        
            
        
    }





    onInput(evt){
        //get input value (no html) and insert sub/sup tags
        let pos = edMLPlayer_Util.getCaretPosition(this.querySelector(':scope > .edml-molecular-input'));

        //cut insert key out
        
        let value = this.querySelector(':scope > .edml-molecular-input').innerText.trim();
        value = value.replaceAll('^',"\u2064"); // invisible plus to symbolize sup
        
        let html = "";
        let sub = false;
        let sup = false;
   
        for(let i = 0; i< value.length; i++){
            if(!isNaN(value[i])){
                //digit
                if(value.length != 1){
                    //no leading digit                        
                    if(sub == false && sup == false){
                        html += '<span class="sub">';
                        sub = true;
                    }   
                    html +=  value[i];
                }
            } else if(value[i] == "\u2064") {
                // ^ ; no leading ^                
                if(value.length != 1){
                    if(sub == true){
                        html += '</span>';
                        sub = false;
                    }
                    html += '<span class="sup">\u2064';
                    sup = true;
                    if(i == value.length - 1) {
                        html+= " ";
                        
                    }
                } 
                
            } else if(value[i] == "-" || value[i] == "+"){
                // + -  ; no leading + -
                if(value.length != 1){
                    if(sub == true){
                        html += '</span>';
                    }
                    if(sup == false){
                        html += '<span class="sup">' + value[i] + '</span>';                    
                    } else {
                        html += value[i] + '</span>';
                    }                  
                    sup = false;
                }
            } else {
                if(edML_Molecular.allowedLetter.indexOf(value[i]) > -1)  {
                    // A-Za-z
                    if(sub == true){
                        html += '</span>';
                        sub = false;
                    }
                    if(sup == true){
                        html += '</span>';
                        sup = false;
                    }
                    
                    if(value[i] == "e"){
                        html += value[i];
                    } else if(i == 0){
                        html += value[i].toUpperCase();
                    } else if(edML_Molecular.allowedLetter.indexOf(value[i-1]) == -1){
                        html += value[i].toUpperCase();
                    } else {
                        html += value[i];
                    }
                    
                }
            }
        }
        
        if(sub) html += '</span>';
        if(sup) html += '</span>';
        this.querySelector(':scope > .edml-molecular-input').innerHTML = html;
        if(pos > this.querySelector(':scope > .edml-molecular-input').innerText.length) pos = this.querySelector(':scope > .edml-molecular-input').innerText.length;
        edMLPlayer_Util.setCaretPosition(this.querySelector(':scope > .edml-molecular-input'),pos);
    }


 /*   onKeyDown(evt){
        let lowkey = evt.key.toLowerCase(); 
        let charcode = event.which || event.keyCode;
        console.log(charcode);
        console.log(lowkey);
        if(lowkey == "backspace" || lowkey == "delete" || lowkey == "f5" || lowkey == "arrowleft" || lowkey == "arrowright"){
            return true;
        }

        let anchornode = window.getSelection().anchorNode;
        let tnode = null;
        if(anchornode == this.querySelector(':scope > .edml-molecular-input')) {  //empty input
            tnode = document.createTextNode("");
            anchornode.append(tnode);
            anchornode = tnode;
        }
        if(evt.key != " " && isFinite(evt.key)) {
            
            if((anchornode.nodeType == Node.TEXT_NODE && (!anchornode.parentNode.classList.contains('sub') && !anchornode.parentNode.classList.contains('sup'))) || (anchornode.nodeType != Node.TEXT_NODE && !anchornode.classList.contains('sub'))){
                
                if(anchornode.nodeType != Node.TEXT_NODE) anchornode = anchornode.firstChild;
                let caretpos = edMLPlayer_Util.getCaretPosition(anchornode);
                let innertext = anchornode.textContent.trim();

                if(anchornode.previousSibling != null && anchornode.previousSibling.nodeType != Node.TEXT_NODE && anchornode.previousSibling.classList.contains('sup')) { // avoid C_2^2+_2H
                    return false;
                } 
            
                anchornode.textContent = innertext.substring(0,caretpos);

                //create new nodes
                let sub = document.createElement('span');  // don't use sub. It is memorized by the browser
                sub.classList.add('sub');
                sub.innerText = evt.key;
                anchornode.parentNode.insertBefore(sub,anchornode.nextSibling);
                edMLPlayer_Util.setCaretPosition(sub,1);

                if(innertext.substring(caretpos).length > 0){
                    let textnode = document.createTextNode(innertext.substring(caretpos));
                    anchornode.parentNode.insertBefore(textnode,sub.nextSibling);
                }
                
                if(tnode != null) tnode.remove();
            } else {
                if(anchornode.parentNode.classList.contains('sup') && (anchornode.parentNode.innerText.indexOf("+") > -1 || anchornode.parentNode.innerText.indexOf("-") > -1)){
                    return false;
                } return true;
            }

        
        } else if(edMLPlayer_Util.isLetter(evt.key) || lowkey == "(" || lowkey == ")"){
            if(anchornode.nodeType != Node.TEXT_NODE) anchornode = anchornode.firstChild;
            
            if(anchornode.parentNode.classList.contains('sub') || anchornode.parentNode.classList.contains('sup')){
                if(anchornode.nextSibling == null){
                    let caretpos = edMLPlayer_Util.getCaretPosition(anchornode);
                    let innertext = anchornode.textContent.trim();
                    anchornode.textContent = innertext.substring(0,caretpos);

                    let textnode = document.createTextNode(evt.key);
                    anchornode.parentNode.parentNode.insertBefore(textnode,anchornode.parentNode.nextSibling);

                    let sub = document.createElement('span');  // don't use sub. It is memorized by the browser
                    sub.classList.add('sub');
                    sub.innerText = innertext.substring(caretpos);
                    anchornode.parentNode.parentNode.insertBefore(sub,textnode.nextSibling);

                                        
                    //set cursor
                    var range = document.createRange(),
                    sel = window.getSelection();
                    range.setStart(textnode,1);
                    range.collapse(true);
                    sel.removeAllRanges();
                    sel.addRange(range);
                }

                if(tnode != null) tnode.remove();
            } else {
                return true;
            }

        } else if(((lowkey.substring(0,1) == "^" || lowkey == "dead") && (isFinite(lowkey.substring(1,2)) || lowkey.substring(1,2) == "+" || lowkey.substring(1,2) == "-")) || evt.key == "+" || evt.key == "-"){
            if(anchornode.nodeType != Node.TEXT_NODE) anchornode = anchornode.firstChild;
            let caretpos = edMLPlayer_Util.getCaretPosition(anchornode);                        

            if(anchornode.parentNode.classList.contains('sup')) {
                if(evt.key == "+" || evt.key == "-") return true; else return false; //  sup in sup is forbidden, +/- is okay
            }
        
            let innertext = anchornode.textContent.trim();
        
            
            //shorten node
            anchornode.textContent = innertext.substring(0,caretpos);



            //create new nodes
            let sup = document.createElement('span');  // don't use sup. It is memorized by the browser
            sup.classList.add('sup');
            if(evt.key.length == 2) {
                sup.innerText = evt.key.substring(1,2).trim(); 
            } else if(evt.key == "^"){
                sup.innerText = ""; 
            } else {
                sup.innerText = evt.key;
            }

            if(anchornode.parentNode == this.querySelector(':scope > .edml-molecular-input')){  //anchornode = text
                anchornode.parentNode.insertBefore(sup,anchornode.nextSibling);

                let textnode = document.createTextNode(innertext.substring(caretpos));
                anchornode.parentNode.insertBefore(textnode,sup.nextSibling);
            } else {   // anchornode = subindex 
                anchornode.parentNode.parentNode.insertBefore(sup,anchornode.parentNode.nextSibling);
                anchornode.textContent = innertext    
            }
            
            


            edMLPlayer_Util.setCaretPosition(sup,sup.innerText.length);
            
            if(tnode != null) tnode.remove();
        } 
        
        return false;
    
    }*/




    verify(value, model){
        let solvedobj = new Object();
        solvedobj.solved = false;
        solvedobj.solution = null;
        solvedobj.credits = 0;
        solvedobj.penalty = 0;


        let userinput = this.getText();
        if(value != null) userinput = value;
        let solved = false;
        let solutionobj = null;
        this.parentNode.querySelectorAll(':scope > edml-molecular').forEach(function(item){
            if(item.isSolution(userinput)) {
                solved = true;
                solutionobj = item;
            }
        });

        solvedobj.solved = solved;
        solvedobj.solution = solutionobj; 
        return solvedobj;

    }

    isSolution(value,solution){        
        let userinputobj = this.analyze(value);
        let encryptedBytes = aesjs.utils.hex.toBytes(this.solution);
        let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
        let decryptedBytes = aesCtr.decrypt(encryptedBytes);
        if(solution == null) solution = aesjs.utils.utf8.fromBytes(decryptedBytes); 
        let solutionobj = this.analyze(solution);
        let solved = true;
        let keys = Object.keys(solutionobj);
        
        let i = 0;
        if(keys.length == Object.keys(userinputobj).length){
            while(i < keys.length && solved) {
                if(userinputobj[keys[i]] == undefined || userinputobj[keys[i]] == null || userinputobj[keys[i]] != solutionobj[keys[i]]) {
                    solved = false;                
                }
                i++;
            } 
        } else {
            solved = false;
        }
        return solved;

    }

    setText(value){
        var node = this.querySelector(':scope > .edml-molecular-input');
        node.value = value;   
    }

    getText(){
        let childnodes = this.querySelector(':scope > .edml-molecular-input').childNodes;
        let text = "";
        for(let i = 0; i < childnodes.length; i++){
            if(childnodes[i].nodeType == Node.TEXT_NODE){
                text += childnodes[i].textContent;
            } else if(childnodes[i].classList.contains("sub")){
                text += childnodes[i].innerText;
            } else if(childnodes[i].classList.contains("sup")){
                text += "^" + childnodes[i].innerText;
            }
        }
        text = text.replaceAll('\u2064','');
        return text;
    }

    resolveBrackets(text){
        //convert e.g. (PO4)3 to P3O12
        text = text.replaceAll(/\((.*)\)([0-9]*)/g,this.replaceBrackets.bind(this));
        return text;
    }

    replaceBrackets(arg){
        if(arg.indexOf('(',1) != -1) {
            arg = this.resolveBrackets(arg);
        }

        let factor = 1;
        if(!isNaN(parseInt(arg.substring(arg.indexOf(')')+1)))) factor = parseInt(arg.substring(arg.indexOf(')')+1));
        
        let chemObj = this.analyze(arg.substring(1,arg.indexOf(')')));
        
        let vals = Object.entries(chemObj);

        let newtext = "";
        for(var i = 0; i < vals.length; i++){
            if(vals[i][0] != "charge"){
                newtext += vals[i][0] + (vals[i][1]*factor).toString();
            }
        }
        return newtext;
    }

    analyze(text){
        
        if(text != null){
            text = this.resolveBrackets(text);
            let chemobj = new Object();
            //Atoms 
            let nb;
            let arr = text.matchAll(/(?<atom>[A-Z][a-z]*)(?<stoich>[0-9]*)/g);
            if(arr != null){
                arr = [...arr];
                for(let i = 0; i < arr.length; i++){
                    nb = arr[i].groups.stoich;  // note ` instead of '
                    if(nb == undefined || nb == null || nb == "") nb = 1; else nb = parseInt(nb);
                    if(chemobj[arr[i].groups.atom] == null) {           // note ` instead of '           
                        chemobj[arr[i].groups.atom] = parseInt(nb);     // note ` instead of '
                    } else {
                        chemobj[arr[i].groups.atom] += parseInt(nb);    // note ` instead of '
                    }
                    
                }
            }

            //charges  
            chemobj.charge = 0;
            let factor = 1;
            let value;
            let arr2 = text.match(/\^[0-9]*[+-]/g);
            if(arr2 != null){
                arr2 =[...arr2];
                for(let i = 0; i < arr2.length; i++){
                    if(arr2[i].indexOf("-") > -1) factor = -1;
                    value = arr2[i].replaceAll('+','').replaceAll('-','').replaceAll('^','');
                    if(value.trim() == "") value = 1;
                    value = parseInt(value);
                    chemobj.charge += (factor * value);
                }
            }            
            return chemobj;
        } else return null;
        
    }




  


    getEdML(){
        let text = "";
        if(this.solution != ""){
            let encryptedBytes = aesjs.utils.hex.toBytes(this.solution);
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let decryptedBytes = aesCtr.decrypt(encryptedBytes);
            text = aesjs.utils.utf8.fromBytes(decryptedBytes); 
        }     
        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 

        return '<molecular'+attr+'>' + text + '</molecular>';
    }

    showSolutionhint(){        
        let hint = document.querySelector('edml-variant.active edml-solutionhint[to="'+this.closest('edml-input').getAttribute('name')+'"]');
  
        if(this.querySelector('.edml-solutionhint-btn') == null){
            let btn = document.createElement('span');
            btn.classList.add('edml-solutionhint-btn');
            this.append(btn);
            
            btn.addEventListener('click',function(){
                edML_DialogSolutionhint.show(hint);                
            });
        }   
        
    }


}
class edML_Molecule extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist(["coefficient","fixed"]);
        this.setMixedContent(true); 
        this.innerHTML = this.innerText; 
        this.check();
    }


    getText(){
        return this.innerText.trim();
    }
}

class edML_Matrixrow extends edML_Tag{

    constructor(firstelement=null){
        super();
        this.setTagWhitelist(["number","expression"]);
        this.setAttributeWhitelist(["name"]);
        this.setMixedContent(false);
        this.setRequiredTag([["number","expression"]]);

        if(firstelement instanceof edML_Number || firstelement instanceof edML_Expression){
            this.prepend(firstelement);
        }

        this.check();

        if(this.querySelector(':scope > edml-number') == null && this.querySelector(':scope > edml-expression') == null){
            //no element found --> create one
            this.append(new edML_Number()); 
        }
    }



}
class edML_Navigation extends edML_Tag{


    constructor(){
        super();
        this.setTagWhitelist(["navlist"]);
        this.setAttributeWhitelist(["indent","fullnumbering"]);
        this.setMixedContent(false);  
        this.setRequiredTag(["navlist"]);
        this.setOnlyOnceTag(["navlist"]);              
        this.check();
        this.setAttribute('tabindex',3);
        this.searchDlg = new edML_DialogSearch();
        this.buildNav(); 

        if(edMLPlayer_Config.get("access.level") == 2){
           // this.setAttribute('aria-label',"navigation")
          /* let h1 = document.createElement('h1');
           h1.innerText = document.edmllocale.get("access_navigation_heading");
           this.prepend(h1);*/
        }      
        
        this.addEventListener('keydown',this.onKeyDown.bind(this));
    }
    
    buildNav(){
        if(edMLPlayer_Config.get("navigation.static") == true || edMLPlayer_Config.get("access.level") == 2) {
            this.classList.add('static');
        } else {
            this.classList.remove('static');
        }

        // set active variant
        //if(this.closest('edml-variant[lang="'+edMLPlayer_Config.getCourseLang()+'"]') != null) this.classList.add('active');


        //create navigation toolbar for open/close and if required for editing



        //add toolbar and edit buttons
        let toolbar = document.createElement('div');
        toolbar.classList.add('edml-navigation-toolbar');
        toolbar.setAttribute('role','group');

        let toolbarbtncontainer = document.createElement('div');
        toolbarbtncontainer.classList.add('edml-navigation-btncontainer');
        toolbar.prepend(toolbarbtncontainer);



        if(edMLPlayer_Config.get("navigation.editmode") == true){
            toolbar.classList.add('editmode');
                    //add page button
            toolbar.btnAddPage = document.createElement('button');
            toolbar.btnAddPage.classList.add('edml-navigation-btnAddPage');
            toolbar.btnAddPage.classList.add('edml-navbtn');
            toolbar.btnAddPage.setAttribute('title',document.edmllocale.get('btn_addpage'));
            toolbar.btnAddPageText = document.createElement('span');
            toolbar.btnAddPageText.classList.add('edml-navigation-btnAddPageText');
            toolbar.btnAddPageText.innerText = document.edmllocale.get('btn_addpage');

            toolbar.btnAddPageIcon = document.createElement('span');
            toolbar.btnAddPageIcon.classList.add('edml-navigation-btnAddPageIcon');
            toolbar.btnAddPageIcon.setAttribute('aria-hidden','true');

            toolbar.btnAddPage.append(toolbar.btnAddPageIcon);
            toolbar.btnAddPage.append(toolbar.btnAddPageText);
            
            toolbarbtncontainer.append(toolbar.btnAddPage);

                    // level down button
            toolbar.btnLevelDown = document.createElement('button');
            toolbar.btnLevelDown.classList.add('edml-navigation-btnLevelDown');
            toolbar.btnLevelDown.classList.add('edml-navbtn');
            toolbar.btnLevelDown.setAttribute('title',document.edmllocale.get('btn_leveldown'));
            toolbar.btnLevelDownText = document.createElement('span');
            toolbar.btnLevelDownText.classList.add('edml-navigation-btnLevelDownText');
            toolbar.btnLevelDownText.innerText = document.edmllocale.get('btn_leveldown');

            toolbar.btnLevelDownIcon = document.createElement('span');
            toolbar.btnLevelDownIcon.classList.add('edml-navigation-btnLevelDownIcon');
            toolbar.btnLevelDownIcon.setAttribute('aria-hidden','true');

            toolbar.btnLevelDown.append(toolbar.btnLevelDownIcon);
            toolbar.btnLevelDown.append(toolbar.btnLevelDownText);
            
            
            toolbarbtncontainer.append(toolbar.btnLevelDown);

                    // level up button
            toolbar.btnLevelUp = document.createElement('button');
            toolbar.btnLevelUp.classList.add('edml-navigation-btnLevelUp');
            toolbar.btnLevelUp.classList.add('edml-navbtn');
            toolbar.btnLevelUp.setAttribute('title',document.edmllocale.get('btn_levelup'));
            toolbar.btnLevelUpText = document.createElement('span');
            toolbar.btnLevelUpText.classList.add('edml-navigation-btnLevelUpText');
            toolbar.btnLevelUpText.innerText = document.edmllocale.get('btn_levelup');

            toolbar.btnLevelUpIcon = document.createElement('span');
            toolbar.btnLevelUpIcon.classList.add('edml-navigation-btnLevelUpIcon');
            toolbar.btnLevelUpIcon.setAttribute('aria-hidden','true');

            toolbar.btnLevelUp.append(toolbar.btnLevelUpIcon);
            toolbar.btnLevelUp.append(toolbar.btnLevelUpText);
            
            toolbarbtncontainer.append(toolbar.btnLevelUp);

                    // level left button
            toolbar.btnLevelLeft = document.createElement('button');
            toolbar.btnLevelLeft.classList.add('edml-navigation-btnLevelLeft');
            toolbar.btnLevelLeft.classList.add('edml-navbtn');
            toolbar.btnLevelLeft.setAttribute('title',document.edmllocale.get('btn_levelleft'));
            toolbar.btnLevelLeftText = document.createElement('span');
            toolbar.btnLevelLeftText.classList.add('edml-navigation-btnLevelLeftText');
            toolbar.btnLevelLeftText.innerText = document.edmllocale.get('btn_levelleft');

            toolbar.btnLevelLeftIcon = document.createElement('span');
            toolbar.btnLevelLeftIcon.classList.add('edml-navigation-btnLevelLeftIcon');
            toolbar.btnLevelLeftIcon.setAttribute('aria-hidden','true');

            toolbar.btnLevelLeft.append(toolbar.btnLevelLeftIcon);
            toolbar.btnLevelLeft.append(toolbar.btnLevelLeftText);
            toolbarbtncontainer.append(toolbar.btnLevelLeft);

                    // level right button
            toolbar.btnLevelRight = document.createElement('button');
            toolbar.btnLevelRight.classList.add('edml-navigation-btnLevelRight');
            toolbar.btnLevelRight.classList.add('edml-navbtn');
            toolbar.btnLevelRight.setAttribute('title',document.edmllocale.get('btn_levelright'));
            toolbar.btnLevelRightText = document.createElement('span');
            toolbar.btnLevelRightText.classList.add('edml-navigation-btnLevelRightText');
            toolbar.btnLevelRightText.innerText = document.edmllocale.get('btn_levelright');
            
            toolbar.btnLevelRightIcon = document.createElement('span');
            toolbar.btnLevelRightIcon.classList.add('edml-navigation-btnLevelRightIcon');
            toolbar.btnLevelRightIcon.setAttribute('aria-hidden','true');
            
            toolbar.btnLevelRight.append(toolbar.btnLevelRightIcon);
            toolbar.btnLevelRight.append(toolbar.btnLevelRightText);
            
            toolbarbtncontainer.append(toolbar.btnLevelRight);


            //toolbar events
            toolbar.btnAddPage.addEventListener('click',this.onAddPage.bind(this));
            toolbar.btnLevelDown.addEventListener('click',this.onLevelDown.bind(this));
            toolbar.btnLevelUp.addEventListener('click',this.onLevelUp.bind(this));
            toolbar.btnLevelLeft .addEventListener('click',this.onLevelLeft.bind(this));
            toolbar.btnLevelRight.addEventListener('click',this.onLevelRight.bind(this));

        } else {
            toolbar.btnSearch = document.createElement('button');
            toolbar.btnSearch.setAttribute('title',document.edmllocale.get('btn_search'));
            toolbar.btnSearch.classList.add('edml-navigation-btnSearch');
            toolbar.btnSearch.classList.add('edml-navbtn');
            toolbar.btnSearchText = document.createElement('span');
            toolbar.btnSearchText.classList.add('edml-navigation-btnText');
            toolbar.btnSearchText.innerText = document.edmllocale.get('btn_search');
            
            
            toolbar.btnSearchIcon = document.createElement('span');
            toolbar.btnSearchIcon.classList.add('edml-navigation-btnSearchIcon');
            toolbar.btnSearchIcon.setAttribute('aria-hidden','true');                          
            toolbar.btnSearch.append(toolbar.btnSearchIcon);           
            toolbar.btnSearch.append(toolbar.btnSearchText);                 
            toolbarbtncontainer.append(toolbar.btnSearch);

            if([...this.closest('edml-course').querySelectorAll('edml-variant')].length > 1){
                toolbar.btnLanguage = document.createElement('select');
                toolbar.btnLanguage.setAttribute('title',document.edmllocale.get('toolbar.lang'));
                toolbar.btnLanguage.classList.add('edml-navigation-btnLanguage');
                toolbar.btnLanguage.classList.add('edml-navbtn');
                                

                this.closest('edml-course').querySelectorAll('edml-variant').forEach(function(item){
                    
                    var option = document.createElement('option');
                    option.innerText = item.getAttribute('lang');
                    option.value = item.getAttribute('lang');   
                    toolbar.btnLanguage.append(option);
                    
                    
                }.bind(this));
                
                toolbar.btnLanguage.addEventListener('change',function(){

                    let evt = new Event("edmlevent-changecourselanguage");
                    evt.lang = toolbar.btnLanguage.value;
                    document.dispatchEvent(evt);                                            
                });

                toolbar.btnLanguage.value = this.closest('edml-variant').getAttribute('lang');
                toolbarbtncontainer.append(toolbar.btnLanguage);
               
            }
            
            
            if( edMLPlayer_Config.get('player.accessenabled')){
                toolbar.btnAccess01 = document.createElement('button');
                toolbar.btnAccess01.setAttribute('title',document.edmllocale.get('btn_access01'));
                toolbar.btnAccess01.classList.add('edml-navigation-btnAccess01');
                toolbar.btnAccess01.classList.add('edml-navbtn');
                toolbar.btnAccess01Text = document.createElement('span');
                toolbar.btnAccess01Text.classList.add('edml-navigation-btnText');
                toolbar.btnAccess01Text.innerText = document.edmllocale.get('btn_access01');
                
                toolbar.btnAccess01Icon = document.createElement('span');
                toolbar.btnAccess01Icon.classList.add('edml-navigation-btnAccess01Icon');
                toolbar.btnAccess01Icon.setAttribute('aria-hidden','true');
                toolbar.btnAccess01.append(toolbar.btnAccess01Icon);
                toolbar.btnAccess01.append(toolbar.btnAccess01Text);
                toolbarbtncontainer.append(toolbar.btnAccess01);
            
                toolbar.btnAccess02 = document.createElement('button');
                toolbar.btnAccess02.setAttribute('title',document.edmllocale.get('btn_access02'));
                toolbar.btnAccess02.classList.add('edml-navigation-btnAccess02');
                toolbar.btnAccess02.classList.add('edml-navbtn');
                toolbar.btnAccess02Text = document.createElement('span');
                toolbar.btnAccess02Text.classList.add('edml-navigation-btnText');
                toolbar.btnAccess02Text.innerText = document.edmllocale.get('btn_access02');
        

                toolbar.btnAccess02Icon = document.createElement('span');
                toolbar.btnAccess02Icon.classList.add('edml-navigation-btnAccess02Icon');
                toolbar.btnAccess02Icon.setAttribute('aria-hidden','true');            
                toolbar.btnAccess02.append(toolbar.btnAccess02Icon);
                toolbar.btnAccess02.append(toolbar.btnAccess02Text);
                toolbarbtncontainer.append(toolbar.btnAccess02);
            }

            toolbar.btnAccess03 = document.createElement('button');
            toolbar.btnAccess03.setAttribute('title',document.edmllocale.get('btn_access03'));
            toolbar.btnAccess03.setAttribute('aria-label',document.edmllocale.get('btn_access03'));
            toolbar.btnAccess03.classList.add('edml-navigation-btnAccess03');
            toolbar.btnAccess03.classList.add('edml-navbtn');
            
            toolbar.btnAccess03Icon = document.createElement('span');
            toolbar.btnAccess03Icon.classList.add('edml-navigation-btnAccess03Icon');
            toolbar.btnAccess03Icon.setAttribute('aria-hidden','true'); 
            toolbar.btnAccess03.append(toolbar.btnAccess03Icon); 
            toolbarbtncontainer.append(toolbar.btnAccess03);  
            
            toolbar.btnAccess04 = document.createElement('button');
            toolbar.btnAccess04.setAttribute('title',document.edmllocale.get('btn_access04'));
            toolbar.btnAccess04.setAttribute('aria-label',document.edmllocale.get('btn_access04'));
            toolbar.btnAccess04.classList.add('edml-navigation-btnAccess04');
            toolbar.btnAccess04.classList.add('edml-navbtn');
            
            toolbar.btnAccess04Icon = document.createElement('span');
            toolbar.btnAccess04Icon.classList.add('edml-navigation-btnAccess04Icon');
            toolbar.btnAccess04Icon.setAttribute('aria-hidden','true'); 
            toolbar.btnAccess04.append(toolbar.btnAccess04Icon); 
            toolbarbtncontainer.append(toolbar.btnAccess04);  
            
            //events
            toolbar.btnSearch.addEventListener('click',this.onSearch.bind(this));
            if( edMLPlayer_Config.get('player.accessenabled')){
                toolbar.btnAccess01.addEventListener('click',this.onBlindUser.bind(this));
                toolbar.btnAccess02.addEventListener('click',this.onVisualImpaired.bind(this));            
            }
            toolbar.btnAccess03.addEventListener('click',this.onIncreaseFontSize.bind(this));
            toolbar.btnAccess04.addEventListener('click',this.onDecreaseFontSize.bind(this));
        
            
    
        }

        let toolbarminmaxcontainer = document.createElement('div');
        toolbarminmaxcontainer.classList.add('edml-navigation-minmaxcontainer');
        

        // min navigation button
        toolbar.btnMin = document.createElement('div');
        toolbar.btnMin.classList.add('edml-navigation-btnMin');
        toolbarminmaxcontainer.prepend(toolbar.btnMin);


                // max navigation button
        toolbar.btnMax = document.createElement('div');
        toolbar.btnMax.classList.add('edml-navigation-btnMax');
        toolbarminmaxcontainer.prepend(toolbar.btnMax);
        toolbar.append(toolbarminmaxcontainer);

        toolbar.btnMin.addEventListener('click',this.hide.bind(this));
        toolbar.btnMax.addEventListener('click',this.show.bind(this));

        // fixed navigation
        toolbar.btnFixed = document.createElement('div');
        toolbar.btnFixed.classList.add('edml-navigation-btnFixed');
        toolbarminmaxcontainer.prepend(toolbar.btnFixed);
        toolbar.append(toolbarminmaxcontainer);

        toolbar.btnFixed.addEventListener('click',function(){this.classList.toggle("fixed")});

        if(this.querySelector(':scope > edml-navigation-toolbar') == null){
            this.prepend(toolbar);
        }


        //Headings for blind users, remove toolbar, aria, ect.
        if(edMLPlayer_Config.get("access.level") == 2){
            /*let heading = document.createElement('h1');
            heading.innerText = document.edmllocale.get('access_navigation_heading');
            this.prepend(heading);*/
            toolbar.classList.add('hidden');

            this.setAttribute('role','navigation');
           // this.setAttribute('aria-label',document.edmllocale.get('access_navigationlabel'));
            
        }
        


        window.setTimeout(function(){
            if(this.closest('edml-course').offsetWidth < 1500) {
                this.hide(); 
            } else {
                //toolbar.btnFixed.classList.add('hide');
                this.show();
            }
        }.bind(this),500);


       //this.refreshNumbering();

    }

    /* SETTER */


    setStatic(bool){
        edMLPlayer_Config.set("navigation.static",bool);

    }


    setEditMode(bool){
        let nav = document.querySelector('edml-navigation.active');
        if(bool){
            nav.querySelector('.edml-navigation-btnAddPage').style.display = 'inline-block';
            nav.querySelector('.edml-navigation-btnLevelDown').style.display = 'inline-block';
            nav.querySelector('.edml-navigation-btnLevelUp').style.display = 'inline-block';
            nav.querySelector('.edml-navigation-btnLevelLeft').style.display = 'inline-block';
            nav.querySelector('.edml-navigation-btnLevelRight').style.display = 'inline-block';
        } else {
            nav.querySelector('.edml-navigation-btnAddPage').style.display = 'none';
            nav.querySelector('.edml-navigation-btnLevelDown').style.display = 'none';
            nav.querySelector('.edml-navigation-btnLevelUp').style.display = 'none';
            nav.querySelector('.edml-navigation-btnLevelLeft').style.display = 'none';
            nav.querySelector('.edml-navigation-btnLevelRight').style.display = 'none';
        }
    }

    setDisabled(bool){
        if(bool == true) {
            this.classList.add('disabled');
        } else {
            this.classList.remove('disabled');            
        }
    }


    /* GETTER */

    getAscPath(){
        return this.getAscPathInner(this.navigation, "00000");

    }

    getAscPathInner(node,ascpath){
        let arr = new Array();
        for(let i = 0; i < node.childNodes.length;i++){
            if(node.childNodes[i].nodeName.toLowerCase() == "navitem"){
                let innerarr = new Array();
                innerarr.push(node.childNodes[i].getAttribute('name'));
                ascpath = this.incrementAscPath(ascpath);
                innerarr.push(ascpath);
                arr.push(innerarr);
                if(node.childNodes[i].querySelector('edml-navitem') != null){
                    arr.concat(node.childNodes[i],getAscPathInner,ascpath+",00000");
                }
            }

        }
        return arr;
    }




    getNavItemEdML(edml, node){
        if(node != null && node.children != null){
            for(let i = 0; i < node.children.length; i++){
                if(node.children[i].tagName.toLowerCase() != "edml-navitem"){
                    edml += '<navitem'+ this.getAttributeString(node.children[i]) + '>';
                    edml = this.getNavItemEdML(edml, node.children[i]);
                    edml += '</navitem>';
                } else if(node.children[i].querySelector(':scope > edml-ref') != null){
                    edml += '<title' + this.getAttributeString(node.children[i]) + '>';
                    edml += node.children[i].innerText;
                    edml += '</title>';
                }
            }

        }
        return edml;
    }

    getAttributeString(node){
        let s = "";
        for(let i = 0; i < node.attributes.length; i++){
            if(node.attributes[i].nodeName != "class" && node.attributes[i].nodeName != "style") s += " " + node.attributes[i].nodeName + '="' + node.attributes[i].value + '"';
        }
        return s;
    }

    incrementAscPath(ascpath){
        let s = ascpath.split(',');
        if(s.length > 0){

            let nb = parseInt(s[s.length-1]);
            nb++;
            let out = "";
            for(let i = 0; i < s.length-1; i++){
                out += s[i] + ",";
            }
            out += nb.toString().padStart(5,'0');
            return out;
        } else return ascpath;
    }

    addNavitem(navitem,selected){
        selected.parentNode.insertBefore(navitem,selected.nextSibling);
        this.refresh();
    }

    refresh(){
        if(document.querySelector('edml-navigation.active') != null) {
            document.querySelector('edml-navigation.active').querySelectorAll('edml-navitem').forEach(function(item){
                item.removeEventListener('click',this.onClickNavitemEvt); //click event navitem
                item.addEventListener('click',this.onClickNavitemEvt); //click event navitem
            }.bind(this));
        }
    }

    refreshNumbering(){


        this.querySelectorAll('edml-navigation.active edml-navlist').forEach(function(item){   
            item.numberList();
            item.setIndent();
            
        });

       

       /* let topitem;
        let index = new Array();
        let numberingArr = this.numbering.split(' ');
        for(let i = 0; i< 20; i++){
            index.push(0);
        }

        let level = 0;
        let number = "";
        let letterArr = ["","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"];
        let gletterArr = ["","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];

        this.querySelectorAll(':scope edml-navitem:not([visible="false"])').forEach(function(item){

            level = 0;
            topitem = item.parentNode.closest('edml-navitem');
            while(topitem != null){
                topitem = topitem.parentNode.closest('edml-navitem');
                level++;
            }

            number = "";
            let numbering = null;
            if(item.querySelector('.edml-navigation-numbering') == null){
                numbering = document.createElement('span');
                numbering.classList.add('edml-navigation-numbering');
                item.prepend(numbering);
            } else {
                numbering = item.querySelector('.edml-navigation-numbering');
            }
            if(level < numberingArr.length){
                for(let i = 0; i <= level; i++){
                    if(i == level) {
                        index[i]++;
                        for(let j = i+1; j < numberingArr.length; j++){
                            index[j] = 0;
                        }
                    }
                    if(numberingArr[i] == "arabic"){
                        number += index[i] + ".";
                    }

                    if(numberingArr[i] == "roman"){
                        number += edML_Arabic2Roman.toRoman(index[i]) + ".";
                    }

                    if(numberingArr[i] == "letter"){
                        for(let k = 0; k <= Math.floor(index[i]/letterArr.length); k++)
                        {
                            number += letterArr[index[i]-(k*letterArr.length)];
                        }
                        number += ".";
                    }

                    if(numberingArr[i] == "Letter"){
                        for(let k = 0; k <= Math.floor(index[i]/gletterArr.length); k++)
                        {
                            number += gletterArr[index[i]-(k*gletterArr.length)];
                        }
                        number += ".";
                    }
                }
            }
            if(number.indexOf(".") != number.lastIndexOf(".")) number = number.substring(0,number.length-1);
            numbering.innerText = number;
        }.bind(this));   */
    }

    setToolbarEditMode(val){
        let toolbar = document.querySelector('.edml-navigation-toolbar');
        if(val == true){
            this.toolbar.btnLevelLeft.style.display = 'inline-block';
            this.toolbar.btnLevelRight.style.display = 'inline-block';
            this.toolbar.btnLevelUp.style.display = 'inline-block';
            this.toolbar.btnLevelDown.style.display = 'inline-block';
            this.toolbar.btnAddPage.style.display = 'inline-block';
        } else {
            this.toolbar.btnLevelLeft.style.display = 'none';
            this.toolbar.btnLevelRight.style.display = 'none';
            this.toolbar.btnLevelUp.style.display = 'none';
            this.toolbar.btnLevelDown.style.display = 'none';
            this.toolbar.btnAddPage.style.display = 'none';
        }
    }

    setNumbering(configstring){
        this.numbering = configstring;
    }





    show(){
        this.classList.remove('hide');
        this.classList.add('show');
        this.querySelector('.edml-navigation-btnMin').classList.remove('hide');
        this.querySelector('.edml-navigation-btnMin').classList.add('show');
        this.querySelector('.edml-navigation-btnMax').classList.remove('show');
        this.querySelector('.edml-navigation-btnMax').classList.add('hide');
        let titlebar = this.closest('edml-course').querySelector('.edmlplayer-titlebar');
        let titlebarpx = 0;
        if(titlebar != null) titlebarpx = titlebar.offsetHeight;
        //this.style.height = (this.closest('edml-variant').offsetHeight-this.getBoundingClientRect().top)+"px";  //
        //this.style.maxHeight = null;
        if(edMLPlayer_Config.get("navigation.static") == true) {
            //this.style.maxHeight = (this.offsetHeight+document.querySelector('#edml-arrowbar').offsetHeight-titlebarpx)+"px";
           // this.style.height = (this.closest('edml-variant').offsetHeight)+"px";
            document.querySelector('#edml-arrowbar').classList.add('static');

        }


        this.closest('edml-variant').querySelector('edml-pages').classList.add('navextended');

        let event = new Event('edmlevent-shownavigation');
        event.navigation = this;
        window.dispatchEvent(event);




    }

    hide(){
        this.classList.remove('show');
        this.classList.add('hide');
        this.querySelector('.edml-navigation-btnMin').classList.remove('show');
        this.querySelector('.edml-navigation-btnMin').classList.add('hide');
        this.querySelector('.edml-navigation-btnMax').classList.remove('hide');
        this.querySelector('.edml-navigation-btnMax').classList.add('show');
        this.style.maxHeight = "1.5em";
        if(edMLPlayer_Config.get("navigation.static") == true) {
            document.querySelector('#edml-arrowbar').classList.remove('static');
        }

        this.closest('edml-variant').querySelector('edml-pages').classList.remove('navextended');

        let event = new Event('edmlevent-hidenavigation');
        event.navigation = this;
        window.dispatchEvent(event);

    }

    isOpen(){
        console.error(this);
        return this.classList.contains('show');
    }
    
    //Events
    onSearch(evt){  
        this.searchDlg.show();
    }

    onIncreaseFontSize(){
        let fontsize = parseFloat(window.getComputedStyle(document.querySelector('edml-course'), null).getPropertyValue('font-size'));                
        edMLPlayer_Config.set('player.fontsize',edMLPlayer_Config.get('player.fontsize') + 2);
        document.querySelector('edml-course').style.fontSize = (fontsize + 2) + "px";
        UnitCalculator.positioning();
        this.closest('edml-course').querySelectorAll('edml-page.active edml-picture').forEach(function(item){
            item.resize();
        });
        this.closest('edml-course').querySelectorAll('edml-page.active edml-choice').forEach(function(item){
            item.resize();
        });
    }

    onDecreaseFontSize(){
        let fontsize = parseFloat(window.getComputedStyle(document.querySelector('edml-course'), null).getPropertyValue('font-size'));                
        document.querySelector('edml-course').style.fontSize = (fontsize - 2) + "px";
        edMLPlayer_Config.set('player.fontsize',edMLPlayer_Config.get('player.fontsize') - 2);
        UnitCalculator.positioning();
        console.log(this.closest('edml-course').querySelector('edml-page.active'));
        this.closest('edml-course').querySelectorAll('edml-page.active edml-picture').forEach(function(item){
            item.resize();
        })
        this.closest('edml-course').querySelectorAll('edml-page.active edml-choice').forEach(function(item){
            item.resize();
        });
    }



    onAddPage(evt){
        let evt2 = new Event('edmlevent-newpage');
        evt2.container = evt.target;
        evt2.selected =  document.querySelector('edml-navigation.active').querySelector('edml-navitem.selected');
        document.dispatchEvent(evt2);
    }

    onLevelDown(evt){
        let selected =  document.querySelector('edml-navigation.active').querySelector('edml-navitem.selected');
        let prev = selected.previousElementSibling;
        while(prev != null && prev.tagName.toLowerCase() != "edml-navitem"){
            prev = prev.previousElementSibling;
        }


        let next = selected.nextElementSibling;
        while(next != null && next.tagName.toLowerCase() != "edml-navitem"){
            next = next.nextElementSibling;
        }

        let evt2 = new Event('edmlevent-navchange');
        evt2.navtype = "down";
        evt2.prev = prev;
        evt2.next = next;
        evt2.container = selected;


        if(next != null) selected.parentNode.insertBefore(next,selected);
        document.dispatchEvent(evt2);
        this.refreshNumbering();

    }

    onLevelUp(evt){
        let selected =  document.querySelector('edml-navigation.active').querySelector('edml-navitem.selected');
        let prev = selected.previousElementSibling;
        while(prev != null && prev.tagName.toLowerCase() != "edml-navitem"){
            prev = prev.previousElementSibling;
        }

        let next = selected.nextElementSibling;
        while(next != null && next.tagName.toLowerCase() != "edml-navitem"){
            next = next.nextElementSibling;
        }

        let evt2 = new Event('edmlevent-navchange');
        evt2.navtype = "up";
        evt2.prev = prev;
        evt.next = next;
        evt2.container = selected;

        if(prev != null) selected.parentNode.insertBefore(selected, prev);


        document.dispatchEvent(evt2);
        this.refreshNumbering();
    }

    onLevelLeft(evt){
        let selected =  document.querySelector('edml-navigation.active').querySelector('edml-navitem.selected');
        let prev = selected.closest('edml-navlist').closest('edml-navitem');
        let parent = null;
            
        if(prev != null){
            parent = prev.closest('edml-navlist');
            if(parent != null){
                parent.insertBefore(selected,prev.nextElementSibling);    
            }                                      
        }
        
        
        
        
        let evt2 = new Event('edmlevent-navchange');
        evt2.navtype = "left";
        evt2.parent = parent;
        evt2.prev = prev;
        evt2.container = selected;
        document.dispatchEvent(evt2);
        this.refreshNumbering();
    }

    onLevelRight(evt){
        let selected =  document.querySelector('edml-navigation.active').querySelector('edml-navitem.selected');     
        let prev = selected.previousElementSibling;
        let parent = null;
        if(prev != null){
            if(prev.querySelector(":scope > edml-navlist") != null){
                parent = prev.querySelector(":scope > edml-navlist");                            
            } else {
                parent = document.createElement('edml-navlist');
                prev.append(parent);            
            }
            parent.append(selected);
        }                     

        
        //let parent = selected.closest('edml-navlist').parentNode.closest('edml-navlist');
           
        
        
        let evt2 = new Event('edmlevent-navchange');
        evt2.navtype = "right";
        evt2.parent = parent;
        evt2.prev = prev;
        evt2.container = selected;
        document.dispatchEvent(evt2);
        this.refreshNumbering();

    }

    onVisualImpaired(){
        if(window.location.search.length == 0){
            window.location.href = window.location.href + "?access=3";
        } else if(window.location.search.substring(1).indexOf("access=") == -1){
            window.location.href = window.location.origin + window.location.pathname + "?" +window.location.search.substring(1) + "&access=3";  
        } else {
            let gets = window.location.search.substring(1).split("&");
            let ref = "";
            for(let i = 0; i < gets.length;i++){
                if(gets[i].indexOf("access=") == -1) {
                    ref += "&" + gets[i];
                } else {
                    ref += "&access=3";
                }
            }
            window.location.href = window.location.origin + window.location.pathname + "?" + ref.substring(1);
        }
        

    }

    onBlindUser(){
        if(window.location.search.length == 0){
            window.location.href = window.location.href + "?access=2";
        } else if(window.location.search.substring(1).indexOf("access=") == -1){
            window.location.href = window.location.origin + window.location.pathname + "?" +window.location.search.substring(1) + "&access=2";  
        } else {
            let gets = window.location.search.substring(1).split("&");
            let ref = "";
            for(let i = 0; i < gets.length;i++){
                if(gets[i].indexOf("access=") == -1) {
                    ref += "&" + gets[i];
                } else {
                    ref += "&access=2";
                }
            }
            window.location.href = window.location.origin + window.location.pathname + "?" + ref.substring(1);
        }
    }





    onKeyDown(evt){
        console.log(evt.key);
        if(evt.key == "+"){
            console.log(document.activeElement);
        }
    }


}
    
class edML_Navitem extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["ref","link","navlist","title"]);
        this.setAttributeWhitelist(["name","tags","visible","roles","label","numbered","difficulty","learnpathinfo"]);
        this.setMixedContent(false);
        this.setOnlyOnceTag(["ref","link","navlist","title"]);
        //this.setRequiredTag([["ref", "link","title"]]);
        this.check();
        //aria
        this.setAttribute('role','navigation');
        
        //event initiliasation
        this.onClickNavitemEvt = this.onClickNavitem.bind(this);
        this.clickcounter = 0;

        
        
        //this.removeEventListener('click',this.onClickNavitemEvt);
        this.addEventListener('click',this.onClickNavitemEvt);
      
        this.onHoverEvt = this.onHover.bind(this);
        this.addEventListener('mouseover',this.onHoverEvt);

        this.onHoverExitEvt = this.onHoverExit.bind(this);
        this.addEventListener('mouseleave',this.onHoverExitEvt);

        this.setAttribute('navindex',edMLPlayer_Functions.getNextNavindex());
        
        this.refresh();
        
        
        //For blind users aria, etc.
        if(edMLPlayer_Config.get("access.level") == 2){   
            this.setAttribute('role','link');
            this.addEventListener("keydown", this.onKeyDownAccess02.bind(this)); 
            this.setAttribute('tabindex',0);
            this.setAttribute('aria-label',this.querySelector('edml-ref, edml-link,edml-title').innerText);                      
        }

        
              
        if(this.getAttribute('roles') == "impressum" && this.querySelector(':scope > edml-ref') != null){
            var refImpressum = new edML_Ref(this.querySelector(':scope > edml-ref').getAttribute('to'),document.edmllocale.get('footer.impressum'));
            refImpressum.classList.add('edmlplayer-refimpressum');
            refImpressum.setAttribute('lang',this.closest('edml-variant').getAttribute('lang'));
            if(edMLPlayer_Config.get("course.lang") != this.closest('edml-variant').getAttribute('lang')) refImpressum.classList.add('hidden');
            document.querySelector('.edmlplayer-footer').append(refImpressum);
        }

        if(this.getAttribute('roles') == "privacy" && this.querySelector(':scope > edml-ref') != null){
            var refPrivacy = new edML_Ref(this.querySelector(':scope > edml-ref').getAttribute('to'),document.edmllocale.get('footer.privacy'));
            refPrivacy.classList.add('edmlplayer-refprivacy');
            refPrivacy.setAttribute('lang',this.closest('edml-variant').getAttribute('lang'));
            if(edMLPlayer_Config.get("course.lang") != this.closest('edml-variant').getAttribute('lang')) refPrivacy.classList.add('hidden');
            document.querySelector('.edmlplayer-footer').append(refPrivacy);
        }
          
        
    }
    


    refresh(){    
        let ref = this.querySelector(':scope > edml-ref');
        let activedepth = edMLPlayer_Config.get("navigation.depth");
        let depth;

        //learnpath?
        if(this.getAttribute('roles') != null && this.getAttribute('roles').toLowerCase().split(' ').indexOf('learnpath') > -1 && edMLPlayer_Config.get('navigation.shortenlearnpath') == true){
            this.classList.add('learnpath');
        }

        //chevron
        if(this.querySelector('edml-navitem') != null){
            depth = this.getNavDepth();            
            if(this.querySelector(':scope > edml-navlist').getAttribute('open') == "true") depth = -10;
            if(this.querySelector(':scope > edml-navlist').getAttribute('open') == "false") depth = 100000000;
            if(depth <= activedepth) this.classList.add('open'); else this.classList.add('close');
            if(this.querySelector(':scope > .edml-navlist-chevron') == null) {
                let chevron = document.createElement('span');
                chevron.classList.add('edml-navlist-chevron');            
                chevron.classList.add('active');
                chevron.setAttribute('role','button');
                chevron.setAttribute('aria-label','expand');
                chevron.setAttribute('tabindex',0);
           
                this.prepend(chevron);

                chevron.addEventListener('click',function(event){  //chevron click
                    event.stopPropagation();
                    if(this.parentNode.classList.contains("open")){
                        this.parentNode.classList.remove("open");
                        this.parentNode.classList.add('close');
                    } else {
                        this.parentNode.classList.remove("close");
                        this.parentNode.classList.add("open");
                    }
                });
            }

        } 
        
        //move ref to top
        if(ref != null){
            this.prepend(ref);
        } 
        
        if(this.querySelector(':scope > edml-title') != null){
            this.prepend(this.querySelector(':scope > edml-title'));
        }
        
        //move edml-navitem-label to top
        if(this.querySelector(':scope > .edml-navitem-label') != null) this.prepend(this.querySelector(':scope > .edml-navitem-label'));

        //move edml-difficultysign to bottom
        if(this.querySelector(':scope > .edml-difficultysign') != null) this.prepend(this.querySelector(':scope > .edml-difficultysign'));

        // ==> order: label ref difficulty

        let level = parseInt(this.getAttribute('difficulty'));
        if(level != NaN && level > 0){
            let diff = "";
            for(let i = 0; i < level; i++) {
                diff += "q";
            }
            if(this.querySelector('.edml-difficultysign') == null) {
                let span = document.createElement('span');
                span.classList.add('edml-difficultysign');
                this.querySelector('edml-ref, edml-link, edml-title').after(span);            
            }
            this.querySelector('.edml-difficultysign').innerText = ""+diff+"";
        } 

        if(this.getAttribute('visible') != null && this.getAttribute('visible') == "false") this.classList.add('hidden');
            
    }

    getNavDepth(){
        let navitem = this;
        let depth = 1;
        while(navitem.parentNode.closest('edml-navitem') != null && depth < 100){
            depth++;
            navitem = navitem.parentNode.closest('edml-navitem');
        }
        return depth;
    }
    
        //events
    onClickNavitem(evt){        
        evt.stopPropagation();

        if(this.clicktimer != null) clearTimeout(this.clicktimer);
        this.clickcounter++;
        let event = evt;
        if(this.closest('edml-variant.active') != null && this.closest('edml-variant.active').querySelector('edml-navigation.disabled') == null){ // only when navigation is not disabled and variant is active, click events will be fired
            setTimeout(function(){if(this.clickcounter == 1) this.onClickNavitemDo(event); if(this.clickcounter > 1) this.onDblClickNavitem(event);this.clickcounter = 0;}.bind(this),280);
        }
        
        if(window.innerWidth < 1550 && !this.closest('edml-variant').querySelector('edml-navigation .edml-navigation-btnFixed').classList.contains('fixed')){  // screen width vs viewport width ?
            this.closest('edml-variant').querySelector('edml-navigation').hide();   
        }      

    }

    onClickNavitemDo(evt){        
        //single click
        //evt.stopPropagation();
        let obj = evt.container;
        if(obj == null) obj = evt.target;
        
               
        let event = new Event('edmlevent-changepage');
        event.navitem = obj.closest('edml-navitem');    //navitem to select
        event.page = null;                              // page to open
        event.container = null;                         // container to move the focus on page
        event.reftype = null;
        event.history = true;
        
        
        let found = false; 
        let toobj = null;   
        let to = "";
        let n = 0;

        while(n < 100 && event.navitem != null && found == false){
            //toobj = document.querySelector('edml-variant.active *[name="'+to+'"]');
            if(event.navitem.querySelector(':scope > edml-link') != null ){
                event.reftype = "link";        
            } else if(event.navitem.querySelector(':scope > edml-title') != null){
                event.reftype = "title";
            } else if(event.navitem.querySelector(':scope > edml-ref') != null ){
                to = event.navitem.querySelector(':scope > edml-ref').getAttribute('to');
                toobj = this.closest("edml-variant").querySelector('*[name="'+to+'"]');
                if(toobj instanceof edML_Navitem){
                    event.navitem = toobj;
                } else if(toobj instanceof edML_Page){
                    found = true;
                    event.page = toobj;
                    event.container = null;
                } else if(toobj instanceof edML_Test){
                    found = true;
                    event.test = toobj; 
                    event.reftype = "test";           
                } else {
                    if(toobj != null && toobj.closest('edml-page') != null){
                        found = true;
                        event.page = toobj.closest('edml-page');
                        event.container = toobj;
                    } else if(toobj != null && toobj.closest('edml-test') != null){
                        found = true;
                        event.test = toobj.closest('edml-test'); 
                        event.reftype = "test";   
                    } else {
                        event.navitem = null; // reference to a not displayable tag
                    }
                }
            } else {
                event.navitem = null; // no reference
            }
            n++;
        }
        
        if(event.navitem != this.closest('edml-variant').querySelector('edml-navitem.selected') || event.navitem == null){
            

            //fire event
          //  if(event.navitem != null) event.navitem.style.minWidth = (event.navitem.closest('edml-navlist').offsetWidth+24)+"px";
            if(this.closest('edml-variant').querySelector('edml-navitem.selected') != null) this.closest('edml-variant').querySelector('edml-navitem.selected').classList.remove('selected');
            document.dispatchEvent(event);    //should be last!

            


        } else if(obj.closest('edml-navitem') == this.closest('edml-variant').querySelector('edml-navitem.selected')){
            //navitem is already selected -> expand it, if possible
            if(event.navitem.querySelector(':scope > .edml-navlist-chevron') != null){
                event.navitem.querySelector(':scope > .edml-navlist-chevron').click();
            }

        }      
    }

    onDblClickNavitem(evt){
        evt.stopPropagation();
        let obj = evt.container;
        if(obj == null) obj = evt.target;
        obj = obj.closest('edml-navitem');
        let navid = obj.getAttribute('name');
        let event = new Event('edmlevent-dblclicknavitem');
        event.reftype = "undefined";
        event.to = null;
        if(obj.querySelector(':scope > edml-ref') != null ) {
            event.reftype = obj.querySelector(':scope > edml-ref').getAttribute('type');
            event.to = obj.querySelector(':scope > edml-ref').getAttribute('to');
        } 
        event.container = obj;
        event.navid = navid;                
        document.dispatchEvent(event);
    }
    
    resetClick(){
        this.clickcounter = 0;
    }
    
    //override
    /*getEdML(){
        let node = this;
        let edml = "";

        edml += '<' + node.tagName.toLowerCase().replace('edml-','');
        if(node.getAttribute('name') != null) edml += ' name="'+node.getAttribute('name') + '"';
        if(node.getAttribute('roles') != null) edml += ' roles="'+node.getAttribute('roles') + '"';
        if(node.getAttribute('visible') != null) edml += ' visible="'+node.getAttribute('visible') + '"';
        if(node.getAttribute('numbered') != null) edml += ' numbered="'+node.getAttribute('numbered') + '"';
        if(node.getAttribute('label') != null) edml += ' label="'+node.getAttribute('label') + '"';
        if(node.getAttribute('showlabel') != null) edml += ' showlabel="'+node.getAttribute('showlabel') + '"';
        edml += '>';
        let cnode;
        if(node.querySelector(':scope > edml-navref') != null) {
            cnode =  node.querySelector(':scope > edml-navref').cloneNode(true);
            if(cnode.querySelector('.edml-navlist-chevron') != null) cnode.querySelector('.edml-navlist-chevron').remove();
            edml += '<navref to="'+cnode.getAttribute('to')+'">'+ cnode.getEdML() +'</navref>';
        } else if(node.querySelector(':scope > edml-pageref') != null) {
            cnode =  node.querySelector(':scope > edml-pageref').cloneNode(true);
            if(cnode.querySelector('.edml-navlist-chevron') != null) cnode.querySelector('.edml-navlist-chevron').remove();
            edml += '<pageref to="'+cnode.getAttribute('to')+'">'+ cnode.getEdML() +'</pageref>';
        } else if(node.querySelector(':scope > edml-link') != null) {
            cnode =  node.querySelector(':scope > edml-link').cloneNode(true);
            if(cnode.querySelector('.edml-navlist-chevron') != null) cnode.querySelector('.edml-navlist-chevron').remove();
            edml += '<link to="'+cnode.getAttribute('to')+'">'+ cnode.getEdML() +'</link>';
        }

        

         //   console.log(node.outerHTML.substring(0,node.outerHTML.indexOf('>')+1))       
        let nodes = [...node.querySelectorAll(':scope > edml-navitem')];      
        for(let i = 0 ; i < nodes.length; i++){
            if(nodes[i].tagName.toLowerCase() == "edml-navitem" ){
                edml += nodes[i].getEdML();
            } else {
            }
        }

        edml += '</' + node.tagName.toLowerCase().replace('edml-','') + '>';;


        return edml;
    }   */
    
    onHover(evt){
        evt.stopPropagation();
        document.querySelectorAll('edml-navitem.hover').forEach(function(item){
            item.classList.remove('hover');
        });
        this.classList.add('hover');
        
    }
    
    onHoverExit(evt){
        this.closest('edml-navlist').querySelectorAll('edml-navitem').forEach(function(item){
            item.classList.remove('hover');
        });
    }

    onKeyDownAccess02(evt){
        if(evt.key === "Enter") {
            
        }

        if(evt.key.toLowerCase() === "arrowdown") {
            this.nextElementSibling.focus();   
        }
        //console.log(evt.key);
        


    }


}
class edML_Navlist extends edML_Tag{

    static formatValues = ["arabic","bullet","dash","dot","greek","letter","Letter","none","roman","Roman"];
    static arrletter = ["a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"];
    static arrLetter = ["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];
    static arrgreek = ["α","β","γ","δ","ε","ζ","η","θ","ι","κ","λ","μ","ν","ξ","ο","π","ρ","σ","τ","υ","φ","χ","ψ","ω"];
    static arrGreek = ["Α","Β","Γ","Δ","Ε","Ζ","Η","Θ","Ι","Κ","Λ","Μ","Ν","Ξ","Ο","Π","Ρ","Σ","Τ","Υ","Φ","Χ","Ψ","Ω"];
    
    constructor(navitem = null){    
        super();  
        this.setTagWhitelist(["navitem"]);
        this.setAttributeWhitelist(["format","separator","lastsep","xml:base","xml:id","open"]);
        this.setMixedContent(false);
        this.setRequiredTag([["navitem"]]);
        if(navitem != null){
            this.append(navitem);
        }
        this.check();  
        this.connected = false;   
        
        //aria
        this.setAttribute('role','navlist');   
                        
    }

    connectedCallback(){
        //generate numbering first time only
        if(this.connected == false) {
            this.numberList();
            this.connected = true;  
            this.closest('edml-variant').classList.add('forceshow');
            this.setIndent();
            this.closest('edml-variant').classList.remove('forceshow');
        }  

    }

    setIndent(){

        let indent = 0;    

        this.querySelectorAll(':scope > edml-navitem > .edml-navitem-label').forEach(function(item){
            item.style.minWidth = "auto";
            if(indent < item.getBoundingClientRect().width) indent = item.getBoundingClientRect().width;      
        });

        

       // indent += 0.5*edMLPlayer_Config.get('player.em2px');
        //console.log(indent);

        // with indent second, third ... line
        let indentBefore = 0;
        if(this.parentNode.closest('edml-navlist') != null) indentBefore = parseInt(this.parentNode.closest('edml-navlist').querySelector(':scope > edml-navitem > .edml-navitem-label').style.minWidth);
   
        this.querySelectorAll(':scope > edml-navitem > .edml-navitem-label').forEach(function(item){
            item.style.minWidth = indent + "px";
            item.parentNode.style.marginLeft = indentBefore + "px";
        });

        //without indent
        /*
        this.querySelectorAll(':scope > edml-navitem > *:not(.edml-navitem-label)').forEach(function(item){
            item.style.textIndent = indent + "px";
        });

        */
    }

    

    numberList(){
        let format = edMLPlayer_Config.get('navigation.format');
        if(this.getAttribute('format') != null && edML_List.formatValues.indexOf(this.getAttribute('format')) > -1){
            format = this.getAttribute('format');
        }

        let separator = edMLPlayer_Config.get('navigation.separator');
        let lastsep = edMLPlayer_Config.get('navigation.lastsep');
        if(this.getAttribute('separator') != null) separator = this.getAttribute('separator');
        if(this.getAttribute('lastsep') == "false" || this.getAttribute('lastsep') == false) lastsep = false;

        

        switch(format){            
            case "decimal": this.numberDecimal(separator,lastsep); break;
            case "letter" : this.numberArray(separator,lastsep, edML_List.arrletter); break;
            case "Letter" : this.numberArray(separator,lastsep, edML_List.arrLetter); break;
            case "greek" : this.numberArray(separator,lastsep, edML_List.arrgreek); break;
            case "Greek" : this.numberArray(separator,lastsep, edML_List.arrGreek); break;
            case "bullet" : this.numberSymbol(separator,lastsep,"•"); break;
            case "dash" : this.numberSymbol(separator,lastsep,"-"); break;
            case "dot" : this.numberSymbol(separator,lastsep,"·"); break;
            case "Roman" : this.numberRoman(separator,lastsep, true); break;
            case "roman" : this.numberRoman(separator,lastsep, false); break;
            default:
                //= none -> do nothing [default behaviour is defined in edMLPlayer_Config]

        }

        // all labels to spans

    }

    numberDecimal(separator,lastsep){
        let nb = 1;
        let text;
        this.querySelectorAll(':scope > edml-navitem').forEach(function(item){
            if(item.getAttribute('label') == null){            
                text = "";
                if(item.parentNode.closest('edml-navitem') != null && item.parentNode.closest('edml-navitem').getAttribute('label') != null) {
                    text = item.parentNode.closest('edml-navitem').getAttribute('label');
                } else if(item.parentNode.closest('edml-navitem') != null && item.parentNode.closest('edml-navitem').getAttribute('alabel') != null){
                    text = item.parentNode.closest('edml-navitem').getAttribute('alabel');
                }
    
                if(lastsep == false && item.querySelector(':scope > edml-navitem') == null){
                    item.setAttribute('alabel',text+nb);
                    item.setAttribute('blabel',text+nb);
                } else {
                    item.setAttribute('alabel',text+nb+separator);
                    item.setAttribute('blabel',text+nb+separator);
                }
            }
            //add label/ alabel as span
            let span  = item.querySelector(':scope > .edml-navitem-label');
            if(span == null) {
                span = document.createElement('span');             
                span.classList.add('edml-navitem-label');
            }

            if(item.getAttribute('label') != null){
                span.innerText = item.getAttribute('label');
            } else {
                span.innerText = item.getAttribute('alabel');            
            }

            item.prepend(span);
            if(item.getAttribute('numbered') == null || item.getAttribute('numbered') != "false") nb++;
        });
    }
    
    numberRoman(separator,lastsep,uppercase){
        let nb = 1;
        let text;
        let oldtext;
        this.querySelectorAll(':scope > edml-navitem').forEach(function(item){
            if(item.getAttribute('label') == null){            
                text = "";
                oldtext = "";
                if(item.parentNode.closest('edml-navitem') != null && item.parentNode.closest('edml-navitem').getAttribute('label') != null) {
                    text = item.parentNode.closest('edml-navitem').getAttribute('label');
                } else if(item.parentNode.closest('edml-navitem') != null && item.parentNode.closest('edml-navitem').getAttribute('alabel') != null){
                    text = item.parentNode.closest('edml-navitem').getAttribute('alabel');
                    oldtext = item.parentNode.closest('edml-navitem').getAttribute('blabel');
                }

                if(lastsep == false && item.querySelector(':scope > edml-navitem') == null){
                    item.setAttribute('alabel',text+edMLPlayer_Util.numberToRoman(nb,uppercase,true));
                    item.setAttribute('blabel',oldtext+nb);
                } else {
                    item.setAttribute('alabel',text+edMLPlayer_Util.numberToRoman(nb,uppercase,true)+separator);
                    item.setAttribute('blabel',oldtext+nb+separator);
                }
            }
            //add label/ alabel as span
            let span  = item.querySelector(':scope > .edml-navitem-label');
            if(span == null) {
                span = document.createElement('span');             
                span.classList.add('edml-navitem-label');
            }
            if(item.getAttribute('label') != null){
                span.innerText = item.getAttribute('label');
            } else {
                span.innerText = item.getAttribute('alabel');            
            }

            item.prepend(span);
            if(item.getAttribute('numbered') == null || item.getAttribute('numbered') != "false") nb++;
        });
    }

    numberSymbol(separator,lastsep, symbol){
        let nb = 1;
        let text;
        let oldtext;
        this.querySelectorAll(':scope > edml-navitem').forEach(function(item){
            if(item.getAttribute('label') == null){            
                text = "";
                oldtext = "";
                if(item.parentNode.closest('edml-navitem') != null && item.parentNode.closest('edml-navitem').getAttribute('label') != null) {
                    text = item.parentNode.closest('edml-navitem').getAttribute('label');
                } else if(item.parentNode.closest('edml-navitem') != null && item.parentNode.closest('edml-navitem').getAttribute('alabel') != null){
                    text = item.parentNode.closest('edml-navitem').getAttribute('alabel');
                    oldtext = item.parentNode.closest('edml-navitem').getAttribute('blabel');
                }

                if(lastsep == false && item.querySelector(':scope > edml-navitem') == null){
                    item.setAttribute('alabel',text+symbol);
                    item.setAttribute('blabel',oldtext+nb);
                } else {
                    item.setAttribute('alabel',text+symbol+separator);
                    item.setAttribute('blabel',oldtext+nb+separator);
                }
                
            }
            //add label/ alabel as span
            let span  = item.querySelector(':scope > .edml-navitem-label');
            if(span == null) {
                span = document.createElement('span');             
                span.classList.add('edml-navitem-label');
            }
            if(item.getAttribute('label') != null){
                span.innerText = item.getAttribute('label');
            } else {
                span.innerText = item.getAttribute('alabel');            
            }

            item.prepend(span);
            if(item.getAttribute('numbered') == null || item.getAttribute('numbered') != "false") nb++;
        });
    }



    numberArray(separator,lastsep,arr){
        let nb = 1;
        let text;
        let oldtext;

        
        this.querySelectorAll(':scope > edml-navitem').forEach(function(item){
            if(item.getAttribute('label') == null){                            
                oldtext = "";

                text = edMLPlayer_Util.numberToArr(nb,arr);

                if(item.parentNode.closest('edml-navitem') != null && item.parentNode.closest('edml-navitem').getAttribute('label') != null) {
                    text = item.parentNode.closest('edml-navitem').getAttribute('label') + text;
                } else if(item.parentNode.closest('edml-navitem') != null && item.parentNode.closest('edml-navitem').getAttribute('alabel') != null){
                    text = item.parentNode.closest('edml-navitem').getAttribute('alabel') + text;
                    oldtext = item.parentNode.closest('edml-navitem').getAttribute('blabel');
                }
                      
                if(lastsep == false && item.querySelector(':scope > edml-navitem') == null){
                    item.setAttribute('alabel',text);
                    item.setAttribute('blabel',oldtext+nb);
                } else {                    
                    item.setAttribute('alabel',text+separator); 
                    item.setAttribute('blabel',oldtext+nb+separator);                   
                }
            }
            //add label/ alabel as span
            let span  = item.querySelector(':scope > .edml-navitem-label');
            if(span == null) {
                span = document.createElement('span');             
                span.classList.add('edml-navitem-label');
            }
            if(item.getAttribute('label') != null){
                span.innerText = item.getAttribute('label');
            } else {
                span.innerText = item.getAttribute('alabel');            
            }

            item.prepend(span);
            if(item.getAttribute('numbered') == null || item.getAttribute('numbered') != "false") nb++;
        });
    }


}
class edML_Note extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getInlineGroup());
        this.setAttributeWhitelist(["name","tags"]);
        this.setMixedContent(true);
        this.check();
        
    }


    connectedCallback(){
        let page = this.closest('edml-page');
        let notes = [...page.querySelectorAll('edml-note')];
        let idx = notes.indexOf(this) + 1;

        //create footnotearea?
        if(page.querySelector('.edml-note-footnotearea') == null){
            let area = document.createElement('div');
            area.classList.add('edml-note-footnotearea');
            page.append(area);
        }


        //footnote already exists?
        if(page.querySelector('.edml-note-footnote[idx="'+idx+'"]') == null){                        

            let area = page.querySelector('.edml-note-footnotearea');
            let footnote = document.createElement('div');        
            footnote.classList.add('edml-note-footnote');
            footnote.setAttribute('idx',idx);

            let footnotetext = document.createElement('span');
            footnotetext.classList.add('edml-note-footnotetext');
            for(let i = this.childNodes.length-1; i > -1; i--){
                footnotetext.prepend(this.childNodes[i]);
            }
            


            let footnotenumber = new edML_P();
            footnotenumber.classList.add('edml-note-footnotenumber');
            footnotenumber.setAttribute('idx',idx);
            footnotenumber.innerHTML = '<sup>'+idx+'</sup>';
            footnotenumber.addEventListener('click',this.footnotenumberclick.bind(this));
            


            footnote.append(footnotenumber);
            footnote.append(footnotetext);
            footnote.addEventListener('mouseenter',this.footnotehover.bind(this));
            footnote.addEventListener('mouseleave',this.footnotehoverOff.bind(this));


            area.append(footnote);
        }

        //number already exists?
        if(this.querySelector(':scope > .edml-note-number') == null){
            let notenumber = document.createElement('span');
            notenumber.classList.add('edml-note-number');
            notenumber.setAttribute('idx',idx);
            notenumber.innerHTML = '<sup>'+idx+'</sup>';
            notenumber.addEventListener('click',this.notenumberclick.bind(this));
            notenumber.addEventListener('mouseenter',this.notenumberhover.bind(this));
            notenumber.addEventListener('mouseleave',this.notenumberhoverOff.bind(this));

            this.innerHTML = "";
            this.append(notenumber);
        }
        

    }

    notenumberclick(evt){
        let obj = evt.target.closest('.edml-note-number');        
        this.closest('edml-page').querySelector('.edml-note-footnotenumber[idx="'+obj.getAttribute('idx')+'"]').scrollIntoView();
    }

    footnotenumberclick(evt){
        let obj = evt.target.closest('.edml-note-footnotenumber');;
        this.closest('edml-page').querySelector('.edml-note-number[idx="'+obj.getAttribute('idx')+'"]').scrollIntoView();
    }


    notenumberhover(evt){
        let obj = evt.target.closest('.edml-note-number');   
        this.closest('edml-page').querySelector('.edml-note-footnotenumber[idx="'+obj.getAttribute('idx')+'"]').parentNode.classList.add('hover');
    }

    footnotehover(evt){
        let obj = evt.target;
        this.closest('edml-page').querySelector('.edml-note-number[idx="'+obj.getAttribute('idx')+'"]').classList.add('hover');
    }

    notenumberhoverOff(evt){
        let obj = evt.target.closest('.edml-note-number');   
        this.closest('edml-page').querySelector('.edml-note-footnotenumber[idx="'+obj.getAttribute('idx')+'"]').parentNode.classList.remove('hover');
    }

    footnotehoverOff(evt){
        let obj = evt.target;
        this.closest('edml-page').querySelector('.edml-note-number[idx="'+obj.getAttribute('idx')+'"]').classList.remove('hover');
    }

    getEdML(){
        //edML of finished note 
        let text = "";
        let node = this;
        if(this.querySelector('.edml-note-number') != null){
            let idx = this.querySelector('.edml-note-number').getAttribute('idx');
            if(this.closest('edml-page').querySelector('.edml-note-footnotenumber[idx="'+idx+'"]') != null){
                console.log(this.closest('edml-page').querySelector('.edml-note-footnotenumber[idx="'+idx+'"]').parentNode.querySelector('.edml-note-footnotetext'));
                node = this.closest('edml-page').querySelector('.edml-note-footnotenumber[idx="'+idx+'"]').parentNode.querySelector('.edml-note-footnotetext'); 
            }
        }
 
        for(let i = 0; i < node.childNodes.length; i++){
            if(node.childNodes[i].nodeType == Node.TEXT_NODE){
                text += node.childNodes[i].textContent;
            } else {
                text += node.childNodes[i].getEdML();
            }
        }
       
        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        }         
        return '<note'+attr+'>' + text + '</note>';
    }



}
class edML_Number extends edML_Inputvalue{


    constructor(value){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist(["precision","minfracdigits","maxfracdigits","minintdigits","maxintdigits","lowertolerance","uppertolerance","lowerreltolerance","upperreltolerance","minfracdigitshints","maxfracdigitshints","minintdigitshints","maxintdigitshints","tags","base","significant","significancecheck","credits"]);
        this.setMixedContent(true);
        this.setRemoveContentByClass([]);


        // conversion edml version 0.1 to 0.2
        if(this.getAttribute('checklive') != null){
            let checklives = this.getAttribute('checklive').split(' ');
            if(checklives.indexOf('minfracdigits') > -1){
                this.setAttribute('minfracdigitshints',"true");
            } else if(checklives.indexOf('maxfracdigits') > -1){
                this.setAttribute('maxfracdigitshints',"true");
            } else if(checklives.indexOf('minintdigits') > -1){
                this.setAttribute('minintdigitshints',"true");
            } else if(checklives.indexOf('maxintdigits') > -1){
                this.setAttribute('maxintdigitshints',"true");
            }  
            this.removeAttribute('checklive');
            console.warn('edML-Warning: checklive attribute is depracted. Use hint-attributes instead. Autoconversion is done.');
        }      

        //conversion end


        this.check();  

        this.classList.add('unsolved'); 
        
        this.key = new Uint8Array(32);
        for(let i =  0; i < 32; i++){
            this.key[i] = Math.floor(Math.random()*Number.MAX_SAFE_INTEGER);
        }
        let solution =  value;        
        if(solution == null) solution = this.innerText.trim();
        
        if(solution != null){                             
            let textBytes = aesjs.utils.utf8.toBytes(solution);            
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let encryptedBytes = aesCtr.encrypt(textBytes); 
            let encryptedHex = aesjs.utils.hex.fromBytes(encryptedBytes);
            this.solution = encryptedHex;
            this.innerText = "";
        }

        
        this.base = null;
        
        
        
        //create GUI objects
        let input = document.createElement('input');
        input.classList.add('edml-number-input');
        if(this.closest('edml-input') != null && this.closest('edml-input').getAttribute('width') != null) {
            input.style.minWidth = this.closest('edml-input').getAttribute('width');                          
            input.style.maxWidth = this.closest('edml-input').getAttribute('width');                          
        }
        //input.setAttribute('type','number'); //bad, because of digit sparator could be changed
        


        //Events
        input.addEventListener('keyup',function(evt){
            if(evt.key.toLowerCase() == "enter" && this.closest('edml-variant').querySelector('edml-test.active') == null && this.checkShowCheckButton()){
                let input = this.closest('edml-input');
                input.removeAttribute('solved');
                input.classList.remove('missed');
                this.classList.remove('unsolved'); 
                edMLPlayer_Functions.checkContainer(input);
                if(window.edmlcheckbutton.container.length == 1 && window.edmlcheckbutton.container[0] == input) {
                    edmlcheckbutton.classList.remove('show');
                    window.edmlcheckbutton.container = [];
                    edMLPlayer_Functions.setTimer(null,null);
                }
            } else {
                this.onCheck(evt);  
            } 
        }.bind(this));

        input.addEventListener('keydown',function(evt){            
            this.onKeyDown(evt);
        }.bind(this));

        //for chrome mobile etc. -> evt.key && evt.keyCode not working
        input.addEventListener('input',this.onInput.bind(this));



        input.addEventListener('paste',this.onPaste.bind(this));
        
        this.append(input);
     

       input.addEventListener('focus',this.onFocus.bind(this));
       input.addEventListener('focusout',this.onFocusOut.bind(this)); 
        

    }

    connectedCallback(){
        this.lastCredits = 0; 

    }




    onFocus(event){
        if(this.base == null) {            
            this.base = this.getSubmodel().base;
            if(this.getAttribute('base') != null) this.base = parseInt(this.getAttribute('base'));
        }
        if(this.base != 10){
            this.classList.add('nodecimal');
            let basespan = document.createElement('span');
            basespan.classList.add('edml-number-base');
            basespan.innerText = this.base;
            this.prepend(basespan);
        }
    }

    onFocusOut(event){
        if(this.querySelector('.edml-number-base') != null){
            this.querySelector('.edml-number-base').remove();
        }
        this.classList.remove('nodecimal');
    }

    onPaste(event){
        event.preventDefault();
        let paste = (event.clipboardData || window.clipboardData).getData('text');
        let input = this.querySelector(':scope > .edml-number-input');
       /* let number = parseFloat(paste);        
        alert(paste);
        //if(!isNaN(number)){
            paste = number.toString();
            let i = 0;
            let next = true;
            let evt = new Object();
            evt.selectionStart = 0;
            evt.selectionEnd = 0; 
            while (i < paste.length && next){
                evt.key = paste[i];
                 
                next = this.checkRangeOnKey(evt);                   
                if(next) i++;
            }
            i = edMLPlayer_Util.getCaretPosition(input);
            if(i > 0) input.value = paste.substring(0,i);*/
            input.value = paste;
        //}
        

    }

    onInput(evt){
        if(this.keydown != true){
            if(evt.inputType.toLowerCase() == "inserttext"){
                let input = this.querySelector('.edml-number-input');
                let okay = true;
                let reduced = input.value.substring(0,this.caretPos) + input.value.substring(this.caretPos + 1);

                // only digits, +, - and separator allowed
                if((this.getSubmodel().digits.indexOf(evt.data.toUpperCase()) == -1 || this.getSubmodel().digits.indexOf(evt.data.toUpperCase()) >= this.base) && evt.data != this.getDecimalSeparator() && evt.data != "+" && evt.data != "-") {
                    okay = false;
                }

                //+ - only at start position
                if((evt.data == "+" || evt.data == "-") && (this.caretPos != 0 || reduced.indexOf("+") > - 1 || reduced.indexOf("-") > -1)){           
                    okay =  false;
                }
          
    
                //only one decimal separator
                if(input.value.indexOf(this.getDecimalSeparator()) != input.value.lastIndexOf(this.getDecimalSeparator()) ){
                    okay = false;
                }

                if(!okay){
                    input.value = reduced;
                    input.setSelectionRange(this.caretPos, this.caretPos); //set caret position
                } 
                
                if(this.preCheckValue(input.value,false) == false){
                    input.value = reduced;
                    input.setSelectionRange(this.caretPos, this.caretPos); //set caret position
                }
            }
        }
    }

    onKeyDown(evt){
        this.caretPos = evt.target.selectionStart;
        /*if(evt.key == undefined || evt.key == null || evt.key.toLowerCase() == "unidentified") this.keydown = false; else this.keydown = true;
        if(evt.notregister == true) this.keydown = false;
        if(this.base == null) {
            this.base = this.getSubmodel().base;
            if(this.getAttribute('base') != null) this.base = parseInt(this.getAttribute('base'));
        }
     

        // allowed function keys
        if(evt.key.toLowerCase() == "backspace" || evt.key.toLowerCase() == "del" || evt.key.toLowerCase() == "delete" || evt.key.toLowerCase() == "f5" || evt.key.toLowerCase() == "arrowleft" || evt.key.toLowerCase() == "arrowright" || evt.key.toLowerCase() == "home" || evt.key.toLowerCase() == "end") {
            return true;
        }
        
        // only digits, +, - and separator allowed
        if((this.getSubmodel().digits.indexOf(evt.key.toUpperCase()) == -1 || this.getSubmodel().digits.indexOf(evt.key.toUpperCase()) >= this.base) && evt.key != this.getSubmodel().decimalseparator && evt.key != "+" && evt.key != "-") {
            return false;
        }
        
        if((evt.key == "+" || evt.key == "-") && (evt.target.selectionStart != 0 || this.querySelector('.edml-number-input').value.indexOf("+") > - 1 || this.querySelector('.edml-number-input').value.indexOf("-") > -1)){            
            return false;
        }

        if((this.querySelector('.edml-number-input').value + evt.key).indexOf('.') != (this.querySelector('.edml-number-input').value + evt.key).lastIndexOf('.')){
            return false;
        }

        return this.preCheckValue(this.querySelector('.edml-number-input').value + evt.key,false); */
        
    }

    preCheckValue(text,finished){                
        let splitted = text.trim().split(this.getDecimalSeparator());    
        let len = splitted[0].length;
        if(splitted[0][0] == "+" || splitted[0][0] == "-") len--;

        let model = this.getSubmodel();
        
        let minfracdigitshints = model.minfracdigitshints;
        if(this.getAttribute('minfracdigitshints') == "true") minfracdigitshints = true;

        let maxfracdigitshints = model.maxfracdigitshints;
        if(this.getAttribute('maxfracdigitshints') == "true") maxfracdigitshints = true;

        let minintdigitshints = model.minintdigitshints;
        if(this.getAttribute('minintdigitshints') == "true") minintdigitshints = true;

        let maxintdigitshints = model.maxintdigitshints;
        if(this.getAttribute('maxintdigitshints') == "true") maxintdigitshints = true;

        

    
            
        //max fractional digits
        if(maxfracdigitshints){
            let maxfracdigits = Number.parseInt(model.maxfracdigits);
            if(this.getAttribute('maxfracdigits') != null) maxfracdigits = Number.parseInt(this.getAttribute('maxfracdigits'));
            
            if(maxfracdigits != null){
                if(splitted.length == 2 && splitted[1].length > maxfracdigits) {
                    new edML_DialogShortmessage(document.edmllocale.get("shortmessage_maxfracdigits") + maxfracdigits,"error");                    
                    return false;  
                }
            }   
        }
            
        //minimum fractional digits can only be checked, if user input is finished; called with finished == true in functions.js
        if(minfracdigitshints && finished){
            let minfracdigits = Number.parseInt(model.minfracdigits);
            if(this.getAttribute('minfracdigits') != null) minfracdigits = Number.parseInt(this.getAttribute('minfracdigits'));

            if(minfracdigits != null && minfracdigits > 0){
                if((splitted.length == 2 && splitted[1].length < minfracdigits) || splitted.length < 2) {
                    new edML_DialogShortmessage(document.edmllocale.get("shortmessage_minfracdigits") + minfracdigits,"error");                    
                    return false;  
                }
            }  
        }


        // maximium integer digits
        if(maxintdigitshints){
            let maxintdigits = Number.parseInt(model.maxintdigits);
            if(this.getAttribute('maxintdigits') != null) maxintdigits = Number.parseInt(this.getAttribute('maxintdigits'));
            if(maxintdigits != null){
                if(len > maxintdigits) {
                    new edML_DialogShortmessage(document.edmllocale.get("shortmessage_maxintdigits") + parseInt(maxintdigits),"error");                    
                    return false;  
                }
            }   
        }


        //minimum integer digits can only be checked, if user input is finished; called with finished == true in functions.js
        if(minintdigitshints){
            
            let minintdigits = Number.parseInt(model.minintdigits);
            if(this.getAttribute('minintdigits') != null) minintdigits = Number.parseInt(this.getAttribute('minintdigits'));
            if(minintdigits != null && minintdigits > 0){
                if((splitted.length == 2 && len < minintdigits)){
                    new edML_DialogShortmessage(document.edmllocale.get("shortmessage_minintdigits") + parseInt(minintdigits),"error");                    
                    return false;  
                } else if(finished && splitted.length == 1 && len < minintdigits) {
                    new edML_DialogShortmessage(document.edmllocale.get("shortmessage_minintdigits") + parseInt(minintdigits),"error");                    
                    return false; 
                }
            }   
        }
            
        

        return true;
    }

    checkShowCheckButton(){
        let okay = this.preCheckValue(this.querySelector('.edml-number-input').value,true);      
        okay = okay && this.querySelector('.edml-number-input').value.trim() != "";
        return okay;
    }

    /*onCheck(evt){        
        let input = this.closest('edml-input');  
        let val = this.getDecimalValue();           
        if(!isNaN(parseFloat(val) && this.querySelector('.edml-number-input').value.trim() != "")) {    
            input.getModel().onCheck(evt, this);
            input.classList.add('selected');
        } else {
            edMLPlayer_Functions.hideCheckButton();     
            if(edMLPlayer_Functions.getTimer() != null) {
                clearTimeout(edMLPlayer_Functions.getTimer());
                edMLPlayer_Functions.setTimer(null);                        
            }
        }
    }*/

    getEdML(){
        let text = "";
        if(this.solution != ""){
            let encryptedBytes = aesjs.utils.hex.toBytes(this.solution);
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let decryptedBytes = aesCtr.decrypt(encryptedBytes);
            text = aesjs.utils.utf8.fromBytes(decryptedBytes); 
        }     
        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 
        return '<number'+attr+'>' + text + '</number>';
    }

    getDecimalValue(){        
        return this.convertToDecimal(this.querySelector(':scope  > .edml-number-input').value, this.getDecimalSeparator());    
    }

    getDecimalSeparator(){
        return edMLPlayer_Util.getDecimalSeparator(this.getSubmodel().decimalseparator);
    }

    getValue(){
        //return number value in english format        
        return this.querySelector(':scope > .edml-number-input').value.replace(',','.');         
    }

    getString(){
        let val = this.querySelector(':scope >  .edml-number-input').value.toString();          
        if(this.getDecimalSeparator() == ",") val = val.replace('.',',');
        return  val;
    }

    getStateValue(){
        //value for state object
        return this.getValue();
    }

    setValue(val){
        this.querySelector(':scope >  .edml-number-input').value = val.replace(".",this.getDecimalSeparator());         
    }

    


    verify(value,model,originalvalue = null){          
        //given value must be decimal value and in english number format
        if(model == null) model = this.getSubmodel();    

        let solvedobj = new Object();
        solvedobj.solved = false;
        
        if(this.getAttribute('credits') != null && !isNaN(parseInt(this.getAttribute('credits')))) {
            solvedobj.credits = parseInt(this.getAttribute('credits'));
         } else {
            solvedobj.credits = model.credits;
        }

        let inputnumber;
            
        if(value != null) {                
            inputnumber = value;                
        } else {
            inputnumber = this.convertToDecimal(this.getValue(),'.');                 
        }

        if(this.solution != "" && inputnumber.toString() != ""){ 
            
            
            let lowertolerance = model.lowertolerance;
            let uppertolerance = model.uppertolerance;
            let lowerreltolerance = model.lowerreltolerance;
            let upperreltolerance = model.upperreltolerance;   
            let checkvalue = model.checkvalue;
            let precision = model.precision;
                
            

            if(this.getAttribute('lowertolerance') != null) lowertolerance = this.getAttribute('lowertolerance');
            if(this.getAttribute('uppertolerance') != null) uppertolerance = this.getAttribute('uppertolerance');
            if(this.getAttribute('lowerreltolerance') != null) lowerreltolerance = this.getAttribute('lowerreltolerance');
            if(this.getAttribute('upperreltolerance') != null) upperreltolerance = this.getAttribute('upperreltolerance');
            

            if(lowertolerance == "INF") lowertolerance = Infinity;
            if(uppertolerance == "INF") uppertolerance = Infinity;
            if(lowerreltolerance == "INF") lowerreltolerance = Infinity;
            if(upperreltolerance == "INF") upperreltolerance = Infinity;

            let minfracdigitshints = model.minfracdigitshints;
            if(this.getAttribute('minfracdigitshints') == "true") minfracdigitshints = true;

            let maxfracdigitshints = model.maxfracdigitshints;
            if(this.getAttribute('maxfracdigitshints') == "true") maxfracdigitshints = true;

            let minintdigitshints = model.minintdigitshints;
            if(this.getAttribute('minintdigitshints') == "true") minintdigitshints = true;

            let maxintdigitshints = model.maxintdigitshints;
            if(this.getAttribute('maxintdigitshints') == "true") maxintdigitshints = true;

            let maxfracdigits = model.maxfracdigits;
            if(this.getAttribute('maxfracdigits') != null) maxfracdigits = this.getAttribute('maxfracdigits');
            if(maxfracdigits != Infinity) maxfracdigits = parseInt(maxfracdigits);

            let minfracdigits = Number.parseInt(model.minfracdigits);
            if(this.getAttribute('minfracdigits') != null) minfracdigits = Number.parseInt(this.getAttribute('minfracdigits'));

            let maxintdigits = model.maxintdigits;
            if(this.getAttribute('maxintdigits') != null) maxintdigits = this.getAttribute('maxintdigits');
            if(maxfracdigits != Infinity) maxintdigits = parseInt(maxintdigits);

            let minintdigits = Number.parseInt(model.minintdigits);
            if(this.getAttribute('minintdigits') != null) minintdigits = Number.parseInt(this.getAttribute('minintdigits'));

            let significant = model.significant;
            if(this.getAttribute('significant') != null) significant = this.getAttribute('significant');

            let significancecheck = Number.parseInt(model.significancecheck);
            if(this.getAttribute('significancecheck') != null) significancecheck = this.getAttribute('significancecheck');


            //force to number !
/*            uppertolerance = parseFloat(uppertolerance);
            lowertolerance = parseFloat(lowertolerance);
            upperreltolerance = parseFloat(upperreltolerance);
            lowerreltolerance = parseFloat(lowerreltolerance);
            precision = parseFloat(precision);*/

            let encryptedBytes = aesjs.utils.hex.toBytes(this.solution);
            let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
            let decryptedBytes = aesCtr.decrypt(encryptedBytes);
            let decryptedText = aesjs.utils.utf8.fromBytes(decryptedBytes); 

            if(maxfracdigits != Infinity){
                decryptedText = this.toFixed(decryptedText,maxfracdigits);
            }
            
            let parentbox = this.parentNode;
            while(parentbox != null && !(parentbox instanceof edML_Box)){
                parentbox = parentbox.parentNode;
            }

            nerdamer.flush();
            nerdamer.clearVars();
            nerdamer.setConstant('E', 'delete');
            

            if(parentbox != null && parentbox.parameters != null){
                nerdamer.flush();
                nerdamer.clearVars();

                for(let i = 0; i < parentbox.parameters.length; i++){
                    nerdamer.setVar(parentbox.parameters[i],parentbox.values[i]);
                }
                decryptedText = nerdamer('simplify('+decryptedText+')').evaluate().text('decimals');
                
            }

            if(parseFloat(decryptedText) != decryptedText) decryptedText = nerdamer('simplify('+decryptedText+')').evaluate().text('decimals');
            
            let solutionnumber = this.convertToDecimal(decryptedText,".");   
            
            

            

            if(originalvalue == null){
                originalvalue = this.getValue();
            }


            let splitted = inputnumber.toString().split(".");    
            let len = splitted[0].length;
            if(splitted[0][0] == "+" || splitted[0][0] == "-") len--;
 
           

           // if( (inputnumber -(uppertolerance+solutionnumber)  < precision || inputnumber - (upperreltolerance * solutionnumber + solutionnumber) < precision) && ((solutionnumber - lowertolerance) - inputnumber < precision ||(solutionnumber - solutionnumber * lowerreltolerance) - inputnumber < precision)){                
           
           //old float based check;
          /* if(((solutionnumber - lowertolerance - precision <= inputnumber) || solutionnumber - (lowerreltolerance * Math.abs(solutionnumber)) - precision <= inputnumber) && ((inputnumber <= solutionnumber + uppertolerance + precision) || (inputnumber <= solutionnumber + Math.abs(solutionnumber) * upperreltolerance + precision ))){
                solvedobj.valuecheck = true; // value is okay
            } else {
                solvedobj.valuecheck = false; // value is not okay
            }*/

            //CAS based check
            nerdamer.flush();
            nerdamer.clearVars();
            nerdamer.setConstant('E', 'delete');

            
            
            try{
                let check1;
                let check2;
                if(nerdamer(solutionnumber+'-'+lowertolerance+'-'+precision+'<='+inputnumber) == 1 || nerdamer(solutionnumber+'-('+lowerreltolerance+ '*abs('+solutionnumber+'))-'+precision+' <='+inputnumber) == 1 || lowertolerance == "Infinity" || lowerreltolerance=="Infinity") check1 = true; else check1 = false;

                if(nerdamer(inputnumber+'<='+solutionnumber+'+'+uppertolerance+'+'+precision) == 1 || nerdamer(inputnumber+'<='+solutionnumber+"+("+upperreltolerance +'*abs('+solutionnumber+'))+'+precision) == 1 || uppertolerance == "Infinity" || upperreltolerance=="Infinity") check2 = true; else check2 = false;

                
                if(check1 && check2){
                    solvedobj.valuecheck = true; // value is okay
                } else {
                    solvedobj.valuecheck = false; // value is not okay
                }
            

            } catch(error){
                solvedobj.valuecheck = false;
                console.log(error);
                console.warn('nerdamer parse error on number');
            }

            
            if(lowertolerance == 0 && lowerreltolerance == 0 && uppertolerance == 0 && upperreltolerance == 0 && checkvalue == false) solvedobj.valuecheck = true; // for exponential; ignore value check result

            //check attributes
            solvedobj.attributecheck = true

            splitted = originalvalue.split(".");  
            len = splitted[0].length;  
            //max fractional digits            
            if(maxfracdigits != null){        
                if(splitted.length == 2 && splitted[1].length > maxfracdigits) {
                    solvedobj.attributecheck = false;                               
                }
            }   
                

            //minimum fractional digits           
            if(minfracdigits != null && minfracdigits > 0){
                if((splitted.length == 2 && splitted[1].length < minfracdigits) || splitted.length < 2) {
                    solvedobj.attributecheck = false;                               
                }
            }  
                

            // maximium integer digits
            if(maxintdigits != null){
                if(len > maxintdigits) {
                    solvedobj.attributecheck = false;                            
                }
            }   
                


            //minimum integer digits
            if(minintdigits != null && minintdigits > 0){                        
                if((splitted.length == 2 && len < minintdigits)){
                    solvedobj.attributecheck = false;                            
                } else if(splitted.length == 1 && len < minintdigits) {
                    solvedobj.attributecheck = false;                            
                }
            }   

            //significant
            let signumber = parseInt(significant);
            if(significant != "none" && !isNaN(signumber) && signumber > -1) {
                let sig = this.getSignificant(originalvalue);      
                if(significancecheck == "strict"){                    
                    if(sig[0] != signumber){
                        solvedobj.attributecheck = false;  
                    }
                } else {
                    if(sig[0] <= signumber && signumber <= sig[1]){

                    } else {
                        solvedobj.attributecheck = false;  
                    }
                }
            }
           

                

            if(solvedobj.attributecheck == false){
                new edML_DialogShortmessage(document.edmllocale.get("shortmessage_digitserror"),"error");                      
                solvedobj.solved = false;  
            } 
            
            if(solvedobj.attributecheck == true && solvedobj.valuecheck == true) {                    
                solvedobj.solved = true;                  
            } else {         
                solvedobj.solved = false;                
            }            
    
        }      
     
        return solvedobj; 
    }

    toFixed(number,digits){
        let split = number.split('.');
        if(split.length == 2){
            return split[0] + "." + split[1].substring(0,digits);
        } else return number;
        
    }

    getSignificant(number){
        let split = number.toString().split('.');   
        let minsig;
        let maxsig;        

        //remove leading integer zeros        
        let found = split[0].length;
        for(let i = 0; i < split[0].length; i++){
            if(split[0].charAt(i) != "0" && i < found) found = i;
        }        
        split[0] = split[0].substring(found);

        //remove  leading fractional zeros if no significant integer digits
        if(split[0].length == 0 && split.length > 0){ 
            found = split[1].length;
            for(let i = 0; i < split[1].length; i++){
                if(split[1].charAt(i) != "0" && i < found) found = i;
            }           
            split[1] = split[1].substring(found);
        }

        
        //calculate min and max significant            
        if(split.length > 1){ //fractional number or int?
            minsig =  split[0].length + split[1].length;
            maxsig = minsig;
        } else {
            maxsig = split[0].length;
            //remove trailing zeros for minsig
            found = split[0].length-1;
            while(found > 0 && split[0].charAt(found) == "0"){
                found--;
            }
            
            split[0] = split[0].substring(0,found+1);
            minsig = split[0].length;
        }
       
        let result = new Array();
        result.push(minsig);
        result.push(maxsig);
        return result;        
        
    }

    reveal(){
        let model = this.getSubmodel(); 
        let encryptedBytes = aesjs.utils.hex.toBytes(this.solution);
        let aesCtr = new aesjs.ModeOfOperation.ctr(this.key, new aesjs.Counter(5));
        let decryptedBytes = aesCtr.decrypt(encryptedBytes);
        let decryptedText = aesjs.utils.utf8.fromBytes(decryptedBytes); 

        let maxfracdigits = model.maxfracdigits;
        if(this.getAttribute('maxfracdigits') != null) maxfracdigits = this.getAttribute('maxfracdigits');
        if(maxfracdigits != Infinity) maxfracdigits = parseInt(maxfracdigits);
        let minfracdigits = Number.parseInt(model.minfracdigits);
        if(this.getAttribute('minfracdigits') != null) minfracdigits = Number.parseInt(this.getAttribute('minfracdigits'));

        let significant = model.significant;
        if(this.getAttribute('significant') != null) significant = this.getAttribute('significant');


        if(maxfracdigits != Infinity){
            decryptedText = this.toFixed(decryptedText,maxfracdigits);
        }

        
        if(minfracdigits > 0){
            let split = decryptedText.split('.');
            if(split.length == 1) {
                split.push("");
                decryptedText += ".";
            }
            if(split[1].length < minfracdigits){
                for(let i = 0; i < minfracdigits-split[1].length;i++) {
                    decryptedText += "0";
                }    
            }
        }
        
        
        if(significant != "none" && decryptedText.indexOf('.') > -1){
            let split = decryptedText.split('.');
            let sig = this.getSignificant(decryptedText);
            for(let i = 0; split[1].length < sig;i++) {
                decryptedText += "0";
            }  
        }

        decryptedText = decryptedText.replace('.',edMLPlayer_Util.getDecimalSeparator(model.decimalseparator));
        return decryptedText;
    }

    showSolutionhint(){        
        let hint = document.querySelector('edml-variant.active edml-solutionhint[to="'+this.closest('edml-input').getAttribute('name')+'"]');
  
        if(this.querySelector('.edml-solutionhint-btn') == null){
            let btn = document.createElement('span');
            btn.classList.add('edml-solutionhint-btn');
            this.append(btn);
            
            btn.addEventListener('click',function(){
                edML_DialogSolutionhint.show(hint);                
            });
        }   
        
    }

    

    /*checkSolutionhint(solvedobj){
        if(solvedobj.solved == false){
            // solutionhint exist?
            if(this.closest('edml-input').getAttribute('name') != null && document.querySelector('edml-variant.active edml-solutionhint[to="'+this.closest('edml-input').getAttribute('name')+'"]') != null){                    
 
                let hint = document.querySelector('edml-variant.active edml-solutionhint[to="'+this.closest('edml-input').getAttribute('name')+'"]').innerHTML;
                if(this.querySelector('.edml-solutionhint-btn') == null){
                    let btn = document.createElement('span');
                    btn.classList.add('edml-solutionhint-btn');
                    this.append(btn);
                    
                    btn.addEventListener('click',function(){
                        let dlg = new edML_DialogSolutionhint();
                        dlg.setTitle(document.edmllocale.get("dialog_solutionhint_title"));                            
                        dlg.setSteps(hint);
                        dlg.hideFooter();
                        dlg.show();    
                        
                        
                    });
                }    
            }    
        }
    }*/



    convertToDecimal(number,decimalsep){
        //converts a number to its decimal value based on variables set to nerdamer
        number = number.toString().trim();
        let decimalnumber = nerdamer('0');   
        let factor = 1;     
        if(this.base == null) {
            this.base = this.getSubmodel().base;
            if(this.getAttribute('base') != null) this.base = parseInt(this.getAttribute('base'));
        }


        let numberArr = (number + "").split(decimalsep);
        let digits = String(numberArr[0]);
        let fractions = String(numberArr[1]);
        let start = 0;

        //check for sign
        if(digits.indexOf('-') == 0){
            digits = digits.substring(1);
            factor = -1;
            start = 0;
        } else if(digits.indexOf('+') == 0){
            start = 0;
            digits = digits.substring(1);
        }
        

        //check for wrong digits
        let okay = true;
        for(let i = start; i < digits.length; i++){            
            if(this.getSubmodel().digits.indexOf(digits[i].toUpperCase()) == -1) okay = false;
        }

        for(let i = 0; i < fractions.length; i++){            
            if(this.getSubmodel().digits.indexOf(fractions[i].toUpperCase()) == -1) okay = false;
        }

        

        //convert
        if(okay){
            //digits before decimalseparator
            //console.log(decimalnumber);
            
            try{
                for(let i = 0; i < digits.length - start; i++){
                    //decimalnumber += this.getSubmodel().digits.indexOf(digits[digits.length - i - 1].toUpperCase()) * Math.pow(this.base,i);
                    decimalnumber = nerdamer(decimalnumber.toTeX('decimal') + "+" + this.getSubmodel().digits.indexOf(digits[digits.length - i - 1].toUpperCase())+"*"+this.base+'^'+i);  
                    //console.log(this.getSubmodel().digits.indexOf(digits[digits.length - i - 1].toUpperCase()));     
                    //console.log(decimalnumber); 
                }
    

                //fractions        
                if(numberArr.length > 1){
                    
                    for(let i = 0; i < String(numberArr[1]).length; i++){
                        decimalnumber = nerdamer(decimalnumber.toTeX('decimal') + "+" + this.getSubmodel().digits.indexOf(fractions[i].toUpperCase())+"*"+this.base+'^(-'+(i+1)+')');                    
                    }
                }
            }catch(error){
                console.log(error);
                console.warn('nerdamer parse error on number2decimal');
            }            
            return nerdamer(factor+"*" + decimalnumber.toTeX('decimal')).toTeX('decimal');
        } else {
            return null;
        }

        
    }

  


    getSubmodel(){       
        if(this.closest('edml-exponential') == null){
            return this.getModel().getSubmodel(edMLPlayer_Functions.getSubmodelByInputvalue(this));
        } else {
            if(this.closest('edml-mantissa') != null){
                return this.getModel().getSubmodel("exponential.mantissa");
            } else {
                return this.getModel().getSubmodel("exponential.exponent");
            }
        }
        
    }

    

    save2SCORM(result){
        //save to SCORM DB
        if(edMLPlayer_Config.get("player.scorm.enabled") == true && (edMLPlayer_Config.get('player.scorm.testonly') != true || document.querySelector('edml-test.active') != null)){  
            let navitem = this.closest('edml-variant').querySelector('edml-navitem.selected');
            if(navitem != null) navitem = navitem.getAttribute('name');
            let exercisename = edML_SCORM.saveInputObjective(result,this.closest('edml-input'),this.getValue().toString());
            edML_SCORM.saveInteraction(this.closest('edml-page').getAttribute("name"),"other","input: number",navitem,exercisename,null);
        }
    }


    

    initFromSCORM(entrynb){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true && edMLPlayer_Config.get('player.scorm.testonly') != true) {
        

            let input = this.querySelector(':scope > .edml-number-input');
            if(input != null) input.value = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.description');           
            if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "failed"){
                this.closest('edml-input').setAttribute('solved','false');
            } else if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "passed"){
                this.closest('edml-input').setAttribute('solved','true');
            }
            
            edMLPlayer_Functions.changeCredits(-this.lastCredits,false);
            this.lastCredits = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.score.raw');             
        }

    }


    clear(){
        this.querySelector('.edml-number-input').value = "";
        this.removeAttribute('solved');       
    }

    



}
class edML_Oneof extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["condition","allof"]);
        this.setAttributeWhitelist([]);
        this.setRequiredAttribute([]);
        this.setRequiredTag([["condition","allof"]]);
        this.setMixedContent(false);
        this.check();
    }


    getResult(){
        let result = false;
        var length = this.childNodes.length;
        var i = 0;
        while(i < length && result == false){
            if(this.childNodes[i].getResult()) result = true;
            i++
        }

        return result;

        
    }
}
class edML_Objectblock extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist([]);
        this.setAttributeWhitelist(["name","tags","plugin"]);
        this.setMixedContent(true);
        this.check();
        this.edml = this.innerText;
        
    }

    getEdML(){
        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"';
        }
        return '<objectblock'+attr+'>' + this.edml + '</objectblock>';
    }
}
 class edML_Option extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getInlineGroup());
        this.setAttributeWhitelist(["credits","correct"]);
        this.setMixedContent(true);     
        this.check();
        
    }
    
}

class edML_Optionalview extends edML_View{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getContainerGroup().concat(["title"]));
        this.setAttributeWhitelist(["name","tags","label"]);
        this.setRequiredTag([edML_Groups.getContainerGroup()]);
        this.setMixedContent(false);
        
        if(this.querySelector(':scope > edml-groupview') == null){
            this.prepend(new edML_Groupview);
        }                
        
        this.check();
        
        this.button = document.createElement('button');
        
        this.button.classList.add('edml-optionalview-button');
        var span = document.createElement('span');
        span.classList.add('edml-optionalview-button-inner');
        span.innerText = document.edmllocale.get('optionalview_button');
        this.button.append(span);
        this.prepend(this.button);
        this.onButtonClickFn = this.onButtonClick.bind(this);
        this.button.addEventListener('click',this.onButtonClickFn);
        this.refresh();

        //move title to top
        if(this.querySelector(':scope > edml-title') != null) this.prepend(this.querySelector(':scope > edml-title')); 
    }
    
    refresh(){
        if(this.querySelector(':scope > edml-groupview > edml-title:not(.edml-autotitle)') != null){
            this.button.querySelector('.edml-optionalview-button-inner').innerHTML = this.querySelector(':scope > edml-groupview > edml-title').innerHTML; 
        }
    }
    
    onButtonClick(){
        this.classList.toggle('show');            
        
        
    }
}
class edML_Order extends edML_Inputvalue{

    constructor(){
        super();
        this.setTagWhitelist(["orderitems","chains"]);
        this.setAttributeWhitelist(["credits","model"]);
        this.setMixedContent(false);
        this.setRequiredTag(["orderitems"],["chains"]); 
        this.setOnlyOnceTag(["orderitems","chains"]);
        this.check();


         //prepare encode chains
         this.key = new Uint8Array(32);
         for(let i =  0; i < 32; i++){
             this.key[i] = Math.floor(Math.random()*Number.MAX_SAFE_INTEGER);
         }

         

         

    }


    connectedCallback(){
        if(this.connected == null){
            this.connected = true;
            let nb = 1;
            let items = new Array();
            this.querySelectorAll(':scope > edml-orderitems > edml-item').forEach(function(item){
                item.setAttribute('order',nb);
                items.push(item);
                nb++;
            }.bind(this));


            //reorder and remember original order
            if(edMLPlayer_Config.get('player.forceshuffleOff') == false){
                for(let i = 0; i < items.length * 2; i++){
                    this.querySelector(":scope > edml-orderitems").prepend(items[Math.floor(Math.random() * items.length)]);
                }
                
            }
            
        
            nb = 0;
            this.itemorder = new Array();
            this.querySelectorAll(':scope > edml-orderitems > edml-item').forEach(function(item){
                this.itemorder[nb] = parseInt(item.getAttribute('order'));
                item.setAttribute('order',nb+1);            
                nb++;
            }.bind(this));

            //encode chains
            this.querySelectorAll(':scope > edml-chains > edml-chain').forEach(function(item){                   
                item.encode(this.key);           
            }.bind(this));

            this.makeDropPlaces();

            this.startidx = -1;
        }
    }



    makeDropPlaces(){
        let dropareas = this.querySelector(':scope > .edml-order-dropareas');
        if(dropareas == null){
            dropareas = document.createElement('div');
            dropareas.classList.add('edml-order-dropareas');
            this.append(dropareas);
        }

        let items = [...this.querySelectorAll(':scope > edml-orderitems > edml-item')];

        for(let i = 0; i < items.length; i++){
            let droparea = document.createElement('div');
            droparea.classList.add('edml-order-droparea');
            droparea.append(items[i]);
            

            items[i].setAttribute('draggable','true');
            items[i].addEventListener('dragstart',this.onDragStart.bind(this,items[i]));            
            items[i].addEventListener('dragend',this.onDragEnd.bind(this,items[i]));  
            items[i].addEventListener('click',this.onClick.bind(this,items[i]));
            items[i].addEventListener('touchstart',this.onTouchstart);
            items[i].addEventListener('touchend',this.onTouchend);
            
            dropareas.append(droparea);

            droparea.addEventListener('drop',this.onDrop.bind(this,droparea));              
            droparea.addEventListener('dragover',this.onDragOver.bind(this,droparea));
        }

   

        

    }

    onTouchstart(evt){
        this.classList.add('touch');
        
    }

    onTouchend(evt){       
        this.classList.remove('ondrag');
        this.classList.remove('touch');
        
        //Checkbutton 
        this.onCheck(evt);
    }



    onClick(item,evt){
        let selected = this.querySelector(':scope > .edml-order-dropareas > .edml-order-droparea > edml-item.selected');
        if(selected == null || selected == item){
            item.classList.toggle('selected');
        } else {
            //swap
            let parentNode = selected.parentNode;
            item.parentNode.append(selected);
            parentNode.append(item);
            selected.classList.remove('selected');

            //Checkbutton 
            this.onCheck(evt);
        }
        
    }

    onDragStart(item){        
        let obj = item;
        let items = [...this.querySelectorAll(':scope > .edml-order-dropareas > .edml-order-droparea > edml-item')];
        let areas = [...this.querySelectorAll(':scope > .edml-order-dropareas > .edml-order-droparea')];
        this.startidx = items.indexOf(item);
        this.dropped = false;
    
        setTimeout(function(){
            obj.classList.add('ondrag');
        });
    }

    onDrop(area,evt){
        this.dropped = true;
        this.querySelector(':scope > .edml-order-dropareas >.edml-order-droparea > edml-item.ondrag').classList.remove('ondrag');
        
        //Checkbutton         
        this.onCheck(evt);

    }

    onDragEnd(item, evt){       
        if(this.dropped == false){      
            item.classList.remove('ondrag');
        
            let items = [...this.querySelectorAll(':scope > .edml-order-dropareas >.edml-order-droparea > edml-item')];
            let areas = [...this.querySelectorAll(':scope > .edml-order-dropareas > .edml-order-droparea')];  

            let n = 0;
            for(let i = 0; i < areas.length-1; i++){           
                if(i != this.startidx){                
                    areas[i].prepend(items[n]);
                    n++;
                } else {
                    areas[i].innerHTML = "";
                }

            }           
            areas[this.startidx].prepend(item);
            this.startidx = -1;
        }
    }

    onDragOver(droparea,evt){
        evt.preventDefault();
        let items = [...this.querySelectorAll(':scope > .edml-order-dropareas > .edml-order-droparea > edml-item')];
        let areas = [...this.querySelectorAll(':scope > .edml-order-dropareas >  .edml-order-droparea')];  
        let idx = areas.indexOf(droparea);
     
        let n = 0;
        for(let i = 0; i < areas.length; i++){
            if(i != idx){
                if(n < items.length){
                    if(items[n].classList.contains('ondrag') && n < items.length - 1) n++;
                    areas[i].prepend(items[n]);
                    n++;
                }
            } else {
                areas[i].prepend(this.querySelector(':scope > .edml-order-dropareas > .edml-order-droparea > edml-item.ondrag'));
            }
            
        }

          
    } 


    verify(value,model){ 

        if(model == null) model = this.getSubmodel();   

        let solvedobj = new Object();
        solvedobj.solved = true;
        solvedobj.solution = null;
        solvedobj.credits = 0;
        solvedobj.penalty = 0;

        //generate value if neccessary
        if(value == null){
            value = "";
            this.querySelectorAll(':scope > .edml-order-dropareas > .edml-order-droparea >edml-item').forEach(function(item){               
                value += this.itemorder[parseInt(item.getAttribute('order'))-1]+" ";
            }.bind(this));
            if(value.length > 0) value = value.substring(0, value.length-1);            
        }

        //compare
        let valuearr = value.split(" ");
        
        this.querySelectorAll(':scope > edml-chains > edml-chain').forEach(function(chain){
            let chainarr = (chain.decode(this.key)).split(" ");
            for(let i = 0; i < chainarr.length-1; i++){
                if(valuearr.indexOf(chainarr[i]) >= valuearr.indexOf(chainarr[i+1]) || valuearr.indexOf(chainarr[i]) == -1 || valuearr.indexOf(chainarr[i+1]) == -1){
                    solvedobj.solved = false;
                }
            }
        }.bind(this));


        return solvedobj;

    


    }

    getEdML(){
        let items = [...this.querySelectorAll(':scope > .edml-order-dropareas > .edml-order-droparea > edml-item')];
        let areas = [...this.querySelectorAll(':scope > .edml-order-dropareas > .edml-order-droparea')];

        //copy items to orderitems
        let orderitems = this.querySelector(':scope > edml-orderitems');
        for(let i = 0; i < items.length; i++){
            orderitems.append(items[i]);
        }

        let text = "";
        text += this.querySelector(':scope > edml-orderitems').getEdML(this.itemorder);   
        
        //copy items back to droparea
        for(let i = 0; i < items.length; i++){
            areas[i].append(items[i]);
        }


        text += this.querySelector(':scope > edml-chains').getEdML(this.key);

        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 


        

        return '<order'+attr+'>' + text + '</order>';
    }

    evaluateCredits(result){
        let model = this.getSubmodel();           
        if(result == true){   
            edMLPlayer_Functions.changeCredits(-1 * this.lastCredits, false);
            edMLPlayer_Functions.changeCredits(parseInt(model.credits), true);                            
            this.lastCredits = model.credits;
            
            if(this.querySelector('.edml-solutionhint-btn') != null) this.querySelector('.edml-solutionhint-btn').remove();
                            
        } else if(result == false){
            
            edMLPlayer_Functions.changeCredits(-1 * this.lastCredits, false);
            if(this.lastCredits != 0 || parseInt(model.penalty) != 0) {
                edMLPlayer_Functions.changeCredits(-1 * parseInt(model.penalty), true);
            } 
            this.lastCredits = -1 * model.penalty;  
           
            
            
        } else {  //result == null
            //do nothing
        }

    }

    save2SCORM(result){
    }


    initFromSCORM(entrynb){

    }


    
    showSolutionhint(){        
        let hint = document.querySelector('edml-variant.active edml-solutionhint[to="'+this.closest('edml-inputblock').getAttribute('name')+'"]');
  
        if(this.closest('edml-inputblock').querySelector('.edml-solutionhint-btn') == null){
            let btn = document.createElement('span');
            btn.classList.add('edml-solutionhint-btn');
            this.closest('edml-inputblock').prepend(btn);
            
            btn.addEventListener('click',function(){                                       
                edML_DialogSolutionhint.show(hint); 
            });
        }   
        
    }
    

}

class edML_Orderitems extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["item"]);
        this.setAttributeWhitelist([]);
        this.setMixedContent(false);
        this.setRequiredTag(["item"]); 
        this.check();
    }


    getEdML(orderarr){
        let text = "";
        if(orderarr == null){
            this.querySelectorAll(':scope > edml-item').forEach(function(item){
                text += item.getEdML();
            });
        } else {
            for(let i = 0; i < orderarr.length; i++){
                text += this.querySelector(':scope > edml-item[order="'+(orderarr.indexOf(i+1)+1)+'"]').getEdML();                
            }
        }

        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i])+'"'; 
        } 
        return '<orderitems'+attr+'>' + text + '</orderitems>';
       
    }



}
class edML_P extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getInlineGroup());
        this.setAttributeWhitelist(["name","tags"]);
        this.setMixedContent(true);
        this.check();
        
    }
}
class edML_Page extends edML_Tag{

    constructor(pageid){
        super();        
        this.setTagWhitelist(edML_Groups.getContainerGroup().concat(["title"]));
        this.setAttributeWhitelist(["name","tags","xml:base","xmlns"]);
        this.setMixedContent(false);
        this.setRequiredAttribute(['name']);
        if(pageid != null){
            this.setAttribute('name',pageid);
        }

        this.check();

        this.setAttribute('tabindex',4);
        this.setAttribute('role','main');
        this.duration = 0; //in s
        this.counter = null; 
        this.maxduration = Infinity;
        
        
    }

    resetCounter(){
        this.stopCounter();
        this.duration = 0;
        if(this.querySelector(':scope > .edml-page-timeoutmsg') != null) this.querySelector(':scope > .edml-page-timeoutmsg').remove();        
    }

    stopCounter(){
        if(this.counter != null) {
            clearInterval(this.counter);        
            this.counter = null;   
        }
        if(this.querySelector(':scope > .edml-page-counter') != null){
            this.querySelector(':scope > .edml-page-counter').remove();
        }
    }

    startCounter(){
        if(this.counter == null) {
            this.counter = setInterval(this.stepCounter.bind(this),1000);
            if(this.querySelector(':scope > .edml-page-counter') == null){
                var counterdiv = document.createElement('div');
                counterdiv.classList.add('edml-page-counter');
                var h = 0;
                var m = 0;
                var s = 0;
                var diff = this.maxduration - this.duration;
                h = parseInt(diff/3600);
                m = parseInt((diff % 3600) / 60);
                s = parseInt(diff % 60);

                if(h == 0) {
                    counterdiv.innerText = edMLPlayer_Util.addLeadingZeros(m,2) + ":" + edMLPlayer_Util.addLeadingZeros(s,2);
                } else {
                    counterdiv.innerText = edMLPlayer_Util.addLeadingZeros(h,2) + ":" + edMLPlayer_Util.addLeadingZeros(m,2) + ":" + edMLPlayer_Util.addLeadingZeros(s,2);
                }
                
                this.prepend(counterdiv);
            }
        }
    }

    stepCounter(){
        this.duration++;
        if(this.querySelector(':scope > .edml-page-counter') != null){
            var h = 0;
            var m = 0;
            var s = 0;
            var diff = this.maxduration - this.duration;
            h = parseInt(diff/3600);
            m = parseInt((diff % 3600) / 60);
            s = parseInt(diff % 60);
            if(diff < 10) this.querySelector(':scope > .edml-page-counter').classList.add('red'); else this.querySelector(':scope > .edml-page-counter').classList.remove('red');

            if(h == 0) {
                this.querySelector(':scope > .edml-page-counter').innerText = edMLPlayer_Util.addLeadingZeros(m,2) + ":" + edMLPlayer_Util.addLeadingZeros(s,2);
            } else {
                this.querySelector(':scope > .edml-page-counter').innerText = edMLPlayer_Util.addLeadingZeros(h,2) + ":" + edMLPlayer_Util.addLeadingZeros(m,2) + ":" + edMLPlayer_Util.addLeadingZeros(s,2);
            }
             
        }

        if(this.duration >= this.maxduration){
            this.setTimeout();
        }
    }

    setTimeout(){
        this.classList.add('timeout');
        if(this.querySelector(':scope > .edml-page-timeoutmsg') == null){
            var timeoutmsg = document.createElement('div');
            timeoutmsg.classList.add('edml-page-timeoutmsg');
            timeoutmsg.innerText = document.edmllocale.get('page.timeout');;
            this.append(timeoutmsg);
            this.stopCounter();
        }
    }


    async setActive(navitem,anchor){                    


        //stop counter of old active page
        this.closest('edml-variant').querySelectorAll('edml-page.active').forEach(function(item){
            item.stopCounter();
        });          
        
        //in test mode: roll parameters, if not yet determined -> every test attempt gets new parameter values
        if(this.closest('edml-variant').querySelector('edml-test.active') != null){
            var isRolled = false;
            this.querySelectorAll('edml-parameter:not([rolled="true"])').forEach(function(item){
                if(item.getAttribute('rolled') != "true"){                   
                    isRolled = true;
                    item.roll();
                    item.setAttribute('rolled','true');
                }
            });

            this.querySelectorAll('edml-parameter').forEach(function(item){        
                let parentbox = item.parentNode;

                while(!(parentbox instanceof edML_Box) && parentbox != null){
                    parentbox = parentbox.parentNode;
                }

                

                if(parentbox != null){   
                    parentbox.querySelectorAll('edml-m').forEach(function(m){
                        m.calculate();
                        m.classList.remove("rendered");    
                        edMLPlayer_Util.typesetMath(m);
                    });
                    
                    parentbox.querySelectorAll('edml-calc').forEach(function(calc){
                        calc.calculate();
                    });

                    
                }                
            
            });

            if(isRolled) {
                const rollEvent = new Event('edmlevent-parameterreroll');
                rollEvent.page = this;
                document.dispatchEvent(rollEvent);                
            }
            
        }

        //clonecontainer
        this.querySelectorAll('edml-clonecontainer').forEach(function(container){
            var from = container.getAttribute('from');
            var original = container.closest('edml-variant').querySelector('*[name="'+from+'"]');
            var nodename = "";
            if(original != null) nodename = original.nodeName.toLowerCase().replace('clonecontainer',"").replace('edml-','');
            var mode = edMLPlayer_Config.get('clonecontainer.mode');
            if(container.getAttribute("mode") != null && mode != "forcenone") mode = container.getAttribute("mode");

            
            if(original != null && edML_Groups.getContainerGroup().indexOf(nodename) > -1){
                if(mode=="deep"){ //deep copy
                    var dom = edML_edML2HTML.parse2dom(original.getEdML());
                    dom.querySelectorAll('*[name]').forEach(function(item){
                        item.removeAttribute('name');
                    });
                    container.parentNode.insertBefore(dom,container);
                    container.remove();
                    
                } else if(mode == "forcenone") {
                } else { //shallow copy
                    original.parentNode.insertBefore(container.cloneNode(),original);
                    container.parentNode.insertBefore(original,container);
                    container.remove();
                }
            }


        });

        //decision?
        this.querySelectorAll('edml-decision').forEach(function(item){
            item.decide();
        });

        //SCORM ?
        if(!this.classList.contains('active') && edMLPlayer_Config.get("player.scorm.enabled") == true){            
            let name = this.getAttribute('name').substring(0,250);
            let suspend_data = null;
            if(navitem != null && navitem.getAttribute('name') != null) suspend_data = navitem.getAttribute('name');
            let description = null;
            if(this.querySelector(':scope > edml-title') != null) description = this.querySelector(':scope > edml-title').innerText.substring(0,250);

            this.scormID = edML_SCORM.saveInteraction(name,'other','page',suspend_data, description,null);

            if(edMLPlayer_Config.get("player.scorm.version") > 2) edML_SCORM.setValue('cmi.location',this.getAttribute('name'));
            edML_SCORM.commit();

            //save result of the last active page inputs on tests
            if(this.closest('edml-variant').querySelector('edml-test.active') != null && this.closest('edml-variant').querySelector('edml-page.active') != null){
                let page = this.closest('edml-variant').querySelector('edml-page.active');
                
                page.querySelectorAll('edml-input,edml-inputblock').forEach(function(item){                   
                    var result = item.verify();
                    item.save2SCORM(result);
                    item.removeAttribute('solved');
                });
            }
            if(this.closest('edml-variant').querySelector('edml-test.active') == null) this.initFromSCORM();
        } 
        
        if(!this.classList.contains('active') && edMLPlayer_Config.get("player.indexeddb.enabled") == true){ 
            var pageobj = await edML_IndexedDB.read('course',edMLPlayer_Config.get("course.name")); 
            if(pageobj != null) {
                pageobj.lastpage = this.getAttribute('name');
            } else {
                pageobj = new Object();
                pageobj.name = edMLPlayer_Config.get("course.name");
                pageobj.lastpage = this.getAttribute('name');
            }
            edML_IndexedDB.write('course',pageobj); 
            //get indexedDB values only when no SCORM is present  
            if(this.closest('edml-variant').querySelector('edml-test.active') == null && edMLPlayer_Config.get("player.scorm.enabled") == false){      
                this.initFromiDB();
            }
        }

        

        
      
        

        window.addEventListener('mathjaxrendered',this.setTabbing.bind(this),{ once: true });
        let promise = edMLPlayer_Util.typesetMath(this); 
        if(promise != null) promise.then(1+1);
        let nav = this.closest('edml-variant').querySelector('edml-navigation');
        //refresh mathjax in navitems
        let promise02 = edMLPlayer_Util.typesetMath(nav); 
        if(promise02 != null) promise02.then(1+1);

        //set anchor
        if(anchor != null && anchor.getAttribute('name') != null){
            
            window.location.hash = anchor.getAttribute('name');
        } else if(navitem != null && navitem.getAttribute('name') != null){
            window.location.hash = navitem.getAttribute('name');
        } else {
            window.location.hash = this.getAttribute('name');
        }
        
        //clean up learnpath stuff
        nav.classList.remove('learnpath');
        
        let lselect = nav.querySelector('edml-navitem.lselect');
        if(lselect != null){
            lselect.classList.remove('lselect');
            lselect.append(nav.querySelector(':scope > edml-navlist'));
        } 

        if(nav.querySelector('.edml-navigation-backbutton') != null) nav.querySelector('.edml-navigation-backbutton').remove();

        if(this.querySelector('.edml-page-learnpathdiv') != null) this.querySelector('.edml-page-learnpathdiv').remove();

        


        //move page title to top
        if(this.querySelector(':scope > edml-title') != null){
            this.prepend(this.querySelector(':scope > edml-title'));
        } 

        //make page active
        if(this.closest('edml-variant').querySelector('edml-page.active') != null) { 
            this.closest('edml-variant').querySelector('edml-page.active').classList.remove('active');
        }
        this.classList.add('active');                
        //scroll to top
        window.scrollTo(0,0);
        this.scrollTo(0,0);

        

        // do learnpath staff

        if(navitem != null && edMLPlayer_Config.get('navigation.shortenlearnpath') == true) {
            //is navitem learnpath? --> hide Container if true 
            
            let spacer = null;
            if(navitem.getAttribute('roles') != null && navitem.getAttribute('roles').toLowerCase().split(' ').indexOf('learnpath') > -1){
                for(let i = 0; i < this.childNodes.length; i++){
                    if(edML_Groups.getContainerGroup().indexOf(this.childNodes[i].nodeName.toLowerCase().replace('edml-','')) > -1){
                        this.childNodes[i].classList.add('hide');
                       
                    }
                }
            } else {
                spacer = document.createElement('div');
                spacer.classList.add('edml-page-spacer');                
            }

            
            // test if one navitem in hierarchy above is learnpath
            let islearnpathchild = false;
            let lparent = navitem.parentNode.closest('edml-navitem');
            while(lparent != null && islearnpathchild == false){                
                if(lparent.getAttribute('roles') != null && lparent.getAttribute('roles').toLowerCase().split(' ').indexOf('learnpath') > -1){
                    islearnpathchild = true;
                    
                } else {
                    lparent = lparent.parentNode.closest('edml-navitem');
                }
            }
            

            if(islearnpathchild || (navitem.classList.contains('learnpath'))){
                nav.classList.add('learnpath');
            }


            //has navitem learnpath elements?
            let learnpaths = new Array();
            navitem.querySelectorAll(':scope > edml-navlist > edml-navitem[roles]').forEach(function(item){
                var roles = item.getAttribute('roles').split(" ");
                if(roles.indexOf('learnpath') > -1){
                    if(item.getAttribute('visible') != "false") learnpaths.push(item);
                }
            });
               
            if(learnpaths.length > 0) {
                
                let learnpathdiv = document.createElement('div');
                learnpathdiv.classList.add('edml-page-learnpathdiv');
                this.append(learnpathdiv);

                if(spacer != null) learnpathdiv.append(spacer);

                let learnpathtitle = document.createElement('div');
                learnpathtitle.innerHTML = document.edmllocale.get('learnpathtitle');
                learnpathdiv.append(learnpathtitle);

                

                let learnpathselector = document.createElement('div');
                learnpathselector.classList.add('edml-page-learnpathselector');

                let learnpathselectorleft = document.createElement('div');
                learnpathselectorleft.classList.add('edml-page-learnpathselector-left');
                

                learnpathselector.append(learnpathselectorleft);

                for(let i = 0; i < learnpaths.length; i++){
                    let lpbutton = document.createElement('div');
                    lpbutton.classList.add('edml-page-learnpathbutton');
                    lpbutton.innerHTML = learnpaths[i].querySelector('edml-ref').innerHTML;
                    lpbutton.addEventListener('click',this.learnpathbuttonClick.bind(this,learnpaths[i],lpbutton));
                    learnpathselectorleft.append(lpbutton);
                    
                }

                //back button
                if(navitem.getAttribute('roles') != null && navitem.getAttribute('roles').toLowerCase().split(' ').indexOf('learnpath') > -1 && navitem.parentNode != null && navitem.parentNode.closest('edml-navitem') != null){         
                    let backbutton = document.createElement('div');
                    backbutton.classList.add('edml-btn');
                    backbutton.classList.add('edml-page-learnpathbackbtn');
                    learnpathselectorleft.append(backbutton);

                    backbutton.addEventListener('click',function(){
                        var nitem = navitem.parentNode.closest('edml-navitem');
                        while(nitem != null && nitem.getAttribute('visible') == "false"){
                            nitem = nitem.parentNode.closest('edml-navitem');
                        }
                        if(nitem != null) nitem.click();
                    });
                }
                
                
                if(navitem.getAttribute('learnpathinfo') != "false"){
                    let learnpathselectorright = document.createElement('div');
                    learnpathselectorright.classList.add('edml-page-learnpathselector-right');

                    learnpathselector.append(learnpathselectorright);
                }                    

                learnpathdiv.append(learnpathselector);
          
                if(this.querySelector('.edml-page-learnpathbutton') != null){
                    //if(parseInt(window.innerWidth) > 799 && navitem.getAttribute('learnpathinfo') != "false") this.querySelector('.edml-page-learnpathbutton').click();
                    //this.querySelector('.edml-page-learnpathbutton').classList.add('selected');
                }

                 

            } else {

            

                // goto first page of learnpath
                if(navitem.classList.contains('learnpath') && navitem.querySelector('edml-navlist edml-navitem') != null){                    
                   /* window.history.go(-1);*/
                    //navitem.classList.add('lselect');
                    navitem.querySelector('edml-navlist edml-navitem').click();
                    
                }
            }

           //build learnpath navigation -> move navlist to top, mark position if neccessary
            if((nav.classList.contains('learnpath') || islearnpathchild) && edMLPlayer_Config.get('navigation.shortenlearnpath') == true){                
                
                //placeholder = document.createElement('div');
                //placeholder.classList.add('edml-navigation-placeholder');
                let item = navitem;
                if(islearnpathchild && !navitem.classList.contains('learnpath')) item = lparent;
                item.classList.add('lselect');
                let navlist = item.querySelector('edml-navlist');
                console.log(navlist);
                if(navlist != null){
                    let bbutton = document.createElement('div');
                    bbutton.classList.add('edml-navigation-backbutton');
                    navlist.append(bbutton);
                    let parent = item.parentNode.closest('edml-navitem');
                    

                    bbutton.addEventListener('click',function(){
                        var navitem = parent.closest('edml-navitem');
                        while(navitem != null && navitem.getAttribute('visible') == "false"){
                            navitem = navitem.parentNode.closest('edml-navitem');
                        }
                        if(navitem != null) navitem.click();
                        
                    });
                    
                    nav.insertBefore(navlist,nav.querySelector('.edml-navigation-toolbar').nextElementSibling);

                }
            }
                        

        } else {
            

            if(lselect != null){
                lselect.classList.remove('lselect');
                lselect.append(nav.querySelector(':scope > edml-navlist'));
            }     
        }

       //rename all autorefs on page
        this.querySelectorAll('edml-autoref').forEach(function(item){
            item.rename();
        });

        //rename all refnumbers
        this.querySelectorAll('edml-refnumber').forEach(function(item){
            item.rename();
        });

        //rename all auto-descriptor in current language
        /* this.querySelectorAll('edml-descriptor.edml-autodescriptor').forEach(function(item){
            item.rename();
        });*/
    

        this.renderEdML();

        //counter
        if(this.closest('edml-variant').querySelector('edml-test.active') != null && this.closest('edml-variant').querySelector('edml-test.active edml-testitem.selected') != null){
            if(this.closest('edml-variant').querySelector('edml-test.active edml-testitem.selected').getAttribute('maxduration') != null){
                var duration = this.closest('edml-variant').querySelector('edml-test.active edml-testitem.selected').getAttribute('maxduration').split(':');
                this.maxduration = 0;

                for(var i = duration.length-1; i >= 0; i--){
                    this.maxduration += Math.pow(60,i)*parseInt(duration[duration.length-i-1]);
                } 
    
                if(isNaN(this.maxduration)) this.maxduration = 0;
                this.startCounter();
            }
        }

        //open all chevrons for selected navitem        
        var opennavitem = this.closest('edml-variant').querySelector('edml-navitem.selected');
        while(opennavitem != null){
            opennavitem = opennavitem.parentNode;
            if(opennavitem != null) opennavitem = opennavitem.closest('edml-navitem');
            if(opennavitem != null && opennavitem.getAttribute('role') != "learnpath") {
                
                opennavitem.classList.remove('close');
                opennavitem.classList.add('open');
            }
        }
        
       
       
        //fire global event
        let event = new Event("edmlevent-newpage");
        event.page = this;
        event.anchor = anchor;
        event.navitem = navitem;
        window.dispatchEvent(event);

        //fire page event
        let event2 = new Event("edmlevent-pageactive");
        event2.page = this;
        event2.anchor = anchor;
        event2.navitem = navitem;
        this.dispatchEvent(event2);

       
    }

    setTabbing(){
        this.querySelectorAll('edml-input').forEach(function(item){
            item.setAttribute('tabindex',0);
        });

        
        this.querySelectorAll('mjx-container').forEach(function(item){
            item.setAttribute('tabindex','-1');
        });
    }

    //render special edML components
    renderEdML(){

        //load pictures
        this.querySelectorAll('edml-picture').forEach(function(item){       
            item.firstload();
        });  

        //make externalmedia/iframes visible            
        this.querySelectorAll('edml-externmedia > .edml-externalmedia-iframe').forEach(function(item){        
            item.style.visibility = "visible";
        });  
    


        this.querySelectorAll(':scope edml-list').forEach(function(item){
            item.setIndent();
        });

        this.querySelectorAll('edml-externmedia').forEach(function(item){
            item.start();
        });

        this.querySelectorAll('edml-picture').forEach(function(item){
            item.resize();
        });

       /* this.querySelectorAll('edml-choice').forEach(function(item){
            item.resize();
        });


        //set z-index for page > * that's for overflowing choice elements
        let len = [...this.querySelectorAll(':scope > *')].length;
        this.querySelectorAll(':scope > *').forEach(function(item){
            item.style.zIndex = len;
            len--;
        });*/

        
   

    }

    learnpathbuttonClick(learnpath,lpbutton){
       
        if(lpbutton.classList.contains('selected')){
            learnpath.click();
            
        } else {
        
            let right = this.querySelector('.edml-page-learnpathselector-right');
            if(right != null){
                right.innerHTML = "";
                right.classList.add('show');    
                let title = document.createElement('div');
                title.classList.add('edml-page-learnpathdescriptiontitle');
                right.append(title);

                let learnpathtitleleft = document.createElement('div');
                learnpathtitleleft.classList.add('edml-page-learnpathtitle-left')                
                title.append(learnpathtitleleft);

                let startbtnsmall = document.createElement('div');
                startbtnsmall.classList.add('edml-btn');
                startbtnsmall.classList.add('edml-page-learnpath-startbtnsmall');
                learnpathtitleleft.append(startbtnsmall);

                startbtnsmall.addEventListener('click',function(){
                    learnpath.click();
                });

                let learnpathtitlemiddle = document.createElement('div');
                learnpathtitlemiddle.classList.add('edml-page-learnpathtitle-middle')                
                learnpathtitlemiddle.innerText = lpbutton.innerHTML;// document.edmllocale.get('learnpathtitlemiddle');
                title.append(learnpathtitlemiddle);
            
                let learnpathtitleright = document.createElement('div');
                learnpathtitleright.classList.add('edml-page-learnpathtitle-right')                
                title.append(learnpathtitleright);

                if(this.querySelector('.edml-page-learnpathbutton.selected') != null) this.querySelector('.edml-page-learnpathbutton.selected').classList.remove('selected');
                lpbutton.classList.add('selected');
                let page = null;
                let navitem = learnpath;
                let i = 0;
                while(page == null && navitem != null && navitem.querySelector('edml-ref') != null && i < 100){
                    navitem = this.closest('edml-variant').querySelector('*[name="'+navitem.querySelector('edml-ref').getAttribute('to')+'"]');
                    if(navitem != null && navitem.closest('edml-navigation') == null){ // no navitem
                        page = navitem.closest('edml-page');
                    }
                    i++;
                }
                if(page != null){
                    //copy containers
                    /*for(let i = 0; i < page.childNodes.length; i++) {
                        if(edML_Groups.getContainerGroup().indexOf(page.childNodes[i].nodeName.toLowerCase().replace('edml-','')) > -1) {
                            let clone = page.childNodes[i].cloneNode(true);
                            clone.classList.remove('hide');
                            if(clone.getAttribute('name') != null) clone.removeAttribute('name');
                            right.append(clone);
                        }
                    }*/
                    //right.insertAdjacentHTML("beforeend",edML_edML2HTML.parse2string(page.getInnerEdML()));                   
                    right.append(edML_edML2HTML.parse2dom(page.getInnerEdML()));
                    
                    if(right.querySelector(':scope > edml-title') != null) right.querySelector(':scope > edml-title').remove();
                    
                    

                    this.renderEdML();

                    edMLPlayer_Util.typesetMath(this);

                    
                    
                } 
                
                //add start button
                let startbtn = document.createElement('div');
                startbtn.classList.add('edml-btn');
                startbtn.classList.add('edml-page-learnpath-startbtn');
                startbtn.innerText = document.edmllocale.get('learnpathstartbtn');
                right.append(startbtn);

                startbtn.addEventListener('click',function(){
                    learnpath.click();
                });

                //add overview back button
                let viewbtn = document.createElement('div');
                viewbtn.classList.add('edml-btn');
                viewbtn.classList.add('edml-page-learnpath-viewbtn');
                viewbtn.innerText = document.edmllocale.get('learnpathviewbtn');
                right.append(viewbtn);
                right.parentNode.classList.add('showright');

                viewbtn.addEventListener('click',function(){
                    right.parentNode.classList.remove('showright');
                });
            } else {
                learnpath.click();
            }
            
        }
    }


    initFromiDB(){
        this.querySelectorAll('edml-input, edml-inputblock, edml-booleangroup').forEach(function(item){
            if(item.initFromiDB != null) item.initFromiDB();
        }.bind(this));

    }

    initFromSCORM(){
        let idx = -1;
        let namesarr = new Array();
        let itemsarr = new Array();
        this.querySelectorAll('edml-input, edml-inputblock, edml-booleangroup').forEach(function(item){          
            let name = null;
            let n = -1;
            idx++;
            
            //create id
            if(item.getAttribute('name') != null) name = item.getAttribute('name');
            if(name != null && name.replace(/[a-zA-Z0-9]*/,"") != "") name = null;  //only numbers and letters for scorm ids
            
            if(name == null) {
                name = this.getAttribute('name').substring(0,500) + "_input";
                let idx = item.getAttribute('inputcounter');
                while (idx.length < 4) idx = "0" + idx;                
                name = name + idx;

            } 
            namesarr.push(name);
            itemsarr.push(item);

        }.bind(this));


            

        //get entry number
        let i = 0;
        let max = edML_SCORM.getValue('cmi.objectives._count');                        
        let objnamearr = new Array();
        
        for(let i = 0; i < max; i++){
            objnamearr.push(edML_SCORM.getValue('cmi.objectives.'+i+'.id').split('#')[0].trim());
        }
        
        let lidx;
        for(let i = 0; i < namesarr.length; i++){
            lidx = objnamearr.lastIndexOf(namesarr[i]);
            if(lidx > -1){
                itemsarr[i].initFromSCORM(lidx);
            }
        }
                           
        
    }

}



class edML_Pages extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist("page");
        this.setAttributeWhitelist(["name","tags"]);
        this.setMixedContent(false);
        this.check();

    }


}
class edML_Panel extends edML_Tag{

    constructor(value){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup().concat(["title"]));
        this.setAttributeWhitelist(["name","tags"]);
        this.setRequiredTag(["title"]);
        this.setMixedContent(false);
        if(value != null) this.innerHTML = value;
        
      /*  if(this.querySelector(':scope > edml-title') == null){
            let title = new edML_Title(" ");
            this.prepend(title);
        }*/
        
        this.check();

        let title = this.querySelector(':scope > edml-title');                
            
        title.addEventListener('click',function(){
            if(!this.classList.contains('show')){                    
                this.parentNode.querySelectorAll(':scope > edml-panel.show').forEach(function(panel){
                    panel.classList.remove('show');
                });
            }
            
            
            this.classList.toggle('show');
            
            if(this.parentNode instanceof edML_Tabset){       
                this.classList.add('show');                         
                this.parentNode.changeView(this);
            }

        }.bind(this));
        
        if(this.parentNode instanceof edML_Tabset){
            
            //title must be first
            if(this.querySelector('edml-title') != null){
                this.prepend(this.querySelector('edml-title'));
            }

            if(this.parentNode.querySelector(':scope > edml-panel.show') == null) {
                this.classList.add('show');
                this.parentNode.changeView(this);
                
            }
                                    
        
        }
              
        
       
    }
}
class edML_Parameter extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["value","range"]);
        this.setAttributeWhitelist(["identifier"]);
        this.setRequiredAttribute(["identifier"]);
        this.setRequiredTag([["value","range"]]);
        this.setMixedContent(false);
        this.check();
        
        
        this.roll();

    }

    connectedCallback(){
       
    }

    roll(){        
        let parentbox = this.parentNode;

        while(!(parentbox instanceof edML_Box) && parentbox != null){
            parentbox = parentbox.parentNode;
        }
   
        if(parentbox != null){ 
            if(parentbox.parameters == null || parentbox.parameters == undefined) {
                parentbox.parameters = new Array();
                parentbox.values = new Array();
            } 

            //check if parameter already marked as rolled
            if(this.getAttribute('rolled') != "true"){
                //if parentbox have already that identifier, remove it
                if(parentbox.parameters.indexOf(this.getAttribute('identifier')) != -1){
                    //console.log("delete parameter");
                    let removei = parentbox.parameters.indexOf(this.getAttribute('identifier'));
                    parentbox.parameters.splice(removei,1);
                    parentbox.values.splice(removei,1);
                }

                parentbox.parameters.push(this.getAttribute('identifier'));
                
                


                var value = this.calculate();
                
                //check for parametergroup, reroll if neccessary, maximal 1000 rerolls
                if(this.closest('edml-parametergroup') != null && (this.closest('edml-parametergroup').getAttribute('pairwisedistinct') == "true" || this.closest('edml-parametergroup').getAttribute('pairwisecoprime') == "true" )){
                    let pgroup = new Array(); 
                    this.closest('edml-parametergroup').querySelectorAll(':scope > edml-parameter').forEach(function(item){
                        pgroup.push(parentbox.parameters.indexOf(item.getAttribute('identifier')));
                    });
                    var reroll = false;
                    if(this.closest('edml-parametergroup').getAttribute('pairwisedistinct') == "true") reroll = this.checkrerollPairwisedistinct(pgroup,value,parentbox);
                    if(reroll == false && this.closest('edml-parametergroup').getAttribute('pairwisecoprime') == "true" && Number.isInteger(value)) reroll = this.checkrerollPairwisecoprime(pgroup,value,parentbox);
                    var n = 0;      
                    var nmax = 1000;     
                    while(reroll && n < nmax){
                        reroll = false;
                        value = this.calculate();
                     
                        if(this.closest('edml-parametergroup').getAttribute('pairwisedistinct') == "true") reroll = this.checkrerollPairwisedistinct(pgroup,value,parentbox);
                        if(reroll == false && this.closest('edml-parametergroup').getAttribute('pairwisecoprime') == "true" && Number.isInteger(value)) reroll = this.checkrerollPairwisecoprime(pgroup,value,parentbox);

                        n++;   
                    }               
                    if(n == nmax && reroll){
                        edML_Error.push("0013",this.closest('edml-parametergroup').outerHTML,parentbox.textContent);
                        edML_Error.printLast(); 
                    }

                    
                }  



                parentbox.values.push(value);

                //save parameter to scorm? 
            
                if(edMLPlayer_Config.get("player.scorm.enabled") == true && (edMLPlayer_Config.get('player.scorm.testonly') != true || document.querySelector('edml-test.active') != null)){

                    if(parentbox != null && parentbox.closest('edml-page') != null && parentbox.values != null && parentbox.values.length > 0){
                        //last one?
                        var paramnodes = [...parentbox.querySelectorAll('edml-parameter')];
                        if(paramnodes.length == parentbox.parameters.length){
                            var name = parentbox.getAttribute('name');
                            if(name == null){
                                name = parentbox.closest('edml-page').getAttribute('name');   
                                var boxes = edML_Groups.getBoxGroupQuerySelector();
                                var idx = [...parentbox.closest('edml-page').querySelectorAll(boxes)].indexOf(parentbox);
                                name += "_box"+(parseInt(idx)+1);
                            }

                            var paramstring = "";
                            for(var i = 0; i < parentbox.values.length; i++){
                                paramstring += ',"'+parentbox.parameters[i]+'":'+'"'+parentbox.values[i]+'"';
                            }
                            // paramstring = "{" + paramstring.substring(1) +"}";  Moodle don't accept { }  !!!
                            paramstring =  paramstring.substring(1);
                            
                            //console.log(parentbox.parameters);

                            //save or load old data?
                            var scormval = edML_SCORM.getInteractionValueByID('cmi.interactions.n.description',name);
                            
                            if(scormval != null && scormval != "" && document.querySelector('edml-test.active') == null){
                                var obj = JSON.parse('{' + scormval + '}');
                                //console.log(obj);
                                var idx;
                                for(var n = 0; n < parentbox.parameters.length; n++){

                                    if(obj[parentbox.parameters[n]] != null){
                                        parentbox.values[n] = obj[parentbox.parameters[n]];
                                        //console.log("parameter " + parentbox.parameters[n] + " loaded: " + parentbox.values[n]);
                                    }
                                }
                            } else {
                                //console.log("saved: " + paramstring);
                                edML_SCORM.saveInteraction(name,'other','parameter',null,paramstring,null);
                            }
                        }
                    }
                }
            }
        }
    }

    checkrerollPairwisedistinct(pgroup,value,parentbox){
        var reroll = false;
        for(var i = 0; i < pgroup.length; i++){    
            if(parentbox.values[pgroup[i]] != null && parentbox.values[pgroup[i]] == value){
                reroll = true;
            }    
        }
        return reroll;
    }


    checkrerollPairwisecoprime(pgroup,value,parentbox){
        var reroll = false;
        var arr = edMLPlayer_Util.getPrimeSet(value);
        for(var i = 0; i < pgroup.length; i++){   
            if(parentbox.values[pgroup[i]] != null && Number.isInteger(parentbox.values[pgroup[i]])) {
                arr = arr.concat(edMLPlayer_Util.getPrimeSet(parentbox.values[pgroup[i]]));
            }
             
        }
 
        const duplicates = arr.filter((item, index) => arr.some((elem, idx) => elem === item && idx !== index));
        if(duplicates.length != 0) reroll = true;
        return reroll;
    }

    


    calculate(){
        //calculate max weight
        let maxweight = 0;
        this.querySelectorAll(':scope > edml-value, :scope > edml-range').forEach(function(item){
            if(item.getAttribute('weight') != null){
                maxweight += parseFloat(item.getAttribute('weight'));
            } else {
                maxweight += 1;
            }
        });

        //determine which range/value
        let random = Math.random() * maxweight;
        let weight = 0;
        let selected = null;
        let oldweight = 0;
        this.querySelectorAll(':scope > edml-value, :scope > edml-range').forEach(function(item){
            
            if(item.getAttribute('weight') != null){
                weight += parseFloat(item.getAttribute('weight'));
            } else {
                weight += 1;
            }
            if(random < weight && random >= oldweight &&  selected == null){
                selected = item;
            }
            oldweight = weight;
        });

        //calculate number       
        let value = 42;  
        if(selected.nodeName.toLowerCase() == "edml-value"){
            value = parseFloat(selected.innerText);
        } else if(selected.nodeName.toLowerCase() == "edml-range"){
            //edges included
            let closure = "closed";
            if(selected.getAttribute("closure") != null) closure = selected.getAttribute('closure');

            let min = parseFloat(selected.querySelector(':scope > edml-value').innerText); 
            let max = parseFloat(selected.querySelector(':scope > edml-value:nth-of-type(2)').innerText); 
            let h = min;
            if(max < min) {
                min = max;
                max = h;
            }
            let step = 1E-15;
            if(selected.getAttribute('step') != null) step = parseFloat(selected.getAttribute('step'));
            
            if(closure == "open"){
                let width = Math.abs(max-min) / step - 1; // -1 to exclude all edges
                value = min + Math.floor(Math.random() * width) * step + step;
            } else if(closure == "openclosed") {
                let width = Math.abs(max-min) / step; 
                value = min + Math.floor(Math.random() * width) * step + step;
            } else if(closure == "closedopen") {
                let width = Math.abs(max-min) / step; 
                value = min + Math.floor(Math.random() * width) * step;
            } else {  //closed (default)
                let width = Math.abs(max-min) / step + 1; // +1 to include all edges
                value = min + Math.floor(Math.random() * width) * step;
            }                                
        }
        return value;
        
    }

}
class edML_Parametergroup extends edML_Tag{


    constructor(){
        super();
        this.setTagWhitelist(["parameter"]);
        this.setAttributeWhitelist(["pairwisedistinct","pairwisecoprime"]);
        this.setMixedContent(false);
        this.setRemoveContentByClass([]);
        this.setRequiredAttribute([]);
        this.check();
    }


}
class edML_Picture extends edML_Tag{

    constructor(iszip = false){
        super();       
        this.setTagWhitelist(["metadata"]);
        this.setAttributeWhitelist(["filepath","name","minwidth","minheight","maxwidth","maxheight","tags"]);
        this.setRequiredAttribute(["filepath"]);
        this.setRequiredTag(["metadata"]);
        this.setOnlyOnceTag(["metadata"]);
        this.check();
          
        
        
        //this.reload();
        
        
         
    }

    firstload(){
        if(this.getAttribute('loaded') == null){
            this.reload();
        }
    }

    reload(){
        let path = "";                      
        if(this.getAttribute('filepath') != null) path = this.getAttribute('filepath');
        
        
        
        let div = this.querySelector('.edmlplayer-imagecontainer');
        if(div == null){
            div = document.createElement('div');
            div.classList.add('edmlplayer-imagecontainer');
        } else {
            if(div.querySelector('img') != null) div.querySelector('img').remove();
        }
            
        let imgobj;
        let img = document.createElement('img');
        imgobj = img;
        img.setAttribute('loading','lazy');
        this.setAttribute('loaded','pending');
        this.width = null;
        this.height = null;
        this.connected = false;
        
        if(edMLPlayer_Config.get("player.file") == null) img.setAttribute('src',path);      
        let ratio = edMLPlayer_Config.get("player.fontsize") / edMLPlayer_Config.get("player.defaultfontsize");
        /*if(this.getAttribute('minwidth') != null) {
            img.style.minWidth = this.getAttribute('minwidth');
            //div.style.minWidth = this.getAttribute('minwidth');
            //this.style.minWidth = this.getAttribute('minwidth');
        }
        if(this.getAttribute('minheight') != null) {
            img.style.minHeight = this.getAttribute('minheight');
            //div.style.minHeight = this.getAttribute('minheight');
            //this.style.minHeight = this.getAttribute('minheight');
        }
        if(this.getAttribute('maxwidth') != null) {
            img.style.maxWidth = this.getAttribute('maxwidth');
            //div.style.maxWidth = this.getAttribute('maxwidth');
            //this.style.maxWidth = this.getAttribute('maxwidth');
        } 

        if(this.getAttribute('maxheight') != null) {
            img.style.maxHeight = this.getAttribute('maxheight');
            //div.style.maxHeight = this.getAttribute('maxheight');
            //this.style.maxHeight = this.getAttribute('maxheight');
        } 

        if(this.getAttribute('maxheight') == null && this.getAttribute('minheight') == null && this.getAttribute('maxwidth') == null && this.getAttribute('minwidth')){
            img.style.maxWidth = "800px";
            img.style.maxHeight = "30vh";
        }*/
        this.resize();

        div.append(imgobj);
        this.prepend(div);      
 
        
        if(edMLPlayer_Config.get("player.file") != null && edMLPlayer_Config.get("player.render.picture") && edMLPlayer_Config.get("player.isZip")) {       //zip file?                  
            this.addEventListener('edmlevent-pictureloaded',function(event){
                if(event.url == null && event.data == null){
                    this.setAttribute('loaded','filenotfound');
                } else {
                    if(path.indexOf('.svg') > 0){                                      
                        var base64 = window.btoa(unescape(encodeURIComponent(event.data)));
                        var imgSource = 'data:image/svg+xml;base64,'+base64;
                        img.setAttribute('src',imgSource);
                        
                    } else {
                        img.setAttribute('src',event.url);
                    }
                    this.setAttribute('loaded','loaded');
                    if(img.naturalWidth != 0) img.style.width = img.naturalWidth;
                    if(img.naturalHeight != 0) img.style.height = img.naturalHeight
                    this.resize();
                    let obj = this;
                    window.setTimeout(function(){obj.resize();},150); //for svg
                }   
               
            }.bind(this));
        } else {
            //no zip file
            if(path.indexOf("./") == 0) path = path.substring(2);         
            let dir = edMLPlayer_Config.get("player.file").substr(0,edMLPlayer_Config.get("player.file").lastIndexOf('/')+1);
            if(edMLPlayer_Config.get("player.ressourcepath") != ""){
                path = edMLPlayer_Config.get("player.ressourcepath") + path;
            } else {
                path = dir + path;  
            }

      
            
            img.setAttribute("src",path);
            this.setAttribute('loaded','loaded');
            img.addEventListener('load',function(){this.width = img.naturalWidth;this.height = img.naturalHeight;this.resize();}.bind(this));
            if(img.naturalWidth != 0) img.style.width = img.naturalWidth;
            if(img.naturalHeight != 0) img.style.height = img.naturalHeight
            this.resize();
            
            
        }   
        
        // info dialog 
        
        img.addEventListener('contextmenu', function(evt) {   
            evt.preventDefault();
            if(this.querySelector(':scope > edml-metadata') != null){
                let text = this.querySelector(':scope > edml-metadata').getText();
            
                let dlg = new edML_Dialog();
                dlg.setTitle(document.edmllocale.get("dialog_pictureinfo_title"),this.closest('edml-variant').getAttribute('lang'));        
                dlg.setBody(text);
                dlg.hideFooter();
                dlg.show();
            }
        }.bind(this), false);
        

        if(edMLPlayer_Config.get("player.file") != null && edMLPlayer_Config.get("player.render.picture") && edMLPlayer_Config.get("player.isZip")) {    
            this.getURLdata();
            this.resize();
        }
    }

    connectedCallback(){
        if(edMLPlayer_Config.get("player.file") != null && edMLPlayer_Config.get("player.render.picture") && edMLPlayer_Config.get("player.isZip")) {    
            this.getURLdata();
            this.resize();
        } else {                    
        }

        if(this.connected == false){
          /*  console.log(this.clientWidth);
            this.connected = true;
            let parent = this.parentNode;
            let next = this.nextElementSibling;
            let help = this.querySelector('img');
            document.body.append(help);
            console.log(help.naturalWidth);
           // parent.insertBefore(this,next);*/

        }
        /*this.closest('edml-variant').classList.add('forceshow');
        this.closest('edml-page').classList.add('active');*/
        
       /* this.closest('edml-page').classList.add('remove');
        this.closest('edml-variant').classList.remove('forceshow');*/
    }
    
    getEdML(){
        return this.edml;
        
    }
    


    resize(){
        let img = this.querySelector(':scope > .edmlplayer-imagecontainer > img');
        let div = this.querySelector(':scope > .edmlplayer-imagecontainer');
        if(img != null && img.complete && div != null){
            let val = (edMLPlayer_Config.get("player.fontsize") / edMLPlayer_Config.get("player.defaultfontsize"));
            let activep = this.closest('edml-page').classList.contains('active');
            let activev = this.closest('edml-variant').classList.contains('active');
            this.closest('edml-page').classList.add('active');
            this.closest('edml-variant').classList.add('active');
           
            


            //console.log(this.querySelector('img'));

            if(this.getAttribute('maxwidth') != null){
                img.style.maxWidth = (parseFloat(this.getAttribute('maxwidth')) * val) + this.getAttribute('maxwidth').replaceAll(/[0-9. ]/g,'');
                //this.style.maxWidth = (parseFloat(this.getAttribute('maxwidth')) * val) + this.getAttribute('maxwidth').replaceAll(/[0-9. ]/g,'');
                //div.style.maxWidth = (parseFloat(this.getAttribute('maxwidth')) * val) + this.getAttribute('maxwidth').replaceAll(/[0-9. ]/g,'');
            } 

            if(this.getAttribute('minwidth') != null){
                img.style.minWidth = (parseFloat(this.getAttribute('minwidth')) * val) + this.getAttribute('minwidth').replaceAll(/[0-9. ]/g,'');
                if(this.getAttribute('minwidth').indexOf('%') > -1){
                    this.style.minWidth = (parseFloat(this.getAttribute('minwidth')) * val) + this.getAttribute('minwidth').replaceAll(/[0-9. ]/g,'');
                    div.style.minWidth = (parseFloat(this.getAttribute('minwidth')) * val) + this.getAttribute('minwidth').replaceAll(/[0-9. ]/g,'');
                }
            }

            if(this.getAttribute('minheight') != null){
                img.style.minHeight = (parseFloat(this.getAttribute('minheight')) * val) + this.getAttribute('minheight').replaceAll(/[0-9. ]/g,'');
                //this.style.minHeight = (parseFloat(this.getAttribute('minheight')) * val) + this.getAttribute('minheight').replaceAll(/[0-9. ]/g,'');
                //div.style.minHeight = (parseFloat(this.getAttribute('minheight')) * val) + this.getAttribute('minheight').replaceAll(/[0-9. ]/g,'');
            }

            if(this.getAttribute('maxheight') != null){
                img.style.maxHeight = (parseFloat(this.getAttribute('maxheight')) * val) + this.getAttribute('maxheight').replaceAll(/[0-9. ]/g,'');
                //this.style.maxHeight = (parseFloat(this.getAttribute('maxheight')) * val) + this.getAttribute('maxheight').replaceAll(/[0-9. ]/g,'');
                //div.style.maxHeight = (parseFloat(this.getAttribute('maxheight')) * val) + this.getAttribute('maxheight').replaceAll(/[0-9. ]/g,'');
            }

            //no width & height given
            if(this.getAttribute('maxheight') == null && this.getAttribute('minheight') == null && this.getAttribute('maxwidth') == null && this.getAttribute('minwidth') == null){
                

                if(img.naturalHeight != 0 && img.naturalHeight != 0){         
                    let width = img.naturalWidth ;
                    let height = img.naturalHeight;
                    //autoscale to max 30vh and 800px
                    if(height > edMLPlayer_Config.get("player.render.maxheight")){
                        let ratio = width/height;
                        height = edMLPlayer_Config.get("player.render.maxheight");
                        width = ratio * height;
                    }

                    if(width > edMLPlayer_Config.get("player.render.maxwidth")){
                        let ratio = height/width;
                        width = edMLPlayer_Config.get("player.render.maxwidth");
                        height = ratio * width;
                    }

                    img.style.width = width * val + "px";
                    img.style.height = height * val + "px";
                    //console.log("natural");
                } else if(this.width != null && this.width != 0 && this.height != 0 && this.height != null) {
                    img.style.width = this.width * val + "px";
                    img.style.height = this.height * val + "px";
                    //console.log("has limits");
                } else {
                    img.style.width = (edMLPlayer_Config.get("player.render.fallbackwidth") * val) + "px";
                    img.style.maxHeight = (edMLPlayer_Config.get("player.render.fallbackheight") * val) + "px";
                    img.style.maxWidth = (edMLPlayer_Config.get("player.render.maxwidth") * val) + "px";   
                    img.style.maxHeight = (edMLPlayer_Config.get("player.render.maxheightvh") * val) + "vh";                    
                   // console.log("default");
                }
    

            }


            if(activep == false) this.closest('edml-page').classList.remove('active');
            if(activev == false) this.closest('edml-variant').classList.add('active');
        }
        
    }
    
    async getURLdata(){        
        let event = new Event('edmlevent-pictureloaded');
        let path = this.getAttribute('filepath').trim();
        
        if(path.indexOf("./") == 0) path = path.substring(2); //zip file        

        if(this.getAttribute('filepath').indexOf('.svg') > 0){    
                let data =  await edMLPlayer_Config.get("player.file").files[path].async("string") ;
                event.url = null;
                event.data = data;            
        } else {
            let url = "";                  
            if(edMLPlayer_Config.get("player.file").files[path] != null){
                let blobdata =  await edMLPlayer_Config.get("player.file").files[path].async("blob") ;
                url = URL.createObjectURL(blobdata);
                event.url = url;
                event.data = null;
            } else {
                console.error('file not found: ' + path);                
            }
            
        }                    
        
        
        this.dispatchEvent(event);
    
    }

   getEdML(){
        let metadata = '';
        if(this.querySelector(':scope > edml-metadata') != null) metadata += this.querySelector(':scope > edml-metadata').getEdML();

        let attr = "";
        for(let i = 0; i < this.getAttributeWhitelist().length; i++){
            if(this.getAttribute(this.getAttributeWhitelist()[i]) != null) attr += " "+this.getAttributeWhitelist()[i]+'="' +this.getAttribute(this.getAttributeWhitelist()[i]).replaceAll('&','&amp')+'"'; 
        } 
        return '<picture'+attr+'>' + metadata + '</picture>';
    }
    
}
class edML_Poolview extends edML_View{

    constructor(){
        super();        
        this.setTagWhitelist(edML_Groups.getContainerGroup().concat(["title"]));
        this.setAttributeWhitelist(["name","tags","label","amount","allowrefresh","shuffle"]);
        this.setRequiredTag([]);
        this.setOnlyOnceTag(["title"]);
        this.setMixedContent(false);
        
        if(this.querySelector(':scope > *:not(edml-title)') == null){            
            this.prepend(new edML_Groupview);
        }        
        this.check();

        
    
    }


    onRefresh(){
        let amount = edMLPlayer_Config.get('poolview.amount');

        

        if(this.getAttribute('amount') != null && !isNaN(parseInt(this.getAttribute('amount')))) amount = parseInt(this.getAttribute('amount'));
        let groups = [...this.querySelectorAll(':scope > .unused')];

        if(groups.length == 0){
            this.querySelectorAll(':scope > *:not(.edml-poolview-refreshbtn)').forEach(function(item){            
                if(!(item instanceof edML_Title)) item.classList.add('unused');
            });

            groups = [...this.querySelectorAll(':scope > .unused')];
            this.querySelector(':scope > .edml-poolview-refreshbtn').classList.remove('back');
        }


       
        let idx;
        if(amount > groups.length) amount = groups.length;

        this.querySelectorAll(':scope > *.active').forEach(function(item){
            item.classList.remove('active');            
        });
        if(groups.length < amount) amount = groups.length;
        for(let i = 0; i < amount; i++){
            idx = parseInt(Math.floor(Math.random() * groups.length));
            groups[idx].classList.remove('unused');
            groups[idx].classList.add('active');        
            groups.splice(idx,1);
        }

        if(groups.length == 0){
            this.querySelector(':scope > .edml-poolview-refreshbtn').classList.add('back');
        }
          
        //renew lists
        this.querySelectorAll(':scope > *.active edml-list').forEach(function(item){
            let list = item;
            window.setTimeout(function(){list.setIndent();},100);
        });



    }

    connectedCallback(){
        if(this.connected == null){
            this.connected = true;
            let shuffle = edMLPlayer_Config.get('poolview.shuffle');
            if(this.getAttribute('shuffle') == "true") shuffle = true; else if(this.getAttribute('shuffle') == "false") shuffle = false;
        
            this.querySelectorAll(':scope > *:not(.edml-poolview-refreshbtn)').forEach(function(item){            
                if(!(item instanceof edML_Title)) item.classList.add('unused');
            });


            if(edMLPlayer_Config.get('player.poolviewenabled')){
                let amount = edMLPlayer_Config.get('poolview.amount');
                if(this.getAttribute('amount') != null && !isNaN(parseInt(this.getAttribute('amount')))) amount = parseInt(this.getAttribute('amount'));
                let groups = [...this.querySelectorAll(':scope > .unused')];
                
                
                let idx;
                let glength = groups.length;
                if(amount > groups.length) amount = groups.length;
                if(groups.length > 0){
                    let name = new URLSearchParams(window.location.search).get('name');
                    //specific named exercise
                    if(this.querySelector(':scope > *[name="'+name+'"]') != null){
                        this.querySelector(':scope > *[name="'+name+'"]').classList.add('active');
                        this.querySelector(':scope > *[name="'+name+'"]').classList.remove('unused');
                        let index = groups.indexOf(this.querySelector(':scope > *[name="'+name+'"]'));
                        if(index > -1) groups.splice(index,1);
                        if(shuffle) this.append(this.querySelector(':scope > *[name="'+name+'"]'));
                        amount--;
                    }

                    for(let i = 0; i < amount; i++){                       
                        idx = parseInt(Math.floor(Math.random() * groups.length));
                        groups[idx].classList.add('active');
                        groups[idx].classList.remove('unused');
                        if(shuffle) this.append(groups[idx]);
                        groups.splice(idx,1);
                    }
                
                }
                if((this.getAttribute('allowrefresh') == "true" || this.getAttribute('allowrefresh') == "1" || (edMLPlayer_Config.get('poolview.refreshbutton') == true && this.getAttribute('allowrefresh') == null)) && glength >= 2*amount){
                    let btn = document.createElement('div');
                    btn.classList.add('edml-poolview-refreshbtn');
                    this.prepend(btn);
                    btn.addEventListener('click',this.onRefresh.bind(this));
                }
            } else {            
                this.querySelectorAll(':scope > *:not(.edml-poolview-refreshbtn)').forEach(function(item){
                    item.classList.add('active');
                    item.classList.remove('unused');
                })
            }
            //move title to top
            if(this.querySelector(':scope > edml-title') != null) {
                this.prepend(this.querySelector(':scope > edml-title'));
                this.querySelector(':scope > edml-title').style.setProperty('display','block','important');
            }
        }
    }
}  
class edML_Products extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["molecule"]);
        this.setAttributeWhitelist(["fixed"]);
        this.setMixedContent(false); 
        this.setRequiredTag(["molecule"]); 
        this.check();
    }
}

class edML_Proofbox extends edML_Box{

    constructor(container){
        super();
        this.setTagWhitelist(edML_Groups.getBlockGroup().concat(["title","parameter","parametergroup","enumerator","descriptor","subtitle"]));
        this.setAttributeWhitelist(["name","label","subtype","tags","numbered"]);
        this.setOnlyOnceTag(["title","descriptor","enumerator","subtitle"]);
        this.setMixedContent(false);
        this.setRemoveContentByClass(["edml-autotitle","edml-autodescriptor"]);
        this.check();
        
        if(this.querySelector(':scope > edml-title') == null){  // for compatiblity
            if(this.querySelector(':scope > edml-descriptor') == null){
                var descr = document.edmllocale.get('proofbox.descriptor',this.closest('edml-variant').getAttribute('lang'));
                if(this.getAttribute('subtype') != null){  
                    if(document.edmllocale.get('proofbox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang')) != null){
                        descr = document.edmllocale.get('proofbox.subtypes.' + this.getAttribute('subtype'),this.closest('edml-variant').getAttribute('lang'));
                    } 
                }

                let descriptor = new edML_Descriptor(descr);
                descriptor.classList.add('edml-autodescriptor');
                this.prepend(descriptor);
            }

            if(this.querySelector(':scope > edml-enumerator') == null && (this.getAttribute('numbered') == "true" || (this.getAttribute('numbered') == null && edMLPlayer_Config.get('box.proofbox.numbered') == true))){ 
                let enumerator = new edML_Enumerator();
                enumerator.classList.add('edml-autoenumerator');
                enumerator.classList.add('edml-proofbox-numbering');
                this.prepend(enumerator);
            }


            this.orderTitle();
            
        }
    }
}
class edML_Quantity extends edML_Inputvalue{

    constructor(){
        super();
        this.setTagWhitelist(["number","unit","exponential","expression"]);        
        this.setAttributeWhitelist(["credits","model"]);
        this.setRequiredTag([["number","exponential","expression"],"unit"])
        this.setMixedContent(false);      
        this.check();

        

    }

    connectedCallback(){
        if(this.connected == null){
            this.connected = true;

            if(this.querySelector(':scope > edml-number') != null){
                this.querySelector(':scope > edml-number').addEventListener('keyup',this.onKeyUpNumber.bind(this));
            }

            if(this.querySelector(':scope > edml-expression') != null){
                this.querySelector(':scope > edml-expression').addEventListener('keyup',function(){
                    this.querySelector(':scope > edml-unit > input').focus();
                    this.querySelector(':scope > edml-unit > input').click();
                }.bind(this));
            }

            if(this.querySelector(':scope > edml-unit') != null){
                this.querySelector(':scope > edml-unit').addEventListener('valuechange',this.onUnitValueChange.bind(this));
                this.querySelector(':scope > edml-unit').addEventListener('keyup',this.checkEnter.bind(this));
            }
        }


        
    }

    onUnitValueChange(){
        if(this.querySelector(':scope > edml-number') != null) this.querySelector(':scope > edml-number').removeAttribute('solved');
        if(this.querySelector(':scope > edml-expression') != null) this.querySelector(':scope > edml-expression').removeAttribute('solved');
        if(this.querySelector(':scope > edml-exponential') != null) this.querySelector(':scope > edml-exponential').removeAttribute('solved');
        if(this.querySelector(':scope > edml-unit') != null) this.querySelector(':scope > edml-unit').removeAttribute('solved');
        this.parentNode.removeAttribute('solved');
    }

    onKeyUpNumber(evt){
        if(this.querySelector(':scope > edml-number') != null) this.querySelector(':scope > edml-number').removeAttribute('solved');
        if(this.querySelector(':scope > edml-unit') != null) this.querySelector(':scope > edml-unit').removeAttribute('solved');
        if(this.querySelector(':scope > edml-expression') != null) this.querySelector(':scope > edml-expression').removeAttribute('solved');
        if(this.querySelector(':scope > edml-exponential') != null) this.querySelector(':scope > edml-exponential').removeAttribute('solved');
        this.parentNode.removeAttribute('solved');
        if(evt.key.toLowerCase() == "tab"){
            this.querySelector(':scope > edml-unit > input').focus();
            this.querySelector(':scope > edml-unit > input').click();
        } else if(evt.key.toLowerCase() == "enter"){
            this.querySelector(':scope > edml-unit > input').focus();
            this.querySelector(':scope > edml-unit > input').click();
            
        }
    }

    checkEnter(evt){
        if(evt.key.toLowerCase() == "enter"){
            
            if(this.checkShowCheckButton()){
                let input = this.closest('edml-input');
                input.removeAttribute('solved');
                input.classList.remove('missed');
                this.classList.remove('unsolved'); 
                edMLPlayer_Functions.checkContainer(input); 
                if(document.querySelector('.edml-expression-output') != null) document.querySelector('.edml-expression-output').classList.remove('active');
                if(document.querySelector('.edml-unit-output') != null) document.querySelector('.edml-unit-output').classList.remove('active');

                if(window.edmlcheckbutton.container.length == 1 && window.edmlcheckbutton.container[0] == input) {
                            
                    edmlcheckbutton.classList.remove('show');
                    window.edmlcheckbutton.container = [];
                    edMLPlayer_Functions.setTimer(null,null);
                }
            }

        }
    }

    verify(value,model){
        //value should be format: "decimalvalue unitvalue"
        let numbervalue;
        let unitvalue;
        let numberobj = null;
        if(this.querySelector(':scope > edml-number') != null) numberobj = this.querySelector(':scope > edml-number');
        if(numberobj == null && this.querySelector(':scope > edml-exponential') != null) numberobj = this.querySelector(':scope > edml-exponential');     
        if(numberobj == null && this.querySelector(':scope > edml-expression') != null) numberobj = this.querySelector(':scope > edml-expression');     
        
        if(value != null && value.split(" ").length == 2){
            unitvalue = value.split(" ")[1];
            numbervalue = value.split(" ")[0];
        } else {
            unitvalue = this.querySelector('edml-unit').getValue();
            numbervalue = numberobj.getDecimalValue();            
        }
                        
        if(model == null) model = this.getSubmodel();    

        let solvedobj = new Object();
        solvedobj.solved = false;
        solvedobj.solution = null;
        if(this.getAttribute('credits') != null && !isNaN(parseInt(this.getAttribute('credits')))) {
            solvedobj.credits = parseInt(this.getAttribute('credits'));
         } else {
            solvedobj.credits = model.credits;
        }

        if(this.querySelector('edml-unit').verify(unitvalue,model.unit).solved == true){
            this.querySelector('edml-unit').setAttribute('solved','true');            

            
            
            let result = UnitCalculator.getUnitArray(unitvalue);           
            let numberSolution = this.querySelector('edml-unit').getSolutionFactor();             
            let number = parseFloat(numbervalue) * result.factor/numberSolution;  

            
            //check value         
            let slobj = numberobj.verify(number,null);
            var valuecheck = slobj.valuecheck;
            //check attributes of number 
            var attrcheck = slobj.attributecheck;


            if(valuecheck && attrcheck){
                numberobj.setAttribute('solved','true');
                solvedobj.solved = true;
            } else {
                numberobj.setAttribute('solved','false');
                solvedobj.solved = false;
            }

        } else {
            this.querySelectorAll(':scope  edml-number').forEach(function(item){
                item.setAttribute('solved','false');  
            });
            solvedobj.solved = false;
        }

        return solvedobj;

        
    }

    checkShowCheckButton(){
        let okay = this.querySelector(':scope > edml-number, :scope > edml-exponential, :scope > edml-expression').checkShowCheckButton() && this.querySelector('edml-unit').checkShowCheckButton(); ;
        
        return okay;
    }

    evaluateCredits(result){
        let model = this.closest("edml-input").getModel().getSubmodel("quantity");           
        if(result == true){           
            edMLPlayer_Functions.changeCredits(-1 * this.lastCredits, false);
            edMLPlayer_Functions.changeCredits(parseInt(model.credits), true);                            
            this.lastCredits = model.credits;
        } else {
            edMLPlayer_Functions.changeCredits(-1 * this.lastCredits, false);
            if(this.lastCredits != 0 || parseInt(model.credits) != 0) {
                edMLPlayer_Functions.changeCredits(-1 * parseInt(model.penalty), true);
            } 
            this.lastCredits = -1 * model.penalty;
        }
    }

    /*getSignificant(number,factor){
        let split = number.toString().split('.');   
        let minsig;
        let maxsig;
        let sigfac = Math.log10(factor);

        //remove trailing zeros
            //remove integer digit zeros
        let found = split[0].length;
        for(let i = 0; i < split[0].length; i++){
            if(split[0].charAt(i) != "0" && i < found) found = i;
        }
        split[0] = split[0].substring(found);
        if(split[0].length == 0){ //remove fractional digits leading zeros if no significant int digits
            found = split[1].length;
            for(let i = 0; i < split[1].length; i++){
                if(split[1].charAt(i) != "0" && i < found) found = i;
            }
            split[1] = split[1].substring(found);
        }

        if(split.length > 1){
            minsig =  split[0].length + split[1].length;
            maxsig = minsig;
        } else {
            maxsig = split[0].length;
            //remove trailing zeros for minsig
            found = split[0].length;
            for(let i = split[0].length-1; i >= 0; i--){
                if(split[0].charAt(i) == "0" && i < found) found = i;
            }
            split[0] = split[0].substring(0,found);
            minsig = split[0].length;
        }

        let result = new Array();
        result.push(minsig);
        result.push(maxsig);
        return result;        
        
    }*/

    setValue(val){
        var split = val.split(" ");
        this.querySelector(':scope > edml-number,:scope > edml-exponential').setValue(split[0]);
        if(split.length > 1){
            this.querySelector(':scope > edml-unit').setValue(split[1]);
        }
    }

    getValue(){  // value: number + units
        return this.getNumberValue() + " " + this.getUnitValue();

    }

    getString(){
        return this.getNumberString()+ " " + this.getUnitValue();
    }

    getNumberString(){
        return this.querySelector(':scope > edml-number, :scope > edml-exponential,:scope > edml-expression').getString();  
    }


    getNumberValue(){
        return this.querySelector(':scope > edml-number, :scope > edml-exponential, :scope > edml-expression').getValue();       
    }

    getDecimalValue(){
        if(this.querySelector(':scope > edml-expression') == null){
            return this.getNumberDecimalValue() + " " + this.getUnitValue();      
        } else {
            return this.querySelector(':scope > edml-expression').getValue() + " " + this.getUnitValue();      
        }
    }

    getNumberDecimalValue(){
        return this.querySelector(':scope > edml-number, :scope > edml-exponential').getDecimalValue();         
    }

    getUnitValue(){
        return this.querySelector(':scope > edml-unit').getValue();
    }


    


    save2SCORM(result){
        if(edMLPlayer_Config.get("player.scorm.enabled") == true && (edMLPlayer_Config.get('player.scorm.testonly') != true || document.querySelector('edml-test.active') != null)){  
            let navitem = this.closest('edml-variant').querySelector('edml-navitem.selected');
            if(navitem != null) navitem = navitem.getAttribute('name');
            let exercisename = edML_SCORM.saveInputObjective(result,this.closest('edml-input'),this.getString());
            edML_SCORM.saveInteraction(this.closest('edml-page').getAttribute("name"),"other","input: quantity",navitem,exercisename,null);
        }
    }


    initFromSCORM(entrynb){   
        if(edMLPlayer_Config.get("player.scorm.enabled") == true && edMLPlayer_Config.get('player.scorm.testonly') != true) {
             
            let value = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.description');           
            let valuenumber = value.split(" ")[0];
            let valueunit = value.split(" ")[1];

            this.querySelector(':scope > edml-number,:scope > edml-exponential').setValue(valuenumber);
            this.querySelector(':scope > edml-unit').setValue(valueunit);

            
            if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "failed"){
                this.closest('edml-input').setAttribute('solved','false');
            } else if(edML_SCORM.getValue('cmi.objectives.'+entrynb+'.success_status') == "passed"){
                this.closest('edml-input').setAttribute('solved','true');
            }

            edMLPlayer_Functions.changeCredits(-this.lastCredits,false);
            this.lastCredits = edML_SCORM.getValue('cmi.objectives.'+entrynb+'.score.raw');
        }
    }

    clear(){
        this.removeAttribute('solved');       
        this.querySelectorAll(':scope > edml-number,:scope > edml-exponential, :scope > edml-expression,:scope > edml-unit').forEach(function(item){
            item.clear();
        });
    }

    showSolutionhint(){        
        let hint = document.querySelector('edml-variant.active edml-solutionhint[to="'+this.closest('edml-input').getAttribute('name')+'"]');
        console.log(hint);
        if(this.querySelector('.edml-solutionhint-btn') == null){
            let btn = document.createElement('span');
            btn.classList.add('edml-solutionhint-btn');
            this.append(btn);
            
            btn.addEventListener('click',function(){
                edML_DialogSolutionhint.show(hint);                
            });
        }   
        
    }
}
class edML_Quote extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(edML_Groups.getInlineInputGroup());
        this.setAttributeWhitelist(["name","tags"]);
        this.setMixedContent(true);
        this.check();
    }

    connectedCallback(){
        this.setAttribute("lang",this.closest('edml-variant').getAttribute('lang'));
    }


}
class edML_Range extends edML_Tag{

    constructor(){
        super();
        this.setTagWhitelist(["value"]);
        this.setAttributeWhitelist(["weight","step","closure"]);
        this.setMixedContent(false);
        this.setRequiredTag(["value"]);
        this.check();
    }

}
class edML_Reaction extends edML_Inputvalue{

    constructor(){
        super();
        this.setTagWhitelist(["educts","products"]);
        this.setAttributeWhitelist(["credits","model","type","reduced"]);
        this.setMixedContent(false);
        this.setRequiredTag(["educts"],["products"]); 
        this.setOnlyOnceTag(["educts","products"]);
        this.check();

        this.fixededucts = this.getSubmodel().fixededucts;
        this.fixedproducts = this.getSubmodel().fixedproducts;

        if(this.querySelector(':scope > edml-educts').getAttribute('fixed') == 'true' || this.querySelector(':scope > edml-educts').getAttribute('fixed') == '1') {
            this.fixededucts = true;
        } else if(this.querySelector(':scope > edml-educts').getAttribute('fixed') == 'false' || this.querySelector(':scope > edml-educts').getAttribute('fixed') == '0') {
            this.fixededucts = false;
        }

        if(this.querySelector(':scope > edml-products').getAttribute('fixed') == 'true' || this.querySelector(':scope > edml-products').getAttribute('fixed') == '1') {
            this.fixedproducts = true;
        } else if(this.querySelector(':scope > edml-products').getAttribute('fixed') == 'false' || this.querySelector(':scope > edml-products').getAttribute('fixed') == '0') {
            this.fixedproducts = false;
        }
            
        //remeber educts & products and remove them
        
        this.educts = [...this.querySelectorAll(':scope > edml-educts > edml-molecule')];
        this.products = [...this.querySelectorAll(':scope > edml-products > edml-molecule')];
        this.querySelector(':scope > edml-educts').remove();
        this.querySelector(':scope > edml-products').remove();

    }


    connectedCallback(){
        if(this.connected == null){
            this.connected = true;
            let reactiontype = this.getSubmodel().type;
            let coefficient;
            let fixedmolecule;
            let display;
                        

            if(this.getAttribute('type') != null) reactiontype = this.getAttribute('type');


            //educts
            let eductsdiv = document.createElement('div');
            eductsdiv.classList.add('edml-reaction-educts');
            this.append(eductsdiv);
            for(let i = 0; i < this.educts.length; i++){  
                coefficient = this.getSubmodel().educts.coefficient;
                if(this.educts[i].getAttribute('coefficient')) coefficient = this.educts[i].getAttribute('coefficient');

                display = false;
                fixedmolecule = this.getSubmodel().educts.fixed; // molecule: input field or text
                if(this.educts[i].getAttribute('fixed') == 'true' || this.educts[i].getAttribute('fixed') == '1') fixedmolecule = true;

                let span = document.createElement('span');
                span.classList.add('edml-reaction-term');
                span.classList.add('edml-reaction-educt');
                
                if(this.educts[i].getAttribute('coefficient') != null) coefficient = this.educts[i].getAttribute('coefficient');
                if(this.educts[i].getAttribute('fixed') == 'true' || this.educts[i].getAttribute('fixed') == '1') fixedmolecule = true;

                if(coefficient != "blank"){
                    span.append(new edML_M(' ' + coefficient + ' '));
                    display = true;
                } else {
                    let number = new edML_Number();
                    number.setAttribute('maxfracdigitshints','true');
                    number.setAttribute('maxfracdigits','0');
                    let coeff = new edML_Input(number);
                    span.append(coeff);            
                }
                
        
                if(fixedmolecule){
                    span.append(new edML_M('\\ce{'+this.educts[i].innerText+'}'));
                    let molecular = new edML_Molecular(this.educts[i].innerText,this.educts[i].innerText);                    
                    let input = new edML_Input(molecular);
                    input.classList.add('hidden');                    
                    span.append(input);                    
                    display = true;
                } else {                                
                    //span.insertAdjacentHTML('beforeend','<edml-input><edml-molecular>test</edml-molecular><edml-input>');
                    let molecular = new edML_Molecular();
                    let input = new edML_Input(molecular);
                
                    span.append(input);

                }

                if(display || this.fixededucts){
                    span.classList.add('fixed');
                    eductsdiv.append(span);
                    if(i < this.educts.length -1) {
                        let plusspan = document.createElement('span');
                        plusspan.classList.add('edml-reaction-plussign');
                        plusspan.innerText = " + ";
                        span.append(plusspan);
                    }

                } else {
                    span.remove();
                }

                
            }

            if(!this.fixededucts){
                let btnaddeduct = document.createElement('span');
                btnaddeduct.classList.add('edml-reaction-addeduct');
                btnaddeduct.classList.add('edml-reaction-button');
                eductsdiv.append(btnaddeduct);

                btnaddeduct.addEventListener('click',function(){
                    let span = document.createElement('span');
                    span.classList.add('edml-reaction-term');
                    span.classList.add('edml-reaction-educt');

                    


                    if(eductsdiv.querySelector('.edml-reaction-term') != null){
                        let plusspan = document.createElement('span');
                        plusspan.classList.add('edml-reaction-plussign');
                        plusspan.innerText = " + ";
                        span.append(plusspan);
                    }

                    let number = new edML_Number();
                    number.setAttribute('maxfracdigitshints','true');
                    number.setAttribute('maxfracdigits','0');
                    let coeff = new edML_Input(number);
                    span.append(coeff);
                    let molecular = new edML_Molecular();
                    let input = new edML_Input(molecular);                
                    span.append(input);    
                    
                    //delete button
                    let delspan = document.createElement('span');
                    delspan.classList.add('edml-reaction-btndelteterm');
                    delspan.addEventListener('click',function(){
                        this.parentNode.remove();
                    });
                    span.append(delspan);
                    
                    eductsdiv.append(span);
                    eductsdiv.append(btnaddeduct);
                }.bind(this));

            }

            //remove last + sign and add button instead
            let arrowspan = document.createElement('span');
            arrowspan.classList.add('edml-reaction-arrow');

            if(reactiontype == 'forward'){    
                arrowspan.append(new edML_M(' \\longrightarrow '));
            } else if(reactiontype == 'reverse'){
                arrowspan.append(new edML_M(' \\longleftarrow '));
            } else {
                arrowspan.append(new edML_M(' \\rightleftharpoons '));
            
            }
            this.append(arrowspan);

            //edMLPlayer_Util.typesetMath(arrowspan);

            //products
            let productsdiv = document.createElement('div');
            productsdiv.classList.add('edml-reaction-products');
            this.append(productsdiv);
            for(let i = 0; i < this.products.length; i++){  
                coefficient = this.getSubmodel().products.coefficient;
                if(this.products[i].getAttribute('coefficient')) coefficient = this.products[i].getAttribute('coefficient');
                display = false;

                fixedmolecule = this.getSubmodel().products.fixed; // molecule: input field or text
                if(this.products[i].getAttribute('fixed') == 'true' || this.products[i].getAttribute('fixed') == '1') fixedmolecule = true;

                let span = document.createElement('span');
                span.classList.add('edml-reaction-term');
                span.classList.add('edml-reaction-product');
                
                if(this.products[i].getAttribute('coefficient') != null) coefficient = this.products[i].getAttribute('coefficient');
                if(this.products[i].getAttribute('fixed') == 'true' || this.products[i].getAttribute('fixed') == '1') fixedmolecule = true;

                if(coefficient != "blank"){
                    span.append(new edML_M(' ' + coefficient + ' '));
                    display = true;
                } else {
                    let number = new edML_Number();
                    number.setAttribute('maxfracdigitshints','true');
                    number.setAttribute('maxfracdigits','0');
                    let coeff = new edML_Input(number);
                    span.append(coeff);
                }
                
        
                if(fixedmolecule){
                    span.append(new edML_M('\\ce{'+this.products[i].innerText+'}'));
                    let molecular = new edML_Molecular(this.products[i].innerText,this.products[i].innerText);                    
                    let input = new edML_Input(molecular);                    
                    input.classList.add('hidden');                                        
                    span.append(input);
                    display = true;
                } else {                              
                    //span.insertAdjacentHTML('beforeend','<edml-input><edml-molecular>test</edml-molecular><edml-input>');
                    let molecular = new edML_Molecular();
                    let input = new edML_Input(molecular);
                    
                    span.append(input);                                
                    
                    
                }

                if(display || this.fixedproducts){
                    productsdiv.append(span);
                    if(i < this.products.length -1) {
                        let plusspan = document.createElement('span');
                        plusspan.classList.add('edml-reaction-plussign');
                        plusspan.innerText = " + ";
                        span.append(plusspan);
                    }
                } else {
                    span.remove();
                }

                

                
            }

            if(!this.fixedproducts){
                let btnaddproduct = document.createElement('span');
                btnaddproduct.classList.add('edml-reaction-addproduct');
                btnaddproduct.classList.add('edml-reaction-button');
                productsdiv.append(btnaddproduct);

                btnaddproduct.addEventListener('click',function(){
                    let span = document.createElement('span');
                    span.classList.add('edml-reaction-term');
                    span.classList.add('edml-reaction-product');

                    if(productsdiv.querySelector('.edml-reaction-term') != null){
                        let plusspan = document.createElement('span');
                        plusspan.classList.add('edml-reaction-plussign');
                        plusspan.innerText = " + ";
                        span.append(plusspan);
                    }

                    let number = new edML_Number();
                    number.setAttribute('maxfracdigitshints','true');
                    number.setAttribute('maxfracdigits','0');
                    let coeff = new edML_Input(number);
                    span.append(coeff);
                    let molecular = new edML_Molecular();
                    let input = new edML_Input(molecular);                
                    span.append(input);      

                    //delete button
                    let delspan = document.createElement('span');
                    delspan.classList.add('edml-reaction-btndelteterm');
                    delspan.addEventListener('click',function(){
                        this.parentNode.remove();
                    });
                    span.append(delspan);

                    productsdiv.append(span);
                    productsdiv.append(btnaddproduct);
                }.bind(this));

            }
        }
    }

    verify(){
        let solvedobj = new Object();
        solvedobj.solved = true;
        solvedobj.solution = null;
        solvedobj.credits = 0;
        solvedobj.penalty = 0;

        let reduced = this.getSubmodel().reduced;
        if(this.getAttribute('reduced') == 'true' || this.getAttribute('reduced') == '1') reduced = this.getAttribute('reduced');
        

        this.querySelectorAll('edml-input').forEach(function(item){
            item.setAttribute('solved','false');
        });
       

        for(let i = 0; i < this.educts.length; i++){
            this.educts[i].used = false;
        }

        for(let i = 0; i < this.products.length; i++){
            this.products[i].used = false;
        }
    
        //Check educts
        this.querySelectorAll(':scope  .edml-reaction-educt edml-molecular').forEach(function(item){
            let isCorrect = false;    
            let i = 0;


            item.parentNode.setAttribute('solved','false');  
                   
            while(i < this.educts.length && isCorrect == false){
                if(this.educts[i].used == false && item.isSolution(item.getText(),this.educts[i].getText()) == true){
                    isCorrect = true;
                    this.educts[i].used = true;
                    this.educts[i].usedby = item.parentNode.parentNode;
                    item.parentNode.setAttribute('solved','true');
                } else {
                    i++;
                }
                
            } 
            if(isCorrect == false){
                item.parentNode.setAttribute('solved','false');
            }           
        }.bind(this));
        
       /* let eductscorrect = true;
        for(let i = 0; i < this.educts.length; i++){
            if(this.educts[i].used == false) eductscorrect = false;
        }
        if(eductscorrect == false || this.querySelector(':scope > .edml-reaction-educts .edmlinput-molecular[solved="false"]') != null){
            //this.querySelector(':scope > .edml-reaction-educts').setAttribute('solved','false');
            solvedobj.solved = false;
        }*/



        //Check products
        this.querySelectorAll(':scope  .edml-reaction-product edml-molecular').forEach(function(item){
            let isCorrect = false;    
            let i = 0;
            item.parentNode.setAttribute('solved','false');     
            
            while(i < this.products.length && isCorrect == false){
                                
                if(this.products[i].used == false && item.isSolution(item.getText(),this.products[i].getText()) == true){
                    isCorrect = true;
                    this.products[i].used = true;
                    this.products[i].usedby = item.parentNode.parentNode;
                    item.parentNode.setAttribute('solved','true');
                } else {
                    i++;
                }
                
            } 
            if(isCorrect == false){
                item.parentNode.setAttribute('solved','false');
            }         
        }.bind(this));

       /* let productscorrect = true;
        for(let i = 0; i < this.products.length; i++){
            if(this.products[i].used == false) productscorrect = false;
        }
        if(productscorrect == false || this.querySelector(':scope > .edml-reaction-products .edmlinput-molecular[solved="false"]') != null){
            this.querySelector(':scope > .edml-reaction-products').setAttribute('solved','false');
            solvedobj.solved = false;
        }*/
        
        //if equilibrium: educts and products reversed?


        // check stoichiometric coefficients
        let variables = ['a','b','c','d','f','g','h','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z'];
        let helper = new edML_Molecular();
        let atoms = new Array();
        for(let i = 0; i < this.educts.length; i++){
            atoms = atoms.concat(Object.keys(helper.analyze(this.educts[i].innerText)));
        }
        atoms = edMLPlayer_Util.uniqueArray(atoms);


           //generate solution
        nerdamer.flush();
        nerdamer.clearVars();
        nerdamer.setConstant('E', 'delete');

        let equations = new Array();
        let aobj;
        let sum;
        let equation; 
        for(let i = 0; i < atoms.length; i++){
            sum = 0; // to avoid zero equations
            equation = "";
            for(let j = 0; j < this.educts.length; j++){
                aobj = helper.analyze(this.educts[j].innerText);                
                if(aobj[atoms[i]] != null && atoms[i] != "e"){
                    equation += '(' + aobj[atoms[i]] + ')*' + variables[j] + "+";
                    sum += Math.abs(aobj[atoms[i]]);
                } 
            }
            equation = equation.substring(0,equation.length-1) + "=";
            
            
            for(let j = 0; j < this.products.length; j++){
                aobj = helper.analyze(this.products[j].innerText);
                if(aobj[atoms[i]] != null && atoms[i] != "e"){
                    equation += '(' + aobj[atoms[i]] + ')*' + variables[j+this.educts.length]+"+";   
                    sum += Math.abs(aobj[atoms[i]]);                 
                } 
            }
            if(sum > 0){
                equation = equation.substring(0,equation.length-1);  
                equations.push(equation);
            }
                
            
         
        }

        var equationsArr = new Array();
        var correctSize = this.educts.length+this.products.length-1; //nerdamer can only solve equations matrix with equal size      
        if(correctSize < equations.length){
            // to much euqations -> generate array of equation arrays for nerdamer with correct size
           
            this.eqs = new Array();
            equationsArr = new Array(); 
            for(var j = 0; j < equations.length; j++){  
                this.createEqsArray(equations,correctSize,j,1,"",equationsArr);
            }
            
            
        } else {
            equations.push("a=1");      
            equationsArr.push(equations);
        }
  

        
        var noerror = false;
        let solution;
        var n = 0;
        while(noerror == false && n < equationsArr.length){
            try{
                solution = nerdamer.solveEquations(equationsArr[n]);                
                noerror = true;
                for(var i = 0; i < solution.length; i++){                    
                    if(parseFloat(solution[i][1]) > 1000) noerror = false;
                }

            } catch(err){     
                         
            }
            n++;
        }

        
        let min = null;
            // make solution smallest integer: divide smallest one, eliminate denominators
                    //find minimum and divide
        for(let i = 0; i < solution.length;i++){
            if((min != null && solution[i][1] < min && solution[i][1] > 0.001) || (min == null && solution[i][1] > 0.001)) min = solution[i][1]; 
        }
        for(let i = 0; i < solution.length;i++){
            solution[i][1] = solution[i][1] / min; 
            if(Math.abs(solution[i][1] - Math.round(solution[i][1])) < 0.001) solution[i][1] = Math.round(solution[i][1]);
        }
        
                    //eliminate denominators
        var denoms = "";
        for(let i = 0; i < solution.length; i++){
            denoms += "," + nerdamer(solution[i][1]).denominator().toString();
        }            
        denoms = denoms.substring(1);
        var factor = parseInt(nerdamer('lcm('+denoms+')').text());
        for(let i = 0; i < solution.length; i++){
            solution[i][1] = factor * solution[i][1];
        }


            //compare solution to input: generate stoichfactors
        let stoichfactors = new Object();
        let number;

        for(let i = 0; i < this.educts.length; i++){
            if(this.educts[i].usedby != null && this.educts[i].getAttribute('coefficient') == nu