//load 3Dmol
var script = document.createElement('script');
script.setAttribute('src',edMLPlayer_Config.get('plugins.threedmol.path') + "/3Dmol-min.js");            
script.setAttribute('type','text/javascript');
script.async = true;
document.head.append(script);


class edMLplugin_3Dmol extends HTMLElement{

	constructor(json){		
		super();
		json = JSON.parse(json);
		//let dir = window.location.pathname.substring(0, window.location.pathname.lastIndexOf('/'));
		
		let dir = "";
		if(!edMLPlayer_Config.get("player.isZip")){

		  dir = edMLPlayer_Config.get("player.file").substr(0,edMLPlayer_Config.get("player.file").lastIndexOf('/')+1);
		}

		let uri;
		if(json.data != null && json.data.indexOf('http') == -1){
			uri = dir + "/" + json.data.replace('./','');
		} else {
			uri = json.data;
		}
		
		if(uri != null){
			this.classList.add('edmlplayer-3dmoldiv');
			this.style.display = "block";
			this.style.position = "relative";
			if(json.width != null) this.style.width = json.width;
			if(json.height != null) this.style.height = json.height;		

			let viewer = $3Dmol.createViewer(this);
			if(edMLPlayer_Config.get('player.isZip') == true && json.data.indexOf('http') == -1){
				 this.loadFromZip(viewer,json,json.data);
				
			} else {
				let xml = new XMLHttpRequest();
				xml.open('GET',uri,true );
				xml.onload  = function(){
					if(this.status ==200){
						viewer.addModel( this.responseText, json.datatype ); 
						//viewer.addModel( blob, json.datatype ); 
						
						//viewer.addSphere({ center: {x:0, y:0, z:0}, radius: 10.0, color: 'green' });
						if(json.style != null && json.style.length == 1) {
							viewer.setStyle({}, json.style); 
						} else {
							//viewer.setStyle({},{sphere: {"radius": 0.5}}); 
							//viewer.setStyle({"atom":"Cl"}, {sphere: {"radius": 0.5,"color":"blue"}}); 				
							for(var i = 0; i < json.style.length; i++){								
								viewer.setStyle({"atom":json.style[i].atom}, json.style[i]); 
							}
						}
						viewer.zoomTo();                                      
						viewer.render();                                   
						
						if(json.zoom != null){
							viewer.zoom(json.zoom, 1000); 
						} else {
							viewer.zoom(1.2, 1000); 
						}           
					} else {
						console.error( "Failed to load " + uri + ": " + this.status );
					}	
					
				}
				xml.send(); 
			} 
			
		}
	}

	async loadFromZip(viewer,json,path){
		path = path.replace('./','');
		if(edMLPlayer_Config.get("player.file").files[path] != null) {
			var blob = await edMLPlayer_Config.get("player.file").files[path].async("string");
			viewer.addModel( blob, json.datatype );
			//viewer.addSphere({ center: {x:0, y:0, z:0}, radius: 10.0, color: 'green' });
			if(json.style != null && json.style.length == 1) {
				viewer.setStyle({}, json.style); 
			} else {
				//viewer.setStyle({},{sphere: {"radius": 0.5}}); 
				//viewer.setStyle({"atom":"Cl"}, {sphere: {"radius": 0.5,"color":"blue"}}); 				
				for(var i = 0; i < json.style.length; i++){								
					viewer.setStyle({"atom":json.style[i].atom}, json.style[i]); 
				}
			}
			viewer.zoomTo();                                      
			viewer.render();  
			if(json.zoom != null){
				viewer.zoom(json.zoom, 1000); 
			} else {
				viewer.zoom(1.2, 1000); 
			}                                      
		
			
		}
	}
}



customElements.define("edmlplugin-3dmol", edMLplugin_3Dmol);


document.addEventListener('edmlevent-coursestarted',function(evt){
	evt.edmlplayernode.querySelectorAll('edml-objectblock[plugin="3dmol"]').forEach(function(objblock){	
		objblock.style.display = "block";
		var json = objblock.textContent;
		objblock.json = json;
		objblock.innerHTML = "";	
		objblock.append(new edMLplugin_3Dmol(json));
		
		
	});
});
        
    