

class edMLplugin_PSE extends HTMLElement{

    static alkaline = "Alkalimetalle";
    static alkalineearth = "Erdalkalimetalle";
    static halogen = "Halogene";
    static noble = "Edelgase";
    static transition = "Übergangsmetalle";
    static laac = "Lanthanoide & Actinoide";
    static source = "Quelle: IUPAC, 2023";
    static dlgName = "Name";
    static dlgAtomicMass = "Atommasse";
    static dlgSymbol = "Atomsymbol";
    static dlgAtomicNumber = "Ordnungszahl";
    static nomassdata = "Massenzahl des Nuklids mit der längsten bestätigten Halbwertszeit";
    static dlgAggregate = "Aggregatzustand";
    static dlgAggregateG = "gasförmig";
    static dlgAggregateL = "flüssig";
    static dlgAggregateS = "fest";
    static activelang = edMLPlayer_Config.get("course.defaultlang");

    static btnNames_en = ["alkali metal","alkaline earth metal","halogen","noble gas","transition metals","lanthanides & actinides","Source: IUPAC, 2023","name","atomic mass","atomic symbol","atomic number","Mass number of the nuclide with the longest confirmed half-life","state of matter","gaseous","liquid","solid"];
    static btnNames_de = ["Alkalimetalle","Erdalkalimetalle","Halogene","Edelgase","Übergangsmetalle","Lanthanoide & Actinoide","Quelle: IUPAC, 2023","Name","Atommasse","Atomsymbol","Ordnungszahl","Massenzahl des Nuklids mit der längsten bestätigten Halbwertszeit","Aggregatzustand","gasförmig","flüssig","fest"];

    static setNameButtons(){
        var names = edMLplugin_PSE.btnNames_en;
        if(edMLplugin_PSE.sactivelang == "de") {
            names = edMLplugin_PSE.btnNames_de;
        }
        edMLplugin_PSE.alkaline = names[0];
        edMLplugin_PSE.alkalineearth = names[1];
        edMLplugin_PSE.halogen = names[2];
        edMLplugin_PSE.noble = names[3];
        edMLplugin_PSE.transition = names[4];
        edMLplugin_PSE.laac = names[5];
        edMLplugin_PSE.source = names[6];
        edMLplugin_PSE.dlgName = names[7];
        edMLplugin_PSE.dlgAtomicMass = names[8];
        edMLplugin_PSE.dlgSymbol = names[9];
        edMLplugin_PSE.dlgAtomicNumber = names[10];
        edMLplugin_PSE.nomassdata = names[11];
        edMLplugin_PSE.dlgAggregate = names[12];
        edMLplugin_PSE.dlgAggregateG = names[13];
        edMLplugin_PSE.dlgAggregateL = names[14];
        edMLplugin_PSE.dlgAggregateS = names[15];

    }

    static elementH = {
        atomicnumber: "1",
        symbol: "H",
        name_de: 'Wasserstoff',
        name_en: 'Hydrogen',
        mass: '1.0080',                
        group: null,
        position: 33,
        aggregate: 'g'
    }

    static elementHe = {
        atomicnumber: "2",
        symbol: "He",
        name_de: 'Helium',
        name_en: 'Helium',
        mass: '4.0026',                
        group: ['noble'],        
        position: 64,
        aggregate: 'g'
    }

    static elementLi = {
        atomicnumber: "3",
        symbol: "Li",
        name_de: 'Lithium', 
        name_en: 'Lithium',       
        mass: '6.94',        
        group: ['alkaline'],        
        position: 65
    }

    static elementBe = {
        atomicnumber: "4",
        symbol: "Be",
        name_de: 'Beryllium', 
        name_en: 'Beryllium',       
        mass: '9.0122',        
        group: ['alkalineearth'],        
        position: 66
    }

    static elementB = {
        atomicnumber: "5",
        symbol: "B",
        name_de: 'Bor',   
        name_en: 'Boron',     
        mass: '10.81',        
        group: ['triel'],        
        position: 91
    }

    static elementC = {
        atomicnumber: "6",
        symbol: "C",
        name_de: 'Kohlenstoff',  
        name_en: 'Carbon',      
        mass: '12.011',        
        group: ['tetrel'],        
        position: 92
    }

    static elementN = {
        atomicnumber: "7",
        symbol: "N",
        name_de: 'Stickstoff', 
        name_en: 'Nitrogen',       
        mass: '14.007',        
        group: ['pentel'],        
        position: 93
    }

    static elementO = {
        atomicnumber: "8",
        symbol: "O",
        name_de: 'Sauerstoff', 
        name_en: 'Oxygen',       
        mass: '15.999',        
        group: ['chalcogen'],        
        position: 94
    }

    static elementF = {
        atomicnumber: "9",
        symbol: "F",
        name_de: 'Fluor', 
        name_en: 'Fluorine',       
        mass: '18.998',        
        group: ['halogen'],        
        position: 95
    }

    static elementNe = {
        atomicnumber: "10",
        symbol: "Ne",
        name_de: 'Neon', 
        name_en: 'Neon',       
        mass: '20.180',        
        group: ['noble'],        
        position: 96
    }

    static elementNa = {
        atomicnumber: "11",
        symbol: "Na",
        name_de: 'Natrium', 
        name_en: 'Sodium',       
        mass: '22.990',        
        group: ['alkaline'],
        position: 97
    }

    static elementMg = {
        atomicnumber: "12",
        symbol: "Mg",
        name_de: 'Magnesium',
        name_en: 'Magnesium',        
        mass: '24.305',        
        group: ['alkalineearth'],        
        position: 98
    }

    static elementAl = {
        atomicnumber: "13",
        symbol: "Al",
        name_de: 'Aluminium', 
        name_en: 'Aluminium',       
        mass: '26.982',        
        group: ['triel'],        
        position: 123
    }

    static elementSi = {
        atomicnumber: "14",
        symbol: "Si",
        name_de: 'Silizium',
        name_en: 'Silicon',        
        mass: '28.085',        
        group: ['tetrel'],
        position: 124
    }

    static elementP = {
        atomicnumber: "15",
        symbol: "P",
        name_de: 'Phosphor',
        name_en: 'Phosphorus',        
        mass: '30.974',        
        group: ['pentel'],        
        position: 125
    }

    static elementS = {
        atomicnumber: "16",
        symbol: "S",
        name_de: 'Schwefel', 
        name_en: 'Sulfur',       
        mass: '32.06',        
        group: ['chalcogen'],
        position: 126
    }

    static elementCl = {
        atomicnumber: "17",
        symbol: "Cl",
        name_de: 'Chlor',  
        name_en: 'Chlorine',     
        mass: '35.45',        
        group: ['halogen'],        
        position: 127
    }

    static elementAr = {
        atomicnumber: "18",
        symbol: "Ar",
        name_de: 'Argon',   
        name_en: 'Argon',     
        mass: '39.95',        
        group: ['noble'],
        position: 128
    }

    static elementK = {
        atomicnumber: "19",
        symbol: "K",
        name_de: 'Kalium',
        name_en: 'Potassium',        
        mass: '39.098',        
        group: ['alkaline'],
        position: 129
    }

    static elementCa = {
        atomicnumber: "20",
        symbol: "Ca",
        name_de: 'Calcium',  
        name_en: 'Calcium',      
        mass: '40.078',        
        group: ['alkalineearth'],
        position: 130
    }

    static elementSc = {
        atomicnumber: "21",
        symbol: "Sc",
        name_de: 'Scandium',
        name_en: 'Scandium',        
        mass: '44.956',        
        group: ['transition'],
        position: 131
    }

    static elementTi = {
        atomicnumber: "22",
        symbol: "Ti",
        name_de: 'Titan',
        name_en: 'Titanium',        
        mass: '47.867',        
        group: ['transition'],
        position: 146
    }

    static elementV = {
        atomicnumber: "23",
        symbol: "V",
        name_de: 'Vanadium',
        name_en: 'Vanadium',        
        mass: '50.942',        
        group: ['transition'],
        position: 147
    }

    static elementCr = {
        atomicnumber: "24",
        symbol: "Cr",
        name_de: 'Chrom',   
        name_en: 'Chromium',     
        mass: '51.996',        
        group: ['transition'],
        position: 148
    }

    static elementMn = {
        atomicnumber: "25",
        symbol: "Mn",
        name_de: 'Mangan', 
        name_en: 'Manganese',      
        mass: '54.938',        
        group: ['transition'],
        position: 149
    }

    static elementFe = {
        atomicnumber: "26",
        symbol: "Fe",
        name_de: 'Eisen',  
        name_en: 'Iron',      
        mass: '55.845',        
        group: ['transition'],
        position: 150
    }

    static elementCo = {
        atomicnumber: "27",
        symbol: "Co",
        name_de: 'Cobalt', 
        name_en: 'Cobalt',       
        mass: '58.933',        
        group: ['transition'],
        position: 151
    }

    static elementNi = {
        atomicnumber: "28",
        symbol: "Ni",
        name_de: 'Nickel',     
        name_en: 'Nickel',   
        mass: '58.693',        
        group: ['transition'],
        position: 152
    }

    static elementCu = {
        atomicnumber: "29",
        symbol: "Cu",
        name_de: 'Kupfer', 
        name_en: 'Copper',       
        mass: '63.546',        
        group: ['transition'],
        position: 153
    }

    static elementZn = {
        atomicnumber: "30",
        symbol: "Zn",
        name_de: 'Zink',   
        name_en: 'Zinc',     
        mass: '65.38',        
        group: ['transition'],
        position: 154
    }

    static elementGa = {
        atomicnumber: "31",
        symbol: "Ga",
        name_de: 'Gallium', 
        name_en: 'Gallium',       
        mass: '69.723',        
        group: ['triel'],
        position: 155
    }

    static elementGe = {
        atomicnumber: "32",
        symbol: "Ge",
        name_de: 'Germanium',  
        name_en: 'Germanium',      
        mass: '72.630',        
        group: ['tetrel'],
        position: 156
    }

    static elementAs = {
        atomicnumber: "33",
        symbol: "As",
        name_de: 'Arsen',  
        name_en: 'Arsenic',      
        mass: '74.922',        
        group: ['pentel'],
        position: 157
    }

    static elementSe = {
        atomicnumber: "34",
        symbol: "Se",
        name_de: 'Selen',   
        name_en: 'Selenium',     
        mass: '78.971',        
        group: ['chalkogen'],
        position: 158
    }

    static elementBr = {
        atomicnumber: "35",
        symbol: "Br",
        name_de: 'Brom', 
        name_en: 'Bromine',       
        mass: '79.904',        
        group: ['halogen'],        
        position: 159
    }

    static elementKr = {
        atomicnumber: "36",
        symbol: "Kr",
        name_de: 'Krypton',   
        name_en: 'Krypton',     
        mass: '83.798',        
        group: ['noble'],
        position: 160
    }


    static elementRb = {
        atomicnumber: "37",
        symbol: "Rb",
        name_de: 'Rubidium',
        name_en: 'Rubidium',        
        mass: '85.468',        
        group: ['alkaline'],        
        position: 161
    }


    static elementSr = {
        atomicnumber: "38",
        symbol: "Sr",
        name_de: 'Strontium',
        name_en: 'Strontium',     
        mass: '87.62',        
        group: ['alkalineearth'],
        position: 162
    }

    static elementY = {
        atomicnumber: "39",
        symbol: "Y",
        name_de: 'Yttrium',    
        name_en: 'Yttrium',   
        mass: '88.906',        
        group: ['transition'],    
        position: 163
    }

    static elementZr = {
        atomicnumber: "40",
        symbol: "Zr",
        name_de: 'Zirkon',
        name_en: 'Zirconium',        
        mass: '91.224',        
        group: ['transition'],        
        position: 178
    }

    static elementNb = {
        atomicnumber: "41",
        symbol: "Nb",
        name_de: 'Niob',
        name_en: 'Niobium',        
        mass: '92.906',        
        group: ['transition'],
        position: 179
    }


    static elementMo = {
        atomicnumber: "42",
        symbol: "Mo",
        name_de: 'Molybdän', 
        name_en: 'Molybdenum',       
        mass: '95.95',        
        group: ['transition'],        
        position: 180
    }

    static elementTc = {
        atomicnumber: "43",
        symbol: "Tc",
        name_de: 'Technetium',
        name_en: 'Technetium',        
        mass: '[97]',        
        group: ['transition'],        
        position: 181
    }

    static elementRu = {
        atomicnumber: "44",
        symbol: "Ru",
        name_de: 'Ruthenium',
        name_en: 'Ruthenium',        
        mass: '101.07',        
        group: ['transition'],
        position: 182
    }

    static elementRh = {
        atomicnumber: "45",
        symbol: "Rh",
        name_de: 'Rhodium',
        name_en: 'Rhodium',        
        mass: '102.91',        
        group: ['transition'],
        position: 183
    }

    static elementPd = {
        atomicnumber: "46",
        symbol: "Pd",
        name_de: 'Palladium',
        name_en: 'Palladium',       
        mass: '106.42',        
        group: ['transition'],
        position: 184
    }

    static elementAg = {
        atomicnumber: "47",
        symbol: "Ag",
        name_de: 'Silber',
        name_en: 'Silver',        
        mass: '107.87',        
        group: ['transition'],
        position: 185
    }


    static elementCd = {
        atomicnumber: "48",
        symbol: "Cd",
        name_de: 'Cadmium', 
        name_en: 'Cadmium',       
        mass: '112.41',        
        group: ['transition'],

        position: 186
    }

    static elementIn = {
        atomicnumber: "49",
        symbol: "In",
        name_de: 'Indium', 
        name_en: 'Indium',       
        mass: '114.82',        
        group: ['triel'],
        position: 187
    }

    static elementSn = {
        atomicnumber: "50",
        symbol: "Sn",
        name_de: 'Zinn',   
        name_en: 'Tin',     
        mass: '118.71',        
        group: ['tetrel'],
        position: 188
    }

    static elementSb = {
        atomicnumber: "51",
        symbol: "Sb",
        name_de: 'Antimon', 
        name_en: 'Antimony',       
        mass: '121.76',        
        group: ['pentel'],
        position: 189
    }

    static elementTe = {
        atomicnumber: "52",
        symbol: "Te",
        name_de: 'Tellur', 
        name_en: 'Tellurium',      
        mass: '127.60',        
        group: ['chalkogen'],
        position: 190
    }

    static elementI = {
        atomicnumber: "53",
        symbol: "I",
        name_de: 'Iod',
        name_en: 'Iodine',        
        mass: '126.90',        
        group: ['halogen'],
        position: 191
    }

    static elementXe = {
        atomicnumber: "54",
        symbol: "Xe",
        name_de: 'Xenon', 
        name_en: 'Xenon',       
        mass: '131.29',        
        group: ['noble'],
        position: 192
    }

    static elementCs = {
        atomicnumber: "55",
        symbol: "Cs",
        name_de: 'Caesium', 
        name_en: 'Caesium',       
        mass: '132.91',        
        group: ['alkaline'],
        position: 193
    }

    static elementBa = {
        atomicnumber: "56",
        symbol: "Ba",
        name_de: 'Barium', 
        name_en: 'Barium',       
        mass: '137.33',        
        group: ['alkalineearth'],
        position: 194
    }

    static elementLa = {
        atomicnumber: "57",
        symbol: "La",
        name_de: 'Lanthan', 
        name_en: 'Lanthanum',       
        mass: '138.91',        
        group: ['transition','lanthanoide','laac'],
        position: 195
    }

    static elementCe = {
        atomicnumber: "58",
        symbol: "Ce",
        name_de: 'Cer',   
        name_en: 'Cerium',     
        mass: '140.12',        
        group: ['transition','lanthanoide','laac'],
        position: 196
    }

    static elementPr = {
        atomicnumber: "59",
        symbol: "Pr",
        name_de: 'Praseodym',  
        name_en: 'Praseodymium',      
        mass: '140.91',        
        group: ['transition','lanthanoide','laac'],
        position: 197
    }

    static elementNd = {
        atomicnumber: "60",
        symbol: "Nd",
        name_de: 'Neodym',   
        name_en: 'Neodymium',     
        mass: '144.24',        
        group: ['transition','lanthanoide','laac'],
        position: 198
    }

    static elementPm = {
        atomicnumber: "61",
        symbol: "Pm",
        name_de: 'Promethium', 
        name_en: 'Promethium',       
        mass: '[145]',        
        group: ['transition','lanthanoide','laac'],
        position: 199
    }

    static elementSm = {
        atomicnumber: "62",
        symbol: "Sm",
        name_de: 'Samarium', 
        name_en: 'Samarium',       
        mass: '150.36',        
        group: ['transition','lanthanoide','laac'],
        position: 200
    }

    static elementEu = {
        atomicnumber: "63",
        symbol: "Eu",
        name_de: 'Europium',  
        name_en: 'Europium',      
        mass: '151.96',        
        group: ['transition','lanthanoide','laac'],
        position: 201
    }

    static elementGd = {
        atomicnumber: "64",
        symbol: "Gd",
        name_de: 'Gadolinium', 
        name_en: 'Gadolinium',      
        mass: '157.25',        
        group: ['transition','lanthanoide','laac'],
        position: 202
    }

    static elementTb = {
        atomicnumber: "65",
        symbol: "Tb",
        name_de: 'Terbium',   
        name_en: 'Terbium',     
        mass: '158.93',        
        group: ['transition','lanthanoide','laac'],
        position: 203
    }

    static elementDy = {
        atomicnumber: "66",
        symbol: "Dy",
        name_de: 'Dysprosium', 
        name_ene: 'Dysprosium',        
        mass: '162.50',        
        group: ['transition','lanthanoide','laac'],
        position: 204
    }

    static elementHo = {
        atomicnumber: "67",
        symbol: "Ho",
        name_de: 'Holmium', 
        name_en: 'Holmium',       
        mass: '164.93',        
        group: ['transition','lanthanoide','laac'],
        position: 205
    }

    static elementEr = {
        atomicnumber: "68",
        symbol: "Er",
        name_de: 'Erbium',  
        name_en: 'Erbium',        
        mass: '167.26',        
        group: ['transition','lanthanoide','laac'],
        position: 206
    }

    static elementTm = {
        atomicnumber: "69",
        symbol: "Tm",
        name_de: 'Thulium',    
        name_en: 'Thulium',        
        mass: '168.93',        
        group: ['transition','lanthanoide','laac'],
        position: 207
    }

    static elementYb = {
        atomicnumber: "70",
        symbol: "Yb",
        name_de: 'Ytterbium',  
        name_en: 'Ytterbium',        
        mass: '173.05',        
        group: ['transition','lanthanoide','laac'],
        position: 208
    }

    static elementLu = {
        atomicnumber: "71",
        symbol: "Lu",
        name_de: 'Lutetium', 
        name_en: 'Lutetium',        
        mass: '174.97',        
        group: ['transition','lanthanoide','laac'],
        position: 209
    }


    static elementHf = {
        atomicnumber: "72",
        symbol: "Hf",
        name_de: 'Hafnium',    
        name_en: 'Hafnium',        
        mass: '178.49',        
        group: ['transition'],
        position: 210
    }

    static elementTa = {
        atomicnumber: "73",
        symbol: "Ta",
        name_de: 'Tantal',       
        name_en: 'Tantalum',        
        mass: '180.95',        
        group: ['transition'],
        position: 211
    }

    static elementW = {
        atomicnumber: "74",
        symbol: "W",
        name_de: 'Wolfram',    
        name_en: 'Tungsten',        
        mass: '183.84',        
        group: ['transition'],
        position: 212
    }

    static elementRe = {
        atomicnumber: "75",
        symbol: "Re",
        name_de: 'Rhenium', 
        name_en: 'Rhenium',       
        mass: '186.21',        
        group: ['transition'],
        position: 213
    }

    static elementOs = {
        atomicnumber: "76",
        symbol: "Os",
        name_de: 'Osmium',  
        name_en: 'Osmium',        
        mass: '190.23',        
        group: ['transition'],
        position: 214
    }

    static elementIr = {
        atomicnumber: "77",
        symbol: "Ir",
        name_de: 'Iridium', 
        name_en: 'Iridium',        
        mass: '192.22',        
        group: ['transition'],
        position: 215
    }

    static elementPt = {
        atomicnumber: "78",
        symbol: "Pt",
        name_de: 'Platin',  
        name_en: 'Platinum',        
        mass: '195.08',        
        group: ['transition'],
        position: 216
    }

    static elementAu = {
        atomicnumber: "79",
        symbol: "Au",
        name_de: 'Gold', 
        name_en: 'Gold',       
        mass: '196.97',        
        group: ['transition'],
        position: 217
    }

    static elementHg = {
        atomicnumber: "80",
        symbol: "Hg",
        name_de: 'Quecksilber', 
        name_en: 'Mercury',       
        mass: '200.59',        
        group: ['transition'],
        position: 218
    }

    static elementTl = {
        atomicnumber: "81",
        symbol: "Tl",
        name_de: 'Thallium', 
        name_en: 'Thallium',       
        mass: '204.38',        
        group: ['triel'],
        position: 219
    }

    static elementPb = {
        atomicnumber: "82",
        symbol: "Pb",
        name_de: 'Blei',  
        name_en: 'Lead',        
        mass: '207.2',        
        group: ['tetrel'],
        position: 220
    }

    static elementBi = {
        atomicnumber: "83",
        symbol: "Bi",
        name_de: 'Bismut',  
        name_en: 'Bismuth',        
        mass: '208.98',        
        group: ['pentel'],
        position: 221
    }

    static elementPo = {
        atomicnumber: "84",
        symbol: "Po",
        name_de: 'Polonium',  
        name_en: 'Polonium',           
        mass: '[209]',        
        group: ['pentel'],
        position: 222
    }

    static elementAt = {
        atomicnumber: "85",
        symbol: "At",
        name_de: 'Astat', 
        name_en: 'Astatine',       
        mass: '[210]',        
        group: ['halogen'],
        position: 223
    }

    static elementRn = {
        atomicnumber: "86",
        symbol: "Rn",
        name_de: 'Radon', 
        name_en: 'Radon',       
        mass: '[222]',        
        group: ['noble'],
        position: 224
    }

    static elementFr = {
        atomicnumber: "87",
        symbol: "Fr",
        name_de: 'Francium',  
        name_en: 'Francium',       
        mass: '[223]',        
        group: ['alkaline'],
        position: 225
    }

    
    static elementRa = {
        atomicnumber: "88",
        symbol: "Ra",
        name_de: 'Radium',  
        name_en: 'Radium',         
        mass: '[226]',        
        group: ['alkalineearth'],
        position: 226
    }


    static elementAc = {
        atomicnumber: "89",
        symbol: "Ac",
        name_de: 'Actinium', 
        name_en: 'Actinium',        
        mass: '[227]',        
        group: ['transition','laac'],
        position: 227
    }

    static elementTh = {
        atomicnumber: "90",
        symbol: "Th",
        name_de: 'Thorium', 
        name_en: 'Thorium',       
        mass: '232.04',        
        group: ['transition','actinoid','laac'],
        position: 228
    }

    static elementPa = {
        atomicnumber: "91",
        symbol: "Pa",
        name_de: 'Protactinium',  
        name_en: 'Protactinium',        
        mass: '231.04',        
        group: ['transition','actinoid','laac'],
        position: 229
    }

    static elementU = {
        atomicnumber: "92",
        symbol: "U",
        name_de: 'Uran',
        name_en: 'Uranium',        
        mass: '238.03',        
        group: ['transition','actinoid','laac'],
        position: 230
    }

    static elementNp = {
        atomicnumber: "93",
        symbol: "Np",
        name_de: 'Neptunium',   
        name_en: 'Neptunium',        
        mass: '[237]',        
        group: ['transition','actinoid','laac'],
        position: 231
    }

    static elementPu = {
        atomicnumber: "94",
        symbol: "Pu",
        name_de: 'Plutonium',  
        name_en: 'Plutonium',        
        mass: '[244]',        
        group: ['transition','actinoid','laac'],
        position: 232
    }

    static elementAm = {
        atomicnumber: "95",
        symbol: "Am",
        name_de: 'Americium',   
        name_en: 'Americium',        
        mass: '[243]',        
        group: ['transition','actinoid','laac'],
        position: 233
    }

    static elementCm = {
        atomicnumber: "96",
        symbol: "Cm",
        name_de: 'Curium',   
        name_en: 'Curium',        
        mass: '[247]',        
        group: ['transition','actinoid','laac'],
        position: 234
    }

    static elementBk = {
        atomicnumber: "97",
        symbol: "Bk",
        name_de: 'Berkelium', 
        name_en: 'Berkelium',       
        mass: '[247]',        
        group: ['transition','actinoid','laac'],
        position: 235
    }


    static elementCf = {
        atomicnumber: "98",
        symbol: "Cf",
        name_de: 'Californium', 
        name_en: 'Californium',        
        mass: '[251]',        
        group: ['transition','actinoid','laac'],
        position: 236
    }

    static elementEs = {
        atomicnumber: "99",
        symbol: "Es",
        name_de: 'Einsteinium',    
        name_en: 'Einsteinium',        
        mass: '[252]',        
        group: ['transition','actinoid','laac'],
        position: 237
    }

    static elementFm = {
        atomicnumber: "100",
        symbol: "Fm",
        name_de: 'Fermium', 
        name_en: 'Fermium',        
        mass: '[257]',        
        group: ['transition','actinoid','laac'],
        position: 238
    }

    static elementMd = {
        atomicnumber: "101",
        symbol: "Md",
        name_de: 'Mendelevium', 
        name_en: 'Mendelevium',        
        mass: '[258]',        
        group: ['transition','actinoid','laac'],
        position: 239
    }

    static elementNo = {
        atomicnumber: "102",
        symbol: "No",
        name_de: 'Nobelium',   
        name_en: 'Nobelium',        
        mass: '[259]',        
        group: ['transition','actinoid','laac'],
        position: 240
    }

    static elementLr = {
        atomicnumber: "103",
        symbol: "Lr",
        name_de: 'Lawren­cium', 
        name_en: 'Lawren­cium',        
        mass: '[262]',        
        group: ['transition','actinoid','laac'],
        position: 241
    }


    static elementRf = {
        atomicnumber: "104",
        symbol: "Rf",
        name_de: 'Ruther­fordium', 
        name_en: 'Ruther­fordium',       
        mass: '[267]',        
        group: ['transition'],
        position: 242
    }

    static elementDb = {
        atomicnumber: "105",
        symbol: "Db",
        name_de: 'Dubnium', 
        name_en: 'Dubnium',        
        mass: '[268]',        
        group: ['transition'],
        position: 243
    }

    static elementSg = {
        atomicnumber: "106",
        symbol: "Sg",
        name_de: 'Seaborgium',
        name_en: 'Seaborgium',        
        mass: '[269]',        
        group: ['transition'],
        position: 244
    }


    static elementBh = {
        atomicnumber: "107",
        symbol: "Bh",
        name_de: 'Bohrium',
        name_en: 'Bohrium',        
        mass: '[270]',        
        group: ['transition'],
        position: 245
    }

    static elementHs = {
        atomicnumber: "108",
        symbol: "Hs",
        name_de: 'Hassium',
        name_en: 'Hassium',        
        mass: '[269]',        
        group: ['transition'],
        position: 246
    }

    static elementMt = {
        atomicnumber: "109",
        symbol: "Mt",
        name_de: 'Meitnerium', 
        name_en: 'Meitnerium',        
        mass: '[277]',        
        group: ['transition'],
        position: 247
    }

    static elementDs = {
        atomicnumber: "110",
        symbol: "Ds",
        name_de: 'Darmstadtium',   
        name_en: 'Darmstadtium',        
        mass: '[281]',        
        group: ['transition'],
        position: 248
    }

    static elementRg = {
        atomicnumber: "111",
        symbol: "Rg",
        name_de: 'Roentgenium',   
        name_en: 'Roentgenium',         
        mass: '[282]',        
        group: ['transition'],
        position: 249
    }

    static elementCn = {
        atomicnumber: "112",
        symbol: "Cn",
        name_de: 'Copernicium',  
        name_en: 'Copernicium',        
        mass: '[285]',        
        group: ['transition'],
        position: 250
    }

    static elementNh = {
        atomicnumber: "113",
        symbol: "Nh",
        name_de: 'Nihonium', 
        name_en: 'Nihonium',       
        mass: '[286]',        
        group: ['triel'],
        position: 251
    }

    static elementFl = {
        atomicnumber: "114",
        symbol: "Fl",
        name_de: 'Flerovium',  
        name_en: 'Flerovium',      
        mass: '[290]',        
        group: ['tetrel'],
        position: 252
    }

    static elementMc = {
        atomicnumber: "115",
        symbol: "Mc",
        name_de: 'Moscovium',
        name_en: 'Moscovium',        
        mass: '[290]',        
        group: ['pentel'],
        position: 253
    }

    static elementLv = {
        atomicnumber: "116",
        symbol: "Lv",
        name_de: 'Livermorium',  
        name_en: 'Livermorium',        
        mass: '[293]',        
        group: ['chalkogen'],
        position: 254
    }


    static elementTs = {
        atomicnumber: "117",
        symbol: "Ts",
        name_de: 'Tenness',   
        name_en: 'Tennessine',        
        mass: '[294]',        
        group: ['halogen'],
        position: 255
    }


    static elementOg = {
        atomicnumber: "118",
        symbol: "Og",
        name_de: 'Oganesson',    
        name_en: 'Oganesson',        
        mass: '[294]',        
        group: ['noble'],
        position: 256
    }



    static elements = [edMLplugin_PSE.elementH,edMLplugin_PSE.elementHe,edMLplugin_PSE.elementLi,edMLplugin_PSE.elementBe,edMLplugin_PSE.elementB,edMLplugin_PSE.elementC,edMLplugin_PSE.elementN,edMLplugin_PSE.elementO,edMLplugin_PSE.elementF,edMLplugin_PSE.elementNe,edMLplugin_PSE.elementNa,edMLplugin_PSE.elementMg,edMLplugin_PSE.elementAl,edMLplugin_PSE.elementSi,edMLplugin_PSE.elementP,edMLplugin_PSE.elementS,edMLplugin_PSE.elementCl,edMLplugin_PSE.elementAr,edMLplugin_PSE.elementK,edMLplugin_PSE.elementCa,edMLplugin_PSE.elementSc,edMLplugin_PSE.elementTi,edMLplugin_PSE.elementV,edMLplugin_PSE.elementCr,edMLplugin_PSE.elementMn ,edMLplugin_PSE.elementFe,edMLplugin_PSE.elementCo,edMLplugin_PSE.elementNi,edMLplugin_PSE.elementCu,edMLplugin_PSE.elementZn,edMLplugin_PSE.elementGa,edMLplugin_PSE.elementGe,edMLplugin_PSE.elementAs,edMLplugin_PSE.elementSe,edMLplugin_PSE.elementBr,edMLplugin_PSE.elementKr,edMLplugin_PSE.elementRb,edMLplugin_PSE.elementSr,edMLplugin_PSE.elementY,edMLplugin_PSE.elementZr,edMLplugin_PSE.elementNb,edMLplugin_PSE.elementMo,edMLplugin_PSE.elementTc,edMLplugin_PSE.elementRu,edMLplugin_PSE.elementRh,edMLplugin_PSE.elementPd,edMLplugin_PSE.elementAg,edMLplugin_PSE.elementCd,edMLplugin_PSE.elementIn,edMLplugin_PSE.elementSn,edMLplugin_PSE.elementSb,edMLplugin_PSE.elementTe,edMLplugin_PSE.elementI,edMLplugin_PSE.elementXe,edMLplugin_PSE.elementCs,edMLplugin_PSE.elementBa,edMLplugin_PSE.elementLa,edMLplugin_PSE.elementCe,edMLplugin_PSE.elementPr,edMLplugin_PSE.elementNd,edMLplugin_PSE.elementPm,edMLplugin_PSE.elementSm,edMLplugin_PSE.elementEu,edMLplugin_PSE.elementGd,edMLplugin_PSE.elementTb,edMLplugin_PSE.elementDy,edMLplugin_PSE.elementHo,edMLplugin_PSE.elementEr,edMLplugin_PSE.elementTm,edMLplugin_PSE.elementYb,edMLplugin_PSE.elementLu,edMLplugin_PSE.elementHf,edMLplugin_PSE.elementTa,edMLplugin_PSE.elementW,edMLplugin_PSE.elementRe,edMLplugin_PSE.elementOs,edMLplugin_PSE.elementIr,edMLplugin_PSE.elementPt,edMLplugin_PSE.elementAu,edMLplugin_PSE.elementHg,edMLplugin_PSE.elementTl,edMLplugin_PSE.elementPb,edMLplugin_PSE.elementBi,edMLplugin_PSE.elementPo,edMLplugin_PSE.elementAt,edMLplugin_PSE.elementRn,edMLplugin_PSE.elementFr,edMLplugin_PSE.elementRa,edMLplugin_PSE.elementAc,edMLplugin_PSE.elementTh,edMLplugin_PSE.elementPa,edMLplugin_PSE.elementU,edMLplugin_PSE.elementNp,edMLplugin_PSE.elementPu,edMLplugin_PSE.elementAm,edMLplugin_PSE.elementCm,edMLplugin_PSE.elementBk,edMLplugin_PSE.elementCf,edMLplugin_PSE.elementEs,edMLplugin_PSE.elementFm,edMLplugin_PSE.elementMd,edMLplugin_PSE.elementNo,edMLplugin_PSE.elementLr,edMLplugin_PSE.elementRf,edMLplugin_PSE.elementDb,edMLplugin_PSE.elementSg,edMLplugin_PSE.elementBh,edMLplugin_PSE.elementHs,edMLplugin_PSE.elementMt,edMLplugin_PSE.elementDs,edMLplugin_PSE.elementRg,edMLplugin_PSE.elementCn,edMLplugin_PSE.elementNh,edMLplugin_PSE.elementFl,edMLplugin_PSE.elementMc,edMLplugin_PSE.elementLv,edMLplugin_PSE.elementTs,edMLplugin_PSE.elementOg];


   
    




    constructor(){
        super();
        this.pse = document.createElement('div');
        this.pse.classList.add('edmlplugin-pse-table');
        this.fontsize = 0.55;
        this.pse.style.fontSize = this.fontsize + "em";   
        edMLplugin_PSE.setNameButtons();                
    }



    connectedCallback(){        
        this.createToolbar();
        this.createTable();    
        this.createLaAcTable();
        this.createSource();
        this.querySelector('.edmlplugin-pse-expand').click();
        this.querySelectorAll('.edmlplugin-pse-elementblock[element]').forEach(function(item){
            item.addEventListener('click',this.onElementBlockClick);
        }.bind(this));
    }

    createSource(){
        var src = document.createElement('div');
        src.classList.add('edmlplugin-pse-source');
        src.innerText = edMLplugin_PSE.source;
        this.append(src);
    }

    createToolbar(){
        var toolbardiv = document.createElement('div');
        toolbardiv.classList.add('edmlplugin-pse-toolbar');

        var buttonsdiv = document.createElement('div');
        buttonsdiv.classList.add('edmlplugin-pse-buttons');

        //zoom buttons
        var buttonZoomIn = document.createElement('div');
        buttonZoomIn.classList.add('edmlplugin-pse-zoomin');
        buttonZoomIn.classList.add('edmlplugin-pse-btn');
        buttonZoomIn.addEventListener('click',function(){
            this.fontsize += 0.2;
            this.pse.style.fontSize = this.fontsize + "em";
        }.bind(this));
        buttonsdiv.append(buttonZoomIn);

        var buttonZoomOut = document.createElement('div');
        buttonZoomOut.classList.add('edmlplugin-pse-zoomout');
        buttonZoomOut.classList.add('edmlplugin-pse-btn');
        buttonZoomOut.addEventListener('click',function(){                
            if(this.fontsize - 0.2 > 0) this.fontsize -= 0.2;
            this.pse.style.fontSize = this.fontsize + "em";
        }.bind(this));
        buttonsdiv.append(buttonZoomOut);

        //expand button
        var buttonExpand = document.createElement('div');
        buttonExpand.classList.add('edmlplugin-pse-expand');
        buttonExpand.classList.add('edmlplugin-pse-btn');
        buttonExpand.classList.add('expanded');        
        buttonExpand.addEventListener('click',function(){    
            this.querySelector('.edmlplugin-pse-expand').classList.toggle('expanded');
            if(this.querySelector('.edmlplugin-pse-expand').classList.contains('expanded')){
                this.querySelectorAll('.edmlplugin-pse-laac.hide').forEach(function(item){
                    item.classList.remove('hide');
                });
                this.pse.classList.remove('laac-hide');
                this.querySelector('.edmlplugin-pse-laacblock').classList.remove('show');
                this.pse.querySelector('.edmlplugin-pse-elementblock[element="La"]').classList.remove('hideinner');
                this.pse.querySelector('.edmlplugin-pse-elementblock[element="Ac"]').classList.remove('hideinner');
                this.querySelector('.edmlplugin-pse-ac').classList.remove('hideinner');
            } else {
                this.querySelectorAll('.edmlplugin-pse-laac').forEach(function(item){
                    item.classList.add('hide');
                });
                this.pse.classList.add('laac-hide');
                this.querySelector('.edmlplugin-pse-laacblock').classList.add('show');
                this.pse.querySelector('.edmlplugin-pse-elementblock[element="La"]').classList.add('hideinner');
                this.pse.querySelector('.edmlplugin-pse-elementblock[element="Ac"]').classList.add('hideinner');
            }
        }.bind(this));
        buttonsdiv.append(buttonExpand);

        //button group: pse-groups
        var btngroup01 = document.createElement('div');
        btngroup01.classList.add('edmlplugin-pse-btngroup01');
            //alakline
        var buttonAlkaline = document.createElement('button');
        buttonAlkaline.classList.add('edmlplugin-pse-btngroup01-button');
        buttonAlkaline.innerText = edMLplugin_PSE.alkaline;
        buttonAlkaline.setAttribute('elements','alkaline');
        buttonAlkaline.addEventListener('click',this.onGroup01.bind(this));
        btngroup01.append(buttonAlkaline);
           

            // halogen
        var buttonHalogen = document.createElement('button');
        buttonHalogen.classList.add('edmlplugin-pse-btngroup01-button');
        buttonHalogen.innerText = edMLplugin_PSE.halogen;
        buttonHalogen.setAttribute('elements','halogen');
        buttonHalogen.addEventListener('click',this.onGroup01.bind(this));
        btngroup01.append(buttonHalogen);

            // transition metals
        var buttonTransition = document.createElement('button');
        buttonTransition.classList.add('edmlplugin-pse-btngroup01-button');
        buttonTransition.innerText = edMLplugin_PSE.transition;
        buttonTransition.setAttribute('elements','transition');
        buttonTransition.addEventListener('click',this.onGroup01.bind(this));
        btngroup01.append(buttonTransition);

           

         //alkalineearth
         var buttonAlkalineEarth = document.createElement('button');
         buttonAlkalineEarth.classList.add('edmlplugin-pse-btngroup01-button');
         buttonAlkalineEarth.innerText = edMLplugin_PSE.alkalineearth;
         buttonAlkalineEarth.setAttribute('elements','alkalineearth');
         buttonAlkalineEarth.addEventListener('click',this.onGroup01.bind(this));
         btngroup01.append(buttonAlkalineEarth);

             

            //noble
        var buttonNoble = document.createElement('button');
        buttonNoble.classList.add('edmlplugin-pse-btngroup01-button');
        buttonNoble.innerText = edMLplugin_PSE.noble;
        buttonNoble.setAttribute('elements','noble');
        buttonNoble.addEventListener('click',this.onGroup01.bind(this));
        btngroup01.append(buttonNoble);

            //lanthanoides & actinoides
        var buttonLaac = document.createElement('button');
        buttonLaac.classList.add('edmlplugin-pse-btngroup01-button');
        buttonLaac.innerText = edMLplugin_PSE.laac;
        buttonLaac.setAttribute('elements','laac');
        buttonLaac.addEventListener('click',this.onGroup01.bind(this));
        btngroup01.append(buttonLaac);



        toolbardiv.append(buttonsdiv);
        toolbardiv.append(btngroup01)

        this.append(toolbardiv);

    }


    createLaAcTable(){
        var laacdiv = document.createElement('div');
        laacdiv.classList.add('edmlplugin-pse-laacblock');
        var arr = ['La','Ce','Pr','Nd','Pm','Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Yb','Lu','Ac','Th','Pa','U','Np','Pu','Am','Cm','Bk','Cf','Es','Fm','Md','No','Lr'];
        var div;
        for(var i = 0; i < arr.length; i++){            
            div = this.pse.querySelector('.edmlplugin-pse-elementblock[element="'+arr[i]+'"]').cloneNode(true);
            div.classList.remove('hide');  
            if(arr[i] == 'Lu' || arr[i] == "Lr") div.classList.add('edmlplugin-pse-rightline');          
            if(i > 15) div.classList.add('edmlplugin-pse-bottomline');
            laacdiv.append(div);
        }
        this.pse.append(laacdiv);
      
    }


    createTable(){           
        var leftline = [34,67,99,132,164];
        var rightline = [64,96,128,160,192,224,256];
        var numbers = [1,34,99,114,115,116,117,118,119,120,121,122,59,60,61,62,63,32];
        var div;
        var elementsymbol;
        var elementmass;
        var elementatomicnumber;
        var elementname;
        var container = document.createElement('div');
        var elements = edMLplugin_PSE.elements;
        var activename = "name_" + edMLplugin_PSE.activelang;
        container.classList.add('edmlplugin-pse-psecontainer');

        //create elementblocks
        for(var i=0; i < 256; i++){
            div = document.createElement('div');
            div.classList.add('edmlplugin-pse-elementblock');
            div.classList.add('edmlplugin-pse-none');
            if((i > 2 && i < 17) || (i > 34 && i < 49) || (i > 66 && i < 81) || (i > 98 && i < 113) || (i > 130 && i < 145) || (i > 162 && i < 177) || (i > 194 && i < 209) || (i > 226 && i < 241)) {
                div.classList.add('edmlplugin-pse-laac'); 
            }
            this.pse.append(div);      
        }

        //insert numbers
        let obj;
        for(var i=0; i < numbers.length; i++){
            obj = this.pse.querySelector('.edmlplugin-pse-elementblock:nth-child('+numbers[i]+')');
            obj.classList.add('edmlplugin-pse-numbering');            
            elementsymbol = document.createElement('div');
            elementsymbol.classList.add('edmlplugin-pse-elementsymbol');       
            elementsymbol.innerText = (i+1);
            obj.append(elementsymbol);

        }

        
        //insert elements
        let mass;
        for(var i = 0; i < edMLplugin_PSE.elements.length; i++){
            obj = this.pse.querySelector('.edmlplugin-pse-elementblock:nth-child('+elements[i].position+')');
            elementsymbol = document.createElement('div');
            elementsymbol.classList.add('edmlplugin-pse-elementsymbol');            
            elementsymbol.innerText = elements[i].symbol;

            //element mass
            elementmass = document.createElement('div');
            elementmass.classList.add('edmlplugin-pse-elementmass');
            mass = elements[i].mass;
            if(edMLPlayer_Config.get("course.defaultlang") == "de") {
                mass = mass.replaceAll('.',',');
            }
            elementmass.innerText = mass;

            //element atomic number
            elementatomicnumber = document.createElement('div');
            elementatomicnumber.classList.add('edmlplugin-pse-elementatomicnumber');
            elementatomicnumber.innerText = elements[i].atomicnumber;

            //element name
            elementname = document.createElement('div');
            elementname.classList.add('edmlplugin-pse-elementname');

            elementname.innerText = elements[i][activename];

            obj.append(elementatomicnumber);
            obj.append(elementsymbol);
            obj.append(elementname);
            obj.append(elementmass);

            if(i > 85) obj.classList.add('edmlplugin-pse-bottomline');

            obj.setAttribute('element',elements[i].symbol);
            obj.setAttribute('nb',elements[i].atomicnumber);
            obj.classList.remove('edmlplugin-pse-none');
        }

        //create additional lines
        for(var i = 0; i < leftline.length; i++){
            this.pse.querySelector('.edmlplugin-pse-elementblock:nth-child('+leftline[i]+')').classList.add('edmlplugin-pse-leftline');
        }

        for(var i = 0; i < rightline.length; i++){
            this.pse.querySelector('.edmlplugin-pse-elementblock:nth-child('+rightline[i]+')').classList.add('edmlplugin-pse-rightline');
        }

        

        container.append(this.pse);
        this.append(container);
    }

    onGroup01(evt){
        //element group event
        var btn = evt.target;
        var group = btn.getAttribute('elements');     

        if(btn.classList.contains('clicked')){
            this.pse.querySelectorAll('.edmlplugin-pse-elementblock.edmlplugin-pse-highlight-'+group).forEach(function(item){
                item.classList.remove('edmlplugin-pse-highlight-'+group);
            });
        } else {
                     
            for(var i = 0; i < edMLplugin_PSE.elements.length; i++){
                if(edMLplugin_PSE.elements[i].group != null && edMLplugin_PSE.elements[i].group.indexOf(group) > - 1){
                    this.pse.querySelectorAll('.edmlplugin-pse-elementblock[element="'+edMLplugin_PSE.elements[i].symbol+'"]').forEach(function(item){                        
                        item.classList.add('edmlplugin-pse-highlight-'+group)
                    });
                }
            }
        }

        btn.classList.toggle('clicked');
    }

    onElementBlockClick(evt){
        var dlg = new edML_Dialog();
        var element = edMLplugin_PSE.elements[parseInt(this.getAttribute('nb'))-1];
        var activename = "name_" + edMLplugin_PSE.activelang;
        var mass;
        if(element != null){
            dlg.setTitle(element[activename]);
            var body = "";
            body += '<p><span class="edmlplugin-pse-dlglabel">'+edMLplugin_PSE.dlgName+':</span>';
            body += '<span class="edmlplugin-pse-dlgvalue">'+element[activename]+'</span></p>';

            body += '<p><span class="edmlplugin-pse-dlglabel">'+edMLplugin_PSE.dlgAtomicNumber+':</span>';
            body += '<span class="edmlplugin-pse-dlgvalue">'+element.atomicnumber+'</span></p>';

            body += '<p><span class="edmlplugin-pse-dlglabel">'+edMLplugin_PSE.dlgAtomicMass+':</span>';
            mass = element.mass;
            if(edMLPlayer_Config.get("course.defaultlang") == "de") {
                mass = mass.replaceAll('.',',');
            }
            if(mass.indexOf('[') > -1){
                body += '<span class="edmlplugin-pse-dlgvalue">'+mass.replace('[','').replace(']','')+' ('+edMLplugin_PSE.nomassdata+')</span></p>';
                
            } else {
                body += '<span class="edmlplugin-pse-dlgvalue">'+mass+' u</span></p>';
            }

            /*body += '<p><span class="edmlplugin-pse-dlglabel">'+edMLplugin_PSE.dlgAggregate+':</span>';
            var aggregate = "-";
            if(element.aggregate == "g") aggregate = edMLplugin_PSE.dlgAggregateG;
            if(element.aggregate == "l") aggregate = edMLplugin_PSE.dlgAggregateL;
            if(element.aggregate == "s") aggregate = edMLplugin_PSE.dlgAggregateS;
            body += '<span class="edmlplugin-pse-dlgvalue">'+aggregate+'</span></p>';*/
            


            dlg.setBody(body);
            dlg.hideFooter();
            dlg.show();
        }
        
    }


}

customElements.define("edmlplugin-pse", edMLplugin_PSE);




document.addEventListener('edmlevent-coursestarted', function(evt){
    
    var link = document.createElement( "link" );
    link.href = edMLPlayer_Config.get("plugins.pse.path")+"/pse_edmlplugin.css";
    link.type = "text/css";
    link.rel = "stylesheet";
    document.getElementsByTagName( "head" )[0].appendChild( link );

    evt.edmlplayernode.querySelectorAll('edml-objectblock[plugin="pse"]').forEach(function(objblock){        
        objblock.append(new edMLplugin_PSE());
        objblock.style.display = "block";
    });
    
        
        
})




